import{s as qs,n as Ps,o as Ks}from"../chunks/scheduler.eb244325.js";import{S as Ds,i as Os,e as i,s as n,c as p,h as el,a as o,d as s,b as a,f as Ys,g as c,j as r,k as Fs,l as tl,m as l,n as M,t as m,o as y,p as d}from"../chunks/index.3fe63ad3.js";import{C as sl}from"../chunks/CopyLLMTxtMenu.08242e11.js";import{C as T}from"../chunks/CodeBlock.91baa5b4.js";import{H as u,E as ll}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.234c3f85.js";function nl(ts){let J,He,Ge,ke,w,xe,U,Ae,j,ss=`In this tutorial, you’ll learn how to implement your own Robot Processor.
It begins by exploring the need for a custom processor, then uses the <code>NormalizerProcessorStep</code> as the running example to explain how to implement, configure, and serialize a processor. Finally, it lists all helper processors that ship with LeRobot.`,Xe,f,Se,h,ls="In most cases, when reading raw data from sensors or when models output actions, you need to process this data to make it compatible with your target system. For example, a common need is normalizing data ranges to make them suitable for neural networks.",We,I,ns="LeRobot’s <code>NormalizerProcessorStep</code> handles this crucial task:",Qe,b,Ve,C,as="Other common processing needs include:",Ee,g,is="<li><strong>Device placement</strong>: Moving tensors between CPU/GPU and converting data types</li> <li><strong>Format conversion</strong>: Transforming between different data structures</li> <li><strong>Batching</strong>: Adding/removing batch dimensions for model compatibility</li> <li><strong>Safety constraints</strong>: Applying limits to robot commands</li>",Le,v,Ye,Z,os="LeRobot provides a pipeline mechanism to implement sequences of processing steps for both input data and output actions, making it easy to compose these transformations in the right order for optimal performance.",Fe,_,qe,z,rs="We’ll use the <code>NormalizerProcessorStep</code> as our main example because it demonstrates essential processor patterns including state management, configuration serialization, and tensor handling that you’ll commonly need.",Pe,$,ps="Prepare the sequence of processing steps necessary for your problem. A processor step is a class that implements the following methods:",Ke,B,cs="<li><code>__call__</code>: implements the processing step for the input transition.</li> <li><code>get_config</code>: gets the configuration of the processor step.</li> <li><code>state_dict</code>: gets the state of the processor step.</li> <li><code>load_state_dict</code>: loads the state of the processor step.</li> <li><code>reset</code>: resets the state of the processor step.</li> <li><code>feature_contract</code>: displays the modification to the feature space during the processor step.</li>",De,N,Oe,G,Ms="The <code>__call__</code> method is the core of your processor step. It takes an <code>EnvTransition</code> and returns a modified <code>EnvTransition</code>. Here’s how the <code>NormalizerProcessorStep</code> works:",et,R,tt,H,ms="See the full implementation in <code>src/lerobot/processor/normalize_processor.py</code> for complete details.",st,k,ys="<strong>Key principles:</strong>",lt,x,ds="<li><strong>Always use <code>transition.copy()</code></strong> to avoid side effects</li> <li><strong>Handle both observations and actions</strong> consistently</li> <li><strong>Separate config from state</strong>: <code>get_config()</code> returns JSON-serializable params, <code>state_dict()</code> returns tensors</li> <li><strong>Convert stats to tensors</strong> in <code>__post_init__()</code> for efficient computation</li>",nt,A,at,X,us="Processors support serialization through three methods that separate configuration from tensor state. The <code>NormalizerProcessorStep</code> demonstrates this perfectly - it carries dataset statistics (tensors) in its state, and hyperparameters in its config:",it,S,ot,W,Js="<strong>Usage:</strong>",rt,Q,pt,V,ct,E,Ts="The <code>transform_features</code> method defines how your processor transforms feature names and shapes. This is crucial for policy configuration and debugging.",Mt,L,ws="For <code>NormalizerProcessorStep</code>, features are typically preserved unchanged since normalization doesn’t alter keys or shapes:",mt,Y,yt,F,Us="When your processor renames or reshapes data, implement this method to reflect the mapping for downstream components. For example, a simple rename processor:",dt,q,ut,P,js="<strong>Key principles:</strong>",Jt,K,fs="<li>Use <code>features.pop(old_key)</code> to remove and get the old feature</li> <li>Use <code>features[new_key] = old_feature</code> to add the renamed feature</li> <li>Always return the modified features dictionary</li> <li>Document transformations clearly in the docstring</li>",Tt,D,wt,O,hs="You can override step parameters at load-time using <code>overrides</code>. This is handy for non-serializable objects or site-specific settings. It works both in policy factories and with <code>DataProcessorPipeline.from_pretrained(...)</code>.",Ut,ee,Is="<strong>Foundational model adaptation</strong>: This is particularly useful when working with foundational pretrained policies where you rarely have access to the original training statistics. You can inject your own dataset statistics to adapt the normalizer to your specific robot or environment data.",jt,te,bs=`Example: during policy evaluation on the robot, override the device and rename map.
Use this to run a policy trained on CUDA on a CPU-only robot, or to remap camera keys when the robot uses different names than the dataset.`,ft,se,Cs="Direct usage with <code>from_pretrained</code>:",ht,le,It,ne,bt,ae,gs="Based on analysis of all LeRobot processor implementations, here are the key patterns and practices:",Ct,ie,gt,oe,vs="Always create copies of input data to avoid unintended side effects. Use <code>transition.copy()</code> and <code>observation.copy()</code> rather than modifying data in-place. This prevents your processor from accidentally affecting other components in the pipeline.",vt,re,Zs="Check for required data before processing and handle missing data gracefully. If your processor expects certain keys (like <code>&quot;pixels&quot;</code> for image processing), validate their presence first. For optional data, use safe access patterns like <code>transition.get()</code> and handle <code>None</code> values appropriately.",Zt,pe,_s="When data validation fails, provide clear, actionable error messages that help users understand what went wrong and how to fix it.",_t,ce,zt,Me,zs="LeRobot provides specialized base classes that reduce boilerplate code and ensure consistency. Use <code>ObservationProcessorStep</code> when you only need to modify observations, <code>ActionProcessorStep</code> for action-only processing, and <code>RobotActionProcessorStep</code> specifically for dictionary-based robot actions.",$t,me,$s="Only inherit directly from <code>ProcessorStep</code> when you need full control over the entire transition or when processing multiple transition components simultaneously. The specialized base classes handle the transition management for you and provide type safety.",Bt,ye,Nt,de,Bs="Register your processors with descriptive, namespaced names using <code>@ProcessorStepRegistry.register()</code>. Use organization prefixes like <code>&quot;robotics_lab/safety_clipper&quot;</code> or <code>&quot;acme_corp/vision_enhancer&quot;</code> to avoid naming conflicts. Avoid generic names like <code>&quot;processor&quot;</code> or <code>&quot;step&quot;</code> that could clash with other implementations.",Gt,ue,Ns="Good registration makes your processors discoverable and enables clean serialization/deserialization when saving and loading pipelines.",Rt,Je,Ht,Te,Gs="Distinguish between configuration parameters (JSON-serializable values) and internal state (tensors, buffers). Use dataclass fields with <code>init=False, repr=False</code> for internal state that shouldn’t appear in the constructor or string representation.",kt,we,Rs="Implement the <code>reset()</code> method to clear internal state between episodes. This is crucial for stateful processors that accumulate data over time, like moving averages or temporal filters.",xt,Ue,Hs="Remember that <code>get_config()</code> should only return JSON-serializable configuration, while <code>state_dict()</code> handles tensor state separately.",At,je,Xt,fe,ks="Validate input types and shapes before processing. Check tensor properties like <code>dtype</code> and dimensions to ensure compatibility with your algorithms. For robot actions, verify that required pose components or joint values are present and within expected ranges.",St,he,xs="Use early returns for edge cases where no processing is needed. Provide clear, descriptive error messages that include the expected vs. actual data types or shapes. This makes debugging much easier for users.",Wt,Ie,Qt,be,As="Design your processors to automatically adapt to the device and dtype of input tensors. Internal tensors (like normalization statistics) should match the input tensor’s device and dtype to ensure compatibility with multi-GPU training, mixed precision, and distributed setups.",Vt,Ce,Xs="Implement a <code>to()</code> method that moves your processor’s internal state to the specified device. Check device/dtype compatibility at runtime and automatically migrate internal state when needed. This pattern enables seamless operation across different hardware configurations without manual intervention.",Et,ge,Lt,ve,Ss="You now have all the tools to implement custom processors in LeRobot! The key steps are:",Yt,Ze,Ws="<li><strong>Define your processor</strong> as a dataclass with the required methods (<code>__call__</code>, <code>get_config</code>, <code>state_dict</code>, <code>load_state_dict</code>, <code>reset</code>, <code>transform_features</code>)</li> <li><strong>Register it</strong> using <code>@ProcessorStepRegistry.register(&quot;name&quot;)</code> for discoverability</li> <li><strong>Integrate it</strong> into a <code>DataProcessorPipeline</code> with other processing steps</li> <li><strong>Use base classes</strong> like <code>ObservationProcessorStep</code> when possible to reduce boilerplate</li> <li><strong>Implement device/dtype awareness</strong> to support multi-GPU and mixed precision setups</li>",Ft,_e,Qs="The processor system is designed to be modular and composable, allowing you to build complex data processing pipelines from simple, focused components. Whether you’re preprocessing sensor data for training or post-processing model outputs for robot execution, custom processors give you the flexibility to handle any data transformation your robotics application requires.",qt,ze,Vs="Key principles for robust processors:",Pt,$e,Es="<li><strong>Device/dtype adaptation</strong>: Internal tensors should match input tensors</li> <li><strong>Clear error messages</strong>: Help users understand what went wrong</li> <li><strong>Base class usage</strong>: Leverage specialized base classes to reduce boilerplate</li> <li><strong>Feature contracts</strong>: Declare data structure changes with <code>transform_features()</code></li>",Kt,Be,Ls="Start simple, test thoroughly, and ensure your processors work seamlessly across different hardware configurations!",Dt,Ne,Ot,Re,es;return w=new sl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),U=new u({props:{title:"Implement your own Robot Processor",local:"implement-your-own-robot-processor",headingTag:"h1"}}),f=new u({props:{title:"Why would you need a custom processor?",local:"why-would-you-need-a-custom-processor",headingTag:"h2"}}),b=new T({props:{code:"JTIzJTIwSW5wdXQlM0ElMjByYXclMjBqb2ludCUyMHBvc2l0aW9ucyUyMGluJTIwJTVCMCUyQyUyMDE4MCU1RCUyMGRlZ3JlZXMlMEFyYXdfYWN0aW9uJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjkwLjAlMkMlMjA0NS4wJTJDJTIwMTM1LjAlNUQpJTBBJTBBJTIzJTIwQWZ0ZXIlMjBwcm9jZXNzaW5nJTNBJTIwbm9ybWFsaXplZCUyMHRvJTIwJTVCLTElMkMlMjAxJTVEJTIwcmFuZ2UlMjBmb3IlMjBtb2RlbCUyMHRyYWluaW5nJTBBbm9ybWFsaXplciUyMCUzRCUyME5vcm1hbGl6ZXJQcm9jZXNzb3JTdGVwKGZlYXR1cmVzJTNEZmVhdHVyZXMlMkMlMjBub3JtX21hcCUzRG5vcm1fbWFwJTJDJTIwc3RhdHMlM0RkYXRhc2V0X3N0YXRzKSUwQW5vcm1hbGl6ZWRfcmVzdWx0JTIwJTNEJTIwbm9ybWFsaXplcih0cmFuc2l0aW9uKSUwQSUyMyUyMC4uLg==",highlighted:`<span class="hljs-comment"># Input: raw joint positions in [0, 180] degrees</span>
raw_action = torch.tensor([<span class="hljs-number">90.0</span>, <span class="hljs-number">45.0</span>, <span class="hljs-number">135.0</span>])

<span class="hljs-comment"># After processing: normalized to [-1, 1] range for model training</span>
normalizer = NormalizerProcessorStep(features=features, norm_map=norm_map, stats=dataset_stats)
normalized_result = normalizer(transition)
<span class="hljs-comment"># ...</span>`,wrap:!1}}),v=new T({props:{code:"JTIzJTIwRXhhbXBsZSUyMHBpcGVsaW5lJTIwY29tYmluaW5nJTIwbXVsdGlwbGUlMjBwcm9jZXNzb3JzJTBBcGlwZWxpbmUlMjAlM0QlMjBQb2xpY3lQcm9jZXNzb3JQaXBlbGluZSglNUIlMEElMjAlMjAlMjAlMjBSZW5hbWVPYnNlcnZhdGlvbnNQcm9jZXNzb3JTdGVwKHJlbmFtZV9tYXAlM0QlN0IlN0QpJTJDJTBBJTIwJTIwJTIwJTIwQWRkQmF0Y2hEaW1lbnNpb25Qcm9jZXNzb3JTdGVwKCklMkMlMEElMjAlMjAlMjAlMjBOb3JtYWxpemVyUHJvY2Vzc29yU3RlcChmZWF0dXJlcyUzRGZlYXR1cmVzJTJDJTIwc3RhdHMlM0RzdGF0cyklMkMlMEElMjAlMjAlMjAlMjBEZXZpY2VQcm9jZXNzb3JTdGVwKGRldmljZSUzRCUyMmN1ZGElMjIpJTJDJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTVEKQ==",highlighted:`<span class="hljs-comment"># Example pipeline combining multiple processors</span>
pipeline = PolicyProcessorPipeline([
    RenameObservationsProcessorStep(rename_map={}),
    AddBatchDimensionProcessorStep(),
    NormalizerProcessorStep(features=features, stats=stats),
    DeviceProcessorStep(device=<span class="hljs-string">&quot;cuda&quot;</span>),
    <span class="hljs-comment"># ...</span>
])`,wrap:!1}}),_=new u({props:{title:"How to implement your own processor?",local:"how-to-implement-your-own-processor",headingTag:"h2"}}),N=new u({props:{title:"Implement the __call__ method",local:"implement-the-call-method",headingTag:"h3"}}),R=new T({props:{code:"JTQwZGF0YWNsYXNzJTBBJTQwUHJvY2Vzc29yU3RlcFJlZ2lzdHJ5LnJlZ2lzdGVyKCUyMm5vcm1hbGl6ZXJfcHJvY2Vzc29yJTIyKSUwQWNsYXNzJTIwTm9ybWFsaXplclByb2Nlc3NvclN0ZXAoUHJvY2Vzc29yU3RlcCklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJOb3JtYWxpemUlMjBvYnNlcnZhdGlvbnMlMkZhY3Rpb25zJTIwdXNpbmclMjBkYXRhc2V0JTIwc3RhdGlzdGljcy4lMjIlMjIlMjIlMEElMEElMjAlMjAlMjAlMjBmZWF0dXJlcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBQb2xpY3lGZWF0dXJlJTVEJTBBJTIwJTIwJTIwJTIwbm9ybV9tYXAlM0ElMjBkaWN0JTVCRmVhdHVyZVR5cGUlMkMlMjBOb3JtYWxpemF0aW9uTW9kZSU1RCUwQSUyMCUyMCUyMCUyMHN0YXRzJTNBJTIwZGljdCU1QnN0ciUyQyUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlNUQlMjAlN0MlMjBOb25lJTIwJTNEJTIwTm9uZSUwQSUyMCUyMCUyMCUyMGVwcyUzQSUyMGZsb2F0JTIwJTNEJTIwMWUtOCUwQSUyMCUyMCUyMCUyMF90ZW5zb3Jfc3RhdHMlM0ElMjBkaWN0JTIwJTNEJTIwZmllbGQoZGVmYXVsdF9mYWN0b3J5JTNEZGljdCUyQyUyMGluaXQlM0RGYWxzZSUyQyUyMHJlcHIlM0RGYWxzZSklMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX3Bvc3RfaW5pdF9fKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyQ29udmVydCUyMHN0YXRzJTIwdG8lMjB0ZW5zb3JzJTIwZm9yJTIwZWZmaWNpZW50JTIwY29tcHV0YXRpb24uJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5zdGF0cyUyMCUzRCUyMHNlbGYuc3RhdHMlMjBvciUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuX3RlbnNvcl9zdGF0cyUyMCUzRCUyMHRvX3RlbnNvcihzZWxmLnN0YXRzJTJDJTIwZGV2aWNlJTNEc2VsZi5kZXZpY2UlMkMlMjBkdHlwZSUzRHRvcmNoLmZsb2F0MzIpJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUyMC0lM0UlMjBFbnZUcmFuc2l0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmV3X3RyYW5zaXRpb24lMjAlM0QlMjB0cmFuc2l0aW9uLmNvcHkoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME5vcm1hbGl6ZSUyMG9ic2VydmF0aW9ucyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME5vcm1hbGl6ZSUyMGFjdGlvbiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMC4uLiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMG5ld190cmFuc2l0aW9uJTBB",highlighted:`<span class="hljs-meta">@dataclass</span>
<span class="hljs-meta">@ProcessorStepRegistry.register(<span class="hljs-params"><span class="hljs-string">&quot;normalizer_processor&quot;</span></span>)</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">NormalizerProcessorStep</span>(<span class="hljs-title class_ inherited__">ProcessorStep</span>):
    <span class="hljs-string">&quot;&quot;&quot;Normalize observations/actions using dataset statistics.&quot;&quot;&quot;</span>

    features: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]
    norm_map: <span class="hljs-built_in">dict</span>[FeatureType, NormalizationMode]
    stats: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]] | <span class="hljs-literal">None</span> = <span class="hljs-literal">None</span>
    eps: <span class="hljs-built_in">float</span> = <span class="hljs-number">1e-8</span>
    _tensor_stats: <span class="hljs-built_in">dict</span> = field(default_factory=<span class="hljs-built_in">dict</span>, init=<span class="hljs-literal">False</span>, <span class="hljs-built_in">repr</span>=<span class="hljs-literal">False</span>)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__post_init__</span>(<span class="hljs-params">self</span>):
        <span class="hljs-string">&quot;&quot;&quot;Convert stats to tensors for efficient computation.&quot;&quot;&quot;</span>
        self.stats = self.stats <span class="hljs-keyword">or</span> {}
        self._tensor_stats = to_tensor(self.stats, device=self.device, dtype=torch.float32)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        new_transition = transition.copy()
        <span class="hljs-comment"># Normalize observations</span>
        <span class="hljs-comment"># ...</span>
        <span class="hljs-comment"># Normalize action</span>
        <span class="hljs-comment"># ...</span>
        <span class="hljs-keyword">return</span> new_transition
`,wrap:!1}}),A=new u({props:{title:"Configuration and State Management",local:"configuration-and-state-management",headingTag:"h3"}}),S=new T({props:{code:"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",highlighted:`<span class="hljs-comment"># Continuing the NormalizerProcessorStep example...</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_config</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    <span class="hljs-string">&quot;&quot;&quot;JSON-serializable configuration (no tensors).&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;eps&quot;</span>: self.eps,
        <span class="hljs-string">&quot;features&quot;</span>: {k: {<span class="hljs-string">&quot;type&quot;</span>: v.<span class="hljs-built_in">type</span>.value, <span class="hljs-string">&quot;shape&quot;</span>: v.shape} <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> self.features.items()},
        <span class="hljs-string">&quot;norm_map&quot;</span>: {ft.value: nm.value <span class="hljs-keyword">for</span> ft, nm <span class="hljs-keyword">in</span> self.norm_map.items()},
        <span class="hljs-comment"># ...</span>
    }

<span class="hljs-keyword">def</span> <span class="hljs-title function_">state_dict</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]:
    <span class="hljs-string">&quot;&quot;&quot;Tensor state only (e.g., dataset statistics).&quot;&quot;&quot;</span>
    flat: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor] = {}
    <span class="hljs-keyword">for</span> key, sub <span class="hljs-keyword">in</span> self._tensor_stats.items():
        <span class="hljs-keyword">for</span> stat_name, tensor <span class="hljs-keyword">in</span> sub.items():
            flat[<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>.<span class="hljs-subst">{stat_name}</span>&quot;</span>] = tensor.cpu()  <span class="hljs-comment"># Always save to CPU</span>
    <span class="hljs-keyword">return</span> flat

<span class="hljs-keyword">def</span> <span class="hljs-title function_">load_state_dict</span>(<span class="hljs-params">self, state: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, torch.Tensor]</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-string">&quot;&quot;&quot;Restore tensor state at runtime.&quot;&quot;&quot;</span>
    self._tensor_stats.clear()
    <span class="hljs-keyword">for</span> flat_key, tensor <span class="hljs-keyword">in</span> state.items():
        key, stat_name = flat_key.rsplit(<span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-number">1</span>)
        <span class="hljs-comment"># Load to processor&#x27;s configured device</span>
        self._tensor_stats.setdefault(key, {})[stat_name] = tensor.to(
            dtype=torch.float32, device=self.device
        )
        <span class="hljs-comment"># ...</span>`,wrap:!1}}),Q=new T({props:{code:"JTIzJTIwU2F2ZSUyMChlLmcuJTJDJTIwaW5zaWRlJTIwYSUyMHBvbGljeSklMEFjb25maWclMjAlM0QlMjBub3JtYWxpemVyLmdldF9jb25maWcoKSUwQXRlbnNvcnMlMjAlM0QlMjBub3JtYWxpemVyLnN0YXRlX2RpY3QoKSUwQSUwQSUyMyUyMFJlc3RvcmUlMjAoZS5nLiUyQyUyMGxvYWRpbmclMjBhJTIwcHJldHJhaW5lZCUyMHBvbGljeSklMEFuZXdfbm9ybWFsaXplciUyMCUzRCUyME5vcm1hbGl6ZXJQcm9jZXNzb3JTdGVwKCoqY29uZmlnKSUwQW5ld19ub3JtYWxpemVyLmxvYWRfc3RhdGVfZGljdCh0ZW5zb3JzKSUwQSUyMyUyME5vdyUyMG5ld19ub3JtYWxpemVyJTIwaGFzJTIwdGhlJTIwc2FtZSUyMHN0YXRzJTIwYW5kJTIwY29uZmlndXJhdGlvbg==",highlighted:`<span class="hljs-comment"># Save (e.g., inside a policy)</span>
config = normalizer.get_config()
tensors = normalizer.state_dict()

<span class="hljs-comment"># Restore (e.g., loading a pretrained policy)</span>
new_normalizer = NormalizerProcessorStep(**config)
new_normalizer.load_state_dict(tensors)
<span class="hljs-comment"># Now new_normalizer has the same stats and configuration</span>`,wrap:!1}}),V=new u({props:{title:"Transform features",local:"transform-features",headingTag:"h3"}}),Y=new T({props:{code:"ZGVmJTIwdHJhbnNmb3JtX2ZlYXR1cmVzKHNlbGYlMkMlMjBmZWF0dXJlcyUzQSUyMGRpY3QlNUJQaXBlbGluZUZlYXR1cmVUeXBlJTJDJTIwZGljdCU1QnN0ciUyQyUyMFBvbGljeUZlYXR1cmUlNUQlNUQpJTIwLSUzRSUyMGRpY3QlNUJQaXBlbGluZUZlYXR1cmVUeXBlJTJDJTIwZGljdCU1QnN0ciUyQyUyMFBvbGljeUZlYXR1cmUlNUQlNUQlM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJOb3JtYWxpemF0aW9uJTIwcHJlc2VydmVzJTIwYWxsJTIwZmVhdHVyZSUyMGRlZmluaXRpb25zLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGZlYXR1cmVzJTIwJTIwJTIzJTIwTm8lMjBjaGFuZ2VzJTIwdG8lMjBmZWF0dXJlJTIwc3RydWN0dXJlJTBBJTIwJTIwJTIwJTIwJTIzJTIwLi4u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_features</span>(<span class="hljs-params">self, features: <span class="hljs-built_in">dict</span>[PipelineFeatureType, <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]]</span>) -&gt; <span class="hljs-built_in">dict</span>[PipelineFeatureType, <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]]:
    <span class="hljs-string">&quot;&quot;&quot;Normalization preserves all feature definitions.&quot;&quot;&quot;</span>
    <span class="hljs-keyword">return</span> features  <span class="hljs-comment"># No changes to feature structure</span>
    <span class="hljs-comment"># ...</span>`,wrap:!1}}),q=new T({props:{code:"ZGVmJTIwdHJhbnNmb3JtX2ZlYXR1cmVzKHNlbGYlMkMlMjBmZWF0dXJlcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBQb2xpY3lGZWF0dXJlJTVEKSUyMC0lM0UlMjBkaWN0JTVCc3RyJTJDJTIwUG9saWN5RmVhdHVyZSU1RCUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNpbXBsZSUyMHJlbmFtaW5nJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJwaXhlbHMlMjIlMjBpbiUyMGZlYXR1cmVzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlNUIlMjJvYnNlcnZhdGlvbi5pbWFnZSUyMiU1RCUyMCUzRCUyMGZlYXR1cmVzLnBvcCglMjJwaXhlbHMlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUGF0dGVybi1iYXNlZCUyMHJlbmFtaW5nJTBBJTIwJTIwJTIwJTIwZm9yJTIwa2V5JTIwaW4lMjBsaXN0KGZlYXR1cmVzLmtleXMoKSklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGtleS5zdGFydHN3aXRoKCUyMmVudl9zdGF0ZS4lMjIpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3VmZml4JTIwJTNEJTIwa2V5JTVCbGVuKCUyMmVudl9zdGF0ZS4lMjIpJTNBJTVEJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZmVhdHVyZXMlNUJmJTIyb2JzZXJ2YXRpb24uJTdCc3VmZml4JTdEJTIyJTVEJTIwJTNEJTIwZmVhdHVyZXMucG9wKGtleSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjAuLi4lMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBmZWF0dXJlcw==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_features</span>(<span class="hljs-params">self, features: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, PolicyFeature]:
    <span class="hljs-comment"># Simple renaming</span>
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;pixels&quot;</span> <span class="hljs-keyword">in</span> features:
        features[<span class="hljs-string">&quot;observation.image&quot;</span>] = features.pop(<span class="hljs-string">&quot;pixels&quot;</span>)

    <span class="hljs-comment"># Pattern-based renaming</span>
    <span class="hljs-keyword">for</span> key <span class="hljs-keyword">in</span> <span class="hljs-built_in">list</span>(features.keys()):
        <span class="hljs-keyword">if</span> key.startswith(<span class="hljs-string">&quot;env_state.&quot;</span>):
            suffix = key[<span class="hljs-built_in">len</span>(<span class="hljs-string">&quot;env_state.&quot;</span>):]
            features[<span class="hljs-string">f&quot;observation.<span class="hljs-subst">{suffix}</span>&quot;</span>] = features.pop(key)
            <span class="hljs-comment"># ...</span>

    <span class="hljs-keyword">return</span> features`,wrap:!1}}),D=new u({props:{title:"Using overrides",local:"using-overrides",headingTag:"h3"}}),le=new T({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yJTIwaW1wb3J0JTIwUm9ib3RQcm9jZXNzb3JQaXBlbGluZSUwQSUwQSUyMyUyMExvYWQlMjBhJTIwZm91bmRhdGlvbmFsJTIwcG9saWN5JTIwdHJhaW5lZCUyMG9uJTIwZGl2ZXJzZSUyMHJvYm90JTIwZGF0YSUwQSUyMyUyMGJ1dCUyMGFkYXB0JTIwbm9ybWFsaXphdGlvbiUyMHRvJTIweW91ciUyMHNwZWNpZmljJTIwcm9ib3QlMkZlbnZpcm9ubWVudCUwQW5ld19zdGF0cyUyMCUzRCUyMExlUm9ib3REYXRhc2V0KHJlcG9faWQlM0QlMjJ1c2VybmFtZSUyRm15LWRhdGFzZXQlMjIpLm1ldGEuc3RhdHMlMEFwcm9jZXNzb3IlMjAlM0QlMjBSb2JvdFByb2Nlc3NvclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJodWdnaW5nZmFjZSUyRmZvdW5kYXRpb25hbC1yb2JvdC1wb2xpY3klMjIlMkMlMjAlMjAlMjMlMjBQcmV0cmFpbmVkJTIwZm91bmRhdGlvbiUyMG1vZGVsJTBBJTIwJTIwJTIwJTIwb3ZlcnJpZGVzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIybm9ybWFsaXplcl9wcm9jZXNzb3IlMjIlM0ElMjAlN0IlMjJzdGF0cyUyMiUzQSUyMG5ld19zdGF0cyU3RCUyQyUyMCUyMCUyMCUyMCUyMCUyMyUyMEluamVjdCUyMHlvdXIlMjByb2JvdCdzJTIwc3RhdGlzdGljcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmRldmljZV9wcm9jZXNzb3IlMjIlM0ElMjAlN0IlMjJkZXZpY2UlMjIlM0ElMjAlMjJjdWRhJTNBMCUyMiU3RCUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMHJlZ2lzdHJ5JTIwbmFtZSUyMGZvciUyMHJlZ2lzdGVyZWQlMjBzdGVwcyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJlbmFtZV9wcm9jZXNzb3IlMjIlM0ElMjAlN0IlMjJyZW5hbWVfbWFwJTIyJTNBJTIwcm9ib3Rfa2V5X21hcCU3RCUyQyUyMCUyMyUyME1hcCUyMHlvdXIlMjByb2JvdCdzJTIwb2JzZXJ2YXRpb24lMjBrZXlzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwLi4uJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor <span class="hljs-keyword">import</span> RobotProcessorPipeline

<span class="hljs-comment"># Load a foundational policy trained on diverse robot data</span>
<span class="hljs-comment"># but adapt normalization to your specific robot/environment</span>
new_stats = LeRobotDataset(repo_id=<span class="hljs-string">&quot;username/my-dataset&quot;</span>).meta.stats
processor = RobotProcessorPipeline.from_pretrained(
    <span class="hljs-string">&quot;huggingface/foundational-robot-policy&quot;</span>,  <span class="hljs-comment"># Pretrained foundation model</span>
    overrides={
        <span class="hljs-string">&quot;normalizer_processor&quot;</span>: {<span class="hljs-string">&quot;stats&quot;</span>: new_stats},     <span class="hljs-comment"># Inject your robot&#x27;s statistics</span>
        <span class="hljs-string">&quot;device_processor&quot;</span>: {<span class="hljs-string">&quot;device&quot;</span>: <span class="hljs-string">&quot;cuda:0&quot;</span>},         <span class="hljs-comment"># registry name for registered steps</span>
        <span class="hljs-string">&quot;rename_processor&quot;</span>: {<span class="hljs-string">&quot;rename_map&quot;</span>: robot_key_map}, <span class="hljs-comment"># Map your robot&#x27;s observation keys</span>
        <span class="hljs-comment"># ...</span>
    },
)`,wrap:!1}}),ne=new u({props:{title:"Best Practices",local:"best-practices",headingTag:"h2"}}),ie=new u({props:{title:"1. Safe Data Handling",local:"1-safe-data-handling",headingTag:"h3"}}),ce=new u({props:{title:"2. Choose Appropriate Base Classes",local:"2-choose-appropriate-base-classes",headingTag:"h3"}}),ye=new u({props:{title:"3. Registration and Naming",local:"3-registration-and-naming",headingTag:"h3"}}),Je=new u({props:{title:"4. State Management Patterns",local:"4-state-management-patterns",headingTag:"h3"}}),je=new u({props:{title:"5. Input Validation and Error Handling",local:"5-input-validation-and-error-handling",headingTag:"h3"}}),Ie=new u({props:{title:"6. Device and Dtype Awareness",local:"6-device-and-dtype-awareness",headingTag:"h3"}}),ge=new u({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),Ne=new ll({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/implement_your_own_processor.mdx"}}),{c(){J=i("meta"),He=n(),Ge=i("p"),ke=n(),p(w.$$.fragment),xe=n(),p(U.$$.fragment),Ae=n(),j=i("p"),j.innerHTML=ss,Xe=n(),p(f.$$.fragment),Se=n(),h=i("p"),h.textContent=ls,We=n(),I=i("p"),I.innerHTML=ns,Qe=n(),p(b.$$.fragment),Ve=n(),C=i("p"),C.textContent=as,Ee=n(),g=i("ul"),g.innerHTML=is,Le=n(),p(v.$$.fragment),Ye=n(),Z=i("p"),Z.textContent=os,Fe=n(),p(_.$$.fragment),qe=n(),z=i("p"),z.innerHTML=rs,Pe=n(),$=i("p"),$.textContent=ps,Ke=n(),B=i("ul"),B.innerHTML=cs,De=n(),p(N.$$.fragment),Oe=n(),G=i("p"),G.innerHTML=Ms,et=n(),p(R.$$.fragment),tt=n(),H=i("p"),H.innerHTML=ms,st=n(),k=i("p"),k.innerHTML=ys,lt=n(),x=i("ul"),x.innerHTML=ds,nt=n(),p(A.$$.fragment),at=n(),X=i("p"),X.innerHTML=us,it=n(),p(S.$$.fragment),ot=n(),W=i("p"),W.innerHTML=Js,rt=n(),p(Q.$$.fragment),pt=n(),p(V.$$.fragment),ct=n(),E=i("p"),E.innerHTML=Ts,Mt=n(),L=i("p"),L.innerHTML=ws,mt=n(),p(Y.$$.fragment),yt=n(),F=i("p"),F.textContent=Us,dt=n(),p(q.$$.fragment),ut=n(),P=i("p"),P.innerHTML=js,Jt=n(),K=i("ul"),K.innerHTML=fs,Tt=n(),p(D.$$.fragment),wt=n(),O=i("p"),O.innerHTML=hs,Ut=n(),ee=i("p"),ee.innerHTML=Is,jt=n(),te=i("p"),te.textContent=bs,ft=n(),se=i("p"),se.innerHTML=Cs,ht=n(),p(le.$$.fragment),It=n(),p(ne.$$.fragment),bt=n(),ae=i("p"),ae.textContent=gs,Ct=n(),p(ie.$$.fragment),gt=n(),oe=i("p"),oe.innerHTML=vs,vt=n(),re=i("p"),re.innerHTML=Zs,Zt=n(),pe=i("p"),pe.textContent=_s,_t=n(),p(ce.$$.fragment),zt=n(),Me=i("p"),Me.innerHTML=zs,$t=n(),me=i("p"),me.innerHTML=$s,Bt=n(),p(ye.$$.fragment),Nt=n(),de=i("p"),de.innerHTML=Bs,Gt=n(),ue=i("p"),ue.textContent=Ns,Rt=n(),p(Je.$$.fragment),Ht=n(),Te=i("p"),Te.innerHTML=Gs,kt=n(),we=i("p"),we.innerHTML=Rs,xt=n(),Ue=i("p"),Ue.innerHTML=Hs,At=n(),p(je.$$.fragment),Xt=n(),fe=i("p"),fe.innerHTML=ks,St=n(),he=i("p"),he.textContent=xs,Wt=n(),p(Ie.$$.fragment),Qt=n(),be=i("p"),be.textContent=As,Vt=n(),Ce=i("p"),Ce.innerHTML=Xs,Et=n(),p(ge.$$.fragment),Lt=n(),ve=i("p"),ve.textContent=Ss,Yt=n(),Ze=i("ol"),Ze.innerHTML=Ws,Ft=n(),_e=i("p"),_e.textContent=Qs,qt=n(),ze=i("p"),ze.textContent=Vs,Pt=n(),$e=i("ul"),$e.innerHTML=Es,Kt=n(),Be=i("p"),Be.textContent=Ls,Dt=n(),p(Ne.$$.fragment),Ot=n(),Re=i("p"),this.h()},l(e){const t=el("svelte-u9bgzb",document.head);J=o(t,"META",{name:!0,content:!0}),t.forEach(s),He=a(e),Ge=o(e,"P",{}),Ys(Ge).forEach(s),ke=a(e),c(w.$$.fragment,e),xe=a(e),c(U.$$.fragment,e),Ae=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-f2ydop"&&(j.innerHTML=ss),Xe=a(e),c(f.$$.fragment,e),Se=a(e),h=o(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-14012gf"&&(h.textContent=ls),We=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1pqilce"&&(I.innerHTML=ns),Qe=a(e),c(b.$$.fragment,e),Ve=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-s4qb1l"&&(C.textContent=as),Ee=a(e),g=o(e,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-j94eby"&&(g.innerHTML=is),Le=a(e),c(v.$$.fragment,e),Ye=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1vf7vne"&&(Z.textContent=os),Fe=a(e),c(_.$$.fragment,e),qe=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1qsxaj2"&&(z.innerHTML=rs),Pe=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-119p6dx"&&($.textContent=ps),Ke=a(e),B=o(e,"UL",{"data-svelte-h":!0}),r(B)!=="svelte-3mrreh"&&(B.innerHTML=cs),De=a(e),c(N.$$.fragment,e),Oe=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-ata62c"&&(G.innerHTML=Ms),et=a(e),c(R.$$.fragment,e),tt=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-15o252k"&&(H.innerHTML=ms),st=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-3wif3z"&&(k.innerHTML=ys),lt=a(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1mvgztx"&&(x.innerHTML=ds),nt=a(e),c(A.$$.fragment,e),at=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-b2vh7o"&&(X.innerHTML=us),it=a(e),c(S.$$.fragment,e),ot=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-qbjyqk"&&(W.innerHTML=Js),rt=a(e),c(Q.$$.fragment,e),pt=a(e),c(V.$$.fragment,e),ct=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-zpl57h"&&(E.innerHTML=Ts),Mt=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1se5k3a"&&(L.innerHTML=ws),mt=a(e),c(Y.$$.fragment,e),yt=a(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-n4v86e"&&(F.textContent=Us),dt=a(e),c(q.$$.fragment,e),ut=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-3wif3z"&&(P.innerHTML=js),Jt=a(e),K=o(e,"UL",{"data-svelte-h":!0}),r(K)!=="svelte-4cbkzr"&&(K.innerHTML=fs),Tt=a(e),c(D.$$.fragment,e),wt=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1j2nqgx"&&(O.innerHTML=hs),Ut=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1q1vmke"&&(ee.innerHTML=Is),jt=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-4yxneh"&&(te.textContent=bs),ft=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-1lufxqo"&&(se.innerHTML=Cs),ht=a(e),c(le.$$.fragment,e),It=a(e),c(ne.$$.fragment,e),bt=a(e),ae=o(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-a9gap8"&&(ae.textContent=gs),Ct=a(e),c(ie.$$.fragment,e),gt=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-d8shql"&&(oe.innerHTML=vs),vt=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1tanh7n"&&(re.innerHTML=Zs),Zt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-11gh8f3"&&(pe.textContent=_s),_t=a(e),c(ce.$$.fragment,e),zt=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-ajlzxq"&&(Me.innerHTML=zs),$t=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1de5ugl"&&(me.innerHTML=$s),Bt=a(e),c(ye.$$.fragment,e),Nt=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-14yccwa"&&(de.innerHTML=Bs),Gt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1td2c4"&&(ue.textContent=Ns),Rt=a(e),c(Je.$$.fragment,e),Ht=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1xtlp1l"&&(Te.innerHTML=Gs),kt=a(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-1o9ps7u"&&(we.innerHTML=Rs),xt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-11a1j3g"&&(Ue.innerHTML=Hs),At=a(e),c(je.$$.fragment,e),Xt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-gzrs9k"&&(fe.innerHTML=ks),St=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-d41fwr"&&(he.textContent=xs),Wt=a(e),c(Ie.$$.fragment,e),Qt=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-1kwzte0"&&(be.textContent=As),Vt=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-14re3q4"&&(Ce.innerHTML=Xs),Et=a(e),c(ge.$$.fragment,e),Lt=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-18m2ax2"&&(ve.textContent=Ss),Yt=a(e),Ze=o(e,"OL",{"data-svelte-h":!0}),r(Ze)!=="svelte-1b1ldni"&&(Ze.innerHTML=Ws),Ft=a(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-w0jjpx"&&(_e.textContent=Qs),qt=a(e),ze=o(e,"P",{"data-svelte-h":!0}),r(ze)!=="svelte-nopmtt"&&(ze.textContent=Vs),Pt=a(e),$e=o(e,"UL",{"data-svelte-h":!0}),r($e)!=="svelte-1o9k3ro"&&($e.innerHTML=Es),Kt=a(e),Be=o(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-9erybv"&&(Be.textContent=Ls),Dt=a(e),c(Ne.$$.fragment,e),Ot=a(e),Re=o(e,"P",{}),Ys(Re).forEach(s),this.h()},h(){Fs(J,"name","hf:doc:metadata"),Fs(J,"content",al)},m(e,t){tl(document.head,J),l(e,He,t),l(e,Ge,t),l(e,ke,t),M(w,e,t),l(e,xe,t),M(U,e,t),l(e,Ae,t),l(e,j,t),l(e,Xe,t),M(f,e,t),l(e,Se,t),l(e,h,t),l(e,We,t),l(e,I,t),l(e,Qe,t),M(b,e,t),l(e,Ve,t),l(e,C,t),l(e,Ee,t),l(e,g,t),l(e,Le,t),M(v,e,t),l(e,Ye,t),l(e,Z,t),l(e,Fe,t),M(_,e,t),l(e,qe,t),l(e,z,t),l(e,Pe,t),l(e,$,t),l(e,Ke,t),l(e,B,t),l(e,De,t),M(N,e,t),l(e,Oe,t),l(e,G,t),l(e,et,t),M(R,e,t),l(e,tt,t),l(e,H,t),l(e,st,t),l(e,k,t),l(e,lt,t),l(e,x,t),l(e,nt,t),M(A,e,t),l(e,at,t),l(e,X,t),l(e,it,t),M(S,e,t),l(e,ot,t),l(e,W,t),l(e,rt,t),M(Q,e,t),l(e,pt,t),M(V,e,t),l(e,ct,t),l(e,E,t),l(e,Mt,t),l(e,L,t),l(e,mt,t),M(Y,e,t),l(e,yt,t),l(e,F,t),l(e,dt,t),M(q,e,t),l(e,ut,t),l(e,P,t),l(e,Jt,t),l(e,K,t),l(e,Tt,t),M(D,e,t),l(e,wt,t),l(e,O,t),l(e,Ut,t),l(e,ee,t),l(e,jt,t),l(e,te,t),l(e,ft,t),l(e,se,t),l(e,ht,t),M(le,e,t),l(e,It,t),M(ne,e,t),l(e,bt,t),l(e,ae,t),l(e,Ct,t),M(ie,e,t),l(e,gt,t),l(e,oe,t),l(e,vt,t),l(e,re,t),l(e,Zt,t),l(e,pe,t),l(e,_t,t),M(ce,e,t),l(e,zt,t),l(e,Me,t),l(e,$t,t),l(e,me,t),l(e,Bt,t),M(ye,e,t),l(e,Nt,t),l(e,de,t),l(e,Gt,t),l(e,ue,t),l(e,Rt,t),M(Je,e,t),l(e,Ht,t),l(e,Te,t),l(e,kt,t),l(e,we,t),l(e,xt,t),l(e,Ue,t),l(e,At,t),M(je,e,t),l(e,Xt,t),l(e,fe,t),l(e,St,t),l(e,he,t),l(e,Wt,t),M(Ie,e,t),l(e,Qt,t),l(e,be,t),l(e,Vt,t),l(e,Ce,t),l(e,Et,t),M(ge,e,t),l(e,Lt,t),l(e,ve,t),l(e,Yt,t),l(e,Ze,t),l(e,Ft,t),l(e,_e,t),l(e,qt,t),l(e,ze,t),l(e,Pt,t),l(e,$e,t),l(e,Kt,t),l(e,Be,t),l(e,Dt,t),M(Ne,e,t),l(e,Ot,t),l(e,Re,t),es=!0},p:Ps,i(e){es||(m(w.$$.fragment,e),m(U.$$.fragment,e),m(f.$$.fragment,e),m(b.$$.fragment,e),m(v.$$.fragment,e),m(_.$$.fragment,e),m(N.$$.fragment,e),m(R.$$.fragment,e),m(A.$$.fragment,e),m(S.$$.fragment,e),m(Q.$$.fragment,e),m(V.$$.fragment,e),m(Y.$$.fragment,e),m(q.$$.fragment,e),m(D.$$.fragment,e),m(le.$$.fragment,e),m(ne.$$.fragment,e),m(ie.$$.fragment,e),m(ce.$$.fragment,e),m(ye.$$.fragment,e),m(Je.$$.fragment,e),m(je.$$.fragment,e),m(Ie.$$.fragment,e),m(ge.$$.fragment,e),m(Ne.$$.fragment,e),es=!0)},o(e){y(w.$$.fragment,e),y(U.$$.fragment,e),y(f.$$.fragment,e),y(b.$$.fragment,e),y(v.$$.fragment,e),y(_.$$.fragment,e),y(N.$$.fragment,e),y(R.$$.fragment,e),y(A.$$.fragment,e),y(S.$$.fragment,e),y(Q.$$.fragment,e),y(V.$$.fragment,e),y(Y.$$.fragment,e),y(q.$$.fragment,e),y(D.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(ie.$$.fragment,e),y(ce.$$.fragment,e),y(ye.$$.fragment,e),y(Je.$$.fragment,e),y(je.$$.fragment,e),y(Ie.$$.fragment,e),y(ge.$$.fragment,e),y(Ne.$$.fragment,e),es=!1},d(e){e&&(s(He),s(Ge),s(ke),s(xe),s(Ae),s(j),s(Xe),s(Se),s(h),s(We),s(I),s(Qe),s(Ve),s(C),s(Ee),s(g),s(Le),s(Ye),s(Z),s(Fe),s(qe),s(z),s(Pe),s($),s(Ke),s(B),s(De),s(Oe),s(G),s(et),s(tt),s(H),s(st),s(k),s(lt),s(x),s(nt),s(at),s(X),s(it),s(ot),s(W),s(rt),s(pt),s(ct),s(E),s(Mt),s(L),s(mt),s(yt),s(F),s(dt),s(ut),s(P),s(Jt),s(K),s(Tt),s(wt),s(O),s(Ut),s(ee),s(jt),s(te),s(ft),s(se),s(ht),s(It),s(bt),s(ae),s(Ct),s(gt),s(oe),s(vt),s(re),s(Zt),s(pe),s(_t),s(zt),s(Me),s($t),s(me),s(Bt),s(Nt),s(de),s(Gt),s(ue),s(Rt),s(Ht),s(Te),s(kt),s(we),s(xt),s(Ue),s(At),s(Xt),s(fe),s(St),s(he),s(Wt),s(Qt),s(be),s(Vt),s(Ce),s(Et),s(Lt),s(ve),s(Yt),s(Ze),s(Ft),s(_e),s(qt),s(ze),s(Pt),s($e),s(Kt),s(Be),s(Dt),s(Ot),s(Re)),s(J),d(w,e),d(U,e),d(f,e),d(b,e),d(v,e),d(_,e),d(N,e),d(R,e),d(A,e),d(S,e),d(Q,e),d(V,e),d(Y,e),d(q,e),d(D,e),d(le,e),d(ne,e),d(ie,e),d(ce,e),d(ye,e),d(Je,e),d(je,e),d(Ie,e),d(ge,e),d(Ne,e)}}}const al='{"title":"Implement your own Robot Processor","local":"implement-your-own-robot-processor","sections":[{"title":"Why would you need a custom processor?","local":"why-would-you-need-a-custom-processor","sections":[],"depth":2},{"title":"How to implement your own processor?","local":"how-to-implement-your-own-processor","sections":[{"title":"Implement the __call__ method","local":"implement-the-call-method","sections":[],"depth":3},{"title":"Configuration and State Management","local":"configuration-and-state-management","sections":[],"depth":3},{"title":"Transform features","local":"transform-features","sections":[],"depth":3},{"title":"Using overrides","local":"using-overrides","sections":[],"depth":3}],"depth":2},{"title":"Best Practices","local":"best-practices","sections":[{"title":"1. Safe Data Handling","local":"1-safe-data-handling","sections":[],"depth":3},{"title":"2. Choose Appropriate Base Classes","local":"2-choose-appropriate-base-classes","sections":[],"depth":3},{"title":"3. Registration and Naming","local":"3-registration-and-naming","sections":[],"depth":3},{"title":"4. State Management Patterns","local":"4-state-management-patterns","sections":[],"depth":3},{"title":"5. Input Validation and Error Handling","local":"5-input-validation-and-error-handling","sections":[],"depth":3},{"title":"6. Device and Dtype Awareness","local":"6-device-and-dtype-awareness","sections":[],"depth":3}],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function il(ts){return Ks(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ml extends Ds{constructor(J){super(),Os(this,J,il,nl,qs,{})}}export{ml as component};
