import{s as Ua,n as Ca,o as Ia}from"../chunks/scheduler.eb244325.js";import{S as ga,i as va,e as o,s as n,c as r,h as $a,a as i,d as l,b as a,f as j,g as M,j as p,k as pn,l as d,m as s,n as c,t as m,o as y,p as w}from"../chunks/index.3fe63ad3.js";import{C as _a}from"../chunks/CopyLLMTxtMenu.08242e11.js";import{C as u}from"../chunks/CodeBlock.91baa5b4.js";import{H as f,E as Aa}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.234c3f85.js";function Ba(rn){let T,Vt,Wt,Xt,U,St,C,Ht,I,Mn="This tutorial will explain how to integrate your own robot design into the LeRobot ecosystem and have it access all of our tools (data collection, control pipelines, policy training and inference).",Lt,g,cn='To that end, we provide the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/robots/robot.py" rel="nofollow"><code>Robot</code></a> base class in the LeRobot which specifies a standard interface for physical robot integration. Let’s see how to implement it.',Qt,v,Ft,$,mn='<li>Your own robot which exposes a communication interface (e.g. serial, CAN, TCP)</li> <li>A way to read sensor data and send motor commands programmatically, e.g. manufacturer’s SDK or API, or your own protocol implementation.</li> <li>LeRobot installed in your environment. Follow our <a href="./installation">Installation Guide</a>.</li>',zt,_,Pt,A,yn="If you’re using Feetech or Dynamixel motors, LeRobot provides built-in bus interfaces:",qt,B,wn='<li><a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/feetech/feetech.py" rel="nofollow"><code>FeetechMotorsBus</code></a> – for controlling Feetech servos</li> <li><a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/dynamixel/dynamixel.py" rel="nofollow"><code>DynamixelMotorsBus</code></a> – for controlling Dynamixel servos</li>',Dt,Z,fn=`Please refer to the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/motors_bus.py" rel="nofollow"><code>MotorsBus</code></a> abstract class to learn about its API.
For a good example of how it can be used, you can have a look at our own <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/robots/so101_follower/so101_follower.py" rel="nofollow">SO101 follower implementation</a>`,Kt,k,dn="Use these if compatible. Otherwise, you’ll need to find or write a Python interface (not covered in this tutorial):",Ot,x,un="<li>Find an existing SDK in Python (or use bindings to C/C++)</li> <li>Or implement a basic communication wrapper (e.g., via pyserial, socket, or CANopen)</li>",el,G,bn="You’re not alone—many community contributions use custom boards or firmware!",tl,N,Tn="For Feetech and Dynamixel, we currently support these servos: - Feetech: - STS &amp; SMS series (protocol 0): <code>sts3215</code>, <code>sts3250</code>, <code>sm8512bl</code> - SCS series (protocol 1): <code>scs0009</code> - Dynamixel (protocol 2.0 only): <code>xl330-m077</code>, <code>xl330-m288</code>, <code>xl430-w250</code>, <code>xm430-w350</code>, <code>xm540-w270</code>, <code>xc430-w150</code>",ll,Y,jn='If you are using Feetech or Dynamixel servos that are not in this list, you can add those in the <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/feetech/tables.py" rel="nofollow">Feetech table</a> or <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/motors/dynamixel/tables.py" rel="nofollow">Dynamixel table</a>. Depending on the model, this will require you to add model-specific information. In most cases though, there shouldn’t be a lot of additions to do.',sl,E,hn="In the next sections, we’ll use a <code>FeetechMotorsBus</code> as the motors interface for the examples. Replace it and adapt to your motors if necessary.",nl,W,al,R,Jn="You’ll first need to specify the config class and a string identifier (<code>name</code>) for your robot. If your robot has special needs that you’d like to be able to change easily, it should go here (e.g. port/address, baudrate).",ol,V,Un="Here, we’ll add the port name and one camera by default for our robot:",il,X,pl,S,Cn='<a href="./cameras">Cameras tutorial</a> to understand how to detect and add your camera.',rl,H,In="Next, we’ll create our actual robot class which inherits from <code>Robot</code>. This abstract class defines a contract you must follow for your robot to be usable with the rest of the LeRobot tools.",Ml,L,gn="Here we’ll create a simple 5-DoF robot with one camera. It could be a simple arm but notice that the <code>Robot</code> abstract class does not assume anything on your robot’s form factor. You can let you imagination run wild when designing new robots!",cl,Q,ml,F,yl,z,vn="These two properties define the <em>interface contract</em> between your robot and tools that consume it (such as data collection or learning pipelines).",wl,h,$n="<p>Note that these properties must be callable even if the robot is not yet connected, so avoid relying on runtime hardware state to define them.</p>",fl,P,dl,q,_n="This property should return a dictionary describing the structure of sensor outputs from your robot. The keys match what <code>get_observation()</code> returns, and the values describe either the shape (for arrays/images) or the type (for simple values).",ul,D,An="Example for our 5-DoF arm with one camera:",bl,K,Tl,O,Bn="In this case, observations consist of a simple dict storing each motor’s position and a camera image.",jl,ee,hl,te,Zn="This property describes the commands your robot expects via <code>send_action()</code>. Again, keys must match the expected input format, and values define the shape/type of each command.",Jl,le,kn="Here, we simply use the same joints proprioceptive features (<code>self._motors_ft</code>) as with <code>observation_features</code>: the action sent will simply the goal position for each motor.",Ul,se,Cl,ne,Il,ae,xn="These methods should handle opening and closing communication with your hardware (e.g. serial ports, CAN interfaces, USB devices, cameras).",gl,oe,vl,ie,Gn="This property should simply reflect that communication with the robot’s hardware is established. When this property is <code>True</code>, it should be possible to read and write to the hardware using <code>get_observation()</code> and <code>send_action()</code>.",$l,pe,_l,re,Al,Me,Nn="This method should establish communication with the hardware. Moreover, if your robot needs calibration and is not calibrated, it should start a calibration procedure by default. If your robot needs some specific configuration, this should also be called here.",Bl,ce,Zl,me,kl,ye,Yn="This method should gracefully terminate communication with the hardware: free any related resources (threads or processes), close ports, etc.",xl,we,En="Here, we already handle this in our <code>MotorsBus</code> and <code>Camera</code> classes so we just need to call their own <code>disconnect()</code> methods:",Gl,fe,Nl,de,Yl,ue,Wn="LeRobot supports saving and loading calibration data automatically. This is useful for joint offsets, zero positions, or sensor alignment.",El,be,Rn="<p>Note that depending on your hardware, this may not apply. If that’s the case, you can simply leave these methods as no-ops:</p>",Wl,Te,Rl,je,Vl,he,Vn="This should reflect whether your robot has the required calibration loaded.",Xl,Je,Sl,Ue,Hl,Ce,Xn="The goal of the calibration is twofold:",Ll,Ie,Sn="<li>Know the physical range of motion of each motors in order to only send commands within this range.</li> <li>Normalize raw motors positions to sensible continuous values (e.g. percentages, degrees) instead of arbitrary discrete value dependant on the specific motor used that will not replicate elsewhere.</li>",Ql,ge,Hn="It should implement the logic for calibration (if relevant) and update the <code>self.calibration</code> dictionary. If you are using Feetech or Dynamixel motors, our bus interfaces already include methods to help with this.",Fl,ve,zl,$e,Pl,_e,Ln="Use this to set up any configuration for your hardware (servos control modes, controller gains, etc.). This should usually be run at connection time and be idempotent.",ql,Ae,Dl,Be,Kl,Ze,Qn="These are the most important runtime functions: the core I/O loop.",Ol,ke,es,xe,Fn="Returns a dictionary of sensor values from the robot. These typically include motor states, camera frames, various sensors, etc. In the LeRobot framework, these observations are what will be fed to a policy in order to predict the actions to take. The dictionary keys and structure must match <code>observation_features</code>.",ts,Ge,ls,Ne,ss,Ye,zn="Takes a dictionary that matches <code>action_features</code>, and sends it to your hardware. You can add safety limits (clipping, smoothing) and return what was actually sent.",ns,Ee,Pn="For simplicity, we won’t be adding any modification of the actions in our example here.",as,We,os,Re,is,Ve,qn='For implementing teleoperation devices, we also provide a <a href="https://github.com/huggingface/lerobot/blob/main/src/lerobot/teleoperators/teleoperator.py" rel="nofollow"><code>Teleoperator</code></a> base class. This class is very similar to the <code>Robot</code> base class and also doesn’t assume anything on form factor.',ps,Xe,Dn="The main differences are in the I/O functions: a teleoperator allows you to produce action via <code>get_action</code> and can receive feedback actions via <code>send_feedback</code>. Feedback could be anything controllable on the teleoperation device that could help the person controlling it understand the consequences of the actions sent. Think motion/force feedback on a leader arm, vibrations on a gamepad controller for example. To implement a teleoperator, you can follow this same tutorial and adapt it for these two methods.",rs,Se,Ms,He,Kn="You can easily extend <code>lerobot</code> with your own custom hardware—be it a camera, robot, or teleoperation device—by creating a separate, installable Python package. If you follow a few simple conventions, the <code>lerobot</code> command-line tools (like <code>lerobot-teleop</code> and <code>lerobot-record</code>) will <strong>automatically discover and integrate your creations</strong> without requiring any changes to the <code>lerobot</code> source code.",cs,Le,On="This guide outlines the conventions your plugin must follow.",ms,Qe,ys,Fe,ea="To ensure your custom device is discoverable, you must adhere to the following four rules.",ws,ze,fs,Pe,ta="Your project must be a standard, installable Python package. Crucially, the name of your package (as defined in <code>pyproject.toml</code> or <code>setup.py</code>) must begin with one of these prefixes:",ds,qe,la="<li><code>lerobot_robot_</code> for a robot.</li> <li><code>lerobot_camera_</code> for a camera.</li> <li><code>lerobot_teleoperator_</code> for a teleoperation device.</li>",us,De,sa="This prefix system is how <code>lerobot</code> automatically finds your plugin in the Python environment.",bs,Ke,Ts,Oe,na="Your device’s implementation class must be named after its configuration class, simply by removing the <code>Config</code> suffix.",js,et,aa="<li><strong>Config Class:</strong> <code>MyAwesomeTeleopConfig</code></li> <li><strong>Device Class:</strong> <code>MyAwesomeTeleop</code></li>",hs,tt,Js,lt,oa="The device class (<code>MyAwesomeTeleop</code>) must be located in a predictable module relative to its configuration class (<code>MyAwesomeTeleopConfig</code>). <code>lerobot</code> will automatically search in these locations:",Us,st,ia="<li>In the <strong>same module</strong> as the config class.</li> <li>In a <strong>submodule named after the device</strong> (e.g., <code>my_awesome_teleop.py</code>).</li>",Cs,nt,pa="The recommended and simplest structure is to place them in separate, clearly named files within the same directory.",Is,at,gs,ot,ra="Your package’s <code>__init__.py</code> file should import and expose both the configuration and the device classes, making them easily accessible.",vs,it,$s,pt,Ma="Let’s create a new teleoperator called <code>my_awesome_teleop</code>.",_s,rt,As,Mt,ca="Here is what the project folder should look like. The package name, <code>lerobot_teleoperator_my_awesome_teleop</code>, follows <strong>Convention #1</strong>.",Bs,ct,Zs,mt,ks,b,yt,kt,ma="<strong><code>config_my_awesome_teleop.py</code></strong>: Defines the configuration class. Note the <code>Config</code> suffix (<strong>Convention #2</strong>).",Os,wt,en,ft,xt,ya="<strong><code>my_awesome_teleop.py</code></strong>: Implements the device. The class name <code>MyAwesomeTeleop</code> matches its config class name (<strong>Convention #2</strong>). This file structure adheres to <strong>Convention #3</strong>.",tn,dt,ln,ut,Gt,wa="<strong><code>__init__.py</code></strong>: Exposes the key classes (<strong>Convention #4</strong>).",sn,bt,xs,Tt,Gs,J,jt,Nt,fa="<strong>Install your new plugin in your Python environment.</strong> You can install your local plugin package using <code>pip</code>’s editable mode or from PyPi.",nn,ht,an,Jt,Yt,da="<strong>Use it directly from the command line.</strong> Now, you can use your custom device by referencing its type.",on,Ut,Ns,Ct,ua="And that’s it! Your custom device is now fully integrated.",Ys,It,Es,gt,ba="Check out these two packages from the community:",Ws,vt,Ta='<li><a href="https://github.com/SpesRobotics/lerobot-robot-xarm" rel="nofollow">https://github.com/SpesRobotics/lerobot-robot-xarm</a></li> <li><a href="https://github.com/SpesRobotics/lerobot-teleoperator-teleop" rel="nofollow">https://github.com/SpesRobotics/lerobot-teleoperator-teleop</a></li>',Rs,$t,Vs,_t,ja="Once your robot class is complete, you can leverage the LeRobot ecosystem:",Xs,At,ha="<li>Control your robot with available teleoperators or integrate directly your teleoperating device</li> <li>Record training data and visualize it</li> <li>Integrate it into RL or imitation learning pipelines</li>",Ss,Bt,Ja='Don’t hesitate to reach out to the community for help on our <a href="https://discord.gg/s3KuuzsPFb" rel="nofollow">Discord</a> 🤗',Hs,Zt,Ls,Rt,Qs;return U=new _a({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new f({props:{title:"Bring Your Own Hardware",local:"bring-your-own-hardware",headingTag:"h1"}}),v=new f({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),_=new f({props:{title:"Choose your motors",local:"choose-your-motors",headingTag:"h2"}}),W=new f({props:{title:"Step 1: Subclass the Robot Interface",local:"step-1-subclass-the-robot-interface",headingTag:"h2"}}),X=new u({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTJDJTIwZmllbGQlMEElMEFmcm9tJTIwbGVyb2JvdC5jYW1lcmFzJTIwaW1wb3J0JTIwQ2FtZXJhQ29uZmlnJTBBZnJvbSUyMGxlcm9ib3QuY2FtZXJhcy5vcGVuY3YlMjBpbXBvcnQlMjBPcGVuQ1ZDYW1lcmFDb25maWclMEFmcm9tJTIwbGVyb2JvdC5yb2JvdHMlMjBpbXBvcnQlMjBSb2JvdENvbmZpZyUwQSUwQSUwQSU0MFJvYm90Q29uZmlnLnJlZ2lzdGVyX3N1YmNsYXNzKCUyMm15X2Nvb2xfcm9ib3QlMjIpJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBNeUNvb2xSb2JvdENvbmZpZyhSb2JvdENvbmZpZyklM0ElMEElMjAlMjAlMjAlMjBwb3J0JTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwY2FtZXJhcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBDYW1lcmFDb25maWclNUQlMjAlM0QlMjBmaWVsZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkZWZhdWx0X2ZhY3RvcnklM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjYW1fMSUyMiUzQSUyME9wZW5DVkNhbWVyYUNvbmZpZyglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbmRleF9vcl9wYXRoJTNEMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZwcyUzRDMwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2lkdGglM0Q0ODAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBoZWlnaHQlM0Q2NDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass, field

<span class="hljs-keyword">from</span> lerobot.cameras <span class="hljs-keyword">import</span> CameraConfig
<span class="hljs-keyword">from</span> lerobot.cameras.opencv <span class="hljs-keyword">import</span> OpenCVCameraConfig
<span class="hljs-keyword">from</span> lerobot.robots <span class="hljs-keyword">import</span> RobotConfig


<span class="hljs-meta">@RobotConfig.register_subclass(<span class="hljs-params"><span class="hljs-string">&quot;my_cool_robot&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobotConfig</span>(<span class="hljs-title class_ inherited__">RobotConfig</span>):
    port: <span class="hljs-built_in">str</span>
    cameras: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, CameraConfig] = field(
        default_factory={
            <span class="hljs-string">&quot;cam_1&quot;</span>: OpenCVCameraConfig(
                index_or_path=<span class="hljs-number">2</span>,
                fps=<span class="hljs-number">30</span>,
                width=<span class="hljs-number">480</span>,
                height=<span class="hljs-number">640</span>,
            ),
        }
    )`,wrap:!1}}),Q=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.cameras <span class="hljs-keyword">import</span> make_cameras_from_configs
<span class="hljs-keyword">from</span> lerobot.motors <span class="hljs-keyword">import</span> Motor, MotorNormMode
<span class="hljs-keyword">from</span> lerobot.motors.feetech <span class="hljs-keyword">import</span> FeetechMotorsBus
<span class="hljs-keyword">from</span> lerobot.robots <span class="hljs-keyword">import</span> Robot

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyCoolRobot</span>(<span class="hljs-title class_ inherited__">Robot</span>):
    config_class = MyCoolRobotConfig
    name = <span class="hljs-string">&quot;my_cool_robot&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyCoolRobotConfig</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.bus = FeetechMotorsBus(
            port=self.config.port,
            motors={
                <span class="hljs-string">&quot;joint_1&quot;</span>: Motor(<span class="hljs-number">1</span>, <span class="hljs-string">&quot;sts3250&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_2&quot;</span>: Motor(<span class="hljs-number">2</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_3&quot;</span>: Motor(<span class="hljs-number">3</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_4&quot;</span>: Motor(<span class="hljs-number">4</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
                <span class="hljs-string">&quot;joint_5&quot;</span>: Motor(<span class="hljs-number">5</span>, <span class="hljs-string">&quot;sts3215&quot;</span>, MotorNormMode.RANGE_M100_100),
            },
            calibration=self.calibration,
        )
        self.cameras = make_cameras_from_configs(config.cameras)`,wrap:!1}}),F=new f({props:{title:"Step 2: Define Observation and Action Features",local:"step-2-define-observation-and-action-features",headingTag:"h2"}}),P=new f({props:{title:"observation_features",local:"observationfeatures",headingTag:"h3"}}),K=new u({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBfbW90b3JzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0eXBlJTVEJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfMS5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzIucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJqb2ludF8zLnBvcyUyMiUzQSUyMGZsb2F0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyam9pbnRfNC5wb3MlMjIlM0ElMjBmbG9hdCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMmpvaW50XzUucG9zJTIyJTNBJTIwZmxvYXQlMkMlMEElMjAlMjAlMjAlMjAlN0QlMEElMEElNDBwcm9wZXJ0eSUwQWRlZiUyMF9jYW1lcmFzX2Z0KHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjB0dXBsZSU1RCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbSUzQSUyMChzZWxmLmNhbWVyYXMlNUJjYW0lNUQuaGVpZ2h0JTJDJTIwc2VsZi5jYW1lcmFzJTVCY2FtJTVELndpZHRoJTJDJTIwMyklMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcyUwQSUyMCUyMCUyMCUyMCU3RCUwQSUwQSU0MHByb3BlcnR5JTBBZGVmJTIwb2JzZXJ2YXRpb25fZmVhdHVyZXMoc2VsZiklMjAtJTNFJTIwZGljdCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMCU3Qioqc2VsZi5fbW90b3JzX2Z0JTJDJTIwKipzZWxmLl9jYW1lcmFzX2Z0JTdE",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_motors_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">type</span>]:
    <span class="hljs-keyword">return</span> {
        <span class="hljs-string">&quot;joint_1.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_2.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_3.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_4.pos&quot;</span>: <span class="hljs-built_in">float</span>,
        <span class="hljs-string">&quot;joint_5.pos&quot;</span>: <span class="hljs-built_in">float</span>,
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">_cameras_ft</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-built_in">tuple</span>]:
    <span class="hljs-keyword">return</span> {
        cam: (self.cameras[cam].height, self.cameras[cam].width, <span class="hljs-number">3</span>) <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras
    }

<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">observation_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> {**self._motors_ft, **self._cameras_ft}`,wrap:!1}}),ee=new f({props:{title:"action_features",local:"actionfeatures",headingTag:"h3"}}),se=new u({props:{code:"ZGVmJTIwYWN0aW9uX2ZlYXR1cmVzKHNlbGYpJTIwLSUzRSUyMGRpY3QlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLl9tb3RvcnNfZnQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">action_features</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>:
    <span class="hljs-keyword">return</span> self._motors_ft`,wrap:!1}}),ne=new f({props:{title:"Step 3: Handle Connection and Disconnection",local:"step-3-handle-connection-and-disconnection",headingTag:"h2"}}),oe=new f({props:{title:"is_connected",local:"isconnected",headingTag:"h3"}}),pe=new u({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jb25uZWN0ZWQoc2VsZiklMjAtJTNFJTIwYm9vbCUzQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHNlbGYuYnVzLmlzX2Nvbm5lY3RlZCUyMGFuZCUyMGFsbChjYW0uaXNfY29ubmVjdGVkJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCkp",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_connected</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-keyword">return</span> self.bus.is_connected <span class="hljs-keyword">and</span> <span class="hljs-built_in">all</span>(cam.is_connected <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values())`,wrap:!1}}),re=new f({props:{title:"connect()",local:"connect",headingTag:"h3"}}),ce=new u({props:{code:"ZGVmJTIwY29ubmVjdChzZWxmJTJDJTIwY2FsaWJyYXRlJTNBJTIwYm9vbCUyMCUzRCUyMFRydWUpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25uZWN0KCklMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY2FsaWJyYXRlZCUyMGFuZCUyMGNhbGlicmF0ZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY2FsaWJyYXRlKCklMEElMEElMjAlMjAlMjAlMjBmb3IlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy52YWx1ZXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhbS5jb25uZWN0KCklMEElMEElMjAlMjAlMjAlMjBzZWxmLmNvbmZpZ3VyZSgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">connect</span>(<span class="hljs-params">self, calibrate: <span class="hljs-built_in">bool</span> = <span class="hljs-literal">True</span></span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.connect()
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_calibrated <span class="hljs-keyword">and</span> calibrate:
        self.calibrate()

    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.connect()

    self.configure()`,wrap:!1}}),me=new f({props:{title:"disconnect()",local:"disconnect",headingTag:"h3"}}),fe=new u({props:{code:"ZGVmJTIwZGlzY29ubmVjdChzZWxmKSUyMC0lM0UlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuZGlzY29ubmVjdCgpJTBBJTIwJTIwJTIwJTIwZm9yJTIwY2FtJTIwaW4lMjBzZWxmLmNhbWVyYXMudmFsdWVzKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjYW0uZGlzY29ubmVjdCgp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">disconnect</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disconnect()
    <span class="hljs-keyword">for</span> cam <span class="hljs-keyword">in</span> self.cameras.values():
        cam.disconnect()`,wrap:!1}}),de=new f({props:{title:"Step 4: Support Calibration and Configuration",local:"step-4-support-calibration-and-configuration",headingTag:"h2"}}),Te=new u({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jYWxpYnJhdGVkKHNlbGYpJTIwLSUzRSUyMGJvb2wlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBUcnVlJTBBJTBBZGVmJTIwY2FsaWJyYXRlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjBwYXNz",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_calibrated</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-keyword">return</span> <span class="hljs-literal">True</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),je=new f({props:{title:"is_calibrated",local:"iscalibrated",headingTag:"h3"}}),Je=new u({props:{code:"JTQwcHJvcGVydHklMEFkZWYlMjBpc19jYWxpYnJhdGVkKHNlbGYpJTIwLSUzRSUyMGJvb2wlM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBzZWxmLmJ1cy5pc19jYWxpYnJhdGVk",highlighted:`<span class="hljs-meta">@property</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">is_calibrated</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">bool</span>:
    <span class="hljs-keyword">return</span> self.bus.is_calibrated`,wrap:!1}}),Ue=new f({props:{title:"calibrate()",local:"calibrate",headingTag:"h3"}}),ve=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">calibrate</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    self.bus.disable_torque()
    <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
        self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)

    <span class="hljs-built_in">input</span>(<span class="hljs-string">f&quot;Move <span class="hljs-subst">{self}</span> to the middle of its range of motion and press ENTER....&quot;</span>)
    homing_offsets = self.bus.set_half_turn_homings()

    <span class="hljs-built_in">print</span>(
        <span class="hljs-string">&quot;Move all joints sequentially through their entire ranges &quot;</span>
        <span class="hljs-string">&quot;of motion.\\nRecording positions. Press ENTER to stop...&quot;</span>
    )
    range_mins, range_maxes = self.bus.record_ranges_of_motion()

    self.calibration = {}
    <span class="hljs-keyword">for</span> motor, m <span class="hljs-keyword">in</span> self.bus.motors.items():
        self.calibration[motor] = MotorCalibration(
            <span class="hljs-built_in">id</span>=m.<span class="hljs-built_in">id</span>,
            drive_mode=<span class="hljs-number">0</span>,
            homing_offset=homing_offsets[motor],
            range_min=range_mins[motor],
            range_max=range_maxes[motor],
        )

    self.bus.write_calibration(self.calibration)
    self._save_calibration()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Calibration saved to&quot;</span>, self.calibration_fpath)`,wrap:!1}}),$e=new f({props:{title:"configure()",local:"configure",headingTag:"h3"}}),Ae=new u({props:{code:"ZGVmJTIwY29uZmlndXJlKHNlbGYpJTIwLSUzRSUyME5vbmUlM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwc2VsZi5idXMudG9ycXVlX2Rpc2FibGVkKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy5jb25maWd1cmVfbW90b3JzKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBtb3RvciUyMGluJTIwc2VsZi5idXMubW90b3JzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyT3BlcmF0aW5nX01vZGUlMjIlMkMlMjBtb3RvciUyQyUyME9wZXJhdGluZ01vZGUuUE9TSVRJT04udmFsdWUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIyUF9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMTYpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VsZi5idXMud3JpdGUoJTIySV9Db2VmZmljaWVudCUyMiUyQyUyMG1vdG9yJTJDJTIwMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWxmLmJ1cy53cml0ZSglMjJEX0NvZWZmaWNpZW50JTIyJTJDJTIwbW90b3IlMkMlMjAzMik=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">configure</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-literal">None</span>:
    <span class="hljs-keyword">with</span> self.bus.torque_disabled():
        self.bus.configure_motors()
        <span class="hljs-keyword">for</span> motor <span class="hljs-keyword">in</span> self.bus.motors:
            self.bus.write(<span class="hljs-string">&quot;Operating_Mode&quot;</span>, motor, OperatingMode.POSITION.value)
            self.bus.write(<span class="hljs-string">&quot;P_Coefficient&quot;</span>, motor, <span class="hljs-number">16</span>)
            self.bus.write(<span class="hljs-string">&quot;I_Coefficient&quot;</span>, motor, <span class="hljs-number">0</span>)
            self.bus.write(<span class="hljs-string">&quot;D_Coefficient&quot;</span>, motor, <span class="hljs-number">32</span>)`,wrap:!1}}),Be=new f({props:{title:"Step 5: Implement Sensors Reading and Action Sending",local:"step-5-implement-sensors-reading-and-action-sending",headingTag:"h2"}}),ke=new f({props:{title:"get_observation()",local:"getobservation",headingTag:"h3"}}),Ge=new u({props:{code:"ZGVmJTIwZ2V0X29ic2VydmF0aW9uKHNlbGYpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMHNlbGYuaXNfY29ubmVjdGVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmFpc2UlMjBDb25uZWN0aW9uRXJyb3IoZiUyMiU3QnNlbGYlN0QlMjBpcyUyMG5vdCUyMGNvbm5lY3RlZC4lMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmVhZCUyMGFybSUyMHBvc2l0aW9uJTBBJTIwJTIwJTIwJTIwb2JzX2RpY3QlMjAlM0QlMjBzZWxmLmJ1cy5zeW5jX3JlYWQoJTIyUHJlc2VudF9Qb3NpdGlvbiUyMiklMEElMjAlMjAlMjAlMjBvYnNfZGljdCUyMCUzRCUyMCU3QmYlMjIlN0Jtb3RvciU3RC5wb3MlMjIlM0ElMjB2YWwlMjBmb3IlMjBtb3RvciUyQyUyMHZhbCUyMGluJTIwb2JzX2RpY3QuaXRlbXMoKSU3RCUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMENhcHR1cmUlMjBpbWFnZXMlMjBmcm9tJTIwY2FtZXJhcyUwQSUyMCUyMCUyMCUyMGZvciUyMGNhbV9rZXklMkMlMjBjYW0lMjBpbiUyMHNlbGYuY2FtZXJhcy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb2JzX2RpY3QlNUJjYW1fa2V5JTVEJTIwJTNEJTIwY2FtLmFzeW5jX3JlYWQoKSUwQSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMG9ic19kaWN0",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_observation</span>(<span class="hljs-params">self</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> self.is_connected:
        <span class="hljs-keyword">raise</span> ConnectionError(<span class="hljs-string">f&quot;<span class="hljs-subst">{self}</span> is not connected.&quot;</span>)

    <span class="hljs-comment"># Read arm position</span>
    obs_dict = self.bus.sync_read(<span class="hljs-string">&quot;Present_Position&quot;</span>)
    obs_dict = {<span class="hljs-string">f&quot;<span class="hljs-subst">{motor}</span>.pos&quot;</span>: val <span class="hljs-keyword">for</span> motor, val <span class="hljs-keyword">in</span> obs_dict.items()}

    <span class="hljs-comment"># Capture images from cameras</span>
    <span class="hljs-keyword">for</span> cam_key, cam <span class="hljs-keyword">in</span> self.cameras.items():
        obs_dict[cam_key] = cam.async_read()

    <span class="hljs-keyword">return</span> obs_dict`,wrap:!1}}),Ne=new f({props:{title:"send_action()",local:"sendaction",headingTag:"h3"}}),We=new u({props:{code:"ZGVmJTIwc2VuZF9hY3Rpb24oc2VsZiUyQyUyMGFjdGlvbiUzQSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQpJTIwLSUzRSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlM0ElMEElMjAlMjAlMjAlMjBnb2FsX3BvcyUyMCUzRCUyMCU3QmtleS5yZW1vdmVzdWZmaXgoJTIyLnBvcyUyMiklM0ElMjB2YWwlMjBmb3IlMjBrZXklMkMlMjB2YWwlMjBpbiUyMGFjdGlvbi5pdGVtcygpJTdEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwU2VuZCUyMGdvYWwlMjBwb3NpdGlvbiUyMHRvJTIwdGhlJTIwYXJtJTBBJTIwJTIwJTIwJTIwc2VsZi5idXMuc3luY193cml0ZSglMjJHb2FsX1Bvc2l0aW9uJTIyJTJDJTIwZ29hbF9wb3MpJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwYWN0aW9u",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">send_action</span>(<span class="hljs-params">self, action: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]:
    goal_pos = {key.removesuffix(<span class="hljs-string">&quot;.pos&quot;</span>): val <span class="hljs-keyword">for</span> key, val <span class="hljs-keyword">in</span> action.items()}

    <span class="hljs-comment"># Send goal position to the arm</span>
    self.bus.sync_write(<span class="hljs-string">&quot;Goal_Position&quot;</span>, goal_pos)

    <span class="hljs-keyword">return</span> action`,wrap:!1}}),Re=new f({props:{title:"Adding a Teleoperator",local:"adding-a-teleoperator",headingTag:"h2"}}),Se=new f({props:{title:"Using Your Own LeRobot Devices 🔌",local:"using-your-own-lerobot-devices-",headingTag:"h2"}}),Qe=new f({props:{title:"The 4 Core Conventions",local:"the-4-core-conventions",headingTag:"h3"}}),ze=new f({props:{title:"1 . Create an Installable Package with a Specific Prefix",local:"1--create-an-installable-package-with-a-specific-prefix",headingTag:"h4"}}),Ke=new f({props:{title:"2 . Follow the SomethingConfig / Something Naming Pattern",local:"2--follow-the-somethingconfig--something-naming-pattern",headingTag:"h4"}}),tt=new f({props:{title:"3 . Place Your Files in a Predictable Structure",local:"3--place-your-files-in-a-predictable-structure",headingTag:"h4"}}),at=new f({props:{title:"4 . Expose Classes in __init__.py",local:"4--expose-classes-in-initpy",headingTag:"h4"}}),it=new f({props:{title:"Putting It All Together: A Complete Example",local:"putting-it-all-together-a-complete-example",headingTag:"h3"}}),rt=new f({props:{title:"Directory Structure",local:"directory-structure",headingTag:"h4"}}),ct=new u({props:{code:"bGVyb2JvdF90ZWxlb3BlcmF0b3JfbXlfYXdlc29tZV90ZWxlb3AlMkYlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBweXByb2plY3QudG9tbCUyMCUyMyUyMChvciUyMHNldHVwLnB5KSUyMGxpc3RzJTIwbGVyb2JvdCUyMGFzJTIwYSUyMGRlcGVuZGVuY3klMEElRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBsZXJvYm90X3RlbGVvcGVyYXRvcl9teV9hd2Vzb21lX3RlbGVvcCUyRiUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMF9faW5pdF9fLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwY29uZmlnX215X2F3ZXNvbWVfdGVsZW9wLnB5JTBBJTIwJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwbXlfYXdlc29tZV90ZWxlb3AucHk=",highlighted:`lerobot_teleoperator_my_awesome_teleop/
├── pyproject.toml # (<span class="hljs-built_in">or</span> setup.<span class="hljs-keyword">py</span>) lists lerobot <span class="hljs-keyword">as</span> <span class="hljs-keyword">a</span> dependency
└── lerobot_teleoperator_my_awesome_teleop/
    ├── __init__.<span class="hljs-keyword">py</span>
    ├── config_my_awesome_teleop.<span class="hljs-keyword">py</span>
    └── my_awesome_teleop.<span class="hljs-keyword">py</span>`,wrap:!1}}),mt=new f({props:{title:"File Contents",local:"file-contents",headingTag:"h4"}}),wt=new u({props:{code:"ZnJvbSUyMGRhdGFjbGFzc2VzJTIwaW1wb3J0JTIwZGF0YWNsYXNzJTBBJTBBZnJvbSUyMGxlcm9ib3QudGVsZW9wZXJhdG9ycy5jb25maWclMjBpbXBvcnQlMjBUZWxlb3BlcmF0b3JDb25maWclMEElMEElNDBUZWxlb3BlcmF0b3JDb25maWcucmVnaXN0ZXJfc3ViY2xhc3MoJTIybXlfYXdlc29tZV90ZWxlb3AlMjIpJTBBJTQwZGF0YWNsYXNzJTBBY2xhc3MlMjBNeUF3ZXNvbWVUZWxlb3BDb25maWcoVGVsZW9wZXJhdG9yQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFlvdXIlMjBjb25maWd1cmF0aW9uJTIwZmllbGRzJTIwZ28lMjBoZXJlJTBBJTIwJTIwJTIwJTIwcG9ydCUzQSUyMHN0ciUyMCUzRCUyMCUyMjE5Mi4xNjguMS4xJTIy",highlighted:`<span class="hljs-keyword">from</span> dataclasses <span class="hljs-keyword">import</span> dataclass

<span class="hljs-keyword">from</span> lerobot.teleoperators.config <span class="hljs-keyword">import</span> TeleoperatorConfig

<span class="hljs-meta">@TeleoperatorConfig.register_subclass(<span class="hljs-params"><span class="hljs-string">&quot;my_awesome_teleop&quot;</span></span>)</span>
<span class="hljs-meta">@dataclass</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyAwesomeTeleopConfig</span>(<span class="hljs-title class_ inherited__">TeleoperatorConfig</span>):
    <span class="hljs-comment"># Your configuration fields go here</span>
    port: <span class="hljs-built_in">str</span> = <span class="hljs-string">&quot;192.168.1.1&quot;</span>`,wrap:!1}}),dt=new u({props:{code:"ZnJvbSUyMGxlcm9ib3QudGVsZW9wZXJhdG9ycy50ZWxlb3BlcmF0b3IlMjBpbXBvcnQlMjBUZWxlb3BlcmF0b3IlMEElMEFmcm9tJTIwLmNvbmZpZ19teV9hd2Vzb21lX3RlbGVvcCUyMGltcG9ydCUyME15QXdlc29tZVRlbGVvcENvbmZpZyUwQSUwQWNsYXNzJTIwTXlBd2Vzb21lVGVsZW9wKFRlbGVvcGVyYXRvciklM0ElMEElMjAlMjAlMjAlMjBjb25maWdfY2xhc3MlMjAlM0QlMjBNeUF3ZXNvbWVUZWxlb3BDb25maWclMEElMjAlMjAlMjAlMjBuYW1lJTIwJTNEJTIwJTIybXlfYXdlc29tZV90ZWxlb3AlMjIlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBfX2luaXRfXyhzZWxmJTJDJTIwY29uZmlnJTNBJTIwTXlBd2Vzb21lVGVsZW9wQ29uZmlnKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN1cGVyKCkuX19pbml0X18oY29uZmlnKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuY29uZmlnJTIwJTNEJTIwY29uZmlnJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwWW91ciUyMGRldmljZSUyMGxvZ2ljJTIwKGUuZy4lMkMlMjBjb25uZWN0KSUyMGdvZXMlMjBoZXJl",highlighted:`<span class="hljs-keyword">from</span> lerobot.teleoperators.teleoperator <span class="hljs-keyword">import</span> Teleoperator

<span class="hljs-keyword">from</span> .config_my_awesome_teleop <span class="hljs-keyword">import</span> MyAwesomeTeleopConfig

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyAwesomeTeleop</span>(<span class="hljs-title class_ inherited__">Teleoperator</span>):
    config_class = MyAwesomeTeleopConfig
    name = <span class="hljs-string">&quot;my_awesome_teleop&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, config: MyAwesomeTeleopConfig</span>):
        <span class="hljs-built_in">super</span>().__init__(config)
        self.config = config

    <span class="hljs-comment"># Your device logic (e.g., connect) goes here</span>`,wrap:!1}}),bt=new u({props:{code:"ZnJvbSUyMC5jb25maWdfbXlfYXdlc29tZV90ZWxlb3AlMjBpbXBvcnQlMjBNeUF3ZXNvbWVUZWxlb3BDb25maWclMEFmcm9tJTIwLm15X2F3ZXNvbWVfdGVsZW9wJTIwaW1wb3J0JTIwTXlBd2Vzb21lVGVsZW9w",highlighted:`<span class="hljs-keyword">from</span> .config_my_awesome_teleop <span class="hljs-keyword">import</span> MyAwesomeTeleopConfig
<span class="hljs-keyword">from</span> .my_awesome_teleop <span class="hljs-keyword">import</span> MyAwesomeTeleop`,wrap:!1}}),Tt=new f({props:{title:"Installation and Usage",local:"installation-and-usage",headingTag:"h3"}}),ht=new u({props:{code:"JTIzJTIwTG9jYWxseSUwQSUyMyUyME5hdmlnYXRlJTIwdG8lMjB5b3VyJTIwcGx1Z2luJ3MlMjByb290JTIwZGlyZWN0b3J5JTIwYW5kJTIwaW5zdGFsbCUyMGl0JTBBY2QlMjBsZXJvYm90X3RlbGVvcGVyYXRvcl9teV9hd2Vzb21lX3RlbGVvcCUwQXBpcCUyMGluc3RhbGwlMjAtZSUyMC4lMEElMEElMjMlMjBGcm9tJTIwUHlQaSUwQXBpcCUyMGluc3RhbGwlMjBsZXJvYm90X3RlbGVvcGVyYXRvcl9teV9hd2Vzb21lX3RlbGVvcA==",highlighted:`<span class="hljs-comment"># Locally</span>
<span class="hljs-comment"># Navigate to your plugin&#x27;s root directory and install it</span>
<span class="hljs-built_in">cd</span> lerobot_teleoperator_my_awesome_teleop
pip install -e .

<span class="hljs-comment"># From PyPi</span>
pip install lerobot_teleoperator_my_awesome_teleop`,wrap:!1}}),Ut=new u({props:{code:"bGVyb2JvdC10ZWxlb3BlcmF0ZSUyMC0tdGVsZW9wLnR5cGUlM0RteV9hd2Vzb21lX3RlbGVvcCUyMCU1QyUwQSUyMyUyMG90aGVyJTIwYXJndW1lbnRz",highlighted:`lerobot-teleoperate --teleop.type=my_awesome_teleop \\
<span class="hljs-comment"># other arguments</span>`,wrap:!1}}),It=new f({props:{title:"Looking for an example ?",local:"looking-for-an-example-",headingTag:"h3"}}),$t=new f({props:{title:"Wrapping Up",local:"wrapping-up",headingTag:"h2"}}),Zt=new Aa({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/integrate_hardware.mdx"}}),{c(){T=o("meta"),Vt=n(),Wt=o("p"),Xt=n(),r(U.$$.fragment),St=n(),r(C.$$.fragment),Ht=n(),I=o("p"),I.textContent=Mn,Lt=n(),g=o("p"),g.innerHTML=cn,Qt=n(),r(v.$$.fragment),Ft=n(),$=o("ul"),$.innerHTML=mn,zt=n(),r(_.$$.fragment),Pt=n(),A=o("p"),A.textContent=yn,qt=n(),B=o("ul"),B.innerHTML=wn,Dt=n(),Z=o("p"),Z.innerHTML=fn,Kt=n(),k=o("p"),k.textContent=dn,Ot=n(),x=o("ul"),x.innerHTML=un,el=n(),G=o("p"),G.textContent=bn,tl=n(),N=o("p"),N.innerHTML=Tn,ll=n(),Y=o("p"),Y.innerHTML=jn,sl=n(),E=o("p"),E.innerHTML=hn,nl=n(),r(W.$$.fragment),al=n(),R=o("p"),R.innerHTML=Jn,ol=n(),V=o("p"),V.textContent=Un,il=n(),r(X.$$.fragment),pl=n(),S=o("p"),S.innerHTML=Cn,rl=n(),H=o("p"),H.innerHTML=In,Ml=n(),L=o("p"),L.innerHTML=gn,cl=n(),r(Q.$$.fragment),ml=n(),r(F.$$.fragment),yl=n(),z=o("p"),z.innerHTML=vn,wl=n(),h=o("blockquote"),h.innerHTML=$n,fl=n(),r(P.$$.fragment),dl=n(),q=o("p"),q.innerHTML=_n,ul=n(),D=o("p"),D.textContent=An,bl=n(),r(K.$$.fragment),Tl=n(),O=o("p"),O.textContent=Bn,jl=n(),r(ee.$$.fragment),hl=n(),te=o("p"),te.innerHTML=Zn,Jl=n(),le=o("p"),le.innerHTML=kn,Ul=n(),r(se.$$.fragment),Cl=n(),r(ne.$$.fragment),Il=n(),ae=o("p"),ae.textContent=xn,gl=n(),r(oe.$$.fragment),vl=n(),ie=o("p"),ie.innerHTML=Gn,$l=n(),r(pe.$$.fragment),_l=n(),r(re.$$.fragment),Al=n(),Me=o("p"),Me.textContent=Nn,Bl=n(),r(ce.$$.fragment),Zl=n(),r(me.$$.fragment),kl=n(),ye=o("p"),ye.textContent=Yn,xl=n(),we=o("p"),we.innerHTML=En,Gl=n(),r(fe.$$.fragment),Nl=n(),r(de.$$.fragment),Yl=n(),ue=o("p"),ue.textContent=Wn,El=n(),be=o("blockquote"),be.innerHTML=Rn,Wl=n(),r(Te.$$.fragment),Rl=n(),r(je.$$.fragment),Vl=n(),he=o("p"),he.textContent=Vn,Xl=n(),r(Je.$$.fragment),Sl=n(),r(Ue.$$.fragment),Hl=n(),Ce=o("p"),Ce.textContent=Xn,Ll=n(),Ie=o("ul"),Ie.innerHTML=Sn,Ql=n(),ge=o("p"),ge.innerHTML=Hn,Fl=n(),r(ve.$$.fragment),zl=n(),r($e.$$.fragment),Pl=n(),_e=o("p"),_e.textContent=Ln,ql=n(),r(Ae.$$.fragment),Dl=n(),r(Be.$$.fragment),Kl=n(),Ze=o("p"),Ze.textContent=Qn,Ol=n(),r(ke.$$.fragment),es=n(),xe=o("p"),xe.innerHTML=Fn,ts=n(),r(Ge.$$.fragment),ls=n(),r(Ne.$$.fragment),ss=n(),Ye=o("p"),Ye.innerHTML=zn,ns=n(),Ee=o("p"),Ee.textContent=Pn,as=n(),r(We.$$.fragment),os=n(),r(Re.$$.fragment),is=n(),Ve=o("p"),Ve.innerHTML=qn,ps=n(),Xe=o("p"),Xe.innerHTML=Dn,rs=n(),r(Se.$$.fragment),Ms=n(),He=o("p"),He.innerHTML=Kn,cs=n(),Le=o("p"),Le.textContent=On,ms=n(),r(Qe.$$.fragment),ys=n(),Fe=o("p"),Fe.textContent=ea,ws=n(),r(ze.$$.fragment),fs=n(),Pe=o("p"),Pe.innerHTML=ta,ds=n(),qe=o("ul"),qe.innerHTML=la,us=n(),De=o("p"),De.innerHTML=sa,bs=n(),r(Ke.$$.fragment),Ts=n(),Oe=o("p"),Oe.innerHTML=na,js=n(),et=o("ul"),et.innerHTML=aa,hs=n(),r(tt.$$.fragment),Js=n(),lt=o("p"),lt.innerHTML=oa,Us=n(),st=o("ul"),st.innerHTML=ia,Cs=n(),nt=o("p"),nt.textContent=pa,Is=n(),r(at.$$.fragment),gs=n(),ot=o("p"),ot.innerHTML=ra,vs=n(),r(it.$$.fragment),$s=n(),pt=o("p"),pt.innerHTML=Ma,_s=n(),r(rt.$$.fragment),As=n(),Mt=o("p"),Mt.innerHTML=ca,Bs=n(),r(ct.$$.fragment),Zs=n(),r(mt.$$.fragment),ks=n(),b=o("ul"),yt=o("li"),kt=o("p"),kt.innerHTML=ma,Os=n(),r(wt.$$.fragment),en=n(),ft=o("li"),xt=o("p"),xt.innerHTML=ya,tn=n(),r(dt.$$.fragment),ln=n(),ut=o("li"),Gt=o("p"),Gt.innerHTML=wa,sn=n(),r(bt.$$.fragment),xs=n(),r(Tt.$$.fragment),Gs=n(),J=o("ol"),jt=o("li"),Nt=o("p"),Nt.innerHTML=fa,nn=n(),r(ht.$$.fragment),an=n(),Jt=o("li"),Yt=o("p"),Yt.innerHTML=da,on=n(),r(Ut.$$.fragment),Ns=n(),Ct=o("p"),Ct.textContent=ua,Ys=n(),r(It.$$.fragment),Es=n(),gt=o("p"),gt.textContent=ba,Ws=n(),vt=o("ul"),vt.innerHTML=Ta,Rs=n(),r($t.$$.fragment),Vs=n(),_t=o("p"),_t.textContent=ja,Xs=n(),At=o("ul"),At.innerHTML=ha,Ss=n(),Bt=o("p"),Bt.innerHTML=Ja,Hs=n(),r(Zt.$$.fragment),Ls=n(),Rt=o("p"),this.h()},l(e){const t=$a("svelte-u9bgzb",document.head);T=i(t,"META",{name:!0,content:!0}),t.forEach(l),Vt=a(e),Wt=i(e,"P",{}),j(Wt).forEach(l),Xt=a(e),M(U.$$.fragment,e),St=a(e),M(C.$$.fragment,e),Ht=a(e),I=i(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-sl443g"&&(I.textContent=Mn),Lt=a(e),g=i(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-yp6pog"&&(g.innerHTML=cn),Qt=a(e),M(v.$$.fragment,e),Ft=a(e),$=i(e,"UL",{"data-svelte-h":!0}),p($)!=="svelte-11itqwk"&&($.innerHTML=mn),zt=a(e),M(_.$$.fragment,e),Pt=a(e),A=i(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-9dsyh9"&&(A.textContent=yn),qt=a(e),B=i(e,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-1cfhvoe"&&(B.innerHTML=wn),Dt=a(e),Z=i(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-169ujvt"&&(Z.innerHTML=fn),Kt=a(e),k=i(e,"P",{"data-svelte-h":!0}),p(k)!=="svelte-12o83v0"&&(k.textContent=dn),Ot=a(e),x=i(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-1d5xfjp"&&(x.innerHTML=un),el=a(e),G=i(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-1e113uy"&&(G.textContent=bn),tl=a(e),N=i(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-145ejj4"&&(N.innerHTML=Tn),ll=a(e),Y=i(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-wbam8h"&&(Y.innerHTML=jn),sl=a(e),E=i(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-tm2a0s"&&(E.innerHTML=hn),nl=a(e),M(W.$$.fragment,e),al=a(e),R=i(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-rc24jv"&&(R.innerHTML=Jn),ol=a(e),V=i(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-1p0w0g0"&&(V.textContent=Un),il=a(e),M(X.$$.fragment,e),pl=a(e),S=i(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1ieof37"&&(S.innerHTML=Cn),rl=a(e),H=i(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-dxku0t"&&(H.innerHTML=In),Ml=a(e),L=i(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-nb93rz"&&(L.innerHTML=gn),cl=a(e),M(Q.$$.fragment,e),ml=a(e),M(F.$$.fragment,e),yl=a(e),z=i(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-l9j1d3"&&(z.innerHTML=vn),wl=a(e),h=i(e,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),p(h)!=="svelte-5ox74y"&&(h.innerHTML=$n),fl=a(e),M(P.$$.fragment,e),dl=a(e),q=i(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-u7pcb4"&&(q.innerHTML=_n),ul=a(e),D=i(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-1t42iyr"&&(D.textContent=An),bl=a(e),M(K.$$.fragment,e),Tl=a(e),O=i(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-1rkp57y"&&(O.textContent=Bn),jl=a(e),M(ee.$$.fragment,e),hl=a(e),te=i(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-12yyl6o"&&(te.innerHTML=Zn),Jl=a(e),le=i(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1h5avx7"&&(le.innerHTML=kn),Ul=a(e),M(se.$$.fragment,e),Cl=a(e),M(ne.$$.fragment,e),Il=a(e),ae=i(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-h4v7d7"&&(ae.textContent=xn),gl=a(e),M(oe.$$.fragment,e),vl=a(e),ie=i(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-1gpnath"&&(ie.innerHTML=Gn),$l=a(e),M(pe.$$.fragment,e),_l=a(e),M(re.$$.fragment,e),Al=a(e),Me=i(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1iphpc4"&&(Me.textContent=Nn),Bl=a(e),M(ce.$$.fragment,e),Zl=a(e),M(me.$$.fragment,e),kl=a(e),ye=i(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-lfuhuo"&&(ye.textContent=Yn),xl=a(e),we=i(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-1seywak"&&(we.innerHTML=En),Gl=a(e),M(fe.$$.fragment,e),Nl=a(e),M(de.$$.fragment,e),Yl=a(e),ue=i(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-1e7cuec"&&(ue.textContent=Wn),El=a(e),be=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),p(be)!=="svelte-9w4yye"&&(be.innerHTML=Rn),Wl=a(e),M(Te.$$.fragment,e),Rl=a(e),M(je.$$.fragment,e),Vl=a(e),he=i(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-10g0kc3"&&(he.textContent=Vn),Xl=a(e),M(Je.$$.fragment,e),Sl=a(e),M(Ue.$$.fragment,e),Hl=a(e),Ce=i(e,"P",{"data-svelte-h":!0}),p(Ce)!=="svelte-15x8ibh"&&(Ce.textContent=Xn),Ll=a(e),Ie=i(e,"UL",{"data-svelte-h":!0}),p(Ie)!=="svelte-1ka4i7r"&&(Ie.innerHTML=Sn),Ql=a(e),ge=i(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-7etria"&&(ge.innerHTML=Hn),Fl=a(e),M(ve.$$.fragment,e),zl=a(e),M($e.$$.fragment,e),Pl=a(e),_e=i(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-1gxojkw"&&(_e.textContent=Ln),ql=a(e),M(Ae.$$.fragment,e),Dl=a(e),M(Be.$$.fragment,e),Kl=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1qfd9tp"&&(Ze.textContent=Qn),Ol=a(e),M(ke.$$.fragment,e),es=a(e),xe=i(e,"P",{"data-svelte-h":!0}),p(xe)!=="svelte-adteeq"&&(xe.innerHTML=Fn),ts=a(e),M(Ge.$$.fragment,e),ls=a(e),M(Ne.$$.fragment,e),ss=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),p(Ye)!=="svelte-1elar01"&&(Ye.innerHTML=zn),ns=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-xmm0bj"&&(Ee.textContent=Pn),as=a(e),M(We.$$.fragment,e),os=a(e),M(Re.$$.fragment,e),is=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),p(Ve)!=="svelte-1s7uvme"&&(Ve.innerHTML=qn),ps=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),p(Xe)!=="svelte-19bs1hk"&&(Xe.innerHTML=Dn),rs=a(e),M(Se.$$.fragment,e),Ms=a(e),He=i(e,"P",{"data-svelte-h":!0}),p(He)!=="svelte-b4gh3p"&&(He.innerHTML=Kn),cs=a(e),Le=i(e,"P",{"data-svelte-h":!0}),p(Le)!=="svelte-1nx86ge"&&(Le.textContent=On),ms=a(e),M(Qe.$$.fragment,e),ys=a(e),Fe=i(e,"P",{"data-svelte-h":!0}),p(Fe)!=="svelte-wkwf1l"&&(Fe.textContent=ea),ws=a(e),M(ze.$$.fragment,e),fs=a(e),Pe=i(e,"P",{"data-svelte-h":!0}),p(Pe)!=="svelte-ngx3o7"&&(Pe.innerHTML=ta),ds=a(e),qe=i(e,"UL",{"data-svelte-h":!0}),p(qe)!=="svelte-1if2wr2"&&(qe.innerHTML=la),us=a(e),De=i(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1g5440j"&&(De.innerHTML=sa),bs=a(e),M(Ke.$$.fragment,e),Ts=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),p(Oe)!=="svelte-hvi6c3"&&(Oe.innerHTML=na),js=a(e),et=i(e,"UL",{"data-svelte-h":!0}),p(et)!=="svelte-one2g8"&&(et.innerHTML=aa),hs=a(e),M(tt.$$.fragment,e),Js=a(e),lt=i(e,"P",{"data-svelte-h":!0}),p(lt)!=="svelte-1oiom90"&&(lt.innerHTML=oa),Us=a(e),st=i(e,"UL",{"data-svelte-h":!0}),p(st)!=="svelte-1631zmm"&&(st.innerHTML=ia),Cs=a(e),nt=i(e,"P",{"data-svelte-h":!0}),p(nt)!=="svelte-8jrjeo"&&(nt.textContent=pa),Is=a(e),M(at.$$.fragment,e),gs=a(e),ot=i(e,"P",{"data-svelte-h":!0}),p(ot)!=="svelte-5us40e"&&(ot.innerHTML=ra),vs=a(e),M(it.$$.fragment,e),$s=a(e),pt=i(e,"P",{"data-svelte-h":!0}),p(pt)!=="svelte-1vhmw5s"&&(pt.innerHTML=Ma),_s=a(e),M(rt.$$.fragment,e),As=a(e),Mt=i(e,"P",{"data-svelte-h":!0}),p(Mt)!=="svelte-pqm0z"&&(Mt.innerHTML=ca),Bs=a(e),M(ct.$$.fragment,e),Zs=a(e),M(mt.$$.fragment,e),ks=a(e),b=i(e,"UL",{});var Et=j(b);yt=i(Et,"LI",{});var Fs=j(yt);kt=i(Fs,"P",{"data-svelte-h":!0}),p(kt)!=="svelte-1bkxmuc"&&(kt.innerHTML=ma),Os=a(Fs),M(wt.$$.fragment,Fs),Fs.forEach(l),en=a(Et),ft=i(Et,"LI",{});var zs=j(ft);xt=i(zs,"P",{"data-svelte-h":!0}),p(xt)!=="svelte-xwteld"&&(xt.innerHTML=ya),tn=a(zs),M(dt.$$.fragment,zs),zs.forEach(l),ln=a(Et),ut=i(Et,"LI",{});var Ps=j(ut);Gt=i(Ps,"P",{"data-svelte-h":!0}),p(Gt)!=="svelte-iyngrk"&&(Gt.innerHTML=wa),sn=a(Ps),M(bt.$$.fragment,Ps),Ps.forEach(l),Et.forEach(l),xs=a(e),M(Tt.$$.fragment,e),Gs=a(e),J=i(e,"OL",{});var qs=j(J);jt=i(qs,"LI",{});var Ds=j(jt);Nt=i(Ds,"P",{"data-svelte-h":!0}),p(Nt)!=="svelte-1x64a52"&&(Nt.innerHTML=fa),nn=a(Ds),M(ht.$$.fragment,Ds),Ds.forEach(l),an=a(qs),Jt=i(qs,"LI",{});var Ks=j(Jt);Yt=i(Ks,"P",{"data-svelte-h":!0}),p(Yt)!=="svelte-rb903a"&&(Yt.innerHTML=da),on=a(Ks),M(Ut.$$.fragment,Ks),Ks.forEach(l),qs.forEach(l),Ns=a(e),Ct=i(e,"P",{"data-svelte-h":!0}),p(Ct)!=="svelte-1u6sxd"&&(Ct.textContent=ua),Ys=a(e),M(It.$$.fragment,e),Es=a(e),gt=i(e,"P",{"data-svelte-h":!0}),p(gt)!=="svelte-4e719u"&&(gt.textContent=ba),Ws=a(e),vt=i(e,"UL",{"data-svelte-h":!0}),p(vt)!=="svelte-1rdiovu"&&(vt.innerHTML=Ta),Rs=a(e),M($t.$$.fragment,e),Vs=a(e),_t=i(e,"P",{"data-svelte-h":!0}),p(_t)!=="svelte-ta7vyn"&&(_t.textContent=ja),Xs=a(e),At=i(e,"UL",{"data-svelte-h":!0}),p(At)!=="svelte-16m8r0w"&&(At.innerHTML=ha),Ss=a(e),Bt=i(e,"P",{"data-svelte-h":!0}),p(Bt)!=="svelte-o90m39"&&(Bt.innerHTML=Ja),Hs=a(e),M(Zt.$$.fragment,e),Ls=a(e),Rt=i(e,"P",{}),j(Rt).forEach(l),this.h()},h(){pn(T,"name","hf:doc:metadata"),pn(T,"content",Za),pn(h,"class","warning")},m(e,t){d(document.head,T),s(e,Vt,t),s(e,Wt,t),s(e,Xt,t),c(U,e,t),s(e,St,t),c(C,e,t),s(e,Ht,t),s(e,I,t),s(e,Lt,t),s(e,g,t),s(e,Qt,t),c(v,e,t),s(e,Ft,t),s(e,$,t),s(e,zt,t),c(_,e,t),s(e,Pt,t),s(e,A,t),s(e,qt,t),s(e,B,t),s(e,Dt,t),s(e,Z,t),s(e,Kt,t),s(e,k,t),s(e,Ot,t),s(e,x,t),s(e,el,t),s(e,G,t),s(e,tl,t),s(e,N,t),s(e,ll,t),s(e,Y,t),s(e,sl,t),s(e,E,t),s(e,nl,t),c(W,e,t),s(e,al,t),s(e,R,t),s(e,ol,t),s(e,V,t),s(e,il,t),c(X,e,t),s(e,pl,t),s(e,S,t),s(e,rl,t),s(e,H,t),s(e,Ml,t),s(e,L,t),s(e,cl,t),c(Q,e,t),s(e,ml,t),c(F,e,t),s(e,yl,t),s(e,z,t),s(e,wl,t),s(e,h,t),s(e,fl,t),c(P,e,t),s(e,dl,t),s(e,q,t),s(e,ul,t),s(e,D,t),s(e,bl,t),c(K,e,t),s(e,Tl,t),s(e,O,t),s(e,jl,t),c(ee,e,t),s(e,hl,t),s(e,te,t),s(e,Jl,t),s(e,le,t),s(e,Ul,t),c(se,e,t),s(e,Cl,t),c(ne,e,t),s(e,Il,t),s(e,ae,t),s(e,gl,t),c(oe,e,t),s(e,vl,t),s(e,ie,t),s(e,$l,t),c(pe,e,t),s(e,_l,t),c(re,e,t),s(e,Al,t),s(e,Me,t),s(e,Bl,t),c(ce,e,t),s(e,Zl,t),c(me,e,t),s(e,kl,t),s(e,ye,t),s(e,xl,t),s(e,we,t),s(e,Gl,t),c(fe,e,t),s(e,Nl,t),c(de,e,t),s(e,Yl,t),s(e,ue,t),s(e,El,t),s(e,be,t),s(e,Wl,t),c(Te,e,t),s(e,Rl,t),c(je,e,t),s(e,Vl,t),s(e,he,t),s(e,Xl,t),c(Je,e,t),s(e,Sl,t),c(Ue,e,t),s(e,Hl,t),s(e,Ce,t),s(e,Ll,t),s(e,Ie,t),s(e,Ql,t),s(e,ge,t),s(e,Fl,t),c(ve,e,t),s(e,zl,t),c($e,e,t),s(e,Pl,t),s(e,_e,t),s(e,ql,t),c(Ae,e,t),s(e,Dl,t),c(Be,e,t),s(e,Kl,t),s(e,Ze,t),s(e,Ol,t),c(ke,e,t),s(e,es,t),s(e,xe,t),s(e,ts,t),c(Ge,e,t),s(e,ls,t),c(Ne,e,t),s(e,ss,t),s(e,Ye,t),s(e,ns,t),s(e,Ee,t),s(e,as,t),c(We,e,t),s(e,os,t),c(Re,e,t),s(e,is,t),s(e,Ve,t),s(e,ps,t),s(e,Xe,t),s(e,rs,t),c(Se,e,t),s(e,Ms,t),s(e,He,t),s(e,cs,t),s(e,Le,t),s(e,ms,t),c(Qe,e,t),s(e,ys,t),s(e,Fe,t),s(e,ws,t),c(ze,e,t),s(e,fs,t),s(e,Pe,t),s(e,ds,t),s(e,qe,t),s(e,us,t),s(e,De,t),s(e,bs,t),c(Ke,e,t),s(e,Ts,t),s(e,Oe,t),s(e,js,t),s(e,et,t),s(e,hs,t),c(tt,e,t),s(e,Js,t),s(e,lt,t),s(e,Us,t),s(e,st,t),s(e,Cs,t),s(e,nt,t),s(e,Is,t),c(at,e,t),s(e,gs,t),s(e,ot,t),s(e,vs,t),c(it,e,t),s(e,$s,t),s(e,pt,t),s(e,_s,t),c(rt,e,t),s(e,As,t),s(e,Mt,t),s(e,Bs,t),c(ct,e,t),s(e,Zs,t),c(mt,e,t),s(e,ks,t),s(e,b,t),d(b,yt),d(yt,kt),d(yt,Os),c(wt,yt,null),d(b,en),d(b,ft),d(ft,xt),d(ft,tn),c(dt,ft,null),d(b,ln),d(b,ut),d(ut,Gt),d(ut,sn),c(bt,ut,null),s(e,xs,t),c(Tt,e,t),s(e,Gs,t),s(e,J,t),d(J,jt),d(jt,Nt),d(jt,nn),c(ht,jt,null),d(J,an),d(J,Jt),d(Jt,Yt),d(Jt,on),c(Ut,Jt,null),s(e,Ns,t),s(e,Ct,t),s(e,Ys,t),c(It,e,t),s(e,Es,t),s(e,gt,t),s(e,Ws,t),s(e,vt,t),s(e,Rs,t),c($t,e,t),s(e,Vs,t),s(e,_t,t),s(e,Xs,t),s(e,At,t),s(e,Ss,t),s(e,Bt,t),s(e,Hs,t),c(Zt,e,t),s(e,Ls,t),s(e,Rt,t),Qs=!0},p:Ca,i(e){Qs||(m(U.$$.fragment,e),m(C.$$.fragment,e),m(v.$$.fragment,e),m(_.$$.fragment,e),m(W.$$.fragment,e),m(X.$$.fragment,e),m(Q.$$.fragment,e),m(F.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(ee.$$.fragment,e),m(se.$$.fragment,e),m(ne.$$.fragment,e),m(oe.$$.fragment,e),m(pe.$$.fragment,e),m(re.$$.fragment,e),m(ce.$$.fragment,e),m(me.$$.fragment,e),m(fe.$$.fragment,e),m(de.$$.fragment,e),m(Te.$$.fragment,e),m(je.$$.fragment,e),m(Je.$$.fragment,e),m(Ue.$$.fragment,e),m(ve.$$.fragment,e),m($e.$$.fragment,e),m(Ae.$$.fragment,e),m(Be.$$.fragment,e),m(ke.$$.fragment,e),m(Ge.$$.fragment,e),m(Ne.$$.fragment,e),m(We.$$.fragment,e),m(Re.$$.fragment,e),m(Se.$$.fragment,e),m(Qe.$$.fragment,e),m(ze.$$.fragment,e),m(Ke.$$.fragment,e),m(tt.$$.fragment,e),m(at.$$.fragment,e),m(it.$$.fragment,e),m(rt.$$.fragment,e),m(ct.$$.fragment,e),m(mt.$$.fragment,e),m(wt.$$.fragment,e),m(dt.$$.fragment,e),m(bt.$$.fragment,e),m(Tt.$$.fragment,e),m(ht.$$.fragment,e),m(Ut.$$.fragment,e),m(It.$$.fragment,e),m($t.$$.fragment,e),m(Zt.$$.fragment,e),Qs=!0)},o(e){y(U.$$.fragment,e),y(C.$$.fragment,e),y(v.$$.fragment,e),y(_.$$.fragment,e),y(W.$$.fragment,e),y(X.$$.fragment,e),y(Q.$$.fragment,e),y(F.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),y(se.$$.fragment,e),y(ne.$$.fragment,e),y(oe.$$.fragment,e),y(pe.$$.fragment,e),y(re.$$.fragment,e),y(ce.$$.fragment,e),y(me.$$.fragment,e),y(fe.$$.fragment,e),y(de.$$.fragment,e),y(Te.$$.fragment,e),y(je.$$.fragment,e),y(Je.$$.fragment,e),y(Ue.$$.fragment,e),y(ve.$$.fragment,e),y($e.$$.fragment,e),y(Ae.$$.fragment,e),y(Be.$$.fragment,e),y(ke.$$.fragment,e),y(Ge.$$.fragment,e),y(Ne.$$.fragment,e),y(We.$$.fragment,e),y(Re.$$.fragment,e),y(Se.$$.fragment,e),y(Qe.$$.fragment,e),y(ze.$$.fragment,e),y(Ke.$$.fragment,e),y(tt.$$.fragment,e),y(at.$$.fragment,e),y(it.$$.fragment,e),y(rt.$$.fragment,e),y(ct.$$.fragment,e),y(mt.$$.fragment,e),y(wt.$$.fragment,e),y(dt.$$.fragment,e),y(bt.$$.fragment,e),y(Tt.$$.fragment,e),y(ht.$$.fragment,e),y(Ut.$$.fragment,e),y(It.$$.fragment,e),y($t.$$.fragment,e),y(Zt.$$.fragment,e),Qs=!1},d(e){e&&(l(Vt),l(Wt),l(Xt),l(St),l(Ht),l(I),l(Lt),l(g),l(Qt),l(Ft),l($),l(zt),l(Pt),l(A),l(qt),l(B),l(Dt),l(Z),l(Kt),l(k),l(Ot),l(x),l(el),l(G),l(tl),l(N),l(ll),l(Y),l(sl),l(E),l(nl),l(al),l(R),l(ol),l(V),l(il),l(pl),l(S),l(rl),l(H),l(Ml),l(L),l(cl),l(ml),l(yl),l(z),l(wl),l(h),l(fl),l(dl),l(q),l(ul),l(D),l(bl),l(Tl),l(O),l(jl),l(hl),l(te),l(Jl),l(le),l(Ul),l(Cl),l(Il),l(ae),l(gl),l(vl),l(ie),l($l),l(_l),l(Al),l(Me),l(Bl),l(Zl),l(kl),l(ye),l(xl),l(we),l(Gl),l(Nl),l(Yl),l(ue),l(El),l(be),l(Wl),l(Rl),l(Vl),l(he),l(Xl),l(Sl),l(Hl),l(Ce),l(Ll),l(Ie),l(Ql),l(ge),l(Fl),l(zl),l(Pl),l(_e),l(ql),l(Dl),l(Kl),l(Ze),l(Ol),l(es),l(xe),l(ts),l(ls),l(ss),l(Ye),l(ns),l(Ee),l(as),l(os),l(is),l(Ve),l(ps),l(Xe),l(rs),l(Ms),l(He),l(cs),l(Le),l(ms),l(ys),l(Fe),l(ws),l(fs),l(Pe),l(ds),l(qe),l(us),l(De),l(bs),l(Ts),l(Oe),l(js),l(et),l(hs),l(Js),l(lt),l(Us),l(st),l(Cs),l(nt),l(Is),l(gs),l(ot),l(vs),l($s),l(pt),l(_s),l(As),l(Mt),l(Bs),l(Zs),l(ks),l(b),l(xs),l(Gs),l(J),l(Ns),l(Ct),l(Ys),l(Es),l(gt),l(Ws),l(vt),l(Rs),l(Vs),l(_t),l(Xs),l(At),l(Ss),l(Bt),l(Hs),l(Ls),l(Rt)),l(T),w(U,e),w(C,e),w(v,e),w(_,e),w(W,e),w(X,e),w(Q,e),w(F,e),w(P,e),w(K,e),w(ee,e),w(se,e),w(ne,e),w(oe,e),w(pe,e),w(re,e),w(ce,e),w(me,e),w(fe,e),w(de,e),w(Te,e),w(je,e),w(Je,e),w(Ue,e),w(ve,e),w($e,e),w(Ae,e),w(Be,e),w(ke,e),w(Ge,e),w(Ne,e),w(We,e),w(Re,e),w(Se,e),w(Qe,e),w(ze,e),w(Ke,e),w(tt,e),w(at,e),w(it,e),w(rt,e),w(ct,e),w(mt,e),w(wt),w(dt),w(bt),w(Tt,e),w(ht),w(Ut),w(It,e),w($t,e),w(Zt,e)}}}const Za='{"title":"Bring Your Own Hardware","local":"bring-your-own-hardware","sections":[{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Choose your motors","local":"choose-your-motors","sections":[],"depth":2},{"title":"Step 1: Subclass the Robot Interface","local":"step-1-subclass-the-robot-interface","sections":[],"depth":2},{"title":"Step 2: Define Observation and Action Features","local":"step-2-define-observation-and-action-features","sections":[{"title":"observation_features","local":"observationfeatures","sections":[],"depth":3},{"title":"action_features","local":"actionfeatures","sections":[],"depth":3}],"depth":2},{"title":"Step 3: Handle Connection and Disconnection","local":"step-3-handle-connection-and-disconnection","sections":[{"title":"is_connected","local":"isconnected","sections":[],"depth":3},{"title":"connect()","local":"connect","sections":[],"depth":3},{"title":"disconnect()","local":"disconnect","sections":[],"depth":3}],"depth":2},{"title":"Step 4: Support Calibration and Configuration","local":"step-4-support-calibration-and-configuration","sections":[{"title":"is_calibrated","local":"iscalibrated","sections":[],"depth":3},{"title":"calibrate()","local":"calibrate","sections":[],"depth":3},{"title":"configure()","local":"configure","sections":[],"depth":3}],"depth":2},{"title":"Step 5: Implement Sensors Reading and Action Sending","local":"step-5-implement-sensors-reading-and-action-sending","sections":[{"title":"get_observation()","local":"getobservation","sections":[],"depth":3},{"title":"send_action()","local":"sendaction","sections":[],"depth":3}],"depth":2},{"title":"Adding a Teleoperator","local":"adding-a-teleoperator","sections":[],"depth":2},{"title":"Using Your Own LeRobot Devices 🔌","local":"using-your-own-lerobot-devices-","sections":[{"title":"The 4 Core Conventions","local":"the-4-core-conventions","sections":[{"title":"1 . Create an Installable Package with a Specific Prefix","local":"1--create-an-installable-package-with-a-specific-prefix","sections":[],"depth":4},{"title":"2 . Follow the SomethingConfig / Something Naming Pattern","local":"2--follow-the-somethingconfig--something-naming-pattern","sections":[],"depth":4},{"title":"3 . Place Your Files in a Predictable Structure","local":"3--place-your-files-in-a-predictable-structure","sections":[],"depth":4},{"title":"4 . Expose Classes in __init__.py","local":"4--expose-classes-in-initpy","sections":[],"depth":4}],"depth":3},{"title":"Putting It All Together: A Complete Example","local":"putting-it-all-together-a-complete-example","sections":[{"title":"Directory Structure","local":"directory-structure","sections":[],"depth":4},{"title":"File Contents","local":"file-contents","sections":[],"depth":4}],"depth":3},{"title":"Installation and Usage","local":"installation-and-usage","sections":[],"depth":3},{"title":"Looking for an example ?","local":"looking-for-an-example-","sections":[],"depth":3}],"depth":2},{"title":"Wrapping Up","local":"wrapping-up","sections":[],"depth":2}],"depth":1}';function ka(rn){return Ia(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wa extends ga{constructor(T){super(),va(this,T,ka,Ba,Ua,{})}}export{Wa as component};
