import{s as bs,n as Is,o as fs}from"../chunks/scheduler.eb244325.js";import{S as vs,i as Cs,e as o,s as n,c,h as Bs,a as i,d as s,b as a,f as hs,g as p,j as r,k as Us,l as gs,m as l,n as M,t as d,o as y,p as m}from"../chunks/index.3fe63ad3.js";import{C as As}from"../chunks/CopyLLMTxtMenu.08242e11.js";import{C as w}from"../chunks/CodeBlock.91baa5b4.js";import{H as J,E as Zs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.234c3f85.js";function Gs(Ye){let T,gt,Ct,At,j,Zt,u,Gt,h,Qe=`In robotics, there’s a fundamental mismatch between the data that robots and humans produce and what machine learning models expect.
Robots output raw sensor data like camera images and joint positions that need normalization, batching, and device placement before models can process them.
Language instructions from humans must be tokenized into numerical representations, and different robots use different coordinate systems that need standardization.`,Rt,U,ze=`The challenge extends to model outputs as well.
Models might output end-effector positions while robots need joint-space commands, or teleoperators produce relative movements while robots expect absolute commands.
Model predictions are often normalized and need conversion back to real-world scales.`,_t,b,We=`Cross-domain translation adds another layer of complexity.
Training data from one robot setup needs adaptation for deployment on different hardware, models trained with specific camera configurations must work with new arrangements, and datasets with different naming conventions need harmonization.`,$t,I,ke=`<strong>That’s where processors come in.</strong> They serve as universal translators that bridge these gaps, ensuring seamless data flow from sensors to models to actuators.
Processors handle all the preprocessing and postprocessing steps needed to convert raw environment data into model-ready inputs and vice versa.`,Nt,f,He="This means that your favorite policy can be used like this:",Vt,v,Et,C,Xt,B,Fe="In robotics, data comes in many forms: images from cameras, joint positions from sensors, text instructions from users, and more. Each type of data requires specific transformations before a model can use it effectively. Models need this data to be:",Yt,g,Se="<li><strong>Normalized</strong>: Scaled to appropriate ranges for neural network processing</li> <li><strong>Batched</strong>: Organized with proper dimensions for batch processing</li> <li><strong>Tokenized</strong>: Text converted to numerical representations</li> <li><strong>Device-placed</strong>: Moved to the right hardware (CPU/GPU)</li> <li><strong>Type-converted</strong>: Cast to appropriate data types</li>",Qt,A,Pe="Processors handle these transformations through composable, reusable steps that can be chained together into pipelines. Think of them as a modular assembly line where each station performs a specific transformation on your data.",zt,Z,Wt,G,kt,R,xe=`The <code>EnvTransition</code> is the fundamental data structure that flows through all processors.
It’s a typed dictionary that represents a complete robot-environment interaction:`,Ht,_,Le="<li><strong>OBSERVATION</strong>: All sensor data (images, states, proprioception)</li> <li><strong>ACTION</strong>: The action to execute or that was executed</li> <li><strong>REWARD</strong>: Reinforcement learning signal</li> <li><strong>DONE/TRUNCATED</strong>: Episode boundary indicators</li> <li><strong>INFO</strong>: Arbitrary metadata</li> <li><strong>COMPLEMENTARY_DATA</strong>: Task descriptions, indices, padding flags, inter-step data</li>",Ft,$,St,N,qe="A <code>ProcessorStep</code> is a single transformation unit that processes transitions. It’s an abstract base class with two required methods:",Pt,V,xt,E,De="<code>__call__</code> is the core of your processor step. It takes an <code>EnvTransition</code> and returns a modified <code>EnvTransition</code>.",Lt,X,Ke="<code>transform_features</code> is used to declare how this step transforms feature shapes/types.",qt,Y,Dt,Q,Oe="The <code>DataProcessorPipeline[TInput, TOutput]</code> chains multiple <code>ProcessorStep</code> instances together:",Kt,z,Ot,W,te,k,ts="The key distinction is in the data structures they handle:",ee,H,es="<thead><tr><th>Aspect</th> <th>RobotProcessorPipeline</th> <th>PolicyProcessorPipeline</th></tr></thead> <tbody><tr><td><strong>Input</strong></td> <td><code>dict[str, Any]</code> - Individual robot values</td> <td><code>dict[str, Any]</code> - Batched tensors</td></tr> <tr><td><strong>Output</strong></td> <td><code>dict[str, Any]</code> - Individual robot commands</td> <td><code>torch.Tensor</code> - Policy predictions</td></tr> <tr><td><strong>Use Case</strong></td> <td>Real-time robot control</td> <td>Model training/inference</td></tr> <tr><td><strong>Data Format</strong></td> <td>Unbatched, heterogeneous</td> <td>Batched, homogeneous</td></tr> <tr><td><strong>Examples</strong></td> <td><code>{&quot;joint_1&quot;: 0.5}</code></td> <td><code>{&quot;observation.state&quot;: tensor([[0.5]])}</code></td></tr></tbody>",se,F,ss="<strong>Use <code>RobotProcessorPipeline</code></strong> for robot hardware interfaces:",le,S,ne,P,ls="<strong>Use <code>PolicyProcessorPipeline</code></strong> for model training and batch processing:",ae,x,oe,L,ie,q,ns="LeRobot provides converter functions to bridge different data formats in <code>lerobot.processor.converters</code>. These functions handle the crucial translations between robot hardware data structures, policy model formats, and the internal <code>EnvTransition</code> representation that flows through processor pipelines.",re,D,as="<thead><tr><th>Category</th> <th>Function</th> <th>Description</th></tr></thead> <tbody><tr><td><strong>Robot Hardware Converters</strong></td> <td><code>robot_action_to_transition</code></td> <td>Robot dict → EnvTransition</td></tr> <tr><td></td> <td><code>observation_to_transition</code></td> <td>Robot obs → EnvTransition</td></tr> <tr><td></td> <td><code>transition_to_robot_action</code></td> <td>EnvTransition → Robot dict</td></tr> <tr><td><strong>Policy/Training Converters</strong></td> <td><code>batch_to_transition</code></td> <td>Batch dict → EnvTransition</td></tr> <tr><td></td> <td><code>transition_to_batch</code></td> <td>EnvTransition → Batch dict</td></tr> <tr><td></td> <td><code>policy_action_to_transition</code></td> <td>Policy tensor → EnvTransition</td></tr> <tr><td></td> <td><code>transition_to_policy_action</code></td> <td>EnvTransition → Policy tensor</td></tr> <tr><td><strong>Utilities</strong></td> <td><code>create_transition</code></td> <td>Build transitions with defaults</td></tr> <tr><td></td> <td><code>identity_transition</code></td> <td>Pass-through converter</td></tr></tbody>",ce,K,os="The key insight is that <strong>robot hardware converters</strong> work with individual values and dictionaries, while <strong>policy/training converters</strong> work with batched tensors and model outputs. The converter functions automatically handle the structural differences, so your processor steps can focus on the core transformations without worrying about data format compatibility.",pe,O,Me,tt,is="The following examples demonstrate real-world processor configurations for policy training and inference.",de,et,rs="Here is an example processor for policy training and inference:",ye,st,me,lt,Je,nt,cs="The most common real-world scenario combines both pipeline types robot hardware generates observations that need policy processing, and policy outputs need robot-compatible postprocessing:",Te,at,we,ot,je,it,ps="Processors don’t just transform data - they can also <strong>change the data structure itself</strong>. The <code>transform_features()</code> method declares these changes, which is crucial for dataset recording and policy creation.",ue,rt,he,ct,Ms="When building datasets or policies, LeRobot needs to know:",Ue,pt,ds="<li><strong>What data fields will exist</strong> after processing</li> <li><strong>What shapes and types</strong> each field will have</li> <li><strong>How to configure models</strong> for the expected data structure</li>",be,Mt,Ie,dt,fe,yt,ys=`<code>create_initial_features()</code> and <code>aggregate_pipeline_dataset_features()</code> solve a critical dataset creation problem: determining the exact final data structure before any data is processed.
Since processor pipelines can add new features (like velocity fields), change tensor shapes (like cropping images), or rename keys, datasets need to know the complete output specification upfront to allocate proper storage and define schemas.
These functions work together by starting with robot hardware specifications (<code>create_initial_features()</code>) then simulating the entire pipeline transformation (<code>aggregate_pipeline_dataset_features()</code>) to compute the final feature dictionary that gets passed to <code>LeRobotDataset.create()</code>, ensuring perfect alignment between what processors output and what datasets expect to store.`,ve,mt,Ce,Jt,Be,Tt,ms="LeRobot provides many registered processor steps. Here are the most commonly used core processors:",ge,wt,Ae,jt,Js="<li><strong><code>normalizer_processor</code></strong>: Normalize observations/actions using dataset statistics (mean/std or min/max)</li> <li><strong><code>device_processor</code></strong>: Move tensors to CPU/GPU with optional dtype conversion</li> <li><strong><code>to_batch_processor</code></strong>: Add batch dimensions to transitions for model compatibility</li> <li><strong><code>rename_observations_processor</code></strong>: Rename observation keys using mapping dictionaries</li> <li><strong><code>tokenizer_processor</code></strong>: Tokenize natural language task descriptions into tokens and attention masks</li>",Ze,ut,Ge,ht,Ts='<li><strong><a href="./implement_your_own_processor">Implement Your Own Processor</a></strong> - Create custom processor steps</li> <li><strong><a href="./debug_processor_pipeline">Debug Your Pipeline</a></strong> - Troubleshoot and optimize pipelines</li> <li><strong><a href="./processors_robots_teleop">Processors for Robots and Teleoperators</a></strong> - Real-world integration patterns</li>',Re,Ut,_e,bt,ws="Processors solve the data translation problem in robotics by providing:",$e,It,js="<li><strong>Modular transformations</strong>: Composable, reusable processing steps</li> <li><strong>Type safety</strong>: Generic pipelines with compile-time checking</li> <li><strong>Performance optimization</strong>: GPU-accelerated operations</li> <li><strong>Robot/Policy distinction</strong>: Separate pipelines for different data structures</li> <li><strong>Comprehensive ecosystem</strong>: 30+ registered processors for common tasks</li>",Ne,ft,us="The key insight: <code>RobotProcessorPipeline</code> handles unbatched robot hardware data, while <code>PolicyProcessorPipeline</code> handles batched model data. Choose the right tool for your data structure!",Ve,vt,Ee,Bt,Xe;return j=new As({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),u=new J({props:{title:"Introduction to Processors",local:"introduction-to-processors",headingTag:"h1"}}),v=new w({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFmcm9tJTIwbGVyb2JvdC5kYXRhc2V0cy5sZXJvYm90X2RhdGFzZXQlMjBpbXBvcnQlMjBMZVJvYm90RGF0YXNldCUwQWZyb20lMjBsZXJvYm90LnBvbGljaWVzLmZhY3RvcnklMjBpbXBvcnQlMjBtYWtlX3ByZV9wb3N0X3Byb2Nlc3NvcnMlMEFmcm9tJTIwbGVyb2JvdC5wb2xpY2llcy55b3VyX3BvbGljeSUyMGltcG9ydCUyMFlvdXJQb2xpY3klMEFmcm9tJTIwbGVyb2JvdC5wcm9jZXNzb3IucGlwZWxpbmUlMjBpbXBvcnQlMjBSb2JvdFByb2Nlc3NvclBpcGVsaW5lJTJDJTIwUG9saWN5UHJvY2Vzc29yUGlwZWxpbmUlMEFkYXRhc2V0JTIwJTNEJTIwTGVSb2JvdERhdGFzZXQoJTIyaGZfdXNlciUyRmRhdGFzZXQlMjIlMkMlMjBlcGlzb2RlcyUzRCU1QjAlNUQpJTBBc2FtcGxlJTIwJTNEJTIwZGF0YXNldCU1QjEwJTVEJTBBJTBBbW9kZWwlMjAlM0QlMjBZb3VyUG9saWN5LmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJoZl91c2VyJTJGbW9kZWwlMjIlMkMlMEEpJTBBbW9kZWwuZXZhbCgpJTBBbW9kZWwudG8oJTIyY3VkYSUyMiklMEFwcmVwcm9jZXNzb3IlMkMlMjBwb3N0cHJvY2Vzc29yJTIwJTNEJTIwbWFrZV9wcmVfcG9zdF9wcm9jZXNzb3JzKG1vZGVsLmNvbmZpZyUyQyUyMHByZXRyYWluZWRfcGF0aCUzRCUyMmhmX3VzZXIlMkZtb2RlbCUyMiUyQyUyMGRhdGFzZXRfc3RhdHMlM0RkYXRhc2V0Lm1ldGEuc3RhdHMpJTBBJTBBcHJlcHJvY2Vzc2VkX3NhbXBsZSUyMCUzRCUyMHByZXByb2Nlc3NvcihzYW1wbGUpJTBBYWN0aW9uJTIwJTNEJTIwbW9kZWwuc2VsZWN0X2FjdGlvbihwcmVwcm9jZXNzZWRfc2FtcGxlKSUwQXBvc3Rwcm9jZXNzZWRfYWN0aW9uJTIwJTNEJTIwcG9zdHByb2Nlc3NvcihhY3Rpb24p",highlighted:`<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">from</span> lerobot.datasets.lerobot_dataset <span class="hljs-keyword">import</span> LeRobotDataset
<span class="hljs-keyword">from</span> lerobot.policies.factory <span class="hljs-keyword">import</span> make_pre_post_processors
<span class="hljs-keyword">from</span> lerobot.policies.your_policy <span class="hljs-keyword">import</span> YourPolicy
<span class="hljs-keyword">from</span> lerobot.processor.pipeline <span class="hljs-keyword">import</span> RobotProcessorPipeline, PolicyProcessorPipeline
dataset = LeRobotDataset(<span class="hljs-string">&quot;hf_user/dataset&quot;</span>, episodes=[<span class="hljs-number">0</span>])
sample = dataset[<span class="hljs-number">10</span>]

model = YourPolicy.from_pretrained(
    <span class="hljs-string">&quot;hf_user/model&quot;</span>,
)
model.<span class="hljs-built_in">eval</span>()
model.to(<span class="hljs-string">&quot;cuda&quot;</span>)
preprocessor, postprocessor = make_pre_post_processors(model.config, pretrained_path=<span class="hljs-string">&quot;hf_user/model&quot;</span>, dataset_stats=dataset.meta.stats)

preprocessed_sample = preprocessor(sample)
action = model.select_action(preprocessed_sample)
postprocessed_action = postprocessor(action)`,wrap:!1}}),C=new J({props:{title:"What are Processors?",local:"what-are-processors",headingTag:"h2"}}),Z=new J({props:{title:"Core Concepts",local:"core-concepts",headingTag:"h2"}}),G=new J({props:{title:"EnvTransition: The Universal Data Container",local:"envtransition-the-universal-data-container",headingTag:"h3"}}),$=new J({props:{title:"ProcessorStep: The Building Block",local:"processorstep-the-building-block",headingTag:"h3"}}),V=new w({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yJTIwaW1wb3J0JTIwUHJvY2Vzc29yU3RlcCUyQyUyMEVudlRyYW5zaXRpb24lMEElMEFjbGFzcyUyME15UHJvY2Vzc29yU3RlcChQcm9jZXNzb3JTdGVwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkV4YW1wbGUlMjBwcm9jZXNzb3IlMjBzdGVwJTIwLSUyMGluaGVyaXQlMjBhbmQlMjBpbXBsZW1lbnQlMjBhYnN0cmFjdCUyMG1ldGhvZHMuJTIyJTIyJTIyJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUyMC0lM0UlMjBFbnZUcmFuc2l0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyVHJhbnNmb3JtJTIwdGhlJTIwdHJhbnNpdGlvbiUyMC0lMjBSRVFVSVJFRCUyMGFic3RyYWN0JTIwbWV0aG9kLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMFlvdXIlMjBwcm9jZXNzaW5nJTIwbG9naWMlMjBoZXJlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwdHJhbnNpdGlvbiUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMHRyYW5zZm9ybV9mZWF0dXJlcyhzZWxmJTJDJTIwZmVhdHVyZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIyJTIyRGVjbGFyZSUyMGhvdyUyMHRoaXMlMjBzdGVwJTIwdHJhbnNmb3JtcyUyMGZlYXR1cmUlMjBzaGFwZXMlMkZ0eXBlcyUyMC0lMjBSRVFVSVJFRCUyMGFic3RyYWN0JTIwbWV0aG9kLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGZlYXR1cmVzJTIwJTIwJTIzJTIwTW9zdCUyMHByb2Nlc3NvcnMlMjByZXR1cm4lMjBmZWF0dXJlcyUyMHVuY2hhbmdlZA==",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor <span class="hljs-keyword">import</span> ProcessorStep, EnvTransition

<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyProcessorStep</span>(<span class="hljs-title class_ inherited__">ProcessorStep</span>):
    <span class="hljs-string">&quot;&quot;&quot;Example processor step - inherit and implement abstract methods.&quot;&quot;&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, transition: EnvTransition</span>) -&gt; EnvTransition:
        <span class="hljs-string">&quot;&quot;&quot;Transform the transition - REQUIRED abstract method.&quot;&quot;&quot;</span>
        <span class="hljs-comment"># Your processing logic here</span>
        <span class="hljs-keyword">return</span> transition

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_features</span>(<span class="hljs-params">self, features</span>):
        <span class="hljs-string">&quot;&quot;&quot;Declare how this step transforms feature shapes/types - REQUIRED abstract method.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">return</span> features  <span class="hljs-comment"># Most processors return features unchanged</span>`,wrap:!1}}),Y=new J({props:{title:"DataProcessorPipeline: The Generic Orchestrator",local:"dataprocessorpipeline-the-generic-orchestrator",headingTag:"h3"}}),z=new w({props:{code:"ZnJvbSUyMGxlcm9ib3QucHJvY2Vzc29yJTIwaW1wb3J0JTIwUm9ib3RQcm9jZXNzb3JQaXBlbGluZSUyQyUyMFBvbGljeVByb2Nlc3NvclBpcGVsaW5lJTBBJTBBJTIzJTIwRm9yJTIwcm9ib3QlMjBoYXJkd2FyZSUyMCh1bmJhdGNoZWQlMjBkYXRhKSUwQXJvYm90X3Byb2Nlc3NvciUyMCUzRCUyMFJvYm90UHJvY2Vzc29yUGlwZWxpbmUlNUJSb2JvdEFjdGlvbiUyQyUyMFJvYm90QWN0aW9uJTVEKCUwQSUyMCUyMCUyMCUyMHN0ZXBzJTNEJTVCc3RlcDElMkMlMjBzdGVwMiUyQyUyMHN0ZXAzJTVEJTJDJTBBJTIwJTIwJTIwJTIwbmFtZSUzRCUyMnJvYm90X3BpcGVsaW5lJTIyJTBBKSUwQSUwQSUyMyUyMEZvciUyMG1vZGVsJTIwdHJhaW5pbmclMkZpbmZlcmVuY2UlMjAoYmF0Y2hlZCUyMGRhdGEpJTBBcG9saWN5X3Byb2Nlc3NvciUyMCUzRCUyMFBvbGljeVByb2Nlc3NvclBpcGVsaW5lJTVCZGljdCU1QnN0ciUyQyUyMEFueSU1RCUyQyUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlNUQoJTBBJTIwJTIwJTIwJTIwc3RlcHMlM0QlNUJzdGVwMSUyQyUyMHN0ZXAyJTJDJTIwc3RlcDMlNUQlMkMlMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIycG9saWN5X3BpcGVsaW5lJTIyJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> lerobot.processor <span class="hljs-keyword">import</span> RobotProcessorPipeline, PolicyProcessorPipeline

<span class="hljs-comment"># For robot hardware (unbatched data)</span>
robot_processor = RobotProcessorPipeline[RobotAction, RobotAction](
    steps=[step1, step2, step3],
    name=<span class="hljs-string">&quot;robot_pipeline&quot;</span>
)

<span class="hljs-comment"># For model training/inference (batched data)</span>
policy_processor = PolicyProcessorPipeline[<span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>], <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]](
    steps=[step1, step2, step3],
    name=<span class="hljs-string">&quot;policy_pipeline&quot;</span>
)`,wrap:!1}}),W=new J({props:{title:"RobotProcessorPipeline vs PolicyProcessorPipeline",local:"robotprocessorpipeline-vs-policyprocessorpipeline",headingTag:"h2"}}),S=new w({props:{code:"JTIzJTIwUm9ib3QlMjBkYXRhJTIwc3RydWN0dXJlcyUzQSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlMjBmb3IlMjBvYnNlcnZhdGlvbnMlMjBhbmQlMjBhY3Rpb25zJTBBcm9ib3Rfb2JzJTNBJTIwZGljdCU1QnN0ciUyQyUyMEFueSU1RCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmpvaW50XzElMjIlM0ElMjAwLjUlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBJbmRpdmlkdWFsJTIwam9pbnQlMjB2YWx1ZXMlMEElMjAlMjAlMjAlMjAlMjJqb2ludF8yJTIyJTNBJTIwLTAuMyUyQyUwQSUyMCUyMCUyMCUyMCUyMmNhbWVyYV8wJTIyJTNBJTIwaW1hZ2VfYXJyYXklMjAlMjAlMjAlMjMlMjBSYXclMjBjYW1lcmElMjBkYXRhJTBBJTdEJTBBJTBBcm9ib3RfYWN0aW9uJTNBJTIwZGljdCU1QnN0ciUyQyUyMEFueSU1RCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmpvaW50XzElMjIlM0ElMjAwLjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBUYXJnZXQlMjBqb2ludCUyMHBvc2l0aW9ucyUwQSUyMCUyMCUyMCUyMCUyMmpvaW50XzIlMjIlM0ElMjAwLjElMkMlMEElMjAlMjAlMjAlMjAlMjJncmlwcGVyJTIyJTNBJTIwMC44JTBBJTdE",highlighted:`<span class="hljs-comment"># Robot data structures: dict[str, Any] for observations and actions</span>
robot_obs: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>] = {
    <span class="hljs-string">&quot;joint_1&quot;</span>: <span class="hljs-number">0.5</span>,           <span class="hljs-comment"># Individual joint values</span>
    <span class="hljs-string">&quot;joint_2&quot;</span>: -<span class="hljs-number">0.3</span>,
    <span class="hljs-string">&quot;camera_0&quot;</span>: image_array   <span class="hljs-comment"># Raw camera data</span>
}

robot_action: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>] = {
    <span class="hljs-string">&quot;joint_1&quot;</span>: <span class="hljs-number">0.2</span>,          <span class="hljs-comment"># Target joint positions</span>
    <span class="hljs-string">&quot;joint_2&quot;</span>: <span class="hljs-number">0.1</span>,
    <span class="hljs-string">&quot;gripper&quot;</span>: <span class="hljs-number">0.8</span>
}`,wrap:!1}}),x=new w({props:{code:"JTIzJTIwUG9saWN5JTIwZGF0YSUyMHN0cnVjdHVyZXMlM0ElMjBiYXRjaCUyMGRpY3RzJTIwYW5kJTIwdGVuc29ycyUwQXBvbGljeV9iYXRjaCUzQSUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiUzQSUyMHRvcmNoLnRlbnNvciglNUIlNUIwLjUlMkMlMjAtMC4zJTVEJTVEKSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEJhdGNoZWQlMjBzdGF0ZXMlMEElMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZXMuY2FtZXJhMCUyMiUzQSUyMHRvcmNoLnRlbnNvciguLi4pJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQmF0Y2hlZCUyMGltYWdlcyUwQSUyMCUyMCUyMCUyMCUyMmFjdGlvbiUyMiUzQSUyMHRvcmNoLnRlbnNvciglNUIlNUIwLjIlMkMlMjAwLjElMkMlMjAwLjglNUQlNUQpJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQmF0Y2hlZCUyMGFjdGlvbnMlMEElN0QlMEElMEFwb2xpY3lfYWN0aW9uJTNBJTIwdG9yY2guVGVuc29yJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QiU1QjAuMiUyQyUyMDAuMSUyQyUyMDAuOCU1RCU1RCklMjAlMjAlMjMlMjBNb2RlbCUyMG91dHB1dCUyMHRlbnNvcg==",highlighted:`<span class="hljs-comment"># Policy data structures: batch dicts and tensors</span>
policy_batch: <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>] = {
    <span class="hljs-string">&quot;observation.state&quot;</span>: torch.tensor([[<span class="hljs-number">0.5</span>, -<span class="hljs-number">0.3</span>]]),      <span class="hljs-comment"># Batched states</span>
    <span class="hljs-string">&quot;observation.images.camera0&quot;</span>: torch.tensor(...),        <span class="hljs-comment"># Batched images</span>
    <span class="hljs-string">&quot;action&quot;</span>: torch.tensor([[<span class="hljs-number">0.2</span>, <span class="hljs-number">0.1</span>, <span class="hljs-number">0.8</span>]])              <span class="hljs-comment"># Batched actions</span>
}

policy_action: torch.Tensor = torch.tensor([[<span class="hljs-number">0.2</span>, <span class="hljs-number">0.1</span>, <span class="hljs-number">0.8</span>]])  <span class="hljs-comment"># Model output tensor</span>`,wrap:!1}}),L=new J({props:{title:"Converter Functions",local:"converter-functions",headingTag:"h2"}}),O=new J({props:{title:"Processor Examples",local:"processor-examples",headingTag:"h2"}}),st=new w({props:{code:"JTIzJTIwVHJhaW5pbmclMjBkYXRhJTIwcHJlcHJvY2Vzc2luZyUyMChvcHRpbWl6ZWQlMjBvcmRlciUyMGZvciUyMEdQVSUyMHBlcmZvcm1hbmNlKSUwQXRyYWluaW5nX3ByZXByb2Nlc3NvciUyMCUzRCUyMFBvbGljeVByb2Nlc3NvclBpcGVsaW5lJTVCZGljdCU1QnN0ciUyQyUyMEFueSU1RCUyQyUyMGRpY3QlNUJzdHIlMkMlMjBBbnklNUQlNUQoJTBBJTIwJTIwJTIwJTIwc3RlcHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBSZW5hbWVPYnNlcnZhdGlvbnNQcm9jZXNzb3JTdGVwKHJlbmFtZV9tYXAlM0QlN0IlN0QpJTJDJTIwJTIwJTIwJTIwJTIwJTIzJTIwU3RhbmRhcmRpemUlMjBrZXlzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwQWRkQmF0Y2hEaW1lbnNpb25Qcm9jZXNzb3JTdGVwKCklMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBiYXRjaCUyMGRpbXMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUb2tlbml6ZXJQcm9jZXNzb3JTdGVwKHRva2VuaXplcl9uYW1lJTNEJTIyLi4uJTIyJTJDJTIwLi4uKSUyQyUyMCUyMCUyMyUyMFRva2VuaXplJTIwbGFuZ3VhZ2UlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXZpY2VQcm9jZXNzb3JTdGVwKGRldmljZSUzRCUyMmN1ZGElMjIpJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTW92ZSUyMHRvJTIwR1BVJTIwZmlyc3QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBOb3JtYWxpemVyUHJvY2Vzc29yU3RlcChmZWF0dXJlcyUzRC4uLiUyQyUyMHN0YXRzJTNELi4uKSUyQyUyMCUyMCUyMCUyMyUyME5vcm1hbGl6ZSUyMG9uJTIwR1BVJTBBJTIwJTIwJTIwJTIwJTVEJTBBKSUwQSUwQSUyMyUyME1vZGVsJTIwb3V0cHV0JTIwcG9zdHByb2Nlc3NpbmclMEF0cmFpbmluZ19wb3N0cHJvY2Vzc29yJTIwJTNEJTIwUG9saWN5UHJvY2Vzc29yUGlwZWxpbmUlNUJ0b3JjaC5UZW5zb3IlMkMlMjB0b3JjaC5UZW5zb3IlNUQoJTBBJTIwJTIwJTIwJTIwc3RlcHMlM0QlNUIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBEZXZpY2VQcm9jZXNzb3JTdGVwKGRldmljZSUzRCUyMmNwdSUyMiklMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBNb3ZlJTIwdG8lMjBDUFUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVbm5vcm1hbGl6ZXJQcm9jZXNzb3JTdGVwKGZlYXR1cmVzJTNELi4uJTJDJTIwc3RhdHMlM0QuLi4pJTJDJTIwJTIzJTIwRGVub3JtYWxpemUlMEElMjAlMjAlMjAlMjAlNUQlMEElMjAlMjAlMjAlMjB0b190cmFuc2l0aW9uJTNEcG9saWN5X2FjdGlvbl90b190cmFuc2l0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdG9fb3V0cHV0JTNEdHJhbnNpdGlvbl90b19wb2xpY3lfYWN0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-comment"># Training data preprocessing (optimized order for GPU performance)</span>
training_preprocessor = PolicyProcessorPipeline[<span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>], <span class="hljs-built_in">dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]](
    steps=[
        RenameObservationsProcessorStep(rename_map={}),     <span class="hljs-comment"># Standardize keys</span>
        AddBatchDimensionProcessorStep(),                   <span class="hljs-comment"># Add batch dims</span>
        TokenizerProcessorStep(tokenizer_name=<span class="hljs-string">&quot;...&quot;</span>, ...),  <span class="hljs-comment"># Tokenize language</span>
        DeviceProcessorStep(device=<span class="hljs-string">&quot;cuda&quot;</span>),                 <span class="hljs-comment"># Move to GPU first</span>
        NormalizerProcessorStep(features=..., stats=...),   <span class="hljs-comment"># Normalize on GPU</span>
    ]
)

<span class="hljs-comment"># Model output postprocessing</span>
training_postprocessor = PolicyProcessorPipeline[torch.Tensor, torch.Tensor](
    steps=[
        DeviceProcessorStep(device=<span class="hljs-string">&quot;cpu&quot;</span>),                  <span class="hljs-comment"># Move to CPU</span>
        UnnormalizerProcessorStep(features=..., stats=...), <span class="hljs-comment"># Denormalize</span>
    ]
    to_transition=policy_action_to_transition,
    to_output=transition_to_policy_action,
)`,wrap:!1}}),lt=new J({props:{title:"An interaction between a robot and a policy with processors",local:"an-interaction-between-a-robot-and-a-policy-with-processors",headingTag:"h3"}}),at=new w({props:{code:"JTIzJTIwUmVhbCUyMGRlcGxveW1lbnQlM0ElMjBSb2JvdCUyMHNlbnNvcnMlMjAlRTIlODYlOTIlMjBNb2RlbCUyMCVFMiU4NiU5MiUyMFJvYm90JTIwY29tbWFuZHMlMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwd2hpbGUlMjBub3QlMjBkb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmF3X29icyUyMCUzRCUyMHJvYm90LmdldF9vYnNlcnZhdGlvbigpJTIwJTIwJTIzJTIwZGljdCU1QnN0ciUyQyUyMEFueSU1RCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEFkZCUyMHlvdXIlMjByb2JvdCUyMG9ic2VydmF0aW9uJTIwdG8lMjBwb2xpY3klMjBvYnNlcnZhdGlvbiUyMHByb2Nlc3NvciUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBvbGljeV9pbnB1dCUyMCUzRCUyMHBvbGljeV9wcmVwcm9jZXNzb3IocmF3X29icyklMjAlMjAlMjMlMjBCYXRjaGVkJTIwZGljdCUwQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHBvbGljeV9vdXRwdXQlMjAlM0QlMjBwb2xpY3kuc2VsZWN0X2FjdGlvbihwb2xpY3lfaW5wdXQpJTIwJTIwJTIzJTIwUG9saWN5JTIwdGVuc29yJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9saWN5X2FjdGlvbiUyMCUzRCUyMHBvbGljeV9wb3N0cHJvY2Vzc29yKHBvbGljeV9vdXRwdXQpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwQWRkJTIweW91ciUyMHJvYm90JTIwYWN0aW9uJTIwdG8lMjBwb2xpY3klMjBhY3Rpb24lMjBwcm9jZXNzb3IlMEElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByb2JvdC5zZW5kX2FjdGlvbihwb2xpY3lfYWN0aW9uKQ==",highlighted:`<span class="hljs-comment"># Real deployment: Robot sensors → Model → Robot commands</span>
<span class="hljs-keyword">with</span> torch.no_grad():
    <span class="hljs-keyword">while</span> <span class="hljs-keyword">not</span> done:
        raw_obs = robot.get_observation()  <span class="hljs-comment"># dict[str, Any]</span>

        <span class="hljs-comment"># Add your robot observation to policy observation processor</span>

        policy_input = policy_preprocessor(raw_obs)  <span class="hljs-comment"># Batched dict</span>

        policy_output = policy.select_action(policy_input)  <span class="hljs-comment"># Policy tensor</span>

        policy_action = policy_postprocessor(policy_output)

        <span class="hljs-comment"># Add your robot action to policy action processor</span>

        robot.send_action(policy_action)`,wrap:!1}}),ot=new J({props:{title:"Feature Contracts: Shape and Type Transformation",local:"feature-contracts-shape-and-type-transformation",headingTag:"h2"}}),rt=new J({props:{title:"Why Feature Contracts Matter",local:"why-feature-contracts-matter",headingTag:"h3"}}),Mt=new w({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMEElMjBwcm9jZXNzb3IlMjB0aGF0JTIwYWRkcyUyMHZlbG9jaXR5JTIwdG8lMjBvYnNlcnZhdGlvbnMlMEFjbGFzcyUyMFZlbG9jaXR5UHJvY2Vzc29yKE9ic2VydmF0aW9uUHJvY2Vzc29yU3RlcCklM0ElMEElMjAlMjAlMjAlMjBkZWYlMjBvYnNlcnZhdGlvbihzZWxmJTJDJTIwb2JzKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG5ld19vYnMlMjAlM0QlMjBvYnMuY29weSgpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjAlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiUyMGluJTIwb2JzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwY29uY2F0ZW5hdGUlMjBjb21wdXRlZCUyMHZlbG9jaXR5JTIwZmllbGQlMjB0byUyMHRoZSUyMHN0YXRlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbmV3X29icyU1QiUyMm9ic2VydmF0aW9uLnN0YXRlJTIyJTVEJTIwJTNEJTIwc2VsZi5fY29tcHV0ZV92ZWxvY2l0eShvYnMlNUIlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiU1RCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBuZXdfb2JzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwdHJhbnNmb3JtX2ZlYXR1cmVzKHNlbGYlMkMlMjBmZWF0dXJlcyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMjJEZWNsYXJlJTIwdGhlJTIwbmV3JTIwdmVsb2NpdHklMjBmaWVsZCUyMHdlJ3JlJTIwYWRkaW5nLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHN0YXRlX2ZlYXR1cmUlMjAlM0QlMjBmZWF0dXJlcyU1QlBpcGVsaW5lRmVhdHVyZVR5cGUuT0JTRVJWQVRJT04lNUQuZ2V0KCUyMm9ic2VydmF0aW9uLnN0YXRlJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwc3RhdGVfZmVhdHVyZSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRvdWJsZV9zaGFwZSUyMCUzRCUyMChzdGF0ZV9mZWF0dXJlLnNoYXBlJTVCMCU1RCUyMColMjAyJTJDKSUyMGlmJTIwc3RhdGVfZmVhdHVyZS5zaGFwZSUyMGVsc2UlMjAoMiUyQyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmZWF0dXJlcyU1QlBpcGVsaW5lRmVhdHVyZVR5cGUuT0JTRVJWQVRJT04lNUQlNUIlMjJvYnNlcnZhdGlvbi5zdGF0ZSUyMiU1RCUyMCUzRCUyMFBvbGljeUZlYXR1cmUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdHlwZSUzREZlYXR1cmVUeXBlLlNUQVRFJTJDJTIwc2hhcGUlM0Rkb3VibGVfc2hhcGUlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZmVhdHVyZXM=",highlighted:`<span class="hljs-comment"># Example: A processor that adds velocity to observations</span>
<span class="hljs-keyword">class</span> <span class="hljs-title class_">VelocityProcessor</span>(<span class="hljs-title class_ inherited__">ObservationProcessorStep</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">observation</span>(<span class="hljs-params">self, obs</span>):
        new_obs = obs.copy()
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;observation.state&quot;</span> <span class="hljs-keyword">in</span> obs:
            <span class="hljs-comment"># concatenate computed velocity field to the state</span>
            new_obs[<span class="hljs-string">&quot;observation.state&quot;</span>] = self._compute_velocity(obs[<span class="hljs-string">&quot;observation.state&quot;</span>])
        <span class="hljs-keyword">return</span> new_obs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">transform_features</span>(<span class="hljs-params">self, features</span>):
        <span class="hljs-string">&quot;&quot;&quot;Declare the new velocity field we&#x27;re adding.&quot;&quot;&quot;</span>
        state_feature = features[PipelineFeatureType.OBSERVATION].get(<span class="hljs-string">&quot;observation.state&quot;</span>)
        <span class="hljs-keyword">if</span> state_feature:
            double_shape = (state_feature.shape[<span class="hljs-number">0</span>] * <span class="hljs-number">2</span>,) <span class="hljs-keyword">if</span> state_feature.shape <span class="hljs-keyword">else</span> (<span class="hljs-number">2</span>,)
            features[PipelineFeatureType.OBSERVATION][<span class="hljs-string">&quot;observation.state&quot;</span>] = PolicyFeature(
                <span class="hljs-built_in">type</span>=FeatureType.STATE, shape=double_shape
            )
        <span class="hljs-keyword">return</span> features`,wrap:!1}}),dt=new J({props:{title:"Feature Specification Functions",local:"feature-specification-functions",headingTag:"h3"}}),mt=new w({props:{code:"ZnJvbSUyMGxlcm9ib3QuZGF0YXNldHMucGlwZWxpbmVfZmVhdHVyZXMlMjBpbXBvcnQlMjBhZ2dyZWdhdGVfcGlwZWxpbmVfZGF0YXNldF9mZWF0dXJlcyUwQSUwQSUyMyUyMFN0YXJ0JTIwd2l0aCUyMHJvYm90J3MlMjByYXclMjBmZWF0dXJlcyUwQWluaXRpYWxfZmVhdHVyZXMlMjAlM0QlMjBjcmVhdGVfaW5pdGlhbF9mZWF0dXJlcyglMEElMjAlMjAlMjAlMjBvYnNlcnZhdGlvbiUzRHJvYm90Lm9ic2VydmF0aW9uX2ZlYXR1cmVzJTJDJTIwJTIwJTIzJTIwJTdCJTIyam9pbnRfMS5wb3MlMjIlM0ElMjBmbG9hdCUyQyUyMCUyMmNhbWVyYV8wJTIyJTNBJTIwKDQ4MCUyQzY0MCUyQzMpJTdEJTBBJTIwJTIwJTIwJTIwYWN0aW9uJTNEcm9ib3QuYWN0aW9uX2ZlYXR1cmVzJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwJTdCJTIyam9pbnRfMS5wb3MlMjIlM0ElMjBmbG9hdCUyQyUyMCUyMmdyaXBwZXIucG9zJTIyJTNBJTIwZmxvYXQlN0QlMEEpJTBBJTBBJTIzJTIwQXBwbHklMjBwcm9jZXNzb3IlMjBwaXBlbGluZSUyMHRvJTIwY29tcHV0ZSUyMGZpbmFsJTIwZmVhdHVyZXMlMEFmaW5hbF9mZWF0dXJlcyUyMCUzRCUyMGFnZ3JlZ2F0ZV9waXBlbGluZV9kYXRhc2V0X2ZlYXR1cmVzKCUwQSUyMCUyMCUyMCUyMHBpcGVsaW5lJTNEbXlfcHJvY2Vzc29yX3BpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwaW5pdGlhbF9mZWF0dXJlcyUzRGluaXRpYWxfZmVhdHVyZXMlMkMlMEElMjAlMjAlMjAlMjB1c2VfdmlkZW9zJTNEVHJ1ZSUwQSklMEElMEElMjMlMjBVc2UlMjBmb3IlMjBkYXRhc2V0JTIwY3JlYXRpb24lMEFkYXRhc2V0JTIwJTNEJTIwTGVSb2JvdERhdGFzZXQuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMHJlcG9faWQlM0QlMjJteV9kYXRhc2V0JTIyJTJDJTBBJTIwJTIwJTIwJTIwZmVhdHVyZXMlM0RmaW5hbF9mZWF0dXJlcyUyQyUyMCUyMCUyMyUyMEtub3dzJTIwZXhhY3RseSUyMHdoYXQlMjBkYXRhJTIwdG8lMjBleHBlY3QlMEElMjAlMjAlMjAlMjAuLi4lMEEp",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.pipeline_features <span class="hljs-keyword">import</span> aggregate_pipeline_dataset_features

<span class="hljs-comment"># Start with robot&#x27;s raw features</span>
initial_features = create_initial_features(
    observation=robot.observation_features,  <span class="hljs-comment"># {&quot;joint_1.pos&quot;: float, &quot;camera_0&quot;: (480,640,3)}</span>
    action=robot.action_features            <span class="hljs-comment"># {&quot;joint_1.pos&quot;: float, &quot;gripper.pos&quot;: float}</span>
)

<span class="hljs-comment"># Apply processor pipeline to compute final features</span>
final_features = aggregate_pipeline_dataset_features(
    pipeline=my_processor_pipeline,
    initial_features=initial_features,
    use_videos=<span class="hljs-literal">True</span>
)

<span class="hljs-comment"># Use for dataset creation</span>
dataset = LeRobotDataset.create(
    repo_id=<span class="hljs-string">&quot;my_dataset&quot;</span>,
    features=final_features,  <span class="hljs-comment"># Knows exactly what data to expect</span>
    ...
)`,wrap:!1}}),Jt=new J({props:{title:"Common Processor Steps",local:"common-processor-steps",headingTag:"h2"}}),wt=new J({props:{title:"Essential Processors",local:"essential-processors",headingTag:"h3"}}),ut=new J({props:{title:"Next Steps",local:"next-steps",headingTag:"h3"}}),Ut=new J({props:{title:"Summary",local:"summary",headingTag:"h2"}}),vt=new Zs({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/introduction_processors.mdx"}}),{c(){T=o("meta"),gt=n(),Ct=o("p"),At=n(),c(j.$$.fragment),Zt=n(),c(u.$$.fragment),Gt=n(),h=o("p"),h.textContent=Qe,Rt=n(),U=o("p"),U.textContent=ze,_t=n(),b=o("p"),b.textContent=We,$t=n(),I=o("p"),I.innerHTML=ke,Nt=n(),f=o("p"),f.textContent=He,Vt=n(),c(v.$$.fragment),Et=n(),c(C.$$.fragment),Xt=n(),B=o("p"),B.textContent=Fe,Yt=n(),g=o("ul"),g.innerHTML=Se,Qt=n(),A=o("p"),A.textContent=Pe,zt=n(),c(Z.$$.fragment),Wt=n(),c(G.$$.fragment),kt=n(),R=o("p"),R.innerHTML=xe,Ht=n(),_=o("ul"),_.innerHTML=Le,Ft=n(),c($.$$.fragment),St=n(),N=o("p"),N.innerHTML=qe,Pt=n(),c(V.$$.fragment),xt=n(),E=o("p"),E.innerHTML=De,Lt=n(),X=o("p"),X.innerHTML=Ke,qt=n(),c(Y.$$.fragment),Dt=n(),Q=o("p"),Q.innerHTML=Oe,Kt=n(),c(z.$$.fragment),Ot=n(),c(W.$$.fragment),te=n(),k=o("p"),k.textContent=ts,ee=n(),H=o("table"),H.innerHTML=es,se=n(),F=o("p"),F.innerHTML=ss,le=n(),c(S.$$.fragment),ne=n(),P=o("p"),P.innerHTML=ls,ae=n(),c(x.$$.fragment),oe=n(),c(L.$$.fragment),ie=n(),q=o("p"),q.innerHTML=ns,re=n(),D=o("table"),D.innerHTML=as,ce=n(),K=o("p"),K.innerHTML=os,pe=n(),c(O.$$.fragment),Me=n(),tt=o("p"),tt.textContent=is,de=n(),et=o("p"),et.textContent=rs,ye=n(),c(st.$$.fragment),me=n(),c(lt.$$.fragment),Je=n(),nt=o("p"),nt.textContent=cs,Te=n(),c(at.$$.fragment),we=n(),c(ot.$$.fragment),je=n(),it=o("p"),it.innerHTML=ps,ue=n(),c(rt.$$.fragment),he=n(),ct=o("p"),ct.textContent=Ms,Ue=n(),pt=o("ul"),pt.innerHTML=ds,be=n(),c(Mt.$$.fragment),Ie=n(),c(dt.$$.fragment),fe=n(),yt=o("p"),yt.innerHTML=ys,ve=n(),c(mt.$$.fragment),Ce=n(),c(Jt.$$.fragment),Be=n(),Tt=o("p"),Tt.textContent=ms,ge=n(),c(wt.$$.fragment),Ae=n(),jt=o("ul"),jt.innerHTML=Js,Ze=n(),c(ut.$$.fragment),Ge=n(),ht=o("ul"),ht.innerHTML=Ts,Re=n(),c(Ut.$$.fragment),_e=n(),bt=o("p"),bt.textContent=ws,$e=n(),It=o("ul"),It.innerHTML=js,Ne=n(),ft=o("p"),ft.innerHTML=us,Ve=n(),c(vt.$$.fragment),Ee=n(),Bt=o("p"),this.h()},l(t){const e=Bs("svelte-u9bgzb",document.head);T=i(e,"META",{name:!0,content:!0}),e.forEach(s),gt=a(t),Ct=i(t,"P",{}),hs(Ct).forEach(s),At=a(t),p(j.$$.fragment,t),Zt=a(t),p(u.$$.fragment,t),Gt=a(t),h=i(t,"P",{"data-svelte-h":!0}),r(h)!=="svelte-1p4wxkn"&&(h.textContent=Qe),Rt=a(t),U=i(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-14636jx"&&(U.textContent=ze),_t=a(t),b=i(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1oobog8"&&(b.textContent=We),$t=a(t),I=i(t,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1ur6am2"&&(I.innerHTML=ke),Nt=a(t),f=i(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-1ka3nux"&&(f.textContent=He),Vt=a(t),p(v.$$.fragment,t),Et=a(t),p(C.$$.fragment,t),Xt=a(t),B=i(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1begaqk"&&(B.textContent=Fe),Yt=a(t),g=i(t,"UL",{"data-svelte-h":!0}),r(g)!=="svelte-1ladsw4"&&(g.innerHTML=Se),Qt=a(t),A=i(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-u7yi05"&&(A.textContent=Pe),zt=a(t),p(Z.$$.fragment,t),Wt=a(t),p(G.$$.fragment,t),kt=a(t),R=i(t,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1ppq2fo"&&(R.innerHTML=xe),Ht=a(t),_=i(t,"UL",{"data-svelte-h":!0}),r(_)!=="svelte-106dygg"&&(_.innerHTML=Le),Ft=a(t),p($.$$.fragment,t),St=a(t),N=i(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-8rfarm"&&(N.innerHTML=qe),Pt=a(t),p(V.$$.fragment,t),xt=a(t),E=i(t,"P",{"data-svelte-h":!0}),r(E)!=="svelte-13brd71"&&(E.innerHTML=De),Lt=a(t),X=i(t,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1mifbwe"&&(X.innerHTML=Ke),qt=a(t),p(Y.$$.fragment,t),Dt=a(t),Q=i(t,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-8mdwcy"&&(Q.innerHTML=Oe),Kt=a(t),p(z.$$.fragment,t),Ot=a(t),p(W.$$.fragment,t),te=a(t),k=i(t,"P",{"data-svelte-h":!0}),r(k)!=="svelte-wjgvgq"&&(k.textContent=ts),ee=a(t),H=i(t,"TABLE",{"data-svelte-h":!0}),r(H)!=="svelte-1gwm6ye"&&(H.innerHTML=es),se=a(t),F=i(t,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1tvtb9y"&&(F.innerHTML=ss),le=a(t),p(S.$$.fragment,t),ne=a(t),P=i(t,"P",{"data-svelte-h":!0}),r(P)!=="svelte-u5i30h"&&(P.innerHTML=ls),ae=a(t),p(x.$$.fragment,t),oe=a(t),p(L.$$.fragment,t),ie=a(t),q=i(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-1svxhl3"&&(q.innerHTML=ns),re=a(t),D=i(t,"TABLE",{"data-svelte-h":!0}),r(D)!=="svelte-5rwep8"&&(D.innerHTML=as),ce=a(t),K=i(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-fqoi61"&&(K.innerHTML=os),pe=a(t),p(O.$$.fragment,t),Me=a(t),tt=i(t,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-zzgjs2"&&(tt.textContent=is),de=a(t),et=i(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1bcvc84"&&(et.textContent=rs),ye=a(t),p(st.$$.fragment,t),me=a(t),p(lt.$$.fragment,t),Je=a(t),nt=i(t,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-1is1ww4"&&(nt.textContent=cs),Te=a(t),p(at.$$.fragment,t),we=a(t),p(ot.$$.fragment,t),je=a(t),it=i(t,"P",{"data-svelte-h":!0}),r(it)!=="svelte-1xj3b0m"&&(it.innerHTML=ps),ue=a(t),p(rt.$$.fragment,t),he=a(t),ct=i(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-np5mv2"&&(ct.textContent=Ms),Ue=a(t),pt=i(t,"UL",{"data-svelte-h":!0}),r(pt)!=="svelte-1yhmz2o"&&(pt.innerHTML=ds),be=a(t),p(Mt.$$.fragment,t),Ie=a(t),p(dt.$$.fragment,t),fe=a(t),yt=i(t,"P",{"data-svelte-h":!0}),r(yt)!=="svelte-6gv7sj"&&(yt.innerHTML=ys),ve=a(t),p(mt.$$.fragment,t),Ce=a(t),p(Jt.$$.fragment,t),Be=a(t),Tt=i(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-kvop2o"&&(Tt.textContent=ms),ge=a(t),p(wt.$$.fragment,t),Ae=a(t),jt=i(t,"UL",{"data-svelte-h":!0}),r(jt)!=="svelte-cbajy3"&&(jt.innerHTML=Js),Ze=a(t),p(ut.$$.fragment,t),Ge=a(t),ht=i(t,"UL",{"data-svelte-h":!0}),r(ht)!=="svelte-z1kkrk"&&(ht.innerHTML=Ts),Re=a(t),p(Ut.$$.fragment,t),_e=a(t),bt=i(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-kqr9xc"&&(bt.textContent=ws),$e=a(t),It=i(t,"UL",{"data-svelte-h":!0}),r(It)!=="svelte-tctthc"&&(It.innerHTML=js),Ne=a(t),ft=i(t,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-1eyaijl"&&(ft.innerHTML=us),Ve=a(t),p(vt.$$.fragment,t),Ee=a(t),Bt=i(t,"P",{}),hs(Bt).forEach(s),this.h()},h(){Us(T,"name","hf:doc:metadata"),Us(T,"content",Rs)},m(t,e){gs(document.head,T),l(t,gt,e),l(t,Ct,e),l(t,At,e),M(j,t,e),l(t,Zt,e),M(u,t,e),l(t,Gt,e),l(t,h,e),l(t,Rt,e),l(t,U,e),l(t,_t,e),l(t,b,e),l(t,$t,e),l(t,I,e),l(t,Nt,e),l(t,f,e),l(t,Vt,e),M(v,t,e),l(t,Et,e),M(C,t,e),l(t,Xt,e),l(t,B,e),l(t,Yt,e),l(t,g,e),l(t,Qt,e),l(t,A,e),l(t,zt,e),M(Z,t,e),l(t,Wt,e),M(G,t,e),l(t,kt,e),l(t,R,e),l(t,Ht,e),l(t,_,e),l(t,Ft,e),M($,t,e),l(t,St,e),l(t,N,e),l(t,Pt,e),M(V,t,e),l(t,xt,e),l(t,E,e),l(t,Lt,e),l(t,X,e),l(t,qt,e),M(Y,t,e),l(t,Dt,e),l(t,Q,e),l(t,Kt,e),M(z,t,e),l(t,Ot,e),M(W,t,e),l(t,te,e),l(t,k,e),l(t,ee,e),l(t,H,e),l(t,se,e),l(t,F,e),l(t,le,e),M(S,t,e),l(t,ne,e),l(t,P,e),l(t,ae,e),M(x,t,e),l(t,oe,e),M(L,t,e),l(t,ie,e),l(t,q,e),l(t,re,e),l(t,D,e),l(t,ce,e),l(t,K,e),l(t,pe,e),M(O,t,e),l(t,Me,e),l(t,tt,e),l(t,de,e),l(t,et,e),l(t,ye,e),M(st,t,e),l(t,me,e),M(lt,t,e),l(t,Je,e),l(t,nt,e),l(t,Te,e),M(at,t,e),l(t,we,e),M(ot,t,e),l(t,je,e),l(t,it,e),l(t,ue,e),M(rt,t,e),l(t,he,e),l(t,ct,e),l(t,Ue,e),l(t,pt,e),l(t,be,e),M(Mt,t,e),l(t,Ie,e),M(dt,t,e),l(t,fe,e),l(t,yt,e),l(t,ve,e),M(mt,t,e),l(t,Ce,e),M(Jt,t,e),l(t,Be,e),l(t,Tt,e),l(t,ge,e),M(wt,t,e),l(t,Ae,e),l(t,jt,e),l(t,Ze,e),M(ut,t,e),l(t,Ge,e),l(t,ht,e),l(t,Re,e),M(Ut,t,e),l(t,_e,e),l(t,bt,e),l(t,$e,e),l(t,It,e),l(t,Ne,e),l(t,ft,e),l(t,Ve,e),M(vt,t,e),l(t,Ee,e),l(t,Bt,e),Xe=!0},p:Is,i(t){Xe||(d(j.$$.fragment,t),d(u.$$.fragment,t),d(v.$$.fragment,t),d(C.$$.fragment,t),d(Z.$$.fragment,t),d(G.$$.fragment,t),d($.$$.fragment,t),d(V.$$.fragment,t),d(Y.$$.fragment,t),d(z.$$.fragment,t),d(W.$$.fragment,t),d(S.$$.fragment,t),d(x.$$.fragment,t),d(L.$$.fragment,t),d(O.$$.fragment,t),d(st.$$.fragment,t),d(lt.$$.fragment,t),d(at.$$.fragment,t),d(ot.$$.fragment,t),d(rt.$$.fragment,t),d(Mt.$$.fragment,t),d(dt.$$.fragment,t),d(mt.$$.fragment,t),d(Jt.$$.fragment,t),d(wt.$$.fragment,t),d(ut.$$.fragment,t),d(Ut.$$.fragment,t),d(vt.$$.fragment,t),Xe=!0)},o(t){y(j.$$.fragment,t),y(u.$$.fragment,t),y(v.$$.fragment,t),y(C.$$.fragment,t),y(Z.$$.fragment,t),y(G.$$.fragment,t),y($.$$.fragment,t),y(V.$$.fragment,t),y(Y.$$.fragment,t),y(z.$$.fragment,t),y(W.$$.fragment,t),y(S.$$.fragment,t),y(x.$$.fragment,t),y(L.$$.fragment,t),y(O.$$.fragment,t),y(st.$$.fragment,t),y(lt.$$.fragment,t),y(at.$$.fragment,t),y(ot.$$.fragment,t),y(rt.$$.fragment,t),y(Mt.$$.fragment,t),y(dt.$$.fragment,t),y(mt.$$.fragment,t),y(Jt.$$.fragment,t),y(wt.$$.fragment,t),y(ut.$$.fragment,t),y(Ut.$$.fragment,t),y(vt.$$.fragment,t),Xe=!1},d(t){t&&(s(gt),s(Ct),s(At),s(Zt),s(Gt),s(h),s(Rt),s(U),s(_t),s(b),s($t),s(I),s(Nt),s(f),s(Vt),s(Et),s(Xt),s(B),s(Yt),s(g),s(Qt),s(A),s(zt),s(Wt),s(kt),s(R),s(Ht),s(_),s(Ft),s(St),s(N),s(Pt),s(xt),s(E),s(Lt),s(X),s(qt),s(Dt),s(Q),s(Kt),s(Ot),s(te),s(k),s(ee),s(H),s(se),s(F),s(le),s(ne),s(P),s(ae),s(oe),s(ie),s(q),s(re),s(D),s(ce),s(K),s(pe),s(Me),s(tt),s(de),s(et),s(ye),s(me),s(Je),s(nt),s(Te),s(we),s(je),s(it),s(ue),s(he),s(ct),s(Ue),s(pt),s(be),s(Ie),s(fe),s(yt),s(ve),s(Ce),s(Be),s(Tt),s(ge),s(Ae),s(jt),s(Ze),s(Ge),s(ht),s(Re),s(_e),s(bt),s($e),s(It),s(Ne),s(ft),s(Ve),s(Ee),s(Bt)),s(T),m(j,t),m(u,t),m(v,t),m(C,t),m(Z,t),m(G,t),m($,t),m(V,t),m(Y,t),m(z,t),m(W,t),m(S,t),m(x,t),m(L,t),m(O,t),m(st,t),m(lt,t),m(at,t),m(ot,t),m(rt,t),m(Mt,t),m(dt,t),m(mt,t),m(Jt,t),m(wt,t),m(ut,t),m(Ut,t),m(vt,t)}}}const Rs='{"title":"Introduction to Processors","local":"introduction-to-processors","sections":[{"title":"What are Processors?","local":"what-are-processors","sections":[],"depth":2},{"title":"Core Concepts","local":"core-concepts","sections":[{"title":"EnvTransition: The Universal Data Container","local":"envtransition-the-universal-data-container","sections":[],"depth":3},{"title":"ProcessorStep: The Building Block","local":"processorstep-the-building-block","sections":[],"depth":3},{"title":"DataProcessorPipeline: The Generic Orchestrator","local":"dataprocessorpipeline-the-generic-orchestrator","sections":[],"depth":3}],"depth":2},{"title":"RobotProcessorPipeline vs PolicyProcessorPipeline","local":"robotprocessorpipeline-vs-policyprocessorpipeline","sections":[],"depth":2},{"title":"Converter Functions","local":"converter-functions","sections":[],"depth":2},{"title":"Processor Examples","local":"processor-examples","sections":[{"title":"An interaction between a robot and a policy with processors","local":"an-interaction-between-a-robot-and-a-policy-with-processors","sections":[],"depth":3}],"depth":2},{"title":"Feature Contracts: Shape and Type Transformation","local":"feature-contracts-shape-and-type-transformation","sections":[{"title":"Why Feature Contracts Matter","local":"why-feature-contracts-matter","sections":[],"depth":3},{"title":"Feature Specification Functions","local":"feature-specification-functions","sections":[],"depth":3}],"depth":2},{"title":"Common Processor Steps","local":"common-processor-steps","sections":[{"title":"Essential Processors","local":"essential-processors","sections":[],"depth":3},{"title":"Next Steps","local":"next-steps","sections":[],"depth":3}],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function _s(Ye){return fs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ys extends vs{constructor(T){super(),Cs(this,T,_s,Gs,bs,{})}}export{Ys as component};
