import{s as Is,n as js,o as vs}from"../chunks/scheduler.eb244325.js";import{S as Cs,i as Zs,e as i,s as l,c as m,h as $s,a as o,d as s,b as n,f as gs,g as p,j as r,k as Us,u,l as Rs,m as a,n as d,t as M,o as c,p as J}from"../chunks/index.3fe63ad3.js";import{C as Bs}from"../chunks/CopyLLMTxtMenu.08242e11.js";import{C as vt}from"../chunks/CodeBlock.91baa5b4.js";import{H as T,E as Xs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.234c3f85.js";function zs(Ee){let f,$t,Ct,Rt,h,Bt,b,Xt,g,He="<code>LeRobotDataset v3.0</code> is a standardized format for robot learning data. It provides unified access to multi-modal time-series data, sensorimotor signals and multi‑camera video, as well as rich metadata for indexing, search, and visualization on the Hugging Face Hub.",zt,U,Le="This docs will guide you to:",Gt,I,ke="<li>Understand the v3.0 design and directory layout</li> <li>Record a dataset and push it to the Hub</li> <li>Load datasets for training with <code>LeRobotDataset</code></li> <li>Stream datasets without downloading using <code>StreamingLeRobotDataset</code></li> <li>Apply image transforms for data augmentation during training</li> <li>Migrate existing <code>v2.1</code> datasets to <code>v3.0</code></li>",Wt,j,Vt,v,xe="<li><strong>File-based storage</strong>: Many episodes per Parquet/MP4 file (v2 used one file per episode).</li> <li><strong>Relational metadata</strong>: Episode boundaries and lookups are resolved through metadata, not filenames.</li> <li><strong>Hub-native streaming</strong>: Consume datasets directly from the Hub with <code>StreamingLeRobotDataset</code>.</li> <li><strong>Lower file-system pressure</strong>: Fewer, larger files ⇒ faster initialization and fewer issues at scale.</li> <li><strong>Unified organization</strong>: Clean directory layout with consistent path templates across data and videos.</li>",Qt,C,Nt,Z,Se="<code>LeRobotDataset v3.0</code> will be included in <code>lerobot &gt;= 0.4.0</code>.",Yt,$,_e='Until that stable release, you can use the main branch by following the <a href="./installation#from-source">build from source instructions</a>.',Et,R,Ht,B,Fe="Run the command below to record a dataset with the SO-101 and push to the Hub:",Lt,X,kt,z,Ae='See the <a href="./il_robots#record-a-dataset">recording guide</a> for more details.',xt,G,St,W,De="A core v3 principle is <strong>decoupling storage from the user API</strong>: data is stored efficiently (few large files), while the public API exposes intuitive episode-level access.",_t,V,qe="<code>v3</code> has three pillars:",Ft,Q,Pe="<li><strong>Tabular data</strong>: Low‑dimensional, high‑frequency signals (states, actions, timestamps) stored in <strong>Apache Parquet</strong>. Access is memory‑mapped or streamed via the <code>datasets</code> stack.</li> <li><strong>Visual data</strong>: Camera frames concatenated and encoded into <strong>MP4</strong>. Frames from the same episode are grouped; videos are sharded per camera for practical sizes.</li> <li><strong>Metadata</strong>: JSON/Parquet records describing schema (feature names, dtypes, shapes), frame rates, normalization stats, and <strong>episode segmentation</strong> (start/end offsets into shared Parquet/MP4 files).</li>",At,N,Ke="<p>To scale to millions of episodes, tabular rows and video frames from multiple episodes are <strong>concatenated</strong> into larger files. Episode‑specific views are reconstructed <strong>via metadata</strong>, not file boundaries.</p>",Dt,y,Oe='<figure style="margin:0; text-align:center;"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobotdataset-v3/asset1datasetv3.png" alt="LeRobotDataset v3 diagram" width="220"/> <figcaption style="font-size:0.9em; color:#666;">From episode‑based to file‑based datasets</figcaption></figure>',qt,Y,Pt,E,ts="<li><strong><code>meta/info.json</code></strong>: canonical schema (features, shapes/dtypes), FPS, codebase version, and <strong>path templates</strong> to locate data/video shards.</li> <li><strong><code>meta/stats.json</code></strong>: global feature statistics (mean/std/min/max) used for normalization; exposed as <code>dataset.meta.stats</code>.</li> <li><strong><code>meta/tasks.jsonl</code></strong>: natural‑language task descriptions mapped to integer IDs for task‑conditioned policies.</li> <li><strong><code>meta/episodes/</code></strong>: per‑episode records (lengths, tasks, offsets) stored as <strong>chunked Parquet</strong> for scalability.</li> <li><strong><code>data/</code></strong>: frame‑by‑frame <strong>Parquet</strong> shards; each file typically contains <strong>many episodes</strong>.</li> <li><strong><code>videos/</code></strong>: <strong>MP4</strong> shards per camera; each file typically contains <strong>many episodes</strong>.</li>",Kt,H,Ot,L,es="<code>LeRobotDataset</code> returns Python dictionaries of PyTorch tensors and integrates with <code>torch.utils.data.DataLoader</code>. Here is a code example showing its use:",te,k,ee,x,se,S,ss="Use <code>StreamingLeRobotDataset</code> to iterate directly from the Hub without local copies. This allows to stream large datasets without the need to downloading them onto disk or loading them onto memory, and is a key feature of the new dataset format.",ae,_,le,w,as='<figure style="margin:0; text-align:center;"><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/lerobotdataset-v3/streaming-lerobot.png" alt="StreamingLeRobotDataset" width="520"/> <figcaption style="font-size:0.9em; color:#666;">Stream directly from the Hub for on‑the‑fly training.</figcaption></figure>',ne,F,ie,A,ls="Image transforms are data augmentations applied to camera frames during training to improve model robustness and generalization. LeRobot supports various transforms including brightness, contrast, saturation, hue, and sharpness adjustments.",oe,D,re,q,ns="Currently, transforms are applied during <strong>training time only</strong>, not during recording. When you create or record a dataset, the raw images are stored without transforms. This allows you to experiment with different augmentations later without re-recording data.",me,P,pe,K,is="Use the <code>image_transforms</code> parameter when loading a dataset for training:",de,O,Me,tt,ce,et,os="LeRobot provides several transform types:",Je,st,rs="<li><strong><code>ColorJitter</code></strong>: Adjusts brightness, contrast, saturation, and hue</li> <li><strong><code>SharpnessJitter</code></strong>: Randomly adjusts image sharpness</li> <li><strong><code>Identity</code></strong>: No transformation (useful for testing)</li>",Te,at,ms="You can also use any <code>torchvision.transforms.v2</code> transform by passing it directly to the <code>image_transforms</code> parameter.",ye,lt,we,nt,ps="<li><strong><code>enable</code></strong>: Enable/disable transforms (default: <code>False</code>)</li> <li><strong><code>max_num_transforms</code></strong>: Maximum number of transforms applied per frame (default: <code>3</code>)</li> <li><strong><code>random_order</code></strong>: Apply transforms in random order vs. standard order (default: <code>False</code>)</li> <li><strong><code>weight</code></strong>: Sampling probability for each transform (higher = more likely, if sum of weights is not 1, they will be normalized)</li> <li><strong><code>kwargs</code></strong>: Transform-specific parameters (e.g., brightness range)</li>",fe,it,ue,ot,ds="Use the visualization script to preview how transforms affect your data:",he,rt,be,mt,Ms="This saves example images showing the effect of each transform, helping you tune parameters.",ge,pt,Ue,dt,cs="<li><strong>Start conservative</strong>: Begin with small ranges (e.g., brightness 0.9-1.1) and increase gradually</li> <li><strong>Test first</strong>: Use the visualization script to ensure transforms look reasonable</li> <li><strong>Monitor training</strong>: Strong augmentations can hurt performance if too aggressive</li> <li><strong>Match your domain</strong>: If your robot operates in varying lighting, use brightness/contrast transforms</li> <li><strong>Combine wisely</strong>: Using too many transforms simultaneously can make training unstable</li>",Ie,Mt,je,ct,Js="A converter aggregates per‑episode files into larger shards and writes episode offsets/metadata. Convert your dataset using the instructions below.",ve,Jt,Ce,Tt,Ts="<strong>What it does</strong>",Ze,yt,ys="<li>Aggregates parquet files: <code>episode-0000.parquet</code>, <code>episode-0001.parquet</code>, … → <strong><code>file-0000.parquet</code></strong>, …</li> <li>Aggregates mp4 files: <code>episode-0000.mp4</code>, <code>episode-0001.mp4</code>, … → <strong><code>file-0000.mp4</code></strong>, …</li> <li>Updates <code>meta/episodes/*</code> (chunked Parquet) with per‑episode lengths, tasks, and byte/frame offsets.</li>",$e,wt,Re,ft,Be,ut,ws='When creating or recording datasets, you <strong>must</strong> call <code>dataset.finalize()</code> to properly close parquet writers. See the <a href="https://github.com/huggingface/lerobot/pull/1903" rel="nofollow">PR #1903</a> for more details.',Xe,ht,ze,bt,fs="<strong>Why is this necessary?</strong>",Ge,gt,us="Dataset v3.0 uses incremental parquet writing with buffered metadata for efficiency. The <code>finalize()</code> method:",We,Ut,hs="<li>Flushes any buffered episode metadata to disk</li> <li>Closes parquet writers to write footer metadata, otherwise the parquet files will be corrupt</li> <li>Ensures the dataset is valid for loading</li>",Ve,It,bs="Without calling <code>finalize()</code>, your parquet files will be incomplete and the dataset won’t load properly.",Qe,jt,Ne,Zt,Ye;return h=new Bs({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),b=new T({props:{title:"LeRobotDataset v3.0",local:"lerobotdataset-v30",headingTag:"h1"}}),j=new T({props:{title:"What’s new in v3",local:"whats-new-in-v3",headingTag:"h2"}}),C=new T({props:{title:"Installation",local:"installation",headingTag:"h2"}}),R=new T({props:{title:"Record a dataset",local:"record-a-dataset",headingTag:"h2"}}),X=new vt({props:{code:"bGVyb2JvdC1yZWNvcmQlMjAlNUMlMEElMjAlMjAtLXJvYm90LnR5cGUlM0RzbzEwMV9mb2xsb3dlciUyMCU1QyUwQSUyMCUyMC0tcm9ib3QucG9ydCUzRCUyRmRldiUyRnR0eS51c2Jtb2RlbTU4NUEwMDc2ODQxJTIwJTVDJTBBJTIwJTIwLS1yb2JvdC5pZCUzRG15X2F3ZXNvbWVfZm9sbG93ZXJfYXJtJTIwJTVDJTBBJTIwJTIwLS1yb2JvdC5jYW1lcmFzJTNEJTIyJTdCJTIwZnJvbnQlM0ElMjAlN0J0eXBlJTNBJTIwb3BlbmN2JTJDJTIwaW5kZXhfb3JfcGF0aCUzQSUyMDAlMkMlMjB3aWR0aCUzQSUyMDE5MjAlMkMlMjBoZWlnaHQlM0ElMjAxMDgwJTJDJTIwZnBzJTNBJTIwMzAlN0QlN0QlMjIlMjAlNUMlMEElMjAlMjAtLXRlbGVvcC50eXBlJTNEc28xMDFfbGVhZGVyJTIwJTVDJTBBJTIwJTIwLS10ZWxlb3AucG9ydCUzRCUyRmRldiUyRnR0eS51c2Jtb2RlbTU4NzYwNDMxNTUxJTIwJTVDJTBBJTIwJTIwLS10ZWxlb3AuaWQlM0RteV9hd2Vzb21lX2xlYWRlcl9hcm0lMjAlNUMlMEElMjAlMjAtLWRpc3BsYXlfZGF0YSUzRHRydWUlMjAlNUMlMEElMjAlMjAtLWRhdGFzZXQucmVwb19pZCUzRCUyNCU3QkhGX1VTRVIlN0QlMkZyZWNvcmQtdGVzdCUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldC5udW1fZXBpc29kZXMlM0Q1JTIwJTVDJTBBJTIwJTIwLS1kYXRhc2V0LnNpbmdsZV90YXNrJTNEJTIyR3JhYiUyMHRoZSUyMGJsYWNrJTIwY3ViZSUyMg==",highlighted:`lerobot-record \\
  --robot.type=so101_follower \\
  --robot.port=/dev/tty.usbmodem585A0076841 \\
  --robot.id=my_awesome_follower_arm \\
  --robot.cameras=<span class="hljs-string">&quot;{ front: {type: opencv, index_or_path: 0, width: 1920, height: 1080, fps: 30}}&quot;</span> \\
  --teleop.type=so101_leader \\
  --teleop.port=/dev/tty.usbmodem58760431551 \\
  --teleop.id=my_awesome_leader_arm \\
  --display_data=<span class="hljs-literal">true</span> \\
  --dataset.repo_id=<span class="hljs-variable">\${HF_USER}</span>/record-test \\
  --dataset.num_episodes=5 \\
  --dataset.single_task=<span class="hljs-string">&quot;Grab the black cube&quot;</span>`,wrap:!1}}),G=new T({props:{title:"Format design",local:"format-design",headingTag:"h2"}}),Y=new T({props:{title:"Directory layout (simplified)",local:"directory-layout-simplified",headingTag:"h3"}}),H=new T({props:{title:"Load a dataset for training",local:"load-a-dataset-for-training",headingTag:"h2"}}),k=new vt({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> lerobot.datasets.lerobot_dataset <span class="hljs-keyword">import</span> LeRobotDataset

repo_id = <span class="hljs-string">&quot;yaak-ai/L2D-v3&quot;</span>

<span class="hljs-comment"># 1) Load from the Hub (cached locally)</span>
dataset = LeRobotDataset(repo_id)

<span class="hljs-comment"># 2) Random access by index</span>
sample = dataset[<span class="hljs-number">100</span>]
<span class="hljs-built_in">print</span>(sample)
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#   &#x27;observation.state&#x27;: tensor([...]),</span>
<span class="hljs-comment">#   &#x27;action&#x27;: tensor([...]),</span>
<span class="hljs-comment">#   &#x27;observation.images.front_left&#x27;: tensor([C, H, W]),</span>
<span class="hljs-comment">#   &#x27;timestamp&#x27;: tensor(1.234),</span>
<span class="hljs-comment">#   ...</span>
<span class="hljs-comment"># }</span>

<span class="hljs-comment"># 3) Temporal windows via delta_timestamps (seconds relative to t)</span>
delta_timestamps = {
    <span class="hljs-string">&quot;observation.images.front_left&quot;</span>: [-<span class="hljs-number">0.2</span>, -<span class="hljs-number">0.1</span>, <span class="hljs-number">0.0</span>]  <span class="hljs-comment"># 0.2s and 0.1s before current frame</span>
}

dataset = LeRobotDataset(repo_id, delta_timestamps=delta_timestamps)

<span class="hljs-comment"># Accessing an index now returns a stack for the specified key(s)</span>
sample = dataset[<span class="hljs-number">100</span>]
<span class="hljs-built_in">print</span>(sample[<span class="hljs-string">&quot;observation.images.front_left&quot;</span>].shape)  <span class="hljs-comment"># [T, C, H, W], where T=3</span>

<span class="hljs-comment"># 4) Wrap with a DataLoader for training</span>
batch_size = <span class="hljs-number">16</span>
data_loader = torch.utils.data.DataLoader(dataset, batch_size=batch_size)

device = <span class="hljs-string">&quot;cuda&quot;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> data_loader:
    observations = batch[<span class="hljs-string">&quot;observation.state&quot;</span>].to(device)
    actions = batch[<span class="hljs-string">&quot;action&quot;</span>].to(device)
    images = batch[<span class="hljs-string">&quot;observation.images.front_left&quot;</span>].to(device)
    <span class="hljs-comment"># model.forward(batch)</span>`,wrap:!1}}),x=new T({props:{title:"Stream a dataset (no downloads)",local:"stream-a-dataset-no-downloads",headingTag:"h2"}}),_=new vt({props:{code:"ZnJvbSUyMGxlcm9ib3QuZGF0YXNldHMuc3RyZWFtaW5nX2RhdGFzZXQlMjBpbXBvcnQlMjBTdHJlYW1pbmdMZVJvYm90RGF0YXNldCUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJ5YWFrLWFpJTJGTDJELXYzJTIyJTBBZGF0YXNldCUyMCUzRCUyMFN0cmVhbWluZ0xlUm9ib3REYXRhc2V0KHJlcG9faWQpJTIwJTIwJTIzJTIwc3RyZWFtcyUyMGRpcmVjdGx5JTIwZnJvbSUyMHRoZSUyMEh1Yg==",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.streaming_dataset <span class="hljs-keyword">import</span> StreamingLeRobotDataset

repo_id = <span class="hljs-string">&quot;yaak-ai/L2D-v3&quot;</span>
dataset = StreamingLeRobotDataset(repo_id)  <span class="hljs-comment"># streams directly from the Hub</span>`,wrap:!1}}),F=new T({props:{title:"Image transforms",local:"image-transforms",headingTag:"h2"}}),D=new T({props:{title:"Using transforms during dataset creation/recording",local:"using-transforms-during-dataset-creationrecording",headingTag:"h3"}}),P=new T({props:{title:"Adding transforms to existing datasets (API)",local:"adding-transforms-to-existing-datasets-api",headingTag:"h3"}}),O=new vt({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.lerobot_dataset <span class="hljs-keyword">import</span> LeRobotDataset
<span class="hljs-keyword">from</span> lerobot.datasets.transforms <span class="hljs-keyword">import</span> ImageTransforms, ImageTransformsConfig, ImageTransformConfig

<span class="hljs-comment"># Option 1: Use default transform configuration (disabled by default)</span>
transforms_config = ImageTransformsConfig(
    enable=<span class="hljs-literal">True</span>,  <span class="hljs-comment"># Enable transforms</span>
    max_num_transforms=<span class="hljs-number">3</span>,  <span class="hljs-comment"># Apply up to 3 transforms per frame</span>
    random_order=<span class="hljs-literal">False</span>,  <span class="hljs-comment"># Apply in standard order</span>
)
transforms = ImageTransforms(transforms_config)

dataset = LeRobotDataset(
    repo_id=<span class="hljs-string">&quot;your-username/your-dataset&quot;</span>,
    image_transforms=transforms
)

<span class="hljs-comment"># Option 2: Create custom transform configuration</span>
custom_transforms_config = ImageTransformsConfig(
    enable=<span class="hljs-literal">True</span>,
    max_num_transforms=<span class="hljs-number">2</span>,
    random_order=<span class="hljs-literal">True</span>,
    tfs={
        <span class="hljs-string">&quot;brightness&quot;</span>: ImageTransformConfig(
            weight=<span class="hljs-number">1.0</span>,
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;ColorJitter&quot;</span>,
            kwargs={<span class="hljs-string">&quot;brightness&quot;</span>: (<span class="hljs-number">0.7</span>, <span class="hljs-number">1.3</span>)}  <span class="hljs-comment"># Adjust brightness range</span>
        ),
        <span class="hljs-string">&quot;contrast&quot;</span>: ImageTransformConfig(
            weight=<span class="hljs-number">2.0</span>,  <span class="hljs-comment"># Higher weight = more likely to be selected</span>
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;ColorJitter&quot;</span>,
            kwargs={<span class="hljs-string">&quot;contrast&quot;</span>: (<span class="hljs-number">0.8</span>, <span class="hljs-number">1.2</span>)}
        ),
        <span class="hljs-string">&quot;sharpness&quot;</span>: ImageTransformConfig(
            weight=<span class="hljs-number">0.5</span>,  <span class="hljs-comment"># Lower weight = less likely to be selected</span>
            <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;SharpnessJitter&quot;</span>,
            kwargs={<span class="hljs-string">&quot;sharpness&quot;</span>: (<span class="hljs-number">0.3</span>, <span class="hljs-number">2.0</span>)}
        ),
    }
)

dataset = LeRobotDataset(
    repo_id=<span class="hljs-string">&quot;your-username/your-dataset&quot;</span>,
    image_transforms=ImageTransforms(custom_transforms_config)
)

<span class="hljs-comment"># Option 3: Use pure torchvision transforms</span>
<span class="hljs-keyword">from</span> torchvision.transforms <span class="hljs-keyword">import</span> v2

torchvision_transforms = v2.Compose([
    v2.ColorJitter(brightness=<span class="hljs-number">0.2</span>, contrast=<span class="hljs-number">0.2</span>, saturation=<span class="hljs-number">0.2</span>, hue=<span class="hljs-number">0.1</span>),
    v2.GaussianBlur(kernel_size=<span class="hljs-number">3</span>, sigma=(<span class="hljs-number">0.1</span>, <span class="hljs-number">2.0</span>)),
])

dataset = LeRobotDataset(
    repo_id=<span class="hljs-string">&quot;your-username/your-dataset&quot;</span>,
    image_transforms=torchvision_transforms
)`,wrap:!1}}),tt=new T({props:{title:"Available transform types",local:"available-transform-types",headingTag:"h3"}}),lt=new T({props:{title:"Configuration options",local:"configuration-options",headingTag:"h3"}}),it=new T({props:{title:"Visualizing transforms",local:"visualizing-transforms",headingTag:"h3"}}),rt=new vt({props:{code:"bGVyb2JvdC1pbWd0cmFuc2Zvcm0tdml6JTIwJTVDJTBBJTIwJTIwLS1yZXBvLWlkJTNEeW91ci11c2VybmFtZSUyRnlvdXItZGF0YXNldCUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0LWRpciUzRC4lMkZ0cmFuc2Zvcm1fZXhhbXBsZXMlMjAlNUMlMEElMjAlMjAtLW4tZXhhbXBsZXMlM0Q1",highlighted:`lerobot-imgtransform-viz \\
  --repo-id=your-username/your-dataset \\
  --output-dir=./transform_examples \\
  --n-examples=5`,wrap:!1}}),pt=new T({props:{title:"Best practices",local:"best-practices",headingTag:"h3"}}),Mt=new T({props:{title:"Migrate v2.1 → v3.0",local:"migrate-v21--v30",headingTag:"h2"}}),Jt=new vt({props:{code:"JTIzJTIwUHJlLXJlbGVhc2UlMjBidWlsZCUyMHdpdGglMjB2MyUyMHN1cHBvcnQlM0ElMEFwaXAlMjBpbnN0YWxsJTIwJTIyaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZsZXJvYm90JTJGYXJjaGl2ZSUyRjMzY2FkMzcwNTRjMmI1OTRjZWJhNTc0NjNlOGYxMWVlMzc0ZmE5M2MuemlwJTIyJTBBJTBBJTIzJTIwQ29udmVydCUyMGFuJTIwZXhpc3RpbmclMjB2Mi4xJTIwZGF0YXNldCUyMGhvc3RlZCUyMG9uJTIwdGhlJTIwSHViJTNBJTBBcHl0aG9uJTIwLW0lMjBsZXJvYm90LmRhdGFzZXRzLnYzMC5jb252ZXJ0X2RhdGFzZXRfdjIxX3RvX3YzMCUyMC0tcmVwby1pZCUzRCUzQ0hGX1VTRVIlMkZEQVRBU0VUX0lEJTNF",highlighted:`<span class="hljs-comment"># Pre-release build with v3 support:</span>
pip install <span class="hljs-string">&quot;https://github.com/huggingface/lerobot/archive/33cad37054c2b594ceba57463e8f11ee374fa93c.zip&quot;</span>

<span class="hljs-comment"># Convert an existing v2.1 dataset hosted on the Hub:</span>
python -m lerobot.datasets.v30.convert_dataset_v21_to_v30 --repo-id=&lt;HF_USER/DATASET_ID&gt;`,wrap:!1}}),wt=new T({props:{title:"Common Issues",local:"common-issues",headingTag:"h2"}}),ft=new T({props:{title:"Always call finalize() before pushing",local:"always-call-finalize-before-pushing",headingTag:"h3"}}),ht=new vt({props:{code:"ZnJvbSUyMGxlcm9ib3QuZGF0YXNldHMubGVyb2JvdF9kYXRhc2V0JTIwaW1wb3J0JTIwTGVSb2JvdERhdGFzZXQlMEElMEElMjMlMjBDcmVhdGUlMjBkYXRhc2V0JTIwYW5kJTIwcmVjb3JkJTIwZXBpc29kZXMlMEFkYXRhc2V0JTIwJTNEJTIwTGVSb2JvdERhdGFzZXQuY3JlYXRlKC4uLiklMEElMEFmb3IlMjBlcGlzb2RlJTIwaW4lMjByYW5nZShudW1fZXBpc29kZXMpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwUmVjb3JkJTIwZnJhbWVzJTBBJTIwJTIwJTIwJTIwZm9yJTIwZnJhbWUlMjBpbiUyMGVwaXNvZGVfZGF0YSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRhdGFzZXQuYWRkX2ZyYW1lKGZyYW1lKSUwQSUyMCUyMCUyMCUyMGRhdGFzZXQuc2F2ZV9lcGlzb2RlKCklMEElMEElMjMlMjBDYWxsJTIwZmluYWxpemUoKSUyMHdoZW4lMjBkb25lJTIwcmVjb3JkaW5nJTIwYW5kJTIwYmVmb3JlJTIwcHVzaF90b19odWIoKSUwQWRhdGFzZXQuZmluYWxpemUoKSUyMCUyMCUyMyUyMENsb3NlcyUyMHBhcnF1ZXQlMjB3cml0ZXJzJTJDJTIwd3JpdGVzJTIwbWV0YWRhdGElMjBmb290ZXJzJTBBZGF0YXNldC5wdXNoX3RvX2h1Yigp",highlighted:`<span class="hljs-keyword">from</span> lerobot.datasets.lerobot_dataset <span class="hljs-keyword">import</span> LeRobotDataset

<span class="hljs-comment"># Create dataset and record episodes</span>
dataset = LeRobotDataset.create(...)

<span class="hljs-keyword">for</span> episode <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_episodes):
    <span class="hljs-comment"># Record frames</span>
    <span class="hljs-keyword">for</span> frame <span class="hljs-keyword">in</span> episode_data:
        dataset.add_frame(frame)
    dataset.save_episode()

<span class="hljs-comment"># Call finalize() when done recording and before push_to_hub()</span>
dataset.finalize()  <span class="hljs-comment"># Closes parquet writers, writes metadata footers</span>
dataset.push_to_hub()`,wrap:!1}}),jt=new Xs({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/lerobot-dataset-v3.mdx"}}),{c(){f=i("meta"),$t=l(),Ct=i("p"),Rt=l(),m(h.$$.fragment),Bt=l(),m(b.$$.fragment),Xt=l(),g=i("p"),g.innerHTML=He,zt=l(),U=i("p"),U.textContent=Le,Gt=l(),I=i("ul"),I.innerHTML=ke,Wt=l(),m(j.$$.fragment),Vt=l(),v=i("ul"),v.innerHTML=xe,Qt=l(),m(C.$$.fragment),Nt=l(),Z=i("p"),Z.innerHTML=Se,Yt=l(),$=i("p"),$.innerHTML=_e,Et=l(),m(R.$$.fragment),Ht=l(),B=i("p"),B.textContent=Fe,Lt=l(),m(X.$$.fragment),kt=l(),z=i("p"),z.innerHTML=Ae,xt=l(),m(G.$$.fragment),St=l(),W=i("p"),W.innerHTML=De,_t=l(),V=i("p"),V.innerHTML=qe,Ft=l(),Q=i("ol"),Q.innerHTML=Pe,At=l(),N=i("blockquote"),N.innerHTML=Ke,Dt=l(),y=i("div"),y.innerHTML=Oe,qt=l(),m(Y.$$.fragment),Pt=l(),E=i("ul"),E.innerHTML=ts,Kt=l(),m(H.$$.fragment),Ot=l(),L=i("p"),L.innerHTML=es,te=l(),m(k.$$.fragment),ee=l(),m(x.$$.fragment),se=l(),S=i("p"),S.innerHTML=ss,ae=l(),m(_.$$.fragment),le=l(),w=i("div"),w.innerHTML=as,ne=l(),m(F.$$.fragment),ie=l(),A=i("p"),A.textContent=ls,oe=l(),m(D.$$.fragment),re=l(),q=i("p"),q.innerHTML=ns,me=l(),m(P.$$.fragment),pe=l(),K=i("p"),K.innerHTML=is,de=l(),m(O.$$.fragment),Me=l(),m(tt.$$.fragment),ce=l(),et=i("p"),et.textContent=os,Je=l(),st=i("ul"),st.innerHTML=rs,Te=l(),at=i("p"),at.innerHTML=ms,ye=l(),m(lt.$$.fragment),we=l(),nt=i("ul"),nt.innerHTML=ps,fe=l(),m(it.$$.fragment),ue=l(),ot=i("p"),ot.textContent=ds,he=l(),m(rt.$$.fragment),be=l(),mt=i("p"),mt.textContent=Ms,ge=l(),m(pt.$$.fragment),Ue=l(),dt=i("ul"),dt.innerHTML=cs,Ie=l(),m(Mt.$$.fragment),je=l(),ct=i("p"),ct.textContent=Js,ve=l(),m(Jt.$$.fragment),Ce=l(),Tt=i("p"),Tt.innerHTML=Ts,Ze=l(),yt=i("ul"),yt.innerHTML=ys,$e=l(),m(wt.$$.fragment),Re=l(),m(ft.$$.fragment),Be=l(),ut=i("p"),ut.innerHTML=ws,Xe=l(),m(ht.$$.fragment),ze=l(),bt=i("p"),bt.innerHTML=fs,Ge=l(),gt=i("p"),gt.innerHTML=us,We=l(),Ut=i("ul"),Ut.innerHTML=hs,Ve=l(),It=i("p"),It.innerHTML=bs,Qe=l(),m(jt.$$.fragment),Ne=l(),Zt=i("p"),this.h()},l(t){const e=$s("svelte-u9bgzb",document.head);f=o(e,"META",{name:!0,content:!0}),e.forEach(s),$t=n(t),Ct=o(t,"P",{}),gs(Ct).forEach(s),Rt=n(t),p(h.$$.fragment,t),Bt=n(t),p(b.$$.fragment,t),Xt=n(t),g=o(t,"P",{"data-svelte-h":!0}),r(g)!=="svelte-3itfuv"&&(g.innerHTML=He),zt=n(t),U=o(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1xhddzp"&&(U.textContent=Le),Gt=n(t),I=o(t,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-1fnyrqq"&&(I.innerHTML=ke),Wt=n(t),p(j.$$.fragment,t),Vt=n(t),v=o(t,"UL",{"data-svelte-h":!0}),r(v)!=="svelte-yef82f"&&(v.innerHTML=xe),Qt=n(t),p(C.$$.fragment,t),Nt=n(t),Z=o(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-eavsve"&&(Z.innerHTML=Se),Yt=n(t),$=o(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-r2q19"&&($.innerHTML=_e),Et=n(t),p(R.$$.fragment,t),Ht=n(t),B=o(t,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1p8f7kn"&&(B.textContent=Fe),Lt=n(t),p(X.$$.fragment,t),kt=n(t),z=o(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-3lpf0d"&&(z.innerHTML=Ae),xt=n(t),p(G.$$.fragment,t),St=n(t),W=o(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1n657sm"&&(W.innerHTML=De),_t=n(t),V=o(t,"P",{"data-svelte-h":!0}),r(V)!=="svelte-qbaryr"&&(V.innerHTML=qe),Ft=n(t),Q=o(t,"OL",{"data-svelte-h":!0}),r(Q)!=="svelte-1a0he5b"&&(Q.innerHTML=Pe),At=n(t),N=o(t,"BLOCKQUOTE",{"data-svelte-h":!0}),r(N)!=="svelte-krhs8x"&&(N.innerHTML=Ke),Dt=n(t),y=o(t,"DIV",{style:!0,"data-svelte-h":!0}),r(y)!=="svelte-y0whhl"&&(y.innerHTML=Oe),qt=n(t),p(Y.$$.fragment,t),Pt=n(t),E=o(t,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-1j4kpyj"&&(E.innerHTML=ts),Kt=n(t),p(H.$$.fragment,t),Ot=n(t),L=o(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-z0zvcd"&&(L.innerHTML=es),te=n(t),p(k.$$.fragment,t),ee=n(t),p(x.$$.fragment,t),se=n(t),S=o(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-gwwmls"&&(S.innerHTML=ss),ae=n(t),p(_.$$.fragment,t),le=n(t),w=o(t,"DIV",{style:!0,"data-svelte-h":!0}),r(w)!=="svelte-1vmyhrf"&&(w.innerHTML=as),ne=n(t),p(F.$$.fragment,t),ie=n(t),A=o(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1w8wpf9"&&(A.textContent=ls),oe=n(t),p(D.$$.fragment,t),re=n(t),q=o(t,"P",{"data-svelte-h":!0}),r(q)!=="svelte-xwvxkd"&&(q.innerHTML=ns),me=n(t),p(P.$$.fragment,t),pe=n(t),K=o(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-8fltgr"&&(K.innerHTML=is),de=n(t),p(O.$$.fragment,t),Me=n(t),p(tt.$$.fragment,t),ce=n(t),et=o(t,"P",{"data-svelte-h":!0}),r(et)!=="svelte-m1m28a"&&(et.textContent=os),Je=n(t),st=o(t,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-11w89ah"&&(st.innerHTML=rs),Te=n(t),at=o(t,"P",{"data-svelte-h":!0}),r(at)!=="svelte-1a3q8bx"&&(at.innerHTML=ms),ye=n(t),p(lt.$$.fragment,t),we=n(t),nt=o(t,"UL",{"data-svelte-h":!0}),r(nt)!=="svelte-1xb362i"&&(nt.innerHTML=ps),fe=n(t),p(it.$$.fragment,t),ue=n(t),ot=o(t,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-1eveown"&&(ot.textContent=ds),he=n(t),p(rt.$$.fragment,t),be=n(t),mt=o(t,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-jh2fe1"&&(mt.textContent=Ms),ge=n(t),p(pt.$$.fragment,t),Ue=n(t),dt=o(t,"UL",{"data-svelte-h":!0}),r(dt)!=="svelte-upu5j"&&(dt.innerHTML=cs),Ie=n(t),p(Mt.$$.fragment,t),je=n(t),ct=o(t,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-15s3b8u"&&(ct.textContent=Js),ve=n(t),p(Jt.$$.fragment,t),Ce=n(t),Tt=o(t,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-1z0frgp"&&(Tt.innerHTML=Ts),Ze=n(t),yt=o(t,"UL",{"data-svelte-h":!0}),r(yt)!=="svelte-1dwwoyp"&&(yt.innerHTML=ys),$e=n(t),p(wt.$$.fragment,t),Re=n(t),p(ft.$$.fragment,t),Be=n(t),ut=o(t,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-iztbu6"&&(ut.innerHTML=ws),Xe=n(t),p(ht.$$.fragment,t),ze=n(t),bt=o(t,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-1aymic3"&&(bt.innerHTML=fs),Ge=n(t),gt=o(t,"P",{"data-svelte-h":!0}),r(gt)!=="svelte-1c5lbj9"&&(gt.innerHTML=us),We=n(t),Ut=o(t,"UL",{"data-svelte-h":!0}),r(Ut)!=="svelte-1e6t8rw"&&(Ut.innerHTML=hs),Ve=n(t),It=o(t,"P",{"data-svelte-h":!0}),r(It)!=="svelte-1s04803"&&(It.innerHTML=bs),Qe=n(t),p(jt.$$.fragment,t),Ne=n(t),Zt=o(t,"P",{}),gs(Zt).forEach(s),this.h()},h(){Us(f,"name","hf:doc:metadata"),Us(f,"content",Gs),u(y,"display","flex"),u(y,"justify-content","center"),u(y,"gap","12px"),u(y,"flex-wrap","wrap"),u(w,"display","flex"),u(w,"justify-content","center"),u(w,"gap","12px"),u(w,"flex-wrap","wrap")},m(t,e){Rs(document.head,f),a(t,$t,e),a(t,Ct,e),a(t,Rt,e),d(h,t,e),a(t,Bt,e),d(b,t,e),a(t,Xt,e),a(t,g,e),a(t,zt,e),a(t,U,e),a(t,Gt,e),a(t,I,e),a(t,Wt,e),d(j,t,e),a(t,Vt,e),a(t,v,e),a(t,Qt,e),d(C,t,e),a(t,Nt,e),a(t,Z,e),a(t,Yt,e),a(t,$,e),a(t,Et,e),d(R,t,e),a(t,Ht,e),a(t,B,e),a(t,Lt,e),d(X,t,e),a(t,kt,e),a(t,z,e),a(t,xt,e),d(G,t,e),a(t,St,e),a(t,W,e),a(t,_t,e),a(t,V,e),a(t,Ft,e),a(t,Q,e),a(t,At,e),a(t,N,e),a(t,Dt,e),a(t,y,e),a(t,qt,e),d(Y,t,e),a(t,Pt,e),a(t,E,e),a(t,Kt,e),d(H,t,e),a(t,Ot,e),a(t,L,e),a(t,te,e),d(k,t,e),a(t,ee,e),d(x,t,e),a(t,se,e),a(t,S,e),a(t,ae,e),d(_,t,e),a(t,le,e),a(t,w,e),a(t,ne,e),d(F,t,e),a(t,ie,e),a(t,A,e),a(t,oe,e),d(D,t,e),a(t,re,e),a(t,q,e),a(t,me,e),d(P,t,e),a(t,pe,e),a(t,K,e),a(t,de,e),d(O,t,e),a(t,Me,e),d(tt,t,e),a(t,ce,e),a(t,et,e),a(t,Je,e),a(t,st,e),a(t,Te,e),a(t,at,e),a(t,ye,e),d(lt,t,e),a(t,we,e),a(t,nt,e),a(t,fe,e),d(it,t,e),a(t,ue,e),a(t,ot,e),a(t,he,e),d(rt,t,e),a(t,be,e),a(t,mt,e),a(t,ge,e),d(pt,t,e),a(t,Ue,e),a(t,dt,e),a(t,Ie,e),d(Mt,t,e),a(t,je,e),a(t,ct,e),a(t,ve,e),d(Jt,t,e),a(t,Ce,e),a(t,Tt,e),a(t,Ze,e),a(t,yt,e),a(t,$e,e),d(wt,t,e),a(t,Re,e),d(ft,t,e),a(t,Be,e),a(t,ut,e),a(t,Xe,e),d(ht,t,e),a(t,ze,e),a(t,bt,e),a(t,Ge,e),a(t,gt,e),a(t,We,e),a(t,Ut,e),a(t,Ve,e),a(t,It,e),a(t,Qe,e),d(jt,t,e),a(t,Ne,e),a(t,Zt,e),Ye=!0},p:js,i(t){Ye||(M(h.$$.fragment,t),M(b.$$.fragment,t),M(j.$$.fragment,t),M(C.$$.fragment,t),M(R.$$.fragment,t),M(X.$$.fragment,t),M(G.$$.fragment,t),M(Y.$$.fragment,t),M(H.$$.fragment,t),M(k.$$.fragment,t),M(x.$$.fragment,t),M(_.$$.fragment,t),M(F.$$.fragment,t),M(D.$$.fragment,t),M(P.$$.fragment,t),M(O.$$.fragment,t),M(tt.$$.fragment,t),M(lt.$$.fragment,t),M(it.$$.fragment,t),M(rt.$$.fragment,t),M(pt.$$.fragment,t),M(Mt.$$.fragment,t),M(Jt.$$.fragment,t),M(wt.$$.fragment,t),M(ft.$$.fragment,t),M(ht.$$.fragment,t),M(jt.$$.fragment,t),Ye=!0)},o(t){c(h.$$.fragment,t),c(b.$$.fragment,t),c(j.$$.fragment,t),c(C.$$.fragment,t),c(R.$$.fragment,t),c(X.$$.fragment,t),c(G.$$.fragment,t),c(Y.$$.fragment,t),c(H.$$.fragment,t),c(k.$$.fragment,t),c(x.$$.fragment,t),c(_.$$.fragment,t),c(F.$$.fragment,t),c(D.$$.fragment,t),c(P.$$.fragment,t),c(O.$$.fragment,t),c(tt.$$.fragment,t),c(lt.$$.fragment,t),c(it.$$.fragment,t),c(rt.$$.fragment,t),c(pt.$$.fragment,t),c(Mt.$$.fragment,t),c(Jt.$$.fragment,t),c(wt.$$.fragment,t),c(ft.$$.fragment,t),c(ht.$$.fragment,t),c(jt.$$.fragment,t),Ye=!1},d(t){t&&(s($t),s(Ct),s(Rt),s(Bt),s(Xt),s(g),s(zt),s(U),s(Gt),s(I),s(Wt),s(Vt),s(v),s(Qt),s(Nt),s(Z),s(Yt),s($),s(Et),s(Ht),s(B),s(Lt),s(kt),s(z),s(xt),s(St),s(W),s(_t),s(V),s(Ft),s(Q),s(At),s(N),s(Dt),s(y),s(qt),s(Pt),s(E),s(Kt),s(Ot),s(L),s(te),s(ee),s(se),s(S),s(ae),s(le),s(w),s(ne),s(ie),s(A),s(oe),s(re),s(q),s(me),s(pe),s(K),s(de),s(Me),s(ce),s(et),s(Je),s(st),s(Te),s(at),s(ye),s(we),s(nt),s(fe),s(ue),s(ot),s(he),s(be),s(mt),s(ge),s(Ue),s(dt),s(Ie),s(je),s(ct),s(ve),s(Ce),s(Tt),s(Ze),s(yt),s($e),s(Re),s(Be),s(ut),s(Xe),s(ze),s(bt),s(Ge),s(gt),s(We),s(Ut),s(Ve),s(It),s(Qe),s(Ne),s(Zt)),s(f),J(h,t),J(b,t),J(j,t),J(C,t),J(R,t),J(X,t),J(G,t),J(Y,t),J(H,t),J(k,t),J(x,t),J(_,t),J(F,t),J(D,t),J(P,t),J(O,t),J(tt,t),J(lt,t),J(it,t),J(rt,t),J(pt,t),J(Mt,t),J(Jt,t),J(wt,t),J(ft,t),J(ht,t),J(jt,t)}}}const Gs='{"title":"LeRobotDataset v3.0","local":"lerobotdataset-v30","sections":[{"title":"What’s new in v3","local":"whats-new-in-v3","sections":[],"depth":2},{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Record a dataset","local":"record-a-dataset","sections":[],"depth":2},{"title":"Format design","local":"format-design","sections":[{"title":"Directory layout (simplified)","local":"directory-layout-simplified","sections":[],"depth":3}],"depth":2},{"title":"Load a dataset for training","local":"load-a-dataset-for-training","sections":[],"depth":2},{"title":"Stream a dataset (no downloads)","local":"stream-a-dataset-no-downloads","sections":[],"depth":2},{"title":"Image transforms","local":"image-transforms","sections":[{"title":"Using transforms during dataset creation/recording","local":"using-transforms-during-dataset-creationrecording","sections":[],"depth":3},{"title":"Adding transforms to existing datasets (API)","local":"adding-transforms-to-existing-datasets-api","sections":[],"depth":3},{"title":"Available transform types","local":"available-transform-types","sections":[],"depth":3},{"title":"Configuration options","local":"configuration-options","sections":[],"depth":3},{"title":"Visualizing transforms","local":"visualizing-transforms","sections":[],"depth":3},{"title":"Best practices","local":"best-practices","sections":[],"depth":3}],"depth":2},{"title":"Migrate v2.1 → v3.0","local":"migrate-v21--v30","sections":[],"depth":2},{"title":"Common Issues","local":"common-issues","sections":[{"title":"Always call finalize() before pushing","local":"always-call-finalize-before-pushing","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ws(Ee){return vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Hs extends Cs{constructor(f){super(),Zs(this,f,Ws,zs,Is,{})}}export{Hs as component};
