import{s as gt,n as yt,o as ht}from"../chunks/scheduler.eb244325.js";import{S as wt,i as dt,e as s,s as n,c as p,h as $t,a as o,d as l,b as a,f as ut,g as c,j as r,k as ft,l as Tt,m as i,n as m,t as u,o as f,p as g}from"../chunks/index.3fe63ad3.js";import{C as Mt}from"../chunks/CopyLLMTxtMenu.08242e11.js";import{C as te}from"../chunks/CodeBlock.91baa5b4.js";import{H as y,E as Ut}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.234c3f85.js";function bt(Ye){let h,ne,le,ae,w,se,d,oe,$,Ze='This guide shows you how to train policies on multiple GPUs using <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Hugging Face Accelerate</a>.',re,T,pe,M,Fe="First, ensure you have accelerate installed:",ce,U,me,b,ue,J,ke="You can launch training in two ways:",fe,C,ge,_,Ae="You can specify all parameters directly in the command without running <code>accelerate config</code>:",ye,v,he,G,De="<strong>Key accelerate parameters:</strong>",we,x,Oe="<li><code>--multi_gpu</code>: Enable multi-GPU training</li> <li><code>--num_processes=2</code>: Number of GPUs to use</li> <li><code>--mixed_precision=fp16</code>: Use fp16 mixed precision (or <code>bf16</code> if supported)</li>",de,I,$e,L,qe="If you prefer to save your configuration, you can optionally configure accelerate for your hardware setup by running:",Te,j,Me,S,Ke="This interactive setup will ask you questions about your training environment (number of GPUs, mixed precision settings, etc.) and saves the configuration for future use. For a simple multi-GPU setup on a single machine, you can use these recommended settings:",Ue,R,et="<li>Compute environment: This machine</li> <li>Number of machines: 1</li> <li>Number of processes: (number of GPUs you want to use)</li> <li>GPU ids to use: (leave empty to use all)</li> <li>Mixed precision: fp16 or bf16 (recommended for faster training)</li>",be,N,tt="Then launch training with:",Je,H,Ce,W,_e,X,lt="When you launch training with accelerate:",ve,V,it="<li><strong>Automatic detection</strong>: LeRobot automatically detects if it’s running under accelerate</li> <li><strong>Data distribution</strong>: Your batch is automatically split across GPUs</li> <li><strong>Gradient synchronization</strong>: Gradients are synchronized across GPUs during backpropagation</li> <li><strong>Single process logging</strong>: Only the main process logs to wandb and saves checkpoints</li>",Ge,B,xe,z,nt="<strong>Important:</strong> LeRobot does <strong>NOT</strong> automatically scale learning rates or training steps based on the number of GPUs. This gives you full control over your training hyperparameters.",Ie,P,Le,Q,at=`Many distributed training frameworks automatically scale the learning rate by the number of GPUs (e.g., <code>lr = base_lr × num_gpus</code>).
However, LeRobot keeps the learning rate exactly as you specify it.`,je,E,Se,Y,st="If you want to scale your hyperparameters when using multiple GPUs, you should do it manually:",Re,Z,ot="<strong>Learning Rate Scaling:</strong>",Ne,F,He,k,rt="<strong>Training Steps Scaling:</strong>",We,A,pt="Since the effective batch size <code>bs</code> increases with multiple GPUs (batch_size × num_gpus), you may want to reduce the number of training steps proportionally:",Xe,D,Ve,O,Be,q,ct="<li>The <code>--policy.use_amp</code> flag in <code>lerobot-train</code> is only used when <strong>not</strong> running with accelerate. When using accelerate, mixed precision is controlled by accelerate’s configuration.</li> <li>Training logs, checkpoints, and hub uploads are only done by the main process to avoid conflicts. Non-main processes have console logging disabled to prevent duplicate output.</li> <li>The effective batch size is <code>batch_size × num_gpus</code>. If you use 4 GPUs with <code>--batch_size=8</code>, your effective batch size is 32.</li> <li>Learning rate scheduling is handled correctly across multiple processes—LeRobot sets <code>step_scheduler_with_optimizer=False</code> to prevent accelerate from adjusting scheduler steps based on the number of processes.</li> <li>When saving or pushing models, LeRobot automatically unwraps the model from accelerate’s distributed wrapper to ensure compatibility.</li> <li>WandB integration automatically initializes only on the main process, preventing multiple runs from being created.</li>",ze,K,mt='For more advanced configurations and troubleshooting, see the <a href="https://huggingface.co/docs/accelerate" rel="nofollow">Accelerate documentation</a>. If you want to learn more about how to train on a large number of GPUs, checkout this awesome guide: <a href="https://huggingface.co/spaces/nanotron/ultrascale-playbook" rel="nofollow">Ultrascale Playbook</a>.',Pe,ee,Qe,ie,Ee;return w=new Mt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),d=new y({props:{title:"Multi-GPU Training",local:"multi-gpu-training",headingTag:"h1"}}),T=new y({props:{title:"Installation",local:"installation",headingTag:"h2"}}),U=new te({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),b=new y({props:{title:"Training with Multiple GPUs",local:"training-with-multiple-gpus",headingTag:"h2"}}),C=new y({props:{title:"Option 1: Without config (specify parameters directly)",local:"option-1-without-config-specify-parameters-directly",headingTag:"h3"}}),v=new te({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMCU1QyUwQSUyMCUyMC0tbXVsdGlfZ3B1JTIwJTVDJTBBJTIwJTIwLS1udW1fcHJvY2Vzc2VzJTNEMiUyMCU1QyUwQSUyMCUyMCUyNCh3aGljaCUyMGxlcm9ib3QtdHJhaW4pJTIwJTVDJTBBJTIwJTIwLS1kYXRhc2V0LnJlcG9faWQlM0QlMjQlN0JIRl9VU0VSJTdEJTJGbXlfZGF0YXNldCUyMCU1QyUwQSUyMCUyMC0tcG9saWN5LnR5cGUlM0RhY3QlMjAlNUMlMEElMjAlMjAtLXBvbGljeS5yZXBvX2lkJTNEJTI0JTdCSEZfVVNFUiU3RCUyRm15X3RyYWluZWRfcG9saWN5JTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEb3V0cHV0cyUyRnRyYWluJTJGYWN0X211bHRpX2dwdSUyMCU1QyUwQSUyMCUyMC0tam9iX25hbWUlM0RhY3RfbXVsdGlfZ3B1JTIwJTVDJTBBJTIwJTIwLS13YW5kYi5lbmFibGUlM0R0cnVl",highlighted:`accelerate launch \\
  --multi_gpu \\
  --num_processes=2 \\
  $(<span class="hljs-built_in">which</span> lerobot-train) \\
  --dataset.repo_id=<span class="hljs-variable">\${HF_USER}</span>/my_dataset \\
  --policy.type=act \\
  --policy.repo_id=<span class="hljs-variable">\${HF_USER}</span>/my_trained_policy \\
  --output_dir=outputs/train/act_multi_gpu \\
  --job_name=act_multi_gpu \\
  --wandb.enable=<span class="hljs-literal">true</span>`,wrap:!1}}),I=new y({props:{title:"Option 2: Using accelerate config",local:"option-2-using-accelerate-config",headingTag:"h3"}}),j=new te({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),H=new te({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMCUyNCh3aGljaCUyMGxlcm9ib3QtdHJhaW4pJTIwJTVDJTBBJTIwJTIwLS1kYXRhc2V0LnJlcG9faWQlM0QlMjQlN0JIRl9VU0VSJTdEJTJGbXlfZGF0YXNldCUyMCU1QyUwQSUyMCUyMC0tcG9saWN5LnR5cGUlM0RhY3QlMjAlNUMlMEElMjAlMjAtLXBvbGljeS5yZXBvX2lkJTNEJTI0JTdCSEZfVVNFUiU3RCUyRm15X3RyYWluZWRfcG9saWN5JTIwJTVDJTBBJTIwJTIwLS1vdXRwdXRfZGlyJTNEb3V0cHV0cyUyRnRyYWluJTJGYWN0X211bHRpX2dwdSUyMCU1QyUwQSUyMCUyMC0tam9iX25hbWUlM0RhY3RfbXVsdGlfZ3B1JTIwJTVDJTBBJTIwJTIwLS13YW5kYi5lbmFibGUlM0R0cnVl",highlighted:`accelerate launch $(<span class="hljs-built_in">which</span> lerobot-train) \\
  --dataset.repo_id=<span class="hljs-variable">\${HF_USER}</span>/my_dataset \\
  --policy.type=act \\
  --policy.repo_id=<span class="hljs-variable">\${HF_USER}</span>/my_trained_policy \\
  --output_dir=outputs/train/act_multi_gpu \\
  --job_name=act_multi_gpu \\
  --wandb.enable=<span class="hljs-literal">true</span>`,wrap:!1}}),W=new y({props:{title:"How It Works",local:"how-it-works",headingTag:"h2"}}),B=new y({props:{title:"Learning Rate and Training Steps Scaling",local:"learning-rate-and-training-steps-scaling",headingTag:"h2"}}),P=new y({props:{title:"Why No Automatic Scaling?",local:"why-no-automatic-scaling",headingTag:"h3"}}),E=new y({props:{title:"When and How to Scale",local:"when-and-how-to-scale",headingTag:"h3"}}),F=new te({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMDIlMjBHUFVzJTIwd2l0aCUyMGxpbmVhciUyMExSJTIwc2NhbGluZyUwQSUyMyUyMEJhc2UlMjBMUiUzQSUyMDFlLTQlMkMlMjB3aXRoJTIwMiUyMEdQVXMlMjAtJTNFJTIwMmUtNCUwQWFjY2VsZXJhdGUlMjBsYXVuY2glMjAtLW51bV9wcm9jZXNzZXMlM0QyJTIwJTI0KHdoaWNoJTIwbGVyb2JvdC10cmFpbiklMjAlNUMlMEElMjAlMjAtLW9wdGltaXplci5sciUzRDJlLTQlMjAlNUMlMEElMjAlMjAtLWRhdGFzZXQucmVwb19pZCUzRGxlcm9ib3QlMkZwdXNodCUyMCU1QyUwQSUyMCUyMC0tcG9saWN5JTNEYWN0",highlighted:`<span class="hljs-comment"># Example: 2 GPUs with linear LR scaling</span>
<span class="hljs-comment"># Base LR: 1e-4, with 2 GPUs -&gt; 2e-4</span>
accelerate launch --num_processes=2 $(<span class="hljs-built_in">which</span> lerobot-train) \\
  --optimizer.lr=2e-4 \\
  --dataset.repo_id=lerobot/pusht \\
  --policy=act`,wrap:!1}}),D=new te({props:{code:"JTIzJTIwRXhhbXBsZSUzQSUyMDIlMjBHUFVzJTIwd2l0aCUyMGVmZmVjdGl2ZSUyMGJhdGNoJTIwc2l6ZSUyMDJ4JTIwbGFyZ2VyJTBBJTIzJTIwT3JpZ2luYWwlM0ElMjBiYXRjaF9zaXplJTNEOCUyQyUyMHN0ZXBzJTNEMTAwMDAwJTBBJTIzJTIwV2l0aCUyMDIlMjBHUFVzJTNBJTIwYmF0Y2hfc2l6ZSUzRDglMjAoMTYlMjBpbiUyMHRvdGFsKSUyQyUyMHN0ZXBzJTNENTAwMDAlMEFhY2NlbGVyYXRlJTIwbGF1bmNoJTIwLS1udW1fcHJvY2Vzc2VzJTNEMiUyMCUyNCh3aGljaCUyMGxlcm9ib3QtdHJhaW4pJTIwJTVDJTBBJTIwJTIwLS1iYXRjaF9zaXplJTNEOCUyMCU1QyUwQSUyMCUyMC0tc3RlcHMlM0Q1MDAwMCUyMCU1QyUwQSUyMCUyMC0tZGF0YXNldC5yZXBvX2lkJTNEbGVyb2JvdCUyRnB1c2h0JTIwJTVDJTBBJTIwJTIwLS1wb2xpY3klM0RhY3Q=",highlighted:`<span class="hljs-comment"># Example: 2 GPUs with effective batch size 2x larger</span>
<span class="hljs-comment"># Original: batch_size=8, steps=100000</span>
<span class="hljs-comment"># With 2 GPUs: batch_size=8 (16 in total), steps=50000</span>
accelerate launch --num_processes=2 $(<span class="hljs-built_in">which</span> lerobot-train) \\
  --batch_size=8 \\
  --steps=50000 \\
  --dataset.repo_id=lerobot/pusht \\
  --policy=act`,wrap:!1}}),O=new y({props:{title:"Notes",local:"notes",headingTag:"h2"}}),ee=new Ut({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/multi_gpu_training.mdx"}}),{c(){h=s("meta"),ne=n(),le=s("p"),ae=n(),p(w.$$.fragment),se=n(),p(d.$$.fragment),oe=n(),$=s("p"),$.innerHTML=Ze,re=n(),p(T.$$.fragment),pe=n(),M=s("p"),M.textContent=Fe,ce=n(),p(U.$$.fragment),me=n(),p(b.$$.fragment),ue=n(),J=s("p"),J.textContent=ke,fe=n(),p(C.$$.fragment),ge=n(),_=s("p"),_.innerHTML=Ae,ye=n(),p(v.$$.fragment),he=n(),G=s("p"),G.innerHTML=De,we=n(),x=s("ul"),x.innerHTML=Oe,de=n(),p(I.$$.fragment),$e=n(),L=s("p"),L.textContent=qe,Te=n(),p(j.$$.fragment),Me=n(),S=s("p"),S.textContent=Ke,Ue=n(),R=s("ul"),R.innerHTML=et,be=n(),N=s("p"),N.textContent=tt,Je=n(),p(H.$$.fragment),Ce=n(),p(W.$$.fragment),_e=n(),X=s("p"),X.textContent=lt,ve=n(),V=s("ol"),V.innerHTML=it,Ge=n(),p(B.$$.fragment),xe=n(),z=s("p"),z.innerHTML=nt,Ie=n(),p(P.$$.fragment),Le=n(),Q=s("p"),Q.innerHTML=at,je=n(),p(E.$$.fragment),Se=n(),Y=s("p"),Y.textContent=st,Re=n(),Z=s("p"),Z.innerHTML=ot,Ne=n(),p(F.$$.fragment),He=n(),k=s("p"),k.innerHTML=rt,We=n(),A=s("p"),A.innerHTML=pt,Xe=n(),p(D.$$.fragment),Ve=n(),p(O.$$.fragment),Be=n(),q=s("ul"),q.innerHTML=ct,ze=n(),K=s("p"),K.innerHTML=mt,Pe=n(),p(ee.$$.fragment),Qe=n(),ie=s("p"),this.h()},l(e){const t=$t("svelte-u9bgzb",document.head);h=o(t,"META",{name:!0,content:!0}),t.forEach(l),ne=a(e),le=o(e,"P",{}),ut(le).forEach(l),ae=a(e),c(w.$$.fragment,e),se=a(e),c(d.$$.fragment,e),oe=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1q21bfz"&&($.innerHTML=Ze),re=a(e),c(T.$$.fragment,e),pe=a(e),M=o(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-1sqasfs"&&(M.textContent=Fe),ce=a(e),c(U.$$.fragment,e),me=a(e),c(b.$$.fragment,e),ue=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1vye7mj"&&(J.textContent=ke),fe=a(e),c(C.$$.fragment,e),ge=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-3gdn0b"&&(_.innerHTML=Ae),ye=a(e),c(v.$$.fragment,e),he=a(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-f2fa6v"&&(G.innerHTML=De),we=a(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-aqgwg9"&&(x.innerHTML=Oe),de=a(e),c(I.$$.fragment,e),$e=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1b40wb9"&&(L.textContent=qe),Te=a(e),c(j.$$.fragment,e),Me=a(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1plecjh"&&(S.textContent=Ke),Ue=a(e),R=o(e,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1skdlw3"&&(R.innerHTML=et),be=a(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-p23sye"&&(N.textContent=tt),Je=a(e),c(H.$$.fragment,e),Ce=a(e),c(W.$$.fragment,e),_e=a(e),X=o(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-c2blf5"&&(X.textContent=lt),ve=a(e),V=o(e,"OL",{"data-svelte-h":!0}),r(V)!=="svelte-1tbs832"&&(V.innerHTML=it),Ge=a(e),c(B.$$.fragment,e),xe=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-rbj0qr"&&(z.innerHTML=nt),Ie=a(e),c(P.$$.fragment,e),Le=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-15zrztt"&&(Q.innerHTML=at),je=a(e),c(E.$$.fragment,e),Se=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-6v0wu4"&&(Y.textContent=st),Re=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1ppb592"&&(Z.innerHTML=ot),Ne=a(e),c(F.$$.fragment,e),He=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-lmqw9n"&&(k.innerHTML=rt),We=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-z9u3ey"&&(A.innerHTML=pt),Xe=a(e),c(D.$$.fragment,e),Ve=a(e),c(O.$$.fragment,e),Be=a(e),q=o(e,"UL",{"data-svelte-h":!0}),r(q)!=="svelte-1nirqzy"&&(q.innerHTML=ct),ze=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-qqmx1m"&&(K.innerHTML=mt),Pe=a(e),c(ee.$$.fragment,e),Qe=a(e),ie=o(e,"P",{}),ut(ie).forEach(l),this.h()},h(){ft(h,"name","hf:doc:metadata"),ft(h,"content",Jt)},m(e,t){Tt(document.head,h),i(e,ne,t),i(e,le,t),i(e,ae,t),m(w,e,t),i(e,se,t),m(d,e,t),i(e,oe,t),i(e,$,t),i(e,re,t),m(T,e,t),i(e,pe,t),i(e,M,t),i(e,ce,t),m(U,e,t),i(e,me,t),m(b,e,t),i(e,ue,t),i(e,J,t),i(e,fe,t),m(C,e,t),i(e,ge,t),i(e,_,t),i(e,ye,t),m(v,e,t),i(e,he,t),i(e,G,t),i(e,we,t),i(e,x,t),i(e,de,t),m(I,e,t),i(e,$e,t),i(e,L,t),i(e,Te,t),m(j,e,t),i(e,Me,t),i(e,S,t),i(e,Ue,t),i(e,R,t),i(e,be,t),i(e,N,t),i(e,Je,t),m(H,e,t),i(e,Ce,t),m(W,e,t),i(e,_e,t),i(e,X,t),i(e,ve,t),i(e,V,t),i(e,Ge,t),m(B,e,t),i(e,xe,t),i(e,z,t),i(e,Ie,t),m(P,e,t),i(e,Le,t),i(e,Q,t),i(e,je,t),m(E,e,t),i(e,Se,t),i(e,Y,t),i(e,Re,t),i(e,Z,t),i(e,Ne,t),m(F,e,t),i(e,He,t),i(e,k,t),i(e,We,t),i(e,A,t),i(e,Xe,t),m(D,e,t),i(e,Ve,t),m(O,e,t),i(e,Be,t),i(e,q,t),i(e,ze,t),i(e,K,t),i(e,Pe,t),m(ee,e,t),i(e,Qe,t),i(e,ie,t),Ee=!0},p:yt,i(e){Ee||(u(w.$$.fragment,e),u(d.$$.fragment,e),u(T.$$.fragment,e),u(U.$$.fragment,e),u(b.$$.fragment,e),u(C.$$.fragment,e),u(v.$$.fragment,e),u(I.$$.fragment,e),u(j.$$.fragment,e),u(H.$$.fragment,e),u(W.$$.fragment,e),u(B.$$.fragment,e),u(P.$$.fragment,e),u(E.$$.fragment,e),u(F.$$.fragment,e),u(D.$$.fragment,e),u(O.$$.fragment,e),u(ee.$$.fragment,e),Ee=!0)},o(e){f(w.$$.fragment,e),f(d.$$.fragment,e),f(T.$$.fragment,e),f(U.$$.fragment,e),f(b.$$.fragment,e),f(C.$$.fragment,e),f(v.$$.fragment,e),f(I.$$.fragment,e),f(j.$$.fragment,e),f(H.$$.fragment,e),f(W.$$.fragment,e),f(B.$$.fragment,e),f(P.$$.fragment,e),f(E.$$.fragment,e),f(F.$$.fragment,e),f(D.$$.fragment,e),f(O.$$.fragment,e),f(ee.$$.fragment,e),Ee=!1},d(e){e&&(l(ne),l(le),l(ae),l(se),l(oe),l($),l(re),l(pe),l(M),l(ce),l(me),l(ue),l(J),l(fe),l(ge),l(_),l(ye),l(he),l(G),l(we),l(x),l(de),l($e),l(L),l(Te),l(Me),l(S),l(Ue),l(R),l(be),l(N),l(Je),l(Ce),l(_e),l(X),l(ve),l(V),l(Ge),l(xe),l(z),l(Ie),l(Le),l(Q),l(je),l(Se),l(Y),l(Re),l(Z),l(Ne),l(He),l(k),l(We),l(A),l(Xe),l(Ve),l(Be),l(q),l(ze),l(K),l(Pe),l(Qe),l(ie)),l(h),g(w,e),g(d,e),g(T,e),g(U,e),g(b,e),g(C,e),g(v,e),g(I,e),g(j,e),g(H,e),g(W,e),g(B,e),g(P,e),g(E,e),g(F,e),g(D,e),g(O,e),g(ee,e)}}}const Jt='{"title":"Multi-GPU Training","local":"multi-gpu-training","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Training with Multiple GPUs","local":"training-with-multiple-gpus","sections":[{"title":"Option 1: Without config (specify parameters directly)","local":"option-1-without-config-specify-parameters-directly","sections":[],"depth":3},{"title":"Option 2: Using accelerate config","local":"option-2-using-accelerate-config","sections":[],"depth":3}],"depth":2},{"title":"How It Works","local":"how-it-works","sections":[],"depth":2},{"title":"Learning Rate and Training Steps Scaling","local":"learning-rate-and-training-steps-scaling","sections":[{"title":"Why No Automatic Scaling?","local":"why-no-automatic-scaling","sections":[],"depth":3},{"title":"When and How to Scale","local":"when-and-how-to-scale","sections":[],"depth":3}],"depth":2},{"title":"Notes","local":"notes","sections":[],"depth":2}],"depth":1}';function Ct(Ye){return ht(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends wt{constructor(h){super(),dt(this,h,Ct,bt,gt,{})}}export{Lt as component};
