import{s as Js,n as gs,o as js}from"../chunks/scheduler.eb244325.js";import{S as cs,i as ws,e as m,s as a,c as i,h as Cs,a as U,d as l,b as n,f as Ts,g as M,j as u,k as Yt,l as fs,m as s,n as p,t as r,o,p as y}from"../chunks/index.3fe63ad3.js";import{C as $s}from"../chunks/CopyLLMTxtMenu.08242e11.js";import{C as T}from"../chunks/CodeBlock.91baa5b4.js";import{H as d,E as hs}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.234c3f85.js";function Is(Rl){let J,Ot,Wt,Pt,w,Kt,C,te,f,Gl="This tutorial explains how to port large-scale robotic datasets to the LeRobot Dataset v3.0 format. We’ll use the <strong>DROID 1.0.1</strong> dataset as our primary example, which demonstrates handling multi-terabyte datasets with thousands of shards across SLURM clusters.",ee,$,le,h,Zl="Dataset v3.0 fundamentally changes how data is organized and stored:",se,I,kl="<strong>v2.1 Structure (Episode-based)</strong>:",ae,b,ne,v,Sl="<strong>v3.0 Structure (File-based)</strong>:",ie,A,Me,R,ql="This transition from individual episode files to file-based chunks dramatically improves performance and reduces storage overhead.",pe,G,re,Z,Ql="Dataset v3.0 introduces significant improvements for handling large datasets:",oe,k,ye,S,Bl="<li><strong>File-based structure</strong>: Episodes are now grouped into chunked files rather than individual episode files</li> <li><strong>Configurable file sizes</strong>: for data and video files</li> <li><strong>Improved storage efficiency</strong>: Better compression and reduced overhead</li>",me,q,Ue,Q,Fl="<li><strong>Parquet-based metadata</strong>: Replaced JSON Lines with efficient parquet format</li> <li><strong>Structured episode access</strong>: Direct pandas DataFrame access via <code>dataset.meta.episodes</code></li> <li><strong>Per-episode statistics</strong>: Enhanced statistics tracking at episode level</li>",ue,B,de,F,Xl="<li><strong>Memory-mapped access</strong>: Improved RAM usage through PyArrow memory mapping</li> <li><strong>Faster loading</strong>: Significantly reduced dataset initialization time</li> <li><strong>Better scalability</strong>: Designed for datasets with millions of episodes</li>",Te,X,Je,x,xl="Before porting large datasets, ensure you have:",ge,N,Nl='<li><strong>LeRobot installed</strong> with v3.0 support. Follow our <a href="./installation">Installation Guide</a>.</li> <li><strong>Sufficient storage</strong>: Raw datasets can be very large (e.g., DROID requires 2TB)</li> <li><strong>Cluster access</strong> (recommended for large datasets): SLURM or similar job scheduler</li> <li><strong>Dataset-specific dependencies</strong>: For DROID, you’ll need TensorFlow Dataset utilities</li>',je,D,ce,z,Dl='<a href="https://droid-dataset.github.io/droid/the-droid-dataset" rel="nofollow">DROID 1.0.1</a> is an excellent example of a large-scale robotic dataset:',we,L,zl="<li><strong>Size</strong>: 1.7TB (RLDS format), 8.7TB (raw data)</li> <li><strong>Structure</strong>: 2048 pre-defined TensorFlow dataset shards</li> <li><strong>Content</strong>: 76,000+ robot manipulation trajectories from Franka Emika Panda robots</li> <li><strong>Scope</strong>: Real-world manipulation tasks across multiple environments and objects</li> <li><strong>Format</strong>: Originally in TensorFlow Records/RLDS format, requiring conversion to LeRobot format</li> <li><strong>Hosting</strong>: Google Cloud Storage with public access via <code>gsutil</code></li>",Ce,_,Ll="The dataset contains diverse manipulation demonstrations with:",fe,E,_l="<li>Multiple camera views (wrist camera, exterior cameras)</li> <li>Natural language task descriptions</li> <li>Robot proprioceptive state and actions</li> <li>Success/failure annotations</li>",$e,V,he,W,Ie,H,be,Y,ve,O,El="For DROID specifically:",Ae,P,Re,K,Vl="For other datasets, install the appropriate readers for your source format.",Ge,tt,Ze,et,Wl="Download DROID from Google Cloud Storage using <code>gsutil</code>:",ke,lt,Se,g,Hl="<p>Large datasets require substantial time and storage:</p> <ul><li><strong>Full DROID (1.7TB)</strong>: Several days to download depending on bandwidth</li> <li><strong>Processing time</strong>: 7+ days for local porting of full dataset</li> <li><strong>Upload time</strong>: 3+ days to push to Hugging Face Hub</li> <li><strong>Local storage</strong>: ~400GB for processed LeRobot format</li></ul>",qe,st,Qe,at,Be,nt,Fe,it,Yl="For development, you can port a single shard:",Xe,Mt,xe,pt,Ol="This approach works for smaller datasets or testing, but large datasets require cluster computing.",Ne,rt,De,ot,Pl="For large datasets like DROID, parallel processing across multiple nodes dramatically reduces processing time.",ze,yt,Le,mt,_e,Ut,Ee,ut,Kl="Find your partition information:",Ve,dt,We,Tt,ts="Choose a <strong>CPU partition</strong> - no GPU needed for dataset porting.",He,Jt,Ye,gt,Oe,jt,Pe,ct,es="<li><strong><code>--workers</code></strong>: Number of parallel jobs (max 2048 for DROID’s shard count)</li> <li><strong><code>--cpus-per-task</code></strong>: 8 CPUs recommended for frame encoding parallelization</li> <li><strong><code>--mem-per-cpu</code></strong>: ~16GB total RAM (8×1950M) for loading raw frames</li>",Ke,j,ls="<p>Start with fewer workers (e.g., 100) to test your cluster configuration before launching thousands of jobs.</p>",tl,wt,el,Ct,ss="Check running jobs:",ll,ft,sl,$t,as="Monitor overall progress:",al,ht,nl,It,ns="Inspect individual job logs:",il,bt,Ml,vt,is="Debug failed jobs:",pl,At,rl,Rt,ol,Gt,Ms="Once all porting jobs complete:",yl,Zt,ml,kt,Ul,St,ul,c,ps="<p>Upload uses fewer workers (50) since it’s network-bound rather than compute-bound.</p>",dl,qt,Tl,Qt,rs="Your completed dataset will have this modern structure:",Jl,Bt,gl,Ft,os="This replaces the old episode-per-file structure with efficient, optimally-sized chunks.",jl,Xt,cl,xt,ys="If you have existing datasets in v2.1 format, use the migration tool:",wl,Nt,Cl,Dt,ms="This automatically:",fl,zt,Us="<li>Converts file structure to v3.0 format</li> <li>Migrates metadata from JSON Lines to parquet</li> <li>Aggregates statistics and creates per-episode stats</li> <li>Updates version information</li>",$l,Lt,hl,_t,us="Dataset v3.0 provides significant improvements for large datasets:",Il,Et,ds="<li><strong>Faster loading</strong>: 3-5x reduction in initialization time</li> <li><strong>Memory efficiency</strong>: Better RAM usage through memory mapping</li> <li><strong>Scalable processing</strong>: Handles millions of episodes efficiently</li> <li><strong>Storage optimization</strong>: Reduced file count and improved compression</li>",bl,Vt,vl,Ht,Al;return w=new $s({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),C=new d({props:{title:"Porting Large Datasets to LeRobot Dataset v3.0",local:"porting-large-datasets-to-lerobot-dataset-v30",headingTag:"h1"}}),$=new d({props:{title:"File Organization: v2.1 vs v3.0",local:"file-organization-v21-vs-v30",headingTag:"h2"}}),b=new T({props:{code:"ZGF0YXNldCUyRiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRhdGElMkZjaHVuay0wMDAlMkZlcGlzb2RlXzAwMDAwMC5wYXJxdWV0JTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGF0YSUyRmNodW5rLTAwMCUyRmVwaXNvZGVfMDAwMDAxLnBhcnF1ZXQlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB2aWRlb3MlMkZjaHVuay0wMDAlMkZjYW1lcmElMkZlcGlzb2RlXzAwMDAwMC5tcDQlMEElRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBtZXRhJTJGZXBpc29kZXMuanNvbmw=",highlighted:`dataset/
├── data/chunk-000/episode_000000.parquet
├── data/chunk-000/episode_000001.parquet
├── videos/chunk-000/camera/episode_000000.mp4
└── meta/episodes.jsonl`,wrap:!1}}),A=new T({props:{code:"ZGF0YXNldCUyRiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMGRhdGElMkZjaHVuay0wMDAlMkZmaWxlLTAwMC5wYXJxdWV0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwTXVsdGlwbGUlMjBlcGlzb2RlcyUyMHBlciUyMGZpbGUlMEElRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB2aWRlb3MlMkZjYW1lcmElMkZjaHVuay0wMDAlMkZmaWxlLTAwMC5tcDQlMjAlMjAlMjAlMjMlMjBDb25zb2xpZGF0ZWQlMjB2aWRlbyUyMGNodW5rcyUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMG1ldGElMkZlcGlzb2RlcyUyRmNodW5rLTAwMCUyRmZpbGUtMDAwLnBhcnF1ZXQlMjAlMjAlMjMlMjBTdHJ1Y3R1cmVkJTIwbWV0YWRhdGE=",highlighted:`dataset/
├── data<span class="hljs-regexp">/chunk-000/</span>file-<span class="hljs-number">000</span>.parquet        <span class="hljs-comment"># Multiple episodes per file</span>
├── videos<span class="hljs-regexp">/camera/</span>chunk-<span class="hljs-number">000</span>/file-<span class="hljs-number">000</span>.mp4   <span class="hljs-comment"># Consolidated video chunks</span>
└── meta<span class="hljs-regexp">/episodes/</span>chunk-<span class="hljs-number">000</span>/file-<span class="hljs-number">000</span>.parquet  <span class="hljs-comment"># Structured metadata</span>`,wrap:!1}}),G=new d({props:{title:"What’s New in Dataset v3.0",local:"whats-new-in-dataset-v30",headingTag:"h2"}}),k=new d({props:{title:"🏗️ Enhanced File Organization",local:"-enhanced-file-organization",headingTag:"h3"}}),q=new d({props:{title:"📊 Modern Metadata Management",local:"-modern-metadata-management",headingTag:"h3"}}),B=new d({props:{title:"🚀 Performance Enhancements",local:"-performance-enhancements",headingTag:"h3"}}),X=new d({props:{title:"Prerequisites",local:"prerequisites",headingTag:"h2"}}),D=new d({props:{title:"Understanding the DROID Dataset",local:"understanding-the-droid-dataset",headingTag:"h2"}}),V=new d({props:{title:"DROID Features Schema",local:"droid-features-schema",headingTag:"h3"}}),W=new T({props:{code:"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",highlighted:`DROID_FEATURES = {
    <span class="hljs-comment"># Episode markers</span>
    <span class="hljs-string">&quot;is_first&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;bool&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">1</span>,)},
    <span class="hljs-string">&quot;is_last&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;bool&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">1</span>,)},
    <span class="hljs-string">&quot;is_terminal&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;bool&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">1</span>,)},

    <span class="hljs-comment"># Language instructions</span>
    <span class="hljs-string">&quot;language_instruction&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">1</span>,)},
    <span class="hljs-string">&quot;language_instruction_2&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">1</span>,)},
    <span class="hljs-string">&quot;language_instruction_3&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">1</span>,)},

    <span class="hljs-comment"># Robot state</span>
    <span class="hljs-string">&quot;observation.state.gripper_position&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;float32&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">1</span>,)},
    <span class="hljs-string">&quot;observation.state.cartesian_position&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;float32&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">6</span>,)},
    <span class="hljs-string">&quot;observation.state.joint_position&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;float32&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">7</span>,)},

    <span class="hljs-comment"># Camera observations</span>
    <span class="hljs-string">&quot;observation.images.wrist_left&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
    <span class="hljs-string">&quot;observation.images.exterior_1_left&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
    <span class="hljs-string">&quot;observation.images.exterior_2_left&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},

    <span class="hljs-comment"># Actions</span>
    <span class="hljs-string">&quot;action.gripper_position&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;float32&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">1</span>,)},
    <span class="hljs-string">&quot;action.cartesian_position&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;float32&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">6</span>,)},
    <span class="hljs-string">&quot;action.joint_position&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;float32&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">7</span>,)},

    <span class="hljs-comment"># Standard LeRobot format</span>
    <span class="hljs-string">&quot;observation.state&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;float32&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">8</span>,)},  <span class="hljs-comment"># joints + gripper</span>
    <span class="hljs-string">&quot;action&quot;</span>: {<span class="hljs-string">&quot;dtype&quot;</span>: <span class="hljs-string">&quot;float32&quot;</span>, <span class="hljs-string">&quot;shape&quot;</span>: (<span class="hljs-number">8</span>,)},  <span class="hljs-comment"># joints + gripper</span>
}`,wrap:!1}}),H=new d({props:{title:"Approach 1: Single Computer Porting",local:"approach-1-single-computer-porting",headingTag:"h2"}}),Y=new d({props:{title:"Step 1: Install Dependencies",local:"step-1-install-dependencies",headingTag:"h3"}}),P=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRlbnNvcmZsb3clMEFwaXAlMjBpbnN0YWxsJTIwdGVuc29yZmxvd19kYXRhc2V0cw==",highlighted:`pip install tensorflow
pip install tensorflow_datasets`,wrap:!1}}),tt=new d({props:{title:"Step 2: Download Raw Data",local:"step-2-download-raw-data",headingTag:"h3"}}),lt=new T({props:{code:"JTIzJTIwSW5zdGFsbCUyMEdvb2dsZSUyMENsb3VkJTIwU0RLJTIwaWYlMjBub3QlMjBhbHJlYWR5JTIwaW5zdGFsbGVkJTBBJTIzJTIwaHR0cHMlM0ElMkYlMkZjbG91ZC5nb29nbGUuY29tJTJGc2RrJTJGZG9jcyUyRmluc3RhbGwlMEElMEElMjMlMjBEb3dubG9hZCUyMHRoZSUyMGZ1bGwlMjBSTERTJTIwZGF0YXNldCUyMCgxLjdUQiklMEFnc3V0aWwlMjAtbSUyMGNwJTIwLXIlMjBncyUzQSUyRiUyRmdyZXNlYXJjaCUyRnJvYm90aWNzJTJGZHJvaWQlMkYxLjAuMSUyMCUyRnlvdXIlMkZkYXRhJTJGJTBBJTBBJTIzJTIwT3IlMjBkb3dubG9hZCUyMGp1c3QlMjB0aGUlMjAxMDAtZXBpc29kZSUyMHNhbXBsZSUyMCgyR0IpJTIwZm9yJTIwdGVzdGluZyUwQWdzdXRpbCUyMC1tJTIwY3AlMjAtciUyMGdzJTNBJTJGJTJGZ3Jlc2VhcmNoJTJGcm9ib3RpY3MlMkZkcm9pZF8xMDAlMjAlMkZ5b3VyJTJGZGF0YSUyRg==",highlighted:`<span class="hljs-comment"># Install Google Cloud SDK if not already installed</span>
<span class="hljs-comment"># https://cloud.google.com/sdk/docs/install</span>

<span class="hljs-comment"># Download the full RLDS dataset (1.7TB)</span>
gsutil -m <span class="hljs-built_in">cp</span> -r gs://gresearch/robotics/droid/1.0.1 /your/data/

<span class="hljs-comment"># Or download just the 100-episode sample (2GB) for testing</span>
gsutil -m <span class="hljs-built_in">cp</span> -r gs://gresearch/robotics/droid_100 /your/data/`,wrap:!1}}),st=new d({props:{title:"Step 3: Port the Dataset",local:"step-3-port-the-dataset",headingTag:"h3"}}),at=new T({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwb3J0X2RhdGFzZXRzJTJGcG9ydF9kcm9pZC5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmF3LWRpciUyMCUyRnlvdXIlMkZkYXRhJTJGZHJvaWQlMkYxLjAuMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwby1pZCUyMHlvdXJfaWQlMkZkcm9pZF8xLjAuMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcHVzaC10by1odWI=",highlighted:`python examples/port_datasets/port_droid.py \\
    --raw-dir /your/data/droid/1.0.1 \\
    --repo-id your_id/droid_1.0.1 \\
    --push-to-hub`,wrap:!1}}),nt=new d({props:{title:"Development and Testing",local:"development-and-testing",headingTag:"h3"}}),Mt=new T({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwb3J0X2RhdGFzZXRzJTJGcG9ydF9kcm9pZC5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmF3LWRpciUyMCUyRnlvdXIlMkZkYXRhJTJGZHJvaWQlMkYxLjAuMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwby1pZCUyMHlvdXJfaWQlMkZkcm9pZF8xLjAuMV90ZXN0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1udW0tc2hhcmRzJTIwMjA0OCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2hhcmQtaW5kZXglMjAw",highlighted:`python examples/port_datasets/port_droid.py \\
    --raw-dir /your/data/droid/1.0.1 \\
    --repo-id your_id/droid_1.0.1_test \\
    --num-shards 2048 \\
    --shard-index 0`,wrap:!1}}),rt=new d({props:{title:"Approach 2: SLURM Cluster Porting (Recommended)",local:"approach-2-slurm-cluster-porting-recommended",headingTag:"h2"}}),yt=new d({props:{title:"Step 1: Install Cluster Dependencies",local:"step-1-install-cluster-dependencies",headingTag:"h3"}}),mt=new T({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRhdGF0cm92ZSUyMCUyMCUyMyUyMEh1Z2dpbmclMjBGYWNlJ3MlMjBkaXN0cmlidXRlZCUyMHByb2Nlc3NpbmclMjBsaWJyYXJ5",highlighted:'pip install datatrove  <span class="hljs-comment"># Hugging Face&#x27;s distributed processing library</span>',wrap:!1}}),Ut=new d({props:{title:"Step 2: Configure Your SLURM Environment",local:"step-2-configure-your-slurm-environment",headingTag:"h3"}}),dt=new T({props:{code:"c2luZm8lMjAtLWZvcm1hdCUzRCUyMiUyNVIlMjIlMjAlMjAlMjMlMjBMaXN0JTIwYXZhaWxhYmxlJTIwcGFydGl0aW9ucyUwQXNpbmZvJTIwLU4lMjAtcCUyMHlvdXJfcGFydGl0aW9uJTIwLWglMjAtbyUyMCUyMiUyNU4lMjBjcHVzJTNEJTI1YyUyMG1lbSUzRCUyNW0lMjIlMjAlMjAlMjMlMjBDaGVjayUyMHJlc291cmNlcw==",highlighted:`sinfo --format=<span class="hljs-string">&quot;%R&quot;</span>  <span class="hljs-comment"># List available partitions</span>
sinfo -N -p your_partition -h -o <span class="hljs-string">&quot;%N cpus=%c mem=%m&quot;</span>  <span class="hljs-comment"># Check resources</span>`,wrap:!1}}),Jt=new d({props:{title:"Step 3: Launch Parallel Porting Jobs",local:"step-3-launch-parallel-porting-jobs",headingTag:"h3"}}),gt=new T({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwb3J0X2RhdGFzZXRzJTJGc2x1cm1fcG9ydF9zaGFyZHMucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJhdy1kaXIlMjAlMkZ5b3VyJTJGZGF0YSUyRmRyb2lkJTJGMS4wLjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlcG8taWQlMjB5b3VyX2lkJTJGZHJvaWRfMS4wLjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWxvZ3MtZGlyJTIwJTJGeW91ciUyRmxvZ3MlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWpvYi1uYW1lJTIwcG9ydF9kcm9pZCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGFydGl0aW9uJTIweW91cl9wYXJ0aXRpb24lMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdvcmtlcnMlMjAyMDQ4JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jcHVzLXBlci10YXNrJTIwOCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWVtLXBlci1jcHUlMjAxOTUwTQ==",highlighted:`python examples/port_datasets/slurm_port_shards.py \\
    --raw-dir /your/data/droid/1.0.1 \\
    --repo-id your_id/droid_1.0.1 \\
    --logs-dir /your/logs \\
    --job-name port_droid \\
    --partition your_partition \\
    --workers 2048 \\
    --cpus-per-task 8 \\
    --mem-per-cpu 1950M`,wrap:!1}}),jt=new d({props:{title:"Parameter Guidelines",local:"parameter-guidelines",headingTag:"h4"}}),wt=new d({props:{title:"Step 4: Monitor Progress",local:"step-4-monitor-progress",headingTag:"h3"}}),ft=new T({props:{code:"c3F1ZXVlJTIwLXUlMjAlMjRVU0VS",highlighted:'squeue -u <span class="hljs-variable">$USER</span>',wrap:!1}}),ht=new T({props:{code:"am9ic19zdGF0dXMlMjAlMkZ5b3VyJTJGbG9ncw==",highlighted:"jobs_status /your/logs",wrap:!1}}),bt=new T({props:{code:"bGVzcyUyMCUyRnlvdXIlMkZsb2dzJTJGcG9ydF9kcm9pZCUyRnNsdXJtX2pvYnMlMkZKT0JfSURfV09SS0VSX0lELm91dA==",highlighted:"less /your/logs/port_droid/slurm_jobs/JOB_ID_WORKER_ID.out",wrap:!1}}),At=new T({props:{code:"ZmFpbGVkX2xvZ3MlMjAlMkZ5b3VyJTJGbG9ncyUyRnBvcnRfZHJvaWQ=",highlighted:"failed_logs /your/logs/port_droid",wrap:!1}}),Rt=new d({props:{title:"Step 5: Aggregate Shards",local:"step-5-aggregate-shards",headingTag:"h3"}}),Zt=new T({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwb3J0X2RhdGFzZXRzJTJGc2x1cm1fYWdncmVnYXRlX3NoYXJkcy5weSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwby1pZCUyMHlvdXJfaWQlMkZkcm9pZF8xLjAuMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbG9ncy1kaXIlMjAlMkZ5b3VyJTJGbG9ncyUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tam9iLW5hbWUlMjBhZ2dyX2Ryb2lkJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wYXJ0aXRpb24lMjB5b3VyX3BhcnRpdGlvbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0td29ya2VycyUyMDIwNDglMjAlNUMlMEElMjAlMjAlMjAlMjAtLWNwdXMtcGVyLXRhc2slMjA4JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tZW0tcGVyLWNwdSUyMDE5NTBN",highlighted:`python examples/port_datasets/slurm_aggregate_shards.py \\
    --repo-id your_id/droid_1.0.1 \\
    --logs-dir /your/logs \\
    --job-name aggr_droid \\
    --partition your_partition \\
    --workers 2048 \\
    --cpus-per-task 8 \\
    --mem-per-cpu 1950M`,wrap:!1}}),kt=new d({props:{title:"Step 6: Upload to Hub",local:"step-6-upload-to-hub",headingTag:"h3"}}),St=new T({props:{code:"cHl0aG9uJTIwZXhhbXBsZXMlMkZwb3J0X2RhdGFzZXRzJTJGc2x1cm1fdXBsb2FkLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXBvLWlkJTIweW91cl9pZCUyRmRyb2lkXzEuMC4xJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sb2dzLWRpciUyMCUyRnlvdXIlMkZsb2dzJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1qb2ItbmFtZSUyMHVwbG9hZF9kcm9pZCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcGFydGl0aW9uJTIweW91cl9wYXJ0aXRpb24lMjAlNUMlMEElMjAlMjAlMjAlMjAtLXdvcmtlcnMlMjA1MCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY3B1cy1wZXItdGFzayUyMDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1lbS1wZXItY3B1JTIwMTk1ME0=",highlighted:`python examples/port_datasets/slurm_upload.py \\
    --repo-id your_id/droid_1.0.1 \\
    --logs-dir /your/logs \\
    --job-name upload_droid \\
    --partition your_partition \\
    --workers 50 \\
    --cpus-per-task 4 \\
    --mem-per-cpu 1950M`,wrap:!1}}),qt=new d({props:{title:"Dataset v3.0 File Structure",local:"dataset-v30-file-structure",headingTag:"h2"}}),Bt=new T({props:{code:"ZGF0YXNldCUyRiUwQSVFMiU5NCU5QyVFMiU5NCU4MCVFMiU5NCU4MCUyMG1ldGElMkYlMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjBlcGlzb2RlcyUyRiUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMGNodW5rLTAwMCUyRiUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU4MiUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMGZpbGUtMDAwLnBhcnF1ZXQlMjAlMjAlMjAlMjAlMjMlMjBFcGlzb2RlJTIwbWV0YWRhdGElMEElRTIlOTQlODIlMjAlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlRTIlOTQlODAlMjB0YXNrcy5wYXJxdWV0JTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVGFzayUyMGRlZmluaXRpb25zJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwc3RhdHMuanNvbiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMEFnZ3JlZ2F0ZWQlMjBzdGF0aXN0aWNzJTBBJUUyJTk0JTgyJTIwJTIwJTIwJUUyJTk0JTk0JUUyJTk0JTgwJUUyJTk0JTgwJTIwaW5mby5qc29uJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRGF0YXNldCUyMGluZm9ybWF0aW9uJTBBJUUyJTk0JTlDJUUyJTk0JTgwJUUyJTk0JTgwJTIwZGF0YSUyRiUwQSVFMiU5NCU4MiUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMGNodW5rLTAwMCUyRiUwQSVFMiU5NCU4MiUyMCUyMCUyMCUyMCUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMGZpbGUtMDAwLnBhcnF1ZXQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDb25zb2xpZGF0ZWQlMjBlcGlzb2RlJTIwZGF0YSUwQSVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMHZpZGVvcyUyRiUwQSUyMCUyMCUyMCUyMCVFMiU5NCU5NCVFMiU5NCU4MCVFMiU5NCU4MCUyMGNhbWVyYV9rZXklMkYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBjaHVuay0wMDAlMkYlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlRTIlOTQlOTQlRTIlOTQlODAlRTIlOTQlODAlMjBmaWxlLTAwMC5tcDQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBDb25zb2xpZGF0ZWQlMjB2aWRlbyUyMGZpbGVz",highlighted:`dataset/
├── meta/
│   ├── episodes/
│   │   └── chunk<span class="hljs-number">-000</span>/
│   │       └── <span class="hljs-built_in">file</span><span class="hljs-number">-000.</span>parquet    <span class="hljs-comment"># Episode metadata</span>
│   ├── tasks.parquet               <span class="hljs-comment"># Task definitions</span>
│   ├── stats.json                  <span class="hljs-comment"># Aggregated statistics</span>
│   └── info.json                   <span class="hljs-comment"># Dataset information</span>
├── data/
│   └── chunk<span class="hljs-number">-000</span>/
│       └── <span class="hljs-built_in">file</span><span class="hljs-number">-000.</span>parquet        <span class="hljs-comment"># Consolidated episode data</span>
└── videos/
    └── camera_key/
        └── chunk<span class="hljs-number">-000</span>/
            └── <span class="hljs-built_in">file</span><span class="hljs-number">-000.</span>mp4        <span class="hljs-comment"># Consolidated video files</span>`,wrap:!1}}),Xt=new d({props:{title:"Migrating from Dataset v2.1",local:"migrating-from-dataset-v21",headingTag:"h2"}}),Nt=new T({props:{code:"cHl0aG9uJTIwc3JjJTJGbGVyb2JvdCUyRmRhdGFzZXRzJTJGdjMwJTJGY29udmVydF9kYXRhc2V0X3YyMV90b192MzAucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXJlcG8taWQlMjB5b3VyX2lkJTJGZXhpc3RpbmdfZGF0YXNldA==",highlighted:`python src/lerobot/datasets/v30/convert_dataset_v21_to_v30.py \\
    --repo-id your_id/existing_dataset`,wrap:!1}}),Lt=new d({props:{title:"Performance Benefits",local:"performance-benefits",headingTag:"h2"}}),Vt=new hs({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/porting_datasets_v3.mdx"}}),{c(){J=m("meta"),Ot=a(),Wt=m("p"),Pt=a(),i(w.$$.fragment),Kt=a(),i(C.$$.fragment),te=a(),f=m("p"),f.innerHTML=Gl,ee=a(),i($.$$.fragment),le=a(),h=m("p"),h.textContent=Zl,se=a(),I=m("p"),I.innerHTML=kl,ae=a(),i(b.$$.fragment),ne=a(),v=m("p"),v.innerHTML=Sl,ie=a(),i(A.$$.fragment),Me=a(),R=m("p"),R.textContent=ql,pe=a(),i(G.$$.fragment),re=a(),Z=m("p"),Z.textContent=Ql,oe=a(),i(k.$$.fragment),ye=a(),S=m("ul"),S.innerHTML=Bl,me=a(),i(q.$$.fragment),Ue=a(),Q=m("ul"),Q.innerHTML=Fl,ue=a(),i(B.$$.fragment),de=a(),F=m("ul"),F.innerHTML=Xl,Te=a(),i(X.$$.fragment),Je=a(),x=m("p"),x.textContent=xl,ge=a(),N=m("ul"),N.innerHTML=Nl,je=a(),i(D.$$.fragment),ce=a(),z=m("p"),z.innerHTML=Dl,we=a(),L=m("ul"),L.innerHTML=zl,Ce=a(),_=m("p"),_.textContent=Ll,fe=a(),E=m("ul"),E.innerHTML=_l,$e=a(),i(V.$$.fragment),he=a(),i(W.$$.fragment),Ie=a(),i(H.$$.fragment),be=a(),i(Y.$$.fragment),ve=a(),O=m("p"),O.textContent=El,Ae=a(),i(P.$$.fragment),Re=a(),K=m("p"),K.textContent=Vl,Ge=a(),i(tt.$$.fragment),Ze=a(),et=m("p"),et.innerHTML=Wl,ke=a(),i(lt.$$.fragment),Se=a(),g=m("blockquote"),g.innerHTML=Hl,qe=a(),i(st.$$.fragment),Qe=a(),i(at.$$.fragment),Be=a(),i(nt.$$.fragment),Fe=a(),it=m("p"),it.textContent=Yl,Xe=a(),i(Mt.$$.fragment),xe=a(),pt=m("p"),pt.textContent=Ol,Ne=a(),i(rt.$$.fragment),De=a(),ot=m("p"),ot.textContent=Pl,ze=a(),i(yt.$$.fragment),Le=a(),i(mt.$$.fragment),_e=a(),i(Ut.$$.fragment),Ee=a(),ut=m("p"),ut.textContent=Kl,Ve=a(),i(dt.$$.fragment),We=a(),Tt=m("p"),Tt.innerHTML=ts,He=a(),i(Jt.$$.fragment),Ye=a(),i(gt.$$.fragment),Oe=a(),i(jt.$$.fragment),Pe=a(),ct=m("ul"),ct.innerHTML=es,Ke=a(),j=m("blockquote"),j.innerHTML=ls,tl=a(),i(wt.$$.fragment),el=a(),Ct=m("p"),Ct.textContent=ss,ll=a(),i(ft.$$.fragment),sl=a(),$t=m("p"),$t.textContent=as,al=a(),i(ht.$$.fragment),nl=a(),It=m("p"),It.textContent=ns,il=a(),i(bt.$$.fragment),Ml=a(),vt=m("p"),vt.textContent=is,pl=a(),i(At.$$.fragment),rl=a(),i(Rt.$$.fragment),ol=a(),Gt=m("p"),Gt.textContent=Ms,yl=a(),i(Zt.$$.fragment),ml=a(),i(kt.$$.fragment),Ul=a(),i(St.$$.fragment),ul=a(),c=m("blockquote"),c.innerHTML=ps,dl=a(),i(qt.$$.fragment),Tl=a(),Qt=m("p"),Qt.textContent=rs,Jl=a(),i(Bt.$$.fragment),gl=a(),Ft=m("p"),Ft.textContent=os,jl=a(),i(Xt.$$.fragment),cl=a(),xt=m("p"),xt.textContent=ys,wl=a(),i(Nt.$$.fragment),Cl=a(),Dt=m("p"),Dt.textContent=ms,fl=a(),zt=m("ul"),zt.innerHTML=Us,$l=a(),i(Lt.$$.fragment),hl=a(),_t=m("p"),_t.textContent=us,Il=a(),Et=m("ul"),Et.innerHTML=ds,bl=a(),i(Vt.$$.fragment),vl=a(),Ht=m("p"),this.h()},l(t){const e=Cs("svelte-u9bgzb",document.head);J=U(e,"META",{name:!0,content:!0}),e.forEach(l),Ot=n(t),Wt=U(t,"P",{}),Ts(Wt).forEach(l),Pt=n(t),M(w.$$.fragment,t),Kt=n(t),M(C.$$.fragment,t),te=n(t),f=U(t,"P",{"data-svelte-h":!0}),u(f)!=="svelte-1vs2jgm"&&(f.innerHTML=Gl),ee=n(t),M($.$$.fragment,t),le=n(t),h=U(t,"P",{"data-svelte-h":!0}),u(h)!=="svelte-1p2p5x5"&&(h.textContent=Zl),se=n(t),I=U(t,"P",{"data-svelte-h":!0}),u(I)!=="svelte-6a68z5"&&(I.innerHTML=kl),ae=n(t),M(b.$$.fragment,t),ne=n(t),v=U(t,"P",{"data-svelte-h":!0}),u(v)!=="svelte-evxyn0"&&(v.innerHTML=Sl),ie=n(t),M(A.$$.fragment,t),Me=n(t),R=U(t,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1fpzr8a"&&(R.textContent=ql),pe=n(t),M(G.$$.fragment,t),re=n(t),Z=U(t,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-16eeglv"&&(Z.textContent=Ql),oe=n(t),M(k.$$.fragment,t),ye=n(t),S=U(t,"UL",{"data-svelte-h":!0}),u(S)!=="svelte-1s076dw"&&(S.innerHTML=Bl),me=n(t),M(q.$$.fragment,t),Ue=n(t),Q=U(t,"UL",{"data-svelte-h":!0}),u(Q)!=="svelte-1ugmwa9"&&(Q.innerHTML=Fl),ue=n(t),M(B.$$.fragment,t),de=n(t),F=U(t,"UL",{"data-svelte-h":!0}),u(F)!=="svelte-1sh40es"&&(F.innerHTML=Xl),Te=n(t),M(X.$$.fragment,t),Je=n(t),x=U(t,"P",{"data-svelte-h":!0}),u(x)!=="svelte-ihzj73"&&(x.textContent=xl),ge=n(t),N=U(t,"UL",{"data-svelte-h":!0}),u(N)!=="svelte-1ufw2kr"&&(N.innerHTML=Nl),je=n(t),M(D.$$.fragment,t),ce=n(t),z=U(t,"P",{"data-svelte-h":!0}),u(z)!=="svelte-l37bzi"&&(z.innerHTML=Dl),we=n(t),L=U(t,"UL",{"data-svelte-h":!0}),u(L)!=="svelte-1oqg2ya"&&(L.innerHTML=zl),Ce=n(t),_=U(t,"P",{"data-svelte-h":!0}),u(_)!=="svelte-mv4617"&&(_.textContent=Ll),fe=n(t),E=U(t,"UL",{"data-svelte-h":!0}),u(E)!=="svelte-25efq3"&&(E.innerHTML=_l),$e=n(t),M(V.$$.fragment,t),he=n(t),M(W.$$.fragment,t),Ie=n(t),M(H.$$.fragment,t),be=n(t),M(Y.$$.fragment,t),ve=n(t),O=U(t,"P",{"data-svelte-h":!0}),u(O)!=="svelte-usum0t"&&(O.textContent=El),Ae=n(t),M(P.$$.fragment,t),Re=n(t),K=U(t,"P",{"data-svelte-h":!0}),u(K)!=="svelte-51339t"&&(K.textContent=Vl),Ge=n(t),M(tt.$$.fragment,t),Ze=n(t),et=U(t,"P",{"data-svelte-h":!0}),u(et)!=="svelte-1ahqb4k"&&(et.innerHTML=Wl),ke=n(t),M(lt.$$.fragment,t),Se=n(t),g=U(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(g)!=="svelte-1556z27"&&(g.innerHTML=Hl),qe=n(t),M(st.$$.fragment,t),Qe=n(t),M(at.$$.fragment,t),Be=n(t),M(nt.$$.fragment,t),Fe=n(t),it=U(t,"P",{"data-svelte-h":!0}),u(it)!=="svelte-172uynn"&&(it.textContent=Yl),Xe=n(t),M(Mt.$$.fragment,t),xe=n(t),pt=U(t,"P",{"data-svelte-h":!0}),u(pt)!=="svelte-1fjtwv3"&&(pt.textContent=Ol),Ne=n(t),M(rt.$$.fragment,t),De=n(t),ot=U(t,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-jukj08"&&(ot.textContent=Pl),ze=n(t),M(yt.$$.fragment,t),Le=n(t),M(mt.$$.fragment,t),_e=n(t),M(Ut.$$.fragment,t),Ee=n(t),ut=U(t,"P",{"data-svelte-h":!0}),u(ut)!=="svelte-105xk4g"&&(ut.textContent=Kl),Ve=n(t),M(dt.$$.fragment,t),We=n(t),Tt=U(t,"P",{"data-svelte-h":!0}),u(Tt)!=="svelte-1ky1h70"&&(Tt.innerHTML=ts),He=n(t),M(Jt.$$.fragment,t),Ye=n(t),M(gt.$$.fragment,t),Oe=n(t),M(jt.$$.fragment,t),Pe=n(t),ct=U(t,"UL",{"data-svelte-h":!0}),u(ct)!=="svelte-1rkhm28"&&(ct.innerHTML=es),Ke=n(t),j=U(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(j)!=="svelte-zexud5"&&(j.innerHTML=ls),tl=n(t),M(wt.$$.fragment,t),el=n(t),Ct=U(t,"P",{"data-svelte-h":!0}),u(Ct)!=="svelte-w5hezt"&&(Ct.textContent=ss),ll=n(t),M(ft.$$.fragment,t),sl=n(t),$t=U(t,"P",{"data-svelte-h":!0}),u($t)!=="svelte-mb7doo"&&($t.textContent=as),al=n(t),M(ht.$$.fragment,t),nl=n(t),It=U(t,"P",{"data-svelte-h":!0}),u(It)!=="svelte-1hs7zit"&&(It.textContent=ns),il=n(t),M(bt.$$.fragment,t),Ml=n(t),vt=U(t,"P",{"data-svelte-h":!0}),u(vt)!=="svelte-19io95y"&&(vt.textContent=is),pl=n(t),M(At.$$.fragment,t),rl=n(t),M(Rt.$$.fragment,t),ol=n(t),Gt=U(t,"P",{"data-svelte-h":!0}),u(Gt)!=="svelte-b38v2y"&&(Gt.textContent=Ms),yl=n(t),M(Zt.$$.fragment,t),ml=n(t),M(kt.$$.fragment,t),Ul=n(t),M(St.$$.fragment,t),ul=n(t),c=U(t,"BLOCKQUOTE",{class:!0,"data-svelte-h":!0}),u(c)!=="svelte-rtpqwu"&&(c.innerHTML=ps),dl=n(t),M(qt.$$.fragment,t),Tl=n(t),Qt=U(t,"P",{"data-svelte-h":!0}),u(Qt)!=="svelte-j8dduk"&&(Qt.textContent=rs),Jl=n(t),M(Bt.$$.fragment,t),gl=n(t),Ft=U(t,"P",{"data-svelte-h":!0}),u(Ft)!=="svelte-7n7lqm"&&(Ft.textContent=os),jl=n(t),M(Xt.$$.fragment,t),cl=n(t),xt=U(t,"P",{"data-svelte-h":!0}),u(xt)!=="svelte-1h7bs3t"&&(xt.textContent=ys),wl=n(t),M(Nt.$$.fragment,t),Cl=n(t),Dt=U(t,"P",{"data-svelte-h":!0}),u(Dt)!=="svelte-sljd79"&&(Dt.textContent=ms),fl=n(t),zt=U(t,"UL",{"data-svelte-h":!0}),u(zt)!=="svelte-qrutqg"&&(zt.innerHTML=Us),$l=n(t),M(Lt.$$.fragment,t),hl=n(t),_t=U(t,"P",{"data-svelte-h":!0}),u(_t)!=="svelte-1nd79fi"&&(_t.textContent=us),Il=n(t),Et=U(t,"UL",{"data-svelte-h":!0}),u(Et)!=="svelte-11t2sar"&&(Et.innerHTML=ds),bl=n(t),M(Vt.$$.fragment,t),vl=n(t),Ht=U(t,"P",{}),Ts(Ht).forEach(l),this.h()},h(){Yt(J,"name","hf:doc:metadata"),Yt(J,"content",bs),Yt(g,"class","warning"),Yt(j,"class","tip"),Yt(c,"class","note")},m(t,e){fs(document.head,J),s(t,Ot,e),s(t,Wt,e),s(t,Pt,e),p(w,t,e),s(t,Kt,e),p(C,t,e),s(t,te,e),s(t,f,e),s(t,ee,e),p($,t,e),s(t,le,e),s(t,h,e),s(t,se,e),s(t,I,e),s(t,ae,e),p(b,t,e),s(t,ne,e),s(t,v,e),s(t,ie,e),p(A,t,e),s(t,Me,e),s(t,R,e),s(t,pe,e),p(G,t,e),s(t,re,e),s(t,Z,e),s(t,oe,e),p(k,t,e),s(t,ye,e),s(t,S,e),s(t,me,e),p(q,t,e),s(t,Ue,e),s(t,Q,e),s(t,ue,e),p(B,t,e),s(t,de,e),s(t,F,e),s(t,Te,e),p(X,t,e),s(t,Je,e),s(t,x,e),s(t,ge,e),s(t,N,e),s(t,je,e),p(D,t,e),s(t,ce,e),s(t,z,e),s(t,we,e),s(t,L,e),s(t,Ce,e),s(t,_,e),s(t,fe,e),s(t,E,e),s(t,$e,e),p(V,t,e),s(t,he,e),p(W,t,e),s(t,Ie,e),p(H,t,e),s(t,be,e),p(Y,t,e),s(t,ve,e),s(t,O,e),s(t,Ae,e),p(P,t,e),s(t,Re,e),s(t,K,e),s(t,Ge,e),p(tt,t,e),s(t,Ze,e),s(t,et,e),s(t,ke,e),p(lt,t,e),s(t,Se,e),s(t,g,e),s(t,qe,e),p(st,t,e),s(t,Qe,e),p(at,t,e),s(t,Be,e),p(nt,t,e),s(t,Fe,e),s(t,it,e),s(t,Xe,e),p(Mt,t,e),s(t,xe,e),s(t,pt,e),s(t,Ne,e),p(rt,t,e),s(t,De,e),s(t,ot,e),s(t,ze,e),p(yt,t,e),s(t,Le,e),p(mt,t,e),s(t,_e,e),p(Ut,t,e),s(t,Ee,e),s(t,ut,e),s(t,Ve,e),p(dt,t,e),s(t,We,e),s(t,Tt,e),s(t,He,e),p(Jt,t,e),s(t,Ye,e),p(gt,t,e),s(t,Oe,e),p(jt,t,e),s(t,Pe,e),s(t,ct,e),s(t,Ke,e),s(t,j,e),s(t,tl,e),p(wt,t,e),s(t,el,e),s(t,Ct,e),s(t,ll,e),p(ft,t,e),s(t,sl,e),s(t,$t,e),s(t,al,e),p(ht,t,e),s(t,nl,e),s(t,It,e),s(t,il,e),p(bt,t,e),s(t,Ml,e),s(t,vt,e),s(t,pl,e),p(At,t,e),s(t,rl,e),p(Rt,t,e),s(t,ol,e),s(t,Gt,e),s(t,yl,e),p(Zt,t,e),s(t,ml,e),p(kt,t,e),s(t,Ul,e),p(St,t,e),s(t,ul,e),s(t,c,e),s(t,dl,e),p(qt,t,e),s(t,Tl,e),s(t,Qt,e),s(t,Jl,e),p(Bt,t,e),s(t,gl,e),s(t,Ft,e),s(t,jl,e),p(Xt,t,e),s(t,cl,e),s(t,xt,e),s(t,wl,e),p(Nt,t,e),s(t,Cl,e),s(t,Dt,e),s(t,fl,e),s(t,zt,e),s(t,$l,e),p(Lt,t,e),s(t,hl,e),s(t,_t,e),s(t,Il,e),s(t,Et,e),s(t,bl,e),p(Vt,t,e),s(t,vl,e),s(t,Ht,e),Al=!0},p:gs,i(t){Al||(r(w.$$.fragment,t),r(C.$$.fragment,t),r($.$$.fragment,t),r(b.$$.fragment,t),r(A.$$.fragment,t),r(G.$$.fragment,t),r(k.$$.fragment,t),r(q.$$.fragment,t),r(B.$$.fragment,t),r(X.$$.fragment,t),r(D.$$.fragment,t),r(V.$$.fragment,t),r(W.$$.fragment,t),r(H.$$.fragment,t),r(Y.$$.fragment,t),r(P.$$.fragment,t),r(tt.$$.fragment,t),r(lt.$$.fragment,t),r(st.$$.fragment,t),r(at.$$.fragment,t),r(nt.$$.fragment,t),r(Mt.$$.fragment,t),r(rt.$$.fragment,t),r(yt.$$.fragment,t),r(mt.$$.fragment,t),r(Ut.$$.fragment,t),r(dt.$$.fragment,t),r(Jt.$$.fragment,t),r(gt.$$.fragment,t),r(jt.$$.fragment,t),r(wt.$$.fragment,t),r(ft.$$.fragment,t),r(ht.$$.fragment,t),r(bt.$$.fragment,t),r(At.$$.fragment,t),r(Rt.$$.fragment,t),r(Zt.$$.fragment,t),r(kt.$$.fragment,t),r(St.$$.fragment,t),r(qt.$$.fragment,t),r(Bt.$$.fragment,t),r(Xt.$$.fragment,t),r(Nt.$$.fragment,t),r(Lt.$$.fragment,t),r(Vt.$$.fragment,t),Al=!0)},o(t){o(w.$$.fragment,t),o(C.$$.fragment,t),o($.$$.fragment,t),o(b.$$.fragment,t),o(A.$$.fragment,t),o(G.$$.fragment,t),o(k.$$.fragment,t),o(q.$$.fragment,t),o(B.$$.fragment,t),o(X.$$.fragment,t),o(D.$$.fragment,t),o(V.$$.fragment,t),o(W.$$.fragment,t),o(H.$$.fragment,t),o(Y.$$.fragment,t),o(P.$$.fragment,t),o(tt.$$.fragment,t),o(lt.$$.fragment,t),o(st.$$.fragment,t),o(at.$$.fragment,t),o(nt.$$.fragment,t),o(Mt.$$.fragment,t),o(rt.$$.fragment,t),o(yt.$$.fragment,t),o(mt.$$.fragment,t),o(Ut.$$.fragment,t),o(dt.$$.fragment,t),o(Jt.$$.fragment,t),o(gt.$$.fragment,t),o(jt.$$.fragment,t),o(wt.$$.fragment,t),o(ft.$$.fragment,t),o(ht.$$.fragment,t),o(bt.$$.fragment,t),o(At.$$.fragment,t),o(Rt.$$.fragment,t),o(Zt.$$.fragment,t),o(kt.$$.fragment,t),o(St.$$.fragment,t),o(qt.$$.fragment,t),o(Bt.$$.fragment,t),o(Xt.$$.fragment,t),o(Nt.$$.fragment,t),o(Lt.$$.fragment,t),o(Vt.$$.fragment,t),Al=!1},d(t){t&&(l(Ot),l(Wt),l(Pt),l(Kt),l(te),l(f),l(ee),l(le),l(h),l(se),l(I),l(ae),l(ne),l(v),l(ie),l(Me),l(R),l(pe),l(re),l(Z),l(oe),l(ye),l(S),l(me),l(Ue),l(Q),l(ue),l(de),l(F),l(Te),l(Je),l(x),l(ge),l(N),l(je),l(ce),l(z),l(we),l(L),l(Ce),l(_),l(fe),l(E),l($e),l(he),l(Ie),l(be),l(ve),l(O),l(Ae),l(Re),l(K),l(Ge),l(Ze),l(et),l(ke),l(Se),l(g),l(qe),l(Qe),l(Be),l(Fe),l(it),l(Xe),l(xe),l(pt),l(Ne),l(De),l(ot),l(ze),l(Le),l(_e),l(Ee),l(ut),l(Ve),l(We),l(Tt),l(He),l(Ye),l(Oe),l(Pe),l(ct),l(Ke),l(j),l(tl),l(el),l(Ct),l(ll),l(sl),l($t),l(al),l(nl),l(It),l(il),l(Ml),l(vt),l(pl),l(rl),l(ol),l(Gt),l(yl),l(ml),l(Ul),l(ul),l(c),l(dl),l(Tl),l(Qt),l(Jl),l(gl),l(Ft),l(jl),l(cl),l(xt),l(wl),l(Cl),l(Dt),l(fl),l(zt),l($l),l(hl),l(_t),l(Il),l(Et),l(bl),l(vl),l(Ht)),l(J),y(w,t),y(C,t),y($,t),y(b,t),y(A,t),y(G,t),y(k,t),y(q,t),y(B,t),y(X,t),y(D,t),y(V,t),y(W,t),y(H,t),y(Y,t),y(P,t),y(tt,t),y(lt,t),y(st,t),y(at,t),y(nt,t),y(Mt,t),y(rt,t),y(yt,t),y(mt,t),y(Ut,t),y(dt,t),y(Jt,t),y(gt,t),y(jt,t),y(wt,t),y(ft,t),y(ht,t),y(bt,t),y(At,t),y(Rt,t),y(Zt,t),y(kt,t),y(St,t),y(qt,t),y(Bt,t),y(Xt,t),y(Nt,t),y(Lt,t),y(Vt,t)}}}const bs='{"title":"Porting Large Datasets to LeRobot Dataset v3.0","local":"porting-large-datasets-to-lerobot-dataset-v30","sections":[{"title":"File Organization: v2.1 vs v3.0","local":"file-organization-v21-vs-v30","sections":[],"depth":2},{"title":"What’s New in Dataset v3.0","local":"whats-new-in-dataset-v30","sections":[{"title":"🏗️ Enhanced File Organization","local":"-enhanced-file-organization","sections":[],"depth":3},{"title":"📊 Modern Metadata Management","local":"-modern-metadata-management","sections":[],"depth":3},{"title":"🚀 Performance Enhancements","local":"-performance-enhancements","sections":[],"depth":3}],"depth":2},{"title":"Prerequisites","local":"prerequisites","sections":[],"depth":2},{"title":"Understanding the DROID Dataset","local":"understanding-the-droid-dataset","sections":[{"title":"DROID Features Schema","local":"droid-features-schema","sections":[],"depth":3}],"depth":2},{"title":"Approach 1: Single Computer Porting","local":"approach-1-single-computer-porting","sections":[{"title":"Step 1: Install Dependencies","local":"step-1-install-dependencies","sections":[],"depth":3},{"title":"Step 2: Download Raw Data","local":"step-2-download-raw-data","sections":[],"depth":3},{"title":"Step 3: Port the Dataset","local":"step-3-port-the-dataset","sections":[],"depth":3},{"title":"Development and Testing","local":"development-and-testing","sections":[],"depth":3}],"depth":2},{"title":"Approach 2: SLURM Cluster Porting (Recommended)","local":"approach-2-slurm-cluster-porting-recommended","sections":[{"title":"Step 1: Install Cluster Dependencies","local":"step-1-install-cluster-dependencies","sections":[],"depth":3},{"title":"Step 2: Configure Your SLURM Environment","local":"step-2-configure-your-slurm-environment","sections":[],"depth":3},{"title":"Step 3: Launch Parallel Porting Jobs","local":"step-3-launch-parallel-porting-jobs","sections":[{"title":"Parameter Guidelines","local":"parameter-guidelines","sections":[],"depth":4}],"depth":3},{"title":"Step 4: Monitor Progress","local":"step-4-monitor-progress","sections":[],"depth":3},{"title":"Step 5: Aggregate Shards","local":"step-5-aggregate-shards","sections":[],"depth":3},{"title":"Step 6: Upload to Hub","local":"step-6-upload-to-hub","sections":[],"depth":3}],"depth":2},{"title":"Dataset v3.0 File Structure","local":"dataset-v30-file-structure","sections":[],"depth":2},{"title":"Migrating from Dataset v2.1","local":"migrating-from-dataset-v21","sections":[],"depth":2},{"title":"Performance Benefits","local":"performance-benefits","sections":[],"depth":2}],"depth":1}';function vs(Rl){return js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ss extends cs{constructor(J){super(),ws(this,J,vs,Is,Js,{})}}export{Ss as component};
