import{s as $l,n as Vl,o as xl}from"../chunks/scheduler.eb244325.js";import{S as El,i as Rl,e as i,s as n,c as M,h as Wl,a as p,d as l,b as a,f as _l,g as r,j as o,k as Xl,l as Nl,m as s,n as h,t as c,o as y,p as u}from"../chunks/index.3fe63ad3.js";import{C as Ql}from"../chunks/CopyLLMTxtMenu.08242e11.js";import{C as w}from"../chunks/CodeBlock.91baa5b4.js";import{H as j,E as Hl}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.234c3f85.js";function Yl(Ft){let m,Ge,Be,_e,d,Xe,T,$e,J,qt=`Processor pipelines can be complex, especially when chaining multiple transformation steps.
Unlike simple function calls, pipelines lack natural observability, you can’t easily see what happens
between each step or where things go wrong.
This guide provides debugging tools and techniques specifically designed to address these challenges
and help you understand data flow through your pipelines.`,Ve,U,Lt="We’ll explore three complementary debugging approaches: <strong>hooks</strong> for runtime monitoring, <strong>step-through debugging</strong> for detailed inspection, and <strong>feature validation</strong> for catching structural mismatches. Each serves a different purpose and together they provide complete visibility into your pipeline’s behavior.",xe,f,Ee,b,Pt=`Hooks are functions that get called at specific points during pipeline execution.
They provide a way to inspect, monitor, or modify data without changing your pipeline code.
Think of them as “event listeners” for your pipeline.`,Re,I,We,C,Dt=`A hook is a callback function that gets automatically invoked at specific moments during pipeline execution.
The concept comes from event-driven programming, imagine you could “hook into” the pipeline’s execution flow to observe or react to what’s happening.`,Ne,g,Kt="Think of hooks like inserting checkpoints into your pipeline. Every time the pipeline reaches one of these checkpoints, it pauses briefly to call your hook function, giving you a chance to inspect the current state, log information, and validate data.",Qe,Z,Ot="A hook is simply a function that accepts two parameters:",He,k,el="<li><code>step_idx: int</code> - The index of the current processing step (0, 1, 2, etc.)</li> <li><code>transition: EnvTransition</code> - The data transition at that point in the pipeline</li>",Ye,A,tl="The beauty of hooks is their non-invasive nature: you can add monitoring, validation, or debugging logic without changing a single line of your pipeline code. The pipeline remains clean and focused on its core logic, while hooks handle the cross-cutting concerns like logging, monitoring, and debugging.",Se,B,ze,v,ll="The pipeline supports two types of hooks:",Fe,G,sl="<li><strong>Before hooks</strong> (<code>register_before_step_hook</code>) - Called before each step executes</li> <li><strong>After hooks</strong> (<code>register_after_step_hook</code>) - Called after each step completes</li>",qe,_,Le,X,Pe,$,nl="Here’s a practical example of a hook that detects NaN values:",De,V,Ke,x,Oe,E,al="Understanding the internal mechanism helps you use hooks more effectively. The pipeline maintains two separate lists: one for before-step hooks and another for after-step hooks. When you register a hook, it’s simply appended to the appropriate list.",et,R,il="During execution, the pipeline follows a strict sequence: for each processing step, it first calls all before-hooks in registration order, then executes the actual step transformation, and finally calls all after-hooks in registration order. This creates a predictable, sandwich-like structure around each step.",tt,W,pl="The key insight is that hooks don’t change the core pipeline logic—they’re purely additive. The pipeline’s <code>_forward</code> method orchestrates this dance between hooks and processing steps, ensuring that your debugging or monitoring code runs at exactly the right moments without interfering with the main data flow.",lt,N,ol="Here’s a simplified view of how the pipeline executes hooks:",st,Q,nt,H,at,Y,Ml="The execution flow looks like this:",it,S,pt,z,rl="For example, with 3 steps and both hook types:",ot,F,Mt,q,rt,L,hl="You can register multiple hooks of the same type - they execute in the order registered:",ht,P,ct,D,cl="While hooks are excellent for monitoring specific issues (like NaN detection) or gathering metrics during normal pipeline execution, sometimes you need to dive deeper. When you want to understand exactly what happens at each step or debug complex transformation logic, step-through debugging provides the detailed inspection you need.",yt,K,ut,O,yl="Step-through debugging is like having a slow-motion replay for your pipeline. Instead of watching your data get transformed in one quick blur from input to output, you can pause and examine what happens after each individual step.",jt,ee,ul="This approach is particularly valuable when you’re trying to understand a complex pipeline, debug unexpected behavior, or verify that each transformation is working as expected. Unlike hooks, which are great for automated monitoring, step-through debugging gives you manual, interactive control over the inspection process.",wt,te,jl="The <code>step_through()</code> method is a generator that yields the transition state after each processing step, allowing you to inspect intermediate results. Think of it as creating a series of snapshots of your data as it flows through the pipeline—each snapshot shows you exactly what your data looks like after one more transformation has been applied.",mt,le,dt,se,wl="The <code>step_through()</code> method fundamentally changes how the pipeline executes. Instead of running all steps in sequence and only returning the final result, it transforms the pipeline into an iterator that yields intermediate results.",Tt,ne,ml="Here’s what happens internally: the method starts by converting your input data into the pipeline’s internal transition format, then yields this initial state. Next, it applies the first processing step and yields the result. Then it applies the second step to that result and yields again, and so on. Each <code>yield</code> gives you a complete snapshot of the transition at that point.",Jt,ae,dl="This generator pattern is powerful because it’s lazy—the pipeline only computes the next step when you ask for it. This means you can stop at any point, inspect the current state thoroughly, and decide whether to continue. You’re not forced to run the entire pipeline just to debug one problematic step.",Ut,ie,Tl="Instead of running the entire pipeline and only seeing the final result, <code>step_through()</code> pauses after each step and gives you the intermediate transition:",ft,pe,bt,oe,It,Me,Jl="You can add breakpoints in the step-through loop to interactively debug:",Ct,re,gt,he,Ul="During the debugger session, you can:",Zt,ce,fl="<li>Examine <code>intermediate[TransitionKey.OBSERVATION]</code> to see observation data</li> <li>Check <code>intermediate[TransitionKey.ACTION]</code> for action transformations</li> <li>Inspect any part of the transition to understand what each step does</li>",kt,ye,bl="Step-through debugging is perfect for understanding the <em>data</em> transformations, but what about the <em>structure</em> of that data? While hooks and step-through help you debug runtime behavior, you also need to ensure your pipeline produces data in the format expected by downstream components. This is where feature contract validation comes in.",At,ue,Bt,je,Il=`Feature contracts define what data structure your pipeline expects as input and produces as output.
Validating these contracts helps catch mismatches early.`,vt,we,Gt,me,Cl="Each processor step has a <code>transform_features()</code> method that describes how it changes the data structure:",_t,de,Xt,Te,$t,Je,gl="Check that your pipeline produces the features you expect:",Vt,Ue,xt,fe,Zl="This validation helps ensure your pipeline will work correctly with downstream components that expect specific data structures.",Et,be,Rt,Ie,kl="Now that you understand the three debugging approaches, you can tackle any pipeline issue systematically:",Wt,Ce,Al="<li><strong>Hooks</strong> - For runtime monitoring and validation without modifying pipeline code</li> <li><strong>Step-through</strong> - For inspecting intermediate states and understanding transformations</li> <li><strong>Feature validation</strong> - For ensuring data structure contracts are met</li>",Nt,ge,Bl="<strong>When to use each approach:</strong>",Qt,Ze,vl="<li>Start with <strong>step-through debugging</strong> when you need to understand what your pipeline does or when something unexpected happens</li> <li>Add <strong>hooks</strong> for continuous monitoring during development and production to catch issues automatically</li> <li>Use <strong>feature validation</strong> before deployment to ensure your pipeline works with downstream components</li>",Ht,ke,Gl="These three tools work together to give you the complete observability that complex pipelines naturally lack. With hooks watching for issues, step-through helping you understand behavior, and feature validation ensuring compatibility, you’ll be able to debug any pipeline confidently and efficiently.",Yt,Ae,St,ve,zt;return d=new Ql({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new j({props:{title:"Debug Your Processor Pipeline",local:"debug-your-processor-pipeline",headingTag:"h1"}}),f=new j({props:{title:"Understanding Hooks",local:"understanding-hooks",headingTag:"h2"}}),I=new j({props:{title:"What is a Hook?",local:"what-is-a-hook",headingTag:"h3"}}),B=new j({props:{title:"Before vs After Hooks",local:"before-vs-after-hooks",headingTag:"h3"}}),_=new w({props:{code:"ZGVmJTIwYmVmb3JlX2hvb2soc3RlcF9pZHglM0ElMjBpbnQlMkMlMjB0cmFuc2l0aW9uJTNBJTIwRW52VHJhbnNpdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDYWxsZWQlMjBiZWZvcmUlMjBzdGVwJTIwcHJvY2Vzc2VzJTIwdGhlJTIwdHJhbnNpdGlvbi4lMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBwcmludChmJTIyQWJvdXQlMjB0byUyMGV4ZWN1dGUlMjBzdGVwJTIwJTdCc3RlcF9pZHglN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNlZnVsJTIwZm9yJTNBJTIwbG9nZ2luZyUyQyUyMHZhbGlkYXRpb24lMkMlMjBzZXR1cCUwQSUwQWRlZiUyMGFmdGVyX2hvb2soc3RlcF9pZHglM0ElMjBpbnQlMkMlMjB0cmFuc2l0aW9uJTNBJTIwRW52VHJhbnNpdGlvbiklM0ElMEElMjAlMjAlMjAlMjAlMjIlMjIlMjJDYWxsZWQlMjBhZnRlciUyMHN0ZXAlMjBoYXMlMjBwcm9jZXNzZWQlMjB0aGUlMjB0cmFuc2l0aW9uLiUyMiUyMiUyMiUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJDb21wbGV0ZWQlMjBzdGVwJTIwJTdCc3RlcF9pZHglN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNlZnVsJTIwZm9yJTNBJTIwbW9uaXRvcmluZyUyMHJlc3VsdHMlMkMlMjBjbGVhbnVwJTJDJTIwZGVidWdnaW5nJTBBJTBBcHJvY2Vzc29yLnJlZ2lzdGVyX2JlZm9yZV9zdGVwX2hvb2soYmVmb3JlX2hvb2spJTBBcHJvY2Vzc29yLnJlZ2lzdGVyX2FmdGVyX3N0ZXBfaG9vayhhZnRlcl9ob29rKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">before_hook</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Called before step processes the transition.&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;About to execute step <span class="hljs-subst">{step_idx}</span>&quot;</span>)
    <span class="hljs-comment"># Useful for: logging, validation, setup</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">after_hook</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Called after step has processed the transition.&quot;&quot;&quot;</span>
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Completed step <span class="hljs-subst">{step_idx}</span>&quot;</span>)
    <span class="hljs-comment"># Useful for: monitoring results, cleanup, debugging</span>

processor.register_before_step_hook(before_hook)
processor.register_after_step_hook(after_hook)`,wrap:!1}}),X=new j({props:{title:"Implementing a NaN Detection Hook",local:"implementing-a-nan-detection-hook",headingTag:"h3"}}),V=new w({props:{code:"ZGVmJTIwY2hlY2tfbmFucyhzdGVwX2lkeCUzQSUyMGludCUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMCUyMiUyMiUyMkNoZWNrJTIwZm9yJTIwTmFOJTIwdmFsdWVzJTIwaW4lMjBvYnNlcnZhdGlvbnMuJTIyJTIyJTIyJTBBJTIwJTIwJTIwJTIwb2JzJTIwJTNEJTIwdHJhbnNpdGlvbi5nZXQoVHJhbnNpdGlvbktleS5PQlNFUlZBVElPTiklMEElMjAlMjAlMjAlMjBpZiUyMG9icyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZvciUyMGtleSUyQyUyMHZhbHVlJTIwaW4lMjBvYnMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwaXNpbnN0YW5jZSh2YWx1ZSUyQyUyMHRvcmNoLlRlbnNvciklMjBhbmQlMjB0b3JjaC5pc25hbih2YWx1ZSkuYW55KCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyTmFOJTIwZGV0ZWN0ZWQlMjBpbiUyMCU3QmtleSU3RCUyMGF0JTIwc3RlcCUyMCU3QnN0ZXBfaWR4JTdEJTIyKSUwQSUwQSUyMyUyMFJlZ2lzdGVyJTIwdGhlJTIwaG9vayUyMHRvJTIwcnVuJTIwYWZ0ZXIlMjBlYWNoJTIwc3RlcCUwQXByb2Nlc3Nvci5yZWdpc3Rlcl9hZnRlcl9zdGVwX2hvb2soY2hlY2tfbmFucyklMEElMEElMjMlMjBQcm9jZXNzJTIweW91ciUyMGRhdGElMjAtJTIwdGhlJTIwaG9vayUyMHdpbGwlMjBiZSUyMGNhbGxlZCUyMGF1dG9tYXRpY2FsbHklMEFvdXRwdXQlMjAlM0QlMjBwcm9jZXNzb3IoaW5wdXRfZGF0YSklMEElMEElMjMlMjBSZW1vdmUlMjB0aGUlMjBob29rJTIwd2hlbiUyMGRvbmUlMjBkZWJ1Z2dpbmclMEFwcm9jZXNzb3IudW5yZWdpc3Rlcl9hZnRlcl9zdGVwX2hvb2soY2hlY2tfbmFucyk=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">check_nans</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    <span class="hljs-string">&quot;&quot;&quot;Check for NaN values in observations.&quot;&quot;&quot;</span>
    obs = transition.get(TransitionKey.OBSERVATION)
    <span class="hljs-keyword">if</span> obs:
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor) <span class="hljs-keyword">and</span> torch.isnan(value).<span class="hljs-built_in">any</span>():
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;NaN detected in <span class="hljs-subst">{key}</span> at step <span class="hljs-subst">{step_idx}</span>&quot;</span>)

<span class="hljs-comment"># Register the hook to run after each step</span>
processor.register_after_step_hook(check_nans)

<span class="hljs-comment"># Process your data - the hook will be called automatically</span>
output = processor(input_data)

<span class="hljs-comment"># Remove the hook when done debugging</span>
processor.unregister_after_step_hook(check_nans)`,wrap:!1}}),x=new j({props:{title:"How Hooks Work Internally",local:"how-hooks-work-internally",headingTag:"h3"}}),Q=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">DataProcessorPipeline</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self</span>):
        self.steps = [...]
        self.before_step_hooks = []  <span class="hljs-comment"># List of before hooks</span>
        self.after_step_hooks = []   <span class="hljs-comment"># List of after hooks</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, transition</span>):
        <span class="hljs-string">&quot;&quot;&quot;Internal method that processes the transition through all steps.&quot;&quot;&quot;</span>
        <span class="hljs-keyword">for</span> step_idx, processor_step <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(self.steps):
            <span class="hljs-comment"># 1. Call all BEFORE hooks</span>
            <span class="hljs-keyword">for</span> hook <span class="hljs-keyword">in</span> self.before_step_hooks:
                hook(step_idx, transition)

            <span class="hljs-comment"># 2. Execute the actual processing step</span>
            transition = processor_step(transition)

            <span class="hljs-comment"># 3. Call all AFTER hooks</span>
            <span class="hljs-keyword">for</span> hook <span class="hljs-keyword">in</span> self.after_step_hooks:
                hook(step_idx, transition)

        <span class="hljs-keyword">return</span> transition

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">register_before_step_hook</span>(<span class="hljs-params">self, hook_fn</span>):
        self.before_step_hooks.append(hook_fn)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">register_after_step_hook</span>(<span class="hljs-params">self, hook_fn</span>):
        self.after_step_hooks.append(hook_fn)`,wrap:!1}}),H=new j({props:{title:"Execution Flow",local:"execution-flow",headingTag:"h3"}}),S=new w({props:{code:"SW5wdXQlMjAlRTIlODYlOTIlMjBCZWZvcmUlMjBIb29rJTIwJUUyJTg2JTkyJTIwU3RlcCUyMDAlMjAlRTIlODYlOTIlMjBBZnRlciUyMEhvb2slMjAlRTIlODYlOTIlMjBCZWZvcmUlMjBIb29rJTIwJUUyJTg2JTkyJTIwU3RlcCUyMDElMjAlRTIlODYlOTIlMjBBZnRlciUyMEhvb2slMjAlRTIlODYlOTIlMjAuLi4lMjAlRTIlODYlOTIlMjBPdXRwdXQ=",highlighted:'<span class="hljs-built_in">Input</span> → <span class="hljs-built_in">Before</span> <span class="hljs-variable">Hook</span> → <span class="hljs-variable">Step</span> <span class="hljs-number">0</span> → <span class="hljs-built_in">After</span> <span class="hljs-variable">Hook</span> → <span class="hljs-built_in">Before</span> <span class="hljs-variable">Hook</span> → <span class="hljs-variable">Step</span> <span class="hljs-number">1</span> → <span class="hljs-built_in">After</span> <span class="hljs-variable">Hook</span> → <span class="hljs-operator">...</span> → <span class="hljs-variable">Output</span>',wrap:!1}}),F=new w({props:{code:"ZGVmJTIwdGltaW5nX2JlZm9yZShzdGVwX2lkeCUyQyUyMHRyYW5zaXRpb24pJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU4RiVCMSVFRiVCOCU4RiUyMCUyMFN0YXJ0aW5nJTIwc3RlcCUyMCU3QnN0ZXBfaWR4JTdEJTIyKSUwQSUwQWRlZiUyMHZhbGlkYXRpb25fYWZ0ZXIoc3RlcF9pZHglMkMlMjB0cmFuc2l0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlRTIlOUMlODUlMjBDb21wbGV0ZWQlMjBzdGVwJTIwJTdCc3RlcF9pZHglN0QlMjIpJTBBJTBBcHJvY2Vzc29yLnJlZ2lzdGVyX2JlZm9yZV9zdGVwX2hvb2sodGltaW5nX2JlZm9yZSklMEFwcm9jZXNzb3IucmVnaXN0ZXJfYWZ0ZXJfc3RlcF9ob29rKHZhbGlkYXRpb25fYWZ0ZXIpJTBBJTBBJTIzJTIwVGhpcyUyMHdpbGwlMjBvdXRwdXQlM0ElMEElMjMlMjAlRTIlOEYlQjElRUYlQjglOEYlMjAlMjBTdGFydGluZyUyMHN0ZXAlMjAwJTBBJTIzJTIwJUUyJTlDJTg1JTIwQ29tcGxldGVkJTIwc3RlcCUyMDAlMEElMjMlMjAlRTIlOEYlQjElRUYlQjglOEYlMjAlMjBTdGFydGluZyUyMHN0ZXAlMjAxJTBBJTIzJTIwJUUyJTlDJTg1JTIwQ29tcGxldGVkJTIwc3RlcCUyMDElMEElMjMlMjAlRTIlOEYlQjElRUYlQjglOEYlMjAlMjBTdGFydGluZyUyMHN0ZXAlMjAyJTBBJTIzJTIwJUUyJTlDJTg1JTIwQ29tcGxldGVkJTIwc3RlcCUyMDI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">timing_before</span>(<span class="hljs-params">step_idx, transition</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;⏱️  Starting step <span class="hljs-subst">{step_idx}</span>&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">validation_after</span>(<span class="hljs-params">step_idx, transition</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ Completed step <span class="hljs-subst">{step_idx}</span>&quot;</span>)

processor.register_before_step_hook(timing_before)
processor.register_after_step_hook(validation_after)

<span class="hljs-comment"># This will output:</span>
<span class="hljs-comment"># ⏱️  Starting step 0</span>
<span class="hljs-comment"># ✅ Completed step 0</span>
<span class="hljs-comment"># ⏱️  Starting step 1</span>
<span class="hljs-comment"># ✅ Completed step 1</span>
<span class="hljs-comment"># ⏱️  Starting step 2</span>
<span class="hljs-comment"># ✅ Completed step 2</span>`,wrap:!1}}),q=new j({props:{title:"Multiple Hooks",local:"multiple-hooks",headingTag:"h3"}}),P=new w({props:{code:"ZGVmJTIwbG9nX3NoYXBlcyhzdGVwX2lkeCUzQSUyMGludCUyQyUyMHRyYW5zaXRpb24lM0ElMjBFbnZUcmFuc2l0aW9uKSUzQSUwQSUyMCUyMCUyMCUyMG9icyUyMCUzRCUyMHRyYW5zaXRpb24uZ2V0KFRyYW5zaXRpb25LZXkuT0JTRVJWQVRJT04pJTBBJTIwJTIwJTIwJTIwaWYlMjBvYnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmludChmJTIyU3RlcCUyMCU3QnN0ZXBfaWR4JTdEJTIwb2JzZXJ2YXRpb24lMjBzaGFwZXMlM0ElMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm9yJTIwa2V5JTJDJTIwdmFsdWUlMjBpbiUyMG9icy5pdGVtcygpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaWYlMjBpc2luc3RhbmNlKHZhbHVlJTJDJTIwdG9yY2guVGVuc29yKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlN0JrZXklN0QlM0ElMjAlN0J2YWx1ZS5zaGFwZSU3RCUyMiklMEElMEFwcm9jZXNzb3IucmVnaXN0ZXJfYWZ0ZXJfc3RlcF9ob29rKGNoZWNrX25hbnMpJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwRXhlY3V0ZXMlMjBmaXJzdCUwQXByb2Nlc3Nvci5yZWdpc3Rlcl9hZnRlcl9zdGVwX2hvb2sobG9nX3NoYXBlcyklMjAlMjAlMjAlMjAlMjAlMjMlMjBFeGVjdXRlcyUyMHNlY29uZCUwQSUwQSUyMyUyMEJvdGglMjBob29rcyUyMHdpbGwlMjBiZSUyMGNhbGxlZCUyMGFmdGVyJTIwZWFjaCUyMHN0ZXAlMjBpbiUyMHJlZ2lzdHJhdGlvbiUyMG9yZGVyJTBBb3V0cHV0JTIwJTNEJTIwcHJvY2Vzc29yKGlucHV0X2RhdGEp",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">log_shapes</span>(<span class="hljs-params">step_idx: <span class="hljs-built_in">int</span>, transition: EnvTransition</span>):
    obs = transition.get(TransitionKey.OBSERVATION)
    <span class="hljs-keyword">if</span> obs:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Step <span class="hljs-subst">{step_idx}</span> observation shapes:&quot;</span>)
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{key}</span>: <span class="hljs-subst">{value.shape}</span>&quot;</span>)

processor.register_after_step_hook(check_nans)      <span class="hljs-comment"># Executes first</span>
processor.register_after_step_hook(log_shapes)     <span class="hljs-comment"># Executes second</span>

<span class="hljs-comment"># Both hooks will be called after each step in registration order</span>
output = processor(input_data)`,wrap:!1}}),K=new j({props:{title:"Step-Through Debugging",local:"step-through-debugging",headingTag:"h2"}}),le=new j({props:{title:"How Step-Through Works",local:"how-step-through-works",headingTag:"h3"}}),pe=new w({props:{code:"JTIzJTIwVGhpcyUyMGNyZWF0ZXMlMjBhJTIwZ2VuZXJhdG9yJTIwdGhhdCUyMHlpZWxkcyUyMGludGVybWVkaWF0ZSUyMHN0YXRlcyUwQWZvciUyMGklMkMlMjBpbnRlcm1lZGlhdGVfcmVzdWx0JTIwaW4lMjBlbnVtZXJhdGUocHJvY2Vzc29yLnN0ZXBfdGhyb3VnaChpbnB1dF9kYXRhKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyJTNEJTNEJTNEJTIwQWZ0ZXIlMjBzdGVwJTIwJTdCaSU3RCUyMCUzRCUzRCUzRCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBJbnNwZWN0JTIwdGhlJTIwb2JzZXJ2YXRpb24lMjBhdCUyMHRoaXMlMjBzdGFnZSUwQSUyMCUyMCUyMCUyMG9icyUyMCUzRCUyMGludGVybWVkaWF0ZV9yZXN1bHQuZ2V0KFRyYW5zaXRpb25LZXkuT0JTRVJWQVRJT04pJTBBJTIwJTIwJTIwJTIwaWYlMjBvYnMlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjBrZXklMkMlMjB2YWx1ZSUyMGluJTIwb2JzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGlzaW5zdGFuY2UodmFsdWUlMkMlMjB0b3JjaC5UZW5zb3IpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiU3QmtleSU3RCUzQSUyMHNoYXBlJTNEJTdCdmFsdWUuc2hhcGUlN0QlMkMlMjBkdHlwZSUzRCU3QnZhbHVlLmR0eXBlJTdEJTIyKQ==",highlighted:`<span class="hljs-comment"># This creates a generator that yields intermediate states</span>
<span class="hljs-keyword">for</span> i, intermediate_result <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(processor.step_through(input_data)):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;=== After step <span class="hljs-subst">{i}</span> ===&quot;</span>)

    <span class="hljs-comment"># Inspect the observation at this stage</span>
    obs = intermediate_result.get(TransitionKey.OBSERVATION)
    <span class="hljs-keyword">if</span> obs:
        <span class="hljs-keyword">for</span> key, value <span class="hljs-keyword">in</span> obs.items():
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(value, torch.Tensor):
                <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{key}</span>: shape=<span class="hljs-subst">{value.shape}</span>, dtype=<span class="hljs-subst">{value.dtype}</span>&quot;</span>)`,wrap:!1}}),oe=new j({props:{title:"Interactive Debugging with Breakpoints",local:"interactive-debugging-with-breakpoints",headingTag:"h3"}}),re=new w({props:{code:"JTIzJTIwU3RlcCUyMHRocm91Z2glMjB0aGUlMjBwaXBlbGluZSUyMHdpdGglMjBkZWJ1Z2dpbmclMEFmb3IlMjBpJTJDJTIwaW50ZXJtZWRpYXRlJTIwaW4lMjBlbnVtZXJhdGUocHJvY2Vzc29yLnN0ZXBfdGhyb3VnaChkYXRhKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyU3RlcCUyMCU3QmklN0QlM0ElMjAlN0Jwcm9jZXNzb3Iuc3RlcHMlNUJpJTVELl9fY2xhc3NfXy5fX25hbWVfXyU3RCUyMiklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBTZXQlMjBhJTIwYnJlYWtwb2ludCUyMHRvJTIwaW5zcGVjdCUyMHRoZSUyMGN1cnJlbnQlMjBzdGF0ZSUwQSUyMCUyMCUyMCUyMGJyZWFrcG9pbnQoKSUyMCUyMCUyMyUyMERlYnVnZ2VyJTIwd2lsbCUyMHBhdXNlJTIwaGVyZSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFlvdSUyMGNhbiUyMG5vdyUyMGluc3BlY3QlMjAnaW50ZXJtZWRpYXRlJyUyMGluJTIwdGhlJTIwZGVidWdnZXIlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjAtJTIwQ2hlY2slMjB0ZW5zb3IlMjBzaGFwZXMlMjBhbmQlMjB2YWx1ZXMlMEElMjAlMjAlMjAlMjAlMjMlMjAtJTIwVmVyaWZ5JTIwZXhwZWN0ZWQlMjB0cmFuc2Zvcm1hdGlvbnMlMEElMjAlMjAlMjAlMjAlMjMlMjAtJTIwTG9vayUyMGZvciUyMHVuZXhwZWN0ZWQlMjBjaGFuZ2Vz",highlighted:`<span class="hljs-comment"># Step through the pipeline with debugging</span>
<span class="hljs-keyword">for</span> i, intermediate <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(processor.step_through(data)):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Step <span class="hljs-subst">{i}</span>: <span class="hljs-subst">{processor.steps[i].__class__.__name__}</span>&quot;</span>)

    <span class="hljs-comment"># Set a breakpoint to inspect the current state</span>
    <span class="hljs-built_in">breakpoint</span>()  <span class="hljs-comment"># Debugger will pause here</span>

    <span class="hljs-comment"># You can now inspect &#x27;intermediate&#x27; in the debugger:</span>
    <span class="hljs-comment"># - Check tensor shapes and values</span>
    <span class="hljs-comment"># - Verify expected transformations</span>
    <span class="hljs-comment"># - Look for unexpected changes</span>`,wrap:!1}}),ue=new j({props:{title:"Validating Feature Contracts",local:"validating-feature-contracts",headingTag:"h2"}}),we=new j({props:{title:"Understanding Feature Contracts",local:"understanding-feature-contracts",headingTag:"h3"}}),de=new w({props:{code:"JTIzJTIwR2V0JTIwdGhlJTIwZXhwZWN0ZWQlMjBvdXRwdXQlMjBmZWF0dXJlcyUyMGZyb20lMjB5b3VyJTIwcGlwZWxpbmUlMEFpbml0aWFsX2ZlYXR1cmVzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwUGlwZWxpbmVGZWF0dXJlVHlwZS5PQlNFUlZBVElPTiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMm9ic2VydmF0aW9uLnN0YXRlJTIyJTNBJTIwUG9saWN5RmVhdHVyZSh0eXBlJTNERmVhdHVyZVR5cGUuU1RBVEUlMkMlMjBzaGFwZSUzRCg3JTJDKSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZSUyMiUzQSUyMFBvbGljeUZlYXR1cmUodHlwZSUzREZlYXR1cmVUeXBlLklNQUdFJTJDJTIwc2hhcGUlM0QoMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwUGlwZWxpbmVGZWF0dXJlVHlwZS5BQ1RJT04lM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJhY3Rpb24lMjIlM0ElMjBQb2xpY3lGZWF0dXJlKHR5cGUlM0RGZWF0dXJlVHlwZS5BQ1RJT04lMkMlMjBzaGFwZSUzRCg0JTJDKSklMEElMjAlMjAlMjAlMjAlN0QlMEElN0QlMEElMEElMjMlMjBDaGVjayUyMHdoYXQlMjB5b3VyJTIwcGlwZWxpbmUlMjB3aWxsJTIwb3V0cHV0JTBBb3V0cHV0X2ZlYXR1cmVzJTIwJTNEJTIwcHJvY2Vzc29yLnRyYW5zZm9ybV9mZWF0dXJlcyhpbml0aWFsX2ZlYXR1cmVzKSUwQSUwQXByaW50KCUyMklucHV0JTIwZmVhdHVyZXMlM0ElMjIpJTBBZm9yJTIwZmVhdHVyZV90eXBlJTJDJTIwZmVhdHVyZXMlMjBpbiUyMGluaXRpYWxfZmVhdHVyZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlN0JmZWF0dXJlX3R5cGUlN0QlM0ElMjIpJTBBJTIwJTIwJTIwJTIwZm9yJTIwa2V5JTJDJTIwZmVhdHVyZSUyMGluJTIwZmVhdHVyZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlMjAlMjAlN0JrZXklN0QlM0ElMjAlN0JmZWF0dXJlLnR5cGUudmFsdWUlN0QlMkMlMjBzaGFwZSUzRCU3QmZlYXR1cmUuc2hhcGUlN0QlMjIpJTBBJTBBcHJpbnQoJTIyJTVDbk91dHB1dCUyMGZlYXR1cmVzJTNBJTIyKSUwQWZvciUyMGZlYXR1cmVfdHlwZSUyQyUyMGZlYXR1cmVzJTIwaW4lMjBvdXRwdXRfZmVhdHVyZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlN0JmZWF0dXJlX3R5cGUlN0QlM0ElMjIpJTBBJTIwJTIwJTIwJTIwZm9yJTIwa2V5JTJDJTIwZmVhdHVyZSUyMGluJTIwZmVhdHVyZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlMjAlMjAlMjAlMjAlN0JrZXklN0QlM0ElMjAlN0JmZWF0dXJlLnR5cGUudmFsdWUlN0QlMkMlMjBzaGFwZSUzRCU3QmZlYXR1cmUuc2hhcGUlN0QlMjIp",highlighted:`<span class="hljs-comment"># Get the expected output features from your pipeline</span>
initial_features = {
    PipelineFeatureType.OBSERVATION: {
        <span class="hljs-string">&quot;observation.state&quot;</span>: PolicyFeature(<span class="hljs-built_in">type</span>=FeatureType.STATE, shape=(<span class="hljs-number">7</span>,)),
        <span class="hljs-string">&quot;observation.image&quot;</span>: PolicyFeature(<span class="hljs-built_in">type</span>=FeatureType.IMAGE, shape=(<span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
    },
    PipelineFeatureType.ACTION: {
        <span class="hljs-string">&quot;action&quot;</span>: PolicyFeature(<span class="hljs-built_in">type</span>=FeatureType.ACTION, shape=(<span class="hljs-number">4</span>,))
    }
}

<span class="hljs-comment"># Check what your pipeline will output</span>
output_features = processor.transform_features(initial_features)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Input features:&quot;</span>)
<span class="hljs-keyword">for</span> feature_type, features <span class="hljs-keyword">in</span> initial_features.items():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{feature_type}</span>:&quot;</span>)
    <span class="hljs-keyword">for</span> key, feature <span class="hljs-keyword">in</span> features.items():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;    <span class="hljs-subst">{key}</span>: <span class="hljs-subst">{feature.<span class="hljs-built_in">type</span>.value}</span>, shape=<span class="hljs-subst">{feature.shape}</span>&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;\\nOutput features:&quot;</span>)
<span class="hljs-keyword">for</span> feature_type, features <span class="hljs-keyword">in</span> output_features.items():
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;  <span class="hljs-subst">{feature_type}</span>:&quot;</span>)
    <span class="hljs-keyword">for</span> key, feature <span class="hljs-keyword">in</span> features.items():
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;    <span class="hljs-subst">{key}</span>: <span class="hljs-subst">{feature.<span class="hljs-built_in">type</span>.value}</span>, shape=<span class="hljs-subst">{feature.shape}</span>&quot;</span>)`,wrap:!1}}),Te=new j({props:{title:"Verifying Expected Features",local:"verifying-expected-features",headingTag:"h3"}}),Ue=new w({props:{code:"JTIzJTIwRGVmaW5lJTIwd2hhdCUyMGZlYXR1cmVzJTIweW91JTIwZXhwZWN0JTIwdGhlJTIwcGlwZWxpbmUlMjB0byUyMHByb2R1Y2UlMEFleHBlY3RlZF9rZXlzJTIwJTNEJTIwJTVCJTIyb2JzZXJ2YXRpb24uc3RhdGUlMjIlMkMlMjAlMjJvYnNlcnZhdGlvbi5pbWFnZSUyMiUyQyUyMCUyMmFjdGlvbiUyMiU1RCUwQSUwQXByaW50KCUyMlZhbGlkYXRpbmclMjBmZWF0dXJlJTIwY29udHJhY3QuLi4lMjIpJTBBZm9yJTIwZXhwZWN0ZWRfa2V5JTIwaW4lMjBleHBlY3RlZF9rZXlzJTNBJTBBJTIwJTIwJTIwJTIwZm91bmQlMjAlM0QlMjBGYWxzZSUwQSUyMCUyMCUyMCUyMGZvciUyMGZlYXR1cmVfdHlwZSUyQyUyMGZlYXR1cmVzJTIwaW4lMjBvdXRwdXRfZmVhdHVyZXMuaXRlbXMoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwZXhwZWN0ZWRfa2V5JTIwaW4lMjBmZWF0dXJlcyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGZlYXR1cmUlMjAlM0QlMjBmZWF0dXJlcyU1QmV4cGVjdGVkX2tleSU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGYlMjIlRTIlOUMlODUlMjAlN0JleHBlY3RlZF9rZXklN0QlM0ElMjAlN0JmZWF0dXJlLnR5cGUudmFsdWUlN0QlMkMlMjBzaGFwZSUzRCU3QmZlYXR1cmUuc2hhcGUlN0QlMjIpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZm91bmQlMjAlM0QlMjBUcnVlJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYnJlYWslMEElMEElMjAlMjAlMjAlMjBpZiUyMG5vdCUyMGZvdW5kJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoZiUyMiVFMiU5RCU4QyUyME1pc3NpbmclMjBleHBlY3RlZCUyMGZlYXR1cmUlM0ElMjAlN0JleHBlY3RlZF9rZXklN0QlMjIp",highlighted:`<span class="hljs-comment"># Define what features you expect the pipeline to produce</span>
expected_keys = [<span class="hljs-string">&quot;observation.state&quot;</span>, <span class="hljs-string">&quot;observation.image&quot;</span>, <span class="hljs-string">&quot;action&quot;</span>]

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Validating feature contract...&quot;</span>)
<span class="hljs-keyword">for</span> expected_key <span class="hljs-keyword">in</span> expected_keys:
    found = <span class="hljs-literal">False</span>
    <span class="hljs-keyword">for</span> feature_type, features <span class="hljs-keyword">in</span> output_features.items():
        <span class="hljs-keyword">if</span> expected_key <span class="hljs-keyword">in</span> features:
            feature = features[expected_key]
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;✅ <span class="hljs-subst">{expected_key}</span>: <span class="hljs-subst">{feature.<span class="hljs-built_in">type</span>.value}</span>, shape=<span class="hljs-subst">{feature.shape}</span>&quot;</span>)
            found = <span class="hljs-literal">True</span>
            <span class="hljs-keyword">break</span>

    <span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> found:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;❌ Missing expected feature: <span class="hljs-subst">{expected_key}</span>&quot;</span>)`,wrap:!1}}),be=new j({props:{title:"Summary",local:"summary",headingTag:"h2"}}),Ae=new Hl({props:{source:"https://github.com/huggingface/lerobot/blob/main/docs/source/debug_processor_pipeline.mdx"}}),{c(){m=i("meta"),Ge=n(),Be=i("p"),_e=n(),M(d.$$.fragment),Xe=n(),M(T.$$.fragment),$e=n(),J=i("p"),J.textContent=qt,Ve=n(),U=i("p"),U.innerHTML=Lt,xe=n(),M(f.$$.fragment),Ee=n(),b=i("p"),b.textContent=Pt,Re=n(),M(I.$$.fragment),We=n(),C=i("p"),C.textContent=Dt,Ne=n(),g=i("p"),g.textContent=Kt,Qe=n(),Z=i("p"),Z.textContent=Ot,He=n(),k=i("ul"),k.innerHTML=el,Ye=n(),A=i("p"),A.textContent=tl,Se=n(),M(B.$$.fragment),ze=n(),v=i("p"),v.textContent=ll,Fe=n(),G=i("ul"),G.innerHTML=sl,qe=n(),M(_.$$.fragment),Le=n(),M(X.$$.fragment),Pe=n(),$=i("p"),$.textContent=nl,De=n(),M(V.$$.fragment),Ke=n(),M(x.$$.fragment),Oe=n(),E=i("p"),E.textContent=al,et=n(),R=i("p"),R.textContent=il,tt=n(),W=i("p"),W.innerHTML=pl,lt=n(),N=i("p"),N.textContent=ol,st=n(),M(Q.$$.fragment),nt=n(),M(H.$$.fragment),at=n(),Y=i("p"),Y.textContent=Ml,it=n(),M(S.$$.fragment),pt=n(),z=i("p"),z.textContent=rl,ot=n(),M(F.$$.fragment),Mt=n(),M(q.$$.fragment),rt=n(),L=i("p"),L.textContent=hl,ht=n(),M(P.$$.fragment),ct=n(),D=i("p"),D.textContent=cl,yt=n(),M(K.$$.fragment),ut=n(),O=i("p"),O.textContent=yl,jt=n(),ee=i("p"),ee.textContent=ul,wt=n(),te=i("p"),te.innerHTML=jl,mt=n(),M(le.$$.fragment),dt=n(),se=i("p"),se.innerHTML=wl,Tt=n(),ne=i("p"),ne.innerHTML=ml,Jt=n(),ae=i("p"),ae.textContent=dl,Ut=n(),ie=i("p"),ie.innerHTML=Tl,ft=n(),M(pe.$$.fragment),bt=n(),M(oe.$$.fragment),It=n(),Me=i("p"),Me.textContent=Jl,Ct=n(),M(re.$$.fragment),gt=n(),he=i("p"),he.textContent=Ul,Zt=n(),ce=i("ul"),ce.innerHTML=fl,kt=n(),ye=i("p"),ye.innerHTML=bl,At=n(),M(ue.$$.fragment),Bt=n(),je=i("p"),je.textContent=Il,vt=n(),M(we.$$.fragment),Gt=n(),me=i("p"),me.innerHTML=Cl,_t=n(),M(de.$$.fragment),Xt=n(),M(Te.$$.fragment),$t=n(),Je=i("p"),Je.textContent=gl,Vt=n(),M(Ue.$$.fragment),xt=n(),fe=i("p"),fe.textContent=Zl,Et=n(),M(be.$$.fragment),Rt=n(),Ie=i("p"),Ie.textContent=kl,Wt=n(),Ce=i("ol"),Ce.innerHTML=Al,Nt=n(),ge=i("p"),ge.innerHTML=Bl,Qt=n(),Ze=i("ul"),Ze.innerHTML=vl,Ht=n(),ke=i("p"),ke.textContent=Gl,Yt=n(),M(Ae.$$.fragment),St=n(),ve=i("p"),this.h()},l(e){const t=Wl("svelte-u9bgzb",document.head);m=p(t,"META",{name:!0,content:!0}),t.forEach(l),Ge=a(e),Be=p(e,"P",{}),_l(Be).forEach(l),_e=a(e),r(d.$$.fragment,e),Xe=a(e),r(T.$$.fragment,e),$e=a(e),J=p(e,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1q65nk3"&&(J.textContent=qt),Ve=a(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-u8e3wb"&&(U.innerHTML=Lt),xe=a(e),r(f.$$.fragment,e),Ee=a(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1d4nxx9"&&(b.textContent=Pt),Re=a(e),r(I.$$.fragment,e),We=a(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1tl8qwt"&&(C.textContent=Dt),Ne=a(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-g73lwr"&&(g.textContent=Kt),Qe=a(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-74gmv5"&&(Z.textContent=Ot),He=a(e),k=p(e,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-6outgx"&&(k.innerHTML=el),Ye=a(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-mbtl9h"&&(A.textContent=tl),Se=a(e),r(B.$$.fragment,e),ze=a(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1fbouur"&&(v.textContent=ll),Fe=a(e),G=p(e,"UL",{"data-svelte-h":!0}),o(G)!=="svelte-xsrxoj"&&(G.innerHTML=sl),qe=a(e),r(_.$$.fragment,e),Le=a(e),r(X.$$.fragment,e),Pe=a(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1ks2c33"&&($.textContent=nl),De=a(e),r(V.$$.fragment,e),Ke=a(e),r(x.$$.fragment,e),Oe=a(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-7f17pf"&&(E.textContent=al),et=a(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1nvp99m"&&(R.textContent=il),tt=a(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-bpn8qt"&&(W.innerHTML=pl),lt=a(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1h7hqy"&&(N.textContent=ol),st=a(e),r(Q.$$.fragment,e),nt=a(e),r(H.$$.fragment,e),at=a(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-ufigjs"&&(Y.textContent=Ml),it=a(e),r(S.$$.fragment,e),pt=a(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-c4zafn"&&(z.textContent=rl),ot=a(e),r(F.$$.fragment,e),Mt=a(e),r(q.$$.fragment,e),rt=a(e),L=p(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-oullvg"&&(L.textContent=hl),ht=a(e),r(P.$$.fragment,e),ct=a(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-1kb9xte"&&(D.textContent=cl),yt=a(e),r(K.$$.fragment,e),ut=a(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1ovynfp"&&(O.textContent=yl),jt=a(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-oaf05p"&&(ee.textContent=ul),wt=a(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-v29wbq"&&(te.innerHTML=jl),mt=a(e),r(le.$$.fragment,e),dt=a(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1r8d1yr"&&(se.innerHTML=wl),Tt=a(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-10upnqa"&&(ne.innerHTML=ml),Jt=a(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-14bs306"&&(ae.textContent=dl),Ut=a(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1lcc4zd"&&(ie.innerHTML=Tl),ft=a(e),r(pe.$$.fragment,e),bt=a(e),r(oe.$$.fragment,e),It=a(e),Me=p(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1j32u21"&&(Me.textContent=Jl),Ct=a(e),r(re.$$.fragment,e),gt=a(e),he=p(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-c4rq6s"&&(he.textContent=Ul),Zt=a(e),ce=p(e,"UL",{"data-svelte-h":!0}),o(ce)!=="svelte-5yml2w"&&(ce.innerHTML=fl),kt=a(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-9kdrli"&&(ye.innerHTML=bl),At=a(e),r(ue.$$.fragment,e),Bt=a(e),je=p(e,"P",{"data-svelte-h":!0}),o(je)!=="svelte-1i8k9ls"&&(je.textContent=Il),vt=a(e),r(we.$$.fragment,e),Gt=a(e),me=p(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1tmoeus"&&(me.innerHTML=Cl),_t=a(e),r(de.$$.fragment,e),Xt=a(e),r(Te.$$.fragment,e),$t=a(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1n7eymf"&&(Je.textContent=gl),Vt=a(e),r(Ue.$$.fragment,e),xt=a(e),fe=p(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-duvvy"&&(fe.textContent=Zl),Et=a(e),r(be.$$.fragment,e),Rt=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1klespr"&&(Ie.textContent=kl),Wt=a(e),Ce=p(e,"OL",{"data-svelte-h":!0}),o(Ce)!=="svelte-14jg3j9"&&(Ce.innerHTML=Al),Nt=a(e),ge=p(e,"P",{"data-svelte-h":!0}),o(ge)!=="svelte-1s8mdv6"&&(ge.innerHTML=Bl),Qt=a(e),Ze=p(e,"UL",{"data-svelte-h":!0}),o(Ze)!=="svelte-6ucjs5"&&(Ze.innerHTML=vl),Ht=a(e),ke=p(e,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-dgojim"&&(ke.textContent=Gl),Yt=a(e),r(Ae.$$.fragment,e),St=a(e),ve=p(e,"P",{}),_l(ve).forEach(l),this.h()},h(){Xl(m,"name","hf:doc:metadata"),Xl(m,"content",Sl)},m(e,t){Nl(document.head,m),s(e,Ge,t),s(e,Be,t),s(e,_e,t),h(d,e,t),s(e,Xe,t),h(T,e,t),s(e,$e,t),s(e,J,t),s(e,Ve,t),s(e,U,t),s(e,xe,t),h(f,e,t),s(e,Ee,t),s(e,b,t),s(e,Re,t),h(I,e,t),s(e,We,t),s(e,C,t),s(e,Ne,t),s(e,g,t),s(e,Qe,t),s(e,Z,t),s(e,He,t),s(e,k,t),s(e,Ye,t),s(e,A,t),s(e,Se,t),h(B,e,t),s(e,ze,t),s(e,v,t),s(e,Fe,t),s(e,G,t),s(e,qe,t),h(_,e,t),s(e,Le,t),h(X,e,t),s(e,Pe,t),s(e,$,t),s(e,De,t),h(V,e,t),s(e,Ke,t),h(x,e,t),s(e,Oe,t),s(e,E,t),s(e,et,t),s(e,R,t),s(e,tt,t),s(e,W,t),s(e,lt,t),s(e,N,t),s(e,st,t),h(Q,e,t),s(e,nt,t),h(H,e,t),s(e,at,t),s(e,Y,t),s(e,it,t),h(S,e,t),s(e,pt,t),s(e,z,t),s(e,ot,t),h(F,e,t),s(e,Mt,t),h(q,e,t),s(e,rt,t),s(e,L,t),s(e,ht,t),h(P,e,t),s(e,ct,t),s(e,D,t),s(e,yt,t),h(K,e,t),s(e,ut,t),s(e,O,t),s(e,jt,t),s(e,ee,t),s(e,wt,t),s(e,te,t),s(e,mt,t),h(le,e,t),s(e,dt,t),s(e,se,t),s(e,Tt,t),s(e,ne,t),s(e,Jt,t),s(e,ae,t),s(e,Ut,t),s(e,ie,t),s(e,ft,t),h(pe,e,t),s(e,bt,t),h(oe,e,t),s(e,It,t),s(e,Me,t),s(e,Ct,t),h(re,e,t),s(e,gt,t),s(e,he,t),s(e,Zt,t),s(e,ce,t),s(e,kt,t),s(e,ye,t),s(e,At,t),h(ue,e,t),s(e,Bt,t),s(e,je,t),s(e,vt,t),h(we,e,t),s(e,Gt,t),s(e,me,t),s(e,_t,t),h(de,e,t),s(e,Xt,t),h(Te,e,t),s(e,$t,t),s(e,Je,t),s(e,Vt,t),h(Ue,e,t),s(e,xt,t),s(e,fe,t),s(e,Et,t),h(be,e,t),s(e,Rt,t),s(e,Ie,t),s(e,Wt,t),s(e,Ce,t),s(e,Nt,t),s(e,ge,t),s(e,Qt,t),s(e,Ze,t),s(e,Ht,t),s(e,ke,t),s(e,Yt,t),h(Ae,e,t),s(e,St,t),s(e,ve,t),zt=!0},p:Vl,i(e){zt||(c(d.$$.fragment,e),c(T.$$.fragment,e),c(f.$$.fragment,e),c(I.$$.fragment,e),c(B.$$.fragment,e),c(_.$$.fragment,e),c(X.$$.fragment,e),c(V.$$.fragment,e),c(x.$$.fragment,e),c(Q.$$.fragment,e),c(H.$$.fragment,e),c(S.$$.fragment,e),c(F.$$.fragment,e),c(q.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(le.$$.fragment,e),c(pe.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(ue.$$.fragment,e),c(we.$$.fragment,e),c(de.$$.fragment,e),c(Te.$$.fragment,e),c(Ue.$$.fragment,e),c(be.$$.fragment,e),c(Ae.$$.fragment,e),zt=!0)},o(e){y(d.$$.fragment,e),y(T.$$.fragment,e),y(f.$$.fragment,e),y(I.$$.fragment,e),y(B.$$.fragment,e),y(_.$$.fragment,e),y(X.$$.fragment,e),y(V.$$.fragment,e),y(x.$$.fragment,e),y(Q.$$.fragment,e),y(H.$$.fragment,e),y(S.$$.fragment,e),y(F.$$.fragment,e),y(q.$$.fragment,e),y(P.$$.fragment,e),y(K.$$.fragment,e),y(le.$$.fragment,e),y(pe.$$.fragment,e),y(oe.$$.fragment,e),y(re.$$.fragment,e),y(ue.$$.fragment,e),y(we.$$.fragment,e),y(de.$$.fragment,e),y(Te.$$.fragment,e),y(Ue.$$.fragment,e),y(be.$$.fragment,e),y(Ae.$$.fragment,e),zt=!1},d(e){e&&(l(Ge),l(Be),l(_e),l(Xe),l($e),l(J),l(Ve),l(U),l(xe),l(Ee),l(b),l(Re),l(We),l(C),l(Ne),l(g),l(Qe),l(Z),l(He),l(k),l(Ye),l(A),l(Se),l(ze),l(v),l(Fe),l(G),l(qe),l(Le),l(Pe),l($),l(De),l(Ke),l(Oe),l(E),l(et),l(R),l(tt),l(W),l(lt),l(N),l(st),l(nt),l(at),l(Y),l(it),l(pt),l(z),l(ot),l(Mt),l(rt),l(L),l(ht),l(ct),l(D),l(yt),l(ut),l(O),l(jt),l(ee),l(wt),l(te),l(mt),l(dt),l(se),l(Tt),l(ne),l(Jt),l(ae),l(Ut),l(ie),l(ft),l(bt),l(It),l(Me),l(Ct),l(gt),l(he),l(Zt),l(ce),l(kt),l(ye),l(At),l(Bt),l(je),l(vt),l(Gt),l(me),l(_t),l(Xt),l($t),l(Je),l(Vt),l(xt),l(fe),l(Et),l(Rt),l(Ie),l(Wt),l(Ce),l(Nt),l(ge),l(Qt),l(Ze),l(Ht),l(ke),l(Yt),l(St),l(ve)),l(m),u(d,e),u(T,e),u(f,e),u(I,e),u(B,e),u(_,e),u(X,e),u(V,e),u(x,e),u(Q,e),u(H,e),u(S,e),u(F,e),u(q,e),u(P,e),u(K,e),u(le,e),u(pe,e),u(oe,e),u(re,e),u(ue,e),u(we,e),u(de,e),u(Te,e),u(Ue,e),u(be,e),u(Ae,e)}}}const Sl='{"title":"Debug Your Processor Pipeline","local":"debug-your-processor-pipeline","sections":[{"title":"Understanding Hooks","local":"understanding-hooks","sections":[{"title":"What is a Hook?","local":"what-is-a-hook","sections":[],"depth":3},{"title":"Before vs After Hooks","local":"before-vs-after-hooks","sections":[],"depth":3},{"title":"Implementing a NaN Detection Hook","local":"implementing-a-nan-detection-hook","sections":[],"depth":3},{"title":"How Hooks Work Internally","local":"how-hooks-work-internally","sections":[],"depth":3},{"title":"Execution Flow","local":"execution-flow","sections":[],"depth":3},{"title":"Multiple Hooks","local":"multiple-hooks","sections":[],"depth":3}],"depth":2},{"title":"Step-Through Debugging","local":"step-through-debugging","sections":[{"title":"How Step-Through Works","local":"how-step-through-works","sections":[],"depth":3},{"title":"Interactive Debugging with Breakpoints","local":"interactive-debugging-with-breakpoints","sections":[],"depth":3}],"depth":2},{"title":"Validating Feature Contracts","local":"validating-feature-contracts","sections":[{"title":"Understanding Feature Contracts","local":"understanding-feature-contracts","sections":[],"depth":3},{"title":"Verifying Expected Features","local":"verifying-expected-features","sections":[],"depth":3}],"depth":2},{"title":"Summary","local":"summary","sections":[],"depth":2}],"depth":1}';function zl(Ft){return xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kl extends El{constructor(m){super(),Rl(this,m,zl,Yl,$l,{})}}export{Kl as component};
