import{s as Rt,n as St,o as kt}from"../chunks/scheduler.c90a44b2.js";import{S as Qt,i as Nt,e as i,s as n,c as m,h as Ft,a as p,d as l,b as a,f as _t,g as o,j as b,k as dt,l as Yt,m as s,n as r,t as d,o as u,p as c}from"../chunks/index.66c3f415.js";import{C as zt,H as M}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.989ebcbf.js";import{C as h}from"../chunks/CodeBlock.aad838e0.js";function Ht(ut){let f,be,ue,Me,w,he,J,fe,Z,ye,U,ct=`Stable Diffusion models can also be used when running inference with OpenVINO. When Stable Diffusion models
are exported to the OpenVINO format, they are decomposed into different components that are later combined during inference:`,we,T,bt="<li>The text encoder</li> <li>The U-NET</li> <li>The VAE encoder</li> <li>The VAE decoder</li>",Je,g,Mt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVStableDiffusionPipeline</code></td></tr> <tr><td><code>image-to-image</code></td> <td><code>OVStableDiffusionImg2ImgPipeline</code></td></tr> <tr><td><code>inpaint</code></td> <td><code>OVStableDiffusionInpaintPipeline</code></td></tr></tbody>",Ze,W,Ue,j,ht="Here is an example of how you can load an OpenVINO Stable Diffusion model and run inference using OpenVINO Runtime:",Te,G,ge,B,ft="To load your PyTorch model and convert it to OpenVINO on the fly, you can set <code>export=True</code>.",We,v,je,V,yt="To further speed up inference, the model can be statically reshaped :",Ge,x,Be,I,wt="In case you want to change any parameters such as the outputs height or width, you’ll need to statically reshape your model once again.",ve,y,Jt='<img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/stable_diffusion_v1_5_sail_boat_rembrandt.png"/>',Ve,$,xe,X,Zt="Here is an example of how you can load an OpenVINO Stable Diffusion model with pre-trained textual inversion embeddings and run inference using OpenVINO Runtime:",Ie,C,Ut="First, you can run original pipeline without textual inversion",$e,_,Xe,R,Tt='Then, you can load <a href="https://huggingface.co/sd-concepts-library/cat-toy" rel="nofollow">sd-concepts-library/cat-toy</a> textual inversion embedding and run pipeline with same prompt again',Ce,S,_e,k,gt="The left image shows the generation result of original stable diffusion v1.5, the right image shows the generation result of stable diffusion v1.5 with textual inversion.",Re,Q,Wt='<thead><tr><th></th> <th></th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/textual_inversion/stable_diffusion_v1_5_without_textual_inversion.png"/></td> <td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/textual_inversion/stable_diffusion_v1_5_with_textual_inversion.png"/></td></tr></tbody>',Se,N,ke,F,Qe,Y,Ne,z,jt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVStableDiffusionXLPipeline</code></td></tr> <tr><td><code>image-to-image</code></td> <td><code>OVStableDiffusionXLImg2ImgPipeline</code></td></tr></tbody>",Fe,H,Ye,E,Gt='Here is an example of how you can load a SDXL OpenVINO model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> and run inference using OpenVINO Runtime:',ze,L,He,q,Bt='<thead><tr><th></th> <th></th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/train_station_friedrich.png"/></td> <td><img src="https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/train_station_friedrich_2.png"/></td></tr></tbody>',Ee,D,Le,P,vt='Here is an example of how you can load an SDXL OpenVINO model from <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> with pre-trained textual inversion embeddings and run inference using OpenVINO Runtime:',qe,O,Vt="First, you can run original pipeline without textual inversion",De,A,Pe,K,xt='Then, you can load <a href="https://civitai.com/models/3036/charturner-character-turnaround-helper-for-15-and-21" rel="nofollow">charturnerv2</a> textual inversion embedding and run pipeline with same prompt again',Oe,ee,Ae,te,Ke,le,It="Here is an example of how you can load a PyTorch SDXL model, convert it to OpenVINO on-the-fly and run inference using OpenVINO Runtime for <em>image-to-image</em>:",et,se,tt,ne,lt,ae,$t='The image can be refined by making use of a model like <a href="https://huggingface.co/stabilityai/stable-diffusion-xl-refiner-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-refiner-1.0</a>. In this case, you only have to output the latents from the base model.',st,ie,nt,pe,at,me,Xt="<thead><tr><th>Task</th> <th>Auto Class</th></tr></thead> <tbody><tr><td><code>text-to-image</code></td> <td><code>OVLatentConsistencyModelPipeline</code></td></tr></tbody>",it,oe,pt,re,Ct='Here is an example of how you can load a Latent Consistency Model (LCM) from <a href="https://huggingface.co/SimianLuo/LCM_Dreamshaper_v7" rel="nofollow">SimianLuo/LCM_Dreamshaper_v7</a> and run inference using OpenVINO :',mt,de,ot,ce,rt;return w=new zt({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),J=new M({props:{title:"Generate images with Diffusion models",local:"generate-images-with-diffusion-models",headingTag:"h1"}}),Z=new M({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),W=new M({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),G=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJlY2hhcmxhaXglMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUtb3BlbnZpbm8lMjIlMEFwaXBlbGluZSUyMCUzRCUyME9WU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXByb21wdCUyMCUzRCUyMCUyMnNhaWxpbmclMjBzaGlwJTIwaW4lMjBzdG9ybSUyMGJ5JTIwUmVtYnJhbmR0JTIyJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0KS5pbWFnZXM=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline

model_id = <span class="hljs-string">&quot;echarlaix/stable-diffusion-v1-5-openvino&quot;</span>
pipeline = OVStableDiffusionPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Rembrandt&quot;</span>
images = pipeline(prompt).images`,wrap:!1}}),v=new h({props:{code:"bW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUyMyUyMERvbid0JTIwZm9yZ2V0JTIwdG8lMjBzYXZlJTIwdGhlJTIwZXhwb3J0ZWQlMjBtb2RlbCUwQXBpcGVsaW5lLnNhdmVfcHJldHJhaW5lZCglMjJvcGVudmluby1zZC12MS01JTIyKQ==",highlighted:`model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = OVStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
<span class="hljs-comment"># Don&#x27;t forget to save the exported model</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;openvino-sd-v1-5&quot;</span>)`,wrap:!1}}),x=new h({props:{code:"JTIzJTIwRGVmaW5lJTIwdGhlJTIwc2hhcGVzJTIwcmVsYXRlZCUyMHRvJTIwdGhlJTIwaW5wdXRzJTIwYW5kJTIwZGVzaXJlZCUyMG91dHB1dHMlMEFiYXRjaF9zaXplJTJDJTIwbnVtX2ltYWdlcyUyQyUyMGhlaWdodCUyQyUyMHdpZHRoJTIwJTNEJTIwMSUyQyUyMDElMkMlMjA1MTIlMkMlMjA1MTIlMEElMjMlMjBTdGF0aWNhbGx5JTIwcmVzaGFwZSUyMHRoZSUyMG1vZGVsJTBBcGlwZWxpbmUucmVzaGFwZShiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSUyQyUyMGhlaWdodCUzRGhlaWdodCUyQyUyMHdpZHRoJTNEd2lkdGglMkMlMjBudW1faW1hZ2VzX3Blcl9wcm9tcHQlM0RudW1faW1hZ2VzKSUwQSUyMyUyMENvbXBpbGUlMjB0aGUlMjBtb2RlbCUyMGJlZm9yZSUyMHRoZSUyMGZpcnN0JTIwaW5mZXJlbmNlJTBBcGlwZWxpbmUuY29tcGlsZSgpJTBBJTBBJTIzJTIwUnVuJTIwaW5mZXJlbmNlJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwaGVpZ2h0JTNEaGVpZ2h0JTJDJTIwd2lkdGglM0R3aWR0aCUyQyUyMG51bV9pbWFnZXNfcGVyX3Byb21wdCUzRG51bV9pbWFnZXMpLmltYWdlcw==",highlighted:`<span class="hljs-comment"># Define the shapes related to the inputs and desired outputs</span>
batch_size, num_images, height, width = <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>
<span class="hljs-comment"># Statically reshape the model</span>
pipeline.reshape(batch_size=batch_size, height=height, width=width, num_images_per_prompt=num_images)
<span class="hljs-comment"># Compile the model before the first inference</span>
pipeline.<span class="hljs-built_in">compile</span>()

<span class="hljs-comment"># Run inference</span>
images = pipeline(prompt, height=height, width=width, num_images_per_prompt=num_images).images`,wrap:!1}}),$=new M({props:{title:"Text-to-Image with Textual Inversion",local:"text-to-image-with-textual-inversion",headingTag:"h3"}}),_=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJlY2hhcmxhaXglMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUtb3BlbnZpbm8lMjIlMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwJTNDY2F0LXRveSUzRSUyMGJhY2stcGFjayUyMiUwQSUyMyUyMFNldCUyMGElMjByYW5kb20lMjBzZWVkJTIwZm9yJTIwYmV0dGVyJTIwY29tcGFyaXNvbiUwQW5wLnJhbmRvbS5zZWVkKDQyKSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RGYWxzZSUyQyUyMGNvbXBpbGUlM0RGYWxzZSklMEFwaXBlbGluZS5jb21waWxlKCklMEFpbWFnZTElMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENTApLmltYWdlcyU1QjAlNUQlMEFpbWFnZTEuc2F2ZSglMjJzdGFibGVfZGlmZnVzaW9uX3YxXzVfd2l0aG91dF90ZXh0dWFsX2ludmVyc2lvbi5wbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;echarlaix/stable-diffusion-v1-5-openvino&quot;</span>
prompt = <span class="hljs-string">&quot;A &lt;cat-toy&gt; back-pack&quot;</span>
<span class="hljs-comment"># Set a random seed for better comparison</span>
np.random.seed(<span class="hljs-number">42</span>)

pipeline = OVStableDiffusionPipeline.from_pretrained(model_id, export=<span class="hljs-literal">False</span>, <span class="hljs-built_in">compile</span>=<span class="hljs-literal">False</span>)
pipeline.<span class="hljs-built_in">compile</span>()
image1 = pipeline(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image1.save(<span class="hljs-string">&quot;stable_diffusion_v1_5_without_textual_inversion.png&quot;</span>)`,wrap:!1}}),S=new h({props:{code:"JTIzJTIwUmVzZXQlMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQXBpcGVsaW5lLmNsZWFyX3JlcXVlc3RzKCklMEElMEElMjMlMjBMb2FkJTIwdGV4dHVhbCUyMGludmVyc2lvbiUyMGludG8lMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQXBpcGVsaW5lLmxvYWRfdGV4dHVhbF9pbnZlcnNpb24oJTIyc2QtY29uY2VwdHMtbGlicmFyeSUyRmNhdC10b3klMjIlMkMlMjAlMjIlM0NjYXQtdG95JTNFJTIyKSUwQSUwQSUyMyUyMENvbXBpbGUlMjB0aGUlMjBtb2RlbCUyMGJlZm9yZSUyMHRoZSUyMGZpcnN0JTIwaW5mZXJlbmNlJTBBcGlwZWxpbmUuY29tcGlsZSgpJTBBaW1hZ2UyJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UyLnNhdmUoJTIyc3RhYmxlX2RpZmZ1c2lvbl92MV81X3dpdGhfdGV4dHVhbF9pbnZlcnNpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-comment"># Reset stable diffusion pipeline</span>
pipeline.clear_requests()

<span class="hljs-comment"># Load textual inversion into stable diffusion pipeline</span>
pipeline.load_textual_inversion(<span class="hljs-string">&quot;sd-concepts-library/cat-toy&quot;</span>, <span class="hljs-string">&quot;&lt;cat-toy&gt;&quot;</span>)

<span class="hljs-comment"># Compile the model before the first inference</span>
pipeline.<span class="hljs-built_in">compile</span>()
image2 = pipeline(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image2.save(<span class="hljs-string">&quot;stable_diffusion_v1_5_with_textual_inversion.png&quot;</span>)`,wrap:!1}}),N=new M({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),F=new h({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWZyb20lMjBpbyUyMGltcG9ydCUyMEJ5dGVzSU8lMEFmcm9tJTIwb3B0aW11bS5pbnRlbCUyMGltcG9ydCUyME9WU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkJTJDJTIwZXhwb3J0JTNEVHJ1ZSklMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnJhdy5naXRodWJ1c2VyY29udGVudC5jb20lMkZDb21wVmlzJTJGc3RhYmxlLWRpZmZ1c2lvbiUyRm1haW4lMkZhc3NldHMlMkZzdGFibGUtc2FtcGxlcyUyRmltZzJpbWclMkZza2V0Y2gtbW91bnRhaW5zLWlucHV0LmpwZyUyMiUwQXJlc3BvbnNlJTIwJTNEJTIwcmVxdWVzdHMuZ2V0KHVybCklMEFpbml0X2ltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihCeXRlc0lPKHJlc3BvbnNlLmNvbnRlbnQpKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDc2OCUyQyUyMDUxMikpJTBBcHJvbXB0JTIwJTNEJTIwJTIyQSUyMGZhbnRhc3klMjBsYW5kc2NhcGUlMkMlMjB0cmVuZGluZyUyMG9uJTIwYXJ0c3RhdGlvbiUyMiUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTNEcHJvbXB0JTJDJTIwaW1hZ2UlM0Rpbml0X2ltYWdlJTJDJTIwc3RyZW5ndGglM0QwLjc1JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0Q3LjUpLmltYWdlcyU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMmZhbnRhc3lfbGFuZHNjYXBlLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> io <span class="hljs-keyword">import</span> BytesIO
<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = OVStableDiffusionImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://raw.githubusercontent.com/CompVis/stable-diffusion/main/assets/stable-samples/img2img/sketch-mountains-input.jpg&quot;</span>
response = requests.get(url)
init_image = Image.<span class="hljs-built_in">open</span>(BytesIO(response.content)).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">768</span>, <span class="hljs-number">512</span>))
prompt = <span class="hljs-string">&quot;A fantasy landscape, trending on artstation&quot;</span>
image = pipeline(prompt=prompt, image=init_image, strength=<span class="hljs-number">0.75</span>, guidance_scale=<span class="hljs-number">7.5</span>).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;fantasy_landscape.png&quot;</span>)`,wrap:!1}}),Y=new M({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),H=new M({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),L=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQWJhc2UlMjAlM0QlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKG1vZGVsX2lkKSUwQXByb21wdCUyMCUzRCUyMCUyMnRyYWluJTIwc3RhdGlvbiUyMGJ5JTIwQ2FzcGFyJTIwRGF2aWQlMjBGcmllZHJpY2glMjIlMEFpbWFnZSUyMCUzRCUyMGJhc2UocHJvbXB0KS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJ0cmFpbl9zdGF0aW9uLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
base = OVStableDiffusionXLPipeline.from_pretrained(model_id)
prompt = <span class="hljs-string">&quot;train station by Caspar David Friedrich&quot;</span>
image = base(prompt).images[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;train_station.png&quot;</span>)`,wrap:!1}}),D=new M({props:{title:"Text-to-Image with Textual Inversion",local:"text-to-image-with-textual-inversion",headingTag:"h3"}}),A=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUwQXByb21wdCUyMCUzRCUyMCUyMmNoYXJ0dXJuZXJ2MiUyQyUyMG11bHRpcGxlJTIwdmlld3MlMjBvZiUyMHRoZSUyMHNhbWUlMjBjaGFyYWN0ZXIlMjBpbiUyMHRoZSUyMHNhbWUlMjBvdXRmaXQlMkMlMjBhJTIwY2hhcmFjdGVyJTIwdHVybmFyb3VuZCUyMHdlYXJpbmclMjBhJTIwcmVkJTIwamFja2V0JTIwYW5kJTIwYmxhY2slMjBzaGlydCUyQyUyMGJlc3QlMjBxdWFsaXR5JTJDJTIwaW50cmljYXRlJTIwZGV0YWlscy4lMjIlMEElMjMlMjBTZXQlMjBhJTIwcmFuZG9tJTIwc2VlZCUyMGZvciUyMGJldHRlciUyMGNvbXBhcmlzb24lMEFucC5yYW5kb20uc2VlZCgxMTIpJTBBJTBBYmFzZSUyMCUzRCUyME9WU3RhYmxlRGlmZnVzaW9uWExQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RGYWxzZSUyQyUyMGNvbXBpbGUlM0RGYWxzZSklMEFiYXNlLmNvbXBpbGUoKSUwQWltYWdlMSUyMCUzRCUyMGJhc2UocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UxLnNhdmUoJTIyc2R4bF93aXRob3V0X3RleHR1YWxfaW52ZXJzaW9uLnBuZyUyMik=",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>
prompt = <span class="hljs-string">&quot;charturnerv2, multiple views of the same character in the same outfit, a character turnaround wearing a red jacket and black shirt, best quality, intricate details.&quot;</span>
<span class="hljs-comment"># Set a random seed for better comparison</span>
np.random.seed(<span class="hljs-number">112</span>)

base = OVStableDiffusionXLPipeline.from_pretrained(model_id, export=<span class="hljs-literal">False</span>, <span class="hljs-built_in">compile</span>=<span class="hljs-literal">False</span>)
base.<span class="hljs-built_in">compile</span>()
image1 = base(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image1.save(<span class="hljs-string">&quot;sdxl_without_textual_inversion.png&quot;</span>)`,wrap:!1}}),ee=new h({props:{code:"JTIzJTIwUmVzZXQlMjBzdGFibGUlMjBkaWZmdXNpb24lMjBwaXBlbGluZSUwQWJhc2UuY2xlYXJfcmVxdWVzdHMoKSUwQSUwQSUyMyUyMExvYWQlMjB0ZXh0dWFsJTIwaW52ZXJzaW9uJTIwaW50byUyMHN0YWJsZSUyMGRpZmZ1c2lvbiUyMHBpcGVsaW5lJTBBYmFzZS5sb2FkX3RleHR1YWxfaW52ZXJzaW9uKCUyMi4lMkZjaGFydHVybmVydjIucHQlMjIlMkMlMjAlMjJjaGFydHVybmVydjIlMjIpJTBBJTBBJTIzJTIwQ29tcGlsZSUyMHRoZSUyMG1vZGVsJTIwYmVmb3JlJTIwdGhlJTIwZmlyc3QlMjBpbmZlcmVuY2UlMEFiYXNlLmNvbXBpbGUoKSUwQWltYWdlMiUyMCUzRCUyMGJhc2UocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2UyLnNhdmUoJTIyc2R4bF93aXRoX3RleHR1YWxfaW52ZXJzaW9uLnBuZyUyMik=",highlighted:`<span class="hljs-comment"># Reset stable diffusion pipeline</span>
base.clear_requests()

<span class="hljs-comment"># Load textual inversion into stable diffusion pipeline</span>
base.load_textual_inversion(<span class="hljs-string">&quot;./charturnerv2.pt&quot;</span>, <span class="hljs-string">&quot;charturnerv2&quot;</span>)

<span class="hljs-comment"># Compile the model before the first inference</span>
base.<span class="hljs-built_in">compile</span>()
image2 = base(prompt, num_inference_steps=<span class="hljs-number">50</span>).images[<span class="hljs-number">0</span>]
image2.save(<span class="hljs-string">&quot;sdxl_with_textual_inversion.png&quot;</span>)`,wrap:!1}}),te=new M({props:{title:"Image-to-Image",local:"image-to-image",headingTag:"h3"}}),se=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFtb2RlbF9pZCUyMCUzRCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1yZWZpbmVyLTEuMCUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRm9wdGltdW0lMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGaW50ZWwlMkZvcGVudmlubyUyRnNkX3hsJTJGY2FzdGxlX2ZyaWVkcmljaC5wbmclMjIlMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UodXJsKS5jb252ZXJ0KCUyMlJHQiUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJtZWRpZXZhbCUyMGNhc3RsZSUyMGJ5JTIwQ2FzcGFyJTIwRGF2aWQlMjBGcmllZHJpY2glMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGltYWdlJTNEaW1hZ2UpLmltYWdlcyU1QjAlNUQlMEElMjMlMjBEb24ndCUyMGZvcmdldCUyMHRvJTIwc2F2ZSUyMHlvdXIlMjBPcGVuVklOTyUyMG1vZGVsJTIwc28lMjB0aGF0JTIweW91JTIwY2FuJTIwbG9hZCUyMGl0JTIwd2l0aG91dCUyMGV4cG9ydGluZyUyMGl0JTIwd2l0aCUyMCU2MGV4cG9ydCUzRFRydWUlNjAlMEFwaXBlbGluZS5zYXZlX3ByZXRyYWluZWQoJTIyb3BlbnZpbm8tc2QteGwtcmVmaW5lci0xLjAlMjIp",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLImg2ImgPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
pipeline = OVStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

url = <span class="hljs-string">&quot;https://huggingface.co/datasets/optimum/documentation-images/resolve/main/intel/openvino/sd_xl/castle_friedrich.png&quot;</span>
image = load_image(url).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
prompt = <span class="hljs-string">&quot;medieval castle by Caspar David Friedrich&quot;</span>
image = pipeline(prompt, image=image).images[<span class="hljs-number">0</span>]
<span class="hljs-comment"># Don&#x27;t forget to save your OpenVINO model so that you can load it without exporting it with \`export=True\`</span>
pipeline.save_pretrained(<span class="hljs-string">&quot;openvino-sd-xl-refiner-1.0&quot;</span>)`,wrap:!1}}),ne=new M({props:{title:"Refining the image output",local:"refining-the-image-output",headingTag:"h3"}}),ie=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVlN0YWJsZURpZmZ1c2lvblhMSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtcmVmaW5lci0xLjAlMjIlMEFyZWZpbmVyJTIwJTNEJTIwT1ZTdGFibGVEaWZmdXNpb25YTEltZzJJbWdQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQSUwQWltYWdlJTIwJTNEJTIwYmFzZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMmxhdGVudCUyMikuaW1hZ2VzJTVCMCU1RCUwQWltYWdlJTIwJTNEJTIwcmVmaW5lcihwcm9tcHQlM0Rwcm9tcHQlMkMlMjBpbWFnZSUzRGltYWdlJTVCTm9uZSUyQyUyMCUzQSU1RCkuaW1hZ2VzJTVCMCU1RA==",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVStableDiffusionXLImg2ImgPipeline

model_id = <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-refiner-1.0&quot;</span>
refiner = OVStableDiffusionXLImg2ImgPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)

image = base(prompt=prompt, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images[<span class="hljs-number">0</span>]
image = refiner(prompt=prompt, image=image[<span class="hljs-literal">None</span>, :]).images[<span class="hljs-number">0</span>]`,wrap:!1}}),pe=new M({props:{title:"Latent Consistency Models",local:"latent-consistency-models",headingTag:"h2"}}),oe=new M({props:{title:"Text-to-Image",local:"text-to-image",headingTag:"h3"}}),de=new h({props:{code:"ZnJvbSUyMG9wdGltdW0uaW50ZWwlMjBpbXBvcnQlMjBPVkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyU2ltaWFuTHVvJTJGTENNX0RyZWFtc2hhcGVyX3Y3JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBPVkxhdGVudENvbnNpc3RlbmN5TW9kZWxQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjBleHBvcnQlM0RUcnVlKSUwQXByb21wdCUyMCUzRCUyMCUyMnNhaWxpbmclMjBzaGlwJTIwaW4lMjBzdG9ybSUyMGJ5JTIwTGVvbmFyZG8lMjBkYSUyMFZpbmNpJTIyJTBBaW1hZ2VzJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDguMCkuaW1hZ2Vz",highlighted:`<span class="hljs-keyword">from</span> optimum.intel <span class="hljs-keyword">import</span> OVLatentConsistencyModelPipeline

model_id = <span class="hljs-string">&quot;SimianLuo/LCM_Dreamshaper_v7&quot;</span>
pipeline = OVLatentConsistencyModelPipeline.from_pretrained(model_id, export=<span class="hljs-literal">True</span>)
prompt = <span class="hljs-string">&quot;sailing ship in storm by Leonardo da Vinci&quot;</span>
images = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">8.0</span>).images`,wrap:!1}}),{c(){f=i("meta"),be=n(),ue=i("p"),Me=n(),m(w.$$.fragment),he=n(),m(J.$$.fragment),fe=n(),m(Z.$$.fragment),ye=n(),U=i("p"),U.textContent=ct,we=n(),T=i("ul"),T.innerHTML=bt,Je=n(),g=i("table"),g.innerHTML=Mt,Ze=n(),m(W.$$.fragment),Ue=n(),j=i("p"),j.textContent=ht,Te=n(),m(G.$$.fragment),ge=n(),B=i("p"),B.innerHTML=ft,We=n(),m(v.$$.fragment),je=n(),V=i("p"),V.textContent=yt,Ge=n(),m(x.$$.fragment),Be=n(),I=i("p"),I.textContent=wt,ve=n(),y=i("div"),y.innerHTML=Jt,Ve=n(),m($.$$.fragment),xe=n(),X=i("p"),X.textContent=Zt,Ie=n(),C=i("p"),C.textContent=Ut,$e=n(),m(_.$$.fragment),Xe=n(),R=i("p"),R.innerHTML=Tt,Ce=n(),m(S.$$.fragment),_e=n(),k=i("p"),k.textContent=gt,Re=n(),Q=i("table"),Q.innerHTML=Wt,Se=n(),m(N.$$.fragment),ke=n(),m(F.$$.fragment),Qe=n(),m(Y.$$.fragment),Ne=n(),z=i("table"),z.innerHTML=jt,Fe=n(),m(H.$$.fragment),Ye=n(),E=i("p"),E.innerHTML=Gt,ze=n(),m(L.$$.fragment),He=n(),q=i("table"),q.innerHTML=Bt,Ee=n(),m(D.$$.fragment),Le=n(),P=i("p"),P.innerHTML=vt,qe=n(),O=i("p"),O.textContent=Vt,De=n(),m(A.$$.fragment),Pe=n(),K=i("p"),K.innerHTML=xt,Oe=n(),m(ee.$$.fragment),Ae=n(),m(te.$$.fragment),Ke=n(),le=i("p"),le.innerHTML=It,et=n(),m(se.$$.fragment),tt=n(),m(ne.$$.fragment),lt=n(),ae=i("p"),ae.innerHTML=$t,st=n(),m(ie.$$.fragment),nt=n(),m(pe.$$.fragment),at=n(),me=i("table"),me.innerHTML=Xt,it=n(),m(oe.$$.fragment),pt=n(),re=i("p"),re.innerHTML=Ct,mt=n(),m(de.$$.fragment),ot=n(),ce=i("p"),this.h()},l(e){const t=Ft("svelte-u9bgzb",document.head);f=p(t,"META",{name:!0,content:!0}),t.forEach(l),be=a(e),ue=p(e,"P",{}),_t(ue).forEach(l),Me=a(e),o(w.$$.fragment,e),he=a(e),o(J.$$.fragment,e),fe=a(e),o(Z.$$.fragment,e),ye=a(e),U=p(e,"P",{"data-svelte-h":!0}),b(U)!=="svelte-1isd6gx"&&(U.textContent=ct),we=a(e),T=p(e,"UL",{"data-svelte-h":!0}),b(T)!=="svelte-bu3ryq"&&(T.innerHTML=bt),Je=a(e),g=p(e,"TABLE",{"data-svelte-h":!0}),b(g)!=="svelte-9sg8v5"&&(g.innerHTML=Mt),Ze=a(e),o(W.$$.fragment,e),Ue=a(e),j=p(e,"P",{"data-svelte-h":!0}),b(j)!=="svelte-t90xds"&&(j.textContent=ht),Te=a(e),o(G.$$.fragment,e),ge=a(e),B=p(e,"P",{"data-svelte-h":!0}),b(B)!=="svelte-1870w60"&&(B.innerHTML=ft),We=a(e),o(v.$$.fragment,e),je=a(e),V=p(e,"P",{"data-svelte-h":!0}),b(V)!=="svelte-f1ib2z"&&(V.textContent=yt),Ge=a(e),o(x.$$.fragment,e),Be=a(e),I=p(e,"P",{"data-svelte-h":!0}),b(I)!=="svelte-k76x21"&&(I.textContent=wt),ve=a(e),y=p(e,"DIV",{class:!0,"data-svelte-h":!0}),b(y)!=="svelte-1bbei4i"&&(y.innerHTML=Jt),Ve=a(e),o($.$$.fragment,e),xe=a(e),X=p(e,"P",{"data-svelte-h":!0}),b(X)!=="svelte-gj1zll"&&(X.textContent=Zt),Ie=a(e),C=p(e,"P",{"data-svelte-h":!0}),b(C)!=="svelte-1ephhdh"&&(C.textContent=Ut),$e=a(e),o(_.$$.fragment,e),Xe=a(e),R=p(e,"P",{"data-svelte-h":!0}),b(R)!=="svelte-j9a9m8"&&(R.innerHTML=Tt),Ce=a(e),o(S.$$.fragment,e),_e=a(e),k=p(e,"P",{"data-svelte-h":!0}),b(k)!=="svelte-1ohkhi8"&&(k.textContent=gt),Re=a(e),Q=p(e,"TABLE",{"data-svelte-h":!0}),b(Q)!=="svelte-1sy4xw8"&&(Q.innerHTML=Wt),Se=a(e),o(N.$$.fragment,e),ke=a(e),o(F.$$.fragment,e),Qe=a(e),o(Y.$$.fragment,e),Ne=a(e),z=p(e,"TABLE",{"data-svelte-h":!0}),b(z)!=="svelte-o49bnr"&&(z.innerHTML=jt),Fe=a(e),o(H.$$.fragment,e),Ye=a(e),E=p(e,"P",{"data-svelte-h":!0}),b(E)!=="svelte-1kedcjk"&&(E.innerHTML=Gt),ze=a(e),o(L.$$.fragment,e),He=a(e),q=p(e,"TABLE",{"data-svelte-h":!0}),b(q)!=="svelte-35z5uj"&&(q.innerHTML=Bt),Ee=a(e),o(D.$$.fragment,e),Le=a(e),P=p(e,"P",{"data-svelte-h":!0}),b(P)!=="svelte-1rl3w3v"&&(P.innerHTML=vt),qe=a(e),O=p(e,"P",{"data-svelte-h":!0}),b(O)!=="svelte-1ephhdh"&&(O.textContent=Vt),De=a(e),o(A.$$.fragment,e),Pe=a(e),K=p(e,"P",{"data-svelte-h":!0}),b(K)!=="svelte-197o8c3"&&(K.innerHTML=xt),Oe=a(e),o(ee.$$.fragment,e),Ae=a(e),o(te.$$.fragment,e),Ke=a(e),le=p(e,"P",{"data-svelte-h":!0}),b(le)!=="svelte-1g03pef"&&(le.innerHTML=It),et=a(e),o(se.$$.fragment,e),tt=a(e),o(ne.$$.fragment,e),lt=a(e),ae=p(e,"P",{"data-svelte-h":!0}),b(ae)!=="svelte-1lzmdpv"&&(ae.innerHTML=$t),st=a(e),o(ie.$$.fragment,e),nt=a(e),o(pe.$$.fragment,e),at=a(e),me=p(e,"TABLE",{"data-svelte-h":!0}),b(me)!=="svelte-veyn1t"&&(me.innerHTML=Xt),it=a(e),o(oe.$$.fragment,e),pt=a(e),re=p(e,"P",{"data-svelte-h":!0}),b(re)!=="svelte-5xcutu"&&(re.innerHTML=Ct),mt=a(e),o(de.$$.fragment,e),ot=a(e),ce=p(e,"P",{}),_t(ce).forEach(l),this.h()},h(){dt(f,"name","hf:doc:metadata"),dt(f,"content",Et),dt(y,"class","flex justify-center")},m(e,t){Yt(document.head,f),s(e,be,t),s(e,ue,t),s(e,Me,t),r(w,e,t),s(e,he,t),r(J,e,t),s(e,fe,t),r(Z,e,t),s(e,ye,t),s(e,U,t),s(e,we,t),s(e,T,t),s(e,Je,t),s(e,g,t),s(e,Ze,t),r(W,e,t),s(e,Ue,t),s(e,j,t),s(e,Te,t),r(G,e,t),s(e,ge,t),s(e,B,t),s(e,We,t),r(v,e,t),s(e,je,t),s(e,V,t),s(e,Ge,t),r(x,e,t),s(e,Be,t),s(e,I,t),s(e,ve,t),s(e,y,t),s(e,Ve,t),r($,e,t),s(e,xe,t),s(e,X,t),s(e,Ie,t),s(e,C,t),s(e,$e,t),r(_,e,t),s(e,Xe,t),s(e,R,t),s(e,Ce,t),r(S,e,t),s(e,_e,t),s(e,k,t),s(e,Re,t),s(e,Q,t),s(e,Se,t),r(N,e,t),s(e,ke,t),r(F,e,t),s(e,Qe,t),r(Y,e,t),s(e,Ne,t),s(e,z,t),s(e,Fe,t),r(H,e,t),s(e,Ye,t),s(e,E,t),s(e,ze,t),r(L,e,t),s(e,He,t),s(e,q,t),s(e,Ee,t),r(D,e,t),s(e,Le,t),s(e,P,t),s(e,qe,t),s(e,O,t),s(e,De,t),r(A,e,t),s(e,Pe,t),s(e,K,t),s(e,Oe,t),r(ee,e,t),s(e,Ae,t),r(te,e,t),s(e,Ke,t),s(e,le,t),s(e,et,t),r(se,e,t),s(e,tt,t),r(ne,e,t),s(e,lt,t),s(e,ae,t),s(e,st,t),r(ie,e,t),s(e,nt,t),r(pe,e,t),s(e,at,t),s(e,me,t),s(e,it,t),r(oe,e,t),s(e,pt,t),s(e,re,t),s(e,mt,t),r(de,e,t),s(e,ot,t),s(e,ce,t),rt=!0},p:St,i(e){rt||(d(w.$$.fragment,e),d(J.$$.fragment,e),d(Z.$$.fragment,e),d(W.$$.fragment,e),d(G.$$.fragment,e),d(v.$$.fragment,e),d(x.$$.fragment,e),d($.$$.fragment,e),d(_.$$.fragment,e),d(S.$$.fragment,e),d(N.$$.fragment,e),d(F.$$.fragment,e),d(Y.$$.fragment,e),d(H.$$.fragment,e),d(L.$$.fragment,e),d(D.$$.fragment,e),d(A.$$.fragment,e),d(ee.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ie.$$.fragment,e),d(pe.$$.fragment,e),d(oe.$$.fragment,e),d(de.$$.fragment,e),rt=!0)},o(e){u(w.$$.fragment,e),u(J.$$.fragment,e),u(Z.$$.fragment,e),u(W.$$.fragment,e),u(G.$$.fragment,e),u(v.$$.fragment,e),u(x.$$.fragment,e),u($.$$.fragment,e),u(_.$$.fragment,e),u(S.$$.fragment,e),u(N.$$.fragment,e),u(F.$$.fragment,e),u(Y.$$.fragment,e),u(H.$$.fragment,e),u(L.$$.fragment,e),u(D.$$.fragment,e),u(A.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(se.$$.fragment,e),u(ne.$$.fragment,e),u(ie.$$.fragment,e),u(pe.$$.fragment,e),u(oe.$$.fragment,e),u(de.$$.fragment,e),rt=!1},d(e){e&&(l(be),l(ue),l(Me),l(he),l(fe),l(ye),l(U),l(we),l(T),l(Je),l(g),l(Ze),l(Ue),l(j),l(Te),l(ge),l(B),l(We),l(je),l(V),l(Ge),l(Be),l(I),l(ve),l(y),l(Ve),l(xe),l(X),l(Ie),l(C),l($e),l(Xe),l(R),l(Ce),l(_e),l(k),l(Re),l(Q),l(Se),l(ke),l(Qe),l(Ne),l(z),l(Fe),l(Ye),l(E),l(ze),l(He),l(q),l(Ee),l(Le),l(P),l(qe),l(O),l(De),l(Pe),l(K),l(Oe),l(Ae),l(Ke),l(le),l(et),l(tt),l(lt),l(ae),l(st),l(nt),l(at),l(me),l(it),l(pt),l(re),l(mt),l(ot),l(ce)),l(f),c(w,e),c(J,e),c(Z,e),c(W,e),c(G,e),c(v,e),c(x,e),c($,e),c(_,e),c(S,e),c(N,e),c(F,e),c(Y,e),c(H,e),c(L,e),c(D,e),c(A,e),c(ee,e),c(te,e),c(se,e),c(ne,e),c(ie,e),c(pe,e),c(oe,e),c(de,e)}}}const Et='{"title":"Generate images with Diffusion models","local":"generate-images-with-diffusion-models","sections":[{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Text-to-Image with Textual Inversion","local":"text-to-image-with-textual-inversion","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3},{"title":"Text-to-Image with Textual Inversion","local":"text-to-image-with-textual-inversion","sections":[],"depth":3},{"title":"Image-to-Image","local":"image-to-image","sections":[],"depth":3},{"title":"Refining the image output","local":"refining-the-image-output","sections":[],"depth":3}],"depth":2},{"title":"Latent Consistency Models","local":"latent-consistency-models","sections":[{"title":"Text-to-Image","local":"text-to-image","sections":[],"depth":3}],"depth":2}],"depth":1}';function Lt(ut){return kt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class At extends Qt{constructor(f){super(),Nt(this,f,Lt,Ht,Rt,{})}}export{At as component};
