import{s as vl,n as Bl,o as Gl}from"../chunks/scheduler.56725da7.js";import{S as Zl,i as Wl,e as o,s,c as p,q as bl,h as $l,a as i,d as l,b as a,f as gl,g as m,j as M,r as Al,k as xl,l as kl,m as n,n as r,t as y,o as w,p as h}from"../chunks/index.18a26576.js";import{C as Hl}from"../chunks/CopyLLMTxtMenu.a8c0e768.js";import{C as u}from"../chunks/CodeBlock.83339eda.js";import{H as be}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.c3d650b8.js";function _l(kt){let J,ge,Ie,Ae,T,xe,c,ve,j,Ht='<em>There is a notebook version of that tutorial <a href="https://github.com/huggingface/optimum-neuron/blob/main/notebooks/text-generation/llama2-13b-chatbot.ipynb" rel="nofollow">here</a></em>.',Be,U,_t="This guide will detail how to export, deploy and run a <strong>LLama-2 13B</strong> chat model on AWS inferentia.",Ge,d,Vt="You will learn how to:",Ze,C,Xt="<li>export the Llama-2 model to the Neuron format,</li> <li>push the exported model to the Hugging Face Hub,</li> <li>deploy the model and use it in a chat application.</li>",We,I,zt="Note: This tutorial was created on a inf2.48xlarge AWS EC2 Instance.",$e,f,ke,b,St='For this guide, we will use the non-gated <a href="https://huggingface.co/NousResearch/Llama-2-13b-chat-hf" rel="nofollow">NousResearch/Llama-2-13b-chat-hf</a> model, which is functionally equivalent to the original <a href="https://huggingface.co/meta-llama/Llama-2-13b-chat-hf" rel="nofollow">meta-llama/Llama-2-13b-chat-hf</a>.',He,g,Nt=`This model is part of the <strong>Llama 2</strong> family of models, and has been tuned to recognize chat interactions
between a <em>user</em> and an <em>assistant</em> (more on that later).`,_e,A,Qt=`As explained in the <a href="https://huggingface.co/docs/optimum-neuron/guides/export_model#exporting-llm-models-to-neuron" rel="nofollow">optimum-neuron documentation</a>
, models need to be compiled and exported to a serialized format before running them on Neuron devices.`,Ve,x,Et="When exporting the model, we will specify two sets of parameters:",Xe,v,Lt=`<li>using <em>compiler_args</em>, we specify on how many cores we want the model to be deployed (each neuron device has two cores), and with which precision (here <em>float16</em>),</li> <li>using <em>input_shapes</em>, we set the static input and output dimensions of the model. All model compilers require static shapes, and neuron makes no exception. Note that the
<em>sequence_length</em> not only constrains the length of the input context, but also the length of the Key/Value cache, and thus, the output length.</li>`,ze,B,Yt="Depending on your choice of parameters and inferentia host, this may take from a few minutes to more than an hour.",Se,G,Rt="For your convenience, we host a pre-compiled version of that model on the Hugging Face hub, so you can skip the export and start using the model immediately in section 2.",Ne,Z,Qe,W,qt="This will probably take a while.",Ee,$,Ft="Fortunately, you will need to do this only once because you can save your model and reload it later.",Le,k,Ye,H,Pt='Even better, you can push it to the <a href="https://huggingface.co/models" rel="nofollow">Hugging Face hub</a>.',Re,_,Kt='For that, you need to be logged in to a <a href="https://huggingface.co/join" rel="nofollow">HuggingFace account</a>.',qe,V,Dt="In the terminal, just type the following command and paste your Hugging Face token when requested:",Fe,X,Pe,z,Ot="By default, the model will be uploaded to your account (organization equal to your user name).",Ke,S,el='Feel free to edit the code below if you want to upload the model to a specific <a href="https://huggingface.co/docs/hub/organizations" rel="nofollow">Hugging Face organization</a>.',De,N,Oe,Q,et,E,tl="The minimum memory required to load a model can be computed with:",tt,L,lt,Y,ll="The <strong>Llama 2 13B</strong> model uses <em>float16</em> weights (stored on 2 bytes) and has 13 billion parameters, which means it requires at least 2 * 13B or ~26GB of memory to store its weights.",nt,R,nl="Each NeuronCore has 16GB of memory which means that a 26GB model cannot fit on a single NeuronCore.",st,q,sl=`In reality, the total space required is much greater than just the number of parameters due to caching attention layer projections (KV caching).
This caching mechanism grows memory allocations linearly with sequence length and batch size.`,at,F,al="Here we set the <em>batch_size</em> to 1, meaning that we can only process one input prompt in parallel. We set the <em>sequence_length</em> to 2048, which corresponds to half the model maximum capacity (4096).",ot,P,ol="The formula to evaluate the size of the KV cache is more involved as it also depends on parameters related to the model architecture, such as the width of the embeddings and the number of decoder blocks.",it,K,il="Bottom-line is, to get very large language models to fit, tensor parallelism is used to split weights, data, and compute across multiple NeuronCores, keeping in mind that the memory on each core cannot exceed 16GB.",Mt,D,Ml=`Note that increasing the number of cores beyond the minimum requirement almost always results in a faster model.
Increasing the tensor parallelism degree improves memory bandwidth which improves model performance.`,pt,O,pl="To optimize performance it’s recommended to use all cores available on the instance.",mt,ee,ml=`In this guide we use all the 24 cores of the <em>inf2.48xlarge</em>, but this should be changed to 12 if you are
using a <em>inf2.24xlarge</em> instance.`,rt,te,yt,le,rl='Once your model has been exported, you can generate text using the transformers library, as it has been described in <a href="https://huggingface.co/blog/how-to-generate" rel="nofollow">detail in this post</a>.',wt,ne,yl="If as suggested you skipped the first section, don’t worry: we will use a precompiled model already present on the hub instead.",ht,se,ut,ae,wl="We will need a <em>Llama 2</em> tokenizer to convert the prompt strings to text tokens.",Jt,oe,Tt,ie,hl="The following generation strategies are supported:",ct,Me,ul="<li>greedy search,</li> <li>multinomial sampling with top-k and top-p (with temperature).</li>",jt,pe,Jl="Most logits pre-processing/filters (such as repetition penalty) are supported.",Ut,me,dt,re,Ct,ye,Tl="We specifically selected a <strong>Llama 2</strong> chat variant to illustrate the excellent behaviour of the exported model when the length of the encoding context grows.",It,we,cl="The model expects the prompts to be formatted following a specific template corresponding to the interactions between a <em>user</em> role and an <em>assistant</em> role.",ft,he,jl='Each chat model has its own convention for encoding such contents, and we will not go into too much details in this guide, because we will directly use the <a href="https://huggingface.co/blog/chat-templates" rel="nofollow">Hugging Face chat templates</a> corresponding to our model.',bt,ue,Ul="The utility function below converts a list of exchanges between the user and the model into a well-formatted chat prompt.",gt,Je,At,Te,dl="We are now equipped to build a simplistic chat application.",xt,ce,Cl=`We simply store the interactions between the user and the assistant in a list that we use to generate
the input prompt.`,vt,je,Bt,Ue,Il="To test the chat application you can use for instance the following sequence of prompts:",Gt,de,Zt,Ce,fl="While very powerful, Large language models can sometimes <em>hallucinate</em>. We call <em>hallucinations</em> generated content that is irrelevant or made-up but presented by the model as if it was accurate. This is a flaw of LLMs and is not a side effect of using them on Trainium / Inferentia.",Wt,fe,$t;return T=new Hl({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),c=new be({props:{title:"Create your own chatbot with llama-2-13B on AWS Inferentia",local:"create-your-own-chatbot-with-llama-2-13b-on-aws-inferentia",headingTag:"h1"}}),f=new be({props:{title:"1. Export the Llama 2 model to Neuron",local:"1-export-the-llama-2-model-to-neuron",headingTag:"h2"}}),Z=new u({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQWNvbXBpbGVyX2FyZ3MlMjAlM0QlMjAlN0IlMjJ0ZW5zb3JfcGFyYWxsZWxfc2l6ZSUyMiUzQSUyMDI0JTdEJTBBaW5wdXRfc2hhcGVzJTIwJTNEJTIwJTdCJTIyYmF0Y2hfc2l6ZSUyMiUzQSUyMDElMkMlMjAlMjJzZXF1ZW5jZV9sZW5ndGglMjIlM0ElMjAyMDQ4JTdEJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJOb3VzUmVzZWFyY2glMkZMbGFtYS0yLTEzYi1jaGF0LWhmJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZXhwb3J0JTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqY29tcGlsZXJfYXJncyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCoqaW5wdXRfc2hhcGVzKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM

compiler_args = {<span class="hljs-string">&quot;tensor_parallel_size&quot;</span>: <span class="hljs-number">24</span>}
input_shapes = {<span class="hljs-string">&quot;batch_size&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;sequence_length&quot;</span>: <span class="hljs-number">2048</span>}
model = NeuronModelForCausalLM.from_pretrained(
        <span class="hljs-string">&quot;NousResearch/Llama-2-13b-chat-hf&quot;</span>,
        export=<span class="hljs-literal">True</span>,
        **compiler_args,
        **input_shapes)`,wrap:!1}}),k=new u({props:{code:"bW9kZWwuc2F2ZV9wcmV0cmFpbmVkKCUyMmxsYW1hLTItMTNiLWNoYXQtbmV1cm9uJTIyKQ==",highlighted:'model.save_pretrained(<span class="hljs-string">&quot;llama-2-13b-chat-neuron&quot;</span>)',wrap:!1}}),X=new u({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),N=new u({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHdob2FtaSUwQSUwQW9yZyUyMCUzRCUyMHdob2FtaSgpJTVCJ25hbWUnJTVEJTBBJTBBcmVwb19pZCUyMCUzRCUyMGYlMjIlN0JvcmclN0QlMkZsbGFtYS0yLTEzYi1jaGF0LW5ldXJvbiUyMiUwQSUwQW1vZGVsLnB1c2hfdG9faHViKCUyMmxsYW1hLTItMTNiLWNoYXQtbmV1cm9uJTIyJTJDJTIwcmVwb3NpdG9yeV9pZCUzRHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> whoami

org = whoami()[<span class="hljs-string">&#x27;name&#x27;</span>]

repo_id = <span class="hljs-string">f&quot;<span class="hljs-subst">{org}</span>/llama-2-13b-chat-neuron&quot;</span>

model.push_to_hub(<span class="hljs-string">&quot;llama-2-13b-chat-neuron&quot;</span>, repository_id=repo_id)`,wrap:!1}}),Q=new be({props:{title:"A few more words about export parameters.",local:"a-few-more-words-about-export-parameters",headingTag:"h3"}}),L=new u({props:{code:"JTIwJTIwJTIwbWVtb3J5JTIwJTNEJTIwYnl0ZXMlMjBwZXIlMjBwYXJhbWV0ZXIlMjAqJTIwbnVtYmVyJTIwb2YlMjBwYXJhbWV0ZXJz",highlighted:'   memory = bytes per <span class="hljs-keyword">parameter</span> * <span class="hljs-keyword">number</span> of parameters',wrap:!1}}),te=new be({props:{title:"2. Generate text using Llama 2 on AWS Inferentia2",local:"2-generate-text-using-llama-2-on-aws-inferentia2",headingTag:"h2"}}),se=new u({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uTW9kZWxGb3JDYXVzYWxMTSUwQSUwQXRyeSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsJTBBZXhjZXB0JTIwTmFtZUVycm9yJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRWRpdCUyMHRoaXMlMjB0byUyMHVzZSUyMGFub3RoZXIlMjBiYXNlJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCdhd3MtbmV1cm9uJTJGTGxhbWEtMi0xM2ItY2hhdC1oZi1uZXVyb24tbGF0ZW5jeScp",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCausalLM

<span class="hljs-keyword">try</span>:
    model
<span class="hljs-keyword">except</span> NameError:
    <span class="hljs-comment"># Edit this to use another base model</span>
    model = NeuronModelForCausalLM.from_pretrained(<span class="hljs-string">&#x27;aws-neuron/Llama-2-13b-chat-hf-neuron-latency&#x27;</span>)`,wrap:!1}}),oe=new u({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJOb3VzUmVzZWFyY2glMkZMbGFtYS0yLTEzYi1jaGF0LWhmJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;NousResearch/Llama-2-13b-chat-hf&quot;</span>)`,wrap:!1}}),me=new u({props:{code:"aW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMldoYXQlMjBpcyUyMGRlZXAtbGVhcm5pbmclMjAlM0YlMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKmlucHV0cyUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTI4JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9fc2FtcGxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRlbXBlcmF0dXJlJTNEMC45JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9wX2slM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRvcF9wJTNEMC45KSUwQXRva2VuaXplci5iYXRjaF9kZWNvZGUob3V0cHV0cyUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKQ==",highlighted:`inputs = tokenizer(<span class="hljs-string">&quot;What is deep-learning ?&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
outputs = model.generate(**inputs,
                         max_new_tokens=<span class="hljs-number">128</span>,
                         do_sample=<span class="hljs-literal">True</span>,
                         temperature=<span class="hljs-number">0.9</span>,
                         top_k=<span class="hljs-number">50</span>,
                         top_p=<span class="hljs-number">0.9</span>)
tokenizer.batch_decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)`,wrap:!1}}),re=new be({props:{title:"3. Create a chat application using llama on AWS Inferentia2",local:"3-create-a-chat-application-using-llama-on-aws-inferentia2",headingTag:"h2"}}),Je=new u({props:{code:"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",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">format_chat_prompt</span>(<span class="hljs-params">message, history, max_tokens</span>):
    <span class="hljs-string">&quot;&quot;&quot; Convert a history of messages to a chat prompt


    Args:
        message(str): the new user message.
        history (List[str]): the list of user messages and assistant responses.
        max_tokens (int): the maximum number of input tokens accepted by the model.

    Returns:
        a \`str\` prompt.
    &quot;&quot;&quot;</span>
    chat = []
    <span class="hljs-comment"># Convert all messages in history to chat interactions</span>
    <span class="hljs-keyword">for</span> interaction <span class="hljs-keyword">in</span> history:
        chat.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span> : interaction[<span class="hljs-number">0</span>]})
        chat.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>, <span class="hljs-string">&quot;content&quot;</span> : interaction[<span class="hljs-number">1</span>]})
    <span class="hljs-comment"># Add the new message</span>
    chat.append({<span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>, <span class="hljs-string">&quot;content&quot;</span> : message})
    <span class="hljs-comment"># Generate the prompt, verifying that we don&#x27;t go beyond the maximum number of tokens</span>
    <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(chat), <span class="hljs-number">2</span>):
        <span class="hljs-comment"># Generate candidate prompt with the last n-i entries</span>
        prompt = tokenizer.apply_chat_template(chat[i:], tokenize=<span class="hljs-literal">False</span>)
        <span class="hljs-comment"># Tokenize to check if we&#x27;re over the limit</span>
        tokens = tokenizer(prompt)
        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(tokens.input_ids) &lt;= max_tokens:
            <span class="hljs-comment"># We&#x27;re good, stop here</span>
            <span class="hljs-keyword">return</span> prompt
    <span class="hljs-comment"># We shall never reach this line</span>
    <span class="hljs-keyword">raise</span> SystemError`,wrap:!1}}),je=new u({props:{code:"aGlzdG9yeSUyMCUzRCUyMCU1QiU1RCUwQW1heF90b2tlbnMlMjAlM0QlMjAxMDI0JTBBJTBBZGVmJTIwY2hhdChtZXNzYWdlJTJDJTIwaGlzdG9yeSUyQyUyMG1heF90b2tlbnMpJTNBJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTIwJTNEJTIwZm9ybWF0X2NoYXRfcHJvbXB0KG1lc3NhZ2UlMkMlMjBoaXN0b3J5JTJDJTIwbWF4X3Rva2VucyklMEElMjAlMjAlMjAlMjAlMjMlMjBVbmNvbW1lbnQlMjB0aGUlMjBsaW5lJTIwYmVsb3clMjB0byUyMHNlZSUyMHdoYXQlMjB0aGUlMjBmb3JtYXR0ZWQlMjBwcm9tcHQlMjBsb29rcyUyMGxpa2UlMEElMjAlMjAlMjAlMjAlMjNwcmludChwcm9tcHQpJTBBJTIwJTIwJTIwJTIwaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X2xlbmd0aCUzRDIwNDglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkb19zYW1wbGUlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdGVtcGVyYXR1cmUlM0QwLjklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b3BfayUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVwZXRpdGlvbl9wZW5hbHR5JTNEMS4yKSUwQSUyMCUyMCUyMCUyMCUyMyUyMERvJTIwbm90JTIwaW5jbHVkZSUyMHRoZSUyMGlucHV0JTIwdG9rZW5zJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG91dHB1dHMlNUIwJTJDJTIwaW5wdXRzLmlucHV0X2lkcy5zaXplKC0xKSUzQSU1RCUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUpJTBBJTIwJTIwJTIwJTIwaGlzdG9yeS5hcHBlbmQoJTVCbWVzc2FnZSUyQyUyMHJlc3BvbnNlJTVEKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHJlc3BvbnNl",highlighted:`history = []
max_tokens = <span class="hljs-number">1024</span>

<span class="hljs-keyword">def</span> <span class="hljs-title function_">chat</span>(<span class="hljs-params">message, history, max_tokens</span>):
    prompt = format_chat_prompt(message, history, max_tokens)
    <span class="hljs-comment"># Uncomment the line below to see what the formatted prompt looks like</span>
    <span class="hljs-comment">#print(prompt)</span>
    inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
    outputs = model.generate(**inputs,
                             max_length=<span class="hljs-number">2048</span>,
                             do_sample=<span class="hljs-literal">True</span>,
                             temperature=<span class="hljs-number">0.9</span>,
                             top_k=<span class="hljs-number">50</span>,
                             repetition_penalty=<span class="hljs-number">1.2</span>)
    <span class="hljs-comment"># Do not include the input tokens</span>
    outputs = outputs[<span class="hljs-number">0</span>, inputs.input_ids.size(-<span class="hljs-number">1</span>):]
    response = tokenizer.decode(outputs, skip_special_tokens=<span class="hljs-literal">True</span>)
    history.append([message, response])
    <span class="hljs-keyword">return</span> response`,wrap:!1}}),de=new u({props:{code:"cHJpbnQoY2hhdCglMjJNeSUyMGZhdm9yaXRlJTIwY29sb3IlMjBpcyUyMGJsdWUuJTIwTXklMjBmYXZvcml0ZSUyMGZydWl0JTIwaXMlMjBzdHJhd2JlcnJ5LiUyMiUyQyUyMGhpc3RvcnklMkMlMjBtYXhfdG9rZW5zKSklMEFwcmludChjaGF0KCUyMk5hbWUlMjBhJTIwZnJ1aXQlMjB0aGF0JTIwaXMlMjBvbiUyMG15JTIwZmF2b3JpdGUlMjBjb2xvdXIuJTIyJTJDJTIwaGlzdG9yeSUyQyUyMG1heF90b2tlbnMpKSUwQXByaW50KGNoYXQoJTIyV2hhdCUyMGlzJTIwdGhlJTIwY29sb3VyJTIwb2YlMjBteSUyMGZhdm9yaXRlJTIwZnJ1aXQlMjAlM0YlMjIlMkMlMjBoaXN0b3J5JTJDJTIwbWF4X3Rva2Vucykp",highlighted:`<span class="hljs-built_in">print</span>(chat(<span class="hljs-string">&quot;My favorite color is blue. My favorite fruit is strawberry.&quot;</span>, history, max_tokens))
<span class="hljs-built_in">print</span>(chat(<span class="hljs-string">&quot;Name a fruit that is on my favorite colour.&quot;</span>, history, max_tokens))
<span class="hljs-built_in">print</span>(chat(<span class="hljs-string">&quot;What is the colour of my favorite fruit ?&quot;</span>, history, max_tokens))`,wrap:!1}}),{c(){J=o("meta"),ge=s(),Ie=o("p"),Ae=s(),p(T.$$.fragment),xe=s(),p(c.$$.fragment),ve=s(),j=o("p"),j.innerHTML=Ht,Be=s(),U=o("p"),U.innerHTML=_t,Ge=s(),d=o("p"),d.textContent=Vt,Ze=s(),C=o("ul"),C.innerHTML=Xt,We=s(),I=o("p"),I.textContent=zt,$e=s(),p(f.$$.fragment),ke=s(),b=o("p"),b.innerHTML=St,He=s(),g=o("p"),g.innerHTML=Nt,_e=s(),A=o("p"),A.innerHTML=Qt,Ve=s(),x=o("p"),x.textContent=Et,Xe=s(),v=o("ul"),v.innerHTML=Lt,ze=s(),B=o("p"),B.textContent=Yt,Se=s(),G=o("p"),G.textContent=Rt,Ne=s(),p(Z.$$.fragment),Qe=s(),W=o("p"),W.textContent=qt,Ee=s(),$=o("p"),$.textContent=Ft,Le=s(),p(k.$$.fragment),Ye=s(),H=o("p"),H.innerHTML=Pt,Re=s(),_=o("p"),_.innerHTML=Kt,qe=s(),V=o("p"),V.textContent=Dt,Fe=s(),p(X.$$.fragment),Pe=s(),z=o("p"),z.textContent=Ot,Ke=s(),S=o("p"),S.innerHTML=el,De=s(),p(N.$$.fragment),Oe=s(),p(Q.$$.fragment),et=s(),E=o("p"),E.textContent=tl,tt=s(),p(L.$$.fragment),lt=s(),Y=o("p"),Y.innerHTML=ll,nt=s(),R=o("p"),R.textContent=nl,st=s(),q=o("p"),q.textContent=sl,at=s(),F=o("p"),F.innerHTML=al,ot=s(),P=o("p"),P.textContent=ol,it=s(),K=o("p"),K.textContent=il,Mt=s(),D=o("p"),D.textContent=Ml,pt=s(),O=o("p"),O.textContent=pl,mt=s(),ee=o("p"),ee.innerHTML=ml,rt=s(),p(te.$$.fragment),yt=s(),le=o("p"),le.innerHTML=rl,wt=s(),ne=o("p"),ne.textContent=yl,ht=s(),p(se.$$.fragment),ut=s(),ae=o("p"),ae.innerHTML=wl,Jt=s(),p(oe.$$.fragment),Tt=s(),ie=o("p"),ie.textContent=hl,ct=s(),Me=o("ul"),Me.innerHTML=ul,jt=s(),pe=o("p"),pe.textContent=Jl,Ut=s(),p(me.$$.fragment),dt=s(),p(re.$$.fragment),Ct=s(),ye=o("p"),ye.innerHTML=Tl,It=s(),we=o("p"),we.innerHTML=cl,ft=s(),he=o("p"),he.innerHTML=jl,bt=s(),ue=o("p"),ue.textContent=Ul,gt=s(),p(Je.$$.fragment),At=s(),Te=o("p"),Te.textContent=dl,xt=s(),ce=o("p"),ce.textContent=Cl,vt=s(),p(je.$$.fragment),Bt=s(),Ue=o("p"),Ue.textContent=Il,Gt=s(),p(de.$$.fragment),Zt=bl(`
<Warning>
`),Ce=o("p"),Ce.innerHTML=fl,Wt=bl(`
</Warning>

`),fe=o("p"),this.h()},l(e){const t=$l("svelte-u9bgzb",document.head);J=i(t,"META",{name:!0,content:!0}),t.forEach(l),ge=a(e),Ie=i(e,"P",{}),gl(Ie).forEach(l),Ae=a(e),m(T.$$.fragment,e),xe=a(e),m(c.$$.fragment,e),ve=a(e),j=i(e,"P",{"data-svelte-h":!0}),M(j)!=="svelte-14mc9a1"&&(j.innerHTML=Ht),Be=a(e),U=i(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1skq0wn"&&(U.innerHTML=_t),Ge=a(e),d=i(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-1hahfn0"&&(d.textContent=Vt),Ze=a(e),C=i(e,"UL",{"data-svelte-h":!0}),M(C)!=="svelte-1ivcbtp"&&(C.innerHTML=Xt),We=a(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-1jogm5f"&&(I.textContent=zt),$e=a(e),m(f.$$.fragment,e),ke=a(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1hepwaf"&&(b.innerHTML=St),He=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-1s9dc42"&&(g.innerHTML=Nt),_e=a(e),A=i(e,"P",{"data-svelte-h":!0}),M(A)!=="svelte-16q26vx"&&(A.innerHTML=Qt),Ve=a(e),x=i(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-vz83yd"&&(x.textContent=Et),Xe=a(e),v=i(e,"UL",{"data-svelte-h":!0}),M(v)!=="svelte-1z4h5r"&&(v.innerHTML=Lt),ze=a(e),B=i(e,"P",{"data-svelte-h":!0}),M(B)!=="svelte-i8skpg"&&(B.textContent=Yt),Se=a(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-121tgcd"&&(G.textContent=Rt),Ne=a(e),m(Z.$$.fragment,e),Qe=a(e),W=i(e,"P",{"data-svelte-h":!0}),M(W)!=="svelte-1j7pdia"&&(W.textContent=qt),Ee=a(e),$=i(e,"P",{"data-svelte-h":!0}),M($)!=="svelte-wxy07q"&&($.textContent=Ft),Le=a(e),m(k.$$.fragment,e),Ye=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-16smhm8"&&(H.innerHTML=Pt),Re=a(e),_=i(e,"P",{"data-svelte-h":!0}),M(_)!=="svelte-1jkprhy"&&(_.innerHTML=Kt),qe=a(e),V=i(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-1lo2b6p"&&(V.textContent=Dt),Fe=a(e),m(X.$$.fragment,e),Pe=a(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-8c3of4"&&(z.textContent=Ot),Ke=a(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-1kcpd2e"&&(S.innerHTML=el),De=a(e),m(N.$$.fragment,e),Oe=a(e),m(Q.$$.fragment,e),et=a(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-mi975y"&&(E.textContent=tl),tt=a(e),m(L.$$.fragment,e),lt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-zmj8oy"&&(Y.innerHTML=ll),nt=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1hs4joy"&&(R.textContent=nl),st=a(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-13xxwf3"&&(q.textContent=sl),at=a(e),F=i(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-13q3i6n"&&(F.innerHTML=al),ot=a(e),P=i(e,"P",{"data-svelte-h":!0}),M(P)!=="svelte-mdqsxr"&&(P.textContent=ol),it=a(e),K=i(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-12eo3v5"&&(K.textContent=il),Mt=a(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-qqihmw"&&(D.textContent=Ml),pt=a(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-13dz4vh"&&(O.textContent=pl),mt=a(e),ee=i(e,"P",{"data-svelte-h":!0}),M(ee)!=="svelte-exk3d9"&&(ee.innerHTML=ml),rt=a(e),m(te.$$.fragment,e),yt=a(e),le=i(e,"P",{"data-svelte-h":!0}),M(le)!=="svelte-a6bs6o"&&(le.innerHTML=rl),wt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-zz3frh"&&(ne.textContent=yl),ht=a(e),m(se.$$.fragment,e),ut=a(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-1ps6mip"&&(ae.innerHTML=wl),Jt=a(e),m(oe.$$.fragment,e),Tt=a(e),ie=i(e,"P",{"data-svelte-h":!0}),M(ie)!=="svelte-1y7mxpx"&&(ie.textContent=hl),ct=a(e),Me=i(e,"UL",{"data-svelte-h":!0}),M(Me)!=="svelte-a4n5id"&&(Me.innerHTML=ul),jt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-k217aq"&&(pe.textContent=Jl),Ut=a(e),m(me.$$.fragment,e),dt=a(e),m(re.$$.fragment,e),Ct=a(e),ye=i(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-1ezk4g0"&&(ye.innerHTML=Tl),It=a(e),we=i(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-1e1yopm"&&(we.innerHTML=cl),ft=a(e),he=i(e,"P",{"data-svelte-h":!0}),M(he)!=="svelte-1xcz5ok"&&(he.innerHTML=jl),bt=a(e),ue=i(e,"P",{"data-svelte-h":!0}),M(ue)!=="svelte-1v5xgsn"&&(ue.textContent=Ul),gt=a(e),m(Je.$$.fragment,e),At=a(e),Te=i(e,"P",{"data-svelte-h":!0}),M(Te)!=="svelte-1hfx6dq"&&(Te.textContent=dl),xt=a(e),ce=i(e,"P",{"data-svelte-h":!0}),M(ce)!=="svelte-ffg1bu"&&(ce.textContent=Cl),vt=a(e),m(je.$$.fragment,e),Bt=a(e),Ue=i(e,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-hnyltz"&&(Ue.textContent=Il),Gt=a(e),m(de.$$.fragment,e),Zt=Al(e,`
<Warning>
`),Ce=i(e,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-l0vp04"&&(Ce.innerHTML=fl),Wt=Al(e,`
</Warning>

`),fe=i(e,"P",{}),gl(fe).forEach(l),this.h()},h(){xl(J,"name","hf:doc:metadata"),xl(J,"content",Vl)},m(e,t){kl(document.head,J),n(e,ge,t),n(e,Ie,t),n(e,Ae,t),r(T,e,t),n(e,xe,t),r(c,e,t),n(e,ve,t),n(e,j,t),n(e,Be,t),n(e,U,t),n(e,Ge,t),n(e,d,t),n(e,Ze,t),n(e,C,t),n(e,We,t),n(e,I,t),n(e,$e,t),r(f,e,t),n(e,ke,t),n(e,b,t),n(e,He,t),n(e,g,t),n(e,_e,t),n(e,A,t),n(e,Ve,t),n(e,x,t),n(e,Xe,t),n(e,v,t),n(e,ze,t),n(e,B,t),n(e,Se,t),n(e,G,t),n(e,Ne,t),r(Z,e,t),n(e,Qe,t),n(e,W,t),n(e,Ee,t),n(e,$,t),n(e,Le,t),r(k,e,t),n(e,Ye,t),n(e,H,t),n(e,Re,t),n(e,_,t),n(e,qe,t),n(e,V,t),n(e,Fe,t),r(X,e,t),n(e,Pe,t),n(e,z,t),n(e,Ke,t),n(e,S,t),n(e,De,t),r(N,e,t),n(e,Oe,t),r(Q,e,t),n(e,et,t),n(e,E,t),n(e,tt,t),r(L,e,t),n(e,lt,t),n(e,Y,t),n(e,nt,t),n(e,R,t),n(e,st,t),n(e,q,t),n(e,at,t),n(e,F,t),n(e,ot,t),n(e,P,t),n(e,it,t),n(e,K,t),n(e,Mt,t),n(e,D,t),n(e,pt,t),n(e,O,t),n(e,mt,t),n(e,ee,t),n(e,rt,t),r(te,e,t),n(e,yt,t),n(e,le,t),n(e,wt,t),n(e,ne,t),n(e,ht,t),r(se,e,t),n(e,ut,t),n(e,ae,t),n(e,Jt,t),r(oe,e,t),n(e,Tt,t),n(e,ie,t),n(e,ct,t),n(e,Me,t),n(e,jt,t),n(e,pe,t),n(e,Ut,t),r(me,e,t),n(e,dt,t),r(re,e,t),n(e,Ct,t),n(e,ye,t),n(e,It,t),n(e,we,t),n(e,ft,t),n(e,he,t),n(e,bt,t),n(e,ue,t),n(e,gt,t),r(Je,e,t),n(e,At,t),n(e,Te,t),n(e,xt,t),n(e,ce,t),n(e,vt,t),r(je,e,t),n(e,Bt,t),n(e,Ue,t),n(e,Gt,t),r(de,e,t),n(e,Zt,t),n(e,Ce,t),n(e,Wt,t),n(e,fe,t),$t=!0},p:Bl,i(e){$t||(y(T.$$.fragment,e),y(c.$$.fragment,e),y(f.$$.fragment,e),y(Z.$$.fragment,e),y(k.$$.fragment,e),y(X.$$.fragment,e),y(N.$$.fragment,e),y(Q.$$.fragment,e),y(L.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(oe.$$.fragment,e),y(me.$$.fragment,e),y(re.$$.fragment,e),y(Je.$$.fragment,e),y(je.$$.fragment,e),y(de.$$.fragment,e),$t=!0)},o(e){w(T.$$.fragment,e),w(c.$$.fragment,e),w(f.$$.fragment,e),w(Z.$$.fragment,e),w(k.$$.fragment,e),w(X.$$.fragment,e),w(N.$$.fragment,e),w(Q.$$.fragment,e),w(L.$$.fragment,e),w(te.$$.fragment,e),w(se.$$.fragment,e),w(oe.$$.fragment,e),w(me.$$.fragment,e),w(re.$$.fragment,e),w(Je.$$.fragment,e),w(je.$$.fragment,e),w(de.$$.fragment,e),$t=!1},d(e){e&&(l(ge),l(Ie),l(Ae),l(xe),l(ve),l(j),l(Be),l(U),l(Ge),l(d),l(Ze),l(C),l(We),l(I),l($e),l(ke),l(b),l(He),l(g),l(_e),l(A),l(Ve),l(x),l(Xe),l(v),l(ze),l(B),l(Se),l(G),l(Ne),l(Qe),l(W),l(Ee),l($),l(Le),l(Ye),l(H),l(Re),l(_),l(qe),l(V),l(Fe),l(Pe),l(z),l(Ke),l(S),l(De),l(Oe),l(et),l(E),l(tt),l(lt),l(Y),l(nt),l(R),l(st),l(q),l(at),l(F),l(ot),l(P),l(it),l(K),l(Mt),l(D),l(pt),l(O),l(mt),l(ee),l(rt),l(yt),l(le),l(wt),l(ne),l(ht),l(ut),l(ae),l(Jt),l(Tt),l(ie),l(ct),l(Me),l(jt),l(pe),l(Ut),l(dt),l(Ct),l(ye),l(It),l(we),l(ft),l(he),l(bt),l(ue),l(gt),l(At),l(Te),l(xt),l(ce),l(vt),l(Bt),l(Ue),l(Gt),l(Zt),l(Ce),l(Wt),l(fe)),l(J),h(T,e),h(c,e),h(f,e),h(Z,e),h(k,e),h(X,e),h(N,e),h(Q,e),h(L,e),h(te,e),h(se,e),h(oe,e),h(me,e),h(re,e),h(Je,e),h(je,e),h(de,e)}}}const Vl='{"title":"Create your own chatbot with llama-2-13B on AWS Inferentia","local":"create-your-own-chatbot-with-llama-2-13b-on-aws-inferentia","sections":[{"title":"1. Export the Llama 2 model to Neuron","local":"1-export-the-llama-2-model-to-neuron","sections":[{"title":"A few more words about export parameters.","local":"a-few-more-words-about-export-parameters","sections":[],"depth":3}],"depth":2},{"title":"2. Generate text using Llama 2 on AWS Inferentia2","local":"2-generate-text-using-llama-2-on-aws-inferentia2","sections":[],"depth":2},{"title":"3. Create a chat application using llama on AWS Inferentia2","local":"3-create-a-chat-application-using-llama-on-aws-inferentia2","sections":[],"depth":2}],"depth":1}';function Xl(kt){return Gl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ll extends Zl{constructor(J){super(),Wl(this,J,Xl,_l,vl,{})}}export{Ll as component};
