import{s as fd,o as hd,n as x}from"../chunks/scheduler.56725da7.js";import{S as _d,i as bd,e as i,s as n,c as p,h as Md,a as c,d as a,b as r,f as w,g as u,j as M,k as T,l as o,m,n as g,t as f,o as h,p as _}from"../chunks/index.18a26576.js";import{T as Nd}from"../chunks/Tip.5b941656.js";import{C as vd}from"../chunks/CopyLLMTxtMenu.a8c0e768.js";import{D as $}from"../chunks/Docstring.5e042fbb.js";import{C as F}from"../chunks/CodeBlock.83339eda.js";import{E as Z}from"../chunks/ExampleCodeBlock.e57fdb5c.js";import{H as k}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.c3d650b8.js";function yd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckZlYXR1cmVFeHRyYWN0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmFsbC1NaW5pTE0tTDYtdjItbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yRmVhdHVyZUV4dHJhY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZhbGwtTWluaUxNLUw2LXYyLW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkRlYXIlMjBFdmFuJTIwSGFuc2VuJTIwaXMlMjB0aGUlMjB3aW5uZXIlMjBvZiUyMHNpeCUyMFRvbnklMjBBd2FyZHMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbGFzdF9oaWRkZW5fc3RhdGUlMjAlM0QlMjBvdXRwdXRzLmxhc3RfaGlkZGVuX3N0YXRlJTBBbGlzdChsYXN0X2hpZGRlbl9zdGF0ZS5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForFeatureExtraction

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForFeatureExtraction.from_pretrained(<span class="hljs-string">&quot;optimum/all-MiniLM-L6-v2-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Dear Evan Hansen is the winner of six Tony Awards.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>last_hidden_state = outputs.last_hidden_state
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(last_hidden_state.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">13</span>, <span class="hljs-number">384</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function wd(j){let l,y="Text Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlbnRlbmNlVHJhbnNmb3JtZXJzJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJnZS1iYXNlLWVuLXYxLjUtbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VudGVuY2VUcmFuc2Zvcm1lcnMuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZ2UtYmFzZS1lbi12MS41LW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkluJTIwdGhlJTIwc21vdWxkZXJpbmclMjBwcm9taXNlJTIwb2YlMjB0aGUlMjBmYWxsJTIwb2YlMjBUcm95JTJDJTIwYSUyMG15dGhpY2FsJTIwd29ybGQlMjBvZiUyMGdvZHMlMjBhbmQlMjBtb3J0YWxzJTIwcmlzZXMlMjBmcm9tJTIwdGhlJTIwYXNoZXMuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBdG9rZW5fZW1iZWRkaW5ncyUyMCUzRCUyMG91dHB1dHMudG9rZW5fZW1iZWRkaW5ncyUwQXNlbnRlbmNlX2VtYmVkZGluZyUyMCUzRCUyMCUzRCUyMG91dHB1dHMuc2VudGVuY2VfZW1iZWRkaW5n",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bge-base-en-v1.5-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSentenceTransformers.from_pretrained(<span class="hljs-string">&quot;optimum/bge-base-en-v1.5-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;In the smouldering promise of the fall of Troy, a mythical world of gods and mortals rises from the ashes.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>token_embeddings = outputs.token_embeddings
<span class="hljs-meta">&gt;&gt;&gt; </span>sentence_embedding = = outputs.sentence_embedding`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-1vtqn41"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Td(j){let l,y="Image Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwdXRpbCUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvbk1vZGVsRm9yU2VudGVuY2VUcmFuc2Zvcm1lcnMlMEElMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGY2xpcF92aXRfZW1iX25ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlbnRlbmNlVHJhbnNmb3JtZXJzLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGY2xpcF92aXRfZW1iX25ldXJvbnglMjIpJTBBdXRpbC5odHRwX2dldCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZVS1BMYWIlMkZzZW50ZW5jZS10cmFuc2Zvcm1lcnMlMkZyYXclMkZtYXN0ZXIlMkZleGFtcGxlcyUyRnNlbnRlbmNlX3RyYW5zZm9ybWVyJTJGYXBwbGljYXRpb25zJTJGaW1hZ2Utc2VhcmNoJTJGdHdvX2RvZ3NfaW5fc25vdy5qcGclMjIlMkMlMjAlMjJ0d29fZG9nc19pbl9zbm93LmpwZyUyMiklMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoJTBBJTIwJTIwJTIwJTIwdGV4dCUzRCU1QiUyMlR3byUyMGRvZ3MlMjBpbiUyMHRoZSUyMHNub3clMjIlMkMlMjAnQSUyMGNhdCUyMG9uJTIwYSUyMHRhYmxlJyUyQyUyMCdBJTIwcGljdHVyZSUyMG9mJTIwTG9uZG9uJTIwYXQlMjBuaWdodCclNUQlMkMlMjBpbWFnZXMlM0RJbWFnZS5vcGVuKCUyMnR3b19kb2dzX2luX3Nub3cuanBnJTIyKSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBwYWRkaW5nJTNEVHJ1ZSUwQSklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBY29zX3Njb3JlcyUyMCUzRCUyMHV0aWwuY29zX3NpbShvdXRwdXRzLmltYWdlX2VtYmVkcyUyQyUyMG91dHB1dHMudGV4dF9lbWJlZHMpJTIwJTIwJTIzJTIwQ29tcHV0ZSUyMGNvc2luZSUyMHNpbWlsYXJpdGllcw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> util
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSentenceTransformers

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/clip_vit_emb_neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSentenceTransformers.from_pretrained(<span class="hljs-string">&quot;optimum/clip_vit_emb_neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>util.http_get(<span class="hljs-string">&quot;https://github.com/UKPLab/sentence-transformers/raw/master/examples/sentence_transformer/applications/image-search/two_dogs_in_snow.jpg&quot;</span>, <span class="hljs-string">&quot;two_dogs_in_snow.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(
<span class="hljs-meta">&gt;&gt;&gt; </span>    text=[<span class="hljs-string">&quot;Two dogs in the snow&quot;</span>, <span class="hljs-string">&#x27;A cat on a table&#x27;</span>, <span class="hljs-string">&#x27;A picture of London at night&#x27;</span>], images=Image.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;two_dogs_in_snow.jpg&quot;</span>), return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>cos_scores = util.cos_sim(outputs.image_embeds, outputs.text_embeds)  <span class="hljs-comment"># Compute cosine similarities</span>`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-l4l8dd"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function $d(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvck1hc2tlZExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmxlZ2FsLWJlcnQtYmFzZS11bmNhc2VkLW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvck1hc2tlZExNLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGbGVnYWwtYmVydC1iYXNlLXVuY2FzZWQtbmV1cm9ueCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIoJTIyVGhpcyUyMCU1Qk1BU0slNUQlMjBBZ3JlZW1lbnQlMjBpcyUyMGJldHdlZW4lMjBHZW5lcmFsJTIwTW90b3JzJTIwYW5kJTIwSm9obiUyME11cnJheS4lMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForMaskedLM

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/legal-bert-base-uncased-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForMaskedLM.from_pretrained(<span class="hljs-string">&quot;optimum/legal-bert-base-uncased-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;This [MASK] Agreement is between General Motors and John Murray.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">13</span>, <span class="hljs-number">30522</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function jd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQtZmluZXR1bmVkLXNzdC0yLWVuZ2xpc2gtbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbi5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmRpc3RpbGJlcnQtYmFzZS11bmNhc2VkLWZpbmV0dW5lZC1zc3QtMi1lbmdsaXNoLW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKCUyMkhhbWlsdG9uJTIwaXMlMjBjb25zaWRlcmVkJTIwdG8lMjBiZSUyMHRoZSUyMGJlc3QlMjBtdXNpY2FsJTIwb2YlMjBodW1hbiUyMGhpc3RvcnkuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;optimum/distilbert-base-uncased-finetuned-sst-2-english-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Hamilton is considered to be the best musical of human history.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function kd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbiUyMGltcG9ydCUyME5ldXJvbk1vZGVsRm9yUXVlc3Rpb25BbnN3ZXJpbmclMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGcm9iZXJ0YS1iYXNlLXNxdWFkMi1uZXVyb254JTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JRdWVzdGlvbkFuc3dlcmluZy5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnJvYmVydGEtYmFzZS1zcXVhZDItbmV1cm9ueCUyMiklMEElMEFxdWVzdGlvbiUyQyUyMHRleHQlMjAlM0QlMjAlMjJBcmUlMjB0aGVyZSUyMHdoZWVsY2hhaXIlMjBzcGFjZXMlMjBpbiUyMHRoZSUyMHRoZWF0cmVzJTNGJTIyJTJDJTIwJTIyWWVzJTJDJTIwd2UlMjBoYXZlJTIwcmVzZXJ2ZWQlMjB3aGVlbGNoYWlyJTIwc3BhY2VzJTIwd2l0aCUyMGElMjBnb29kJTIwdmlldy4lMjIlMEFpbnB1dHMlMjAlM0QlMjB0b2tlbml6ZXIocXVlc3Rpb24lMkMlMjB0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFzdGFydF9wb3NpdGlvbnMlMjAlM0QlMjB0b3JjaC50ZW5zb3IoJTVCMSU1RCklMEFlbmRfcG9zaXRpb25zJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QjEyJTVEKSUwQSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyUyQyUyMHN0YXJ0X3Bvc2l0aW9ucyUzRHN0YXJ0X3Bvc2l0aW9ucyUyQyUyMGVuZF9wb3NpdGlvbnMlM0RlbmRfcG9zaXRpb25zKSUwQXN0YXJ0X3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuc3RhcnRfbG9naXRzJTBBZW5kX3Njb3JlcyUyMCUzRCUyMG91dHB1dHMuZW5kX2xvZ2l0cw==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForQuestionAnswering

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForQuestionAnswering.from_pretrained(<span class="hljs-string">&quot;optimum/roberta-base-squad2-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>question, text = <span class="hljs-string">&quot;Are there wheelchair spaces in the theatres?&quot;</span>, <span class="hljs-string">&quot;Yes, we have reserved wheelchair spaces with a good view.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(question, text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_positions = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>end_positions = torch.tensor([<span class="hljs-number">12</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, start_positions=start_positions, end_positions=end_positions)
<span class="hljs-meta">&gt;&gt;&gt; </span>start_scores = outputs.start_logits
<span class="hljs-meta">&gt;&gt;&gt; </span>end_scores = outputs.end_logits`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Cd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclRva2VuQ2xhc3NpZmljYXRpb24lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGYmVydC1iYXNlLU5FUi1uZXVyb254JTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JUb2tlbkNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGYmVydC1iYXNlLU5FUi1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJMaW4tTWFudWVsJTIwTWlyYW5kYSUyMGlzJTIwYW4lMjBBbWVyaWNhbiUyMHNvbmd3cml0ZXIlMkMlMjBhY3RvciUyQyUyMHNpbmdlciUyQyUyMGZpbG1tYWtlciUyQyUyMGFuZCUyMHBsYXl3cmlnaHQuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForTokenClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForTokenClassification.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-NER-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(<span class="hljs-string">&quot;Lin-Manuel Miranda is an American songwriter, actor, singer, filmmaker, and playwright.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">20</span>, <span class="hljs-number">9</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Jd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvck11bHRpcGxlQ2hvaWNlJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRmJlcnQtYmFzZS11bmNhc2VkX1NXQUctbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yTXVsdGlwbGVDaG9pY2UuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZiZXJ0LWJhc2UtdW5jYXNlZF9TV0FHLW5ldXJvbnglMjIpJTBBJTBBbnVtX2Nob2ljZXMlMjAlM0QlMjA0JTBBZmlyc3Rfc2VudGVuY2UlMjAlM0QlMjAlNUIlMjJNZW1iZXJzJTIwb2YlMjB0aGUlMjBwcm9jZXNzaW9uJTIwd2FsayUyMGRvd24lMjB0aGUlMjBzdHJlZXQlMjBob2xkaW5nJTIwc21hbGwlMjBob3JuJTIwYnJhc3MlMjBpbnN0cnVtZW50cy4lMjIlNUQlMjAqJTIwbnVtX2Nob2ljZXMlMEFzZWNvbmRfc2VudGVuY2UlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjBwYXNzZXMlMjBieSUyMHdhbGtpbmclMjBkb3duJTIwdGhlJTIwc3RyZWV0JTIwcGxheWluZyUyMHRoZWlyJTIwaW5zdHJ1bWVudHMuJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGRydW0lMjBsaW5lJTIwaGFzJTIwaGVhcmQlMjBhcHByb2FjaGluZyUyMHRoZW0uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQSUyMGRydW0lMjBsaW5lJTIwYXJyaXZlcyUyMGFuZCUyMHRoZXkncmUlMjBvdXRzaWRlJTIwZGFuY2luZyUyMGFuZCUyMGFzbGVlcC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBJTIwZHJ1bSUyMGxpbmUlMjB0dXJucyUyMHRoZSUyMGxlYWQlMjBzaW5nZXIlMjB3YXRjaGVzJTIwdGhlJTIwcGVyZm9ybWFuY2UuJTIyJTBBJTVEJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKGZpcnN0X3NlbnRlbmNlJTJDJTIwc2Vjb25kX3NlbnRlbmNlJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUlMkMlMjBwYWRkaW5nJTNEVHJ1ZSklMEElMEFmb3IlMjBrJTJDJTIwdiUyMGluJTIwaW5wdXRzLml0ZW1zKCklM0ElMEElMjAlMjAlMjAlMjBpbnB1dHMlNUJrJTVEJTIwJTNEJTIwJTVCdiU1QmklM0ElMjBpJTIwJTJCJTIwbnVtX2Nob2ljZXMlNUQlMjBmb3IlMjBpJTIwaW4lMjByYW5nZSgwJTJDJTIwbGVuKHYpJTJDJTIwbnVtX2Nob2ljZXMpJTVEJTBBaW5wdXRzJTIwJTNEJTIwZGljdChpbnB1dHMuY29udmVydF90b190ZW5zb3JzKHRlbnNvcl90eXBlJTNEJTIycHQlMjIpKSUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxvZ2l0cy5zaGFwZQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForMultipleChoice

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased_SWAG-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForMultipleChoice.from_pretrained(<span class="hljs-string">&quot;optimum/bert-base-uncased_SWAG-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>num_choices = <span class="hljs-number">4</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>first_sentence = [<span class="hljs-string">&quot;Members of the procession walk down the street holding small horn brass instruments.&quot;</span>] * num_choices
<span class="hljs-meta">&gt;&gt;&gt; </span>second_sentence = [
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line passes by walking down the street playing their instruments.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line has heard approaching them.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line arrives and they&#x27;re outside dancing and asleep.&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A drum line turns the lead singer watches the performance.&quot;</span>
<span class="hljs-meta">... </span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(first_sentence, second_sentence, truncation=<span class="hljs-literal">True</span>, padding=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Unflatten the inputs values expanding it to the shape [batch_size, num_choices, seq_length]</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> inputs.items():
<span class="hljs-meta">... </span>    inputs[k] = [v[i: i + num_choices] <span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">0</span>, <span class="hljs-built_in">len</span>(v), num_choices)]
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(inputs.convert_to_tensors(tensor_type=<span class="hljs-string">&quot;pt&quot;</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>logits.shape
[<span class="hljs-number">1</span>, <span class="hljs-number">4</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function xd(j){let l,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=i("p"),l.innerHTML=y},l(b){l=c(b,"P",{"data-svelte-h":!0}),M(l)!=="svelte-fincs2"&&(l.innerHTML=y)},m(b,d){m(b,l,d)},p:x,d(b){b&&a(l)}}}function Id(j){let l,y="Example of text-to-text generation:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTSUwQSUyMyUyMGV4cG9ydCUwQW5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZChnb29nbGUtdDUlMkZ0NS1zbWFsbCUyQyUyMGV4cG9ydCUzRFRydWUlMkMlMjBkeW5hbWljX2JhdGNoX3NpemUlM0RGYWxzZSUyQyUyMGJhdGNoX3NpemUlM0QxJTJDJTIwc2VxdWVuY2VfbGVuZ3RoJTNENjQlMkMlMjBudW1fYmVhbXMlM0Q0KSUwQW5ldXJvbl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIydDVfc21hbGxfbmV1cm9ueCUyMiklMEFkZWwlMjBuZXVyb25fbW9kZWwlMEElMEElMjMlMjBpbmZlcmVuY2UlMEFuZXVyb25fbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIydDVfc21hbGxfbmV1cm9ueCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJ0NV9zbWFsbF9uZXVyb254JTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJ0cmFuc2xhdGUlMjBFbmdsaXNoJTIwdG8lMjBHZXJtYW4lM0ElMjBMZXRzJTIwZWF0JTIwZ29vZCUyMGZvb2QuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBuZXVyb25fbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDElMkMlMEEpJTBBcmVzdWx0cyUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUodCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUyMGZvciUyMHQlMjBpbiUyMG91dHB1dCU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSeq2SeqLM
<span class="hljs-comment"># export</span>
neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(google-t5/t5-small, export=<span class="hljs-literal">True</span>, dynamic_batch_size=<span class="hljs-literal">False</span>, batch_size=<span class="hljs-number">1</span>, sequence_length=<span class="hljs-number">64</span>, num_beams=<span class="hljs-number">4</span>)
neuron_model.save_pretrained(<span class="hljs-string">&quot;t5_small_neuronx&quot;</span>)
<span class="hljs-keyword">del</span> neuron_model

<span class="hljs-comment"># inference</span>
neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;t5_small_neuronx&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;t5_small_neuronx&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;translate English to German: Lets eat good food.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

output = neuron_model.generate(
    **inputs,
    num_return_sequences=<span class="hljs-number">1</span>,
)
results = [tokenizer.decode(t, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> output]`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-hhyk5s"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Zd(j){let l,y="Example of text-to-text generation with tensor parallelism:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTSUwQSUyMyUyMGV4cG9ydCUwQWlmJTIwX19uYW1lX18lMjAlM0QlM0QlMjAlMjJfX21haW5fXyUyMiUzQSUyMCUyMCUyMyUyMGNvbXB1bHNvcnklMjBmb3IlMjBwYXJhbGxlbCUyMHRyYWNpbmclMjBzaW5jZSUyMHRoZSUyMEFQSSUyMHdpbGwlMjBzcGF3biUyMG11bHRpcGxlJTIwcHJvY2Vzc2VzLiUwQSUyMCUyMCUyMCUyMG5ldXJvbl9tb2RlbCUyMCUzRCUyME5ldXJvbk1vZGVsRm9yU2VxMlNlcUxNLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBnb29nbGUlMkZmbGFuLXQ1LXhsJTJDJTIwZXhwb3J0JTNEVHJ1ZSUyQyUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEOCUyQyUyMGR5bmFtaWNfYmF0Y2hfc2l6ZSUzREZhbHNlJTJDJTIwYmF0Y2hfc2l6ZSUzRDElMkMlMjBzZXF1ZW5jZV9sZW5ndGglM0QxMjglMkMlMjBudW1fYmVhbXMlM0Q0JTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMG5ldXJvbl9tb2RlbC5zYXZlX3ByZXRyYWluZWQoJTIyZmxhbl90NV94bF9uZXVyb254X3RwOCUyMiklMEElMjAlMjAlMjAlMjBkZWwlMjBuZXVyb25fbW9kZWwlMEElMjMlMjBpbmZlcmVuY2UlMEFuZXVyb25fbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlcTJTZXFMTS5mcm9tX3ByZXRyYWluZWQoJTIyZmxhbl90NV94bF9uZXVyb254X3RwOCUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJmbGFuX3Q1X3hsX25ldXJvbnhfdHA4JTIyKSUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplciglMjJ0cmFuc2xhdGUlMjBFbmdsaXNoJTIwdG8lMjBHZXJtYW4lM0ElMjBMZXRzJTIwZWF0JTIwZ29vZCUyMGZvb2QuJTIyJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXQlMjAlM0QlMjBuZXVyb25fbW9kZWwuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwKippbnB1dHMlMkMlMEElMjAlMjAlMjAlMjBudW1fcmV0dXJuX3NlcXVlbmNlcyUzRDElMkMlMEEpJTBBcmVzdWx0cyUyMCUzRCUyMCU1QnRva2VuaXplci5kZWNvZGUodCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUyMGZvciUyMHQlMjBpbiUyMG91dHB1dCU1RA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSeq2SeqLM
<span class="hljs-comment"># export</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:  <span class="hljs-comment"># compulsory for parallel tracing since the API will spawn multiple processes.</span>
    neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(
        google/flan-t5-xl, export=<span class="hljs-literal">True</span>, tensor_parallel_size=<span class="hljs-number">8</span>, dynamic_batch_size=<span class="hljs-literal">False</span>, batch_size=<span class="hljs-number">1</span>, sequence_length=<span class="hljs-number">128</span>, num_beams=<span class="hljs-number">4</span>,
    )
    neuron_model.save_pretrained(<span class="hljs-string">&quot;flan_t5_xl_neuronx_tp8&quot;</span>)
    <span class="hljs-keyword">del</span> neuron_model
<span class="hljs-comment"># inference</span>
neuron_model = NeuronModelForSeq2SeqLM.from_pretrained(<span class="hljs-string">&quot;flan_t5_xl_neuronx_tp8&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;flan_t5_xl_neuronx_tp8&quot;</span>)
inputs = tokenizer(<span class="hljs-string">&quot;translate English to German: Lets eat good food.&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

output = neuron_model.generate(
    **inputs,
    num_return_sequences=<span class="hljs-number">1</span>,
)
results = [tokenizer.decode(t, skip_special_tokens=<span class="hljs-literal">True</span>) <span class="hljs-keyword">for</span> t <span class="hljs-keyword">in</span> output]`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-onp91"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Fd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b0ltYWdlUHJvY2Vzc29yJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQXByZXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyb3B0aW11bSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0LW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckltYWdlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZ2aXQtYmFzZS1wYXRjaDE2LTIyNC1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByZXByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBcHJlZGljdGVkX2xhYmVsJTIwJTNEJTIwbG9naXRzLmFyZ21heCgtMSkuaXRlbSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForImageClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForImageClassification.from_pretrained(<span class="hljs-string">&quot;optimum/vit-base-patch16-224-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = logits.argmax(-<span class="hljs-number">1</span>).item()`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Xd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUwQSUwQXVybCUyMCUzRCUyMCUyMmh0dHAlM0ElMkYlMkZpbWFnZXMuY29jb2RhdGFzZXQub3JnJTJGdmFsMjAxNyUyRjAwMDAwMDAzOTc2OS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFwcmVwcm9jZXNzb3IlMjAlM0QlMjBBdXRvSW1hZ2VQcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMm9wdGltdW0lMkZkZWVwbGFidjMtbW9iaWxldml0LXNtYWxsLW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclNlbWFudGljU2VnbWVudGF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJvcHRpbXVtJTJGZGVlcGxhYnYzLW1vYmlsZXZpdC1zbWFsbC1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMHByZXByb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRz",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForSemanticSegmentation
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;optimum/deeplabv3-mobilevit-small-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForSemanticSegmentation.from_pretrained(<span class="hljs-string">&quot;optimum/deeplabv3-mobilevit-small-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Ud(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvck9iamVjdERldGVjdGlvbiUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBBdXRvSW1hZ2VQcm9jZXNzb3IlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBcHJlcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJodXN0dmwlMkZ5b2xvcy10aW55JTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JPYmplY3REZXRlY3Rpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmh1c3R2bCUyRnlvbG9zLXRpbnklMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwcHJlcHJvY2Vzc29yKGltYWdlcyUzRGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpJTBBdGFyZ2V0X3NpemVzJTIwJTNEJTIwdG9yY2gudGVuc29yKCU1QmltYWdlLnNpemUlNUIlM0ElM0EtMSU1RCU1RCklMEFyZXN1bHRzJTIwJTNEJTIwaW1hZ2VfcHJvY2Vzc29yLnBvc3RfcHJvY2Vzc19vYmplY3RfZGV0ZWN0aW9uKG91dHB1dHMlMkMlMjB0aHJlc2hvbGQlM0QwLjklMkMlMjB0YXJnZXRfc2l6ZXMlM0R0YXJnZXRfc2l6ZXMpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForObjectDetection
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForObjectDetection.from_pretrained(<span class="hljs-string">&quot;hustvl/yolos-tiny&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = preprocessor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>target_sizes = torch.tensor([image.size[::-<span class="hljs-number">1</span>]])
<span class="hljs-meta">&gt;&gt;&gt; </span>results = image_processor.post_process_object_detection(outputs, threshold=<span class="hljs-number">0.9</span>, target_sizes=target_sizes)[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Sd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24lMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvckF1ZGlvQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtYXVkaW8tY2xhc3NpZmljYXRpb24lMjIpJTBBJTBBJTIzJTIwYXVkaW8lMjBmaWxlJTIwaXMlMjBkZWNvZGVkJTIwb24lMjB0aGUlMjBmbHklMEFpbnB1dHMlMjAlM0QlMjBmZWF0dXJlX2V4dHJhY3RvcihkYXRhc2V0JTVCMCU1RCU1QiUyMmF1ZGlvJTIyJTVEJTVCJTIyYXJyYXklMjIlNUQlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTBBbG9naXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMpLmxvZ2l0cyUwQXByZWRpY3RlZF9jbGFzc19pZHMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpLml0ZW0oKSUwQXByZWRpY3RlZF9sYWJlbCUyMCUzRCUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHMlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForAudioClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-audio-classification&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForAudioClassification.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-audio-classification&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_label = model.config.id2label[predicted_class_ids]`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Vd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckF1ZGlvRnJhbWVDbGFzc2lmaWNhdGlvbiUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQWZlYXR1cmVfZXh0cmFjdG9yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGd2F2MnZlYzItYmFzZS1zdXBlcmItc2QtbmV1cm9ueCUyMiklMEFtb2RlbCUyMCUzRCUyMCUyME5ldXJvbk1vZGVsRm9yQXVkaW9GcmFtZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJKaW5neWElMkZ3YXYydmVjMi1iYXNlLXN1cGVyYi1zZC1uZXVyb254JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGZlYXR1cmVfZXh0cmFjdG9yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIlMkMlMjBzYW1wbGluZ19yYXRlJTNEc2FtcGxpbmdfcmF0ZSklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBJTBBcHJvYmFiaWxpdGllcyUyMCUzRCUyMHRvcmNoLnNpZ21vaWQobG9naXRzJTVCMCU1RCklMEFsYWJlbHMlMjAlM0QlMjAocHJvYmFiaWxpdGllcyUyMCUzRSUyMDAuNSkubG9uZygpJTBBbGFiZWxzJTVCMCU1RC50b2xpc3QoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForAudioFrameClassification
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sd-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model =  NeuronModelForAudioFrameClassification.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sd-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, sampling_rate=sampling_rate)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits

<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.sigmoid(logits[<span class="hljs-number">0</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = (probabilities &gt; <span class="hljs-number">0.5</span>).long()
<span class="hljs-meta">&gt;&gt;&gt; </span>labels[<span class="hljs-number">0</span>].tolist()`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function zd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckNUQyUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUwQWltcG9ydCUyMHRvcmNoJTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQXNhbXBsaW5nX3JhdGUlMjAlM0QlMjBkYXRhc2V0LmZlYXR1cmVzJTVCJTIyYXVkaW8lMjIlNUQuc2FtcGxpbmdfcmF0ZSUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtY3RjJTIyKSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtY3RjJTIyKSUwQSUwQSUyMyUyMGF1ZGlvJTIwZmlsZSUyMGlzJTIwZGVjb2RlZCUyMG9uJTIwdGhlJTIwZmx5JTBBaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGRhdGFzZXQlNUIwJTVEJTVCJTIyYXVkaW8lMjIlNUQlNUIlMjJhcnJheSUyMiU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEFsb2dpdHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykubG9naXRzJTBBcHJlZGljdGVkX2lkcyUyMCUzRCUyMHRvcmNoLmFyZ21heChsb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMEF0cmFuc2NyaXB0aW9uJTIwJTNEJTIwcHJvY2Vzc29yLmJhdGNoX2RlY29kZShwcmVkaWN0ZWRfaWRzKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCTC
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForCTC.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># audio file is decoded on the fly</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(dataset[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;audio&quot;</span>][<span class="hljs-string">&quot;array&quot;</span>], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = model(**inputs).logits
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_ids = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>transcription = processor.batch_decode(predicted_ids)`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Wd(j){let l,y="Example using <code>optimum.neuron.pipeline</code>:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvckNUQyUyQyUyMHBpcGVsaW5lJTBBJTBBcHJvY2Vzc29yJTIwJTNEJTIwQXV0b1Byb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIySmluZ3lhJTJGd2F2MnZlYzItbGFyZ2UtOTYwaC1sdjYwLXNlbGYtbmV1cm9ueC1jdGMlMjIpJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJoZi1pbnRlcm5hbC10ZXN0aW5nJTJGbGlicmlzcGVlY2hfYXNyX2RlbW8lMjIlMkMlMjAlMjJjbGVhbiUyMiUyQyUyMHNwbGl0JTNEJTIydmFsaWRhdGlvbiUyMiklMEFkYXRhc2V0JTIwJTNEJTIwZGF0YXNldC5zb3J0KCUyMmlkJTIyKSUwQSUwQW1vZGVsJTIwJTNEJTIwTmV1cm9uTW9kZWxGb3JDVEMuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWxhcmdlLTk2MGgtbHY2MC1zZWxmLW5ldXJvbngtY3RjJTIyKSUwQWFzciUyMCUzRCUyMHBpcGVsaW5lKCUyMmF1dG9tYXRpYy1zcGVlY2gtcmVjb2duaXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwZmVhdHVyZV9leHRyYWN0b3IlM0Rwcm9jZXNzb3IuZmVhdHVyZV9leHRyYWN0b3IlMkMlMjB0b2tlbml6ZXIlM0Rwcm9jZXNzb3IudG9rZW5pemVyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForCTC, pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForCTC.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-large-960h-lv60-self-neuronx-ctc&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>asr = pipeline(<span class="hljs-string">&quot;automatic-speech-recognition&quot;</span>, model=model, feature_extractor=processor.feature_extractor, tokenizer=processor.tokenizer)`,wrap:!1}}),{c(){l=i("p"),l.innerHTML=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-ch7hyj"&&(l.innerHTML=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Bd(j){let l,y="Example:",b,d,N;return d=new F({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Qcm9jZXNzb3IlMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25Nb2RlbEZvclhWZWN0b3IlMEFmcm9tJTIwZGF0YXNldHMlMjBpbXBvcnQlMjBsb2FkX2RhdGFzZXQlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaGYtaW50ZXJuYWwtdGVzdGluZyUyRmxpYnJpc3BlZWNoX2Fzcl9kZW1vJTIyJTJDJTIwJTIyY2xlYW4lMjIlMkMlMjBzcGxpdCUzRCUyMnZhbGlkYXRpb24lMjIpJTBBZGF0YXNldCUyMCUzRCUyMGRhdGFzZXQuc29ydCglMjJpZCUyMiklMEFzYW1wbGluZ19yYXRlJTIwJTNEJTIwZGF0YXNldC5mZWF0dXJlcyU1QiUyMmF1ZGlvJTIyJTVELnNhbXBsaW5nX3JhdGUlMEElMEFmZWF0dXJlX2V4dHJhY3RvciUyMCUzRCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLXN2LW5ldXJvbnglMjIpJTBBbW9kZWwlMjAlM0QlMjBOZXVyb25Nb2RlbEZvclhWZWN0b3IuZnJvbV9wcmV0cmFpbmVkKCUyMkppbmd5YSUyRndhdjJ2ZWMyLWJhc2Utc3VwZXJiLXN2LW5ldXJvbnglMjIpJTBBJTBBaW5wdXRzJTIwJTNEJTIwZmVhdHVyZV9leHRyYWN0b3IoJTBBJTIwJTIwJTIwJTIwJTVCZCU1QiUyMmFycmF5JTIyJTVEJTIwZm9yJTIwZCUyMGluJTIwZGF0YXNldCU1QiUzQTIlNUQlNUIlMjJhdWRpbyUyMiU1RCU1RCUyQyUyMHNhbXBsaW5nX3JhdGUlM0RzYW1wbGluZ19yYXRlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiUyQyUyMHBhZGRpbmclM0RUcnVlJTBBKSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBtb2RlbCgqKmlucHV0cykuZW1iZWRkaW5ncyUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLm5vcm1hbGl6ZShlbWJlZGRpbmdzJTJDJTIwZGltJTNELTEpJTBBJTBBY29zaW5lX3NpbSUyMCUzRCUyMHRvcmNoLm5uLkNvc2luZVNpbWlsYXJpdHkoZGltJTNELTEpJTBBc2ltaWxhcml0eSUyMCUzRCUyMGNvc2luZV9zaW0oZW1iZWRkaW5ncyU1QjAlNUQlMkMlMjBlbWJlZGRpbmdzJTVCMSU1RCklMEF0aHJlc2hvbGQlMjAlM0QlMjAwLjclMEFpZiUyMHNpbWlsYXJpdHklMjAlM0MlMjB0aHJlc2hvbGQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJTcGVha2VycyUyMGFyZSUyMG5vdCUyMHRoZSUyMHNhbWUhJTIyKSUwQXJvdW5kKHNpbWlsYXJpdHkuaXRlbSgpJTJDJTIwMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronModelForXVector
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;hf-internal-testing/librispeech_asr_demo&quot;</span>, <span class="hljs-string">&quot;clean&quot;</span>, split=<span class="hljs-string">&quot;validation&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = dataset.sort(<span class="hljs-string">&quot;id&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>sampling_rate = dataset.features[<span class="hljs-string">&quot;audio&quot;</span>].sampling_rate

<span class="hljs-meta">&gt;&gt;&gt; </span>feature_extractor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sv-neuronx&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = NeuronModelForXVector.from_pretrained(<span class="hljs-string">&quot;Jingya/wav2vec2-base-superb-sv-neuronx&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = feature_extractor(
<span class="hljs-meta">... </span>    [d[<span class="hljs-string">&quot;array&quot;</span>] <span class="hljs-keyword">for</span> d <span class="hljs-keyword">in</span> dataset[:<span class="hljs-number">2</span>][<span class="hljs-string">&quot;audio&quot;</span>]], sampling_rate=sampling_rate, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>, padding=<span class="hljs-literal">True</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = model(**inputs).embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = torch.nn.functional.normalize(embeddings, dim=-<span class="hljs-number">1</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>cosine_sim = torch.nn.CosineSimilarity(dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>similarity = cosine_sim(embeddings[<span class="hljs-number">0</span>], embeddings[<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>threshold = <span class="hljs-number">0.7</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> similarity &lt; threshold:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Speakers are not the same!&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(similarity.item(), <span class="hljs-number">2</span>)`,wrap:!1}}),{c(){l=i("p"),l.textContent=y,b=n(),p(d.$$.fragment)},l(t){l=c(t,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),b=r(t),u(d.$$.fragment,t)},m(t,v){m(t,l,v),m(t,b,v),g(d,t,v),N=!0},p:x,i(t){N||(f(d.$$.fragment,t),N=!0)},o(t){h(d.$$.fragment,t),N=!1},d(t){t&&(a(l),a(b)),_(d,t)}}}function Pd(j){let l,y,b,d,N,t,v,Dr,ht,Hr,_t,Yr,bt,Fi=`The <code>NeuronTracedModel</code> class is available for instantiating a base Neuron model without a specific head.
It is used as the base class for all tasks but text generation.`,Qr,C,Mt,hs,ln,Xi="Base class running compiled and optimized models on Neuron devices.",_s,cn,Ui=`It implements generic methods for interacting with the Hugging Face Hub as well as compiling vanilla
transformers models to neuron-optimized TorchScript module and export it using <code>optimum.exporters.neuron</code> toolchain.`,bs,dn,Si="Class attributes:",Ms,mn,Vi=`<li>model_type (<code>str</code>, <em>optional</em>, defaults to <code>&quot;neuron_model&quot;</code>) — The name of the model type to use when
registering the NeuronTracedModel classes.</li> <li>auto_model_class (<code>Type</code>, <em>optional</em>, defaults to <code>AutoModel</code>) — The <code>AutoModel</code> class to be represented by the
current NeuronTracedModel class.</li>`,Ns,pn,zi="Common attributes:",vs,un,Wi=`<li>model (<code>torch.jit._script.ScriptModule</code>) — The loaded <code>ScriptModule</code> compiled for neuron devices.</li> <li>config (<code>PretrainedConfig</code>) — The configuration of the model.</li> <li>model_save_dir (<code>Path</code>) — The directory where a neuron compiled model is saved.
By default, if the loaded model is local, the directory where the original model will be used. Otherwise, the
cache directory will be used.</li>`,ys,Ee,Nt,ws,gn,Bi="Returns whether this model can generate sequences with <code>.generate()</code>.",Ts,Re,vt,$s,fn,Pi="Gets a dictionary of inputs with their valid static shapes.",js,Le,yt,ks,hn,Gi=`Loads a TorchScript module compiled by neuron(x)-cc compiler. It will be first loaded onto CPU and then moved to
one or multiple <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/arch/neuron-hardware/neuroncores-arch.html" rel="nofollow">NeuronCore</a>.`,Cs,qe,wt,Js,_n,Ei="Removes padding from output tensors.",Ar,Tt,Kr,$t,Ri="The following Neuron model classes are available for natural language processing tasks.",Or,jt,ea,X,kt,xs,bn,Li="Neuron Model with a BaseModelOutput for feature-extraction tasks.",Is,Mn,qi=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Zs,Nn,Di="Feature Extraction model on Neuron devices.",Fs,le,Ct,Xs,vn,Hi="The <code>NeuronModelForFeatureExtraction</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Us,De,ta,Jt,oa,U,xt,Ss,yn,Yi="Neuron Model for Sentence Transformers.",Vs,wn,Qi=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,zs,Tn,Ai="Sentence Transformers model on Neuron devices.",Ws,re,It,Bs,$n,Ki="The <code>NeuronModelForSentenceTransformers</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Ps,He,Gs,Ye,na,Zt,ra,S,Ft,Es,jn,Oi="Neuron Model with a MaskedLMOutput for masked language modeling tasks.",Rs,kn,ec=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Ls,Cn,tc="Masked language model for on Neuron devices.",qs,ie,Xt,Ds,Jn,oc="The <code>NeuronModelForMaskedLM</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Hs,Qe,aa,Ut,sa,V,St,Ys,xn,nc=`Neuron Model with a sequence classification/regression head on top (a linear layer on top of the
pooled output) e.g. for GLUE tasks.`,Qs,In,rc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,As,Zn,ac="Sequence Classification model on Neuron devices.",Ks,ce,Vt,Os,Fn,sc="The <code>NeuronModelForSequenceClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",el,Ae,la,zt,ia,z,Wt,tl,Xn,lc="Neuron Model with a QuestionAnsweringModelOutput for extractive question-answering tasks like SQuAD.",ol,Un,ic=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,nl,Sn,cc="Question Answering model on Neuron devices.",rl,de,Bt,al,Vn,dc="The <code>NeuronModelForQuestionAnswering</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",sl,Ke,ca,Pt,da,W,Gt,ll,zn,mc=`Neuron Model with a token classification head on top (a linear layer on top of the hidden-states output) e.g.
for Named-Entity-Recognition (NER) tasks.`,il,Wn,pc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,cl,Bn,uc="Token Classification model on Neuron devices.",dl,me,Et,ml,Pn,gc="The <code>NeuronModelForTokenClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",pl,Oe,ma,Rt,pa,B,Lt,ul,Gn,fc=`Neuron Model with a multiple choice classification head on top (a linear layer on top of the pooled output and a
softmax) e.g. for RocStories/SWAG tasks.`,gl,En,hc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,fl,Rn,_c="Multiple choice model on Neuron devices.",hl,pe,qt,_l,Ln,bc="The <code>NeuronModelForMultipleChoice</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",bl,et,ua,Dt,ga,Y,Ht,Ml,qn,Mc="Neuron model with a causal language modeling head for inference on Neuron devices.",Nl,Dn,Nc=`This model inherits from <code>~neuron.NeuronModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,vl,Hn,Yt,fa,Qt,ha,Q,At,yl,Yn,vc="Neuron Sequence-to-sequence model with a language modeling head for text2text-generation tasks.",wl,Qn,yc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Tl,I,Kt,$l,An,wc='The <a href="/docs/optimum.neuron/main/en/model_doc/modeling_auto#optimum.neuron.NeuronModelForSeq2SeqLM">NeuronModelForSeq2SeqLM</a> forward method, overrides the <code>__call__</code> special method.',jl,tt,kl,Kn,Tc="<em>(Following models are compiled with neuronx compiler and can only be run on INF2.)</em>",Cl,ot,Jl,On,$c="<em>(For large models, in order to fit into Neuron cores, we need to apply tensor parallelism. Here below is an example ran on <code>inf2.24xlarge</code>.)</em>",xl,nt,_a,Ot,ba,eo,jc="The following Neuron model classes are available for computer vision tasks.",Ma,to,Na,P,oo,Il,er,kc="Neuron Model with an image classification head on top (a linear layer on top of the final hidden state of the [CLS] token) e.g. for ImageNet.",Zl,tr,Cc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Fl,or,Jc="Neuron Model for image-classification tasks. This class officially supports beit, convnext, convnextv2, deit, levit, mobilenet_v2, mobilevit, vit, etc.",Xl,ue,no,Ul,nr,xc="The <code>NeuronModelForImageClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Sl,rt,va,ro,ya,G,ao,Vl,rr,Ic="Neuron Model with a semantic segmentation head on top, e.g. for Pascal VOC.",zl,ar,Zc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Wl,sr,Fc="Neuron Model for semantic-segmentation, with an all-MLP decode head on top e.g. for ADE20k, CityScapes. This class officially supports mobilevit, mobilenet-v2, etc.",Bl,ge,so,Pl,lr,Xc="The <code>NeuronModelForSemanticSegmentation</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Gl,at,wa,lo,Ta,E,io,El,ir,Uc="Neuron Model with object detection heads on top, for tasks such as COCO detection.",Rl,cr,Sc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Ll,dr,Vc="Neuron Model for object-detection, with object detection heads on top, for tasks such as COCO detection.",ql,fe,co,Dl,mr,zc="The <code>NeuronModelForObjectDetection</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Hl,st,$a,mo,ja,po,Wc="The following auto classes are available for the following audio tasks.",ka,uo,Ca,R,go,Yl,pr,Bc="Neuron Model with an audio classification head.",Ql,ur,Pc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,Al,gr,Gc=`Neuron Model for audio-classification, with a sequence classification head on top (a linear layer over the pooled output) for tasks like
SUPERB Keyword Spotting.`,Kl,he,fo,Ol,fr,Ec="The <code>NeuronModelForAudioClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",ei,lt,Ja,ho,xa,L,_o,ti,hr,Rc="Neuron Model with an audio frame classification head.",oi,_r,Lc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,ni,br,qc="Neuron Model with a frame classification head on top for tasks like Speaker Diarization.",ri,_e,bo,ai,Mr,Dc="The <code>NeuronModelForAudioFrameClassification</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",si,it,Ia,Mo,Za,q,No,li,Nr,Hc="Neuron Model with a connectionist temporal classification head.",ii,vr,Yc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,ci,yr,Qc="Neuron Model with a language modeling head on top for Connectionist Temporal Classification (CTC).",di,ae,vo,mi,wr,Ac="The <code>NeuronModelForCTC</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",pi,ct,ui,dt,Fa,yo,Xa,D,wo,gi,Tr,Kc="Neuron Model with an XVector feature extraction head on top for tasks like Speaker Verification.",fi,$r,Oc=`This model inherits from <code>~neuron.modeling.NeuronTracedModel</code>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving)`,hi,jr,ed="Neuron Model with an XVector feature extraction head on top for tasks like Speaker Verification.",_i,be,To,bi,kr,td="The <code>NeuronModelForXVector</code> forward method, overrides the <code>__call__</code> special method. Accepts only the inputs traced during the compilation step. Any additional inputs provided during inference will be ignored. To include extra inputs, recompile the model with those inputs specified.",Mi,mt,Ua,$o,Sa,jo,od="The following Neuron model classes are available for stable diffusion tasks.",Va,ko,za,ke,Co,Ni,Cr,Jo,Wa,xo,Ba,Ce,Io,vi,Jr,Zo,Pa,Fo,Ga,Je,Xo,yi,xr,Uo,Ea,So,Ra,xe,Vo,wi,Ir,zo,La,Wo,qa,Ie,Bo,Ti,pt,Po,$i,Zr,nd="The call function to the pipeline for generation.",Da,Go,Ha,Ze,Eo,ji,Fr,Ro,Ya,Lo,Qa,Fe,qo,ki,Xr,Do,Aa,Ho,Ka,Xe,Yo,Ci,Ur,Qo,Oa,Ao,es,Ue,Ko,Ji,Sr,Oo,ts,en,os,Se,tn,xi,Me,on,Ii,Vr,rd="The call function to the pipeline for generation.",Zi,zr,ad="Examples:",ns,qr,rs;return N=new vd({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),v=new k({props:{title:"Models",local:"models",headingTag:"h1"}}),ht=new k({props:{title:"Generic model classes",local:"generic-model-classes",headingTag:"h2"}}),_t=new k({props:{title:"NeuronTracedModel",local:"optimum.neuron.NeuronTracedModel",headingTag:"h3"}}),Mt=new $({props:{name:"class optimum.neuron.NeuronTracedModel",anchor:"optimum.neuron.NeuronTracedModel",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_traced.py#L72"}}),Nt=new $({props:{name:"can_generate",anchor:"optimum.neuron.NeuronTracedModel.can_generate",parameters:[],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_traced.py#L661"}}),vt=new $({props:{name:"get_input_static_shapes",anchor:"optimum.neuron.NeuronTracedModel.get_input_static_shapes",parameters:[{name:"neuron_config",val:": NeuronDefaultConfig"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_traced.py#L516"}}),yt=new $({props:{name:"load_model",anchor:"optimum.neuron.NeuronTracedModel.load_model",parameters:[{name:"path",val:": str | pathlib.Path"},{name:"to_neuron",val:": bool = False"},{name:"device_id",val:": int = 0"}],parametersDescription:[{anchor:"optimum.neuron.NeuronTracedModel.load_model.path",description:`<strong>path</strong> (<code>str | Path</code>) &#x2014;
Path of the compiled model.`,name:"path"},{anchor:"optimum.neuron.NeuronTracedModel.load_model.to_neuron",description:`<strong>to_neuron</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
Whether to move manually the traced model to NeuronCore. It&#x2019;s only needed when <code>inline_weights_to_neff=False</code>, otherwise it is loaded automatically to a Neuron device.`,name:"to_neuron"},{anchor:"optimum.neuron.NeuronTracedModel.load_model.device_id",description:`<strong>device_id</strong> (<code>int</code>, defaults to 0) &#x2014;
Index of NeuronCore to load the traced model to.`,name:"device_id"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_traced.py#L120"}}),wt=new $({props:{name:"remove_padding",anchor:"optimum.neuron.NeuronTracedModel.remove_padding",parameters:[{name:"outputs",val:": list[torch.Tensor]"},{name:"dims",val:": list[int]"},{name:"indices",val:": list[int]"},{name:"padding_side",val:": typing.Literal['right', 'left'] = 'right'"}],parametersDescription:[{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.outputs",description:`<strong>outputs</strong> (<code>list[torch.Tensor]</code>) &#x2014;
List of torch tensors which are inference output.`,name:"outputs"},{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.dims",description:`<strong>dims</strong> (<code>list[int]</code>) &#x2014;
List of dimensions in which we slice a tensor.`,name:"dims"},{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.indices",description:`<strong>indices</strong> (<code>list[int]</code>) &#x2014;
List of indices in which we slice a tensor along an axis.`,name:"indices"},{anchor:"optimum.neuron.NeuronTracedModel.remove_padding.padding_side",description:`<strong>padding_side</strong> (<code>Literal[&quot;right&quot;, &quot;left&quot;]</code>, defaults to &#x201C;right&#x201D;) &#x2014;
The side on which the padding has been applied.`,name:"padding_side"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_traced.py#L613"}}),Tt=new k({props:{title:"Natural Language Processing",local:"natural-language-processing",headingTag:"h2"}}),jt=new k({props:{title:"NeuronModelForFeatureExtraction",local:"optimum.neuron.NeuronModelForFeatureExtraction",headingTag:"h3"}}),kt=new $({props:{name:"class optimum.neuron.NeuronModelForFeatureExtraction",anchor:"optimum.neuron.NeuronModelForFeatureExtraction",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L92"}}),Ct=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": torch.Tensor | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L99"}}),De=new Z({props:{anchor:"optimum.neuron.NeuronModelForFeatureExtraction.forward.example",$$slots:{default:[yd]},$$scope:{ctx:j}}}),Jt=new k({props:{title:"NeuronModelForSentenceTransformers",local:"optimum.neuron.NeuronModelForSentenceTransformers",headingTag:"h3"}}),xt=new $({props:{name:"class optimum.neuron.NeuronModelForSentenceTransformers",anchor:"optimum.neuron.NeuronModelForSentenceTransformers",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L144"}}),It=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"pixel_values",val:": torch.Tensor | None = None"},{name:"token_type_ids",val:": torch.Tensor | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L152"}}),He=new Z({props:{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.example",$$slots:{default:[wd]},$$scope:{ctx:j}}}),Ye=new Z({props:{anchor:"optimum.neuron.NeuronModelForSentenceTransformers.forward.example-2",$$slots:{default:[Td]},$$scope:{ctx:j}}}),Zt=new k({props:{title:"NeuronModelForMaskedLM",local:"optimum.neuron.NeuronModelForMaskedLM",headingTag:"h3"}}),Ft=new $({props:{name:"class optimum.neuron.NeuronModelForMaskedLM",anchor:"optimum.neuron.NeuronModelForMaskedLM",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMaskedLM.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForMaskedLM.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L210"}}),Xt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForMaskedLM.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": torch.Tensor | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L217"}}),Qe=new Z({props:{anchor:"optimum.neuron.NeuronModelForMaskedLM.forward.example",$$slots:{default:[$d]},$$scope:{ctx:j}}}),Ut=new k({props:{title:"NeuronModelForSequenceClassification",local:"optimum.neuron.NeuronModelForSequenceClassification",headingTag:"h3"}}),St=new $({props:{name:"class optimum.neuron.NeuronModelForSequenceClassification",anchor:"optimum.neuron.NeuronModelForSequenceClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSequenceClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForSequenceClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L304"}}),Vt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": torch.Tensor | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L311"}}),Ae=new Z({props:{anchor:"optimum.neuron.NeuronModelForSequenceClassification.forward.example",$$slots:{default:[jd]},$$scope:{ctx:j}}}),zt=new k({props:{title:"NeuronModelForQuestionAnswering",local:"optimum.neuron.NeuronModelForQuestionAnswering",headingTag:"h3"}}),Wt=new $({props:{name:"class optimum.neuron.NeuronModelForQuestionAnswering",anchor:"optimum.neuron.NeuronModelForQuestionAnswering",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L256"}}),Bt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": torch.Tensor | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L263"}}),Ke=new Z({props:{anchor:"optimum.neuron.NeuronModelForQuestionAnswering.forward.example",$$slots:{default:[kd]},$$scope:{ctx:j}}}),Pt=new k({props:{title:"NeuronModelForTokenClassification",local:"optimum.neuron.NeuronModelForTokenClassification",headingTag:"h3"}}),Gt=new $({props:{name:"class optimum.neuron.NeuronModelForTokenClassification",anchor:"optimum.neuron.NeuronModelForTokenClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForTokenClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForTokenClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L351"}}),Et=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForTokenClassification.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": torch.Tensor | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L358"}}),Oe=new Z({props:{anchor:"optimum.neuron.NeuronModelForTokenClassification.forward.example",$$slots:{default:[Cd]},$$scope:{ctx:j}}}),Rt=new k({props:{title:"NeuronModelForMultipleChoice",local:"optimum.neuron.NeuronModelForMultipleChoice",headingTag:"h3"}}),Lt=new $({props:{name:"class optimum.neuron.NeuronModelForMultipleChoice",anchor:"optimum.neuron.NeuronModelForMultipleChoice",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMultipleChoice.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForMultipleChoice.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L399"}}),qt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward",parameters:[{name:"input_ids",val:": Tensor"},{name:"attention_mask",val:": Tensor"},{name:"token_type_ids",val:": torch.Tensor | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, num_choices, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"},{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.token_type_ids",description:`<strong>token_type_ids</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, num_choices, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Segment token indices to indicate first and second portions of the inputs. Indices are selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>sentence A</strong>,</li>
<li>0 for tokens that are <strong>sentence B</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#token-type-ids" rel="nofollow">What are token type IDs?</a></li>
</ul>`,name:"token_type_ids"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L406"}}),et=new Z({props:{anchor:"optimum.neuron.NeuronModelForMultipleChoice.forward.example",$$slots:{default:[Jd]},$$scope:{ctx:j}}}),Dt=new k({props:{title:"NeuronModelForCausalLM",local:"optimum.neuron.NeuronModelForCausalLM",headingTag:"h3"}}),Ht=new $({props:{name:"class optimum.neuron.NeuronModelForCausalLM",anchor:"optimum.neuron.NeuronModelForCausalLM",parameters:[{name:"device",val:": device = device(type='cpu')"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_decoder.py#L107"}}),Yt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForCausalLM.forward",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_base.py#L42"}}),Qt=new k({props:{title:"NeuronModelForSeq2SeqLM",local:"optimum.neuron.NeuronModelForSeq2SeqLM",headingTag:"h3"}}),At=new $({props:{name:"class optimum.neuron.NeuronModelForSeq2SeqLM",anchor:"optimum.neuron.NeuronModelForSeq2SeqLM",parameters:[{name:"encoder",val:": ScriptModule"},{name:"decoder",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"encoder_file_name",val:": str | None = 'model.neuron'"},{name:"decoder_file_name",val:": str | None = 'model.neuron'"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig'] | None = None"},{name:"configs",val:": dict[str, 'PretrainedConfig'] | None = None"},{name:"generation_config",val:": transformers.generation.configuration_utils.GenerationConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.encoder",description:'<strong>encoder</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module of the encoder with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"encoder"},{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.decoder",description:'<strong>decoder</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module of the decoder with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"decoder"},{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_seq2seq.py#L446"}}),Kt=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward",parameters:[{name:"attention_mask",val:": torch.FloatTensor | None = None"},{name:"decoder_input_ids",val:": torch.LongTensor | None = None"},{name:"decoder_attention_mask",val:": torch.BoolTensor | None = None"},{name:"encoder_outputs",val:": tuple[tuple[torch.Tensor]] | None = None"},{name:"beam_scores",val:": torch.FloatTensor | None = None"},{name:"return_dict",val:": bool = False"},{name:"output_attentions",val:": bool = False"},{name:"output_hidden_states",val:": bool = False"}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary.
Indices can be obtained using <a href="https://huggingface.co/docs/transformers/autoclass_tutorial#autotokenizer" rel="nofollow"><code>AutoTokenizer</code></a>.
See <a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.encode" rel="nofollow"><code>PreTrainedTokenizer.encode</code></a> and
<a href="https://huggingface.co/docs/transformers/main_classes/tokenizer#transformers.PreTrainedTokenizerBase.__call__" rel="nofollow"><code>PreTrainedTokenizer.__call__</code></a> for details.
<a href="https://huggingface.co/docs/transformers/glossary#input-ids" rel="nofollow">What are input IDs?</a>`,name:"input_ids"},{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, sequence_length)</code>, defaults to <code>None</code>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.
<a href="https://huggingface.co/docs/transformers/glossary#attention-mask" rel="nofollow">What are attention masks?</a></li>
</ul>`,name:"attention_mask"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_seq2seq.py#L450"}}),tt=new Nd({props:{$$slots:{default:[xd]},$$scope:{ctx:j}}}),ot=new Z({props:{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.example",$$slots:{default:[Id]},$$scope:{ctx:j}}}),nt=new Z({props:{anchor:"optimum.neuron.NeuronModelForSeq2SeqLM.forward.example-2",$$slots:{default:[Zd]},$$scope:{ctx:j}}}),Ot=new k({props:{title:"Computer Vision",local:"computer-vision",headingTag:"h2"}}),to=new k({props:{title:"NeuronModelForImageClassification",local:"optimum.neuron.NeuronModelForImageClassification",headingTag:"h3"}}),oo=new $({props:{name:"class optimum.neuron.NeuronModelForImageClassification",anchor:"optimum.neuron.NeuronModelForImageClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForImageClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForImageClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L446"}}),no=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForImageClassification.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForImageClassification.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoImageProcessor" rel="nofollow"><code>AutoImageProcessor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L460"}}),rt=new Z({props:{anchor:"optimum.neuron.NeuronModelForImageClassification.forward.example",$$slots:{default:[Fd]},$$scope:{ctx:j}}}),ro=new k({props:{title:"NeuronModelForSemanticSegmentation",local:"optimum.neuron.NeuronModelForSemanticSegmentation",headingTag:"h3"}}),ao=new $({props:{name:"class optimum.neuron.NeuronModelForSemanticSegmentation",anchor:"optimum.neuron.NeuronModelForSemanticSegmentation",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L493"}}),so=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoImageProcessor" rel="nofollow"><code>AutoImageProcessor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L507"}}),at=new Z({props:{anchor:"optimum.neuron.NeuronModelForSemanticSegmentation.forward.example",$$slots:{default:[Xd]},$$scope:{ctx:j}}}),lo=new k({props:{title:"NeuronModelForObjectDetection",local:"optimum.neuron.NeuronModelForObjectDetection",headingTag:"h3"}}),io=new $({props:{name:"class optimum.neuron.NeuronModelForObjectDetection",anchor:"optimum.neuron.NeuronModelForObjectDetection",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForObjectDetection.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForObjectDetection.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L540"}}),co=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForObjectDetection.forward",parameters:[{name:"pixel_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForObjectDetection.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.Tensor | None</code> of shape <code>(batch_size, num_channels, height, width)</code>, defaults to <code>None</code>) &#x2014;
Pixel values corresponding to the images in the current batch.
Pixel values can be obtained from encoded images using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoImageProcessor" rel="nofollow"><code>AutoImageProcessor</code></a>.`,name:"pixel_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L554"}}),st=new Z({props:{anchor:"optimum.neuron.NeuronModelForObjectDetection.forward.example",$$slots:{default:[Ud]},$$scope:{ctx:j}}}),mo=new k({props:{title:"Audio",local:"audio",headingTag:"h2"}}),uo=new k({props:{title:"NeuronModelForAudioClassification",local:"optimum.neuron.NeuronModelForAudioClassification",headingTag:"h3"}}),go=new $({props:{name:"class optimum.neuron.NeuronModelForAudioClassification",anchor:"optimum.neuron.NeuronModelForAudioClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForAudioClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L589"}}),fo=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForAudioClassification.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L597"}}),lt=new Z({props:{anchor:"optimum.neuron.NeuronModelForAudioClassification.forward.example",$$slots:{default:[Sd]},$$scope:{ctx:j}}}),ho=new k({props:{title:"NeuronModelForAudioFrameClassification",local:"optimum.neuron.NeuronModelForAudioFrameClassification",headingTag:"h3"}}),_o=new $({props:{name:"class optimum.neuron.NeuronModelForAudioFrameClassification",anchor:"optimum.neuron.NeuronModelForAudioFrameClassification",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L630"}}),bo=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L637"}}),it=new Z({props:{anchor:"optimum.neuron.NeuronModelForAudioFrameClassification.forward.example",$$slots:{default:[Vd]},$$scope:{ctx:j}}}),Mo=new k({props:{title:"NeuronModelForCTC",local:"optimum.neuron.NeuronModelForCTC",headingTag:"h3"}}),No=new $({props:{name:"class optimum.neuron.NeuronModelForCTC",anchor:"optimum.neuron.NeuronModelForCTC",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForCTC.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForCTC.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L670"}}),vo=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForCTC.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForCTC.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L678"}}),ct=new Z({props:{anchor:"optimum.neuron.NeuronModelForCTC.forward.example",$$slots:{default:[zd]},$$scope:{ctx:j}}}),dt=new Z({props:{anchor:"optimum.neuron.NeuronModelForCTC.forward.example-2",$$slots:{default:[Wd]},$$scope:{ctx:j}}}),yo=new k({props:{title:"NeuronModelForXVector",local:"optimum.neuron.NeuronModelForXVector",headingTag:"h3"}}),wo=new $({props:{name:"class optimum.neuron.NeuronModelForXVector",anchor:"optimum.neuron.NeuronModelForXVector",parameters:[{name:"model",val:": ScriptModule"},{name:"config",val:": PretrainedConfig"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_file_name",val:": str | None = None"},{name:"preprocessors",val:": list | None = None"},{name:"neuron_config",val:": NeuronDefaultConfig | None = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForXVector.config",description:`<strong>config</strong> (<code>transformers.PretrainedConfig</code>) &#x2014; <a href="https://huggingface.co/docs/transformers/main_classes/configuration#transformers.PretrainedConfig" rel="nofollow">PretrainedConfig</a> is the Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <code>optimum.neuron.modeling.NeuronTracedModel.from_pretrained</code> method to load the model weights.`,name:"config"},{anchor:"optimum.neuron.NeuronModelForXVector.model",description:'<strong>model</strong> (<code>torch.jit._script.ScriptModule</code>) &#x2014; <a href="https://pytorch.org/docs/stable/generated/torch.jit.ScriptModule.html" rel="nofollow">torch.jit._script.ScriptModule</a> is the TorchScript module with embedded NEFF(Neuron Executable File Format) compiled by neuron(x) compiler.',name:"model"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L711"}}),To=new $({props:{name:"forward",anchor:"optimum.neuron.NeuronModelForXVector.forward",parameters:[{name:"input_values",val:": Tensor"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronModelForXVector.forward.input_values",description:`<strong>input_values</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Float values of input raw speech waveform..
Input values can be obtained from audio file loaded into an array using <a href="https://huggingface.co/docs/transformers/en/model_doc/auto#transformers.AutoProcessor" rel="nofollow"><code>AutoProcessor</code></a>.`,name:"input_values"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling.py#L718"}}),mt=new Z({props:{anchor:"optimum.neuron.NeuronModelForXVector.forward.example",$$slots:{default:[Bd]},$$scope:{ctx:j}}}),$o=new k({props:{title:"Stable Diffusion",local:"stable-diffusion",headingTag:"h2"}}),ko=new k({props:{title:"NeuronStableDiffusionPipeline",local:"optimum.neuron.NeuronStableDiffusionPipeline",headingTag:"h3"}}),Co=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionPipeline",anchor:"optimum.neuron.NeuronStableDiffusionPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1536"}}),Jo=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1106"}}),xo=new k({props:{title:"NeuronStableDiffusionImg2ImgPipeline",local:"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline",headingTag:"h3"}}),Io=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionImg2ImgPipeline",anchor:"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1549"}}),Zo=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1106"}}),Fo=new k({props:{title:"NeuronStableDiffusionInpaintPipeline",local:"optimum.neuron.NeuronStableDiffusionInpaintPipeline",headingTag:"h3"}}),Xo=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionInpaintPipeline",anchor:"optimum.neuron.NeuronStableDiffusionInpaintPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1554"}}),Uo=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1106"}}),So=new k({props:{title:"NeuronLatentConsistencyModelPipeline",local:"optimum.neuron.NeuronLatentConsistencyModelPipeline",headingTag:"h3"}}),Vo=new $({props:{name:"class optimum.neuron.NeuronLatentConsistencyModelPipeline",anchor:"optimum.neuron.NeuronLatentConsistencyModelPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1567"}}),zo=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronLatentConsistencyModelPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1106"}}),Wo=new k({props:{title:"NeuronStableDiffusionControlNetPipeline",local:"optimum.neuron.NeuronStableDiffusionControlNetPipeline",headingTag:"h3"}}),Bo=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionControlNetPipeline",anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1572"}}),Po=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__",parameters:[{name:"prompt",val:": str | list[str] | None = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": list[int] | None = None"},{name:"sigmas",val:": list[float] | None = None"},{name:"guidance_scale",val:": float = 7.5"},{name:"negative_prompt",val:": str | list[str] | None = None"},{name:"num_images_per_prompt",val:": int | None = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": torch._C.Generator | list[torch._C.Generator] | None = None"},{name:"latents",val:": torch.Tensor | None = None"},{name:"prompt_embeds",val:": torch.Tensor | None = None"},{name:"negative_prompt_embeds",val:": torch.Tensor | None = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": list[torch.Tensor] | None = None"},{name:"output_type",val:": str = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"controlnet_conditioning_scale",val:": float | list[float] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": float | list[float] = 0.0"},{name:"control_guidance_end",val:": float | list[float] = 1.0"},{name:"clip_skip",val:": int | None = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": list[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str | list[str] | None</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>&quot;PipelineImageInput&quot; | None</code>, defaults to <code>None</code>) &#x2014;
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet. When <code>prompt</code> is a list, and if a list of images is passed for a single
ControlNet, each will be paired with each prompt in the <code>prompt</code> list. This also applies to multiple
ControlNets, where a list of image lists can be passed to batch for each prompt and each ControlNet.`,name:"image"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>list[int] | None</code>, defaults to <code>None</code>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is
passed will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>list[int] | None</code>, defaults to <code>None</code>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 7.5) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str | list[str] | None</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt. If it is different from the batch size used for the compiltaion,
it will be overridden by the static batch size of neuron (except for dynamic batching).`,name:"num_images_per_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <code>diffusers.schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator | list[torch.Generator] | None</code>, defaults to <code>None</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.ip_adapter_image",description:"<strong>ip_adapter_image</strong> &#x2014; (<code>PipelineImageInput | None</code>, defaults to <code>None</code>): Optional image input to work with IP Adapters.",name:"ip_adapter_image"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>list[torch.Tensor] | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length same as number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict[str, Any] | None</code>, defaults to <code>None</code>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float | list[float]</code>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float | list[float]</code>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float | list[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int | None</code>, defaults to <code>None</code>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable[[int, int, dict], None] | PipelineCallback | MultiPipelineCallbacks | None</code>, defaults to <code>None</code>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference. with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.neuron.NeuronStableDiffusionControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>list[str]</code>, defaults to <code>[&quot;latents&quot;]</code>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/pipelines/diffusers/pipeline_controlnet.py#L33",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated images and the
second element is a list of <code>bool</code>s indicating whether the corresponding generated image contains
“not-safe-for-work” (nsfw) content.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),Go=new k({props:{title:"NeuronPixArtAlphaPipeline",local:"optimum.neuron.NeuronPixArtAlphaPipeline",headingTag:"h3"}}),Eo=new $({props:{name:"class optimum.neuron.NeuronPixArtAlphaPipeline",anchor:"optimum.neuron.NeuronPixArtAlphaPipeline",parameters:[{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1579"}}),Ro=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronPixArtAlphaPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1106"}}),Lo=new k({props:{title:"NeuronStableDiffusionXLPipeline",local:"optimum.neuron.NeuronStableDiffusionXLPipeline",headingTag:"h3"}}),qo=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1597"}}),Do=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1106"}}),Ho=new k({props:{title:"NeuronStableDiffusionXLImg2ImgPipeline",local:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",headingTag:"h3"}}),Yo=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1610"}}),Qo=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1106"}}),Ao=new k({props:{title:"NeuronStableDiffusionXLInpaintPipeline",local:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",headingTag:"h3"}}),Ko=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1617"}}),Oo=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline.__call__",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1106"}}),en=new k({props:{title:"NeuronStableDiffusionXLControlNetPipeline",local:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",headingTag:"h3"}}),tn=new $({props:{name:"class optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline",parameters:[{name:"config",val:": dict[str, typing.Any]"},{name:"configs",val:": dict[str, 'PretrainedConfig']"},{name:"neuron_configs",val:": dict[str, 'NeuronDefaultConfig']"},{name:"data_parallel_mode",val:": typing.Literal['none', 'unet', 'transformer', 'all']"},{name:"scheduler",val:": diffusers.schedulers.scheduling_utils.SchedulerMixin | None"},{name:"vae_decoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeDecoder"},{name:"text_encoder",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"text_encoder_2",val:": torch.jit._script.ScriptModule | NeuronModelTextEncoder | None = None"},{name:"unet",val:": torch.jit._script.ScriptModule | NeuronModelUnet | None = None"},{name:"transformer",val:": torch.jit._script.ScriptModule | NeuronModelTransformer | None = None"},{name:"vae_encoder",val:": torch.jit._script.ScriptModule | NeuronModelVaeEncoder | None = None"},{name:"image_encoder",val:": torch.jit._script.ScriptModule | None = None"},{name:"safety_checker",val:": torch.jit._script.ScriptModule | None = None"},{name:"tokenizer",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | transformers.models.t5.tokenization_t5.T5Tokenizer | None = None"},{name:"tokenizer_2",val:": transformers.models.clip.tokenization_clip.CLIPTokenizer | None = None"},{name:"feature_extractor",val:": transformers.models.clip.feature_extraction_clip.CLIPFeatureExtractor | None = None"},{name:"controlnet",val:": torch.jit._script.ScriptModule | list[torch.jit._script.ScriptModule]| NeuronControlNetModel | NeuronMultiControlNetModel | None = None"},{name:"requires_aesthetics_score",val:": bool = False"},{name:"force_zeros_for_empty_prompt",val:": bool = True"},{name:"add_watermarker",val:": bool | None = None"},{name:"model_save_dir",val:": str | pathlib.Path | tempfile.TemporaryDirectory | None = None"},{name:"model_and_config_save_paths",val:": dict[str, tuple[str, pathlib.Path]] | None = None"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/modeling_diffusion.py#L1624"}}),on=new $({props:{name:"__call__",anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__",parameters:[{name:"prompt",val:": str | list[str] | None = None"},{name:"prompt_2",val:": str | list[str] | None = None"},{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"num_inference_steps",val:": int = 50"},{name:"timesteps",val:": list[int] | None = None"},{name:"sigmas",val:": list[float] | None = None"},{name:"denoising_end",val:": float | None = None"},{name:"guidance_scale",val:": float = 5.0"},{name:"negative_prompt",val:": str | list[str] | None = None"},{name:"negative_prompt_2",val:": str | list[str] | None = None"},{name:"num_images_per_prompt",val:": int | None = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": torch._C.Generator | list[torch._C.Generator] | None = None"},{name:"latents",val:": torch.Tensor | None = None"},{name:"prompt_embeds",val:": torch.Tensor | None = None"},{name:"negative_prompt_embeds",val:": torch.Tensor | None = None"},{name:"pooled_prompt_embeds",val:": torch.Tensor | None = None"},{name:"negative_pooled_prompt_embeds",val:": torch.Tensor | None = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": list[torch.Tensor] | None = None"},{name:"output_type",val:": str | None = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"cross_attention_kwargs",val:": dict[str, typing.Any] | None = None"},{name:"controlnet_conditioning_scale",val:": float | list[float] = 1.0"},{name:"guess_mode",val:": bool = False"},{name:"control_guidance_start",val:": float | list[float] = 0.0"},{name:"control_guidance_end",val:": float | list[float] = 1.0"},{name:"original_size",val:": tuple[int, int] | None = None"},{name:"crops_coords_top_left",val:": tuple[int, int] = (0, 0)"},{name:"target_size",val:": tuple[int, int] | None = None"},{name:"negative_original_size",val:": tuple[int, int] | None = None"},{name:"negative_crops_coords_top_left",val:": tuple[int, int] = (0, 0)"},{name:"negative_target_size",val:": tuple[int, int] | None = None"},{name:"clip_skip",val:": int | None = None"},{name:"callback_on_step_end",val:": typing.Union[typing.Callable[[int, int, dict], NoneType], diffusers.callbacks.PipelineCallback, diffusers.callbacks.MultiPipelineCallbacks, NoneType] = None"},{name:"callback_on_step_end_tensor_inputs",val:": list[str] = ['latents']"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str | list[str]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide image generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str | list[str]</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in both text-encoders.`,name:"prompt_2"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.image",description:`<strong>image</strong> (<code>PipelineImageInput | None</code>, defaults to <code>None</code>) &#x2014;
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image default to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"image"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.timesteps",description:`<strong>timesteps</strong> (<code>list[int] | None</code>, defaults to <code>None</code>) &#x2014;
Custom timesteps to use for the denoising process with schedulers which support a <code>timesteps</code> argument
in their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used. Must be in descending order.`,name:"timesteps"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>list[float] | None</code>, defaults to <code>None</code>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.denoising_end",description:`<strong>denoising_end</strong> (<code>float | None</code>, defaults to <code>None</code>) &#x2014;
When specified, determines the fraction (between 0.0 and 1.0) of the total denoising process to be
completed before it is intentionally prematurely terminated. As a result, the returned sample will
still retain a substantial amount of noise as determined by the discrete timesteps selected by the
scheduler. The denoising_end parameter should ideally be utilized when this pipeline forms a part of a
&#x201C;Mixture of Denoisers&#x201D; multi-pipeline setup, as elaborated in <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/stable_diffusion_xl#refining-the-image-output" rel="nofollow"><strong>Refining the Image
Output</strong></a>`,name:"denoising_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, defaults to 5.0) &#x2014;
A higher guidance scale value encourages the model to generate images closely linked to the text
<code>prompt</code> at the expense of lower image quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str | list[str] | None</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str | list[str] | None</code>, defaults to <code>None</code>) &#x2014;
The prompt or prompts to guide what to not include in image generation. This is sent to <code>tokenizer_2</code>
and <code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in both text-encoders.`,name:"negative_prompt_2"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <code>diffusers.schedulers.DDIMScheduler</code>, and is ignored in other schedulers.`,name:"eta"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator | list[torch.Generator] | None</code>, defaults to <code>None</code>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, pooled text embeddings are generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.Tensor | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs (prompt
weighting). If not provided, pooled <code>negative_prompt_embeds</code> are generated from <code>negative_prompt</code> input
argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput | None</code>, defaults to <code>None</code>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>list[torch.Tensor] | None</code>, defaults to <code>None</code>) &#x2014;
Pre-generated image embeddings for IP-Adapter. It should be a list of length the same as the number of
IP-adapters. Each element should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should
contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to <code>True</code>. If not
provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str | None</code>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generated image. Choose between <code>PIL.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> instead of a
plain tuple.`,name:"return_dict"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict[str, Any] | None</code>, defaults to <code>None</code>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float | list[float]</code>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.guess_mode",description:`<strong>guess_mode</strong> (<code>bool</code>, defaults to <code>False</code>) &#x2014;
The ControlNet encoder tries to recognize the content of the input image even if you remove all
prompts. A <code>guidance_scale</code> value between 3.0 and 5.0 is recommended.`,name:"guess_mode"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float | list[float]</code>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float | list[float]</code>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.original_size",description:`<strong>original_size</strong> (<code>tuple[int, int] | None</code>, defaults to (1024, 1024)) &#x2014;
If <code>original_size</code> is not the same as <code>target_size</code>, the image will appear to be down- or upsampled.
<code>original_size</code> defaults to <code>(height, width)</code> if not specified. Part of SDXL&#x2019;s micro-conditioning as
explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"original_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.crops_coords_top_left",description:`<strong>crops_coords_top_left</strong> (<code>tuple[int, int]</code>, defaults to (0, 0)) &#x2014;
<code>crops_coords_top_left</code> can be used to generate an image that appears to be &#x201C;cropped&#x201D; from the position
<code>crops_coords_top_left</code> downwards. Favorable, well-centered images are usually achieved by setting
<code>crops_coords_top_left</code> to (0, 0). Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"crops_coords_top_left"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.target_size",description:`<strong>target_size</strong> (<code>tuple[int, int] | None</code>, defaults to <code>None</code>) &#x2014;
For most cases, <code>target_size</code> should be set to the desired height and width of the generated image. If
not specified, it will default to <code>(height, width)</code>. Part of SDXL&#x2019;s micro-conditioning as explained in
section 2.2 of <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>.`,name:"target_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_original_size",description:`<strong>negative_original_size</strong> (<code>tuple[int, int] | None</code>, defaults to <code>None</code>) &#x2014;
To negatively condition the generation process based on a specific image resolution. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_original_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_crops_coords_top_left",description:`<strong>negative_crops_coords_top_left</strong> (<code>tuple[int, int]</code>, defaults to (0, 0)) &#x2014;
To negatively condition the generation process based on a specific crop coordinates. Part of SDXL&#x2019;s
micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_crops_coords_top_left"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.negative_target_size",description:`<strong>negative_target_size</strong> (<code>tuple[int, int] | None</code>, defaults to <code>None</code>) &#x2014;
To negatively condition the generation process based on a target image resolution. It should be the same
as the <code>target_size</code> for most cases. Part of SDXL&#x2019;s micro-conditioning as explained in section 2.2 of
<a href="https://huggingface.co/papers/2307.01952" rel="nofollow">https://huggingface.co/papers/2307.01952</a>. For more
information, refer to this issue thread: <a href="https://github.com/huggingface/diffusers/issues/4208" rel="nofollow">https://github.com/huggingface/diffusers/issues/4208</a>.`,name:"negative_target_size"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.clip_skip",description:`<strong>clip_skip</strong> (<code>int | None</code>, defaults to <code>None</code>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable[[int, int, dict], None] | PipelineCallback | MultiPipelineCallbacks | None</code>, defaults to <code>None</code>) &#x2014;
A function or a subclass of <code>PipelineCallback</code> or <code>MultiPipelineCallbacks</code> that is called at the end of
each denoising step during the inference with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: dict)</code>. <code>callback_kwargs</code> will include a
list of all tensors as specified by <code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>list[str]</code>, defaults to <code>[&quot;latents&quot;]</code>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"}],source:"https://github.com/huggingface/optimum-neuron/blob/main/optimum/neuron/pipelines/diffusers/pipeline_controlnet_sd_xl.py#L37",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> is returned,
otherwise a <code>tuple</code> is returned containing the output images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput</code> or <code>tuple</code></p>
`}}),{c(){l=i("meta"),y=n(),b=i("p"),d=n(),p(N.$$.fragment),t=n(),p(v.$$.fragment),Dr=n(),p(ht.$$.fragment),Hr=n(),p(_t.$$.fragment),Yr=n(),bt=i("p"),bt.innerHTML=Fi,Qr=n(),C=i("div"),p(Mt.$$.fragment),hs=n(),ln=i("p"),ln.textContent=Xi,_s=n(),cn=i("p"),cn.innerHTML=Ui,bs=n(),dn=i("p"),dn.textContent=Si,Ms=n(),mn=i("ul"),mn.innerHTML=Vi,Ns=n(),pn=i("p"),pn.textContent=zi,vs=n(),un=i("ul"),un.innerHTML=Wi,ys=n(),Ee=i("div"),p(Nt.$$.fragment),ws=n(),gn=i("p"),gn.innerHTML=Bi,Ts=n(),Re=i("div"),p(vt.$$.fragment),$s=n(),fn=i("p"),fn.textContent=Pi,js=n(),Le=i("div"),p(yt.$$.fragment),ks=n(),hn=i("p"),hn.innerHTML=Gi,Cs=n(),qe=i("div"),p(wt.$$.fragment),Js=n(),_n=i("p"),_n.textContent=Ei,Ar=n(),p(Tt.$$.fragment),Kr=n(),$t=i("p"),$t.textContent=Ri,Or=n(),p(jt.$$.fragment),ea=n(),X=i("div"),p(kt.$$.fragment),xs=n(),bn=i("p"),bn.textContent=Li,Is=n(),Mn=i("p"),Mn.innerHTML=qi,Zs=n(),Nn=i("p"),Nn.textContent=Di,Fs=n(),le=i("div"),p(Ct.$$.fragment),Xs=n(),vn=i("p"),vn.innerHTML=Hi,Us=n(),p(De.$$.fragment),ta=n(),p(Jt.$$.fragment),oa=n(),U=i("div"),p(xt.$$.fragment),Ss=n(),yn=i("p"),yn.textContent=Yi,Vs=n(),wn=i("p"),wn.innerHTML=Qi,zs=n(),Tn=i("p"),Tn.textContent=Ai,Ws=n(),re=i("div"),p(It.$$.fragment),Bs=n(),$n=i("p"),$n.innerHTML=Ki,Ps=n(),p(He.$$.fragment),Gs=n(),p(Ye.$$.fragment),na=n(),p(Zt.$$.fragment),ra=n(),S=i("div"),p(Ft.$$.fragment),Es=n(),jn=i("p"),jn.textContent=Oi,Rs=n(),kn=i("p"),kn.innerHTML=ec,Ls=n(),Cn=i("p"),Cn.textContent=tc,qs=n(),ie=i("div"),p(Xt.$$.fragment),Ds=n(),Jn=i("p"),Jn.innerHTML=oc,Hs=n(),p(Qe.$$.fragment),aa=n(),p(Ut.$$.fragment),sa=n(),V=i("div"),p(St.$$.fragment),Ys=n(),xn=i("p"),xn.textContent=nc,Qs=n(),In=i("p"),In.innerHTML=rc,As=n(),Zn=i("p"),Zn.textContent=ac,Ks=n(),ce=i("div"),p(Vt.$$.fragment),Os=n(),Fn=i("p"),Fn.innerHTML=sc,el=n(),p(Ae.$$.fragment),la=n(),p(zt.$$.fragment),ia=n(),z=i("div"),p(Wt.$$.fragment),tl=n(),Xn=i("p"),Xn.textContent=lc,ol=n(),Un=i("p"),Un.innerHTML=ic,nl=n(),Sn=i("p"),Sn.textContent=cc,rl=n(),de=i("div"),p(Bt.$$.fragment),al=n(),Vn=i("p"),Vn.innerHTML=dc,sl=n(),p(Ke.$$.fragment),ca=n(),p(Pt.$$.fragment),da=n(),W=i("div"),p(Gt.$$.fragment),ll=n(),zn=i("p"),zn.textContent=mc,il=n(),Wn=i("p"),Wn.innerHTML=pc,cl=n(),Bn=i("p"),Bn.textContent=uc,dl=n(),me=i("div"),p(Et.$$.fragment),ml=n(),Pn=i("p"),Pn.innerHTML=gc,pl=n(),p(Oe.$$.fragment),ma=n(),p(Rt.$$.fragment),pa=n(),B=i("div"),p(Lt.$$.fragment),ul=n(),Gn=i("p"),Gn.textContent=fc,gl=n(),En=i("p"),En.innerHTML=hc,fl=n(),Rn=i("p"),Rn.textContent=_c,hl=n(),pe=i("div"),p(qt.$$.fragment),_l=n(),Ln=i("p"),Ln.innerHTML=bc,bl=n(),p(et.$$.fragment),ua=n(),p(Dt.$$.fragment),ga=n(),Y=i("div"),p(Ht.$$.fragment),Ml=n(),qn=i("p"),qn.textContent=Mc,Nl=n(),Dn=i("p"),Dn.innerHTML=Nc,vl=n(),Hn=i("div"),p(Yt.$$.fragment),fa=n(),p(Qt.$$.fragment),ha=n(),Q=i("div"),p(At.$$.fragment),yl=n(),Yn=i("p"),Yn.textContent=vc,wl=n(),Qn=i("p"),Qn.innerHTML=yc,Tl=n(),I=i("div"),p(Kt.$$.fragment),$l=n(),An=i("p"),An.innerHTML=wc,jl=n(),p(tt.$$.fragment),kl=n(),Kn=i("p"),Kn.innerHTML=Tc,Cl=n(),p(ot.$$.fragment),Jl=n(),On=i("p"),On.innerHTML=$c,xl=n(),p(nt.$$.fragment),_a=n(),p(Ot.$$.fragment),ba=n(),eo=i("p"),eo.textContent=jc,Ma=n(),p(to.$$.fragment),Na=n(),P=i("div"),p(oo.$$.fragment),Il=n(),er=i("p"),er.textContent=kc,Zl=n(),tr=i("p"),tr.innerHTML=Cc,Fl=n(),or=i("p"),or.textContent=Jc,Xl=n(),ue=i("div"),p(no.$$.fragment),Ul=n(),nr=i("p"),nr.innerHTML=xc,Sl=n(),p(rt.$$.fragment),va=n(),p(ro.$$.fragment),ya=n(),G=i("div"),p(ao.$$.fragment),Vl=n(),rr=i("p"),rr.textContent=Ic,zl=n(),ar=i("p"),ar.innerHTML=Zc,Wl=n(),sr=i("p"),sr.textContent=Fc,Bl=n(),ge=i("div"),p(so.$$.fragment),Pl=n(),lr=i("p"),lr.innerHTML=Xc,Gl=n(),p(at.$$.fragment),wa=n(),p(lo.$$.fragment),Ta=n(),E=i("div"),p(io.$$.fragment),El=n(),ir=i("p"),ir.textContent=Uc,Rl=n(),cr=i("p"),cr.innerHTML=Sc,Ll=n(),dr=i("p"),dr.textContent=Vc,ql=n(),fe=i("div"),p(co.$$.fragment),Dl=n(),mr=i("p"),mr.innerHTML=zc,Hl=n(),p(st.$$.fragment),$a=n(),p(mo.$$.fragment),ja=n(),po=i("p"),po.textContent=Wc,ka=n(),p(uo.$$.fragment),Ca=n(),R=i("div"),p(go.$$.fragment),Yl=n(),pr=i("p"),pr.textContent=Bc,Ql=n(),ur=i("p"),ur.innerHTML=Pc,Al=n(),gr=i("p"),gr.textContent=Gc,Kl=n(),he=i("div"),p(fo.$$.fragment),Ol=n(),fr=i("p"),fr.innerHTML=Ec,ei=n(),p(lt.$$.fragment),Ja=n(),p(ho.$$.fragment),xa=n(),L=i("div"),p(_o.$$.fragment),ti=n(),hr=i("p"),hr.textContent=Rc,oi=n(),_r=i("p"),_r.innerHTML=Lc,ni=n(),br=i("p"),br.textContent=qc,ri=n(),_e=i("div"),p(bo.$$.fragment),ai=n(),Mr=i("p"),Mr.innerHTML=Dc,si=n(),p(it.$$.fragment),Ia=n(),p(Mo.$$.fragment),Za=n(),q=i("div"),p(No.$$.fragment),li=n(),Nr=i("p"),Nr.textContent=Hc,ii=n(),vr=i("p"),vr.innerHTML=Yc,ci=n(),yr=i("p"),yr.textContent=Qc,di=n(),ae=i("div"),p(vo.$$.fragment),mi=n(),wr=i("p"),wr.innerHTML=Ac,pi=n(),p(ct.$$.fragment),ui=n(),p(dt.$$.fragment),Fa=n(),p(yo.$$.fragment),Xa=n(),D=i("div"),p(wo.$$.fragment),gi=n(),Tr=i("p"),Tr.textContent=Kc,fi=n(),$r=i("p"),$r.innerHTML=Oc,hi=n(),jr=i("p"),jr.textContent=ed,_i=n(),be=i("div"),p(To.$$.fragment),bi=n(),kr=i("p"),kr.innerHTML=td,Mi=n(),p(mt.$$.fragment),Ua=n(),p($o.$$.fragment),Sa=n(),jo=i("p"),jo.textContent=od,Va=n(),p(ko.$$.fragment),za=n(),ke=i("div"),p(Co.$$.fragment),Ni=n(),Cr=i("div"),p(Jo.$$.fragment),Wa=n(),p(xo.$$.fragment),Ba=n(),Ce=i("div"),p(Io.$$.fragment),vi=n(),Jr=i("div"),p(Zo.$$.fragment),Pa=n(),p(Fo.$$.fragment),Ga=n(),Je=i("div"),p(Xo.$$.fragment),yi=n(),xr=i("div"),p(Uo.$$.fragment),Ea=n(),p(So.$$.fragment),Ra=n(),xe=i("div"),p(Vo.$$.fragment),wi=n(),Ir=i("div"),p(zo.$$.fragment),La=n(),p(Wo.$$.fragment),qa=n(),Ie=i("div"),p(Bo.$$.fragment),Ti=n(),pt=i("div"),p(Po.$$.fragment),$i=n(),Zr=i("p"),Zr.textContent=nd,Da=n(),p(Go.$$.fragment),Ha=n(),Ze=i("div"),p(Eo.$$.fragment),ji=n(),Fr=i("div"),p(Ro.$$.fragment),Ya=n(),p(Lo.$$.fragment),Qa=n(),Fe=i("div"),p(qo.$$.fragment),ki=n(),Xr=i("div"),p(Do.$$.fragment),Aa=n(),p(Ho.$$.fragment),Ka=n(),Xe=i("div"),p(Yo.$$.fragment),Ci=n(),Ur=i("div"),p(Qo.$$.fragment),Oa=n(),p(Ao.$$.fragment),es=n(),Ue=i("div"),p(Ko.$$.fragment),Ji=n(),Sr=i("div"),p(Oo.$$.fragment),ts=n(),p(en.$$.fragment),os=n(),Se=i("div"),p(tn.$$.fragment),xi=n(),Me=i("div"),p(on.$$.fragment),Ii=n(),Vr=i("p"),Vr.textContent=rd,Zi=n(),zr=i("p"),zr.textContent=ad,ns=n(),qr=i("p"),this.h()},l(e){const s=Md("svelte-u9bgzb",document.head);l=c(s,"META",{name:!0,content:!0}),s.forEach(a),y=r(e),b=c(e,"P",{}),w(b).forEach(a),d=r(e),u(N.$$.fragment,e),t=r(e),u(v.$$.fragment,e),Dr=r(e),u(ht.$$.fragment,e),Hr=r(e),u(_t.$$.fragment,e),Yr=r(e),bt=c(e,"P",{"data-svelte-h":!0}),M(bt)!=="svelte-1wqojdr"&&(bt.innerHTML=Fi),Qr=r(e),C=c(e,"DIV",{class:!0});var J=w(C);u(Mt.$$.fragment,J),hs=r(J),ln=c(J,"P",{"data-svelte-h":!0}),M(ln)!=="svelte-14ur69o"&&(ln.textContent=Xi),_s=r(J),cn=c(J,"P",{"data-svelte-h":!0}),M(cn)!=="svelte-1chwlbt"&&(cn.innerHTML=Ui),bs=r(J),dn=c(J,"P",{"data-svelte-h":!0}),M(dn)!=="svelte-wz8va1"&&(dn.textContent=Si),Ms=r(J),mn=c(J,"UL",{"data-svelte-h":!0}),M(mn)!=="svelte-7z1nij"&&(mn.innerHTML=Vi),Ns=r(J),pn=c(J,"P",{"data-svelte-h":!0}),M(pn)!=="svelte-86gko0"&&(pn.textContent=zi),vs=r(J),un=c(J,"UL",{"data-svelte-h":!0}),M(un)!=="svelte-1jg1kmv"&&(un.innerHTML=Wi),ys=r(J),Ee=c(J,"DIV",{class:!0});var nn=w(Ee);u(Nt.$$.fragment,nn),ws=r(nn),gn=c(nn,"P",{"data-svelte-h":!0}),M(gn)!=="svelte-1r2xt0l"&&(gn.innerHTML=Bi),nn.forEach(a),Ts=r(J),Re=c(J,"DIV",{class:!0});var rn=w(Re);u(vt.$$.fragment,rn),$s=r(rn),fn=c(rn,"P",{"data-svelte-h":!0}),M(fn)!=="svelte-fniwno"&&(fn.textContent=Pi),rn.forEach(a),js=r(J),Le=c(J,"DIV",{class:!0});var an=w(Le);u(yt.$$.fragment,an),ks=r(an),hn=c(an,"P",{"data-svelte-h":!0}),M(hn)!=="svelte-o2sfh1"&&(hn.innerHTML=Gi),an.forEach(a),Cs=r(J),qe=c(J,"DIV",{class:!0});var sn=w(qe);u(wt.$$.fragment,sn),Js=r(sn),_n=c(sn,"P",{"data-svelte-h":!0}),M(_n)!=="svelte-2mtl9d"&&(_n.textContent=Ei),sn.forEach(a),J.forEach(a),Ar=r(e),u(Tt.$$.fragment,e),Kr=r(e),$t=c(e,"P",{"data-svelte-h":!0}),M($t)!=="svelte-1j76tak"&&($t.textContent=Ri),Or=r(e),u(jt.$$.fragment,e),ea=r(e),X=c(e,"DIV",{class:!0});var A=w(X);u(kt.$$.fragment,A),xs=r(A),bn=c(A,"P",{"data-svelte-h":!0}),M(bn)!=="svelte-tyb6d9"&&(bn.textContent=Li),Is=r(A),Mn=c(A,"P",{"data-svelte-h":!0}),M(Mn)!=="svelte-t21i2g"&&(Mn.innerHTML=qi),Zs=r(A),Nn=c(A,"P",{"data-svelte-h":!0}),M(Nn)!=="svelte-1nitj0t"&&(Nn.textContent=Di),Fs=r(A),le=c(A,"DIV",{class:!0});var Ve=w(le);u(Ct.$$.fragment,Ve),Xs=r(Ve),vn=c(Ve,"P",{"data-svelte-h":!0}),M(vn)!=="svelte-cgjaxs"&&(vn.innerHTML=Hi),Us=r(Ve),u(De.$$.fragment,Ve),Ve.forEach(a),A.forEach(a),ta=r(e),u(Jt.$$.fragment,e),oa=r(e),U=c(e,"DIV",{class:!0});var K=w(U);u(xt.$$.fragment,K),Ss=r(K),yn=c(K,"P",{"data-svelte-h":!0}),M(yn)!=="svelte-o9alfo"&&(yn.textContent=Yi),Vs=r(K),wn=c(K,"P",{"data-svelte-h":!0}),M(wn)!=="svelte-t21i2g"&&(wn.innerHTML=Qi),zs=r(K),Tn=c(K,"P",{"data-svelte-h":!0}),M(Tn)!=="svelte-fib3qb"&&(Tn.textContent=Ai),Ws=r(K),re=c(K,"DIV",{class:!0});var se=w(re);u(It.$$.fragment,se),Bs=r(se),$n=c(se,"P",{"data-svelte-h":!0}),M($n)!=="svelte-mm1jdo"&&($n.innerHTML=Ki),Ps=r(se),u(He.$$.fragment,se),Gs=r(se),u(Ye.$$.fragment,se),se.forEach(a),K.forEach(a),na=r(e),u(Zt.$$.fragment,e),ra=r(e),S=c(e,"DIV",{class:!0});var O=w(S);u(Ft.$$.fragment,O),Es=r(O),jn=c(O,"P",{"data-svelte-h":!0}),M(jn)!=="svelte-12nn25"&&(jn.textContent=Oi),Rs=r(O),kn=c(O,"P",{"data-svelte-h":!0}),M(kn)!=="svelte-t21i2g"&&(kn.innerHTML=ec),Ls=r(O),Cn=c(O,"P",{"data-svelte-h":!0}),M(Cn)!=="svelte-1y0nyf2"&&(Cn.textContent=tc),qs=r(O),ie=c(O,"DIV",{class:!0});var ze=w(ie);u(Xt.$$.fragment,ze),Ds=r(ze),Jn=c(ze,"P",{"data-svelte-h":!0}),M(Jn)!=="svelte-8d129p"&&(Jn.innerHTML=oc),Hs=r(ze),u(Qe.$$.fragment,ze),ze.forEach(a),O.forEach(a),aa=r(e),u(Ut.$$.fragment,e),sa=r(e),V=c(e,"DIV",{class:!0});var ee=w(V);u(St.$$.fragment,ee),Ys=r(ee),xn=c(ee,"P",{"data-svelte-h":!0}),M(xn)!=="svelte-sy64kq"&&(xn.textContent=nc),Qs=r(ee),In=c(ee,"P",{"data-svelte-h":!0}),M(In)!=="svelte-t21i2g"&&(In.innerHTML=rc),As=r(ee),Zn=c(ee,"P",{"data-svelte-h":!0}),M(Zn)!=="svelte-1pso76n"&&(Zn.textContent=ac),Ks=r(ee),ce=c(ee,"DIV",{class:!0});var We=w(ce);u(Vt.$$.fragment,We),Os=r(We),Fn=c(We,"P",{"data-svelte-h":!0}),M(Fn)!=="svelte-1qtopj4"&&(Fn.innerHTML=sc),el=r(We),u(Ae.$$.fragment,We),We.forEach(a),ee.forEach(a),la=r(e),u(zt.$$.fragment,e),ia=r(e),z=c(e,"DIV",{class:!0});var te=w(z);u(Wt.$$.fragment,te),tl=r(te),Xn=c(te,"P",{"data-svelte-h":!0}),M(Xn)!=="svelte-196ytxv"&&(Xn.textContent=lc),ol=r(te),Un=c(te,"P",{"data-svelte-h":!0}),M(Un)!=="svelte-t21i2g"&&(Un.innerHTML=ic),nl=r(te),Sn=c(te,"P",{"data-svelte-h":!0}),M(Sn)!=="svelte-8xyl8y"&&(Sn.textContent=cc),rl=r(te),de=c(te,"DIV",{class:!0});var Be=w(de);u(Bt.$$.fragment,Be),al=r(Be),Vn=c(Be,"P",{"data-svelte-h":!0}),M(Vn)!=="svelte-1il3s71"&&(Vn.innerHTML=dc),sl=r(Be),u(Ke.$$.fragment,Be),Be.forEach(a),te.forEach(a),ca=r(e),u(Pt.$$.fragment,e),da=r(e),W=c(e,"DIV",{class:!0});var oe=w(W);u(Gt.$$.fragment,oe),ll=r(oe),zn=c(oe,"P",{"data-svelte-h":!0}),M(zn)!=="svelte-16p5zms"&&(zn.textContent=mc),il=r(oe),Wn=c(oe,"P",{"data-svelte-h":!0}),M(Wn)!=="svelte-t21i2g"&&(Wn.innerHTML=pc),cl=r(oe),Bn=c(oe,"P",{"data-svelte-h":!0}),M(Bn)!=="svelte-1hvccyd"&&(Bn.textContent=uc),dl=r(oe),me=c(oe,"DIV",{class:!0});var Pe=w(me);u(Et.$$.fragment,Pe),ml=r(Pe),Pn=c(Pe,"P",{"data-svelte-h":!0}),M(Pn)!=="svelte-x5ht8e"&&(Pn.innerHTML=gc),pl=r(Pe),u(Oe.$$.fragment,Pe),Pe.forEach(a),oe.forEach(a),ma=r(e),u(Rt.$$.fragment,e),pa=r(e),B=c(e,"DIV",{class:!0});var ne=w(B);u(Lt.$$.fragment,ne),ul=r(ne),Gn=c(ne,"P",{"data-svelte-h":!0}),M(Gn)!=="svelte-1kpvzm3"&&(Gn.textContent=fc),gl=r(ne),En=c(ne,"P",{"data-svelte-h":!0}),M(En)!=="svelte-t21i2g"&&(En.innerHTML=hc),fl=r(ne),Rn=c(ne,"P",{"data-svelte-h":!0}),M(Rn)!=="svelte-v7xrhz"&&(Rn.textContent=_c),hl=r(ne),pe=c(ne,"DIV",{class:!0});var Ge=w(pe);u(qt.$$.fragment,Ge),_l=r(Ge),Ln=c(Ge,"P",{"data-svelte-h":!0}),M(Ln)!=="svelte-kejd1q"&&(Ln.innerHTML=bc),bl=r(Ge),u(et.$$.fragment,Ge),Ge.forEach(a),ne.forEach(a),ua=r(e),u(Dt.$$.fragment,e),ga=r(e),Y=c(e,"DIV",{class:!0});var ut=w(Y);u(Ht.$$.fragment,ut),Ml=r(ut),qn=c(ut,"P",{"data-svelte-h":!0}),M(qn)!=="svelte-1dh7ria"&&(qn.textContent=Mc),Nl=r(ut),Dn=c(ut,"P",{"data-svelte-h":!0}),M(Dn)!=="svelte-m4jyla"&&(Dn.innerHTML=Nc),vl=r(ut),Hn=c(ut,"DIV",{class:!0});var sd=w(Hn);u(Yt.$$.fragment,sd),sd.forEach(a),ut.forEach(a),fa=r(e),u(Qt.$$.fragment,e),ha=r(e),Q=c(e,"DIV",{class:!0});var gt=w(Q);u(At.$$.fragment,gt),yl=r(gt),Yn=c(gt,"P",{"data-svelte-h":!0}),M(Yn)!=="svelte-12et8hl"&&(Yn.textContent=vc),wl=r(gt),Qn=c(gt,"P",{"data-svelte-h":!0}),M(Qn)!=="svelte-t21i2g"&&(Qn.innerHTML=yc),Tl=r(gt),I=c(gt,"DIV",{class:!0});var H=w(I);u(Kt.$$.fragment,H),$l=r(H),An=c(H,"P",{"data-svelte-h":!0}),M(An)!=="svelte-dxj8i4"&&(An.innerHTML=wc),jl=r(H),u(tt.$$.fragment,H),kl=r(H),Kn=c(H,"P",{"data-svelte-h":!0}),M(Kn)!=="svelte-1osiy1t"&&(Kn.innerHTML=Tc),Cl=r(H),u(ot.$$.fragment,H),Jl=r(H),On=c(H,"P",{"data-svelte-h":!0}),M(On)!=="svelte-89pj2f"&&(On.innerHTML=$c),xl=r(H),u(nt.$$.fragment,H),H.forEach(a),gt.forEach(a),_a=r(e),u(Ot.$$.fragment,e),ba=r(e),eo=c(e,"P",{"data-svelte-h":!0}),M(eo)!=="svelte-dmb9sp"&&(eo.textContent=jc),Ma=r(e),u(to.$$.fragment,e),Na=r(e),P=c(e,"DIV",{class:!0});var Ne=w(P);u(oo.$$.fragment,Ne),Il=r(Ne),er=c(Ne,"P",{"data-svelte-h":!0}),M(er)!=="svelte-iobswt"&&(er.textContent=kc),Zl=r(Ne),tr=c(Ne,"P",{"data-svelte-h":!0}),M(tr)!=="svelte-t21i2g"&&(tr.innerHTML=Cc),Fl=r(Ne),or=c(Ne,"P",{"data-svelte-h":!0}),M(or)!=="svelte-1g4h8eb"&&(or.textContent=Jc),Xl=r(Ne),ue=c(Ne,"DIV",{class:!0});var Wr=w(ue);u(no.$$.fragment,Wr),Ul=r(Wr),nr=c(Wr,"P",{"data-svelte-h":!0}),M(nr)!=="svelte-4a7c7i"&&(nr.innerHTML=xc),Sl=r(Wr),u(rt.$$.fragment,Wr),Wr.forEach(a),Ne.forEach(a),va=r(e),u(ro.$$.fragment,e),ya=r(e),G=c(e,"DIV",{class:!0});var ve=w(G);u(ao.$$.fragment,ve),Vl=r(ve),rr=c(ve,"P",{"data-svelte-h":!0}),M(rr)!=="svelte-a522e4"&&(rr.textContent=Ic),zl=r(ve),ar=c(ve,"P",{"data-svelte-h":!0}),M(ar)!=="svelte-t21i2g"&&(ar.innerHTML=Zc),Wl=r(ve),sr=c(ve,"P",{"data-svelte-h":!0}),M(sr)!=="svelte-jb8c8r"&&(sr.textContent=Fc),Bl=r(ve),ge=c(ve,"DIV",{class:!0});var Br=w(ge);u(so.$$.fragment,Br),Pl=r(Br),lr=c(Br,"P",{"data-svelte-h":!0}),M(lr)!=="svelte-kcdbet"&&(lr.innerHTML=Xc),Gl=r(Br),u(at.$$.fragment,Br),Br.forEach(a),ve.forEach(a),wa=r(e),u(lo.$$.fragment,e),Ta=r(e),E=c(e,"DIV",{class:!0});var ye=w(E);u(io.$$.fragment,ye),El=r(ye),ir=c(ye,"P",{"data-svelte-h":!0}),M(ir)!=="svelte-1jokdk4"&&(ir.textContent=Uc),Rl=r(ye),cr=c(ye,"P",{"data-svelte-h":!0}),M(cr)!=="svelte-t21i2g"&&(cr.innerHTML=Sc),Ll=r(ye),dr=c(ye,"P",{"data-svelte-h":!0}),M(dr)!=="svelte-pqeh18"&&(dr.textContent=Vc),ql=r(ye),fe=c(ye,"DIV",{class:!0});var Pr=w(fe);u(co.$$.fragment,Pr),Dl=r(Pr),mr=c(Pr,"P",{"data-svelte-h":!0}),M(mr)!=="svelte-rg1qqx"&&(mr.innerHTML=zc),Hl=r(Pr),u(st.$$.fragment,Pr),Pr.forEach(a),ye.forEach(a),$a=r(e),u(mo.$$.fragment,e),ja=r(e),po=c(e,"P",{"data-svelte-h":!0}),M(po)!=="svelte-1htpfc5"&&(po.textContent=Wc),ka=r(e),u(uo.$$.fragment,e),Ca=r(e),R=c(e,"DIV",{class:!0});var we=w(R);u(go.$$.fragment,we),Yl=r(we),pr=c(we,"P",{"data-svelte-h":!0}),M(pr)!=="svelte-13994kt"&&(pr.textContent=Bc),Ql=r(we),ur=c(we,"P",{"data-svelte-h":!0}),M(ur)!=="svelte-t21i2g"&&(ur.innerHTML=Pc),Al=r(we),gr=c(we,"P",{"data-svelte-h":!0}),M(gr)!=="svelte-iwso1f"&&(gr.textContent=Gc),Kl=r(we),he=c(we,"DIV",{class:!0});var Gr=w(he);u(fo.$$.fragment,Gr),Ol=r(Gr),fr=c(Gr,"P",{"data-svelte-h":!0}),M(fr)!=="svelte-1mrzugx"&&(fr.innerHTML=Ec),ei=r(Gr),u(lt.$$.fragment,Gr),Gr.forEach(a),we.forEach(a),Ja=r(e),u(ho.$$.fragment,e),xa=r(e),L=c(e,"DIV",{class:!0});var Te=w(L);u(_o.$$.fragment,Te),ti=r(Te),hr=c(Te,"P",{"data-svelte-h":!0}),M(hr)!=="svelte-1wtizei"&&(hr.textContent=Rc),oi=r(Te),_r=c(Te,"P",{"data-svelte-h":!0}),M(_r)!=="svelte-t21i2g"&&(_r.innerHTML=Lc),ni=r(Te),br=c(Te,"P",{"data-svelte-h":!0}),M(br)!=="svelte-484vqn"&&(br.textContent=qc),ri=r(Te),_e=c(Te,"DIV",{class:!0});var Er=w(_e);u(bo.$$.fragment,Er),ai=r(Er),Mr=c(Er,"P",{"data-svelte-h":!0}),M(Mr)!=="svelte-hohte"&&(Mr.innerHTML=Dc),si=r(Er),u(it.$$.fragment,Er),Er.forEach(a),Te.forEach(a),Ia=r(e),u(Mo.$$.fragment,e),Za=r(e),q=c(e,"DIV",{class:!0});var $e=w(q);u(No.$$.fragment,$e),li=r($e),Nr=c($e,"P",{"data-svelte-h":!0}),M(Nr)!=="svelte-1minwrj"&&(Nr.textContent=Hc),ii=r($e),vr=c($e,"P",{"data-svelte-h":!0}),M(vr)!=="svelte-t21i2g"&&(vr.innerHTML=Yc),ci=r($e),yr=c($e,"P",{"data-svelte-h":!0}),M(yr)!=="svelte-1dft1qw"&&(yr.textContent=Qc),di=r($e),ae=c($e,"DIV",{class:!0});var ft=w(ae);u(vo.$$.fragment,ft),mi=r(ft),wr=c(ft,"P",{"data-svelte-h":!0}),M(wr)!=="svelte-33b8wf"&&(wr.innerHTML=Ac),pi=r(ft),u(ct.$$.fragment,ft),ui=r(ft),u(dt.$$.fragment,ft),ft.forEach(a),$e.forEach(a),Fa=r(e),u(yo.$$.fragment,e),Xa=r(e),D=c(e,"DIV",{class:!0});var je=w(D);u(wo.$$.fragment,je),gi=r(je),Tr=c(je,"P",{"data-svelte-h":!0}),M(Tr)!=="svelte-ylsbuv"&&(Tr.textContent=Kc),fi=r(je),$r=c(je,"P",{"data-svelte-h":!0}),M($r)!=="svelte-t21i2g"&&($r.innerHTML=Oc),hi=r(je),jr=c(je,"P",{"data-svelte-h":!0}),M(jr)!=="svelte-ylsbuv"&&(jr.textContent=ed),_i=r(je),be=c(je,"DIV",{class:!0});var Rr=w(be);u(To.$$.fragment,Rr),bi=r(Rr),kr=c(Rr,"P",{"data-svelte-h":!0}),M(kr)!=="svelte-190wczg"&&(kr.innerHTML=td),Mi=r(Rr),u(mt.$$.fragment,Rr),Rr.forEach(a),je.forEach(a),Ua=r(e),u($o.$$.fragment,e),Sa=r(e),jo=c(e,"P",{"data-svelte-h":!0}),M(jo)!=="svelte-149jhtw"&&(jo.textContent=od),Va=r(e),u(ko.$$.fragment,e),za=r(e),ke=c(e,"DIV",{class:!0});var as=w(ke);u(Co.$$.fragment,as),Ni=r(as),Cr=c(as,"DIV",{class:!0});var ld=w(Cr);u(Jo.$$.fragment,ld),ld.forEach(a),as.forEach(a),Wa=r(e),u(xo.$$.fragment,e),Ba=r(e),Ce=c(e,"DIV",{class:!0});var ss=w(Ce);u(Io.$$.fragment,ss),vi=r(ss),Jr=c(ss,"DIV",{class:!0});var id=w(Jr);u(Zo.$$.fragment,id),id.forEach(a),ss.forEach(a),Pa=r(e),u(Fo.$$.fragment,e),Ga=r(e),Je=c(e,"DIV",{class:!0});var ls=w(Je);u(Xo.$$.fragment,ls),yi=r(ls),xr=c(ls,"DIV",{class:!0});var cd=w(xr);u(Uo.$$.fragment,cd),cd.forEach(a),ls.forEach(a),Ea=r(e),u(So.$$.fragment,e),Ra=r(e),xe=c(e,"DIV",{class:!0});var is=w(xe);u(Vo.$$.fragment,is),wi=r(is),Ir=c(is,"DIV",{class:!0});var dd=w(Ir);u(zo.$$.fragment,dd),dd.forEach(a),is.forEach(a),La=r(e),u(Wo.$$.fragment,e),qa=r(e),Ie=c(e,"DIV",{class:!0});var cs=w(Ie);u(Bo.$$.fragment,cs),Ti=r(cs),pt=c(cs,"DIV",{class:!0});var ds=w(pt);u(Po.$$.fragment,ds),$i=r(ds),Zr=c(ds,"P",{"data-svelte-h":!0}),M(Zr)!=="svelte-50j04k"&&(Zr.textContent=nd),ds.forEach(a),cs.forEach(a),Da=r(e),u(Go.$$.fragment,e),Ha=r(e),Ze=c(e,"DIV",{class:!0});var ms=w(Ze);u(Eo.$$.fragment,ms),ji=r(ms),Fr=c(ms,"DIV",{class:!0});var md=w(Fr);u(Ro.$$.fragment,md),md.forEach(a),ms.forEach(a),Ya=r(e),u(Lo.$$.fragment,e),Qa=r(e),Fe=c(e,"DIV",{class:!0});var ps=w(Fe);u(qo.$$.fragment,ps),ki=r(ps),Xr=c(ps,"DIV",{class:!0});var pd=w(Xr);u(Do.$$.fragment,pd),pd.forEach(a),ps.forEach(a),Aa=r(e),u(Ho.$$.fragment,e),Ka=r(e),Xe=c(e,"DIV",{class:!0});var us=w(Xe);u(Yo.$$.fragment,us),Ci=r(us),Ur=c(us,"DIV",{class:!0});var ud=w(Ur);u(Qo.$$.fragment,ud),ud.forEach(a),us.forEach(a),Oa=r(e),u(Ao.$$.fragment,e),es=r(e),Ue=c(e,"DIV",{class:!0});var gs=w(Ue);u(Ko.$$.fragment,gs),Ji=r(gs),Sr=c(gs,"DIV",{class:!0});var gd=w(Sr);u(Oo.$$.fragment,gd),gd.forEach(a),gs.forEach(a),ts=r(e),u(en.$$.fragment,e),os=r(e),Se=c(e,"DIV",{class:!0});var fs=w(Se);u(tn.$$.fragment,fs),xi=r(fs),Me=c(fs,"DIV",{class:!0});var Lr=w(Me);u(on.$$.fragment,Lr),Ii=r(Lr),Vr=c(Lr,"P",{"data-svelte-h":!0}),M(Vr)!=="svelte-50j04k"&&(Vr.textContent=rd),Zi=r(Lr),zr=c(Lr,"P",{"data-svelte-h":!0}),M(zr)!=="svelte-kvfsh7"&&(zr.textContent=ad),Lr.forEach(a),fs.forEach(a),ns=r(e),qr=c(e,"P",{}),w(qr).forEach(a),this.h()},h(){T(l,"name","hf:doc:metadata"),T(l,"content",Gd),T(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Hn,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Cr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(ke,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Jr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Je,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ir,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(pt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Fr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Xr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ur,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Sr,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),T(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,s){o(document.head,l),m(e,y,s),m(e,b,s),m(e,d,s),g(N,e,s),m(e,t,s),g(v,e,s),m(e,Dr,s),g(ht,e,s),m(e,Hr,s),g(_t,e,s),m(e,Yr,s),m(e,bt,s),m(e,Qr,s),m(e,C,s),g(Mt,C,null),o(C,hs),o(C,ln),o(C,_s),o(C,cn),o(C,bs),o(C,dn),o(C,Ms),o(C,mn),o(C,Ns),o(C,pn),o(C,vs),o(C,un),o(C,ys),o(C,Ee),g(Nt,Ee,null),o(Ee,ws),o(Ee,gn),o(C,Ts),o(C,Re),g(vt,Re,null),o(Re,$s),o(Re,fn),o(C,js),o(C,Le),g(yt,Le,null),o(Le,ks),o(Le,hn),o(C,Cs),o(C,qe),g(wt,qe,null),o(qe,Js),o(qe,_n),m(e,Ar,s),g(Tt,e,s),m(e,Kr,s),m(e,$t,s),m(e,Or,s),g(jt,e,s),m(e,ea,s),m(e,X,s),g(kt,X,null),o(X,xs),o(X,bn),o(X,Is),o(X,Mn),o(X,Zs),o(X,Nn),o(X,Fs),o(X,le),g(Ct,le,null),o(le,Xs),o(le,vn),o(le,Us),g(De,le,null),m(e,ta,s),g(Jt,e,s),m(e,oa,s),m(e,U,s),g(xt,U,null),o(U,Ss),o(U,yn),o(U,Vs),o(U,wn),o(U,zs),o(U,Tn),o(U,Ws),o(U,re),g(It,re,null),o(re,Bs),o(re,$n),o(re,Ps),g(He,re,null),o(re,Gs),g(Ye,re,null),m(e,na,s),g(Zt,e,s),m(e,ra,s),m(e,S,s),g(Ft,S,null),o(S,Es),o(S,jn),o(S,Rs),o(S,kn),o(S,Ls),o(S,Cn),o(S,qs),o(S,ie),g(Xt,ie,null),o(ie,Ds),o(ie,Jn),o(ie,Hs),g(Qe,ie,null),m(e,aa,s),g(Ut,e,s),m(e,sa,s),m(e,V,s),g(St,V,null),o(V,Ys),o(V,xn),o(V,Qs),o(V,In),o(V,As),o(V,Zn),o(V,Ks),o(V,ce),g(Vt,ce,null),o(ce,Os),o(ce,Fn),o(ce,el),g(Ae,ce,null),m(e,la,s),g(zt,e,s),m(e,ia,s),m(e,z,s),g(Wt,z,null),o(z,tl),o(z,Xn),o(z,ol),o(z,Un),o(z,nl),o(z,Sn),o(z,rl),o(z,de),g(Bt,de,null),o(de,al),o(de,Vn),o(de,sl),g(Ke,de,null),m(e,ca,s),g(Pt,e,s),m(e,da,s),m(e,W,s),g(Gt,W,null),o(W,ll),o(W,zn),o(W,il),o(W,Wn),o(W,cl),o(W,Bn),o(W,dl),o(W,me),g(Et,me,null),o(me,ml),o(me,Pn),o(me,pl),g(Oe,me,null),m(e,ma,s),g(Rt,e,s),m(e,pa,s),m(e,B,s),g(Lt,B,null),o(B,ul),o(B,Gn),o(B,gl),o(B,En),o(B,fl),o(B,Rn),o(B,hl),o(B,pe),g(qt,pe,null),o(pe,_l),o(pe,Ln),o(pe,bl),g(et,pe,null),m(e,ua,s),g(Dt,e,s),m(e,ga,s),m(e,Y,s),g(Ht,Y,null),o(Y,Ml),o(Y,qn),o(Y,Nl),o(Y,Dn),o(Y,vl),o(Y,Hn),g(Yt,Hn,null),m(e,fa,s),g(Qt,e,s),m(e,ha,s),m(e,Q,s),g(At,Q,null),o(Q,yl),o(Q,Yn),o(Q,wl),o(Q,Qn),o(Q,Tl),o(Q,I),g(Kt,I,null),o(I,$l),o(I,An),o(I,jl),g(tt,I,null),o(I,kl),o(I,Kn),o(I,Cl),g(ot,I,null),o(I,Jl),o(I,On),o(I,xl),g(nt,I,null),m(e,_a,s),g(Ot,e,s),m(e,ba,s),m(e,eo,s),m(e,Ma,s),g(to,e,s),m(e,Na,s),m(e,P,s),g(oo,P,null),o(P,Il),o(P,er),o(P,Zl),o(P,tr),o(P,Fl),o(P,or),o(P,Xl),o(P,ue),g(no,ue,null),o(ue,Ul),o(ue,nr),o(ue,Sl),g(rt,ue,null),m(e,va,s),g(ro,e,s),m(e,ya,s),m(e,G,s),g(ao,G,null),o(G,Vl),o(G,rr),o(G,zl),o(G,ar),o(G,Wl),o(G,sr),o(G,Bl),o(G,ge),g(so,ge,null),o(ge,Pl),o(ge,lr),o(ge,Gl),g(at,ge,null),m(e,wa,s),g(lo,e,s),m(e,Ta,s),m(e,E,s),g(io,E,null),o(E,El),o(E,ir),o(E,Rl),o(E,cr),o(E,Ll),o(E,dr),o(E,ql),o(E,fe),g(co,fe,null),o(fe,Dl),o(fe,mr),o(fe,Hl),g(st,fe,null),m(e,$a,s),g(mo,e,s),m(e,ja,s),m(e,po,s),m(e,ka,s),g(uo,e,s),m(e,Ca,s),m(e,R,s),g(go,R,null),o(R,Yl),o(R,pr),o(R,Ql),o(R,ur),o(R,Al),o(R,gr),o(R,Kl),o(R,he),g(fo,he,null),o(he,Ol),o(he,fr),o(he,ei),g(lt,he,null),m(e,Ja,s),g(ho,e,s),m(e,xa,s),m(e,L,s),g(_o,L,null),o(L,ti),o(L,hr),o(L,oi),o(L,_r),o(L,ni),o(L,br),o(L,ri),o(L,_e),g(bo,_e,null),o(_e,ai),o(_e,Mr),o(_e,si),g(it,_e,null),m(e,Ia,s),g(Mo,e,s),m(e,Za,s),m(e,q,s),g(No,q,null),o(q,li),o(q,Nr),o(q,ii),o(q,vr),o(q,ci),o(q,yr),o(q,di),o(q,ae),g(vo,ae,null),o(ae,mi),o(ae,wr),o(ae,pi),g(ct,ae,null),o(ae,ui),g(dt,ae,null),m(e,Fa,s),g(yo,e,s),m(e,Xa,s),m(e,D,s),g(wo,D,null),o(D,gi),o(D,Tr),o(D,fi),o(D,$r),o(D,hi),o(D,jr),o(D,_i),o(D,be),g(To,be,null),o(be,bi),o(be,kr),o(be,Mi),g(mt,be,null),m(e,Ua,s),g($o,e,s),m(e,Sa,s),m(e,jo,s),m(e,Va,s),g(ko,e,s),m(e,za,s),m(e,ke,s),g(Co,ke,null),o(ke,Ni),o(ke,Cr),g(Jo,Cr,null),m(e,Wa,s),g(xo,e,s),m(e,Ba,s),m(e,Ce,s),g(Io,Ce,null),o(Ce,vi),o(Ce,Jr),g(Zo,Jr,null),m(e,Pa,s),g(Fo,e,s),m(e,Ga,s),m(e,Je,s),g(Xo,Je,null),o(Je,yi),o(Je,xr),g(Uo,xr,null),m(e,Ea,s),g(So,e,s),m(e,Ra,s),m(e,xe,s),g(Vo,xe,null),o(xe,wi),o(xe,Ir),g(zo,Ir,null),m(e,La,s),g(Wo,e,s),m(e,qa,s),m(e,Ie,s),g(Bo,Ie,null),o(Ie,Ti),o(Ie,pt),g(Po,pt,null),o(pt,$i),o(pt,Zr),m(e,Da,s),g(Go,e,s),m(e,Ha,s),m(e,Ze,s),g(Eo,Ze,null),o(Ze,ji),o(Ze,Fr),g(Ro,Fr,null),m(e,Ya,s),g(Lo,e,s),m(e,Qa,s),m(e,Fe,s),g(qo,Fe,null),o(Fe,ki),o(Fe,Xr),g(Do,Xr,null),m(e,Aa,s),g(Ho,e,s),m(e,Ka,s),m(e,Xe,s),g(Yo,Xe,null),o(Xe,Ci),o(Xe,Ur),g(Qo,Ur,null),m(e,Oa,s),g(Ao,e,s),m(e,es,s),m(e,Ue,s),g(Ko,Ue,null),o(Ue,Ji),o(Ue,Sr),g(Oo,Sr,null),m(e,ts,s),g(en,e,s),m(e,os,s),m(e,Se,s),g(tn,Se,null),o(Se,xi),o(Se,Me),g(on,Me,null),o(Me,Ii),o(Me,Vr),o(Me,Zi),o(Me,zr),m(e,ns,s),m(e,qr,s),rs=!0},p(e,[s]){const J={};s&2&&(J.$$scope={dirty:s,ctx:e}),De.$set(J);const nn={};s&2&&(nn.$$scope={dirty:s,ctx:e}),He.$set(nn);const rn={};s&2&&(rn.$$scope={dirty:s,ctx:e}),Ye.$set(rn);const an={};s&2&&(an.$$scope={dirty:s,ctx:e}),Qe.$set(an);const sn={};s&2&&(sn.$$scope={dirty:s,ctx:e}),Ae.$set(sn);const A={};s&2&&(A.$$scope={dirty:s,ctx:e}),Ke.$set(A);const Ve={};s&2&&(Ve.$$scope={dirty:s,ctx:e}),Oe.$set(Ve);const K={};s&2&&(K.$$scope={dirty:s,ctx:e}),et.$set(K);const se={};s&2&&(se.$$scope={dirty:s,ctx:e}),tt.$set(se);const O={};s&2&&(O.$$scope={dirty:s,ctx:e}),ot.$set(O);const ze={};s&2&&(ze.$$scope={dirty:s,ctx:e}),nt.$set(ze);const ee={};s&2&&(ee.$$scope={dirty:s,ctx:e}),rt.$set(ee);const We={};s&2&&(We.$$scope={dirty:s,ctx:e}),at.$set(We);const te={};s&2&&(te.$$scope={dirty:s,ctx:e}),st.$set(te);const Be={};s&2&&(Be.$$scope={dirty:s,ctx:e}),lt.$set(Be);const oe={};s&2&&(oe.$$scope={dirty:s,ctx:e}),it.$set(oe);const Pe={};s&2&&(Pe.$$scope={dirty:s,ctx:e}),ct.$set(Pe);const ne={};s&2&&(ne.$$scope={dirty:s,ctx:e}),dt.$set(ne);const Ge={};s&2&&(Ge.$$scope={dirty:s,ctx:e}),mt.$set(Ge)},i(e){rs||(f(N.$$.fragment,e),f(v.$$.fragment,e),f(ht.$$.fragment,e),f(_t.$$.fragment,e),f(Mt.$$.fragment,e),f(Nt.$$.fragment,e),f(vt.$$.fragment,e),f(yt.$$.fragment,e),f(wt.$$.fragment,e),f(Tt.$$.fragment,e),f(jt.$$.fragment,e),f(kt.$$.fragment,e),f(Ct.$$.fragment,e),f(De.$$.fragment,e),f(Jt.$$.fragment,e),f(xt.$$.fragment,e),f(It.$$.fragment,e),f(He.$$.fragment,e),f(Ye.$$.fragment,e),f(Zt.$$.fragment,e),f(Ft.$$.fragment,e),f(Xt.$$.fragment,e),f(Qe.$$.fragment,e),f(Ut.$$.fragment,e),f(St.$$.fragment,e),f(Vt.$$.fragment,e),f(Ae.$$.fragment,e),f(zt.$$.fragment,e),f(Wt.$$.fragment,e),f(Bt.$$.fragment,e),f(Ke.$$.fragment,e),f(Pt.$$.fragment,e),f(Gt.$$.fragment,e),f(Et.$$.fragment,e),f(Oe.$$.fragment,e),f(Rt.$$.fragment,e),f(Lt.$$.fragment,e),f(qt.$$.fragment,e),f(et.$$.fragment,e),f(Dt.$$.fragment,e),f(Ht.$$.fragment,e),f(Yt.$$.fragment,e),f(Qt.$$.fragment,e),f(At.$$.fragment,e),f(Kt.$$.fragment,e),f(tt.$$.fragment,e),f(ot.$$.fragment,e),f(nt.$$.fragment,e),f(Ot.$$.fragment,e),f(to.$$.fragment,e),f(oo.$$.fragment,e),f(no.$$.fragment,e),f(rt.$$.fragment,e),f(ro.$$.fragment,e),f(ao.$$.fragment,e),f(so.$$.fragment,e),f(at.$$.fragment,e),f(lo.$$.fragment,e),f(io.$$.fragment,e),f(co.$$.fragment,e),f(st.$$.fragment,e),f(mo.$$.fragment,e),f(uo.$$.fragment,e),f(go.$$.fragment,e),f(fo.$$.fragment,e),f(lt.$$.fragment,e),f(ho.$$.fragment,e),f(_o.$$.fragment,e),f(bo.$$.fragment,e),f(it.$$.fragment,e),f(Mo.$$.fragment,e),f(No.$$.fragment,e),f(vo.$$.fragment,e),f(ct.$$.fragment,e),f(dt.$$.fragment,e),f(yo.$$.fragment,e),f(wo.$$.fragment,e),f(To.$$.fragment,e),f(mt.$$.fragment,e),f($o.$$.fragment,e),f(ko.$$.fragment,e),f(Co.$$.fragment,e),f(Jo.$$.fragment,e),f(xo.$$.fragment,e),f(Io.$$.fragment,e),f(Zo.$$.fragment,e),f(Fo.$$.fragment,e),f(Xo.$$.fragment,e),f(Uo.$$.fragment,e),f(So.$$.fragment,e),f(Vo.$$.fragment,e),f(zo.$$.fragment,e),f(Wo.$$.fragment,e),f(Bo.$$.fragment,e),f(Po.$$.fragment,e),f(Go.$$.fragment,e),f(Eo.$$.fragment,e),f(Ro.$$.fragment,e),f(Lo.$$.fragment,e),f(qo.$$.fragment,e),f(Do.$$.fragment,e),f(Ho.$$.fragment,e),f(Yo.$$.fragment,e),f(Qo.$$.fragment,e),f(Ao.$$.fragment,e),f(Ko.$$.fragment,e),f(Oo.$$.fragment,e),f(en.$$.fragment,e),f(tn.$$.fragment,e),f(on.$$.fragment,e),rs=!0)},o(e){h(N.$$.fragment,e),h(v.$$.fragment,e),h(ht.$$.fragment,e),h(_t.$$.fragment,e),h(Mt.$$.fragment,e),h(Nt.$$.fragment,e),h(vt.$$.fragment,e),h(yt.$$.fragment,e),h(wt.$$.fragment,e),h(Tt.$$.fragment,e),h(jt.$$.fragment,e),h(kt.$$.fragment,e),h(Ct.$$.fragment,e),h(De.$$.fragment,e),h(Jt.$$.fragment,e),h(xt.$$.fragment,e),h(It.$$.fragment,e),h(He.$$.fragment,e),h(Ye.$$.fragment,e),h(Zt.$$.fragment,e),h(Ft.$$.fragment,e),h(Xt.$$.fragment,e),h(Qe.$$.fragment,e),h(Ut.$$.fragment,e),h(St.$$.fragment,e),h(Vt.$$.fragment,e),h(Ae.$$.fragment,e),h(zt.$$.fragment,e),h(Wt.$$.fragment,e),h(Bt.$$.fragment,e),h(Ke.$$.fragment,e),h(Pt.$$.fragment,e),h(Gt.$$.fragment,e),h(Et.$$.fragment,e),h(Oe.$$.fragment,e),h(Rt.$$.fragment,e),h(Lt.$$.fragment,e),h(qt.$$.fragment,e),h(et.$$.fragment,e),h(Dt.$$.fragment,e),h(Ht.$$.fragment,e),h(Yt.$$.fragment,e),h(Qt.$$.fragment,e),h(At.$$.fragment,e),h(Kt.$$.fragment,e),h(tt.$$.fragment,e),h(ot.$$.fragment,e),h(nt.$$.fragment,e),h(Ot.$$.fragment,e),h(to.$$.fragment,e),h(oo.$$.fragment,e),h(no.$$.fragment,e),h(rt.$$.fragment,e),h(ro.$$.fragment,e),h(ao.$$.fragment,e),h(so.$$.fragment,e),h(at.$$.fragment,e),h(lo.$$.fragment,e),h(io.$$.fragment,e),h(co.$$.fragment,e),h(st.$$.fragment,e),h(mo.$$.fragment,e),h(uo.$$.fragment,e),h(go.$$.fragment,e),h(fo.$$.fragment,e),h(lt.$$.fragment,e),h(ho.$$.fragment,e),h(_o.$$.fragment,e),h(bo.$$.fragment,e),h(it.$$.fragment,e),h(Mo.$$.fragment,e),h(No.$$.fragment,e),h(vo.$$.fragment,e),h(ct.$$.fragment,e),h(dt.$$.fragment,e),h(yo.$$.fragment,e),h(wo.$$.fragment,e),h(To.$$.fragment,e),h(mt.$$.fragment,e),h($o.$$.fragment,e),h(ko.$$.fragment,e),h(Co.$$.fragment,e),h(Jo.$$.fragment,e),h(xo.$$.fragment,e),h(Io.$$.fragment,e),h(Zo.$$.fragment,e),h(Fo.$$.fragment,e),h(Xo.$$.fragment,e),h(Uo.$$.fragment,e),h(So.$$.fragment,e),h(Vo.$$.fragment,e),h(zo.$$.fragment,e),h(Wo.$$.fragment,e),h(Bo.$$.fragment,e),h(Po.$$.fragment,e),h(Go.$$.fragment,e),h(Eo.$$.fragment,e),h(Ro.$$.fragment,e),h(Lo.$$.fragment,e),h(qo.$$.fragment,e),h(Do.$$.fragment,e),h(Ho.$$.fragment,e),h(Yo.$$.fragment,e),h(Qo.$$.fragment,e),h(Ao.$$.fragment,e),h(Ko.$$.fragment,e),h(Oo.$$.fragment,e),h(en.$$.fragment,e),h(tn.$$.fragment,e),h(on.$$.fragment,e),rs=!1},d(e){e&&(a(y),a(b),a(d),a(t),a(Dr),a(Hr),a(Yr),a(bt),a(Qr),a(C),a(Ar),a(Kr),a($t),a(Or),a(ea),a(X),a(ta),a(oa),a(U),a(na),a(ra),a(S),a(aa),a(sa),a(V),a(la),a(ia),a(z),a(ca),a(da),a(W),a(ma),a(pa),a(B),a(ua),a(ga),a(Y),a(fa),a(ha),a(Q),a(_a),a(ba),a(eo),a(Ma),a(Na),a(P),a(va),a(ya),a(G),a(wa),a(Ta),a(E),a($a),a(ja),a(po),a(ka),a(Ca),a(R),a(Ja),a(xa),a(L),a(Ia),a(Za),a(q),a(Fa),a(Xa),a(D),a(Ua),a(Sa),a(jo),a(Va),a(za),a(ke),a(Wa),a(Ba),a(Ce),a(Pa),a(Ga),a(Je),a(Ea),a(Ra),a(xe),a(La),a(qa),a(Ie),a(Da),a(Ha),a(Ze),a(Ya),a(Qa),a(Fe),a(Aa),a(Ka),a(Xe),a(Oa),a(es),a(Ue),a(ts),a(os),a(Se),a(ns),a(qr)),a(l),_(N,e),_(v,e),_(ht,e),_(_t,e),_(Mt),_(Nt),_(vt),_(yt),_(wt),_(Tt,e),_(jt,e),_(kt),_(Ct),_(De),_(Jt,e),_(xt),_(It),_(He),_(Ye),_(Zt,e),_(Ft),_(Xt),_(Qe),_(Ut,e),_(St),_(Vt),_(Ae),_(zt,e),_(Wt),_(Bt),_(Ke),_(Pt,e),_(Gt),_(Et),_(Oe),_(Rt,e),_(Lt),_(qt),_(et),_(Dt,e),_(Ht),_(Yt),_(Qt,e),_(At),_(Kt),_(tt),_(ot),_(nt),_(Ot,e),_(to,e),_(oo),_(no),_(rt),_(ro,e),_(ao),_(so),_(at),_(lo,e),_(io),_(co),_(st),_(mo,e),_(uo,e),_(go),_(fo),_(lt),_(ho,e),_(_o),_(bo),_(it),_(Mo,e),_(No),_(vo),_(ct),_(dt),_(yo,e),_(wo),_(To),_(mt),_($o,e),_(ko,e),_(Co),_(Jo),_(xo,e),_(Io),_(Zo),_(Fo,e),_(Xo),_(Uo),_(So,e),_(Vo),_(zo),_(Wo,e),_(Bo),_(Po),_(Go,e),_(Eo),_(Ro),_(Lo,e),_(qo),_(Do),_(Ho,e),_(Yo),_(Qo),_(Ao,e),_(Ko),_(Oo),_(en,e),_(tn),_(on)}}}const Gd='{"title":"Models","local":"models","sections":[{"title":"Generic model classes","local":"generic-model-classes","sections":[{"title":"NeuronTracedModel","local":"optimum.neuron.NeuronTracedModel","sections":[],"depth":3}],"depth":2},{"title":"Natural Language Processing","local":"natural-language-processing","sections":[{"title":"NeuronModelForFeatureExtraction","local":"optimum.neuron.NeuronModelForFeatureExtraction","sections":[],"depth":3},{"title":"NeuronModelForSentenceTransformers","local":"optimum.neuron.NeuronModelForSentenceTransformers","sections":[],"depth":3},{"title":"NeuronModelForMaskedLM","local":"optimum.neuron.NeuronModelForMaskedLM","sections":[],"depth":3},{"title":"NeuronModelForSequenceClassification","local":"optimum.neuron.NeuronModelForSequenceClassification","sections":[],"depth":3},{"title":"NeuronModelForQuestionAnswering","local":"optimum.neuron.NeuronModelForQuestionAnswering","sections":[],"depth":3},{"title":"NeuronModelForTokenClassification","local":"optimum.neuron.NeuronModelForTokenClassification","sections":[],"depth":3},{"title":"NeuronModelForMultipleChoice","local":"optimum.neuron.NeuronModelForMultipleChoice","sections":[],"depth":3},{"title":"NeuronModelForCausalLM","local":"optimum.neuron.NeuronModelForCausalLM","sections":[],"depth":3},{"title":"NeuronModelForSeq2SeqLM","local":"optimum.neuron.NeuronModelForSeq2SeqLM","sections":[],"depth":3}],"depth":2},{"title":"Computer Vision","local":"computer-vision","sections":[{"title":"NeuronModelForImageClassification","local":"optimum.neuron.NeuronModelForImageClassification","sections":[],"depth":3},{"title":"NeuronModelForSemanticSegmentation","local":"optimum.neuron.NeuronModelForSemanticSegmentation","sections":[],"depth":3},{"title":"NeuronModelForObjectDetection","local":"optimum.neuron.NeuronModelForObjectDetection","sections":[],"depth":3}],"depth":2},{"title":"Audio","local":"audio","sections":[{"title":"NeuronModelForAudioClassification","local":"optimum.neuron.NeuronModelForAudioClassification","sections":[],"depth":3},{"title":"NeuronModelForAudioFrameClassification","local":"optimum.neuron.NeuronModelForAudioFrameClassification","sections":[],"depth":3},{"title":"NeuronModelForCTC","local":"optimum.neuron.NeuronModelForCTC","sections":[],"depth":3},{"title":"NeuronModelForXVector","local":"optimum.neuron.NeuronModelForXVector","sections":[],"depth":3}],"depth":2},{"title":"Stable Diffusion","local":"stable-diffusion","sections":[{"title":"NeuronStableDiffusionPipeline","local":"optimum.neuron.NeuronStableDiffusionPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionImg2ImgPipeline","local":"optimum.neuron.NeuronStableDiffusionImg2ImgPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionInpaintPipeline","local":"optimum.neuron.NeuronStableDiffusionInpaintPipeline","sections":[],"depth":3},{"title":"NeuronLatentConsistencyModelPipeline","local":"optimum.neuron.NeuronLatentConsistencyModelPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionControlNetPipeline","local":"optimum.neuron.NeuronStableDiffusionControlNetPipeline","sections":[],"depth":3},{"title":"NeuronPixArtAlphaPipeline","local":"optimum.neuron.NeuronPixArtAlphaPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLPipeline","local":"optimum.neuron.NeuronStableDiffusionXLPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLImg2ImgPipeline","local":"optimum.neuron.NeuronStableDiffusionXLImg2ImgPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLInpaintPipeline","local":"optimum.neuron.NeuronStableDiffusionXLInpaintPipeline","sections":[],"depth":3},{"title":"NeuronStableDiffusionXLControlNetPipeline","local":"optimum.neuron.NeuronStableDiffusionXLControlNetPipeline","sections":[],"depth":3}],"depth":2}],"depth":1}';function Ed(j){return hd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kd extends _d{constructor(l){super(),bd(this,l,Ed,Pd,fd,{})}}export{Kd as component};
