import{s as fs,a as He,n as ys,o as ws}from"../chunks/scheduler.56725da7.js";import{S as gs,i as Ms,e as i,s as l,c as p,h as ds,a as o,d as n,b as a,f as hs,g as u,j as r,k as y,l as Ts,m as s,n as m,t as c,o as h,p as f}from"../chunks/index.18a26576.js";import{C as Js}from"../chunks/CopyLLMTxtMenu.a8c0e768.js";import{C as g}from"../chunks/CodeBlock.83339eda.js";import{H as w}from"../chunks/MermaidChart.svelte_svelte_type_style_lang.c3d650b8.js";function Cs(wn){let M,Ge,Qe,Re,d,Xe,T,Pe,J,gn="This guide will help you get Optimum Neuron up and running. There are two main approaches:",Ye,C,Mn="<li><strong>🚀 Recommended: AWS EC2 with Deep Learning AMI</strong> - The simplest way to get started with pre-configured environment</li> <li><strong>⚙️ Manual Installation</strong> - Install Optimum Neuron on existing infrastructure</li>",Fe,v,De,I,dn='The simplest way to work with AWS Trainium or Inferentia and Optimum Neuron on Amazon EC2 is the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a> (DLAMI). The DLAMI comes with all required libraries pre-packaged for you, including the Optimum Neuron, Neuron Drivers, Transformers, Datasets, and Accelerate. The HF DLAMI is provided at no additional charge to Amazon EC2 users.',qe,x,Tn='Optimum Neuron supports Inf1, Inf2, Trn1 and Trn2, all accessible on Amazon EC2. You can find all the specifications of the Trn and Inf instances <a href="https://aws.amazon.com/ec2/instance-types/" rel="nofollow">here</a>, in the “Accelerated Computing” section.',Oe,b,Jn="In this section, we will show you:",Ke,$,Cn='<li><a href="#create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami">How to create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI</a> <ol><li><a href="#find-a-supported-region">Find a supported region</a></li> <li><a href="#increase-service-quota">Increase service quota</a></li> <li><a href="#launch-the-amazon-ec2-instance-with-the-hf-dlami">Launch the Amazon EC2 instance with the HF DLAMI</a></li> <li><a href="#connect-through-ssh">Connect through SSH</a></li></ol></li> <li><a href="#set-up-your-remote-development-environment">How to set up your remote development environment</a> <ol><li><a href="#access-through-jupyter-notebook">Access through Jupyter Notebook</a></li> <li><a href="#access-through-vs-code-remote-server">Access through VS Code remote server</a></li></ol></li>',et,j,tt,U,vn="Before creating the EC2 instance, make sure you are in a supported region for the instance you selected and that you have quota in your AWS account.",nt,S,st,k,In="Here is the list of regions that support at least one type of Trainium or Inferentia2 instance, as of February 2025:",lt,A,xn="<li>us-east-1: US East (N. Virginia)</li> <li>us-east-2: US East (Ohio)</li> <li>us-west-2: US West (Oregon)</li> <li>ap-south-1: Asia Pacific (Mumbai)</li> <li>ap-northeast-1: Asia Pacific (Tokyo)</li> <li>ap-southeast-1: Asia Pacific (Singapore)</li> <li>ap-southeast-2: Asia Pacific (Sydney)</li> <li>ap-southeast-4: Asia Pacific (Melbourne)</li> <li>eu-north-1: Europe (Stockholm)</li> <li>eu-west-3: Europe (Paris)</li> <li>eu-west-2: Europe (London)</li> <li>eu-west-1: Europe (Ireland)</li> <li>eu-central-1: Europe (Frankfurt)</li> <li>sa-east-1: South America (Sao Paulo)</li>",at,L,bn="Here is a Python script that lets you pull the latest supported instance type in each region you have enabled:",it,_,ot,N,rt,W,$n="Now that you selected your region and that you switched to it, you can request a Service Quota increase through the AWS Console by navigating to Service Quota, AWS services in the left panel, search for Amazon EC2, then “trn” or “inf”. You are able to request quota increase for On-Demand and Spot instances separately.",pt,B,jn="By default, all quotas are 0 for Inferentia and Trainium. There is no charge for increased quotas. There are separate quotas for Inferentia and Trainium, and separate quotas for spot and on-demand. Quotas refer to the maximum TOTAL number of vCPUs assigned to each instance type.",ut,V,Un="For example, a quota of 192 will let you run a single inf2.48xlarge, two inf2.24xlarges, six inf2.8xlarges, or forty-eight of the inf2.xlarges. It will also let you run inf1 instance types. Similarly for Trainium, a quota of 128 will let you run a single trn1n.32xlarge or trn1.32xlarge, but it will also let you run sixteen trn1.2xlarge.",mt,Z,ct,E,Sn="Let’s deploy a trn1.2xlarge instance in the us-east-1 region (North Virginia) through the EC2 console.",ht,H,kn="First, click on <strong>Launch instance</strong> and define a name for the instance (<code>trainium-huggingface-demo</code>).",ft,Q,An,yt,z,Ln="Next, you search the Amazon Marketplace for Hugging Face AMIs. Entering “Hugging Face” in the search bar for “Application and OS Images” and hitting “enter”.",wt,G,_n,gt,R,Nn='This should now open the “Choose an Amazon Machine Image” view with the search. You can now navigate to “AWS Marketplace AMIs” and find the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a> and click select.',Mt,X,Wn,dt,P,Bn="<em>You will be asked to subscribe if you aren’t. The AMI is completely free of charge, and you will only pay for the EC2 compute.</em>",Tt,Y,Vn="Then you need to define a key pair, which will be used to connect to the instance via <code>ssh</code>. You can create one in place if you don’t have a key pair.",Jt,F,Zn,Ct,D,En='After that, create or select a <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html" rel="nofollow">security group</a> which allows <code>ssh</code> traffic.',vt,q,Hn,It,O,Qn="You are ready to launch the instance. Therefore click on “Launch Instance” on the right side.",xt,K,zn,bt,ee,Gn='AWS will now provision the instance using the <a href="https://aws.amazon.com/marketplace/pp/prodview-gr3e6yiscria2" rel="nofollow">Hugging Face Neuron Deep Learning AMI</a>.',$t,te,jt,ne,Rn="Once the instance is ready, you can view and copy the public IPv4 address to <code>ssh</code> into the machine.",Ut,se,Xn,St,le,Pn="Replace the empty strings <code>&quot;&quot;</code> in the snippet below with the IP address of your instances and the path to the key pair you created/selected when launching the instance.",kt,ae,At,ie,Yn="Once you are connected, you can run <code>neuron-ls</code> to ensure you have access to the Trainium accelerators. You should see a similar output than below.",Lt,oe,_t,re,Nt,pe,Fn="We will walk through setting up Jupyter Notebooks or VS Code remote server on the Amazon EC2 instance.",Wt,ue,Dn="These two methods require an SSH connection of some kind. These instructions were written for a Mac, but should work on a Linux system as well. A PC may require using Putty.",Bt,me,qn="You should have a .pem file that you created when you deployed your instance or had from previous deployments. You can connect to your system using:",Vt,ce,Zt,he,Et,fe,On="This method involves running the Jupyter notebook server on the Neuron instance, mapping a port locally, then using the browser on your desktop to access the notebook server.",Ht,ye,Kn="Start by mapping a port on your local machine to the Neuron instance. From a terminal on your system, run",Qt,we,zt,ge,es="Then connect to your Amazon EC2 instance using SSH from your computer. Once connected, from the command prompt, run",Gt,Me,Rt,de,ts="After a few seconds, check the nohup.out file to find your server’s token:",Xt,Te,Pt,Je,ns="Copy the connection string and paste it into your browser. After a few seconds, you should eventually see the Jupyter Notebook browser. It should look like http://localhost:8888/tree?token=337fc8de2aenot_a_real_tokene952c43946e4fb57131",Yt,Ce,ss="This process works because you have mapped the 8888 port on your local machine to the 8888 port on the Neuron instance, so when you connect to localhost:8888, you end up accessing the Jupyter server on the Neuron instance.",Ft,ve,ls="If you have problems, make sure the initial port mapping was successful. If you already have something running on port 8888 on your machine, this may give you an error. You can always change the port (e.g. 8885) in all the instructions if you need to.",Dt,Ie,qt,xe,as="With Visual Studio Code installed on your local machine, you can use the Remote-SSH command to edit and run files that are stored on a Neuron instance. See the VS Code article for additional details.",Ot,be,is="<li>Select Remote-SSH: Connect to Host… from the Command Palette (F1, ⇧⌘P)</li> <li>Enter in the full connection string from the ssh section above: ssh -i “/path/to/sshkey.pem” ubuntu@instance_ip_address</li> <li>VS Code should connect and automatically set up the VS Code server.</li> <li>Eventually, you should be prompted for a base directory. You can browse to a directory on the Neuron instance.</li> <li>In case you find that some commands seem greyed out in the menus, but the keyboard commands still work (⌘S to save or ^⇧` for terminal), you may need to restart VS Code.</li>",Kt,$e,en,je,os="Manual installation is useful in several scenarios:",tn,Ue,rs="<li><strong>Using a newer version</strong>: Install the latest Optimum Neuron version that may not yet be available in the DLAMI</li> <li><strong>Custom AMI requirements</strong>: Working with your organization’s standard AMI or security-hardened images</li> <li><strong>Existing infrastructure</strong>: Adding Neuron support to pre-configured environments or Docker containers</li> <li><strong>Development setup</strong>: Installing pre-release or development versions for testing</li> <li><strong>Minimal installations</strong>: Creating lightweight environments with only required dependencies</li>",nn,Se,ps="If you choose manual installation, you will need to ensure the Neuron drivers and tools are properly installed first.",sn,ke,us='Before installing <code>optimum-neuron</code> make sure that you have installed the Neuron driver and tools, check out <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/general/setup/torch-neuronx.html#setup-torch-neuronx" rel="nofollow">more detailed guide here</a>.',ln,Ae,an,Le,ms="Pointing to the AWS Neuron repository:",on,_e,rn,Ne,pn,We,un,Be,mn,Ve,cn,Ze,hn,Ee,cs='Now that you have Optimum Neuron set up, check out the <strong><a href="./quickstart">Quickstart Guide</a></strong> to learn the basics of training and inference with Optimum Neuron.',fn,ze,yn;return d=new Js({props:{containerStyle:"float: right; margin-left: 10px; display: inline-flex; position: relative; z-index: 10;"}}),T=new w({props:{title:"EC2 Setup",local:"ec2-setup",headingTag:"h1"}}),v=new w({props:{title:"Recommended: AWS EC2 with Deep Learning AMI",local:"recommended-aws-ec2-with-deep-learning-ami",headingTag:"h2"}}),j=new w({props:{title:"Create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI",local:"create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami",headingTag:"h3"}}),S=new w({props:{title:"Find a supported region",local:"find-a-supported-region",headingTag:"h4"}}),_=new g({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> boto3
<span class="hljs-keyword">from</span> datetime <span class="hljs-keyword">import</span> datetime

ec2 = boto3.client(<span class="hljs-string">&#x27;ec2&#x27;</span>)

regions = [region[<span class="hljs-string">&#x27;RegionName&#x27;</span>] <span class="hljs-keyword">for</span> region <span class="hljs-keyword">in</span> ec2.describe_regions()[<span class="hljs-string">&#x27;Regions&#x27;</span>]]


<span class="hljs-comment">#Edit this line to change the instance types displayed</span>
instance_types = [<span class="hljs-string">&#x27;trn1.32xlarge&#x27;</span>, <span class="hljs-string">&#x27;trn1.2xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.48xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.24xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.8xlarge&#x27;</span>, <span class="hljs-string">&#x27;inf2.xlarge&#x27;</span>, <span class="hljs-string">&#x27;trn2.48xlarge&#x27;</span>]

supported_regions = {}

<span class="hljs-keyword">for</span> region <span class="hljs-keyword">in</span> regions:
   ec2_region = boto3.client(<span class="hljs-string">&#x27;ec2&#x27;</span>, region_name=region)
   response = ec2_region.describe_instance_type_offerings(
      <span class="hljs-comment">#LocationType=&#x27;availability-zone&#x27;,</span>
      Filters=[
        {<span class="hljs-string">&#x27;Name&#x27;</span>: <span class="hljs-string">&#x27;instance-type&#x27;</span>, <span class="hljs-string">&#x27;Values&#x27;</span>: instance_types},
      ]
   )
   <span class="hljs-keyword">if</span> response[<span class="hljs-string">&#x27;InstanceTypeOfferings&#x27;</span>]:
      supported_regions[region] = [offer[<span class="hljs-string">&#x27;InstanceType&#x27;</span>] <span class="hljs-keyword">for</span> offer <span class="hljs-keyword">in</span> response[<span class="hljs-string">&#x27;InstanceTypeOfferings&#x27;</span>]]

<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;# Supported Regions as of&#x27;</span>,datetime.now().strftime(<span class="hljs-string">&#x27;%B %d, %Y&#x27;</span>))
<span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;================&#x27;</span>)


client = boto3.client(<span class="hljs-string">&#x27;ssm&#x27;</span>)

<span class="hljs-keyword">for</span> region, instance_types <span class="hljs-keyword">in</span> supported_regions.items():
    <span class="hljs-keyword">try</span>:
        response = client.get_parameter(Name=<span class="hljs-string">f&#x27;/aws/service/global-infrastructure/regions/<span class="hljs-subst">{region}</span>/longName&#x27;</span>)
        region_long_name = response[<span class="hljs-string">&#x27;Parameter&#x27;</span>][<span class="hljs-string">&#x27;Value&#x27;</span>]
    <span class="hljs-keyword">except</span> (client.exceptions.ParameterNotFound, KeyError):
        region_long_name = region
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27; * <span class="hljs-subst">{region}</span>: <span class="hljs-subst">{region_long_name}</span>&#x27;</span>)
    <span class="hljs-keyword">for</span> instance_type <span class="hljs-keyword">in</span> instance_types:
      <span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;  - <span class="hljs-subst">{instance_type}</span>&#x27;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&#x27;\\n&#x27;</span>)`,wrap:!1}}),N=new w({props:{title:"Increase service quota",local:"increase-service-quota",headingTag:"h4"}}),Z=new w({props:{title:"Launch the Amazon EC2 instance with the HF DLAMI",local:"launch-the-amazon-ec2-instance-with-the-hf-dlami",headingTag:"h4"}}),te=new w({props:{title:"Connect through SSH",local:"connect-through-ssh",headingTag:"h4"}}),ae=new g({props:{code:"UFVCTElDX0ROUyUzRCUyMiUyMiUyMCUyMyUyMElQJTIwYWRkcmVzcyUwQUtFWV9QQVRIJTNEJTIyJTIyJTIwJTIzJTIwbG9jYWwlMjBwYXRoJTIwdG8lMjBrZXklMjBwYWlyJTBBJTBBc3NoJTIwLWklMjAlMjRLRVlfUEFUSCUyMHVidW50dSU0MCUyNFBVQkxJQ19ETlM=",highlighted:`PUBLIC_DNS=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># IP address</span>
KEY_PATH=<span class="hljs-string">&quot;&quot;</span> <span class="hljs-comment"># local path to key pair</span>

ssh -i <span class="hljs-variable">$KEY_PATH</span> ubuntu@<span class="hljs-variable">$PUBLIC_DNS</span>`,wrap:!1}}),oe=new g({props:{code:"dWJ1bnR1JTQwaXAtMTcyLTMxLTc5LTE2NCUzQX4lMjQlMjBuZXVyb24tbHMlMEFpbnN0YW5jZS10eXBlJTNBJTIwdHJuMS4yeGxhcmdlJTBBaW5zdGFuY2UtaWQlM0ElMjBpLTA1NzA2MTVlNDE3MDBhNDgxJTBBJTJCLS0tLS0tLS0lMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0tJTJCJTBBJTdDJTIwTkVVUk9OJTIwJTdDJTIwTkVVUk9OJTIwJTdDJTIwTkVVUk9OJTIwJTdDJTIwJTIwJTIwUENJJTIwJTIwJTIwJTdDJTBBJTdDJTIwREVWSUNFJTIwJTdDJTIwQ09SRVMlMjAlMjAlN0MlMjBNRU1PUlklMjAlN0MlMjAlMjAlMjBCREYlMjAlMjAlMjAlN0MlMEElMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0lMkItLS0tLS0tLS0lMkIlMEElN0MlMjAwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwMiUyMCUyMCUyMCUyMCUyMCUyMCU3QyUyMDMyJTIwR0IlMjAlMjAlN0MlMjAwMCUzQTFlLjAlMjAlN0MlMEElMkItLS0tLS0tLSUyQi0tLS0tLS0tJTJCLS0tLS0tLS0lMkItLS0tLS0tLS0lMkI=",highlighted:`ubuntu@ip<span class="hljs-number">-172</span><span class="hljs-number">-31</span><span class="hljs-number">-79</span><span class="hljs-number">-164</span><span class="hljs-punctuation">:</span>~$ neuron-ls
instance-type<span class="hljs-punctuation">:</span> trn1<span class="hljs-number">.2</span>xlarge
instance-id<span class="hljs-punctuation">:</span> i<span class="hljs-number">-0570615e41700</span>a481
+--------+--------+--------+---------+
| NEURON | NEURON | NEURON |   PCI   |
| DEVICE | CORES  | MEMORY |   BDF   |
+--------+--------+--------+---------+
| <span class="hljs-number">0</span>      | <span class="hljs-number">2</span>      | <span class="hljs-number">32</span> GB  | <span class="hljs-number">00</span><span class="hljs-punctuation">:</span><span class="hljs-number">1</span>e<span class="hljs-number">.0</span> |
+--------+--------+--------+---------+`,wrap:!1}}),re=new w({props:{title:"Set up your remote development environment",local:"set-up-your-remote-development-environment",headingTag:"h3"}}),ce=new g({props:{code:"c3NoJTIwLWklMjAlMjIlMkZwYXRoJTJGdG8lMkZzc2hrZXkucGVtJTIyJTIwdWJ1bnR1JTQwaW5zdGFuY2VfaXBfYWRkcmVzcw==",highlighted:'ssh -i <span class="hljs-string">&quot;/path/to/sshkey.pem&quot;</span> ubuntu@instance_ip_address',wrap:!1}}),he=new w({props:{title:"Access through Jupyter Notebook",local:"access-through-jupyter-notebook",headingTag:"h4"}}),we=new g({props:{code:"c3NoJTIwLWklMjAlMjIlMkZwYXRoJTJGdG8lMkZzc2hrZXkucGVtJTIyJTIwLU4lMjAtZiUyMC1MJTIwbG9jYWxob3N0JTNBODg4OCUzQWxvY2FsaG9zdCUzQTg4ODglMjB1YnVudHUlNDBpbnN0YW5jZV9pcF9hZGRyZXNz",highlighted:'ssh -i <span class="hljs-string">&quot;/path/to/sshkey.pem&quot;</span> -N -f -L localhost:8888:localhost:8888 ubuntu@instance_ip_address',wrap:!1}}),Me=new g({props:{code:"bm9odXAlMjBqdXB5dGVyJTIwbm90ZWJvb2slMjAtLW5vLWJyb3dzZXIlMjAtLXBvcnQlM0Q4ODg4",highlighted:'<span class="hljs-built_in">nohup</span> jupyter notebook --no-browser --port=8888',wrap:!1}}),Te=new g({props:{code:"Y2F0JTIwbm9odXAub3V0JTIwJTdDJTIwZ3JlcCUyMGxvY2FsaG9zdA==",highlighted:'<span class="hljs-built_in">cat</span> nohup.out | grep localhost',wrap:!1}}),Ie=new w({props:{title:"Access through VS Code remote server",local:"access-through-vs-code-remote-server",headingTag:"h4"}}),$e=new w({props:{title:"Alternative: Manual Installation",local:"alternative-manual-installation",headingTag:"h2"}}),Ae=new w({props:{title:"Adding pip packages URL",local:"adding-pip-packages-url",headingTag:"h3"}}),_e=new g({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBjb25maWclMjBzZXQlMjBnbG9iYWwuZXh0cmEtaW5kZXgtdXJsJTIwaHR0cHMlM0ElMkYlMkZwaXAucmVwb3MubmV1cm9uLmFtYXpvbmF3cy5jb20=",highlighted:'python -m pip config <span class="hljs-built_in">set</span> global.extra-index-url https://pip.repos.neuron.amazonaws.com',wrap:!1}}),Ne=new w({props:{title:"Installing optimum-neuron for AWS Trainium ( trn1 ) or AWS inferentia2 ( inf2 )",local:"installing-optimum-neuron-for-aws-trainium--trn1--or-aws-inferentia2--inf2-",headingTag:"h3"}}),We=new g({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwb3B0aW11bS1uZXVyb24lNUJuZXVyb254JTVE",highlighted:"python -m pip install optimum-neuron[neuronx]",wrap:!1}}),Be=new w({props:{title:"Installing optimum-neuron for AWS inferentia ( inf1 )",local:"installing-optimum-neuron-for-aws-inferentia--inf1-",headingTag:"h3"}}),Ve=new g({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwb3B0aW11bS1uZXVyb24lNUJuZXVyb24lNUQ=",highlighted:"python -m pip install optimum-neuron[neuron]",wrap:!1}}),Ze=new w({props:{title:"What’s Next?",local:"whats-next",headingTag:"h2"}}),{c(){M=i("meta"),Ge=l(),Qe=i("p"),Re=l(),p(d.$$.fragment),Xe=l(),p(T.$$.fragment),Pe=l(),J=i("p"),J.textContent=gn,Ye=l(),C=i("ol"),C.innerHTML=Mn,Fe=l(),p(v.$$.fragment),De=l(),I=i("p"),I.innerHTML=dn,qe=l(),x=i("p"),x.innerHTML=Tn,Oe=l(),b=i("p"),b.textContent=Jn,Ke=l(),$=i("ol"),$.innerHTML=Cn,et=l(),p(j.$$.fragment),tt=l(),U=i("p"),U.textContent=vn,nt=l(),p(S.$$.fragment),st=l(),k=i("p"),k.textContent=In,lt=l(),A=i("ul"),A.innerHTML=xn,at=l(),L=i("p"),L.textContent=bn,it=l(),p(_.$$.fragment),ot=l(),p(N.$$.fragment),rt=l(),W=i("p"),W.textContent=$n,pt=l(),B=i("p"),B.textContent=jn,ut=l(),V=i("p"),V.textContent=Un,mt=l(),p(Z.$$.fragment),ct=l(),E=i("p"),E.textContent=Sn,ht=l(),H=i("p"),H.innerHTML=kn,ft=l(),Q=i("img"),yt=l(),z=i("p"),z.textContent=Ln,wt=l(),G=i("img"),gt=l(),R=i("p"),R.innerHTML=Nn,Mt=l(),X=i("img"),dt=l(),P=i("p"),P.innerHTML=Bn,Tt=l(),Y=i("p"),Y.innerHTML=Vn,Jt=l(),F=i("img"),Ct=l(),D=i("p"),D.innerHTML=En,vt=l(),q=i("img"),It=l(),O=i("p"),O.textContent=Qn,xt=l(),K=i("img"),bt=l(),ee=i("p"),ee.innerHTML=Gn,$t=l(),p(te.$$.fragment),jt=l(),ne=i("p"),ne.innerHTML=Rn,Ut=l(),se=i("img"),St=l(),le=i("p"),le.innerHTML=Pn,kt=l(),p(ae.$$.fragment),At=l(),ie=i("p"),ie.innerHTML=Yn,Lt=l(),p(oe.$$.fragment),_t=l(),p(re.$$.fragment),Nt=l(),pe=i("p"),pe.textContent=Fn,Wt=l(),ue=i("p"),ue.textContent=Dn,Bt=l(),me=i("p"),me.textContent=qn,Vt=l(),p(ce.$$.fragment),Zt=l(),p(he.$$.fragment),Et=l(),fe=i("p"),fe.textContent=On,Ht=l(),ye=i("p"),ye.textContent=Kn,Qt=l(),p(we.$$.fragment),zt=l(),ge=i("p"),ge.textContent=es,Gt=l(),p(Me.$$.fragment),Rt=l(),de=i("p"),de.textContent=ts,Xt=l(),p(Te.$$.fragment),Pt=l(),Je=i("p"),Je.textContent=ns,Yt=l(),Ce=i("p"),Ce.textContent=ss,Ft=l(),ve=i("p"),ve.textContent=ls,Dt=l(),p(Ie.$$.fragment),qt=l(),xe=i("p"),xe.textContent=as,Ot=l(),be=i("ol"),be.innerHTML=is,Kt=l(),p($e.$$.fragment),en=l(),je=i("p"),je.textContent=os,tn=l(),Ue=i("ul"),Ue.innerHTML=rs,nn=l(),Se=i("p"),Se.textContent=ps,sn=l(),ke=i("p"),ke.innerHTML=us,ln=l(),p(Ae.$$.fragment),an=l(),Le=i("p"),Le.textContent=ms,on=l(),p(_e.$$.fragment),rn=l(),p(Ne.$$.fragment),pn=l(),p(We.$$.fragment),un=l(),p(Be.$$.fragment),mn=l(),p(Ve.$$.fragment),cn=l(),p(Ze.$$.fragment),hn=l(),Ee=i("p"),Ee.innerHTML=cs,fn=l(),ze=i("p"),this.h()},l(e){const t=ds("svelte-u9bgzb",document.head);M=o(t,"META",{name:!0,content:!0}),t.forEach(n),Ge=a(e),Qe=o(e,"P",{}),hs(Qe).forEach(n),Re=a(e),u(d.$$.fragment,e),Xe=a(e),u(T.$$.fragment,e),Pe=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-ppiuvg"&&(J.textContent=gn),Ye=a(e),C=o(e,"OL",{"data-svelte-h":!0}),r(C)!=="svelte-bfl7te"&&(C.innerHTML=Mn),Fe=a(e),u(v.$$.fragment,e),De=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1gnzyei"&&(I.innerHTML=dn),qe=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1g253ra"&&(x.innerHTML=Tn),Oe=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-zcjb5i"&&(b.textContent=Jn),Ke=a(e),$=o(e,"OL",{"data-svelte-h":!0}),r($)!=="svelte-myip9t"&&($.innerHTML=Cn),et=a(e),u(j.$$.fragment,e),tt=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1y0w0e0"&&(U.textContent=vn),nt=a(e),u(S.$$.fragment,e),st=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-19mf0fu"&&(k.textContent=In),lt=a(e),A=o(e,"UL",{"data-svelte-h":!0}),r(A)!=="svelte-1ur9ox2"&&(A.innerHTML=xn),at=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-cd8ooq"&&(L.textContent=bn),it=a(e),u(_.$$.fragment,e),ot=a(e),u(N.$$.fragment,e),rt=a(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-mu91xn"&&(W.textContent=$n),pt=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1oqd42e"&&(B.textContent=jn),ut=a(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-tmf6ga"&&(V.textContent=Un),mt=a(e),u(Z.$$.fragment,e),ct=a(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-r3bcy6"&&(E.textContent=Sn),ht=a(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-50wzvt"&&(H.innerHTML=kn),ft=a(e),Q=o(e,"IMG",{src:!0,alt:!0}),yt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-7wwfcf"&&(z.textContent=Ln),wt=a(e),G=o(e,"IMG",{src:!0,alt:!0}),gt=a(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-cgjl8t"&&(R.innerHTML=Nn),Mt=a(e),X=o(e,"IMG",{src:!0,alt:!0}),dt=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-11azj2p"&&(P.innerHTML=Bn),Tt=a(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1j7ptbp"&&(Y.innerHTML=Vn),Jt=a(e),F=o(e,"IMG",{src:!0,alt:!0}),Ct=a(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-jwe09q"&&(D.innerHTML=En),vt=a(e),q=o(e,"IMG",{src:!0,alt:!0}),It=a(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1hnrw8h"&&(O.textContent=Qn),xt=a(e),K=o(e,"IMG",{src:!0,alt:!0}),bt=a(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-yyg7kn"&&(ee.innerHTML=Gn),$t=a(e),u(te.$$.fragment,e),jt=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-dpbyx7"&&(ne.innerHTML=Rn),Ut=a(e),se=o(e,"IMG",{src:!0,alt:!0}),St=a(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-pmoe5"&&(le.innerHTML=Pn),kt=a(e),u(ae.$$.fragment,e),At=a(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1jd2fkg"&&(ie.innerHTML=Yn),Lt=a(e),u(oe.$$.fragment,e),_t=a(e),u(re.$$.fragment,e),Nt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-va0ciz"&&(pe.textContent=Fn),Wt=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-20tg3z"&&(ue.textContent=Dn),Bt=a(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-14ylm5t"&&(me.textContent=qn),Vt=a(e),u(ce.$$.fragment,e),Zt=a(e),u(he.$$.fragment,e),Et=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-16s9nvc"&&(fe.textContent=On),Ht=a(e),ye=o(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-kl6qgs"&&(ye.textContent=Kn),Qt=a(e),u(we.$$.fragment,e),zt=a(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-l0sx97"&&(ge.textContent=es),Gt=a(e),u(Me.$$.fragment,e),Rt=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1fn6l5y"&&(de.textContent=ts),Xt=a(e),u(Te.$$.fragment,e),Pt=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-ou1jyu"&&(Je.textContent=ns),Yt=a(e),Ce=o(e,"P",{"data-svelte-h":!0}),r(Ce)!=="svelte-1965vx"&&(Ce.textContent=ss),Ft=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-165fa3p"&&(ve.textContent=ls),Dt=a(e),u(Ie.$$.fragment,e),qt=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-bzwe4m"&&(xe.textContent=as),Ot=a(e),be=o(e,"OL",{"data-svelte-h":!0}),r(be)!=="svelte-c41b6w"&&(be.innerHTML=is),Kt=a(e),u($e.$$.fragment,e),en=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1qjg0mm"&&(je.textContent=os),tn=a(e),Ue=o(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-204tif"&&(Ue.innerHTML=rs),nn=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-134n78l"&&(Se.textContent=ps),sn=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-1xl7fn1"&&(ke.innerHTML=us),ln=a(e),u(Ae.$$.fragment,e),an=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1fuys5u"&&(Le.textContent=ms),on=a(e),u(_e.$$.fragment,e),rn=a(e),u(Ne.$$.fragment,e),pn=a(e),u(We.$$.fragment,e),un=a(e),u(Be.$$.fragment,e),mn=a(e),u(Ve.$$.fragment,e),cn=a(e),u(Ze.$$.fragment,e),hn=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-1yywgqb"&&(Ee.innerHTML=cs),fn=a(e),ze=o(e,"P",{}),hs(ze).forEach(n),this.h()},h(){y(M,"name","hf:doc:metadata"),y(M,"content",vs),He(Q.src,An="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/01-name-instance.png")||y(Q,"src",An),y(Q,"alt","name instance"),He(G.src,_n="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/02-search-ami.png")||y(G,"src",_n),y(G,"alt","search ami"),He(X.src,Wn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/03-select-ami.png")||y(X,"src",Wn),y(X,"alt","select ami"),He(F.src,Zn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/04-select-key.png")||y(F,"src",Zn),y(F,"alt","select ssh key"),He(q.src,Hn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/05-select-sg.png")||y(q,"src",Hn),y(q,"alt","select security group"),He(K.src,zn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/06-launch-instance.png")||y(K,"src",zn),y(K,"alt","select ssh key"),He(se.src,Xn="https://raw.githubusercontent.com/huggingface/optimum-neuron/main/docs/assets/guides/setup_aws_instance/07-copy-dns.png")||y(se,"src",Xn),y(se,"alt","select public dns")},m(e,t){Ts(document.head,M),s(e,Ge,t),s(e,Qe,t),s(e,Re,t),m(d,e,t),s(e,Xe,t),m(T,e,t),s(e,Pe,t),s(e,J,t),s(e,Ye,t),s(e,C,t),s(e,Fe,t),m(v,e,t),s(e,De,t),s(e,I,t),s(e,qe,t),s(e,x,t),s(e,Oe,t),s(e,b,t),s(e,Ke,t),s(e,$,t),s(e,et,t),m(j,e,t),s(e,tt,t),s(e,U,t),s(e,nt,t),m(S,e,t),s(e,st,t),s(e,k,t),s(e,lt,t),s(e,A,t),s(e,at,t),s(e,L,t),s(e,it,t),m(_,e,t),s(e,ot,t),m(N,e,t),s(e,rt,t),s(e,W,t),s(e,pt,t),s(e,B,t),s(e,ut,t),s(e,V,t),s(e,mt,t),m(Z,e,t),s(e,ct,t),s(e,E,t),s(e,ht,t),s(e,H,t),s(e,ft,t),s(e,Q,t),s(e,yt,t),s(e,z,t),s(e,wt,t),s(e,G,t),s(e,gt,t),s(e,R,t),s(e,Mt,t),s(e,X,t),s(e,dt,t),s(e,P,t),s(e,Tt,t),s(e,Y,t),s(e,Jt,t),s(e,F,t),s(e,Ct,t),s(e,D,t),s(e,vt,t),s(e,q,t),s(e,It,t),s(e,O,t),s(e,xt,t),s(e,K,t),s(e,bt,t),s(e,ee,t),s(e,$t,t),m(te,e,t),s(e,jt,t),s(e,ne,t),s(e,Ut,t),s(e,se,t),s(e,St,t),s(e,le,t),s(e,kt,t),m(ae,e,t),s(e,At,t),s(e,ie,t),s(e,Lt,t),m(oe,e,t),s(e,_t,t),m(re,e,t),s(e,Nt,t),s(e,pe,t),s(e,Wt,t),s(e,ue,t),s(e,Bt,t),s(e,me,t),s(e,Vt,t),m(ce,e,t),s(e,Zt,t),m(he,e,t),s(e,Et,t),s(e,fe,t),s(e,Ht,t),s(e,ye,t),s(e,Qt,t),m(we,e,t),s(e,zt,t),s(e,ge,t),s(e,Gt,t),m(Me,e,t),s(e,Rt,t),s(e,de,t),s(e,Xt,t),m(Te,e,t),s(e,Pt,t),s(e,Je,t),s(e,Yt,t),s(e,Ce,t),s(e,Ft,t),s(e,ve,t),s(e,Dt,t),m(Ie,e,t),s(e,qt,t),s(e,xe,t),s(e,Ot,t),s(e,be,t),s(e,Kt,t),m($e,e,t),s(e,en,t),s(e,je,t),s(e,tn,t),s(e,Ue,t),s(e,nn,t),s(e,Se,t),s(e,sn,t),s(e,ke,t),s(e,ln,t),m(Ae,e,t),s(e,an,t),s(e,Le,t),s(e,on,t),m(_e,e,t),s(e,rn,t),m(Ne,e,t),s(e,pn,t),m(We,e,t),s(e,un,t),m(Be,e,t),s(e,mn,t),m(Ve,e,t),s(e,cn,t),m(Ze,e,t),s(e,hn,t),s(e,Ee,t),s(e,fn,t),s(e,ze,t),yn=!0},p:ys,i(e){yn||(c(d.$$.fragment,e),c(T.$$.fragment,e),c(v.$$.fragment,e),c(j.$$.fragment,e),c(S.$$.fragment,e),c(_.$$.fragment,e),c(N.$$.fragment,e),c(Z.$$.fragment,e),c(te.$$.fragment,e),c(ae.$$.fragment,e),c(oe.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(he.$$.fragment,e),c(we.$$.fragment,e),c(Me.$$.fragment,e),c(Te.$$.fragment,e),c(Ie.$$.fragment,e),c($e.$$.fragment,e),c(Ae.$$.fragment,e),c(_e.$$.fragment,e),c(Ne.$$.fragment,e),c(We.$$.fragment,e),c(Be.$$.fragment,e),c(Ve.$$.fragment,e),c(Ze.$$.fragment,e),yn=!0)},o(e){h(d.$$.fragment,e),h(T.$$.fragment,e),h(v.$$.fragment,e),h(j.$$.fragment,e),h(S.$$.fragment,e),h(_.$$.fragment,e),h(N.$$.fragment,e),h(Z.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(oe.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(he.$$.fragment,e),h(we.$$.fragment,e),h(Me.$$.fragment,e),h(Te.$$.fragment,e),h(Ie.$$.fragment,e),h($e.$$.fragment,e),h(Ae.$$.fragment,e),h(_e.$$.fragment,e),h(Ne.$$.fragment,e),h(We.$$.fragment,e),h(Be.$$.fragment,e),h(Ve.$$.fragment,e),h(Ze.$$.fragment,e),yn=!1},d(e){e&&(n(Ge),n(Qe),n(Re),n(Xe),n(Pe),n(J),n(Ye),n(C),n(Fe),n(De),n(I),n(qe),n(x),n(Oe),n(b),n(Ke),n($),n(et),n(tt),n(U),n(nt),n(st),n(k),n(lt),n(A),n(at),n(L),n(it),n(ot),n(rt),n(W),n(pt),n(B),n(ut),n(V),n(mt),n(ct),n(E),n(ht),n(H),n(ft),n(Q),n(yt),n(z),n(wt),n(G),n(gt),n(R),n(Mt),n(X),n(dt),n(P),n(Tt),n(Y),n(Jt),n(F),n(Ct),n(D),n(vt),n(q),n(It),n(O),n(xt),n(K),n(bt),n(ee),n($t),n(jt),n(ne),n(Ut),n(se),n(St),n(le),n(kt),n(At),n(ie),n(Lt),n(_t),n(Nt),n(pe),n(Wt),n(ue),n(Bt),n(me),n(Vt),n(Zt),n(Et),n(fe),n(Ht),n(ye),n(Qt),n(zt),n(ge),n(Gt),n(Rt),n(de),n(Xt),n(Pt),n(Je),n(Yt),n(Ce),n(Ft),n(ve),n(Dt),n(qt),n(xe),n(Ot),n(be),n(Kt),n(en),n(je),n(tn),n(Ue),n(nn),n(Se),n(sn),n(ke),n(ln),n(an),n(Le),n(on),n(rn),n(pn),n(un),n(mn),n(cn),n(hn),n(Ee),n(fn),n(ze)),n(M),f(d,e),f(T,e),f(v,e),f(j,e),f(S,e),f(_,e),f(N,e),f(Z,e),f(te,e),f(ae,e),f(oe,e),f(re,e),f(ce,e),f(he,e),f(we,e),f(Me,e),f(Te,e),f(Ie,e),f($e,e),f(Ae,e),f(_e,e),f(Ne,e),f(We,e),f(Be,e),f(Ve,e),f(Ze,e)}}}const vs='{"title":"EC2 Setup","local":"ec2-setup","sections":[{"title":"Recommended: AWS EC2 with Deep Learning AMI","local":"recommended-aws-ec2-with-deep-learning-ami","sections":[{"title":"Create an AWS Trainium or Inferentia instance on Amazon EC2 with the HF DLAMI","local":"create-an-aws-trainium-or-inferentia-instance-on-amazon-ec2-with-the-hf-dlami","sections":[{"title":"Find a supported region","local":"find-a-supported-region","sections":[],"depth":4},{"title":"Increase service quota","local":"increase-service-quota","sections":[],"depth":4},{"title":"Launch the Amazon EC2 instance with the HF DLAMI","local":"launch-the-amazon-ec2-instance-with-the-hf-dlami","sections":[],"depth":4},{"title":"Connect through SSH","local":"connect-through-ssh","sections":[],"depth":4}],"depth":3},{"title":"Set up your remote development environment","local":"set-up-your-remote-development-environment","sections":[{"title":"Access through Jupyter Notebook","local":"access-through-jupyter-notebook","sections":[],"depth":4},{"title":"Access through VS Code remote server","local":"access-through-vs-code-remote-server","sections":[],"depth":4}],"depth":3}],"depth":2},{"title":"Alternative: Manual Installation","local":"alternative-manual-installation","sections":[{"title":"Adding pip packages URL","local":"adding-pip-packages-url","sections":[],"depth":3},{"title":"Installing optimum-neuron for AWS Trainium ( trn1 ) or AWS inferentia2 ( inf2 )","local":"installing-optimum-neuron-for-aws-trainium--trn1--or-aws-inferentia2--inf2-","sections":[],"depth":3},{"title":"Installing optimum-neuron for AWS inferentia ( inf1 )","local":"installing-optimum-neuron-for-aws-inferentia--inf1-","sections":[],"depth":3}],"depth":2},{"title":"What’s Next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function Is(wn){return ws(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ss extends gs{constructor(M){super(),Ms(this,M,Is,Cs,fs,{})}}export{Ss as component};
