import{s as lM,n as sM,o as tM}from"../chunks/scheduler.362310b7.js";import{S as MM,i as aM,g as e,s as a,r as y,m as Yl,A as nM,h as j,f as t,c as n,j as I,u as T,x as J,n as Vl,k as Kt,y as o,a as M,v as p,d as i,t as U,w as u}from"../chunks/index.57dfc70d.js";import{C as A}from"../chunks/CodeBlock.5d40996c.js";import{H as c,E as eM}from"../chunks/getInferenceSnippets.9a9f9361.js";function jM(ht){let r,Hl,Rl,Fl,d,Dl,q,Ct='Text Generation Inference (TGI) now supports <a href="#grammar-and-constraints">JSON and regex grammars</a> and <a href="#tools-and-functions">tools and functions</a> to help developers guide LLM responses to fit their needs.',Ll,g,mt='These feature are available starting from version <code>1.4.3</code>. They are accessible via the <a href="https://pypi.org/project/huggingface-hub/" rel="nofollow"><code>huggingface_hub</code></a> library. The tool support is compatible with OpenAI’s client libraries. The following guide will walk you through the new features and how to use them!',Pl,b,dt="<em>note: guidance is supported as grammar in the <code>/generate</code> endpoint and as tools in the <code>v1/chat/completions</code> endpoint.</em>",Ol,f,Kl,E,qt='TGI leverages the <a href="https://github.com/outlines-dev/outlines" rel="nofollow">outlines</a> library to efficiently parse and compile the grammatical structures and tools specified by users. This integration transforms the defined grammars into an intermediate representation that acts as a framework to guide and constrain content generation, ensuring that outputs adhere to the specified grammatical rules.',ls,B,gt='If you are interested in the technical details on how outlines is used in TGI, you can check out the <a href="../conceptual/guidance">conceptual guidance documentation</a>.',ss,Q,ts,N,Ms,Z,bt='<li><a href="#the-grammar-parameter">The Grammar Parameter</a>: Shape your AI’s responses with precision.</li> <li><a href="#constrain-with-pydantic">Constrain with Pydantic</a>: Define a grammar using Pydantic models.</li> <li><a href="#json-schema-integration">JSON Schema Integration</a>: Fine-grained control over your requests via JSON schema.</li> <li><a href="#using-the-client">Using the client</a>: Use TGI’s client libraries to shape the AI’s responses.</li>',as,G,ns,W,ft='<li><a href="#the-tools-parameter">The Tools Parameter</a>: Enhance the AI’s capabilities with predefined functions.</li> <li><a href="#text-generation-inference-client">Via the client</a>: Use TGI’s client libraries to interact with the Messages API and Tool functions.</li> <li><a href="#openai-integration">OpenAI integration</a>: Use OpenAI’s client libraries to interact with TGI’s Messages API and Tool functions.</li>',es,S,js,v,os,$,Et="In TGI <code>1.4.3</code>, we’ve introduced the grammar parameter, which allows you to specify the format of the response you want from the LLM.",Js,k,Bt='Using curl, you can make a request to TGI’s Messages API with the grammar parameter. This is the most primitive way to interact with the API and using <a href="#constrain-with-pydantic">Pydantic</a> is recommended for ease of use and readability.',ys,x,Ts,z,ps,X,Qt="The Hugging Face Hub Python library provides a client that makes it easy to interact with the Messages API. Here’s an example of how to use the client to send a request with a grammar parameter.",is,Y,Us,V,Nt="A grammar can be defined using Pydantic models, JSON schemas, or regular expressions. The LLM will then generate a response that conforms to the specified grammar.",us,R,Zt="<p>Note: A grammar must compile to an intermediate representation to constrain the output. Grammar compilation is a computationally expensive and may take a few seconds to complete on the first request. Subsequent requests will use the cached grammar and will be much faster.</p>",Is,_,cs,H,Gt="Using Pydantic models we can define a similar grammar as the previous example in a shorter and more readable way.",ws,F,As,D,Wt="defining a grammar as regular expressions",rs,L,hs,P,Cs,O,ms,K,St="In addition to the grammar parameter, we’ve also introduced a set of tools and functions to help you get the most out of the Messages API.",ds,ll,vt="Tools are a set of user defined functions that can be used in tandem with the chat functionality to enhance the LLM’s capabilities. Functions, similar to grammar are defined as JSON schema and can be passed as part of the parameters to the Messages API.",qs,sl,gs,tl,bs,Ml,$t="Grammars are supported in the <code>/generate</code> endpoint, while tools are supported in the <code>/chat/completions</code> endpoint. Here’s an example of how to use the client to send a request with a tool parameter.",fs,al,Es,nl,Bs,el,kt="TGI exposes an OpenAI-compatible API, which means you can use OpenAI’s client libraries to interact with TGI’s Messages API and Tool functions.",Qs,jl,Ns,ol,Zs,Jl,xt="When configuring how the model interacts with tools during a chat completion, there are several options for determining if or how a tool should be called. These options are controlled by the <code>tool_choice</code> parameter, which specifies the behavior of the model in relation to tool usage. The following modes are supported:",Gs,w,yl,ql,zt="<strong><code>auto</code></strong>:",Ds,h,gl,Xt="The model decides whether to call a tool or generate a response message based on the user’s input.",Ls,bl,Yt="If tools are provided, this is the default mode.",Ps,fl,Os,Tl,Ks,pl,El,Vt="<strong><code>none</code></strong>:",lt,C,Bl,Rt="The model will never call any tools and will only generate a response message.",st,Ql,_t="If no tools are provided, this is the default mode.",tt,Nl,Mt,il,at,Ul,Zl,Ht="<strong><code>required</code></strong>:",nt,ul,Gl,Ft="The model must call one or more tools and will not generate a response message on its own.",et,Wl,jt,Il,ot,cl,Sl,Dt="<strong>Specific Tool Call by Function Name</strong>:",Jt,wl,vl,Lt="You can force the model to call a specific tool either by specifying the tool function directly or by using an object definition.",yt,$l,Tt,Al,kl,pt,rl,it,xl,Ut,hl,Ws,Cl,Pt="These options allow flexibility when integrating tools with the chat completions endpoint. You can configure the model to either rely on tools automatically or force it to follow a predefined behavior, based on the needs of the task at hand.",Ss,vs,$s,ml,Ot="<thead><tr><th><strong>Tool Choice Option</strong></th> <th><strong>Description</strong></th> <th><strong>When to Use</strong></th></tr></thead> <tbody><tr><td><code>auto</code></td> <td>The model decides whether to call a tool or generate a message. This is the default if tools are provided.</td> <td>Use when you want the model to decide when a tool is necessary.</td></tr> <tr><td><code>none</code></td> <td>The model generates a message without calling any tools. This is the default if no tools are provided.</td> <td>Use when you do not want the model to call any tools.</td></tr> <tr><td><code>required</code></td> <td>The model must call one or more tools and will not generate a message on its own.</td> <td>Use when a tool call is mandatory, and you do not want a regular message generated.</td></tr> <tr><td>Specific Tool Call (<code>name</code> or object)</td> <td>Force the model to call a specific tool either by specifying its name (<code>tool_choice=&quot;get_current_weather&quot;</code>) or using an object.</td> <td>Use when you want to restrict the model to calling a particular tool for the response.</td></tr></tbody>",ks,dl,xs,_l,zs;return d=new c({props:{title:"Guidance",local:"guidance",headingTag:"h1"}}),f=new c({props:{title:"How it works",local:"how-it-works",headingTag:"h2"}}),Q=new c({props:{title:"Table of Contents 📚",local:"table-of-contents-",headingTag:"h2"}}),N=new c({props:{title:"Grammar and Constraints",local:"grammar-and-constraints",headingTag:"h3"}}),G=new c({props:{title:"Tools and Functions",local:"tools-and-functions",headingTag:"h3"}}),S=new c({props:{title:"Grammar and Constraints 🛣️",local:"grammar-and-constraints-",headingTag:"h2"}}),v=new c({props:{title:"The Grammar Parameter",local:"the-grammar-parameter",headingTag:"h3"}}),x=new A({props:{code:"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",highlighted:`curl localhost<span class="hljs-punctuation">:</span><span class="hljs-number">3000</span>/generate \\
    -X POST \\
    -H &#x27;Content-Type<span class="hljs-punctuation">:</span> application/json&#x27; \\
    -d &#x27;<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;repetition_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;json&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;value&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                    <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;activity&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;animals_seen&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;integer&quot;</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;minimum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;maximum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;animals&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;array&quot;</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;items&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                        <span class="hljs-punctuation">}</span>
                    <span class="hljs-punctuation">}</span>
                <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;location&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;activity&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;animals_seen&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;animals&quot;</span><span class="hljs-punctuation">]</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>&#x27;
<span class="hljs-comment">// {&quot;generated_text&quot;:&quot;{ \\n\\n\\&quot;activity\\&quot;: \\&quot;biking\\&quot;,\\n\\&quot;animals\\&quot;: [\\&quot;puppy\\&quot;,\\&quot;cat\\&quot;,\\&quot;raccoon\\&quot;],\\n\\&quot;animals_seen\\&quot;: 3,\\n\\&quot;location\\&quot;: \\&quot;park\\&quot;\\n}&quot;}</span>
`,wrap:!1}}),z=new c({props:{title:"Hugging Face Hub Python Library",local:"hugging-face-hub-python-library",headingTag:"h3"}}),Y=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

schema = {
    <span class="hljs-string">&quot;properties&quot;</span>: {
        <span class="hljs-string">&quot;location&quot;</span>: {<span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Location&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
        <span class="hljs-string">&quot;activity&quot;</span>: {<span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Activity&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>},
        <span class="hljs-string">&quot;animals_seen&quot;</span>: {
            <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>,
            <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>,
            <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Animals Seen&quot;</span>,
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
        },
        <span class="hljs-string">&quot;animals&quot;</span>: {<span class="hljs-string">&quot;items&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>}, <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Animals&quot;</span>, <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>},
    },
    <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>],
    <span class="hljs-string">&quot;title&quot;</span>: <span class="hljs-string">&quot;Animals&quot;</span>,
    <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
}

user_input = <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>
resp = client.text_generation(
    <span class="hljs-string">f&quot;convert to JSON: &#x27;f<span class="hljs-subst">{user_input}</span>&#x27;. please use the following schema: <span class="hljs-subst">{schema}</span>&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
    seed=<span class="hljs-number">42</span>,
    grammar={<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: schema},
)

<span class="hljs-built_in">print</span>(resp)
<span class="hljs-comment"># { &quot;activity&quot;: &quot;bike ride&quot;, &quot;animals&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;], &quot;animals_seen&quot;: 3, &quot;location&quot;: &quot;park&quot; }</span>
`,wrap:!1}}),_=new c({props:{title:"Constrain with Pydantic",local:"constrain-with-pydantic",headingTag:"h3"}}),F=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWZyb20lMjBweWRhbnRpYyUyMGltcG9ydCUyMEJhc2VNb2RlbCUyQyUyMGNvbmludCUwQWZyb20lMjB0eXBpbmclMjBpbXBvcnQlMjBMaXN0JTBBJTBBJTBBY2xhc3MlMjBBbmltYWxzKEJhc2VNb2RlbCklM0ElMEElMjAlMjAlMjAlMjBsb2NhdGlvbiUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMGFjdGl2aXR5JTNBJTIwc3RyJTBBJTIwJTIwJTIwJTIwYW5pbWFsc19zZWVuJTNBJTIwY29uaW50KGdlJTNEMSUyQyUyMGxlJTNENSklMjAlMjAlMjMlMjBDb25zdHJhaW5lZCUyMGludGVnZXIlMjB0eXBlJTBBJTIwJTIwJTIwJTIwYW5pbWFscyUzQSUyMExpc3QlNUJzdHIlNUQlMEElMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTMwMDAlMjIpJTBBJTBBdXNlcl9pbnB1dCUyMCUzRCUyMCUyMkklMjBzYXclMjBhJTIwcHVwcHklMjBhJTIwY2F0JTIwYW5kJTIwYSUyMHJhY2Nvb24lMjBkdXJpbmclMjBteSUyMGJpa2UlMjByaWRlJTIwaW4lMjB0aGUlMjBwYXJrJTIyJTBBcmVzcCUyMCUzRCUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24oJTBBJTIwJTIwJTIwJTIwZiUyMmNvbnZlcnQlMjB0byUyMEpTT04lM0ElMjAnZiU3QnVzZXJfaW5wdXQlN0QnLiUyMHBsZWFzZSUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHNjaGVtYSUzQSUyMCU3QkFuaW1hbHMubW9kZWxfanNvbl9zY2hlbWEoKSU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1heF9uZXdfdG9rZW5zJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwc2VlZCUzRDQyJTJDJTBBJTIwJTIwJTIwJTIwZ3JhbW1hciUzRCU3QiUyMnR5cGUlMjIlM0ElMjAlMjJqc29uJTIyJTJDJTIwJTIydmFsdWUlMjIlM0ElMjBBbmltYWxzLm1vZGVsX2pzb25fc2NoZW1hKCklN0QlMkMlMEEpJTBBJTBBcHJpbnQocmVzcCklMEElMjMlMjAlN0IlMjAlMjJhY3Rpdml0eSUyMiUzQSUyMCUyMmJpa2UlMjByaWRlJTIyJTJDJTIwJTIyYW5pbWFscyUyMiUzQSUyMCU1QiUyMnB1cHB5JTIyJTJDJTIwJTIyY2F0JTIyJTJDJTIwJTIycmFjY29vbiUyMiU1RCUyQyUyMCUyMmFuaW1hbHNfc2VlbiUyMiUzQSUyMDMlMkMlMjAlMjJsb2NhdGlvbiUyMiUzQSUyMCUyMnBhcmslMjIlMjAlN0QlMEElMEE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel, conint
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>


<span class="hljs-keyword">class</span> <span class="hljs-title class_">Animals</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    location: <span class="hljs-built_in">str</span>
    activity: <span class="hljs-built_in">str</span>
    animals_seen: conint(ge=<span class="hljs-number">1</span>, le=<span class="hljs-number">5</span>)  <span class="hljs-comment"># Constrained integer type</span>
    animals: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]


client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

user_input = <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>
resp = client.text_generation(
    <span class="hljs-string">f&quot;convert to JSON: &#x27;f<span class="hljs-subst">{user_input}</span>&#x27;. please use the following schema: <span class="hljs-subst">{Animals.model_json_schema()}</span>&quot;</span>,
    max_new_tokens=<span class="hljs-number">100</span>,
    seed=<span class="hljs-number">42</span>,
    grammar={<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>, <span class="hljs-string">&quot;value&quot;</span>: Animals.model_json_schema()},
)

<span class="hljs-built_in">print</span>(resp)
<span class="hljs-comment"># { &quot;activity&quot;: &quot;bike ride&quot;, &quot;animals&quot;: [&quot;puppy&quot;, &quot;cat&quot;, &quot;raccoon&quot;], &quot;animals_seen&quot;: 3, &quot;location&quot;: &quot;park&quot; }</span>

`,wrap:!1}}),L=new A({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwJTNBJTJGJTJGbG9jYWxob3N0JTNBMzAwMCUyMiklMEElMEFzZWN0aW9uX3JlZ2V4JTIwJTNEJTIwJTIyKCUzRiUzQTI1JTVCMC01JTVEJTdDMiU1QjAtNCU1RCU1QjAtOSU1RCU3QyU1QjAxJTVEJTNGJTVCMC05JTVEJTVCMC05JTVEJTNGKSUyMiUwQXJlZ2V4cCUyMCUzRCUyMGYlMjJIRUxMTyU1Qy4lN0JzZWN0aW9uX3JlZ2V4JTdEJTVDLldPUkxEJTVDLiU3QnNlY3Rpb25fcmVnZXglN0QlMjIlMEElMEElMjMlMjBUaGlzJTIwaXMlMjBhJTIwbW9yZSUyMHJlYWxpc3RpYyUyMGV4YW1wbGUlMjBvZiUyMGFuJTIwaXAlMjBhZGRyZXNzJTIwcmVnZXglMEElMjMlMjByZWdleHAlMjAlM0QlMjBmJTIyJTdCc2VjdGlvbl9yZWdleCU3RCU1Qy4lN0JzZWN0aW9uX3JlZ2V4JTdEJTVDLiU3QnNlY3Rpb25fcmVnZXglN0QlNUMuJTdCc2VjdGlvbl9yZWdleCU3RCUyMiUwQSUwQSUwQXJlc3AlMjAlM0QlMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKCUwQSUyMCUyMCUyMCUyMGYlMjJXaGF0cyUyMEdvb2dsZXMlMjBETlMlM0YlMjBQbGVhc2UlMjB1c2UlMjB0aGUlMjBmb2xsb3dpbmclMjByZWdleCUzQSUyMCU3QnJlZ2V4cCU3RCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNlZWQlM0Q0MiUyQyUwQSUyMCUyMCUyMCUyMGdyYW1tYXIlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIycmVnZXglMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2YWx1ZSUyMiUzQSUyMHJlZ2V4cCUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSklMEElMEElMEFwcmludChyZXNwKSUwQSUyMyUyMEhFTExPLjI1NS5XT1JMRC4yNTUlMEE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

section_regex = <span class="hljs-string">&quot;(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)&quot;</span>
regexp = <span class="hljs-string">f&quot;HELLO\\.<span class="hljs-subst">{section_regex}</span>\\.WORLD\\.<span class="hljs-subst">{section_regex}</span>&quot;</span>

<span class="hljs-comment"># This is a more realistic example of an ip address regex</span>
<span class="hljs-comment"># regexp = f&quot;{section_regex}\\.{section_regex}\\.{section_regex}\\.{section_regex}&quot;</span>


resp = client.text_generation(
    <span class="hljs-string">f&quot;Whats Googles DNS? Please use the following regex: <span class="hljs-subst">{regexp}</span>&quot;</span>,
    seed=<span class="hljs-number">42</span>,
    grammar={
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;regex&quot;</span>,
        <span class="hljs-string">&quot;value&quot;</span>: regexp,
    },
)


<span class="hljs-built_in">print</span>(resp)
<span class="hljs-comment"># HELLO.255.WORLD.255</span>
`,wrap:!1}}),P=new c({props:{title:"Tools and Functions 🛠️",local:"tools-and-functions-",headingTag:"h2"}}),O=new c({props:{title:"The Tools Parameter",local:"the-tools-parameter",headingTag:"h3"}}),sl=new A({props:{code:"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",highlighted:`curl localhost<span class="hljs-punctuation">:</span><span class="hljs-number">3000</span>/v1/chat/completions \\
    -X POST \\
    -H &#x27;Content-Type<span class="hljs-punctuation">:</span> application/json&#x27; \\
    -d &#x27;<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tgi&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is the weather like in New York?&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;tools&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_current_weather&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Get the current weather&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>
                        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;format&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;enum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;celsius&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;fahrenheit&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>
                        <span class="hljs-punctuation">}</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;location&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;format&quot;</span><span class="hljs-punctuation">]</span>
                <span class="hljs-punctuation">}</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;tool_choice&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_current_weather&quot;</span>
<span class="hljs-punctuation">}</span>&#x27;
<span class="hljs-comment">// {&quot;id&quot;:&quot;&quot;,&quot;object&quot;:&quot;text_completion&quot;,&quot;created&quot;:1709051640,&quot;model&quot;:&quot;HuggingFaceH4/zephyr-7b-beta&quot;,&quot;system_fingerprint&quot;:&quot;1.4.3-native&quot;,&quot;choices&quot;:[{&quot;index&quot;:0,&quot;message&quot;:{&quot;role&quot;:&quot;assistant&quot;,&quot;tool_calls&quot;:{&quot;id&quot;:0,&quot;type&quot;:&quot;function&quot;,&quot;function&quot;:{&quot;description&quot;:null,&quot;name&quot;:&quot;tools&quot;,&quot;parameters&quot;:{&quot;format&quot;:&quot;celsius&quot;,&quot;location&quot;:&quot;New York&quot;}}}},&quot;logprobs&quot;:null,&quot;finish_reason&quot;:&quot;eos_token&quot;}],&quot;usage&quot;:{&quot;prompt_tokens&quot;:157,&quot;completion_tokens&quot;:19,&quot;total_tokens&quot;:176}}</span>`,wrap:!1}}),tl=new c({props:{title:"Chat Completion with Tools",local:"chat-completion-with-tools",headingTag:"h3"}}),al=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

tools = [
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;location&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                    },
                    <span class="hljs-string">&quot;format&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
                    },
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
            },
        },
    },
    {
        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
        <span class="hljs-string">&quot;function&quot;</span>: {
            <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
            <span class="hljs-string">&quot;parameters&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                <span class="hljs-string">&quot;properties&quot;</span>: {
                    <span class="hljs-string">&quot;location&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                    },
                    <span class="hljs-string">&quot;format&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                        <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
                    },
                    <span class="hljs-string">&quot;num_days&quot;</span>: {
                        <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
                        <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
                    },
                },
                <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
            },
        },
    },
]

chat = client.chat_completion(
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You&#x27;re a helpful assistant! Answer the users question best you can.&quot;</span>,
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the weather like in Brooklyn, New York?&quot;</span>,
        },
    ],
    tools=tools,
    seed=<span class="hljs-number">42</span>,
    max_tokens=<span class="hljs-number">100</span>,
)

<span class="hljs-built_in">print</span>(chat.choices[<span class="hljs-number">0</span>].message.tool_calls)
<span class="hljs-comment"># [ChatCompletionOutputToolCall(function=ChatCompletionOutputFunctionDefinition(arguments={&#x27;format&#x27;: &#x27;fahrenheit&#x27;, &#x27;location&#x27;: &#x27;Brooklyn, New York&#x27;, &#x27;num_days&#x27;: 7}, name=&#x27;get_n_day_weather_forecast&#x27;, description=None), id=0, type=&#x27;function&#x27;)]</span>
`,wrap:!1}}),nl=new c({props:{title:"OpenAI integration",local:"openai-integration",headingTag:"h3"}}),jl=new A({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># Initialize the client, pointing it to one of the available models</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;_&quot;</span>,
)

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> tools defined above and removed for brevity</span>

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
        },
    ],
    tools=tools,
    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,  <span class="hljs-comment"># tool selected by model</span>
    max_tokens=<span class="hljs-number">500</span>,
)


called = chat_completion.choices[<span class="hljs-number">0</span>].message.tool_calls
<span class="hljs-built_in">print</span>(called)
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#     &quot;id&quot;: 0,</span>
<span class="hljs-comment">#     &quot;type&quot;: &quot;function&quot;,</span>
<span class="hljs-comment">#     &quot;function&quot;: {</span>
<span class="hljs-comment">#         &quot;description&quot;: None,</span>
<span class="hljs-comment">#         &quot;name&quot;: &quot;tools&quot;,</span>
<span class="hljs-comment">#         &quot;parameters&quot;: {</span>
<span class="hljs-comment">#             &quot;format&quot;: &quot;celsius&quot;,</span>
<span class="hljs-comment">#             &quot;location&quot;: &quot;San Francisco, CA&quot;,</span>
<span class="hljs-comment">#             &quot;num_days&quot;: 3,</span>
<span class="hljs-comment">#         },</span>
<span class="hljs-comment">#     },</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),ol=new c({props:{title:"Tool Choice Configuration",local:"tool-choice-configuration",headingTag:"h3"}}),Tl=new A({props:{code:"dG9vbF9jaG9pY2UlM0QlMjJhdXRvJTIy",highlighted:'tool_choice=<span class="hljs-string">&quot;auto&quot;</span>',wrap:!1}}),il=new A({props:{code:"dG9vbF9jaG9pY2UlM0QlMjJub25lJTIy",highlighted:'tool_choice=<span class="hljs-string">&quot;none&quot;</span>',wrap:!1}}),Il=new A({props:{code:"dG9vbF9jaG9pY2UlM0QlMjJyZXF1aXJlZCUyMg==",highlighted:'tool_choice=<span class="hljs-string">&quot;required&quot;</span>',wrap:!1}}),rl=new A({props:{code:"dG9vbF9jaG9pY2UlM0QlMjJnZXRfY3VycmVudF93ZWF0aGVyJTIy",highlighted:'tool_choice=<span class="hljs-string">&quot;get_current_weather&quot;</span>',wrap:!1}}),hl=new A({props:{code:"dG9vbF9jaG9pY2UlM0QlN0IlMEElMjAlMjAlMjJ0eXBlJTIyJTNBJTIwJTIyZnVuY3Rpb24lMjIlMkMlMEElMjAlMjAlMjJmdW5jdGlvbiUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMm5hbWUlMjIlM0ElMjAlMjJnZXRfY3VycmVudF93ZWF0aGVyJTIyJTBBJTIwJTIwJTdEJTBBJTdE",highlighted:`tool_choice={
  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
  <span class="hljs-string">&quot;function&quot;</span>: {
      <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>
  }
}`,wrap:!1}}),dl=new eM({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/basic_tutorials/using_guidance.md"}}),{c(){r=e("meta"),Hl=a(),Rl=e("p"),Fl=a(),y(d.$$.fragment),Dl=a(),q=e("p"),q.innerHTML=Ct,Ll=a(),g=e("p"),g.innerHTML=mt,Pl=a(),b=e("p"),b.innerHTML=dt,Ol=a(),y(f.$$.fragment),Kl=a(),E=e("p"),E.innerHTML=qt,ls=a(),B=e("p"),B.innerHTML=gt,ss=a(),y(Q.$$.fragment),ts=a(),y(N.$$.fragment),Ms=a(),Z=e("ul"),Z.innerHTML=bt,as=a(),y(G.$$.fragment),ns=a(),W=e("ul"),W.innerHTML=ft,es=a(),y(S.$$.fragment),js=a(),y(v.$$.fragment),os=a(),$=e("p"),$.innerHTML=Et,Js=a(),k=e("p"),k.innerHTML=Bt,ys=a(),y(x.$$.fragment),Ts=a(),y(z.$$.fragment),ps=a(),X=e("p"),X.textContent=Qt,is=a(),y(Y.$$.fragment),Us=a(),V=e("p"),V.textContent=Nt,us=a(),R=e("blockquote"),R.innerHTML=Zt,Is=a(),y(_.$$.fragment),cs=a(),H=e("p"),H.textContent=Gt,ws=a(),y(F.$$.fragment),As=a(),D=e("p"),D.textContent=Wt,rs=a(),y(L.$$.fragment),hs=a(),y(P.$$.fragment),Cs=a(),y(O.$$.fragment),ms=a(),K=e("p"),K.textContent=St,ds=a(),ll=e("p"),ll.textContent=vt,qs=a(),y(sl.$$.fragment),gs=a(),y(tl.$$.fragment),bs=a(),Ml=e("p"),Ml.innerHTML=$t,fs=a(),y(al.$$.fragment),Es=a(),y(nl.$$.fragment),Bs=a(),el=e("p"),el.textContent=kt,Qs=a(),y(jl.$$.fragment),Ns=a(),y(ol.$$.fragment),Zs=a(),Jl=e("p"),Jl.innerHTML=xt,Gs=a(),w=e("ol"),yl=e("li"),ql=e("p"),ql.innerHTML=zt,Ds=a(),h=e("ul"),gl=e("li"),gl.textContent=Xt,Ls=a(),bl=e("li"),bl.textContent=Yt,Ps=a(),fl=e("li"),Os=Yl(`Example usage:
	`),y(Tl.$$.fragment),Ks=a(),pl=e("li"),El=e("p"),El.innerHTML=Vt,lt=a(),C=e("ul"),Bl=e("li"),Bl.textContent=Rt,st=a(),Ql=e("li"),Ql.textContent=_t,tt=a(),Nl=e("li"),Mt=Yl(`Example usage:
	`),y(il.$$.fragment),at=a(),Ul=e("li"),Zl=e("p"),Zl.innerHTML=Ht,nt=a(),ul=e("ul"),Gl=e("li"),Gl.textContent=Ft,et=a(),Wl=e("li"),jt=Yl(`Example usage:
	`),y(Il.$$.fragment),ot=a(),cl=e("li"),Sl=e("p"),Sl.innerHTML=Dt,Jt=a(),wl=e("ul"),vl=e("li"),vl.textContent=Lt,yt=a(),$l=e("li"),Tt=Yl("Two ways to do this:"),Al=e("ol"),kl=e("li"),pt=Yl(`Provide the function name as a string:
	`),y(rl.$$.fragment),it=a(),xl=e("li"),Ut=Yl(`Use the function object format:
	`),y(hl.$$.fragment),Ws=a(),Cl=e("p"),Cl.textContent=Pt,Ss=a(),vs=e("hr"),$s=a(),ml=e("table"),ml.innerHTML=Ot,ks=a(),y(dl.$$.fragment),xs=a(),_l=e("p"),this.h()},l(l){const s=nM("svelte-u9bgzb",document.head);r=j(s,"META",{name:!0,content:!0}),s.forEach(t),Hl=n(l),Rl=j(l,"P",{}),I(Rl).forEach(t),Fl=n(l),T(d.$$.fragment,l),Dl=n(l),q=j(l,"P",{"data-svelte-h":!0}),J(q)!=="svelte-kbjeep"&&(q.innerHTML=Ct),Ll=n(l),g=j(l,"P",{"data-svelte-h":!0}),J(g)!=="svelte-fq1iv3"&&(g.innerHTML=mt),Pl=n(l),b=j(l,"P",{"data-svelte-h":!0}),J(b)!=="svelte-bfgv2a"&&(b.innerHTML=dt),Ol=n(l),T(f.$$.fragment,l),Kl=n(l),E=j(l,"P",{"data-svelte-h":!0}),J(E)!=="svelte-wsp0l4"&&(E.innerHTML=qt),ls=n(l),B=j(l,"P",{"data-svelte-h":!0}),J(B)!=="svelte-15m2t7v"&&(B.innerHTML=gt),ss=n(l),T(Q.$$.fragment,l),ts=n(l),T(N.$$.fragment,l),Ms=n(l),Z=j(l,"UL",{"data-svelte-h":!0}),J(Z)!=="svelte-12576sd"&&(Z.innerHTML=bt),as=n(l),T(G.$$.fragment,l),ns=n(l),W=j(l,"UL",{"data-svelte-h":!0}),J(W)!=="svelte-18ofpvb"&&(W.innerHTML=ft),es=n(l),T(S.$$.fragment,l),js=n(l),T(v.$$.fragment,l),os=n(l),$=j(l,"P",{"data-svelte-h":!0}),J($)!=="svelte-yoqu28"&&($.innerHTML=Et),Js=n(l),k=j(l,"P",{"data-svelte-h":!0}),J(k)!=="svelte-1vsv0tm"&&(k.innerHTML=Bt),ys=n(l),T(x.$$.fragment,l),Ts=n(l),T(z.$$.fragment,l),ps=n(l),X=j(l,"P",{"data-svelte-h":!0}),J(X)!=="svelte-126mt2g"&&(X.textContent=Qt),is=n(l),T(Y.$$.fragment,l),Us=n(l),V=j(l,"P",{"data-svelte-h":!0}),J(V)!=="svelte-1nlfjb7"&&(V.textContent=Nt),us=n(l),R=j(l,"BLOCKQUOTE",{"data-svelte-h":!0}),J(R)!=="svelte-cm9i0i"&&(R.innerHTML=Zt),Is=n(l),T(_.$$.fragment,l),cs=n(l),H=j(l,"P",{"data-svelte-h":!0}),J(H)!=="svelte-3pxjtu"&&(H.textContent=Gt),ws=n(l),T(F.$$.fragment,l),As=n(l),D=j(l,"P",{"data-svelte-h":!0}),J(D)!=="svelte-6wpj0x"&&(D.textContent=Wt),rs=n(l),T(L.$$.fragment,l),hs=n(l),T(P.$$.fragment,l),Cs=n(l),T(O.$$.fragment,l),ms=n(l),K=j(l,"P",{"data-svelte-h":!0}),J(K)!=="svelte-lut42n"&&(K.textContent=St),ds=n(l),ll=j(l,"P",{"data-svelte-h":!0}),J(ll)!=="svelte-1a560wn"&&(ll.textContent=vt),qs=n(l),T(sl.$$.fragment,l),gs=n(l),T(tl.$$.fragment,l),bs=n(l),Ml=j(l,"P",{"data-svelte-h":!0}),J(Ml)!=="svelte-13xxzo"&&(Ml.innerHTML=$t),fs=n(l),T(al.$$.fragment,l),Es=n(l),T(nl.$$.fragment,l),Bs=n(l),el=j(l,"P",{"data-svelte-h":!0}),J(el)!=="svelte-qj1me9"&&(el.textContent=kt),Qs=n(l),T(jl.$$.fragment,l),Ns=n(l),T(ol.$$.fragment,l),Zs=n(l),Jl=j(l,"P",{"data-svelte-h":!0}),J(Jl)!=="svelte-13rggpe"&&(Jl.innerHTML=xt),Gs=n(l),w=j(l,"OL",{});var m=I(w);yl=j(m,"LI",{});var Xs=I(yl);ql=j(Xs,"P",{"data-svelte-h":!0}),J(ql)!=="svelte-xbr04b"&&(ql.innerHTML=zt),Ds=n(Xs),h=j(Xs,"UL",{});var zl=I(h);gl=j(zl,"LI",{"data-svelte-h":!0}),J(gl)!=="svelte-kqytsb"&&(gl.textContent=Xt),Ls=n(zl),bl=j(zl,"LI",{"data-svelte-h":!0}),J(bl)!=="svelte-1jg6yx2"&&(bl.textContent=Yt),Ps=n(zl),fl=j(zl,"LI",{});var ut=I(fl);Os=Vl(ut,`Example usage:
	`),T(Tl.$$.fragment,ut),ut.forEach(t),zl.forEach(t),Xs.forEach(t),Ks=n(m),pl=j(m,"LI",{});var Ys=I(pl);El=j(Ys,"P",{"data-svelte-h":!0}),J(El)!=="svelte-11bn5m0"&&(El.innerHTML=Vt),lt=n(Ys),C=j(Ys,"UL",{});var Xl=I(C);Bl=j(Xl,"LI",{"data-svelte-h":!0}),J(Bl)!=="svelte-klffq4"&&(Bl.textContent=Rt),st=n(Xl),Ql=j(Xl,"LI",{"data-svelte-h":!0}),J(Ql)!=="svelte-up128b"&&(Ql.textContent=_t),tt=n(Xl),Nl=j(Xl,"LI",{});var It=I(Nl);Mt=Vl(It,`Example usage:
	`),T(il.$$.fragment,It),It.forEach(t),Xl.forEach(t),Ys.forEach(t),at=n(m),Ul=j(m,"LI",{});var Vs=I(Ul);Zl=j(Vs,"P",{"data-svelte-h":!0}),J(Zl)!=="svelte-1u693el"&&(Zl.innerHTML=Ht),nt=n(Vs),ul=j(Vs,"UL",{});var Rs=I(ul);Gl=j(Rs,"LI",{"data-svelte-h":!0}),J(Gl)!=="svelte-9fo4bt"&&(Gl.textContent=Ft),et=n(Rs),Wl=j(Rs,"LI",{});var ct=I(Wl);jt=Vl(ct,`Example usage:
	`),T(Il.$$.fragment,ct),ct.forEach(t),Rs.forEach(t),Vs.forEach(t),ot=n(m),cl=j(m,"LI",{});var _s=I(cl);Sl=j(_s,"P",{"data-svelte-h":!0}),J(Sl)!=="svelte-gefj73"&&(Sl.innerHTML=Dt),Jt=n(_s),wl=j(_s,"UL",{});var Hs=I(wl);vl=j(Hs,"LI",{"data-svelte-h":!0}),J(vl)!=="svelte-1o336wz"&&(vl.textContent=Lt),yt=n(Hs),$l=j(Hs,"LI",{});var wt=I($l);Tt=Vl(wt,"Two ways to do this:"),Al=j(wt,"OL",{});var Fs=I(Al);kl=j(Fs,"LI",{});var At=I(kl);pt=Vl(At,`Provide the function name as a string:
	`),T(rl.$$.fragment,At),At.forEach(t),it=n(Fs),xl=j(Fs,"LI",{});var rt=I(xl);Ut=Vl(rt,`Use the function object format:
	`),T(hl.$$.fragment,rt),rt.forEach(t),Fs.forEach(t),wt.forEach(t),Hs.forEach(t),_s.forEach(t),m.forEach(t),Ws=n(l),Cl=j(l,"P",{"data-svelte-h":!0}),J(Cl)!=="svelte-6l9nzs"&&(Cl.textContent=Pt),Ss=n(l),vs=j(l,"HR",{}),$s=n(l),ml=j(l,"TABLE",{"data-svelte-h":!0}),J(ml)!=="svelte-9e6c3b"&&(ml.innerHTML=Ot),ks=n(l),T(dl.$$.fragment,l),xs=n(l),_l=j(l,"P",{}),I(_l).forEach(t),this.h()},h(){Kt(r,"name","hf:doc:metadata"),Kt(r,"content",oM)},m(l,s){o(document.head,r),M(l,Hl,s),M(l,Rl,s),M(l,Fl,s),p(d,l,s),M(l,Dl,s),M(l,q,s),M(l,Ll,s),M(l,g,s),M(l,Pl,s),M(l,b,s),M(l,Ol,s),p(f,l,s),M(l,Kl,s),M(l,E,s),M(l,ls,s),M(l,B,s),M(l,ss,s),p(Q,l,s),M(l,ts,s),p(N,l,s),M(l,Ms,s),M(l,Z,s),M(l,as,s),p(G,l,s),M(l,ns,s),M(l,W,s),M(l,es,s),p(S,l,s),M(l,js,s),p(v,l,s),M(l,os,s),M(l,$,s),M(l,Js,s),M(l,k,s),M(l,ys,s),p(x,l,s),M(l,Ts,s),p(z,l,s),M(l,ps,s),M(l,X,s),M(l,is,s),p(Y,l,s),M(l,Us,s),M(l,V,s),M(l,us,s),M(l,R,s),M(l,Is,s),p(_,l,s),M(l,cs,s),M(l,H,s),M(l,ws,s),p(F,l,s),M(l,As,s),M(l,D,s),M(l,rs,s),p(L,l,s),M(l,hs,s),p(P,l,s),M(l,Cs,s),p(O,l,s),M(l,ms,s),M(l,K,s),M(l,ds,s),M(l,ll,s),M(l,qs,s),p(sl,l,s),M(l,gs,s),p(tl,l,s),M(l,bs,s),M(l,Ml,s),M(l,fs,s),p(al,l,s),M(l,Es,s),p(nl,l,s),M(l,Bs,s),M(l,el,s),M(l,Qs,s),p(jl,l,s),M(l,Ns,s),p(ol,l,s),M(l,Zs,s),M(l,Jl,s),M(l,Gs,s),M(l,w,s),o(w,yl),o(yl,ql),o(yl,Ds),o(yl,h),o(h,gl),o(h,Ls),o(h,bl),o(h,Ps),o(h,fl),o(fl,Os),p(Tl,fl,null),o(w,Ks),o(w,pl),o(pl,El),o(pl,lt),o(pl,C),o(C,Bl),o(C,st),o(C,Ql),o(C,tt),o(C,Nl),o(Nl,Mt),p(il,Nl,null),o(w,at),o(w,Ul),o(Ul,Zl),o(Ul,nt),o(Ul,ul),o(ul,Gl),o(ul,et),o(ul,Wl),o(Wl,jt),p(Il,Wl,null),o(w,ot),o(w,cl),o(cl,Sl),o(cl,Jt),o(cl,wl),o(wl,vl),o(wl,yt),o(wl,$l),o($l,Tt),o($l,Al),o(Al,kl),o(kl,pt),p(rl,kl,null),o(Al,it),o(Al,xl),o(xl,Ut),p(hl,xl,null),M(l,Ws,s),M(l,Cl,s),M(l,Ss,s),M(l,vs,s),M(l,$s,s),M(l,ml,s),M(l,ks,s),p(dl,l,s),M(l,xs,s),M(l,_l,s),zs=!0},p:sM,i(l){zs||(i(d.$$.fragment,l),i(f.$$.fragment,l),i(Q.$$.fragment,l),i(N.$$.fragment,l),i(G.$$.fragment,l),i(S.$$.fragment,l),i(v.$$.fragment,l),i(x.$$.fragment,l),i(z.$$.fragment,l),i(Y.$$.fragment,l),i(_.$$.fragment,l),i(F.$$.fragment,l),i(L.$$.fragment,l),i(P.$$.fragment,l),i(O.$$.fragment,l),i(sl.$$.fragment,l),i(tl.$$.fragment,l),i(al.$$.fragment,l),i(nl.$$.fragment,l),i(jl.$$.fragment,l),i(ol.$$.fragment,l),i(Tl.$$.fragment,l),i(il.$$.fragment,l),i(Il.$$.fragment,l),i(rl.$$.fragment,l),i(hl.$$.fragment,l),i(dl.$$.fragment,l),zs=!0)},o(l){U(d.$$.fragment,l),U(f.$$.fragment,l),U(Q.$$.fragment,l),U(N.$$.fragment,l),U(G.$$.fragment,l),U(S.$$.fragment,l),U(v.$$.fragment,l),U(x.$$.fragment,l),U(z.$$.fragment,l),U(Y.$$.fragment,l),U(_.$$.fragment,l),U(F.$$.fragment,l),U(L.$$.fragment,l),U(P.$$.fragment,l),U(O.$$.fragment,l),U(sl.$$.fragment,l),U(tl.$$.fragment,l),U(al.$$.fragment,l),U(nl.$$.fragment,l),U(jl.$$.fragment,l),U(ol.$$.fragment,l),U(Tl.$$.fragment,l),U(il.$$.fragment,l),U(Il.$$.fragment,l),U(rl.$$.fragment,l),U(hl.$$.fragment,l),U(dl.$$.fragment,l),zs=!1},d(l){l&&(t(Hl),t(Rl),t(Fl),t(Dl),t(q),t(Ll),t(g),t(Pl),t(b),t(Ol),t(Kl),t(E),t(ls),t(B),t(ss),t(ts),t(Ms),t(Z),t(as),t(ns),t(W),t(es),t(js),t(os),t($),t(Js),t(k),t(ys),t(Ts),t(ps),t(X),t(is),t(Us),t(V),t(us),t(R),t(Is),t(cs),t(H),t(ws),t(As),t(D),t(rs),t(hs),t(Cs),t(ms),t(K),t(ds),t(ll),t(qs),t(gs),t(bs),t(Ml),t(fs),t(Es),t(Bs),t(el),t(Qs),t(Ns),t(Zs),t(Jl),t(Gs),t(w),t(Ws),t(Cl),t(Ss),t(vs),t($s),t(ml),t(ks),t(xs),t(_l)),t(r),u(d,l),u(f,l),u(Q,l),u(N,l),u(G,l),u(S,l),u(v,l),u(x,l),u(z,l),u(Y,l),u(_,l),u(F,l),u(L,l),u(P,l),u(O,l),u(sl,l),u(tl,l),u(al,l),u(nl,l),u(jl,l),u(ol,l),u(Tl),u(il),u(Il),u(rl),u(hl),u(dl,l)}}}const oM='{"title":"Guidance","local":"guidance","sections":[{"title":"How it works","local":"how-it-works","sections":[],"depth":2},{"title":"Table of Contents 📚","local":"table-of-contents-","sections":[{"title":"Grammar and Constraints","local":"grammar-and-constraints","sections":[],"depth":3},{"title":"Tools and Functions","local":"tools-and-functions","sections":[],"depth":3}],"depth":2},{"title":"Grammar and Constraints 🛣️","local":"grammar-and-constraints-","sections":[{"title":"The Grammar Parameter","local":"the-grammar-parameter","sections":[],"depth":3},{"title":"Hugging Face Hub Python Library","local":"hugging-face-hub-python-library","sections":[],"depth":3},{"title":"Constrain with Pydantic","local":"constrain-with-pydantic","sections":[],"depth":3}],"depth":2},{"title":"Tools and Functions 🛠️","local":"tools-and-functions-","sections":[{"title":"The Tools Parameter","local":"the-tools-parameter","sections":[],"depth":3},{"title":"Chat Completion with Tools","local":"chat-completion-with-tools","sections":[],"depth":3},{"title":"OpenAI integration","local":"openai-integration","sections":[],"depth":3},{"title":"Tool Choice Configuration","local":"tool-choice-configuration","sections":[],"depth":3}],"depth":2}],"depth":1}';function JM(ht){return tM(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class UM extends MM{constructor(r){super(),aM(this,r,JM,jM,lM,{})}}export{UM as component};
