import os
os.environ["CUDA_VISIBLE_DEVICES"]="1"
os.environ["HF_ENDPOINT"] = "https://hf-mirror.com"
os.environ["HF_CACHE_DIR"] = "/mnt/workspace/workgroup/zheliu.lzy/.cache"
os.environ["TRANSFORMERS_CACHE"] = "/mnt/workspace/workgroup/zheliu.lzy/.cache"
os.environ["HF_HOME"] = "/mnt/workspace/workgroup/zheliu.lzy/.cache"
os.environ["PYTHONWARNINGS"] = "ignore::FutureWarning"
import sys 
sys.path.append("/mnt/workspace/workgroup/zheliu.lzy/vision_cot/OminiControl/LooseControl")

import json
from PIL import Image
from tqdm import tqdm
import random
import numpy as np
import torch
from loosecontrol import LooseControlNet

SCENES_PROMPT = [
    "on the desert",
    "in the room",
    "on the street",
    "in the jungle",
    "on the road",
    "in the studio",
    "on the beach",
    "on a snowy landscape",
    "in the apartment",
    "in the library",
]

# Set seed for reproducibility
def seed_everything(seed: int):
    torch.manual_seed(seed)
    if torch.cuda.is_available():
        torch.cuda.manual_seed_all(seed)
    np.random.seed(seed)
    random.seed(seed)


device = torch.device("cuda:0") if torch.cuda.is_available() else torch.device("cpu")
lcn = LooseControlNet("shariqfarooq/loose-control-3dbox")
lcn = lcn.to(device, torch.bfloat16)

prompt = "A photo of a snowman in a desert"
pos_prompts="4k, high-res, realistic, "
negative_prompt = "blurry, text, caption, lowquality,lowresolution, low res, grainy, ugly"

json_path = '3DLayBench/highly_scored_prompts.json'
with open(json_path, 'r') as f:
    data = json.load(f)

os.makedirs(f"LooseControl/3dlaybench/samples", exist_ok=True)
for pair in tqdm(data):
    prompt = pair['prompt']
    seeds = [42]
    
    try:
        for scene in SCENES_PROMPT:
            if scene in prompt:
                boxy_depth = Image.open(f"data/render/{prompt.replace(f' {scene}', '')}/bas_depth_2.png")
        for seed in seeds:
            seed_everything(seed)
            gen_image = lcn(prompt, negative_prompt=negative_prompt, control_image=boxy_depth)
            gen_image.save(f"LooseControl/3dlaybench/samples/{prompt}_{seed}.png")
    except:
        pass