import os
os.environ["CUDA_VISIBLE_DEVICES"]="1"
os.environ["HF_ENDPOINT"] = "https://hf-mirror.com"
os.environ["HF_CACHE_DIR"] = "/mnt/workspace/workgroup/zheliu.lzy/.cache"
os.environ["TRANSFORMERS_CACHE"] = "/mnt/workspace/workgroup/zheliu.lzy/.cache"
os.environ["HF_HOME"] = "/mnt/workspace/workgroup/zheliu.lzy/.cache"
os.environ["PYTHONWARNINGS"] = "ignore::FutureWarning"
import sys 
sys.path.append("/mnt/workspace/workgroup/zheliu.lzy/vision_cot/OminiControl/LooseControl")

import json
from PIL import Image
from tqdm import tqdm
import random
import numpy as np
import torch
from loosecontrol import LooseControlNet

# Set seed for reproducibility
def seed_everything(seed: int):
    torch.manual_seed(seed)
    if torch.cuda.is_available():
        torch.cuda.manual_seed_all(seed)
    np.random.seed(seed)
    random.seed(seed)


device = torch.device("cuda:0") if torch.cuda.is_available() else torch.device("cpu")
lcn = LooseControlNet("shariqfarooq/loose-control-3dbox")
lcn = lcn.to(device, torch.bfloat16)

scene_prompt = {
    'An empty desert with cloudy sky': "on the desert with cloudy sky",
    "An empty room with windows and curtains": "in the room with windows and curtains",
    "An empty street": "on the street",
    "An empty jungle": "in the jungle",
    "An empty road": "on the road",
    "An empty studio": "in the studio",
    "An empty beach": "on the beach",
    "A snowy landscape": "on a snowy landscape",
    "An empty apartment": "in the apartment",
}

prompt = "A photo of a snowman in a desert"
pos_prompts="4k, high-res, realistic, "
negative_prompt = "blurry, text, caption, lowquality,lowresolution, low res, grainy, ugly"

for i, json_name in tqdm(enumerate(os.listdir("build_a_scene/eval/evaluation_set_1/generation/json")), total=100):
    json_path = f"build_a_scene/eval/evaluation_set_1/generation/json/{json_name}"
    with open(json_path, 'r') as f:
        data = json.load(f)
    seeds = sorted(data["seeds"])
    scene = data['scene']
    prompt = f"{pos_prompts}{data['box_1']['prompt']} and {data['box_2']['prompt']} {scene_prompt[scene]}"
    
    boxy_depth = Image.open(f"build_a_scene/eval/evaluation_set_1/generation/renders/{str(i).zfill(4)}.png")
    for seed in seeds:
        seed_everything(seed)
        os.makedirs(f"LooseControl/results/{str(i).zfill(4)}", exist_ok=True)
        gen_image_1 = lcn(prompt, negative_prompt=negative_prompt, control_image=boxy_depth)
        gen_image_1.save(f"LooseControl/results/{str(i).zfill(4)}/{str(i).zfill(4)}_{seed}.png")
