---
license: apache-2.0
library_name: diffusers
---
# FLUX.1-schnell-training-adapter

This won't do anything on its own. To use it, you will need a trainer that can train with it. It was designed for my trainer, [ai-toolkit](https://github.com/ostris/ai-toolkit).
But other trainers may support it as well.


## What is this?

This is an adapter that allows you to train LoRAs directly on [black-forest-labs/FLUX.1-schnell](https://huggingface.co/black-forest-labs/FLUX.1-schnell). Schnell is
a step distilled model, meaning it can generate an image in just a few steps. However, this makes it impossible to train on it directly because every step you train
breaks down the compression more and more. With this adapter enabled during training, that doesnt happen. It is activated during the training process, and
disabled during sampling. After the LoRA is trained, this adapter is no longer needed. 


## Benefits of training directly on schnell

- **Apache 2.0** - FLUX.1 schnell is licensed as Apache 2.0, and so is this adapter, which means everything you train on it can be licensed however you want. When training on dev, everything trained on it inherits the non commercial license.
- **Better Compatibility** - LoRAs trained on dev seem to not work as well on schnell. By training directly on schnell, your LoRAs will be more compatable with it.
- **Sampling Speed** - I love training samples to watch progress. But doing 20-30 steps for every sample image takes FOREVER. With this adapter, you only need 1-4 steps.


## Support my work

<a href="https://glif.app" target="_blank">
<img alt="glif.app" src="https://raw.githubusercontent.com/ostris/ai-toolkit/main/assets/glif.svg?v=1" width="256" height="auto">
</a>


My work on this project would not be possible without the amazing support of [Glif](https://glif.app/) and everyone on the 
team. If you want to support me, support Glif. [Join the site](https://glif.app/), 
[Join us on Discord](https://discord.com/invite/nuR9zZ2nsh), [follow us on Twitter](https://x.com/heyglif)
and come make some cool stuff with us