import matplotlib.pyplot as plt
import numpy as np
import os # 导入os模块用于检查和创建文件夹

num_sub=6
# 提供的两个数据列表
list1_orig = np.array([0.811, 0.813, 0.81, 0.81, 0.809, 0.787, 0.745, 0.714, 0.659, 0.753, 0.759, 0.801, 0.766, 0.798, 0.763, 0.814, 0.79, 0.783])
list2_orig = np.array([0.773, 0.75, 0.718, 0.711, 0.7, 0.698, 0.732, 0.712, 0.642, 0.661, 0.659, 0.631, 0.641, 0.681, 0.677, 0.659, 0.652, 0.639])

# 截取并合并列表的前num_sub和后num_sub个元素
list1 = np.concatenate([list1_orig[:num_sub], list1_orig[-num_sub:]])
list2 = np.concatenate([list2_orig[:num_sub], list2_orig[-num_sub:]])

# 横坐标标记 (这个diffs已经是处理后的12个元素，可以直接使用)
# 如果原始diffs也需要类似list1/list2的处理，则需要先定义一个更长的diffs_orig
# 但根据您代码的上下文，这里的diffs似乎就是最终想要的12个标签
diffs_labels = np.array([-6, -5, -4, -3, -2, -1, 1, 2, 3, 4, 5, 6])
# 下面这行在您原代码中对于diffs_labels的定义是冗余的，因为diffs_labels已经是12个元素
# 如果diffs_labels изначально был бы длиннее, тогда это имело бы смысл.
# diffs_labels = np.concatenate([diffs_labels[:num_sub], diffs_labels[-num_sub:]])


# 生成x轴的实际绘图位置 (0, 1, 2, ..., N-1)
x_values = np.arange(len(list1))

# 创建绘图
plt.figure(figsize=(12, 7)) # 您可以根据需要调整图形大小

# 绘制第一个列表的折线图
# marker='o' 在每个数据点添加一个圆圈标记
# linestyle='-' 使用实线连接数据点
plt.plot(x_values, list1, marker='o', linestyle='-', label='List 1')

# 绘制第二个列表的折线图
# marker='s' 在每个数据点添加一个方形标记
plt.plot(x_values, list2, marker='s', linestyle='-', label='List 2')

# 绘制数据全为 1 的灰色虚线
plt.axhline(y=1, color='gray', linestyle='--', label='Threshold at 1')

# 添加图例
plt.legend()

# 添加标题和轴标签
plt.title('Line Graph of Two Lists') # 您可以修改为更具描述性的标题
plt.xlabel('Diffs')
plt.ylabel('Value')

# 显示网格 (可选)
plt.grid(True)

# 设置x轴刻度和标签
# 这是修改的关键点：
# 第一个参数 ticks 指定刻度线的位置
# 第二个参数 labels 指定对应位置的标签
plt.xticks(ticks=x_values, labels=diffs_labels, ha='right')

# --- 新增：设置y轴的坐标范围 ---
plt.ylim(0.2, 1.05)
# --- 结束新增 ---

# 自动调整子图参数，使之填充整个图像区域，防止标签被截断
plt.tight_layout()

# 保存图形前确保目标文件夹存在
output_dir = 'consist'
if not os.path.exists(output_dir):
    os.makedirs(output_dir)
    print(f"已创建文件夹: {output_dir}")

# 显示图形或保存图形
plt.savefig(os.path.join(output_dir, 'visual.png'))