import matplotlib.pyplot as plt
import matplotlib as mpl
import numpy as np
import os


# 全局设置 Times New Roman 字体
mpl.rcParams['font.family'] = 'serif'
mpl.rcParams['font.serif'] = ['Times New Roman'] + mpl.rcParams['font.serif']
mpl.rcParams['mathtext.fontset'] = 'stix'
mpl.rcParams['axes.unicode_minus'] = False

num_sub = 6

# 数据处理部分保持不变...
list1_orig = np.array([0.811, 0.813, 0.81, 0.81, 0.809, 0.787, 0.745, 0.714, 0.659, 0.753, 0.759, 0.801, 0.766, 0.798, 0.763, 0.814, 0.79, 0.783])
list2_orig = np.array([0.773, 0.75, 0.718, 0.711, 0.7, 0.698, 0.732, 0.712, 0.642, 0.661, 0.659, 0.631, 0.641, 0.681, 0.677, 0.659, 0.652, 0.639])

list1 = np.concatenate([list1_orig[:num_sub], list1_orig[-num_sub:]])
list2 = np.concatenate([list2_orig[:num_sub], list2_orig[-num_sub:]])
diffs_labels = np.array([-6, -5, -4, -3, -2, -1, 1, 2, 3, 4, 5, 6])
x_values = np.arange(len(list1))

# 创建画布并设置样式
plt.style.use('seaborn-v0_8-whitegrid')  # 使用seaborn样式
fig, ax = plt.subplots(figsize=(10, 8))  # 增大画布尺寸

# 定义专业配色方案
color1 = '#1f77b4'  # 深蓝色
color2 = '#ff7f0e'  # 橙色
threshold_color = '#2ca02c'  # 绿色

# 绘制阈值线
ax.axhline(y=1, color=threshold_color, linestyle='--', linewidth=2, alpha=0.8, label='Best (==1)')

# 绘制折线图
line1, = ax.plot(x_values, list1, marker='o', markersize=10,
                linestyle='-', linewidth=2.5, color=color1,
                markerfacecolor='white', markeredgecolor=color1,
               markeredgewidth=1.5, label='CoT-Diff (Ours)')

line2, = ax.plot(x_values, list2, marker='s', markersize=10,
                linestyle='-', linewidth=2.5, color=color2,
                markerfacecolor='white', markeredgecolor=color2,
               markeredgewidth=1.5, label='EliGen')



# 设置标题和标签（使用更大字体）
# ax.set_title('Performance Comparison of Two Methods', fontsize=18, pad=20)

ax.set_xlabel('Depth Difference (Relative)', fontsize=28, fontweight='bold', fontfamily='Times New Roman')
ax.set_ylabel('3D Consistency', fontsize=28, fontweight='bold', fontfamily='Times New Roman')


# 设置坐标轴范围
ax.set_ylim(0.3, 1.05)  # 根据数据范围优化显示区域
ax.set_xlim(-0.5, len(x_values)-0.5)

# 自定义x轴刻度
ax.set_xticks(x_values)
ax.set_xticklabels(diffs_labels, fontsize=24, fontfamily='Times New Roman')
# rotation=45, ha='right'

# 优化y轴刻度
ax.tick_params(axis='y', labelsize=24, labelfontfamily='Times New Roman')

# 添加阴影效果
ax.grid(True, linestyle='--', alpha=0.7, axis='y')
ax.patch.set_facecolor('#f9f9f9')  # 设置浅灰背景

# 图例设置
# legend = ax.legend(loc='lower left', fontsize=20, frameon=True, fancybox=True, shadow=True)

legend = ax.legend(loc='lower left',
                   fontsize=24,
                   frameon=True,
                   fancybox=True,
                   shadow=True,
                   prop={'family': 'Times New Roman', 'size': 24, 'weight': 'normal'})
legend.get_frame().set_facecolor('#ffffff')

# 布局调整
plt.tight_layout()

# 创建输出目录
output_dir = 'consist'
if not os.path.exists(output_dir):
    os.makedirs(output_dir)

# 保存高清图像
plt.savefig(os.path.join(output_dir, 'visual_optimized.pdf'), dpi=300, bbox_inches='tight')
plt.close()