import os
import json
from PIL import Image
import sys
sys.path.append("/mnt/workspace/workgroup/zheliu.lzy/vision_cot/OminiControl")
sys.path.append("/mnt/workspace/workgroup/zheliu.lzy/vision_cot/OminiControl")

from src.utils.scene import DiffusionScene

scene_prompt = {
    'An empty desert with cloudy sky': "on the desert with cloudy sky",
    "An empty room with windows and curtains": "in the room with windows and curtains",
    "An empty street": "on the street",
    "An empty jungle": "in the jungle",
    "An empty road": "on the road",
    "An empty studio": "in the studio",
    "An empty beach": "on the beach",
    "A snowy landscape": "on a snowy landscape",
    "An empty apartment": "in the apartment",
}

entity_prompt = {
    'An empty desert with cloudy sky': "desert",
    "An empty room with windows and curtains": "room ground",
    "An empty street": "street",
    "An empty jungle": "jungle ground",
    "An empty road": "road",
    "An empty studio": "studio ground",
    "An empty beach": "beach",
    "A snowy landscape": "snowy landscape",
    "An empty apartment": "apartment ground",
}

json_data = []
data_path = 'exp/bas_data'

for i, json_name in enumerate(os.listdir("build_a_scene/eval/evaluation_set_1/generation/json")):
    os.makedirs(f"{data_path}/{str(i).zfill(4)}", exist_ok=True)
    new_data = {}
    entities = []
    json_path = f"build_a_scene/eval/evaluation_set_1/generation/json/{json_name}"
    with open(json_path, 'r') as f:
        data = json.load(f)
    seeds = sorted(data["seeds"])
    scene = data['scene']
    prompt = f"{data['box_1']['prompt']} and {data['box_2']['prompt']} {scene_prompt[scene]}"

    new_data['seeds'] = seeds
    new_data['caption'] = prompt
    new_data['entities'] = [
        {'entity': data['box_1']['prompt']},
        {'entity': data['box_2']['prompt']},
        {'entity': f"ground of {entity_prompt[scene]}"},
    ]

    json_data.append(new_data)

    scene_size = data["scene_size"]
    scene = DiffusionScene(scene_size=scene_size)
    camera_angle = data["camera_angle"]
    scene.move_camera(rotation_angle=camera_angle, rotation_axis=[1, 0, 0], translation=[0, 0, 0])
    scene.build_floor(scale_x=2, scale_y=4, floor_offset=-scene_size)
    # scene.build_floor(scale_x=1, scale_y=1, floor_offset=-scene_size/5)

    b1_id = "box_1"
    b1_size = data[b1_id]["size"]
    b1_origin = data[b1_id]["origin"]
    b1_prompt = data[b1_id]["prompt"]
    # b1_size = [s/2 for s in b1_size]
    # b1_origin[-1] = (b1_origin[-1] + scene_size/5*4 + 1)/2 -1
    # b1_origin[-2] = b1_origin[-2] - scene_size - b1_size[-2]
    scene.add_box_ori(id=b1_id, size=b1_size, origin=b1_origin, prompt=b1_prompt)

    b2_id = "box_2"
    b2_size = data[b2_id]["size"]
    b2_origin = data[b2_id]["origin"]
    b2_prompt = data[b2_id]["prompt"]
    # b2_size = [s/2 for s in b2_size]
    # b2_origin[-1] = (b2_origin[-1] + scene_size/5*4 + 1)/2 -1
    # b2_origin[-2] = b2_origin[-2] - scene_size - b2_size[-2]
    scene.add_box_ori(id=b2_id, size=b2_size, origin=b2_origin, prompt=b2_prompt)

    depth_all = scene.render(single=True, floor=True)
    for j, depth in enumerate(depth_all):
        Image.fromarray(depth).save(f'{data_path}/{str(i).zfill(4)}/render_depth_{j}.png')

with open('exp/bas_data_floor.json', 'w') as f:
    json.dump(json_data, f, indent=4)

