# test distribution in the Orient Anything
import torch
import matplotlib.pyplot as plt
from PIL import Image
import numpy as np
from scipy.stats import vonmises

def P_gauss(theta, sigma):
    sigma = torch.tensor(sigma)
    diff = torch.arange(1, 181, dtype=torch.float32) - theta
    numerator = -(diff ** 2) / (2 * sigma ** 2)
    return numerator
    numerator = torch.exp(-(diff ** 2) / (2 * sigma ** 2))
    angles = torch.arange(1, 181, dtype=torch.float32)
    denominator = torch.exp(-(angles - theta) ** 2 / (2 * sigma ** 2)).sum()
    return numerator / denominator

def P_gauss_circular(phi, sigma, range=360):
    mean = 0
    sigma = torch.tensor(sigma)
    diff = torch.arange(1, range+1, dtype=torch.float32) - phi
    diff_rad = torch.deg2rad(diff)
    numerator = torch.cos(diff_rad) / torch.deg2rad(sigma)**2
    return numerator
    numerator = torch.exp(torch.cos(diff_rad) / sigma**2)
    denominator = 2 * torch.pi * torch.i0(1 / sigma**2)
    # denominator = 2 * torch.pi * torch.special.i0(1 / sigma**2)
    return numerator / denominator

# Example parameters
# phi = 90.0
# sigma_phi = 2.0
# distribution = P_gauss(phi, sigma_phi).softmax(dim=-1)

phi = 180.0
# phi = 0.0
sigma_phi = 20.0
distribution = P_gauss_circular(phi, sigma_phi).softmax(dim=-1)

# # phi = 180.0
# phi = 90.0
# sigma_phi = 1.0
# distribution = P_gauss_circular(phi, sigma_phi, range=180).softmax(dim=-1)

import matplotlib.pyplot as plt
# Set up the plot
plt.figure(figsize=(10, 6))
plt.plot(torch.arange(1, 361, dtype=torch.float32), distribution.cpu().numpy())
plt.xlabel('Angle (degrees)')
plt.ylabel('Probability')
plt.title('Circular Gaussian Distribution')
plt.grid(True)

# Save the plot as a PIL image
plt.savefig('distribution_plot.png', format='png')
plt.close()

