export CUDA_VISIBLE_DEVICES='3'
export HF_ENDPOINT="https://hf-mirror.com"
export HF_CACHE_DIR="/mnt/workspace/workgroup/zheliu.lzy/.cache"
export TRANSFORMERS_CACHE="/mnt/workspace/workgroup/zheliu.lzy/.cache"
export HF_HOME="/mnt/workspace/workgroup/zheliu.lzy/.cache"

dims=(
    # "3d_spatial"
    # "non_spatial"
    # "color"
    "complex"
    # "spatial"
    # "shape"
    "texture"
)
# --save_path "t2i_compbench/dataset/${dim}" --ckpt '30000'
for dim in "${dims[@]}"; do
    python src/eval/eval_t2i.py \
        --model 'eligen_3d' \
        --json_path "t2i_compbench/dataset/${dim}/json" \
        --data_path "t2i_compbench/dataset/${dim}/render" \
        --save_path "t2i_compbench/dataset/${dim}" --ckpt '30000'
done

# # add
# for dim in "${dims[@]}"; do
#     python src/eval/eval_t2i.py \
#         --model 'eligen_3d' --json_path "t2i_compbench/dataset/${dim}/json_add" \
#         --data_path "t2i_compbench/dataset/${dim}/render_add" \
#         --save_path "t2i_compbench/dataset/${dim}_add" --ckpt '30000'
# done

# for dim in "${dims[@]}"; do
#     python src/eval/eval_t2i.py \
#         --model 'eligen_3d' \
#         --json_path "t2i_compbench/dataset_qwen/${dim}/json" \
#         --data_path "t2i_compbench/dataset_qwen/${dim}/render" \
#         --save_path "t2i_compbench/dataset_qwen/${dim}" \
#         --ckpt '30000'
# done

echo "All processes completed"
