/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;

public final class StyleTextPropAtom
extends RecordAtom {
    private byte[] _header;
    private static final long _type = RecordTypes.StyleTextPropAtom.typeID;
    private byte[] reserved;
    private byte[] rawContents;
    private boolean initialised = false;
    private List<TextPropCollection> paragraphStyles;
    private List<TextPropCollection> charStyles;

    public List<TextPropCollection> getParagraphStyles() {
        return this.paragraphStyles;
    }

    public void setParagraphStyles(List<TextPropCollection> ps) {
        this.paragraphStyles = ps;
    }

    public List<TextPropCollection> getCharacterStyles() {
        return this.charStyles;
    }

    public void setCharacterStyles(List<TextPropCollection> cs) {
        this.charStyles = cs;
    }

    public int getParagraphTextLengthCovered() {
        return this.getCharactersCovered(this.paragraphStyles);
    }

    public int getCharacterTextLengthCovered() {
        return this.getCharactersCovered(this.charStyles);
    }

    private int getCharactersCovered(List<TextPropCollection> styles) {
        int length = 0;
        for (TextPropCollection tpc : styles) {
            length += tpc.getCharactersCovered();
        }
        return length;
    }

    public StyleTextPropAtom(byte[] source, int start, int len) {
        if (len < 18) {
            len = 18;
            if (source.length - start < 18) {
                throw new RuntimeException("Not enough data to form a StyleTextPropAtom (min size 18 bytes long) - found " + (source.length - start));
            }
        }
        this._header = new byte[8];
        System.arraycopy(source, start, this._header, 0, 8);
        this.rawContents = new byte[len - 8];
        System.arraycopy(source, start + 8, this.rawContents, 0, this.rawContents.length);
        this.reserved = new byte[0];
        this.paragraphStyles = new ArrayList<TextPropCollection>();
        this.charStyles = new ArrayList<TextPropCollection>();
    }

    public StyleTextPropAtom(int parentTextSize) {
        this._header = new byte[8];
        this.rawContents = new byte[0];
        this.reserved = new byte[0];
        LittleEndian.putInt(this._header, 2, (short)_type);
        LittleEndian.putInt(this._header, 4, 10);
        this.paragraphStyles = new ArrayList<TextPropCollection>();
        this.charStyles = new ArrayList<TextPropCollection>();
        this.addParagraphTextPropCollection(parentTextSize);
        this.addCharacterTextPropCollection(parentTextSize);
        this.initialised = true;
        try {
            this.updateRawContents();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        this.updateRawContents();
        out.write(this._header);
        out.write(this.rawContents);
        out.write(this.reserved);
    }

    public void setParentTextSize(int size) {
        TextPropCollection thisCollection;
        if (this.initialised) {
            return;
        }
        int pos = 0;
        int textHandled = 0;
        this.paragraphStyles.clear();
        this.charStyles.clear();
        int prsize = size;
        while (pos < this.rawContents.length && textHandled < prsize) {
            int textLen = LittleEndian.getInt(this.rawContents, pos);
            textLen = this.checkTextLength(textLen, textHandled, size);
            textHandled += textLen;
            short indent = LittleEndian.getShort(this.rawContents, pos += 4);
            int paraFlags = LittleEndian.getInt(this.rawContents, pos += 2);
            thisCollection = new TextPropCollection(textLen, TextPropCollection.TextPropType.paragraph);
            thisCollection.setIndentLevel(indent);
            int plSize = thisCollection.buildTextPropList(paraFlags, this.rawContents, pos += 4);
            this.paragraphStyles.add(thisCollection);
            if ((pos += plSize) >= this.rawContents.length || textHandled != size) continue;
            ++prsize;
        }
        if (this.rawContents.length > 0 && textHandled != size + 1) {
            logger.log(5, "Problem reading paragraph style runs: textHandled = " + textHandled + ", text.size+1 = " + (size + 1));
        }
        textHandled = 0;
        int chsize = size;
        while (pos < this.rawContents.length && textHandled < chsize) {
            int textLen = LittleEndian.getInt(this.rawContents, pos);
            textLen = this.checkTextLength(textLen, textHandled, size);
            textHandled += textLen;
            int charFlags = LittleEndian.getInt(this.rawContents, pos += 4);
            thisCollection = new TextPropCollection(textLen, TextPropCollection.TextPropType.character);
            int chSize = thisCollection.buildTextPropList(charFlags, this.rawContents, pos += 4);
            this.charStyles.add(thisCollection);
            if ((pos += chSize) >= this.rawContents.length || textHandled != size) continue;
            ++chsize;
        }
        if (this.rawContents.length > 0 && textHandled != size + 1) {
            logger.log(5, "Problem reading character style runs: textHandled = " + textHandled + ", text.size+1 = " + (size + 1));
        }
        if (pos < this.rawContents.length) {
            this.reserved = new byte[this.rawContents.length - pos];
            System.arraycopy(this.rawContents, pos, this.reserved, 0, this.reserved.length);
        }
        this.initialised = true;
    }

    private int checkTextLength(int readLength, int handledSoFar, int overallSize) {
        if (readLength + handledSoFar > overallSize + 1) {
            logger.log(5, "Style length of " + readLength + " at " + handledSoFar + " larger than stated size of " + overallSize + ", truncating");
            return overallSize + 1 - handledSoFar;
        }
        return readLength;
    }

    private void updateRawContents() throws IOException {
        if (this.initialised) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (TextPropCollection tpc : this.paragraphStyles) {
                tpc.writeOut(baos);
            }
            for (TextPropCollection tpc : this.charStyles) {
                tpc.writeOut(baos);
            }
            this.rawContents = baos.toByteArray();
        }
        int newSize = this.rawContents.length + this.reserved.length;
        LittleEndian.putInt(this._header, 4, newSize);
    }

    public void clearStyles() {
        this.paragraphStyles.clear();
        this.charStyles.clear();
        this.reserved = new byte[0];
        this.initialised = true;
    }

    public TextPropCollection addParagraphTextPropCollection(int charactersCovered) {
        TextPropCollection tpc = new TextPropCollection(charactersCovered, TextPropCollection.TextPropType.paragraph);
        this.paragraphStyles.add(tpc);
        return tpc;
    }

    public TextPropCollection addCharacterTextPropCollection(int charactersCovered) {
        TextPropCollection tpc = new TextPropCollection(charactersCovered, TextPropCollection.TextPropType.character);
        this.charStyles.add(tpc);
        return tpc;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("StyleTextPropAtom:\n");
        if (!this.initialised) {
            out.append("Uninitialised, dumping Raw Style Data\n");
        } else {
            out.append("Paragraph properties\n");
            for (TextPropCollection pr : this.getParagraphStyles()) {
                out.append(pr);
            }
            out.append("Character properties\n");
            for (TextPropCollection pr : this.getCharacterStyles()) {
                out.append(pr);
            }
            out.append("Reserved bytes\n");
            out.append(HexDump.dump(this.reserved, 0L, 0));
        }
        out.append("  original byte stream \n");
        byte[] buf = new byte[this.rawContents.length + this.reserved.length];
        System.arraycopy(this.rawContents, 0, buf, 0, this.rawContents.length);
        System.arraycopy(this.reserved, 0, buf, this.rawContents.length, this.reserved.length);
        out.append(HexDump.dump(buf, 0L, 0));
        return out.toString();
    }
}

