/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.usermodel;

import java.awt.Color;
import org.apache.poi.hslf.exceptions.HSLFException;
import org.apache.poi.hslf.model.textproperties.BitMaskTextProp;
import org.apache.poi.hslf.model.textproperties.TextProp;
import org.apache.poi.hslf.model.textproperties.TextPropCollection;
import org.apache.poi.hslf.usermodel.HSLFHyperlink;
import org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import org.apache.poi.hslf.usermodel.HSLFSheet;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import org.apache.poi.sl.draw.DrawPaint;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.TextRun;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class HSLFTextRun
implements TextRun {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    private HSLFTextParagraph parentParagraph;
    private String _runText = "";
    private String _fontFamily;
    private HSLFHyperlink link;
    private TextPropCollection characterStyle = new TextPropCollection(1, TextPropCollection.TextPropType.character);

    public HSLFTextRun(HSLFTextParagraph parentParagraph) {
        this.parentParagraph = parentParagraph;
    }

    public TextPropCollection getCharacterStyle() {
        return this.characterStyle;
    }

    public void setCharacterStyle(TextPropCollection characterStyle) {
        this.characterStyle.copy(characterStyle);
        this.characterStyle.updateTextSize(this._runText.length());
    }

    @Internal
    void setMasterStyleReference(TextPropCollection characterStyle) {
        this.characterStyle = characterStyle;
    }

    public void updateSheet() {
        if (this._fontFamily != null) {
            this.setFontFamily(this._fontFamily);
            this._fontFamily = null;
        }
    }

    public int getLength() {
        return this._runText.length();
    }

    @Override
    public String getRawText() {
        return this._runText;
    }

    @Override
    public void setText(String text) {
        if (text == null) {
            throw new HSLFException("text must not be null");
        }
        String newText = HSLFTextParagraph.toInternalString(text);
        if (!newText.equals(this._runText)) {
            this._runText = newText;
            if (HSLFSlideShow.getLoadSavePhase() == HSLFSlideShow.LoadSavePhase.LOADED) {
                this.parentParagraph.setDirty();
            }
        }
    }

    private boolean isCharFlagsTextPropVal(int index) {
        return this.getFlag(index);
    }

    protected boolean getFlag(int index) {
        if (this.characterStyle == null) {
            return false;
        }
        BitMaskTextProp prop = (BitMaskTextProp)this.characterStyle.findByName("char_flags");
        if (prop == null || !prop.getSubPropMatches()[index]) {
            int txtype = this.parentParagraph.getRunType();
            HSLFSheet sheet = this.parentParagraph.getSheet();
            if (sheet != null) {
                HSLFMasterSheet master = sheet.getMasterSheet();
                if (master != null) {
                    prop = (BitMaskTextProp)master.getStyleAttribute(txtype, this.parentParagraph.getIndentLevel(), "char_flags", true);
                }
            } else {
                this.logger.log(5, "MasterSheet is not available");
            }
        }
        return prop == null ? false : prop.getSubValue(index);
    }

    private void setCharFlagsTextPropVal(int index, boolean value) {
        if (this.getFlag(index) != value) {
            this.setFlag(index, value);
            this.parentParagraph.setDirty();
        }
    }

    public void setCharTextPropVal(String propName, Integer val) {
        HSLFTextParagraph.setPropVal(this.characterStyle, propName, val);
        this.parentParagraph.setDirty();
    }

    @Override
    public boolean isBold() {
        return this.isCharFlagsTextPropVal(0);
    }

    @Override
    public void setBold(boolean bold) {
        this.setCharFlagsTextPropVal(0, bold);
    }

    @Override
    public boolean isItalic() {
        return this.isCharFlagsTextPropVal(1);
    }

    @Override
    public void setItalic(boolean italic) {
        this.setCharFlagsTextPropVal(1, italic);
    }

    @Override
    public boolean isUnderlined() {
        return this.isCharFlagsTextPropVal(2);
    }

    @Override
    public void setUnderlined(boolean underlined) {
        this.setCharFlagsTextPropVal(2, underlined);
    }

    public boolean isShadowed() {
        return this.isCharFlagsTextPropVal(4);
    }

    public void setShadowed(boolean flag) {
        this.setCharFlagsTextPropVal(4, flag);
    }

    public boolean isEmbossed() {
        return this.isCharFlagsTextPropVal(9);
    }

    public void setEmbossed(boolean flag) {
        this.setCharFlagsTextPropVal(9, flag);
    }

    @Override
    public boolean isStrikethrough() {
        return this.isCharFlagsTextPropVal(8);
    }

    @Override
    public void setStrikethrough(boolean flag) {
        this.setCharFlagsTextPropVal(8, flag);
    }

    public int getSuperscript() {
        TextProp tp = HSLFTextParagraph.getPropVal(this.characterStyle, "superscript", this.parentParagraph);
        return tp == null ? 0 : tp.getValue();
    }

    public void setSuperscript(int val) {
        this.setCharTextPropVal("superscript", val);
    }

    @Override
    public Double getFontSize() {
        TextProp tp = HSLFTextParagraph.getPropVal(this.characterStyle, "font.size", this.parentParagraph);
        return tp == null ? null : Double.valueOf(tp.getValue());
    }

    @Override
    public void setFontSize(Double fontSize) {
        Integer iFontSize = fontSize == null ? null : Integer.valueOf(fontSize.intValue());
        this.setCharTextPropVal("font.size", iFontSize);
    }

    public int getFontIndex() {
        TextProp tp = HSLFTextParagraph.getPropVal(this.characterStyle, "font.index", this.parentParagraph);
        return tp == null ? -1 : tp.getValue();
    }

    public void setFontIndex(int idx) {
        this.setCharTextPropVal("font.index", idx);
    }

    @Override
    public void setFontFamily(String fontFamily) {
        HSLFSlideShow slideShow;
        HSLFSheet sheet = this.parentParagraph.getSheet();
        HSLFSlideShow hSLFSlideShow = slideShow = sheet == null ? null : sheet.getSlideShow();
        if (sheet == null || slideShow == null) {
            this._fontFamily = fontFamily;
            return;
        }
        Integer fontIdx = fontFamily == null ? null : Integer.valueOf(slideShow.getFontCollection().addFont(fontFamily));
        this.setCharTextPropVal("font.index", fontIdx);
    }

    @Override
    public String getFontFamily() {
        HSLFSlideShow slideShow;
        HSLFSheet sheet = this.parentParagraph.getSheet();
        HSLFSlideShow hSLFSlideShow = slideShow = sheet == null ? null : sheet.getSlideShow();
        if (sheet == null || slideShow == null) {
            return this._fontFamily;
        }
        TextProp tp = HSLFTextParagraph.getPropVal(this.characterStyle, "font.index,asian.font.index,ansi.font.index,symbol.font.index", this.parentParagraph);
        if (tp == null) {
            return null;
        }
        return slideShow.getFontCollection().getFontWithId(tp.getValue());
    }

    @Override
    public PaintStyle.SolidPaint getFontColor() {
        TextProp tp = HSLFTextParagraph.getPropVal(this.characterStyle, "font.color", this.parentParagraph);
        if (tp == null) {
            return null;
        }
        Color color = HSLFTextParagraph.getColorFromColorIndexStruct(tp.getValue(), this.parentParagraph.getSheet());
        PaintStyle.SolidPaint ps = DrawPaint.createSolidPaint(color);
        return ps;
    }

    public void setFontColor(int bgr) {
        this.setCharTextPropVal("font.color", bgr);
    }

    @Override
    public void setFontColor(Color color) {
        this.setFontColor(DrawPaint.createSolidPaint(color));
    }

    @Override
    public void setFontColor(PaintStyle color) {
        if (!(color instanceof PaintStyle.SolidPaint)) {
            throw new IllegalArgumentException("HSLF only supports solid paint");
        }
        PaintStyle.SolidPaint sp = (PaintStyle.SolidPaint)color;
        Color c = DrawPaint.applyColorTransform(sp.getSolidColor());
        int rgb = new Color(c.getBlue(), c.getGreen(), c.getRed(), 254).getRGB();
        this.setFontColor(rgb);
    }

    protected void setFlag(int index, boolean value) {
        BitMaskTextProp prop = (BitMaskTextProp)this.characterStyle.addWithName("char_flags");
        prop.setSubValue(value, index);
    }

    public HSLFTextParagraph getTextParagraph() {
        return this.parentParagraph;
    }

    @Override
    public TextRun.TextCap getTextCap() {
        return TextRun.TextCap.NONE;
    }

    @Override
    public boolean isSubscript() {
        return this.getSuperscript() < 0;
    }

    @Override
    public boolean isSuperscript() {
        return this.getSuperscript() > 0;
    }

    @Override
    public byte getPitchAndFamily() {
        return 0;
    }

    protected void setHyperlink(HSLFHyperlink link) {
        this.link = link;
    }

    public HSLFHyperlink getHyperlink() {
        return this.link;
    }

    public HSLFHyperlink createHyperlink() {
        if (this.link == null) {
            this.link = HSLFHyperlink.createHyperlink(this);
            this.parentParagraph.setDirty();
        }
        return this.link;
    }
}

