/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.netcdf.impl;

import java.lang.reflect.Array;
import org.apache.sis.internal.jdk8.Function;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Utilities;

final class Attribute {
    static final Function<Attribute, String> NAME_FUNCTION = new Function<Attribute, String>(){

        @Override
        public String apply(Attribute attribute) {
            return attribute.name;
        }
    };
    final String name;
    final Object value;

    Attribute(String string, Object object) {
        this.name = string;
        this.value = object;
    }

    final String[] stringValues() {
        if (this.value instanceof String) {
            return new String[]{(String)this.value};
        }
        String[] stringArray = new String[Array.getLength(this.value)];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = Array.get(this.value, i).toString();
        }
        return stringArray;
    }

    final Number[] numberValues() {
        Number[] numberArray = new Number[this.value instanceof String ? 0 : Array.getLength(this.value)];
        for (int i = 0; i < numberArray.length; ++i) {
            numberArray[i] = (Number)Array.get(this.value, i);
        }
        return numberArray;
    }

    final boolean booleanValue() {
        return this.value instanceof String && Boolean.valueOf((String)this.value) != false;
    }

    static String dateToISO(String string) {
        if ((string = CharSequences.trimWhitespaces(string)) != null && !string.isEmpty()) {
            boolean bl;
            int n = string.lastIndexOf(84) + 1;
            int n2 = string.length();
            int n3 = 2;
            boolean bl2 = bl = string.charAt(n2 - 1) == 'Z';
            if (n != 0) {
                int n4;
                if (bl) {
                    --n2;
                } else {
                    n4 = Math.max(string.indexOf(43, n), string.indexOf(45, n));
                    bl = n4 >= 0;
                    if (bl) {
                        n2 = n4;
                    }
                }
                for (n4 = n; n4 < n2 && (string.charAt(n4) != ':' || --n3 != 0); ++n4) {
                }
            }
            CharSequence charSequence = string;
            if (n3 != 0 || !bl) {
                StringBuilder stringBuilder = new StringBuilder(string);
                stringBuilder.setLength(n2);
                if (n == 0) {
                    stringBuilder.append("T00");
                }
                while (--n3 >= 0) {
                    stringBuilder.append(":00");
                }
                if (bl) {
                    stringBuilder.append(string, n2, string.length());
                } else {
                    stringBuilder.append('Z');
                }
                charSequence = stringBuilder;
            }
            int n5 = 0;
            int n6 = charSequence.length();
            while (--n6 >= 0) {
                boolean bl3;
                char c = charSequence.charAt(n6);
                boolean bl4 = bl3 = c >= '0' && c <= '9';
                if (n5 == 0) {
                    if (!bl3) continue;
                    n5 = n6;
                    continue;
                }
                if (bl3) continue;
                if (n5 - n6 == 1) {
                    StringBuilder stringBuilder;
                    if (charSequence == string) {
                        stringBuilder = new StringBuilder(string);
                        charSequence = stringBuilder;
                    } else {
                        stringBuilder = (StringBuilder)charSequence;
                    }
                    stringBuilder.insert(n6 + 1, '0');
                }
                n5 = 0;
            }
            string = charSequence.toString();
        }
        return string;
    }

    public String toString() {
        return this.name + " = " + Utilities.deepToString(this.value);
    }
}

