/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import java.io.Serializable;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.NameMeaning;
import org.apache.sis.io.wkt.Convention;
import org.apache.sis.io.wkt.ElementKind;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.io.wkt.Formatter;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;

@XmlRootElement(name="RS_Identifier")
public class ImmutableIdentifier
extends FormattableObject
implements ReferenceIdentifier,
Serializable {
    private static final long serialVersionUID = -7681717592582493409L;
    public static final String DESCRIPTION_KEY = "description";
    @XmlElement(required=true)
    private final String code;
    @XmlElement(required=true)
    private final String codeSpace;
    @XmlElement(required=true)
    private final Citation authority;
    @XmlElement
    private final String version;
    private final InternationalString description;

    public ImmutableIdentifier(ReferenceIdentifier referenceIdentifier) {
        ArgumentChecks.ensureNonNull("identifier", referenceIdentifier);
        this.code = referenceIdentifier.getCode();
        this.codeSpace = referenceIdentifier.getCodeSpace();
        this.authority = referenceIdentifier.getAuthority();
        this.version = referenceIdentifier.getVersion();
        this.description = referenceIdentifier instanceof DefaultIdentifier ? ((DefaultIdentifier)((Object)referenceIdentifier)).getDescription() : null;
        this.validate(null);
    }

    public ImmutableIdentifier(Citation citation, String string, String string2) {
        this(citation, string, string2, null, null);
    }

    public ImmutableIdentifier(Citation citation, String string, String string2, String string3, InternationalString internationalString) {
        this.code = string2;
        this.codeSpace = string;
        this.authority = citation;
        this.version = string3;
        this.description = internationalString;
        this.validate(null);
    }

    public ImmutableIdentifier(Map<String, ?> map) throws IllegalArgumentException {
        ArgumentChecks.ensureNonNull("properties", map);
        this.code = CharSequences.trimWhitespaces(Containers.property(map, "code", String.class));
        this.version = CharSequences.trimWhitespaces(Containers.property(map, "version", String.class));
        this.description = Types.toInternationalString(map, DESCRIPTION_KEY);
        Object obj = map.get("authority");
        if (obj instanceof String) {
            this.authority = Citations.fromName((String)obj);
        } else if (obj == null || obj instanceof Citation) {
            this.authority = (Citation)obj;
        } else {
            throw ImmutableIdentifier.illegalPropertyType(map, "authority", obj);
        }
        obj = map.get("codespace");
        if (obj == null && !map.containsKey("codespace")) {
            this.codeSpace = org.apache.sis.internal.util.Citations.getCodeSpace(this.authority);
        } else if (obj instanceof String) {
            this.codeSpace = CharSequences.trimWhitespaces((String)obj);
        } else {
            throw ImmutableIdentifier.illegalPropertyType(map, "codespace", obj);
        }
        this.validate(map);
    }

    private void validate(Map<String, ?> map) {
        if (this.code == null || this.code.isEmpty()) {
            throw new IllegalArgumentException(Errors.getResources(map).getString(this.code == null ? (short)64 : 23, "code"));
        }
    }

    private static IllegalArgumentException illegalPropertyType(Map<String, ?> map, String string, Object object) {
        return new IllegalArgumentException(Errors.getResources(map).getString((short)40, string, object.getClass()));
    }

    public static ImmutableIdentifier castOrCopy(ReferenceIdentifier referenceIdentifier) {
        if (referenceIdentifier == null || referenceIdentifier instanceof ImmutableIdentifier) {
            return (ImmutableIdentifier)referenceIdentifier;
        }
        return new ImmutableIdentifier(referenceIdentifier);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getCodeSpace() {
        return this.codeSpace;
    }

    @Override
    public Citation getAuthority() {
        return this.authority;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    @Deprecated
    public InternationalString getRemarks() {
        return this.description;
    }

    @Deprecated
    public boolean isDeprecated() {
        return false;
    }

    public int hashCode() {
        int n = -1925158113;
        if (this.code != null) {
            n ^= this.code.hashCode();
        }
        if (this.codeSpace != null) {
            n = n * 31 + this.codeSpace.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            ImmutableIdentifier immutableIdentifier = (ImmutableIdentifier)object;
            return Objects.equals(this.code, immutableIdentifier.code) && Objects.equals(this.codeSpace, immutableIdentifier.codeSpace) && Objects.equals(this.authority, immutableIdentifier.authority) && Objects.equals(this.version, immutableIdentifier.version) && Objects.equals(this.description, immutableIdentifier.description);
        }
        return false;
    }

    @Override
    protected String formatTo(Formatter formatter) {
        String string = null;
        String string2 = this.getCode();
        if (string2 != null) {
            String string3;
            String string4 = this.getCodeSpace();
            Citation citation = this.getAuthority();
            String string5 = string3 = string4 != null ? string4 : org.apache.sis.internal.util.Citations.getIdentifier(citation, true);
            if (string3 != null) {
                Convention convention = formatter.getConvention();
                if (convention.majorVersion() == 1) {
                    string = "Authority";
                    formatter.append(string3, ElementKind.IDENTIFIER);
                    formatter.append(string2, ElementKind.IDENTIFIER);
                } else {
                    String string6;
                    boolean bl;
                    string = "Id";
                    formatter.append(string3, ElementKind.IDENTIFIER);
                    ImmutableIdentifier.appendCode(formatter, string2);
                    String string7 = this.getVersion();
                    if (string7 != null) {
                        ImmutableIdentifier.appendCode(formatter, string7);
                    }
                    FormattableObject formattableObject = formatter.getEnclosingElement(1);
                    boolean bl2 = bl = formatter.getEnclosingElement(2) == null;
                    if (!(!bl && formattableObject instanceof ParameterValue || (string6 = org.apache.sis.internal.util.Citations.getIdentifier(citation, false)) == null || string6.equals(string3))) {
                        formatter.append(new Cite(string6));
                    }
                    if (bl && formattableObject != null && convention != Convention.INTERNAL && NameMeaning.usesURN(string3) && (string6 = NameMeaning.toObjectType(formattableObject.getClass())) != null) {
                        formatter.append(new URI(string6, string3, string7, string2));
                    }
                }
            }
        }
        return string;
    }

    private static void appendCode(Formatter formatter, String string) {
        if (string != null) {
            long l;
            try {
                l = Long.parseLong(string);
            }
            catch (NumberFormatException numberFormatException) {
                formatter.append(string, ElementKind.IDENTIFIER);
                return;
            }
            formatter.append(l);
        }
    }

    private ImmutableIdentifier() {
        this.code = null;
        this.codeSpace = null;
        this.authority = null;
        this.version = null;
        this.description = null;
    }

    private static final class URI
    extends FormattableObject {
        private final String type;
        private final String codeSpace;
        private final String version;
        private final String code;

        URI(String string, String string2, String string3, String string4) {
            this.type = string;
            this.codeSpace = string2;
            this.version = string3;
            this.code = string4;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            StringBuilder stringBuilder = new StringBuilder("urn:ogc:def").append(':').append(this.type).append(':').append(this.codeSpace).append(':');
            if (this.version != null) {
                stringBuilder.append(this.version);
            }
            stringBuilder.append(':').append(this.code);
            formatter.append(stringBuilder.toString(), null);
            return "URI";
        }
    }

    private static final class Cite
    extends FormattableObject {
        private final String identifier;

        Cite(String string) {
            this.identifier = string;
        }

        @Override
        protected String formatTo(Formatter formatter) {
            formatter.append(this.identifier, ElementKind.CITATION);
            return "Citation";
        }
    }
}

