/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.internal.util.Utilities;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform2D;
import org.apache.sis.referencing.operation.transform.ContextualParameters;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.ComparisonMode;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public abstract class NormalizedProjection
extends AbstractMathTransform2D
implements Serializable {
    private static final long serialVersionUID = 1969740225939106310L;
    static final double ANGULAR_TOLERANCE = 1.5706706731410455E-9;
    static final double ITERATION_TOLERANCE = 3.926676682852614E-10;
    static final int MAXIMUM_ITERATIONS = 15;
    private static final Map<Class<?>, ParameterDescriptorGroup> DESCRIPTORS = new HashMap();
    final ContextualParameters context;
    protected final double excentricity;
    protected final double excentricitySquared;
    private final MathTransform2D inverse;

    protected NormalizedProjection(OperationMethod operationMethod, Parameters parameters, Map<ParameterRole, ? extends ParameterDescriptor<? extends Number>> map) {
        this(new Initializer(operationMethod, parameters, map, 0));
    }

    NormalizedProjection(Initializer initializer) {
        this.context = initializer.context;
        this.excentricitySquared = initializer.excentricitySquared.value;
        this.excentricity = Math.sqrt(this.excentricitySquared);
        this.inverse = new Inverse();
    }

    NormalizedProjection(NormalizedProjection normalizedProjection) {
        this.context = normalizedProjection.context;
        this.excentricity = normalizedProjection.excentricity;
        this.excentricitySquared = normalizedProjection.excentricitySquared;
        this.inverse = new Inverse();
    }

    static boolean identMatch(OperationMethod operationMethod, String string, String string2) {
        if (string2 != null) {
            for (ReferenceIdentifier referenceIdentifier : operationMethod.getIdentifiers()) {
                if (!"EPSG".equals(referenceIdentifier.getCodeSpace())) continue;
                return string2.equals(referenceIdentifier.getCode());
            }
        }
        return operationMethod.getName().getCode().replace('_', ' ').matches(string);
    }

    public MathTransform createMapProjection(MathTransformFactory mathTransformFactory) throws FactoryException {
        return this.context.completeTransform(mathTransformFactory, this);
    }

    @Override
    protected final ContextualParameters getContextualParameters() {
        return this.context;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        ParameterValueGroup parameterValueGroup = this.getParameterDescriptors().createValue();
        parameterValueGroup.parameter("excentricity").setValue(this.excentricity);
        String[] stringArray = this.getInternalParameterNames();
        double[] dArray = this.getInternalParameterValues();
        for (int i = 0; i < stringArray.length; ++i) {
            parameterValueGroup.parameter(stringArray[i]).setValue(dArray[i]);
        }
        return parameterValueGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        ParameterDescriptorGroup parameterDescriptorGroup;
        Class<?> clazz = this.getClass();
        while (!Modifier.isPublic(clazz.getModifiers())) {
            clazz = clazz.getSuperclass();
        }
        Map<Class<?>, ParameterDescriptorGroup> map = DESCRIPTORS;
        synchronized (map) {
            parameterDescriptorGroup = DESCRIPTORS.get(clazz);
            if (parameterDescriptorGroup == null) {
                ParameterBuilder parameterBuilder = new ParameterBuilder().setRequired(true);
                if (Utilities.isSIS(clazz)) {
                    parameterBuilder.setCodeSpace(Citations.SIS, "SIS");
                }
                String[] stringArray = this.getInternalParameterNames();
                GeneralParameterDescriptor[] generalParameterDescriptorArray = new ParameterDescriptor[stringArray.length + 1];
                for (int i = 0; i < generalParameterDescriptorArray.length; ++i) {
                    ParameterDescriptorGroup parameterDescriptorGroup2;
                    ParameterDescriptor<Object> parameterDescriptor = i == 0 ? ((parameterDescriptorGroup2 = CollectionsExt.first(DESCRIPTORS.values())) != null ? (ParameterDescriptor<Object>)parameterDescriptorGroup2.descriptor("excentricity") : ((ParameterBuilder)parameterBuilder.addName(Citations.SIS, "excentricity")).createBounded(0.0, 1.0, Double.NaN, null)) : ((ParameterBuilder)parameterBuilder.addName(stringArray[i - 1])).create(Double.class, null);
                    generalParameterDescriptorArray[i] = parameterDescriptor;
                }
                parameterDescriptorGroup = ((ParameterBuilder)parameterBuilder.addName(CharSequences.camelCaseToSentence(clazz.getSimpleName()))).createGroup(1, 1, generalParameterDescriptorArray);
                DESCRIPTORS.put(clazz, parameterDescriptorGroup);
            }
        }
        return parameterDescriptorGroup;
    }

    String[] getInternalParameterNames() {
        return CharSequences.EMPTY_ARRAY;
    }

    double[] getInternalParameterValues() {
        return null;
    }

    @Override
    public abstract Matrix transform(double[] var1, int var2, double[] var3, int var4, boolean var5) throws ProjectionException;

    protected abstract void inverseTransform(double[] var1, int var2, double[] var3, int var4) throws ProjectionException;

    @Override
    public MathTransform2D inverse() {
        return this.inverse;
    }

    @Override
    protected int computeHashCode() {
        long l = Double.doubleToLongBits(this.excentricity);
        double[] dArray = this.getInternalParameterValues();
        if (dArray != null) {
            for (int i = 0; i < dArray.length; ++i) {
                l = l * 31L + Double.doubleToLongBits(dArray[i]);
            }
        }
        return super.computeHashCode() ^ Numerics.hashCode(l);
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        double[] dArray;
        if (object == this) {
            return true;
        }
        if (!super.equals(object, comparisonMode)) {
            return false;
        }
        NormalizedProjection normalizedProjection = (NormalizedProjection)object;
        switch (comparisonMode) {
            case STRICT: 
            case BY_CONTRACT: {
                if (!Objects.equals(this.context, normalizedProjection.context)) {
                    return false;
                }
            }
            case IGNORE_METADATA: {
                if (Numerics.equals(this.excentricitySquared, normalizedProjection.excentricitySquared)) break;
                return false;
            }
            default: {
                double d = Math.max(this.excentricity, normalizedProjection.excentricity);
                if (Numerics.epsilonEqual(this.excentricity, normalizedProjection.excentricity, 1.5706706731410455E-9 * (1.0 / d - d))) break;
                assert (comparisonMode != ComparisonMode.DEBUG) : Numerics.messageForDifference("excentricity", this.excentricity, normalizedProjection.excentricity);
                return false;
            }
        }
        if ((dArray = this.getInternalParameterValues()) != null) {
            double[] dArray2 = normalizedProjection.getInternalParameterValues();
            assert (dArray2.length == dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                if (Numerics.epsilonEqual(dArray[i], dArray2[i], comparisonMode)) continue;
                assert (comparisonMode != ComparisonMode.DEBUG) : Numerics.messageForDifference(this.getInternalParameterNames()[i], dArray[i], dArray2[i]);
                return false;
            }
        }
        return true;
    }

    private final class Inverse
    extends AbstractMathTransform2D.Inverse {
        private static final long serialVersionUID = -9138242780765956870L;

        public Inverse() {
            super(NormalizedProjection.this);
        }

        @Override
        public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws TransformException {
            if (!bl) {
                NormalizedProjection.this.inverseTransform(dArray, n, dArray2, n2);
                return null;
            }
            if (dArray2 == null) {
                dArray2 = new double[2];
                n2 = 0;
            }
            NormalizedProjection.this.inverseTransform(dArray, n, dArray2, n2);
            return Matrices.inverse(NormalizedProjection.this.transform(dArray2, n2, null, 0, true));
        }
    }

    protected static enum ParameterRole {
        SEMI_MAJOR,
        SEMI_MINOR,
        LATITUDE_OF_CONFORMAL_SPHERE_RADIUS,
        CENTRAL_MERIDIAN,
        SCALE_FACTOR,
        FALSE_EASTING,
        FALSE_WESTING,
        FALSE_NORTHING,
        FALSE_SOUTHING;

    }
}

