/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.POIXMLDocument;
import org.apache.poi.POIXMLTextExtractor;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.openxml4j.opc.internal.FileHelper;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.xwpf.usermodel.XWPFRelation;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.ooxml.MetadataExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.xmlbeans.XmlException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class AbstractOOXMLExtractor
implements OOXMLExtractor {
    static final String RELATION_AUDIO = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/audio";
    static final String RELATION_IMAGE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image";
    static final String RELATION_OLE_OBJECT = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/oleObject";
    static final String RELATION_PACKAGE = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package";
    static final String RELATION_MACRO = "http://schemas.microsoft.com/office/2006/relationships/vbaProject";
    static final String RELATION_OFFICE_DOCUMENT = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument";
    private static final String TYPE_OLE_OBJECT = "application/vnd.openxmlformats-officedocument.oleObject";
    protected static final String[] EMBEDDED_RELATIONSHIPS = new String[]{"http://schemas.openxmlformats.org/officeDocument/2006/relationships/audio", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/package", "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument"};
    private final EmbeddedDocumentExtractor embeddedExtractor;
    protected POIXMLTextExtractor extractor;

    public AbstractOOXMLExtractor(ParseContext context, POIXMLTextExtractor extractor) {
        this.extractor = extractor;
        this.embeddedExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
    }

    @Override
    public POIXMLDocument getDocument() {
        return this.extractor.getDocument();
    }

    @Override
    public MetadataExtractor getMetadataExtractor() {
        return new MetadataExtractor(this.extractor);
    }

    @Override
    public void getXHTML(ContentHandler handler, Metadata metadata, ParseContext context) throws SAXException, XmlException, IOException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        this.buildXHTML(xhtml);
        this.handleEmbeddedParts(handler, metadata);
        this.handleThumbnail(handler);
        xhtml.endDocument();
    }

    protected String getJustFileName(String desc) {
        int idx = desc.lastIndexOf(47);
        if (idx != -1) {
            desc = desc.substring(idx + 1);
        }
        if ((idx = desc.lastIndexOf(46)) != -1) {
            desc = desc.substring(0, idx);
        }
        return desc;
    }

    private void handleThumbnail(ContentHandler handler) {
        try {
            OPCPackage opcPackage = this.extractor.getPackage();
            for (PackageRelationship rel : opcPackage.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail")) {
                PackagePart tPart = opcPackage.getPart(rel);
                InputStream tStream = tPart.getInputStream();
                Metadata thumbnailMetadata = new Metadata();
                String thumbName = tPart.getPartName().getName();
                thumbnailMetadata.set("resourceName", thumbName);
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("http://www.w3.org/1999/xhtml", "class", "class", "CDATA", "embedded");
                attributes.addAttribute("http://www.w3.org/1999/xhtml", "id", "id", "CDATA", thumbName);
                handler.startElement("http://www.w3.org/1999/xhtml", "div", "div", attributes);
                handler.endElement("http://www.w3.org/1999/xhtml", "div", "div");
                thumbnailMetadata.set("embeddedRelationshipId", thumbName);
                thumbnailMetadata.set("Content-Type", tPart.getContentType());
                thumbnailMetadata.set(TikaCoreProperties.TITLE, tPart.getPartName().getName());
                if (this.embeddedExtractor.shouldParseEmbedded(thumbnailMetadata)) {
                    this.embeddedExtractor.parseEmbedded(TikaInputStream.get(tStream), new EmbeddedContentHandler(handler), thumbnailMetadata, false);
                }
                tStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleEmbeddedParts(ContentHandler handler, Metadata metadata) throws TikaException, IOException, SAXException {
        HashSet<String> seen = new HashSet<String>();
        try {
            for (PackagePart source : this.getMainDocumentParts()) {
                if (source == null) continue;
                for (PackageRelationship rel : source.getRelationships()) {
                    try {
                        this.handleEmbeddedPart(source, rel, handler, metadata, seen);
                    }
                    catch (Exception e) {
                        if (e instanceof SAXException) {
                            throw e;
                        }
                        EmbeddedDocumentUtil.recordEmbeddedStreamException(e, metadata);
                    }
                }
            }
        }
        catch (InvalidFormatException e) {
            throw new TikaException("Broken OOXML file", e);
        }
    }

    private void handleEmbeddedPart(PackagePart source, PackageRelationship rel, ContentHandler handler, Metadata parentMetadata, Set<String> seen) throws IOException, SAXException, TikaException, InvalidFormatException {
        PackagePart target;
        String sourceDesc;
        URI sourceURI;
        URI targetURI = rel.getTargetURI();
        if (targetURI != null) {
            if (seen.contains(targetURI.toString())) {
                return;
            }
            seen.add(targetURI.toString());
        }
        sourceDesc = (sourceURI = rel.getSourceURI()) != null ? ((sourceDesc = this.getJustFileName(sourceURI.getPath())).startsWith("slide") ? sourceDesc + "_" : "") : "";
        if (rel.getTargetMode() != TargetMode.INTERNAL) {
            return;
        }
        try {
            target = source.getRelatedPart(rel);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        String type = rel.getRelationshipType();
        if (RELATION_OLE_OBJECT.equals(type) && TYPE_OLE_OBJECT.equals(target.getContentType())) {
            this.handleEmbeddedOLE(target, handler, sourceDesc + rel.getId(), parentMetadata);
        } else if (RELATION_AUDIO.equals(type) || RELATION_IMAGE.equals(type) || RELATION_PACKAGE.equals(type) || RELATION_OLE_OBJECT.equals(type)) {
            this.handleEmbeddedFile(target, handler, sourceDesc + rel.getId());
        } else if (RELATION_MACRO.equals(type)) {
            this.handleMacros(target, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEmbeddedOLE(PackagePart part, ContentHandler handler, String rel, Metadata parentMetadata) throws IOException, SAXException {
        if (part.getSize() >= 0L && part.getSize() < 1536L) {
            return;
        }
        InputStream is = part.getInputStream();
        POIFSFileSystem fs = null;
        try {
            fs = new POIFSFileSystem(part.getInputStream());
        }
        catch (Exception e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException(e, parentMetadata);
            return;
        }
        TikaInputStream stream = null;
        try {
            Metadata metadata = new Metadata();
            metadata.set("embeddedRelationshipId", rel);
            DirectoryNode root = fs.getRoot();
            OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(root);
            if (root.hasEntry("CONTENTS") && root.hasEntry("\u0001Ole") && root.hasEntry("\u0001CompObj")) {
                stream = TikaInputStream.get(fs.createDocumentInputStream("CONTENTS"));
                if (this.embeddedExtractor.shouldParseEmbedded(metadata)) {
                    this.embeddedExtractor.parseEmbedded(stream, new EmbeddedContentHandler(handler), metadata, false);
                }
            } else if (OfficeParser.POIFSDocumentType.OLE10_NATIVE == type) {
                byte[] data;
                Ole10Native ole = Ole10Native.createFromEmbeddedOleObject(fs);
                if (ole.getLabel() != null) {
                    metadata.set("resourceName", ole.getLabel());
                }
                if (ole.getCommand() != null) {
                    metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getCommand());
                }
                if (ole.getFileName() != null) {
                    metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getFileName());
                }
                if ((data = ole.getDataBuffer()) != null) {
                    stream = TikaInputStream.get(data);
                }
                if (stream != null && this.embeddedExtractor.shouldParseEmbedded(metadata)) {
                    this.embeddedExtractor.parseEmbedded(stream, new EmbeddedContentHandler(handler), metadata, false);
                }
            } else {
                this.handleEmbeddedFile(part, handler, rel);
            }
        }
        catch (FileNotFoundException e) {
        }
        catch (Ole10NativeException e) {
        }
        catch (IOException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException(e, parentMetadata);
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            if (stream != null) {
                stream.close();
            }
        }
    }

    protected void handleEmbeddedFile(PackagePart part, ContentHandler handler, String rel) throws SAXException, IOException {
        Metadata metadata = new Metadata();
        metadata.set("embeddedRelationshipId", rel);
        String name = part.getPartName().getName();
        metadata.set("resourceName", name.substring(name.lastIndexOf(47) + 1));
        metadata.set("Content-Type", part.getContentType());
        if (this.embeddedExtractor.shouldParseEmbedded(metadata)) {
            try (TikaInputStream tis = TikaInputStream.get(part.getInputStream());){
                this.embeddedExtractor.parseEmbedded(tis, new EmbeddedContentHandler(handler), metadata, false);
            }
        }
    }

    protected abstract void buildXHTML(XHTMLContentHandler var1) throws SAXException, XmlException, IOException;

    protected abstract List<PackagePart> getMainDocumentParts() throws TikaException;

    void handleMacros(PackagePart macroPart, ContentHandler handler) throws TikaException, SAXException {
        try (InputStream is = macroPart.getInputStream();
             NPOIFSFileSystem npoifs = new NPOIFSFileSystem(is);){
            OfficeParser.extractMacros(npoifs, handler, this.embeddedExtractor);
        }
        catch (IOException e) {
            throw new TikaException("Broken OOXML file", e);
        }
    }

    protected Map<String, String> loadLinkedRelationships(PackagePart bodyPart, boolean includeInternal, Metadata metadata) {
        HashMap<String, String> linkedRelationships = new HashMap<String, String>();
        try {
            PackageRelationshipCollection prc = bodyPart.getRelationshipsByType(XWPFRelation.HYPERLINK.getRelation());
            for (int i = 0; i < prc.size(); ++i) {
                String url;
                PackageRelationship pr = prc.getRelationship(i);
                if (pr == null || !includeInternal && TargetMode.INTERNAL.equals((Object)pr.getTargetMode())) continue;
                String id = pr.getId();
                String string = url = pr.getTargetURI() == null ? null : pr.getTargetURI().toString();
                if (id == null || url == null) continue;
                linkedRelationships.put(id, url);
            }
            for (String rel : EMBEDDED_RELATIONSHIPS) {
                prc = bodyPart.getRelationshipsByType(rel);
                for (int i = 0; i < prc.size(); ++i) {
                    String uriString;
                    PackageRelationship pr = prc.getRelationship(i);
                    if (pr == null) continue;
                    String id = pr.getId();
                    String fileName = uriString = pr.getTargetURI() == null ? null : pr.getTargetURI().toString();
                    if (pr.getTargetURI() != null) {
                        try {
                            fileName = FileHelper.getFilename(new File(fileName));
                        }
                        catch (Exception e) {
                            fileName = uriString;
                        }
                    }
                    if (id == null) continue;
                    fileName = fileName == null ? "" : fileName;
                    linkedRelationships.put(id, fileName);
                }
            }
        }
        catch (InvalidFormatException e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException(e, metadata);
        }
        return linkedRelationships;
    }
}

