/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.microsoft.ooxml.AbstractOOXMLExtractor;
import org.apache.tika.parser.microsoft.ooxml.OOXMLTikaBodyPartHandler;
import org.apache.tika.parser.microsoft.ooxml.OOXMLWordAndPowerPointTextHandler;
import org.apache.tika.parser.microsoft.ooxml.xslf.XSLFEventBasedPowerPointExtractor;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SXSLFPowerPointExtractorDecorator
extends AbstractOOXMLExtractor {
    private static final String HANDOUT_MASTER = "http://schemas.openxmlformats.org/officeDocument/2006/relationships/handoutMaster";
    private static final String[] MAIN_STORY_PART_RELATIONS = new String[]{XSLFRelation.MAIN.getContentType(), XSLFRelation.PRESENTATION_MACRO.getContentType(), XSLFRelation.PRESENTATIONML.getContentType(), XSLFRelation.PRESENTATIONML_TEMPLATE.getContentType(), XSLFRelation.MACRO.getContentType(), XSLFRelation.MACRO_TEMPLATE.getContentType(), XSLFRelation.THEME_MANAGER.getContentType()};
    private final OPCPackage opcPackage;
    private final ParseContext context;
    private final Metadata metadata;
    private PackagePart mainDocument = null;
    private final CommentAuthors commentAuthors = new CommentAuthors();

    public SXSLFPowerPointExtractorDecorator(Metadata metadata, ParseContext context, XSLFEventBasedPowerPointExtractor extractor) {
        super(context, extractor);
        this.metadata = metadata;
        this.context = context;
        this.opcPackage = extractor.getPackage();
        for (String contentType : MAIN_STORY_PART_RELATIONS) {
            ArrayList<PackagePart> pps = this.opcPackage.getPartsByContentType(contentType);
            if (pps.size() <= 0) continue;
            this.mainDocument = (PackagePart)pps.get(0);
            break;
        }
    }

    @Override
    protected void buildXHTML(XHTMLContentHandler xhtml) throws SAXException, IOException {
        this.loadCommentAuthors();
        try {
            PackageRelationshipCollection prc = this.mainDocument.getRelationshipsByType(XSLFRelation.SLIDE.getRelation());
            if (prc.size() == 0) {
                // empty if block
            }
            for (int i = 0; i < prc.size(); ++i) {
                this.handleSlidePart(this.mainDocument.getRelatedPart(prc.getRelationship(i)), xhtml);
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        this.handleBasicRelatedParts(XSLFRelation.SLIDE_MASTER.getRelation(), "slide-master", this.mainDocument, new PlaceHolderSkipper(new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>())));
        this.handleBasicRelatedParts(HANDOUT_MASTER, "slide-handout-master", this.mainDocument, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), new HashMap<String, String>()));
    }

    private void loadCommentAuthors() {
        PackageRelationshipCollection prc = null;
        try {
            prc = this.mainDocument.getRelationshipsByType(XSLFRelation.COMMENT_AUTHORS.getRelation());
        }
        catch (InvalidFormatException e) {
            // empty catch block
        }
        if (prc == null || prc.size() == 0) {
            return;
        }
        for (int i = 0; i < prc.size(); ++i) {
            PackagePart commentAuthorsPart = null;
            try {
                commentAuthorsPart = this.mainDocument.getRelatedPart(prc.getRelationship(i));
            }
            catch (InvalidFormatException e) {
                // empty catch block
            }
            if (commentAuthorsPart == null) continue;
            try (InputStream stream = commentAuthorsPart.getInputStream();){
                this.context.getSAXParser().parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler(new XSLFCommentAuthorHandler()));
                continue;
            }
            catch (IOException | TikaException | SAXException e) {
                // empty catch block
            }
        }
    }

    private void handleSlidePart(PackagePart slidePart, XHTMLContentHandler xhtml) throws IOException, SAXException {
        Map<String, String> linkedRelationships = this.loadLinkedRelationships(slidePart, false, this.metadata);
        xhtml.startElement("div", "class", "slide-content");
        try (InputStream stream = slidePart.getInputStream();){
            this.context.getSAXParser().parse((InputStream)new CloseShieldInputStream(stream), (DefaultHandler)new OfflineContentHandler(new EmbeddedContentHandler(new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), linkedRelationships))));
        }
        catch (TikaException e) {
            // empty catch block
        }
        xhtml.endElement("div");
        this.handleBasicRelatedParts(XSLFRelation.SLIDE_LAYOUT.getRelation(), "slide-master-content", slidePart, new PlaceHolderSkipper(new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), linkedRelationships)));
        this.handleBasicRelatedParts(XSLFRelation.NOTES.getRelation(), "slide-notes", slidePart, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), linkedRelationships));
        this.handleBasicRelatedParts(XSLFRelation.NOTES_MASTER.getRelation(), "slide-notes-master", slidePart, new OOXMLWordAndPowerPointTextHandler(new OOXMLTikaBodyPartHandler(xhtml), linkedRelationships));
        this.handleBasicRelatedParts(XSLFRelation.COMMENTS.getRelation(), null, slidePart, new XSLFCommentsHandler(xhtml));
    }

    private void handleBasicRelatedParts(String contentType, String xhtmlClassLabel, PackagePart parentPart, ContentHandler contentHandler) throws SAXException {
        PackageRelationshipCollection relatedPartPRC = null;
        try {
            relatedPartPRC = parentPart.getRelationshipsByType(contentType);
        }
        catch (InvalidFormatException e) {
            // empty catch block
        }
        if (relatedPartPRC != null && relatedPartPRC.size() > 0) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", xhtmlClassLabel);
            contentHandler.startElement("", "div", "div", attributes);
            for (int i = 0; i < relatedPartPRC.size(); ++i) {
                PackageRelationship relatedPartPackageRelationship = relatedPartPRC.getRelationship(i);
                try {
                    PackagePart relatedPartPart = parentPart.getRelatedPart(relatedPartPackageRelationship);
                    try (InputStream stream = relatedPartPart.getInputStream();){
                        this.context.getSAXParser().parse(stream, (DefaultHandler)new OfflineContentHandler(new EmbeddedContentHandler(contentHandler)));
                    }
                    catch (IOException | TikaException e) {}
                    continue;
                }
                catch (InvalidFormatException e) {
                    // empty catch block
                }
            }
            contentHandler.endElement("", "div", "div");
        }
    }

    @Override
    protected List<PackagePart> getMainDocumentParts() {
        ArrayList<PackagePart> parts = new ArrayList<PackagePart>();
        try {
            PackageRelationshipCollection prc = this.mainDocument.getRelationshipsByType(XSLFRelation.SLIDE.getRelation());
            for (int i = 0; i < prc.size(); ++i) {
                PackagePart slidePart = this.mainDocument.getRelatedPart(prc.getRelationship(i));
                this.addSlideParts(slidePart, parts);
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        parts.add(this.mainDocument);
        for (String rel : new String[]{XSLFRelation.SLIDE_MASTER.getRelation(), HANDOUT_MASTER}) {
            try {
                PackageRelationshipCollection prc = this.mainDocument.getRelationshipsByType(rel);
                for (int i = 0; i < prc.size(); ++i) {
                    PackagePart pp = this.mainDocument.getRelatedPart(prc.getRelationship(i));
                    if (pp == null) continue;
                    parts.add(pp);
                }
            }
            catch (InvalidFormatException e) {
                // empty catch block
            }
        }
        return parts;
    }

    private void addSlideParts(PackagePart slidePart, List<PackagePart> parts) {
        for (String relation : new String[]{XSLFRelation.VML_DRAWING.getRelation(), XSLFRelation.SLIDE_LAYOUT.getRelation(), XSLFRelation.NOTES_MASTER.getRelation(), XSLFRelation.NOTES.getRelation()}) {
            try {
                for (PackageRelationship packageRelationship : slidePart.getRelationshipsByType(relation)) {
                    if (packageRelationship.getTargetMode() != TargetMode.INTERNAL) continue;
                    PackagePartName relName = PackagingURIHelper.createPartName(packageRelationship.getTargetURI());
                    parts.add(packageRelationship.getPackage().getPart(relName));
                }
            }
            catch (InvalidFormatException e) {
                // empty catch block
            }
        }
        parts.add(slidePart);
    }

    private class CommentAuthors {
        Map<String, String> nameMap = new HashMap<String, String>();
        Map<String, String> initialMap = new HashMap<String, String>();

        private CommentAuthors() {
        }

        void add(String id, String name, String initials) {
            if (id == null) {
                return;
            }
            if (name != null) {
                this.nameMap.put(id, name);
            }
            if (initials != null) {
                this.initialMap.put(id, initials);
            }
        }

        String getName(String id) {
            if (id == null) {
                return null;
            }
            return this.nameMap.get(id);
        }

        String getInitials(String id) {
            if (id == null) {
                return null;
            }
            return this.initialMap.get(id);
        }
    }

    private static class PlaceHolderSkipper
    extends DefaultHandler {
        private final ContentHandler wrappedHandler;
        boolean inPH = false;

        PlaceHolderSkipper(ContentHandler wrappedHandler) {
            this.wrappedHandler = wrappedHandler;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("ph".equals(localName)) {
                this.inPH = true;
            }
            if (!this.inPH) {
                this.wrappedHandler.startElement(uri, localName, qName, atts);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.inPH) {
                this.wrappedHandler.endElement(uri, localName, qName);
            }
            if ("sp".equals(localName)) {
                this.inPH = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (!this.inPH) {
                this.wrappedHandler.characters(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            if (!this.inPH) {
                this.wrappedHandler.characters(ch, start, length);
            }
        }
    }

    private class XSLFCommentAuthorHandler
    extends DefaultHandler {
        String id = null;
        String name = null;
        String initials = null;

        private XSLFCommentAuthorHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("cmAuthor".equals(localName)) {
                for (int i = 0; i < atts.getLength(); ++i) {
                    if ("id".equals(atts.getLocalName(i))) {
                        this.id = atts.getValue(i);
                        continue;
                    }
                    if ("name".equals(atts.getLocalName(i))) {
                        this.name = atts.getValue(i);
                        continue;
                    }
                    if (!"initials".equals(atts.getLocalName(i))) continue;
                    this.initials = atts.getValue(i);
                }
                SXSLFPowerPointExtractorDecorator.this.commentAuthors.add(this.id, this.name, this.initials);
                this.id = null;
                this.name = null;
                this.initials = null;
            }
        }
    }

    private class XSLFCommentsHandler
    extends DefaultHandler {
        private String commentAuthorId = null;
        private StringBuilder commentBuffer = new StringBuilder();
        private XHTMLContentHandler xhtml;

        XSLFCommentsHandler(XHTMLContentHandler xhtml) {
            this.xhtml = xhtml;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if ("cm".equals(localName)) {
                this.commentAuthorId = atts.getValue("", "authorId");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.commentBuffer.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if ("cm".equals(localName)) {
                this.xhtml.startElement("p", "class", "slide-comment");
                String authorString = SXSLFPowerPointExtractorDecorator.this.commentAuthors.getName(this.commentAuthorId);
                String authorInitials = SXSLFPowerPointExtractorDecorator.this.commentAuthors.getInitials(this.commentAuthorId);
                if (authorString != null || authorInitials != null) {
                    this.xhtml.startElement("b");
                    boolean authorExists = false;
                    if (authorString != null) {
                        this.xhtml.characters(authorString.toString());
                        authorExists = true;
                    }
                    if (authorExists && authorInitials != null) {
                        this.xhtml.characters(" (");
                    }
                    if (authorInitials != null) {
                        this.xhtml.characters(authorInitials);
                    }
                    if (authorExists && authorInitials != null) {
                        this.xhtml.characters(")");
                    }
                    this.xhtml.endElement("b");
                }
                this.xhtml.characters(this.commentBuffer.toString());
                this.xhtml.endElement("p");
                this.commentBuffer.setLength(0);
                this.commentAuthorId = null;
            }
        }
    }
}

