/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.wordperfect;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.UnsupportedFormatException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Office;
import org.apache.tika.metadata.QuattroPro;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.parser.wordperfect.WPInputStream;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class QPWTextExtractor {
    private static final Logger LOG = LogManager.getLogger(QPWTextExtractor.class);
    private static final String OLE_DOCUMENT_NAME = "NativeContent_MAIN";
    private static final Map<Integer, Extractor> EXTRACTORS = new HashMap<Integer, Extractor>();

    QPWTextExtractor() {
    }

    public void extract(InputStream input, XHTMLContentHandler xhtml, Metadata metadata) throws IOException, SAXException, TikaException {
        POIFSFileSystem pfs = new POIFSFileSystem(input);
        DirectoryNode rootNode = pfs.getRoot();
        if (rootNode == null || !rootNode.hasEntry(OLE_DOCUMENT_NAME)) {
            throw new UnsupportedFormatException("Unsupported QuattroPro file format. Looking for OLE entry \"NativeContent_MAIN\". Found: " + rootNode.getEntryNames());
        }
        xhtml.startElement("p");
        try (WPInputStream in = new WPInputStream(pfs.createDocumentInputStream(OLE_DOCUMENT_NAME));){
            Context ctx = new Context(in, xhtml, metadata);
            while (this.hasNext(in)) {
                ctx.type = in.readWPShort();
                ctx.bodyLength = in.readWPShort();
                Extractor extractor = EXTRACTORS.get(ctx.type);
                if (extractor != null) {
                    extractor.extract(ctx);
                    continue;
                }
                Extractor.IGNORE.extract(ctx);
            }
        }
        xhtml.endElement("p");
    }

    private boolean hasNext(InputStream in) throws IOException {
        try {
            in.mark(1);
            boolean bl = in.read() != -1;
            return bl;
        }
        finally {
            in.reset();
        }
    }

    private static String getQstrLabel(WPInputStream in) throws IOException {
        int count = in.readWPShort();
        in.readWPByte();
        char[] text = new char[count + 1];
        text[0] = in.readWPChar();
        for (int i = 0; i < count; ++i) {
            text[i + 1] = in.readWPChar();
        }
        return new String(text);
    }

    static {
        EXTRACTORS.put(1, Extractor.BOF);
        EXTRACTORS.put(5, Extractor.USER);
        EXTRACTORS.put(1027, Extractor.EXT_LINK);
        EXTRACTORS.put(1031, Extractor.STRING_TABLE);
        EXTRACTORS.put(1537, Extractor.BOS);
        EXTRACTORS.put(1541, Extractor.SHEET_HEADFOOT);
        EXTRACTORS.put(1542, Extractor.SHEET_HEADFOOT);
        EXTRACTORS.put(3074, Extractor.FORMULA_STRING_VALUE);
        EXTRACTORS.put(3186, Extractor.CGENERICLABEL);
        EXTRACTORS.put(3200, Extractor.CCOMMENT);
    }

    class Context {
        private final WPInputStream in;
        private final XHTMLContentHandler xhtml;
        private final Metadata metadata;
        private int type;
        private int bodyLength;

        public Context(WPInputStream in, XHTMLContentHandler xhtml, Metadata metadata) {
            this.in = in;
            this.xhtml = xhtml;
            this.metadata = metadata;
        }
    }

    private static enum Extractor {
        IGNORE{

            @Override
            public void extract(Context ctx) throws IOException {
                ctx.in.skipWPByte(ctx.bodyLength);
            }
        }
        ,
        BOF{

            @Override
            public void extract(Context ctx) throws IOException {
                ctx.metadata.set(QuattroPro.ID, ctx.in.readWPString(4));
                ctx.metadata.set(QuattroPro.VERSION, ctx.in.readWPShort());
                ctx.metadata.set(QuattroPro.BUILD, ctx.in.readWPShort());
                ctx.in.readWPShort();
                ctx.metadata.set(QuattroPro.LOWEST_VERSION, ctx.in.readWPShort());
                ctx.metadata.set(Office.PAGE_COUNT, ctx.in.readWPShort());
                ctx.in.skipWPByte(ctx.bodyLength - 14);
            }
        }
        ,
        USER{

            @Override
            public void extract(Context ctx) throws IOException {
                ctx.metadata.set(TikaCoreProperties.CREATOR, QPWTextExtractor.getQstrLabel(ctx.in));
                ctx.metadata.set(TikaCoreProperties.MODIFIER, QPWTextExtractor.getQstrLabel(ctx.in));
            }
        }
        ,
        EXT_LINK{

            @Override
            public void extract(Context ctx) throws IOException, SAXException {
                ctx.in.readWPShort();
                ctx.in.readWPShort();
                ctx.in.readWPShort();
                ctx.xhtml.characters(QPWTextExtractor.getQstrLabel(ctx.in));
                ctx.xhtml.characters(System.lineSeparator());
            }
        }
        ,
        STRING_TABLE{

            @Override
            public void extract(Context ctx) throws IOException, SAXException {
                long entries = ctx.in.readWPLong();
                ctx.in.readWPLong();
                ctx.in.readWPLong();
                int i = 0;
                while ((long)i < entries) {
                    ctx.xhtml.characters(QPWTextExtractor.getQstrLabel(ctx.in));
                    ctx.xhtml.characters(System.lineSeparator());
                    ++i;
                }
            }
        }
        ,
        BOS{

            @Override
            public void extract(Context ctx) throws IOException, SAXException {
                ctx.in.readWPShort();
                ctx.in.readWPShort();
                ctx.in.readWPShort();
                ctx.in.readWPLong();
                ctx.in.readWPLong();
                ctx.in.readWPShort();
                ctx.in.readWPShort();
                ctx.xhtml.characters(QPWTextExtractor.getQstrLabel(ctx.in));
                ctx.xhtml.characters(System.lineSeparator());
            }
        }
        ,
        SHEET_HEADFOOT{

            @Override
            public void extract(Context ctx) throws IOException, SAXException {
                ctx.in.readWPShort();
                ctx.xhtml.characters(QPWTextExtractor.getQstrLabel(ctx.in));
                ctx.xhtml.characters(System.lineSeparator());
            }
        }
        ,
        FORMULA_STRING_VALUE{

            @Override
            public void extract(Context ctx) throws IOException, SAXException {
                ctx.in.readWPShort();
                ctx.in.readWPLong();
                ctx.xhtml.characters(QPWTextExtractor.getQstrLabel(ctx.in));
            }
        }
        ,
        CGENERICLABEL{

            @Override
            public void extract(Context ctx) throws IOException, SAXException {
                ctx.in.readWPShort();
                ctx.in.readWPLong();
                ctx.in.readWPShort();
                ctx.xhtml.characters(QPWTextExtractor.getQstrLabel(ctx.in));
            }
        }
        ,
        CCOMMENT{

            @Override
            public void extract(Context ctx) throws IOException, SAXException {
                ctx.in.readWPShort();
                ctx.in.readWPLong();
                ctx.in.readWPLong();
                ctx.xhtml.characters(QPWTextExtractor.getQstrLabel(ctx.in));
                ctx.xhtml.characters(QPWTextExtractor.getQstrLabel(ctx.in));
            }
        }
        ,
        DEBUG{

            @Override
            public void extract(Context ctx) throws IOException {
                LOG.error((Object)("REC (" + Integer.toHexString(ctx.type) + "/" + ctx.bodyLength + "):" + ctx.in.readWPString(ctx.bodyLength)));
            }
        };


        public abstract void extract(Context var1) throws IOException, SAXException;
    }
}

