/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ParseException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriInfo;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.html.HtmlParser;
import org.apache.tika.parser.ocr.TesseractOCRConfig;
import org.apache.tika.parser.pdf.PDFParserConfig;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ExpandedTitleContentHandler;
import org.apache.tika.sax.RichTextContentHandler;
import org.apache.tika.server.InputStreamFactory;
import org.apache.tika.server.TikaServerParseException;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Path(value="/tika")
public class TikaResource {
    public static final String GREETING = "This is Tika Server (" + new Tika().toString() + "). Please PUT\n";
    public static final String X_TIKA_OCR_HEADER_PREFIX = "X-Tika-OCR";
    public static final String X_TIKA_PDF_HEADER_PREFIX = "X-Tika-PDF";
    private static final Log logger = LogFactory.getLog(TikaResource.class);
    private static TikaConfig tikaConfig;
    private static DigestingParser.Digester digester;
    private static InputStreamFactory inputStreamFactory;

    public static void init(TikaConfig config, DigestingParser.Digester digestr, InputStreamFactory iSF) {
        tikaConfig = config;
        digester = digestr;
        inputStreamFactory = iSF;
    }

    public static Parser createParser() {
        final AutoDetectParser parser = new AutoDetectParser(tikaConfig);
        Map<MediaType, Parser> parsers = parser.getParsers();
        parsers.put(MediaType.APPLICATION_XML, new HtmlParser());
        parser.setParsers(parsers);
        parser.setFallback(new Parser(){

            @Override
            public Set<MediaType> getSupportedTypes(ParseContext parseContext) {
                return parser.getSupportedTypes(parseContext);
            }

            @Override
            public void parse(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, ParseContext parseContext) {
                throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
            }
        });
        if (digester != null) {
            return new DigestingParser(parser, digester);
        }
        return parser;
    }

    public static TikaConfig getConfig() {
        return tikaConfig;
    }

    public static String detectFilename(MultivaluedMap<String, String> httpHeaders) {
        String disposition = httpHeaders.getFirst("Content-Disposition");
        if (disposition != null) {
            try {
                String fn;
                ContentDisposition c = new ContentDisposition(disposition);
                if ("attachment".equals(c.getDisposition()) && (fn = c.getParameter("filename")) != null) {
                    return fn;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
                logger.warn(String.format(Locale.ROOT, "Parse exception %s determining content disposition", e.getMessage()), e);
            }
        }
        return httpHeaders.getFirst("File-Name");
    }

    public static void fillParseContext(ParseContext parseContext, MultivaluedMap<String, String> httpHeaders, Parser embeddedParser) {
        TesseractOCRConfig ocrConfig = new TesseractOCRConfig();
        PDFParserConfig pdfParserConfig = new PDFParserConfig();
        for (String key : httpHeaders.keySet()) {
            if (StringUtils.startsWith(key, X_TIKA_OCR_HEADER_PREFIX)) {
                TikaResource.processHeaderConfig(httpHeaders, ocrConfig, key, X_TIKA_OCR_HEADER_PREFIX);
                continue;
            }
            if (!StringUtils.startsWith(key, X_TIKA_PDF_HEADER_PREFIX)) continue;
            TikaResource.processHeaderConfig(httpHeaders, pdfParserConfig, key, X_TIKA_PDF_HEADER_PREFIX);
        }
        parseContext.set(TesseractOCRConfig.class, ocrConfig);
        parseContext.set(PDFParserConfig.class, pdfParserConfig);
        if (embeddedParser != null) {
            parseContext.set(Parser.class, embeddedParser);
        }
    }

    public static InputStream getInputStream(InputStream is, HttpHeaders headers) {
        try {
            return inputStreamFactory.getInputSteam(is, headers);
        }
        catch (IOException e) {
            throw new TikaServerParseException(e);
        }
    }

    private static void processHeaderConfig(MultivaluedMap<String, String> httpHeaders, Object object, String key, String prefix) {
        try {
            String property = StringUtils.removeStart(key, prefix);
            Field field = object.getClass().getDeclaredField(StringUtils.uncapitalize(property));
            field.setAccessible(true);
            if (field.getType() == String.class) {
                field.set(object, httpHeaders.getFirst(key));
            } else if (field.getType() == Integer.TYPE) {
                field.setInt(object, Integer.parseInt(httpHeaders.getFirst(key)));
            } else if (field.getType() == Double.TYPE) {
                field.setDouble(object, Double.parseDouble(httpHeaders.getFirst(key)));
            } else if (field.getType() == Boolean.TYPE) {
                field.setBoolean(object, Boolean.parseBoolean(httpHeaders.getFirst(key)));
            }
        }
        catch (Throwable ex) {
            throw new WebApplicationException(String.format(Locale.ROOT, "%s is an invalid %s header", key, X_TIKA_OCR_HEADER_PREFIX));
        }
    }

    public static void fillMetadata(Parser parser, Metadata metadata, ParseContext context, MultivaluedMap<String, String> httpHeaders) {
        String password;
        String contentTypeHeader;
        javax.ws.rs.core.MediaType mediaType;
        String fileName = TikaResource.detectFilename(httpHeaders);
        if (fileName != null) {
            metadata.set("resourceName", fileName);
        }
        javax.ws.rs.core.MediaType mediaType2 = mediaType = (contentTypeHeader = httpHeaders.getFirst("Content-Type")) == null ? null : javax.ws.rs.core.MediaType.valueOf(contentTypeHeader);
        if (mediaType != null && "xml".equals(mediaType.getSubtype())) {
            mediaType = null;
        }
        if (mediaType != null && mediaType.equals(javax.ws.rs.core.MediaType.APPLICATION_OCTET_STREAM_TYPE)) {
            mediaType = null;
        }
        if (mediaType != null) {
            metadata.add("Content-Type", mediaType.toString());
            final Detector detector = TikaResource.getDetector(parser);
            TikaResource.setDetector(parser, new Detector(){

                @Override
                public MediaType detect(InputStream inputStream, Metadata metadata) throws IOException {
                    String ct = metadata.get("Content-Type");
                    MediaType type = null;
                    if (ct != null) {
                        type = MediaType.parse(ct);
                    }
                    if (type != null) {
                        return type;
                    }
                    return detector.detect(inputStream, metadata);
                }
            });
        }
        if ((password = httpHeaders.getFirst("Password")) != null) {
            context.set(PasswordProvider.class, new PasswordProvider(){

                @Override
                public String getPassword(Metadata metadata) {
                    return password;
                }
            });
        }
    }

    public static void setDetector(Parser p, Detector detector) {
        AutoDetectParser adp = TikaResource.getAutoDetectParser(p);
        adp.setDetector(detector);
    }

    public static Detector getDetector(Parser p) {
        AutoDetectParser adp = TikaResource.getAutoDetectParser(p);
        return adp.getDetector();
    }

    private static AutoDetectParser getAutoDetectParser(Parser p) {
        if (p instanceof AutoDetectParser) {
            return (AutoDetectParser)p;
        }
        if (p instanceof ParserDecorator) {
            Parser wrapped = ((ParserDecorator)p).getWrappedParser();
            if (wrapped instanceof AutoDetectParser) {
                return (AutoDetectParser)wrapped;
            }
            throw new RuntimeException("Couldn't find AutoDetectParser within: " + wrapped.getClass());
        }
        throw new RuntimeException("Couldn't find AutoDetectParser within: " + p.getClass());
    }

    public static void parse(Parser parser, Log logger, String path, InputStream inputStream, ContentHandler handler, Metadata metadata, ParseContext parseContext) throws IOException {
        try (TikaInputStream tikaInputStream = TikaInputStream.get(inputStream);){
            parser.parse(tikaInputStream, handler, metadata, parseContext);
        }
        catch (SAXException e) {
            throw new TikaServerParseException(e);
        }
        catch (EncryptedDocumentException e) {
            logger.warn(String.format(Locale.ROOT, "%s: Encrypted document", path), e);
            throw new TikaServerParseException(e);
        }
        catch (Exception e) {
            logger.warn(String.format(Locale.ROOT, "%s: Text extraction failed", path), e);
            throw new TikaServerParseException(e);
        }
    }

    public static void logRequest(Log logger, UriInfo info, Metadata metadata) {
        if (metadata.get("Content-Type") == null) {
            logger.info(String.format(Locale.ROOT, "%s (autodetecting type)", info.getPath()));
        } else {
            logger.info(String.format(Locale.ROOT, "%s (%s)", info.getPath(), metadata.get("Content-Type")));
        }
    }

    @GET
    @Produces(value={"text/plain"})
    public String getMessage() {
        return GREETING;
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/plain"})
    @Path(value="form")
    public StreamingOutput getTextFromMultipart(Attachment att, @Context UriInfo info) {
        return this.produceText(att.getObject(InputStream.class), att.getHeaders(), info);
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    public StreamingOutput getText(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceText(TikaResource.getInputStream(is, httpHeaders), httpHeaders.getRequestHeaders(), info);
    }

    public StreamingOutput produceText(final InputStream is, MultivaluedMap<String, String> httpHeaders, final UriInfo info) {
        final Parser parser = TikaResource.createParser();
        final Metadata metadata = new Metadata();
        final ParseContext context = new ParseContext();
        TikaResource.fillMetadata(parser, metadata, context, httpHeaders);
        TikaResource.fillParseContext(context, httpHeaders, parser);
        TikaResource.logRequest(logger, info, metadata);
        return new StreamingOutput(){

            @Override
            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                BodyContentHandler body = new BodyContentHandler(new RichTextContentHandler(writer));
                try (InputStream inputStream = is;){
                    TikaResource.parse(parser, logger, info.getPath(), inputStream, body, metadata, context);
                }
            }
        };
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/html"})
    @Path(value="form")
    public StreamingOutput getHTMLFromMultipart(Attachment att, @Context UriInfo info) {
        return this.produceOutput(att.getObject(InputStream.class), att.getHeaders(), info, "html");
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/html"})
    public StreamingOutput getHTML(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceOutput(TikaResource.getInputStream(is, httpHeaders), httpHeaders.getRequestHeaders(), info, "html");
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/xml"})
    @Path(value="form")
    public StreamingOutput getXMLFromMultipart(Attachment att, @Context UriInfo info) {
        return this.produceOutput(att.getObject(InputStream.class), att.getHeaders(), info, "xml");
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"text/xml"})
    public StreamingOutput getXML(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) {
        return this.produceOutput(TikaResource.getInputStream(is, httpHeaders), httpHeaders.getRequestHeaders(), info, "xml");
    }

    private StreamingOutput produceOutput(final InputStream is, MultivaluedMap<String, String> httpHeaders, final UriInfo info, final String format) {
        final Parser parser = TikaResource.createParser();
        final Metadata metadata = new Metadata();
        final ParseContext context = new ParseContext();
        TikaResource.fillMetadata(parser, metadata, context, httpHeaders);
        TikaResource.fillParseContext(context, httpHeaders, parser);
        TikaResource.logRequest(logger, info, metadata);
        return new StreamingOutput(){

            @Override
            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                ExpandedTitleContentHandler content;
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
                try {
                    SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
                    TransformerHandler handler = factory.newTransformerHandler();
                    handler.getTransformer().setOutputProperty("method", format);
                    handler.getTransformer().setOutputProperty("indent", "yes");
                    handler.getTransformer().setOutputProperty("encoding", StandardCharsets.UTF_8.name());
                    handler.setResult(new StreamResult(writer));
                    content = new ExpandedTitleContentHandler(handler);
                }
                catch (TransformerConfigurationException e) {
                    throw new WebApplicationException(e);
                }
                TikaResource.parse(parser, logger, info.getPath(), is, content, metadata, context);
            }
        };
    }

    static {
        digester = null;
        inputStreamFactory = null;
        ExtractorFactory.setAllThreadsPreferEventExtractors(true);
    }
}

