/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.resource;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.parser.DigestingParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.RichTextContentHandler;
import org.apache.tika.server.resource.TikaResource;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Path(value="/unpack")
public class UnpackerResource {
    public static final String TEXT_FILENAME = "__TEXT__";
    private static final Log logger = LogFactory.getLog(UnpackerResource.class);
    private static final String META_FILENAME = "__METADATA__";

    public static void metadataToCsv(Metadata metadata, OutputStream outputStream) throws IOException {
        CSVWriter writer = new CSVWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
        for (String name : metadata.names()) {
            String[] values = metadata.getValues(name);
            ArrayList<String> list = new ArrayList<String>(values.length + 1);
            list.add(name);
            list.addAll(Arrays.asList(values));
            writer.writeNext(list.toArray(values));
        }
        writer.close();
    }

    @Path(value="/{id:(/.*)?}")
    @PUT
    @Produces(value={"application/zip", "application/x-tar"})
    public Map<String, byte[]> unpack(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) throws Exception {
        return this.process(TikaResource.getInputStream(is, httpHeaders), httpHeaders, info, false);
    }

    @Path(value="/all{id:(/.*)?}")
    @PUT
    @Produces(value={"application/zip", "application/x-tar"})
    public Map<String, byte[]> unpackAll(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info) throws Exception {
        return this.process(TikaResource.getInputStream(is, httpHeaders), httpHeaders, info, true);
    }

    private Map<String, byte[]> process(InputStream is, @Context HttpHeaders httpHeaders, @Context UriInfo info, boolean saveAll) throws Exception {
        Metadata metadata = new Metadata();
        ParseContext pc = new ParseContext();
        Parser parser = TikaResource.createParser();
        if (parser instanceof DigestingParser) {
            parser = ((DigestingParser)parser).getWrappedParser();
        }
        TikaResource.fillMetadata(parser, metadata, pc, httpHeaders.getRequestHeaders());
        TikaResource.logRequest(logger, info, metadata);
        ByteArrayOutputStream text = new ByteArrayOutputStream();
        DefaultHandler ch = saveAll ? new BodyContentHandler(new RichTextContentHandler(new OutputStreamWriter((OutputStream)text, StandardCharsets.UTF_8))) : new DefaultHandler();
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        MutableInt count = new MutableInt();
        pc.set(EmbeddedDocumentExtractor.class, new MyEmbeddedDocumentExtractor(count, files));
        TikaResource.parse(parser, logger, info.getPath(), is, ch, metadata, pc);
        if (count.intValue() == 0 && !saveAll) {
            throw new WebApplicationException(Response.Status.NO_CONTENT);
        }
        if (saveAll) {
            files.put(TEXT_FILENAME, text.toByteArray());
            ByteArrayOutputStream metaStream = new ByteArrayOutputStream();
            UnpackerResource.metadataToCsv(metadata, metaStream);
            files.put(META_FILENAME, metaStream.toByteArray());
        }
        return files;
    }

    private class MyEmbeddedDocumentExtractor
    implements EmbeddedDocumentExtractor {
        private final MutableInt count;
        private final Map<String, byte[]> zout;

        MyEmbeddedDocumentExtractor(MutableInt count, Map<String, byte[]> zout) {
            this.count = count;
            this.zout = zout;
        }

        @Override
        public boolean shouldParseEmbedded(Metadata metadata) {
            return true;
        }

        @Override
        public void parseEmbedded(InputStream inputStream, ContentHandler contentHandler, Metadata metadata, boolean b) throws SAXException, IOException {
            TikaInputStream tin;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOUtils.copy(inputStream, bos);
            byte[] data = bos.toByteArray();
            String name = metadata.get("resourceName");
            String contentType = metadata.get("Content-Type");
            if (name == null) {
                name = Integer.toString(this.count.intValue());
            }
            if (!name.contains(".") && contentType != null) {
                try {
                    String ext = TikaResource.getConfig().getMimeRepository().forName(contentType).getExtension();
                    if (ext != null) {
                        name = name + ext;
                    }
                }
                catch (MimeTypeException e) {
                    logger.warn("Unexpected MimeTypeException", e);
                }
            }
            if ("application/vnd.openxmlformats-officedocument.oleObject".equals(contentType)) {
                POIFSFileSystem poifs = new POIFSFileSystem(new ByteArrayInputStream(data));
                OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(poifs);
                if (type == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
                    try {
                        Ole10Native ole = Ole10Native.createFromEmbeddedOleObject(poifs);
                        if (ole.getDataSize() > 0) {
                            String label = ole.getLabel();
                            if (label.startsWith("ole-")) {
                                label = Integer.toString(this.count.intValue()) + '-' + label;
                            }
                            name = label;
                            data = ole.getDataBuffer();
                        }
                    }
                    catch (Ole10NativeException ex) {
                        logger.warn("Skipping invalid part", ex);
                    }
                } else {
                    name = name + '.' + type.getExtension();
                }
            }
            String finalName = name;
            if (data.length > 0) {
                this.zout.put(finalName, data);
                this.count.increment();
            } else if (inputStream instanceof TikaInputStream && (tin = (TikaInputStream)inputStream).getOpenContainer() != null && tin.getOpenContainer() instanceof DirectoryEntry) {
                POIFSFileSystem fs = new POIFSFileSystem();
                this.copy((DirectoryEntry)tin.getOpenContainer(), fs.getRoot());
                ByteArrayOutputStream bos2 = new ByteArrayOutputStream();
                fs.writeFilesystem(bos2);
                bos2.close();
                this.zout.put(finalName, bos2.toByteArray());
            }
        }

        protected void copy(DirectoryEntry sourceDir, DirectoryEntry destDir) throws IOException {
            for (Entry entry : sourceDir) {
                if (entry instanceof DirectoryEntry) {
                    DirectoryEntry newDir = destDir.createDirectory(entry.getName());
                    this.copy((DirectoryEntry)entry, newDir);
                    continue;
                }
                DocumentInputStream contents = new DocumentInputStream((DocumentEntry)entry);
                Throwable throwable = null;
                try {
                    destDir.createDocument(entry.getName(), contents);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (contents == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)contents).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)contents).close();
                }
            }
        }
    }
}

