/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.query;

import com.healthmarketscience.jackcess.RowId;
import com.healthmarketscience.jackcess.impl.RowIdImpl;
import com.healthmarketscience.jackcess.impl.RowImpl;
import com.healthmarketscience.jackcess.impl.query.AppendQueryImpl;
import com.healthmarketscience.jackcess.impl.query.CrossTabQueryImpl;
import com.healthmarketscience.jackcess.impl.query.DataDefinitionQueryImpl;
import com.healthmarketscience.jackcess.impl.query.DeleteQueryImpl;
import com.healthmarketscience.jackcess.impl.query.MakeTableQueryImpl;
import com.healthmarketscience.jackcess.impl.query.PassthroughQueryImpl;
import com.healthmarketscience.jackcess.impl.query.QueryFormat;
import com.healthmarketscience.jackcess.impl.query.SelectQueryImpl;
import com.healthmarketscience.jackcess.impl.query.UnionQueryImpl;
import com.healthmarketscience.jackcess.impl.query.UpdateQueryImpl;
import com.healthmarketscience.jackcess.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryImpl
implements Query {
    protected static final Log LOG = LogFactory.getLog(QueryImpl.class);
    private static final Row EMPTY_ROW = new Row();
    private final String _name;
    private final List<Row> _rows;
    private final int _objectId;
    private final Query.Type _type;
    private final int _objectFlag;

    protected QueryImpl(String name, List<Row> rows, int objectId, int objectFlag, Query.Type type) {
        short foundType;
        this._name = name;
        this._rows = rows;
        this._objectId = objectId;
        this._type = type;
        this._objectFlag = objectFlag;
        if (type != Query.Type.UNKNOWN && (foundType = QueryImpl.getShortValue(this.getQueryType(rows), this._type.getValue())) != this._type.getValue()) {
            throw new IllegalStateException(this.withErrorContext("Unexpected query type " + foundType));
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public Query.Type getType() {
        return this._type;
    }

    @Override
    public boolean isHidden() {
        return (this._objectFlag & 8) != 0;
    }

    @Override
    public int getObjectId() {
        return this._objectId;
    }

    @Override
    public int getObjectFlag() {
        return this._objectFlag;
    }

    public List<Row> getRows() {
        return this._rows;
    }

    protected List<Row> getRowsByAttribute(Byte attribute) {
        return QueryImpl.getRowsByAttribute(this.getRows(), attribute);
    }

    protected Row getRowByAttribute(Byte attribute) {
        return this.getUniqueRow(QueryImpl.getRowsByAttribute(this.getRows(), attribute));
    }

    public Row getTypeRow() {
        return this.getRowByAttribute(QueryFormat.TYPE_ATTRIBUTE);
    }

    protected List<Row> getParameterRows() {
        return this.getRowsByAttribute(QueryFormat.PARAMETER_ATTRIBUTE);
    }

    protected Row getFlagRow() {
        return this.getRowByAttribute(QueryFormat.FLAG_ATTRIBUTE);
    }

    protected Row getRemoteDatabaseRow() {
        return this.getRowByAttribute(QueryFormat.REMOTEDB_ATTRIBUTE);
    }

    protected List<Row> getTableRows() {
        return this.getRowsByAttribute(QueryFormat.TABLE_ATTRIBUTE);
    }

    protected List<Row> getColumnRows() {
        return this.getRowsByAttribute(QueryFormat.COLUMN_ATTRIBUTE);
    }

    protected List<Row> getJoinRows() {
        return this.getRowsByAttribute(QueryFormat.JOIN_ATTRIBUTE);
    }

    protected Row getWhereRow() {
        return this.getRowByAttribute(QueryFormat.WHERE_ATTRIBUTE);
    }

    protected List<Row> getGroupByRows() {
        return this.getRowsByAttribute(QueryFormat.GROUPBY_ATTRIBUTE);
    }

    protected Row getHavingRow() {
        return this.getRowByAttribute(QueryFormat.HAVING_ATTRIBUTE);
    }

    protected List<Row> getOrderByRows() {
        return this.getRowsByAttribute(QueryFormat.ORDERBY_ATTRIBUTE);
    }

    protected abstract void toSQLString(StringBuilder var1);

    protected void toSQLParameterString(StringBuilder builder) {
        List<String> params = this.getParameters();
        if (!params.isEmpty()) {
            builder.append("PARAMETERS ").append(params).append(';').append(QueryFormat.NEWLINE);
        }
    }

    @Override
    public List<String> getParameters() {
        return new RowFormatter(this.getParameterRows()){

            protected void format(StringBuilder builder, Row row) {
                String typeName = QueryFormat.PARAM_TYPE_MAP.get(row.flag);
                if (typeName == null) {
                    throw new IllegalStateException(QueryImpl.this.withErrorContext("Unknown param type " + row.flag));
                }
                builder.append(row.name1).append(' ').append(typeName);
                if (QueryFormat.TEXT_FLAG.equals(row.flag) && QueryImpl.getIntValue(row.extra, 0) > 0) {
                    builder.append('(').append(row.extra).append(')');
                }
            }
        }.format();
    }

    protected List<String> getFromTables() {
        ArrayList<Join> joinExprs = new ArrayList<Join>();
        for (Row table : this.getTableRows()) {
            StringBuilder builder = new StringBuilder();
            if (table.expression != null) {
                QueryImpl.toQuotedExpr(builder, table.expression).append('.');
            }
            if (table.name1 != null) {
                QueryImpl.toOptionalQuotedExpr(builder, table.name1, true);
            }
            QueryImpl.toAlias(builder, table.name2);
            String key = table.name2 != null ? table.name2 : table.name1;
            joinExprs.add(new Join(key, builder.toString()));
        }
        List<Row> joins = this.getJoinRows();
        if (!joins.isEmpty()) {
            Collection<List<Row>> comboJoins = this.combineJoins(joins);
            for (List<Row> comboJoin : comboJoins) {
                Row join = comboJoin.get(0);
                String joinExpr = join.expression;
                if (comboJoin.size() > 1) {
                    AppendableList<String> comboExprs = new AppendableList<String>(){
                        private static final long serialVersionUID = 0L;

                        @Override
                        protected String getSeparator() {
                            return ") AND (";
                        }
                    };
                    for (Row tmpJoin : comboJoin) {
                        comboExprs.add(tmpJoin.expression);
                    }
                    joinExpr = "(" + comboExprs + ")";
                }
                String fromTable = join.name1;
                String toTable = join.name2;
                Join fromExpr = this.getJoinExpr(fromTable, joinExprs);
                Join toExpr = this.getJoinExpr(toTable, joinExprs);
                String joinType = QueryFormat.JOIN_TYPE_MAP.get(join.flag);
                if (joinType == null) {
                    throw new IllegalStateException(this.withErrorContext("Unknown join type " + join.flag));
                }
                String expr = fromExpr + joinType + toExpr + " ON " + joinExpr;
                fromExpr.join(toExpr, expr);
                joinExprs.add(fromExpr);
            }
        }
        AppendableList<String> result = new AppendableList<String>();
        for (Join joinExpr : joinExprs) {
            result.add(joinExpr.expression);
        }
        return result;
    }

    private Join getJoinExpr(String table, List<Join> joinExprs) {
        Iterator<Join> iter = joinExprs.iterator();
        while (iter.hasNext()) {
            Join joinExpr = iter.next();
            if (!joinExpr.tables.contains(table)) continue;
            iter.remove();
            return joinExpr;
        }
        throw new IllegalStateException(this.withErrorContext("Cannot find join table " + table));
    }

    private Collection<List<Row>> combineJoins(List<Row> joins) {
        LinkedHashMap comboJoinMap = new LinkedHashMap();
        for (Row join : joins) {
            List<String> key = Arrays.asList(join.name1, join.name2);
            ArrayList<Row> comboJoins = (ArrayList<Row>)comboJoinMap.get(key);
            if (comboJoins == null) {
                comboJoins = new ArrayList<Row>();
                comboJoinMap.put(key, comboJoins);
            } else if (((Row)comboJoins.get((int)0)).flag.shortValue() != join.flag.shortValue()) {
                throw new IllegalStateException(this.withErrorContext("Mismatched join flags for combo joins"));
            }
            comboJoins.add(join);
        }
        return comboJoinMap.values();
    }

    protected String getFromRemoteDbPath() {
        return this.getRemoteDatabaseRow().name1;
    }

    protected String getFromRemoteDbType() {
        return this.getRemoteDatabaseRow().expression;
    }

    protected String getWhereExpression() {
        return this.getWhereRow().expression;
    }

    protected List<String> getOrderings() {
        return new RowFormatter(this.getOrderByRows()){

            protected void format(StringBuilder builder, Row row) {
                builder.append(row.expression);
                if ("D".equalsIgnoreCase(row.name1)) {
                    builder.append(" DESC");
                }
            }
        }.format();
    }

    @Override
    public String getOwnerAccessType() {
        return this.hasFlag(4) ? "WITH OWNERACCESS OPTION" : "";
    }

    protected boolean hasFlag(int flagMask) {
        return QueryImpl.hasFlag(this.getFlagRow(), flagMask);
    }

    protected boolean supportsStandardClauses() {
        return true;
    }

    @Override
    public String toSQLString() {
        StringBuilder builder = new StringBuilder();
        if (this.supportsStandardClauses()) {
            this.toSQLParameterString(builder);
        }
        this.toSQLString(builder);
        if (this.supportsStandardClauses()) {
            String accessType = this.getOwnerAccessType();
            if (!"".equals(accessType)) {
                builder.append(QueryFormat.NEWLINE).append(accessType);
            }
            builder.append(';');
        }
        return builder.toString();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    public static QueryImpl create(int objectFlag, String name, List<Row> rows, int objectId) {
        int typeFlag = objectFlag & 0xF0;
        try {
            switch (typeFlag) {
                case 0: {
                    return new SelectQueryImpl(name, rows, objectId, objectFlag);
                }
                case 80: {
                    return new MakeTableQueryImpl(name, rows, objectId, objectFlag);
                }
                case 64: {
                    return new AppendQueryImpl(name, rows, objectId, objectFlag);
                }
                case 48: {
                    return new UpdateQueryImpl(name, rows, objectId, objectFlag);
                }
                case 32: {
                    return new DeleteQueryImpl(name, rows, objectId, objectFlag);
                }
                case 16: {
                    return new CrossTabQueryImpl(name, rows, objectId, objectFlag);
                }
                case 96: {
                    return new DataDefinitionQueryImpl(name, rows, objectId, objectFlag);
                }
                case 112: {
                    return new PassthroughQueryImpl(name, rows, objectId, objectFlag);
                }
                case 128: {
                    return new UnionQueryImpl(name, rows, objectId, objectFlag);
                }
            }
            throw new IllegalStateException(QueryImpl.withErrorContext("unknown query object flag " + typeFlag, name));
        }
        catch (IllegalStateException e) {
            LOG.warn(QueryImpl.withErrorContext("Failed parsing query", name), e);
            return new UnknownQueryImpl(name, (List)rows, objectId, objectFlag);
        }
    }

    private Short getQueryType(List<Row> rows) {
        return this.getUniqueRow(QueryImpl.getRowsByAttribute(rows, (Byte)QueryFormat.TYPE_ATTRIBUTE)).flag;
    }

    private static List<Row> getRowsByAttribute(List<Row> rows, Byte attribute) {
        ArrayList<Row> result = new ArrayList<Row>();
        for (Row row : rows) {
            if (!attribute.equals(row.attribute)) continue;
            result.add(row);
        }
        return result;
    }

    protected Row getUniqueRow(List<Row> rows) {
        if (rows.size() == 1) {
            return rows.get(0);
        }
        if (rows.isEmpty()) {
            return EMPTY_ROW;
        }
        throw new IllegalStateException(this.withErrorContext("Unexpected number of rows for" + rows));
    }

    protected static List<Row> filterRowsByFlag(List<Row> rows, final short flag) {
        return new RowFilter(){

            protected boolean keep(Row row) {
                return QueryImpl.hasFlag(row, flag);
            }
        }.filter(rows);
    }

    protected static List<Row> filterRowsByNotFlag(List<Row> rows, final short flag) {
        return new RowFilter(){

            protected boolean keep(Row row) {
                return !QueryImpl.hasFlag(row, flag);
            }
        }.filter(rows);
    }

    protected static boolean hasFlag(Row row, int flagMask) {
        return (QueryImpl.getShortValue(row.flag, 0) & flagMask) != 0;
    }

    protected static short getShortValue(Short s, int def) {
        return s != null ? s : (short)def;
    }

    protected static int getIntValue(Integer i, int def) {
        return i != null ? i : def;
    }

    protected static StringBuilder toOptionalQuotedExpr(StringBuilder builder, String fullExpr, boolean isIdentifier) {
        String[] stringArray;
        if (isIdentifier) {
            stringArray = QueryFormat.IDENTIFIER_SEP_PAT.split(fullExpr);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = fullExpr;
        }
        String[] exprs = stringArray;
        for (int i = 0; i < exprs.length; ++i) {
            String expr = exprs[i];
            if (QueryFormat.QUOTABLE_CHAR_PAT.matcher(expr).find()) {
                QueryImpl.toQuotedExpr(builder, expr);
            } else {
                builder.append(expr);
            }
            if (i >= exprs.length - 1) continue;
            builder.append('.');
        }
        return builder;
    }

    protected static StringBuilder toQuotedExpr(StringBuilder builder, String expr) {
        return !QueryImpl.isQuoted(expr) ? builder.append('[').append(expr).append(']') : builder.append(expr);
    }

    protected static boolean isQuoted(String expr) {
        return expr.length() >= 2 && expr.charAt(0) == '[' && expr.charAt(expr.length() - 1) == ']';
    }

    protected static StringBuilder toRemoteDb(StringBuilder builder, String remoteDbPath, String remoteDbType) {
        if (remoteDbPath != null || remoteDbType != null) {
            builder.append(" IN '");
            if (remoteDbPath != null) {
                builder.append(remoteDbPath);
            }
            builder.append('\'');
            if (remoteDbType != null) {
                builder.append(" [").append(remoteDbType).append(']');
            }
        }
        return builder;
    }

    protected static StringBuilder toAlias(StringBuilder builder, String alias) {
        if (alias != null) {
            QueryImpl.toOptionalQuotedExpr(builder.append(" AS "), alias, false);
        }
        return builder;
    }

    private String withErrorContext(String msg) {
        return QueryImpl.withErrorContext(msg, this.getName());
    }

    private static String withErrorContext(String msg, String queryName) {
        return msg + " (Query: " + queryName + ")";
    }

    private static final class Join {
        public final List<String> tables = new ArrayList<String>();
        public boolean isJoin;
        public String expression;

        private Join(String table, String expr) {
            this.tables.add(table);
            this.expression = expr;
        }

        public void join(Join other, String newExpr) {
            this.tables.addAll(other.tables);
            this.isJoin = true;
            this.expression = newExpr;
        }

        public String toString() {
            return this.isJoin ? "(" + this.expression + ")" : this.expression;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AppendableList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 0L;

        protected AppendableList() {
        }

        protected AppendableList(Collection<? extends E> c) {
            super(c);
        }

        protected String getSeparator() {
            return ", ";
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            Iterator iter = this.iterator();
            while (iter.hasNext()) {
                builder.append(iter.next().toString());
                if (!iter.hasNext()) continue;
                builder.append(this.getSeparator());
            }
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class RowFilter {
        protected RowFilter() {
        }

        public List<Row> filter(List<Row> list) {
            Iterator<Row> iter = list.iterator();
            while (iter.hasNext()) {
                if (this.keep(iter.next())) continue;
                iter.remove();
            }
            return list;
        }

        protected abstract boolean keep(Row var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static abstract class RowFormatter {
        private final List<Row> _list;

        protected RowFormatter(List<Row> list) {
            this._list = list;
        }

        public List<String> format() {
            return this.format(new AppendableList<String>());
        }

        public List<String> format(List<String> strs) {
            for (Row row : this._list) {
                StringBuilder builder = new StringBuilder();
                this.format(builder, row);
                strs.add(builder.toString());
            }
            return strs;
        }

        protected abstract void format(StringBuilder var1, Row var2);
    }

    public static final class Row {
        private final RowId _id;
        public final Byte attribute;
        public final String expression;
        public final Short flag;
        public final Integer extra;
        public final String name1;
        public final String name2;
        public final Integer objectId;
        public final byte[] order;

        private Row() {
            this._id = null;
            this.attribute = null;
            this.expression = null;
            this.flag = null;
            this.extra = null;
            this.name1 = null;
            this.name2 = null;
            this.objectId = null;
            this.order = null;
        }

        public Row(com.healthmarketscience.jackcess.Row tableRow) {
            this(tableRow.getId(), tableRow.getByte("Attribute"), tableRow.getString("Expression"), tableRow.getShort("Flag"), tableRow.getInt("LvExtra"), tableRow.getString("Name1"), tableRow.getString("Name2"), tableRow.getInt("ObjectId"), tableRow.getBytes("Order"));
        }

        public Row(RowId id, Byte attribute, String expression, Short flag, Integer extra, String name1, String name2, Integer objectId, byte[] order) {
            this._id = id;
            this.attribute = attribute;
            this.expression = expression;
            this.flag = flag;
            this.extra = extra;
            this.name1 = name1;
            this.name2 = name2;
            this.objectId = objectId;
            this.order = order;
        }

        public com.healthmarketscience.jackcess.Row toTableRow() {
            RowImpl tableRow = new RowImpl((RowIdImpl)this._id);
            tableRow.put("Attribute", this.attribute);
            tableRow.put("Expression", this.expression);
            tableRow.put("Flag", this.flag);
            tableRow.put("LvExtra", this.extra);
            tableRow.put("Name1", this.name1);
            tableRow.put("Name2", this.name2);
            tableRow.put("ObjectId", this.objectId);
            tableRow.put("Order", this.order);
            return tableRow;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class UnknownQueryImpl
    extends QueryImpl {
        private UnknownQueryImpl(String name, List<Row> rows, int objectId, int objectFlag) {
            super(name, rows, objectId, objectFlag, Query.Type.UNKNOWN);
        }

        @Override
        protected void toSQLString(StringBuilder builder) {
            throw new UnsupportedOperationException();
        }
    }
}

