/*
 * Decompiled with CFR 0.152.
 */
package com.optimaize.langdetect;

import com.cybozu.labs.langdetect.util.Util;
import com.google.common.base.Optional;
import com.optimaize.langdetect.DetectedLanguage;
import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.NgramFrequencyData;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LanguageDetectorImpl
implements LanguageDetector {
    private static final Logger logger = LoggerFactory.getLogger(LanguageDetectorImpl.class);
    private static final double ALPHA_WIDTH = 0.05;
    private static final int ITERATION_LIMIT = 1000;
    private static final double CONV_THRESHOLD = 0.99999;
    private static final int BASE_FREQ = 10000;
    private static final int N_TRIAL = 7;
    private static final long DEFAULT_SEED = 41L;
    @NotNull
    private final NgramFrequencyData ngramFrequencyData;
    @Nullable
    private final double[] priorMap;
    private final double alpha;
    private final Optional<Long> seed;
    private final int shortTextAlgorithm;
    private final double prefixFactor;
    private final double suffixFactor;
    private final double probabilityThreshold;
    private final double minimalConfidence;
    private final NgramExtractor ngramExtractor;

    LanguageDetectorImpl(@NotNull NgramFrequencyData ngramFrequencyData, double alpha, Optional<Long> seed, int shortTextAlgorithm, double prefixFactor, double suffixFactor, double probabilityThreshold, double minimalConfidence, @Nullable Map<LdLocale, Double> langWeightingMap, @NotNull NgramExtractor ngramExtractor) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("alpha must be between 0 and 1, but was: " + alpha);
        }
        if (prefixFactor < 0.0 || prefixFactor > 10.0) {
            throw new IllegalArgumentException("prefixFactor must be between 0 and 10, but was: " + prefixFactor);
        }
        if (suffixFactor < 0.0 || suffixFactor > 10.0) {
            throw new IllegalArgumentException("suffixFactor must be between 0 and 10, but was: " + suffixFactor);
        }
        if (probabilityThreshold < 0.0 || probabilityThreshold > 1.0) {
            throw new IllegalArgumentException("probabilityThreshold must be between 0 and 1, but was: " + probabilityThreshold);
        }
        if (minimalConfidence < 0.0 || minimalConfidence > 1.0) {
            throw new IllegalArgumentException("minimalConfidence must be between 0 and 1, but was: " + minimalConfidence);
        }
        if (langWeightingMap != null && langWeightingMap.isEmpty()) {
            langWeightingMap = null;
        }
        this.ngramFrequencyData = ngramFrequencyData;
        this.alpha = alpha;
        this.seed = seed;
        this.shortTextAlgorithm = shortTextAlgorithm;
        this.prefixFactor = prefixFactor;
        this.suffixFactor = suffixFactor;
        this.probabilityThreshold = probabilityThreshold;
        this.minimalConfidence = minimalConfidence;
        this.priorMap = langWeightingMap == null ? null : Util.makeInternalPrioMap(langWeightingMap, ngramFrequencyData.getLanguageList());
        this.ngramExtractor = ngramExtractor;
    }

    @Override
    public Optional<LdLocale> detect(CharSequence text) {
        List<DetectedLanguage> probabilities = this.getProbabilities(text);
        if (probabilities.isEmpty()) {
            return Optional.absent();
        }
        DetectedLanguage best = probabilities.get(0);
        if (best.getProbability() >= this.minimalConfidence) {
            return Optional.of(best.getLocale());
        }
        return Optional.absent();
    }

    @Override
    public List<DetectedLanguage> getProbabilities(CharSequence text) {
        double[] langprob = this.detectBlock(text);
        if (langprob == null) {
            return Collections.emptyList();
        }
        return this.sortProbability(langprob);
    }

    @Nullable
    private double[] detectBlock(CharSequence text) {
        if (text.length() <= this.shortTextAlgorithm) {
            Map<String, Integer> ngrams = this.ngramExtractor.extractCountedGrams(text);
            if (ngrams.isEmpty()) {
                return null;
            }
            return this.detectBlockShortText(ngrams);
        }
        List<String> strings = this.ngramExtractor.extractGrams(text);
        if (strings.isEmpty()) {
            return null;
        }
        return this.detectBlockLongText(strings);
    }

    private double[] detectBlockShortText(Map<String, Integer> ngrams) {
        double[] prob = this.initProbability();
        double alpha = this.alpha;
        for (Map.Entry<String, Integer> gramWithCount : ngrams.entrySet()) {
            this.updateLangProb(prob, gramWithCount.getKey(), gramWithCount.getValue(), alpha);
        }
        Util.normalizeProb(prob);
        if (logger.isDebugEnabled()) {
            logger.debug("==> " + this.sortProbability(prob));
        }
        return prob;
    }

    private double[] detectBlockLongText(List<String> ngrams) {
        assert (!ngrams.isEmpty());
        double[] langprob = new double[this.ngramFrequencyData.getLanguageList().size()];
        Random rand = new Random(this.seed.or(41L));
        for (int t = 0; t < 7; ++t) {
            double[] prob = this.initProbability();
            double alpha = this.alpha + rand.nextGaussian() * 0.05;
            for (int i = 0; i < 1000; ++i) {
                int r = rand.nextInt(ngrams.size());
                this.updateLangProb(prob, ngrams.get(r), 1, alpha);
                if (i % 5 != 0) continue;
                if (Util.normalizeProb(prob) > 0.99999) break;
                if (!logger.isTraceEnabled()) continue;
                logger.trace("> " + this.sortProbability(prob));
            }
            for (int j = 0; j < langprob.length; ++j) {
                int n = j;
                langprob[n] = langprob[n] + prob[j] / 7.0;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("==> " + this.sortProbability(prob));
        }
        return langprob;
    }

    private double[] initProbability() {
        double[] prob = new double[this.ngramFrequencyData.getLanguageList().size()];
        if (this.priorMap != null) {
            System.arraycopy(this.priorMap, 0, prob, 0, prob.length);
            for (int i = 0; i < prob.length; ++i) {
                prob[i] = this.priorMap[i];
            }
        } else {
            for (int i = 0; i < prob.length; ++i) {
                prob[i] = 1.0 / (double)this.ngramFrequencyData.getLanguageList().size();
            }
        }
        return prob;
    }

    private boolean updateLangProb(@NotNull double[] prob, @NotNull String ngram, int count, double alpha) {
        double[] langProbMap = this.ngramFrequencyData.getProbabilities(ngram);
        if (langProbMap == null) {
            return false;
        }
        if (logger.isTraceEnabled()) {
            logger.trace(ngram + "(" + Util.unicodeEncode(ngram) + "):" + Util.wordProbToString(langProbMap, this.ngramFrequencyData.getLanguageList()));
        }
        double weight = alpha / 10000.0;
        if (ngram.length() > 1) {
            if (this.prefixFactor != 1.0 && ngram.charAt(0) == ' ') {
                weight *= this.prefixFactor;
            } else if (this.suffixFactor != 1.0 && ngram.charAt(ngram.length() - 1) == ' ') {
                weight *= this.suffixFactor;
            }
        }
        for (int i = 0; i < prob.length; ++i) {
            for (int amount = 0; amount < count; ++amount) {
                int n = i;
                prob[n] = prob[n] * (weight + langProbMap[i]);
            }
        }
        return true;
    }

    @NotNull
    private List<DetectedLanguage> sortProbability(double[] prob) {
        ArrayList<DetectedLanguage> list = new ArrayList<DetectedLanguage>();
        block0: for (int j = 0; j < prob.length; ++j) {
            double p = prob[j];
            if (!(p >= this.probabilityThreshold)) continue;
            for (int i = 0; i <= list.size(); ++i) {
                if (i != list.size() && !(((DetectedLanguage)list.get(i)).getProbability() < p)) continue;
                list.add(i, new DetectedLanguage(this.ngramFrequencyData.getLanguage(j), p));
                continue block0;
            }
        }
        return list;
    }
}

