/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Variant;

public class VariantListBuilderImpl
extends Variant.VariantListBuilder {
    private List<String> encodings = new ArrayList<String>();
    private List<Locale> languages = new ArrayList<Locale>();
    private List<MediaType> mediaTypes = new ArrayList<MediaType>();
    private List<Variant> variants = new ArrayList<Variant>();

    @Override
    public Variant.VariantListBuilder add() {
        this.addVariants();
        this.resetMeta();
        return this;
    }

    @Override
    public List<Variant> build() {
        ArrayList<Variant> vs = new ArrayList<Variant>(this.variants);
        this.reset();
        return vs;
    }

    @Override
    public Variant.VariantListBuilder encodings(String ... encs) {
        this.encodings.addAll(Arrays.asList(encs));
        return this;
    }

    @Override
    public Variant.VariantListBuilder mediaTypes(MediaType ... types) {
        this.mediaTypes.addAll(Arrays.asList(types));
        return this;
    }

    private void reset() {
        this.variants.clear();
        this.resetMeta();
    }

    private void resetMeta() {
        this.mediaTypes.clear();
        this.languages.clear();
        this.encodings.clear();
    }

    private void addVariants() {
        if (this.mediaTypes.size() > 0) {
            this.handleMediaTypes();
        } else if (this.languages.size() > 0) {
            this.handleLanguages(null);
        } else if (this.encodings.size() > 0) {
            for (String enc : this.encodings) {
                this.variants.add(new Variant(null, (Locale)null, enc));
            }
        }
    }

    private void handleMediaTypes() {
        for (MediaType type : this.mediaTypes) {
            if (this.languages.size() > 0) {
                this.handleLanguages(type);
                continue;
            }
            if (this.encodings.size() > 0) {
                for (String enc : this.encodings) {
                    this.variants.add(new Variant(type, (Locale)null, enc));
                }
                continue;
            }
            this.variants.add(new Variant(type, (Locale)null, null));
        }
    }

    private void handleLanguages(MediaType type) {
        for (Locale lang : this.languages) {
            if (this.encodings.size() > 0) {
                for (String enc : this.encodings) {
                    this.variants.add(new Variant(type, lang, enc));
                }
                continue;
            }
            this.variants.add(new Variant(type, lang, null));
        }
    }

    @Override
    public Variant.VariantListBuilder languages(Locale ... ls) {
        this.languages.addAll(Arrays.asList(ls));
        return this;
    }
}

