/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import org.apache.cxf.jaxrs.ext.StreamingResponse;
import org.apache.cxf.jaxrs.utils.InjectionUtils;

public class StreamingResponseProvider<T>
implements MessageBodyWriter<StreamingResponse<T>> {
    @Context
    private Providers providers;

    @Override
    public boolean isWriteable(Class<?> cls, Type type, Annotation[] anns, MediaType mt) {
        return StreamingResponse.class.isAssignableFrom(cls);
    }

    @Override
    public void writeTo(StreamingResponse<T> p, Class<?> cls, Type t, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        Class<?> actualCls = InjectionUtils.getActualType(t);
        MessageBodyWriter<?> writer = this.providers.getMessageBodyWriter(actualCls, actualCls, anns, mt);
        if (writer == null) {
            throw new InternalServerErrorException();
        }
        StreamingResponseWriter thewriter = new StreamingResponseWriter(writer, actualCls, anns, mt, headers, os);
        p.writeTo(thewriter);
    }

    @Override
    public long getSize(StreamingResponse<T> arg0, Class<?> arg1, Type arg2, Annotation[] arg3, MediaType arg4) {
        return -1L;
    }

    private class StreamingResponseWriter
    implements StreamingResponse.Writer<T> {
        private MessageBodyWriter<T> writer;
        private Class<?> cls;
        private MediaType mt;
        private Annotation[] anns;
        private MultivaluedMap<String, Object> headers;
        private OutputStream os;

        public StreamingResponseWriter(MessageBodyWriter<T> writer, Class<?> cls, Annotation[] anns, MediaType mt, MultivaluedMap<String, Object> headers, OutputStream os) {
            this.writer = writer;
            this.cls = cls;
            this.anns = anns;
            this.mt = mt;
            this.headers = headers;
            this.os = os;
        }

        @Override
        public void write(T data) throws IOException {
            this.writer.writeTo(data, this.cls, this.cls, this.anns, this.mt, this.headers, this.os);
        }

        @Override
        public OutputStream getEntityStream() {
            return this.os;
        }
    }
}

