/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.colorpane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;

public class CSSeparation
implements ChangeListener,
ActionListener {
    private JSlider slider;
    private JTextField tintField;
    private JLabel colorBar;
    private JPanel panel;
    private PDSeparation separation;
    private float tintValue = 1.0f;

    public CSSeparation(COSArray array) {
        try {
            this.separation = new PDSeparation(array);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.initUI();
        this.initValues();
    }

    private void initUI() {
        Font boldFont = new Font("Monospaced", 1, 20);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(2, 2, 2, 2);
        JPanel inputPanel = new JPanel(new GridBagLayout());
        this.slider = new JSlider(0, 100, 50);
        this.slider.setMajorTickSpacing(50);
        this.slider.setPaintTicks(true);
        Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
        JLabel lightest = new JLabel("lightest");
        lightest.setFont(new Font("Monospaced", 1, 10));
        JLabel darkest = new JLabel("darkest");
        darkest.setFont(new Font("Monospaced", 1, 10));
        JLabel midPoint = new JLabel("0.5");
        midPoint.setFont(new Font("Monospaced", 1, 10));
        ((Dictionary)labelTable).put(0, lightest);
        ((Dictionary)labelTable).put(50, midPoint);
        ((Dictionary)labelTable).put(100, darkest);
        this.slider.setPaintLabels(true);
        this.slider.setLabelTable(labelTable);
        this.slider.addChangeListener(this);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 10;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        inputPanel.add((Component)this.slider, gbc);
        JLabel tintLabel = new JLabel("Tint Value:");
        tintLabel.setFont(boldFont);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        inputPanel.add((Component)tintLabel, gbc);
        this.tintField = new JTextField();
        this.tintField.addActionListener(this);
        this.tintField.setPreferredSize(new Dimension(10, 30));
        gbc.gridx = 1;
        gbc.weightx = 0.5;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        inputPanel.add((Component)this.tintField, gbc);
        JPanel contentPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.gridx = 0;
        gbc2.gridy = 0;
        gbc2.gridwidth = 2;
        gbc2.weightx = 0.3;
        gbc2.weighty = 1.0;
        gbc2.fill = 2;
        contentPanel.add((Component)inputPanel, gbc2);
        this.colorBar = new JLabel();
        this.colorBar.setOpaque(true);
        gbc2.gridx = 2;
        gbc2.weightx = 0.7;
        gbc2.gridwidth = 4;
        gbc2.gridheight = 2;
        gbc2.fill = 1;
        contentPanel.add((Component)this.colorBar, gbc2);
        this.setColorBarBorder();
        JPanel mainpanel = new JPanel(new GridBagLayout());
        JLabel colorantNameLabel = new JLabel("Colorant: " + this.separation.getColorantName());
        colorantNameLabel.setFont(boldFont);
        GridBagConstraints maingbc = new GridBagConstraints();
        maingbc.gridx = 0;
        maingbc.gridy = 0;
        maingbc.weightx = 1.0;
        maingbc.weighty = 0.03;
        maingbc.anchor = 23;
        mainpanel.add((Component)colorantNameLabel, maingbc);
        maingbc.gridx = 0;
        maingbc.gridy = 1;
        maingbc.weighty = 0.97;
        maingbc.gridwidth = 10;
        maingbc.fill = 2;
        mainpanel.add((Component)contentPanel, maingbc);
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.panel.setPreferredSize(new Dimension(300, 500));
        JLabel colorSpaceLabel = new JLabel("Separation colorspace");
        colorSpaceLabel.setAlignmentX(0.5f);
        colorSpaceLabel.setFont(new Font("Monospaced", 1, 30));
        this.panel.add(colorSpaceLabel);
        this.panel.add(mainpanel);
    }

    private void initValues() {
        this.slider.setValue(this.getIntRepresentation(this.tintValue));
        this.tintField.setText(Float.toString(this.tintValue));
    }

    public JPanel getPanel() {
        return this.panel;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        int value = this.slider.getValue();
        this.tintValue = this.getFloatRepresentation(value);
        this.tintField.setText(Float.toString(this.tintValue));
        this.updateColorBar();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String input = this.tintField.getText();
        try {
            this.tintValue = Float.parseFloat(input);
            this.slider.setValue(this.getIntRepresentation(this.tintValue));
            this.updateColorBar();
        }
        catch (NumberFormatException e) {
            this.tintField.setText(Float.toString(this.tintValue));
        }
    }

    private void updateColorBar() {
        try {
            float[] rgbValues = this.separation.toRGB(new float[]{this.tintValue});
            this.colorBar.setBackground(new Color(rgbValues[0], rgbValues[1], rgbValues[2]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void setColorBarBorder() {
        try {
            float[] rgbValues = this.separation.toRGB(new float[]{1.0f});
            Color darkest = new Color(rgbValues[0], rgbValues[1], rgbValues[2]);
            this.colorBar.setBorder(new BevelBorder(1, darkest, darkest));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private float getFloatRepresentation(int value) {
        return (float)value / 100.0f;
    }

    private int getIntRepresentation(float value) {
        return (int)(value * 100.0f);
    }
}

