/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdgf.pointers;

import org.apache.poi.hdgf.pointers.Pointer;
import org.apache.poi.util.LittleEndian;

public final class PointerV6
extends Pointer {
    @Override
    public boolean destinationHasStrings() {
        return 64 <= this.format && this.format < 80;
    }

    @Override
    public boolean destinationHasPointers() {
        if (this.type == 20) {
            return true;
        }
        if (this.format == 29 || this.format == 30) {
            return true;
        }
        return 80 <= this.format && this.format < 96;
    }

    @Override
    public boolean destinationHasChunks() {
        return 208 <= this.format && this.format < 223;
    }

    @Override
    public boolean destinationCompressed() {
        return (this.format & 2) > 0;
    }

    @Override
    public int getSizeInBytes() {
        return 18;
    }

    @Override
    public int getNumPointersOffset(byte[] data) {
        return PointerV6.getNumPointersOffsetV6(data);
    }

    public static int getNumPointersOffsetV6(byte[] data) {
        return (int)LittleEndian.getUInt(data, 0);
    }

    @Override
    public int getNumPointers(int offset, byte[] data) {
        return PointerV6.getNumPointersV6(offset, data);
    }

    public static int getNumPointersV6(int offset, byte[] data) {
        return (int)LittleEndian.getUInt(data, offset);
    }

    @Override
    public int getPostNumPointersSkip() {
        return PointerV6.getPostNumPointersSkipV6();
    }

    public static int getPostNumPointersSkipV6() {
        return 8;
    }
}

