/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.datatypes;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.ByteChunk;
import org.apache.poi.hsmf.datatypes.Chunk;
import org.apache.poi.hsmf.datatypes.ChunkGroup;
import org.apache.poi.hsmf.datatypes.DirectoryChunk;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class AttachmentChunks
implements ChunkGroup {
    private static POILogger logger = POILogFactory.getLogger(AttachmentChunks.class);
    public static final String PREFIX = "__attach_version1.0_#";
    public ByteChunk attachData;
    public StringChunk attachExtension;
    public StringChunk attachFileName;
    public StringChunk attachLongFileName;
    public StringChunk attachMimeTag;
    public DirectoryChunk attachmentDirectory;
    public ByteChunk attachRenderingWMF;
    private String poifsName;
    private List<Chunk> allChunks = new ArrayList<Chunk>();

    public AttachmentChunks(String poifsName) {
        this.poifsName = poifsName;
    }

    public boolean isEmbeddedMessage() {
        return this.attachmentDirectory != null;
    }

    public MAPIMessage getEmbeddedMessage() throws IOException {
        if (this.attachmentDirectory != null) {
            return this.attachmentDirectory.getAsEmbededMessage();
        }
        return null;
    }

    public byte[] getEmbeddedAttachmentObject() {
        if (this.attachData != null) {
            return this.attachData.getValue();
        }
        return null;
    }

    public Chunk[] getAll() {
        return this.allChunks.toArray(new Chunk[this.allChunks.size()]);
    }

    @Override
    public Chunk[] getChunks() {
        return this.getAll();
    }

    public String getPOIFSName() {
        return this.poifsName;
    }

    @Override
    public void record(Chunk chunk) {
        int chunkId = chunk.getChunkId();
        if (chunkId == MAPIProperty.ATTACH_DATA.id) {
            if (chunk instanceof ByteChunk) {
                this.attachData = (ByteChunk)chunk;
            } else if (chunk instanceof DirectoryChunk) {
                this.attachmentDirectory = (DirectoryChunk)chunk;
            } else {
                logger.log(7, "Unexpected data chunk of type " + chunk);
            }
        } else if (chunkId == MAPIProperty.ATTACH_EXTENSION.id) {
            this.attachExtension = (StringChunk)chunk;
        } else if (chunkId == MAPIProperty.ATTACH_FILENAME.id) {
            this.attachFileName = (StringChunk)chunk;
        } else if (chunkId == MAPIProperty.ATTACH_LONG_FILENAME.id) {
            this.attachLongFileName = (StringChunk)chunk;
        } else if (chunkId == MAPIProperty.ATTACH_MIME_TAG.id) {
            this.attachMimeTag = (StringChunk)chunk;
        } else if (chunkId == MAPIProperty.ATTACH_RENDERING.id) {
            this.attachRenderingWMF = (ByteChunk)chunk;
        }
        this.allChunks.add(chunk);
    }

    @Override
    public void chunksComplete() {
    }

    public static class AttachmentChunksSorter
    implements Comparator<AttachmentChunks>,
    Serializable {
        @Override
        public int compare(AttachmentChunks a, AttachmentChunks b) {
            return a.poifsName.compareTo(b.poifsName);
        }
    }
}

