/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.sl.usermodel.StrokeStyle;

public class DrawShape
implements Drawable {
    protected final Shape<?, ?> shape;

    public DrawShape(Shape<?, ?> shape) {
        this.shape = shape;
    }

    @Override
    public void applyTransform(Graphics2D graphics) {
        char[] cmds;
        char[] cArray;
        if (!(this.shape instanceof PlaceableShape)) {
            return;
        }
        PlaceableShape ps = (PlaceableShape)((Object)this.shape);
        boolean isHSLF = ps.getClass().getCanonicalName().toLowerCase(Locale.ROOT).contains("hslf");
        AffineTransform tx = (AffineTransform)graphics.getRenderingHint(Drawable.GROUP_TRANSFORM);
        if (tx == null) {
            tx = new AffineTransform();
        }
        Rectangle2D anchor = tx.createTransformedShape(ps.getAnchor()).getBounds2D();
        if (isHSLF) {
            char[] cArray2 = new char[3];
            cArray2[0] = 104;
            cArray2[1] = 118;
            cArray = cArray2;
            cArray2[2] = 114;
        } else {
            char[] cArray3 = new char[3];
            cArray3[0] = 114;
            cArray3[1] = 104;
            cArray = cArray3;
            cArray3[2] = 118;
        }
        block5: for (char ch : cmds = cArray) {
            switch (ch) {
                case 'h': {
                    if (!ps.getFlipHorizontal()) continue block5;
                    graphics.translate(anchor.getX() + anchor.getWidth(), anchor.getY());
                    graphics.scale(-1.0, 1.0);
                    graphics.translate(-anchor.getX(), -anchor.getY());
                    continue block5;
                }
                case 'v': {
                    if (!ps.getFlipVertical()) continue block5;
                    graphics.translate(anchor.getX(), anchor.getY() + anchor.getHeight());
                    graphics.scale(1.0, -1.0);
                    graphics.translate(-anchor.getX(), -anchor.getY());
                    continue block5;
                }
                case 'r': {
                    double rotation = ps.getRotation();
                    if (rotation == 0.0) continue block5;
                    double centerX = anchor.getCenterX();
                    double centerY = anchor.getCenterY();
                    if ((rotation %= 360.0) < 0.0) {
                        rotation += 360.0;
                    }
                    int quadrant = ((int)rotation + 45) / 90 % 4;
                    double scaleX = 1.0;
                    double scaleY = 1.0;
                    if (quadrant == 1 || quadrant == 3) {
                        AffineTransform txs;
                        if (isHSLF) {
                            txs = new AffineTransform(tx);
                        } else {
                            txs = new AffineTransform();
                            txs.translate(centerX, centerY);
                            txs.rotate(1.5707963267948966);
                            txs.translate(-centerX, -centerY);
                            txs.concatenate(tx);
                        }
                        txs.translate(centerX, centerY);
                        txs.rotate(1.5707963267948966);
                        txs.translate(-centerX, -centerY);
                        Rectangle2D anchor2 = txs.createTransformedShape(ps.getAnchor()).getBounds2D();
                        scaleX = DrawShape.safeScale(anchor.getWidth(), anchor2.getWidth());
                        scaleY = DrawShape.safeScale(anchor.getHeight(), anchor2.getHeight());
                    } else {
                        quadrant = 0;
                    }
                    graphics.translate(centerX, centerY);
                    double rot = Math.toRadians(rotation - (double)quadrant * 90.0);
                    if (rot != 0.0) {
                        graphics.rotate(rot);
                    }
                    graphics.scale(scaleX, scaleY);
                    rot = Math.toRadians(quadrant * 90);
                    if (rot != 0.0) {
                        graphics.rotate(rot);
                    }
                    graphics.translate(-centerX, -centerY);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("unexpected transform code " + ch);
                }
            }
        }
    }

    private static double safeScale(double dim1, double dim2) {
        if (dim1 == 0.0) {
            return 1.0;
        }
        return dim2 == 0.0 ? 1.0 : dim1 / dim2;
    }

    @Override
    public void draw(Graphics2D graphics) {
    }

    @Override
    public void drawContent(Graphics2D graphics) {
    }

    public static Rectangle2D getAnchor(Graphics2D graphics, PlaceableShape<?, ?> shape) {
        return DrawShape.getAnchor(graphics, shape.getAnchor());
    }

    public static Rectangle2D getAnchor(Graphics2D graphics, Rectangle2D anchor) {
        if (graphics == null) {
            return anchor;
        }
        AffineTransform tx = (AffineTransform)graphics.getRenderingHint(Drawable.GROUP_TRANSFORM);
        if (tx != null) {
            anchor = tx.createTransformedShape(anchor).getBounds2D();
        }
        return anchor;
    }

    protected Shape<?, ?> getShape() {
        return this.shape;
    }

    protected static BasicStroke getStroke(StrokeStyle strokeStyle) {
        int lineCap;
        StrokeStyle.LineCap lineCapE;
        StrokeStyle.LineDash lineDash;
        float lineWidth = (float)strokeStyle.getLineWidth();
        if (lineWidth == 0.0f) {
            lineWidth = 0.25f;
        }
        if ((lineDash = strokeStyle.getLineDash()) == null) {
            lineDash = StrokeStyle.LineDash.SOLID;
        }
        int[] dashPatI = lineDash.pattern;
        float dash_phase = 0.0f;
        float[] dashPatF = null;
        if (dashPatI != null) {
            dashPatF = new float[dashPatI.length];
            for (int i = 0; i < dashPatI.length; ++i) {
                dashPatF[i] = (float)dashPatI[i] * Math.max(1.0f, lineWidth);
            }
        }
        if ((lineCapE = strokeStyle.getLineCap()) == null) {
            lineCapE = StrokeStyle.LineCap.FLAT;
        }
        switch (lineCapE) {
            case ROUND: {
                lineCap = 1;
                break;
            }
            case SQUARE: {
                lineCap = 2;
                break;
            }
            default: {
                lineCap = 0;
            }
        }
        int lineJoin = 1;
        return new BasicStroke(lineWidth, lineCap, lineJoin, lineWidth, dashPatF, 0.0f);
    }
}

