/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.ByteArrayInputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianInput;

public final class LittleEndianByteArrayInputStream
extends ByteArrayInputStream
implements LittleEndianInput {
    public LittleEndianByteArrayInputStream(byte[] buf, int startOffset, int maxReadLen) {
        super(buf, startOffset, maxReadLen);
    }

    public LittleEndianByteArrayInputStream(byte[] buf, int startOffset) {
        super(buf, startOffset, buf.length - startOffset);
    }

    public LittleEndianByteArrayInputStream(byte[] buf) {
        super(buf);
    }

    private void checkPosition(int i) {
        if (i > this.count - this.pos) {
            throw new RuntimeException("Buffer overrun");
        }
    }

    public int getReadIndex() {
        return this.pos;
    }

    @Override
    public byte readByte() {
        this.checkPosition(1);
        return (byte)this.read();
    }

    @Override
    public int readInt() {
        int size = 4;
        this.checkPosition(4);
        int le = LittleEndian.getInt(this.buf, this.pos);
        super.skip(4L);
        return le;
    }

    @Override
    public long readLong() {
        int size = 8;
        this.checkPosition(8);
        long le = LittleEndian.getLong(this.buf, this.pos);
        super.skip(8L);
        return le;
    }

    @Override
    public short readShort() {
        return (short)this.readUShort();
    }

    @Override
    public int readUByte() {
        return this.readByte() & 0xFF;
    }

    @Override
    public int readUShort() {
        int size = 2;
        this.checkPosition(2);
        int le = LittleEndian.getUShort(this.buf, this.pos);
        super.skip(2L);
        return le;
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public void readFully(byte[] buffer, int off, int len) {
        this.checkPosition(len);
        this.read(buffer, off, len);
    }

    @Override
    public void readFully(byte[] buffer) {
        this.checkPosition(buffer.length);
        this.read(buffer, 0, buffer.length);
    }

    @Override
    public void readPlain(byte[] buf, int off, int len) {
        this.readFully(buf, off, len);
    }
}

