/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.metadata.replace;

import java.util.Set;
import javax.measure.unit.Unit;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.sis.internal.jaxb.metadata.direct.GO_MemberName;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.metadata.ReferencingServices;
import org.apache.sis.internal.simple.SimpleIdentifiedObject;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.iso.Names;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.InternationalString;
import org.opengis.util.MemberName;
import org.opengis.util.TypeName;

@XmlType(name="SV_Parameter_Type", namespace="http://www.isotc211.org/2005/srv", propOrder={"memberName", "description", "optionality", "repeatability", "valueType"})
@XmlRootElement(name="SV_Parameter", namespace="http://www.isotc211.org/2005/srv")
public final class ServiceParameter
extends SimpleIdentifiedObject
implements ParameterDescriptor {
    private static final long serialVersionUID = -5335736212313243889L;
    @XmlElement(required=true, name="name")
    @XmlJavaTypeAdapter(value=GO_MemberName.class)
    MemberName memberName;
    @XmlElement
    InternationalString description;
    public boolean optionality;
    @XmlElement(required=true)
    public boolean repeatability;
    private transient ParameterDescriptor descriptor;

    ServiceParameter() {
    }

    private ServiceParameter(ParameterDescriptor<?> parameterDescriptor) {
        super(parameterDescriptor);
        this.memberName = ServiceParameter.getMemberName(parameterDescriptor);
        this.optionality = parameterDescriptor.getMinimumOccurs() > 0;
        this.repeatability = parameterDescriptor.getMaximumOccurs() > 1;
    }

    public static ServiceParameter castOrCopy(ParameterDescriptor<?> parameterDescriptor) {
        if (parameterDescriptor == null || parameterDescriptor instanceof ServiceParameter) {
            return (ServiceParameter)parameterDescriptor;
        }
        return new ServiceParameter(parameterDescriptor);
    }

    public static MemberName getMemberName(ParameterDescriptor<?> parameterDescriptor) {
        if (parameterDescriptor != null) {
            Object object;
            ReferenceIdentifier referenceIdentifier = parameterDescriptor.getName();
            if (referenceIdentifier instanceof MemberName) {
                return (MemberName)((Object)referenceIdentifier);
            }
            Object object2 = CollectionsExt.nonNull(parameterDescriptor.getAlias()).iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!(object instanceof MemberName)) continue;
                return (MemberName)object;
            }
            if (referenceIdentifier != null && (object2 = parameterDescriptor.getValueClass()) != null && (object = referenceIdentifier.getCode()) != null) {
                return Names.createMemberName(referenceIdentifier.getCodeSpace(), ":", (CharSequence)object, object2);
            }
        }
        return null;
    }

    @Override
    public synchronized ReferenceIdentifier getName() {
        if (this.name == null && this.memberName != null) {
            this.name = this.memberName instanceof ReferenceIdentifier ? (ReferenceIdentifier)((Object)this.memberName) : new NameToIdentifier(this.memberName);
        }
        return this.name;
    }

    public Class<?> getValueClass() {
        return this.memberName != null ? Names.toClass(this.memberName.getAttributeType()) : null;
    }

    @XmlElement(name="valueType")
    final TypeName getValueType() {
        return this.memberName != null ? this.memberName.getAttributeType() : null;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    @XmlElement(name="optionality", required=true)
    final String getOptionality() {
        return this.optionality ? "Optional" : "Mandatory";
    }

    final void setOptionality(String string) {
        if (string != null) {
            this.optionality = Boolean.parseBoolean(string) || string.equalsIgnoreCase("Optional");
        }
    }

    @Override
    public int getMinimumOccurs() {
        return this.optionality ? 0 : 1;
    }

    @Override
    public int getMaximumOccurs() {
        return this.repeatability ? Integer.MAX_VALUE : 1;
    }

    public Set<?> getValidValues() {
        return null;
    }

    public Comparable<?> getMinimumValue() {
        return null;
    }

    public Comparable<?> getMaximumValue() {
        return null;
    }

    public Object getDefaultValue() {
        return null;
    }

    @Override
    public Unit<?> getUnit() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParameterValue<?> createValue() {
        ParameterDescriptor<?> parameterDescriptor;
        ServiceParameter serviceParameter = this;
        synchronized (serviceParameter) {
            parameterDescriptor = this.descriptor;
            if (parameterDescriptor == null) {
                this.descriptor = parameterDescriptor = ReferencingServices.getInstance().toImplementation(this);
            }
        }
        return parameterDescriptor.createValue();
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        ParameterDescriptor parameterDescriptor;
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode) && object instanceof ParameterDescriptor && (parameterDescriptor = (ParameterDescriptor)object).getUnit() == null && parameterDescriptor.getDefaultValue() == null && parameterDescriptor.getValueClass() == this.getValueClass()) {
            if (comparisonMode.isIgnoringMetadata()) {
                return Objects.equals(ServiceParameter.toString(this.getName()), ServiceParameter.toString(parameterDescriptor.getName()));
            }
            return parameterDescriptor.getMinimumOccurs() == this.getMinimumOccurs() && parameterDescriptor.getMaximumOccurs() == this.getMaximumOccurs() && parameterDescriptor.getValidValues() == null && parameterDescriptor.getMinimumValue() == null && parameterDescriptor.getMaximumValue() == null;
        }
        return false;
    }

    private static String toString(Identifier identifier) {
        return identifier != null ? identifier.toString() : null;
    }
}

