/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.resources.Errors;

public abstract class ChannelData {
    private static final int BIT_OFFSET_SIZE = 3;
    public final String filename;
    public final ByteBuffer buffer;
    final long channelOffset;
    long bufferOffset;
    private long bitPosition;
    private Mark mark;

    ChannelData(String string, Channel channel, ByteBuffer byteBuffer) throws IOException {
        this.filename = string;
        this.buffer = byteBuffer;
        this.channelOffset = channel instanceof FileChannel ? ((FileChannel)channel).position() : 0L;
    }

    public final int getBitOffset() {
        long l = this.bufferOffset + (long)this.buffer.position();
        if (this.bitPosition >>> 3 != l) {
            this.bitPosition = l << 3;
        }
        return (int)(this.bitPosition & 7L);
    }

    public final void setBitOffset(int n) {
        ArgumentChecks.ensureBetween("bitOffset", 0, 7, n);
        long l = this.bufferOffset + (long)this.buffer.position();
        this.bitPosition = l << 3 | (long)n;
    }

    final void clearBitOffset() {
        this.bitPosition = 0L;
    }

    public long getStreamPosition() {
        return this.bufferOffset + (long)this.buffer.position();
    }

    public final void setStreamPosition(long l) {
        this.bufferOffset = l - (long)this.buffer.position();
        this.clearBitOffset();
        this.mark = null;
    }

    public final long getFlushedPosition() {
        return this.bufferOffset;
    }

    public final void flushBefore(long l) throws IOException {
        long l2 = this.getStreamPosition();
        if (l < this.bufferOffset || l > l2) {
            throw new IndexOutOfBoundsException(Errors.format((short)133, "position", this.bufferOffset, l2, l));
        }
        int n = (int)(l - this.bufferOffset);
        int n2 = this.buffer.position() - n;
        int n3 = this.buffer.limit() - n;
        this.flushAndSetPosition(n);
        this.buffer.compact().position(n2).limit(n3);
        Mark mark = null;
        Mark mark2 = this.mark;
        while (mark2 != null) {
            if (mark2.position >= l) {
                mark = mark2;
            }
            mark2 = mark2.next;
        }
        if (mark != null) {
            mark.next = null;
        } else {
            this.mark = null;
        }
    }

    void flushAndSetPosition(int n) throws IOException {
        this.buffer.position(n);
        this.bufferOffset += (long)n;
    }

    public abstract void seek(long var1) throws IOException;

    public final void mark() {
        this.mark = new Mark(this.getStreamPosition(), (byte)this.getBitOffset(), this.mark);
    }

    public final void reset() throws IOException {
        Mark mark = this.mark;
        if (mark == null) {
            throw new InvalidMarkException();
        }
        this.mark = mark.next;
        this.seek(mark.position);
        this.setBitOffset(mark.bitOffset);
    }

    protected void onEmptyTransfer() throws IOException {
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[\u201c" + this.filename + "\u201d at " + this.getStreamPosition() + ']';
    }

    private static final class Mark {
        final long position;
        final byte bitOffset;
        Mark next;

        Mark(long l, byte by, Mark mark) {
            this.position = l;
            this.bitOffset = by;
            this.next = mark;
        }
    }
}

