/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.internal.geoapi.evolution.UnsupportedCodeList;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.citation.LegacyTelephones;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.CodeList;

@XmlType(name="CI_Telephone_Type", propOrder={"voices", "facsimiles"})
@XmlRootElement(name="CI_Telephone")
public class DefaultTelephone
extends ISOMetadata
implements Telephone {
    private static final long serialVersionUID = 5156405432420742237L;
    private String number;
    CodeList<?> numberType;
    @Deprecated
    private Collection<Telephone> owner;

    public DefaultTelephone() {
    }

    DefaultTelephone(String string, CodeList<?> codeList) {
        this.number = string;
        this.numberType = codeList;
    }

    public DefaultTelephone(Telephone telephone) {
        super(telephone);
        if (telephone != null) {
            if (telephone instanceof DefaultTelephone) {
                this.number = ((DefaultTelephone)telephone).getNumber();
                this.numberType = ((DefaultTelephone)telephone).numberType;
            } else {
                this.setVoices(telephone.getVoices());
                this.setFacsimiles(telephone.getFacsimiles());
            }
        }
    }

    public static DefaultTelephone castOrCopy(Telephone telephone) {
        if (telephone == null || telephone instanceof DefaultTelephone) {
            return (DefaultTelephone)telephone;
        }
        return new DefaultTelephone(telephone);
    }

    @UML(identifier="number", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String string) {
        this.checkWritePermission();
        this.number = string;
    }

    @UML(identifier="numberType", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public CodeList<?> getNumberType() {
        return this.numberType;
    }

    public void setNumberType(CodeList<?> codeList) {
        this.checkWritePermission();
        this.numberType = codeList;
    }

    final DefaultTelephone setOwner(Collection<Telephone> collection) {
        if (this.owner != collection) {
            if (this.owner != null && !CollectionsExt.identityEquals(this.owner.iterator(), collection.iterator())) {
                DefaultTelephone defaultTelephone = new DefaultTelephone(this);
                defaultTelephone.owner = collection;
                return defaultTelephone;
            }
            this.owner = collection;
        }
        return this;
    }

    final Collection<Telephone> getOwner() {
        if (this.owner == null) {
            if (this.isModifiable()) {
                this.owner = new ArrayList<Telephone>(4);
                this.owner.add(this);
            } else {
                this.owner = Collections.singletonList(this);
            }
        }
        return this.owner;
    }

    @Override
    @Deprecated
    @XmlElement(name="voice")
    public final Collection<String> getVoices() {
        return new LegacyTelephones(this.getOwner(), UnsupportedCodeList.VOICE);
    }

    @Deprecated
    public void setVoices(Collection<? extends String> collection) {
        ((LegacyTelephones)this.getVoices()).setValues(collection);
    }

    @Override
    @Deprecated
    @XmlElement(name="facsimile")
    public final Collection<String> getFacsimiles() {
        return new LegacyTelephones(this.getOwner(), UnsupportedCodeList.FACSIMILE);
    }

    @Deprecated
    public void setFacsimiles(Collection<? extends String> collection) {
        ((LegacyTelephones)this.getFacsimiles()).setValues(collection);
    }
}

