/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.langdetect;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.language.detect.LanguageConfidence;
import org.apache.tika.language.detect.LanguageDetector;
import org.apache.tika.language.detect.LanguageResult;

public class TextLangDetector
extends LanguageDetector {
    private static final String TEXT_REST_HOST = "http://localhost:8000";
    private static final String TEXT_LID_PATH = "/lid";
    private static String restHostUrlStr;
    private Set<String> languages;
    private CharArrayWriter writer;

    public TextLangDetector() {
        restHostUrlStr = TEXT_REST_HOST;
        this.languages = this.getAllLanguages();
        this.writer = new CharArrayWriter();
    }

    @Override
    public LanguageDetector loadModels() throws IOException {
        return null;
    }

    @Override
    public LanguageDetector loadModels(Set<String> set) throws IOException {
        return null;
    }

    @Override
    public boolean hasModel(String language) {
        return this.languages.contains(language);
    }

    @Override
    public LanguageDetector setPriors(Map<String, Float> languageProbabilities) throws IOException {
        return null;
    }

    @Override
    public void reset() {
        this.writer.reset();
    }

    @Override
    public void addText(char[] cbuf, int off, int len) {
        this.writer.write(cbuf, off, len);
        this.writer.write(32);
    }

    @Override
    public List<LanguageResult> detectAll() {
        ArrayList<LanguageResult> result = new ArrayList<LanguageResult>();
        String language = this.detect(this.writer.toString());
        if (language != null) {
            result.add(new LanguageResult(language, LanguageConfidence.MEDIUM, 1.0f));
        } else {
            result.add(new LanguageResult(language, LanguageConfidence.NONE, 0.0f));
        }
        return result;
    }

    private Set<String> getAllLanguages() {
        HashSet<String> languages = new HashSet<String>();
        try {
            Response response = WebClient.create(restHostUrlStr + TEXT_LID_PATH).get();
            String json = response.readEntity(String.class);
            JsonArray jsonArray = new JsonParser().parse(json).getAsJsonObject().get("all_languages").getAsJsonArray();
            for (JsonElement jsonElement : jsonArray) {
                languages.add(jsonElement.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return languages;
    }

    private String detect(String content) {
        String language = null;
        try {
            Response response = WebClient.create(restHostUrlStr + TEXT_LID_PATH).put(content);
            String json = response.readEntity(String.class);
            language = new JsonParser().parse(json).getAsJsonObject().get("language").getAsString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return language;
    }

    protected static boolean canRun() {
        try {
            Response response = WebClient.create("http://localhost:8000/lid").get();
            String json = response.readEntity(String.class);
            JsonArray jsonArray = new JsonParser().parse(json).getAsJsonObject().get("all_languages").getAsJsonArray();
            return jsonArray.size() != 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

