/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language.translate;

import com.memetix.mst.language.Language;
import com.memetix.mst.translate.Translate;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.translate.Translator;

public class MicrosoftTranslator
implements Translator {
    boolean available;
    String clientId;
    String clientSecret;
    public static final String PROPERTIES_FILE = "translator.microsoft.properties";
    public static final String ID_PROPERTY = "translator.client-id";
    public static final String SECRET_PROPERTY = "translator.client-secret";
    public static final String DEFAULT_ID = "dummy-id";
    public static final String DEFAULT_SECRET = "dummy-secret";

    public MicrosoftTranslator() {
        Properties props = new Properties();
        InputStream stream = MicrosoftTranslator.class.getResourceAsStream(PROPERTIES_FILE);
        try {
            if (stream != null) {
                props.load(stream);
                this.clientId = props.getProperty(ID_PROPERTY);
                this.clientSecret = props.getProperty(SECRET_PROPERTY);
                this.available = this.checkAvailable();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.available = false;
        }
    }

    @Override
    public String translate(String text, String sourceLanguage, String targetLanguage) throws TikaException, IOException {
        if (!this.available) {
            return text;
        }
        Language source = Language.fromString(sourceLanguage);
        Language target = Language.fromString(targetLanguage);
        Translate.setClientId(this.clientId);
        Translate.setClientSecret(this.clientSecret);
        try {
            return Translate.execute(text, source, target);
        }
        catch (Exception e) {
            throw new TikaException("Error with Microsoft Translation: " + e.getMessage());
        }
    }

    @Override
    public String translate(String text, String targetLanguage) throws TikaException, IOException {
        if (!this.available) {
            return text;
        }
        Language target = Language.fromString(targetLanguage);
        Translate.setClientId(this.clientId);
        Translate.setClientSecret(this.clientSecret);
        try {
            return Translate.execute(text, target);
        }
        catch (Exception e) {
            throw new TikaException("Error with Microsoft Translation: " + e.getMessage());
        }
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    public void setId(String id) {
        this.clientId = id;
        this.available = this.checkAvailable();
    }

    public void setSecret(String secret) {
        this.clientSecret = secret;
        this.available = this.checkAvailable();
    }

    private boolean checkAvailable() {
        return this.clientId != null && !this.clientId.equals(DEFAULT_ID) && this.clientSecret != null && !this.clientSecret.equals(DEFAULT_SECRET);
    }
}

