/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.TikaCoreProperties;

public abstract class MetadataFields {
    private static HashSet<String> known = new HashSet();

    private static void setKnownForClass(Class<?> clazz) {
        Field[] fields;
        for (Field f : fields = clazz.getFields()) {
            Object p;
            int mod = f.getModifiers();
            if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !Modifier.isFinal(mod)) continue;
            Class<?> c = f.getType();
            if (String.class.equals(c)) {
                try {
                    p = (String)f.get(null);
                    if (p != null) {
                        known.add((String)p);
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            if (!Property.class.isAssignableFrom(c)) continue;
            try {
                p = (Property)f.get(null);
                if (p == null) continue;
                known.add(((Property)p).getName());
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isMetadataField(String name) {
        return known.contains(name);
    }

    public static boolean isMetadataField(Property property) {
        return known.contains(property.getName());
    }

    static {
        MetadataFields.setKnownForClass(TikaCoreProperties.class);
        MetadataFields.setKnownForClass(Metadata.class);
    }
}

