/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.journal;

import java.util.ArrayList;
import java.util.List;
import org.apache.tika.metadata.Metadata;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.XML;

public class TEIParser {
    public Metadata parse(String source) {
        JSONObject obj = XML.toJSONObject(source);
        Metadata metadata = new Metadata();
        this.createGrobidMetadata(source, obj, metadata);
        return metadata;
    }

    private void createGrobidMetadata(String source, JSONObject obj, Metadata metadata) {
        if (obj != null) {
            try {
                JSONObject teiHeader = obj.getJSONObject("TEI").getJSONObject("teiHeader");
                if (teiHeader.has("text")) {
                    this.parseText(teiHeader.getJSONObject("text"), metadata);
                }
                if (teiHeader.has("fileDesc")) {
                    this.parseFileDesc(teiHeader.getJSONObject("fileDesc"), metadata);
                }
                if (teiHeader.has("profileDesc")) {
                    this.parseProfileDesc(teiHeader.getJSONObject("profileDesc"), metadata);
                }
            }
            catch (JSONException e) {
                System.out.println("No TEI Object found.");
            }
        }
        this.addStaticMet(source, obj, metadata);
    }

    private void addStaticMet(String source, JSONObject obj, Metadata metadata) {
        metadata.add("Class", Metadata.class.getName());
        metadata.add("TEIJSONSource", obj.toString());
        metadata.add("TEIXMLSource", source);
    }

    private void parseText(JSONObject text, Metadata metadata) {
        if (text.has("xml:lang")) {
            metadata.add("Language", text.getString("xml:lang"));
        }
    }

    private void parseFileDesc(JSONObject fileDesc, Metadata metadata) {
        if (fileDesc.has("titleStmt")) {
            this.parseTitleStmt(fileDesc.getJSONObject("titleStmt"), metadata);
        }
        if (fileDesc.has("sourceDesc")) {
            this.parseSourceDesc(fileDesc.getJSONObject("sourceDesc"), metadata);
        }
    }

    private void parseTitleStmt(JSONObject titleStmt, Metadata metadata) {
        JSONObject title;
        if (titleStmt.has("title") && (title = titleStmt.getJSONObject("title")).has("content")) {
            metadata.add("Title", title.getString("content"));
        }
    }

    private void parseSourceDesc(JSONObject sourceDesc, Metadata metadata) {
        if (sourceDesc.has("biblStruct")) {
            this.parseBiblStruct(sourceDesc.getJSONObject("biblStruct"), metadata);
        }
    }

    private void parseBiblStruct(JSONObject biblStruct, Metadata metadata) {
        if (biblStruct.has("analytic") && biblStruct.get("analytic") instanceof JSONObject) {
            JSONObject analytic = biblStruct.getJSONObject("analytic");
            if (analytic.has("author")) {
                Object authorObj = analytic.get("author");
                ArrayList<Author> authorList = new ArrayList<Author>();
                if (authorObj instanceof JSONObject) {
                    this.parseAuthor((JSONObject)authorObj, authorList);
                } else if (authorObj instanceof JSONArray) {
                    JSONArray authors = (JSONArray)authorObj;
                    if (authors.length() > 0) {
                        for (int i = 0; i < authors.length(); ++i) {
                            JSONObject author = authors.getJSONObject(i);
                            this.parseAuthor(author, authorList);
                        }
                    }
                    metadata.add("Address", this.getMetadataAddresses(authorList));
                    metadata.add("Affiliation", this.getMetadataAffiliations(authorList));
                    metadata.add("Authors", this.getMetadataAuthors(authorList));
                    metadata.add("FullAffiliations", this.getMetadataFullAffiliations(authorList));
                }
            }
        } else {
            metadata.add("Error", "Unable to parse: no analytic section in JSON");
        }
    }

    private String getMetadataFullAffiliations(List<Author> authorList) {
        ArrayList<Affiliation> unique = new ArrayList<Affiliation>();
        StringBuilder metAffils = new StringBuilder();
        for (Author a : authorList) {
            for (Affiliation af : a.getAffiliations()) {
                if (unique.contains(af)) continue;
                unique.add(af);
            }
        }
        metAffils.append("[");
        for (Affiliation af : unique) {
            metAffils.append(af.toString());
            metAffils.append(",");
        }
        metAffils.append((CharSequence)metAffils.deleteCharAt(metAffils.length() - 1));
        metAffils.append("]");
        return metAffils.toString();
    }

    private String getMetadataAuthors(List<Author> authorList) {
        ArrayList<Affiliation> unique = new ArrayList<Affiliation>();
        StringBuilder metAuthors = new StringBuilder();
        for (Author a : authorList) {
            for (Affiliation af : a.getAffiliations()) {
                if (unique.contains(af)) continue;
                unique.add(af);
            }
        }
        for (Author a : authorList) {
            metAuthors.append(this.printOrBlank(a.getFirstName()));
            metAuthors.append(this.printOrBlank(a.getMiddleName()));
            metAuthors.append(this.printOrBlank(a.getSurName()));
            StringBuilder affilBuilder = new StringBuilder();
            for (int idx = 0; idx < unique.size(); ++idx) {
                Affiliation af = (Affiliation)unique.get(idx);
                if (!a.getAffiliations().contains(af)) continue;
                affilBuilder.append(idx + 1);
                affilBuilder.append(",");
            }
            if (affilBuilder.length() > 0) {
                affilBuilder.deleteCharAt(affilBuilder.length() - 1);
            }
            metAuthors.append(affilBuilder.toString());
            metAuthors.append(" ");
        }
        return metAuthors.toString();
    }

    private String getMetadataAffiliations(List<Author> authorList) {
        ArrayList<Affiliation> unique = new ArrayList<Affiliation>();
        StringBuilder metAffil = new StringBuilder();
        for (Author a : authorList) {
            for (Affiliation af : a.getAffiliations()) {
                if (unique.contains(af)) continue;
                unique.add(af);
            }
        }
        int count = 1;
        for (Affiliation a : unique) {
            metAffil.append(count);
            metAffil.append(" ");
            metAffil.append(a.getOrgName().toString());
            metAffil.deleteCharAt(metAffil.length() - 1);
            metAffil.append("; ");
            ++count;
        }
        if (count > 1) {
            metAffil.deleteCharAt(metAffil.length() - 1);
            metAffil.deleteCharAt(metAffil.length() - 1);
        }
        return metAffil.toString();
    }

    private String getMetadataAddresses(List<Author> authorList) {
        ArrayList<Address> unique = new ArrayList<Address>();
        StringBuilder metAddress = new StringBuilder();
        for (Author a : authorList) {
            for (Affiliation af : a.getAffiliations()) {
                if (unique.contains(af.getAddress())) continue;
                unique.add(af.getAddress());
            }
        }
        for (Address ad : unique) {
            metAddress.append(ad.toString());
            metAddress.append(" ");
        }
        return metAddress.toString();
    }

    private void parseAuthor(JSONObject authorObj, List<Author> authorList) {
        Author author = new Author();
        if (authorObj.has("persName")) {
            JSONObject persName = authorObj.getJSONObject("persName");
            if (persName.has("forename")) {
                JSONArray foreName;
                Object foreNameObj = persName.get("forename");
                if (foreNameObj instanceof JSONObject) {
                    this.parseNamePart((JSONObject)foreNameObj, author);
                } else if (foreNameObj instanceof JSONArray && (foreName = persName.getJSONArray("forename")).length() > 0) {
                    for (int i = 0; i < foreName.length(); ++i) {
                        JSONObject namePart = foreName.getJSONObject(i);
                        this.parseNamePart(namePart, author);
                    }
                }
            }
            if (persName.has("surname")) {
                author.setSurName(persName.getString("surname"));
            }
            if (authorObj.has("affiliation")) {
                this.parseAffiliation(authorObj.get("affiliation"), author);
            }
        }
        authorList.add(author);
    }

    private void parseNamePart(JSONObject namePart, Author author) {
        if (namePart.has("type") && namePart.has("content")) {
            String type = namePart.getString("type");
            String content = namePart.getString("content");
            if (type.equals("first")) {
                author.setFirstName(content);
            }
            if (type.equals("middle")) {
                author.setMiddleName(content);
            }
        }
    }

    private void parseAffiliation(Object affiliationJSON, Author author) {
        JSONArray affiliationArray;
        if (affiliationJSON instanceof JSONObject) {
            this.parseOneAffiliation((JSONObject)affiliationJSON, author);
        } else if (affiliationJSON instanceof JSONArray && (affiliationArray = (JSONArray)affiliationJSON) != null && affiliationArray.length() > 0) {
            for (int i = 0; i < affiliationArray.length(); ++i) {
                JSONObject affiliationObj = affiliationArray.getJSONObject(i);
                this.parseOneAffiliation(affiliationObj, author);
            }
        }
    }

    private void parseOneAffiliation(JSONObject affiliationObj, Author author) {
        Affiliation affiliation = new Affiliation();
        if (affiliationObj.has("address")) {
            this.parseAddress(affiliationObj.getJSONObject("address"), affiliation);
        }
        if (affiliationObj.has("orgName")) {
            OrgName orgName = new OrgName();
            Object orgObject = affiliationObj.get("orgName");
            if (orgObject instanceof JSONObject) {
                this.parseOrgName((JSONObject)orgObject, orgName);
            } else if (orgObject instanceof JSONArray) {
                JSONArray orgNames = (JSONArray)orgObject;
                if (orgNames != null && orgNames.length() > 0) {
                    for (int i = 0; i < orgNames.length(); ++i) {
                        this.parseOrgName(orgNames.getJSONObject(i), orgName);
                    }
                }
                affiliation.setOrgName(orgName);
            }
        }
        author.getAffiliations().add(affiliation);
    }

    private void parseAddress(JSONObject addressObj, Affiliation affiliation) {
        Address address = new Address();
        if (addressObj.has("region")) {
            address.setRegion(addressObj.getString("region"));
        }
        if (addressObj.has("postCode")) {
            address.setPostCode(JSONObject.valueToString(addressObj.get("postCode")));
        }
        if (addressObj.has("settlement")) {
            address.setSettlment(addressObj.getString("settlement"));
        }
        if (addressObj.has("country")) {
            Country country = new Country();
            Object countryObj = addressObj.get("country");
            if (countryObj instanceof JSONObject) {
                JSONObject countryJson = addressObj.getJSONObject("country");
                if (countryJson.has("content")) {
                    country.setContent(countryJson.getString("content"));
                }
                if (countryJson.has("key")) {
                    country.setKey(countryJson.getString("key"));
                }
            } else if (countryObj instanceof String) {
                country.setContent((String)countryObj);
            }
            address.setCountry(country);
        }
        affiliation.setAddress(address);
    }

    private void parseOrgName(JSONObject orgObj, OrgName orgName) {
        OrgTypeName typeName = new OrgTypeName();
        if (orgObj.has("content")) {
            typeName.setName(orgObj.getString("content"));
        }
        if (orgObj.has("type")) {
            typeName.setType(orgObj.getString("type"));
        }
        orgName.getTypeNames().add(typeName);
    }

    private void parseProfileDesc(JSONObject profileDesc, Metadata metadata) {
        JSONObject textClass;
        if (profileDesc.has("abstract") && profileDesc.has("p")) {
            metadata.add("Abstract", profileDesc.getString("p"));
        }
        if (profileDesc.has("textClass") && (textClass = profileDesc.getJSONObject("textClass")).has("keywords")) {
            JSONObject keywords;
            Object keywordsObj = textClass.get("keywords");
            if (keywordsObj instanceof String) {
                metadata.add("Keyword", (String)keywordsObj);
            } else if (keywordsObj instanceof JSONObject && (keywords = textClass.getJSONObject("keywords")).has("term")) {
                JSONArray termArr = keywords.getJSONArray("term");
                for (int i = 0; i < termArr.length(); ++i) {
                    metadata.add("Keyword", JSONObject.valueToString(termArr.get(i)));
                }
            }
        }
    }

    private String printOrBlank(String val) {
        if (val != null && !val.equals("")) {
            return val + " ";
        }
        return " ";
    }

    private class Country {
        private String key = null;
        private String content = null;

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public boolean equals(Object obj) {
            Country otherC = (Country)obj;
            if (this.key == null) {
                if (otherC.getKey() != null) {
                    return false;
                }
                if (this.content == null) {
                    return otherC.getContent() == null;
                }
                return this.content.equals(otherC.getContent());
            }
            if (this.content == null) {
                if (otherC.getContent() != null) {
                    return false;
                }
                return this.key.equals(otherC.getKey());
            }
            return this.key.equals(otherC.getKey()) && this.content.equals(otherC.getContent());
        }
    }

    private class Address {
        private String region = null;
        private String postCode = null;
        private String settlment = null;
        private Country country;

        public Address() {
            this.country = new Country();
        }

        public String getRegion() {
            return this.region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getPostCode() {
            return this.postCode;
        }

        public void setPostCode(String postCode) {
            this.postCode = postCode;
        }

        public String getSettlment() {
            return this.settlment;
        }

        public void setSettlment(String settlment) {
            this.settlment = settlment;
        }

        public Country getCountry() {
            return this.country;
        }

        public void setCountry(Country country) {
            this.country = country;
        }

        public boolean equals(Object obj) {
            Address otherA = (Address)obj;
            if (this.settlment == null) {
                return otherA.getSettlment() == null;
            }
            if (this.country == null) {
                return otherA.getCountry() == null;
            }
            if (this.postCode == null) {
                return otherA.getPostCode() == null;
            }
            if (this.region == null) {
                return otherA.getRegion() == null;
            }
            return this.settlment.equals(otherA.getSettlment()) && this.country.equals(otherA.getCountry()) && this.postCode.equals(otherA.getPostCode()) && this.region.equals(otherA.getRegion());
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.settlment);
            builder.append(", ");
            builder.append(this.region);
            builder.append(" ");
            builder.append(this.postCode);
            builder.append(" ");
            builder.append(this.country.getContent());
            return builder.toString();
        }
    }

    class OrgTypeName {
        private String name = null;
        private String type = null;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean equals(Object obj) {
            OrgTypeName otherOrgName = (OrgTypeName)obj;
            return this.type.equals(otherOrgName.getType()) && this.name.equals(otherOrgName.getName());
        }
    }

    class OrgName {
        private List<OrgTypeName> typeNames = new ArrayList<OrgTypeName>();

        public List<OrgTypeName> getTypeNames() {
            return this.typeNames;
        }

        public void setTypeNames(List<OrgTypeName> typeNames) {
            this.typeNames = typeNames;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (OrgTypeName on : this.typeNames) {
                builder.append(on.getName());
                builder.append(" ");
            }
            return builder.toString();
        }

        public boolean equals(Object obj) {
            OrgName otherA = (OrgName)obj;
            if (otherA.getTypeNames() != null) {
                if (this.typeNames == null) {
                    return false;
                }
                return this.typeNames.size() == otherA.getTypeNames().size();
            }
            return this.typeNames == null;
        }
    }

    class Affiliation {
        private OrgName orgName;
        private Address address;

        public Affiliation() {
            this.orgName = new OrgName();
            this.address = new Address();
        }

        public OrgName getOrgName() {
            return this.orgName;
        }

        public void setOrgName(OrgName orgName) {
            this.orgName = orgName;
        }

        public Address getAddress() {
            return this.address;
        }

        public void setAddress(Address address) {
            this.address = address;
        }

        public boolean equals(Object obj) {
            Affiliation otherA = (Affiliation)obj;
            return this.getAddress().equals(otherA.getAddress()) && this.getOrgName().equals(otherA.getOrgName());
        }

        public String toString() {
            return "Affiliation {orgName=" + this.orgName + ", address=" + this.address + "}";
        }
    }

    class Author {
        private String surName = null;
        private String middleName = null;
        private String firstName = null;
        private List<Affiliation> affiliations = new ArrayList<Affiliation>();

        public String getSurName() {
            return this.surName;
        }

        public void setSurName(String surName) {
            this.surName = surName;
        }

        public String getMiddleName() {
            return this.middleName;
        }

        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public List<Affiliation> getAffiliations() {
            return this.affiliations;
        }

        public void setAffiliations(List<Affiliation> affiliations) {
            this.affiliations = affiliations;
        }

        public String toString() {
            return "Author [surName=" + this.surName + ", middleName=" + this.middleName != null ? this.middleName : ", firstName=" + this.firstName + ", affiliations=" + this.affiliations + "]";
        }
    }
}

