/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.ocr;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;

public class TesseractOCRConfig
implements Serializable {
    private static final long serialVersionUID = -4861942486845757891L;
    private String tesseractPath = "";
    private String tessdataPath = "";
    private String language = "eng";
    private String pageSegMode = "1";
    private int minFileSizeToOcr = 0;
    private int maxFileSizeToOcr = Integer.MAX_VALUE;
    private int timeout = 120;
    private OUTPUT_TYPE outputType = OUTPUT_TYPE.TXT;
    private int enableImageProcessing = 0;
    private String ImageMagickPath = "";
    private int density = 300;
    private int depth = 4;
    private String colorspace = "gray";
    private String filter = "triangle";
    private int resize = 900;
    private boolean preserveInterwordSpacing = false;

    public TesseractOCRConfig() {
        this.init(this.getClass().getResourceAsStream("TesseractOCRConfig.properties"));
    }

    public TesseractOCRConfig(InputStream is) {
        this.init(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(InputStream is) {
        if (is == null) {
            return;
        }
        Properties props = new Properties();
        try {
            props.load(is);
        }
        catch (IOException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        this.setTesseractPath(this.getProp(props, "tesseractPath", this.getTesseractPath()));
        this.setTessdataPath(this.getProp(props, "tessdataPath", this.getTessdataPath()));
        this.setLanguage(this.getProp(props, "language", this.getLanguage()));
        this.setPageSegMode(this.getProp(props, "pageSegMode", this.getPageSegMode()));
        this.setMinFileSizeToOcr(this.getProp(props, "minFileSizeToOcr", this.getMinFileSizeToOcr()));
        this.setMaxFileSizeToOcr(this.getProp(props, "maxFileSizeToOcr", this.getMaxFileSizeToOcr()));
        this.setTimeout(this.getProp(props, "timeout", this.getTimeout()));
        String outputTypeString = props.getProperty("outputType");
        if ("txt".equals(outputTypeString)) {
            this.setOutputType(OUTPUT_TYPE.TXT);
        } else if ("hocr".equals(outputTypeString)) {
            this.setOutputType(OUTPUT_TYPE.HOCR);
        }
        this.setPreserveInterwordSpacing(this.getProp(props, "preserveInterwordSpacing", false));
        this.setEnableImageProcessing(this.getProp(props, "enableImageProcessing", this.isEnableImageProcessing()));
        this.setImageMagickPath(this.getProp(props, "ImageMagickPath", this.getImageMagickPath()));
        this.setDensity(this.getProp(props, "density", this.getDensity()));
        this.setDepth(this.getProp(props, "depth", this.getDepth()));
        this.setColorspace(this.getProp(props, "colorspace", this.getColorspace()));
        this.setFilter(this.getProp(props, "filter", this.getFilter()));
        this.setResize(this.getProp(props, "resize", this.getResize()));
    }

    public String getTesseractPath() {
        return this.tesseractPath;
    }

    public void setTesseractPath(String tesseractPath) {
        if (!tesseractPath.isEmpty() && !tesseractPath.endsWith(File.separator)) {
            tesseractPath = tesseractPath + File.separator;
        }
        this.tesseractPath = tesseractPath;
    }

    public String getTessdataPath() {
        return this.tessdataPath;
    }

    public void setTessdataPath(String tessdataPath) {
        if (!tessdataPath.isEmpty() && !tessdataPath.endsWith(File.separator)) {
            tessdataPath = tessdataPath + File.separator;
        }
        this.tessdataPath = tessdataPath;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        if (!language.matches("([a-zA-Z]{3}(_[a-zA-Z]{3,4})?(\\+?))+") || language.endsWith("+")) {
            throw new IllegalArgumentException("Invalid language code");
        }
        this.language = language;
    }

    public String getPageSegMode() {
        return this.pageSegMode;
    }

    public void setPageSegMode(String pageSegMode) {
        if (!pageSegMode.matches("[1-9]|10")) {
            throw new IllegalArgumentException("Invalid language code");
        }
        this.pageSegMode = pageSegMode;
    }

    public void setPreserveInterwordSpacing(boolean preserveInterwordSpacing) {
        this.preserveInterwordSpacing = preserveInterwordSpacing;
    }

    public boolean getPreserveInterwordSpacing() {
        return this.preserveInterwordSpacing;
    }

    public int getMinFileSizeToOcr() {
        return this.minFileSizeToOcr;
    }

    public void setMinFileSizeToOcr(int minFileSizeToOcr) {
        this.minFileSizeToOcr = minFileSizeToOcr;
    }

    public int getMaxFileSizeToOcr() {
        return this.maxFileSizeToOcr;
    }

    public void setMaxFileSizeToOcr(int maxFileSizeToOcr) {
        this.maxFileSizeToOcr = maxFileSizeToOcr;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setOutputType(OUTPUT_TYPE outputType) {
        this.outputType = outputType;
    }

    public OUTPUT_TYPE getOutputType() {
        return this.outputType;
    }

    public int isEnableImageProcessing() {
        return this.enableImageProcessing;
    }

    public void setEnableImageProcessing(int enableImageProcessing) {
        this.enableImageProcessing = enableImageProcessing;
    }

    public int getDensity() {
        return this.density;
    }

    public void setDensity(int density) {
        if (density < 150 || density > 1200) {
            throw new IllegalArgumentException("Invalid density value. Valid range of values is 150-1200.");
        }
        this.density = density;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        int[] allowedValues = new int[]{2, 4, 8, 16, 32, 64, 256, 4096};
        for (int i = 0; i < allowedValues.length; ++i) {
            if (depth != allowedValues[i]) continue;
            this.depth = depth;
            return;
        }
        throw new IllegalArgumentException("Invalid depth value. Valid values are 2, 4, 8, 16, 32, 64, 256, 4096.");
    }

    public String getColorspace() {
        return this.colorspace;
    }

    public void setColorspace(String colorspace) {
        if (colorspace.equals(null)) {
            throw new IllegalArgumentException("Colorspace value cannot be null.");
        }
        this.colorspace = colorspace;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        if (filter.equals(null)) {
            throw new IllegalArgumentException("Filter value cannot be null. Valid values are point, hermite, cubic, box, gaussian, catrom, triangle, quadratic and mitchell.");
        }
        String[] allowedFilters = new String[]{"Point", "Hermite", "Cubic", "Box", "Gaussian", "Catrom", "Triangle", "Quadratic", "Mitchell"};
        for (int i = 0; i < allowedFilters.length; ++i) {
            if (!filter.equalsIgnoreCase(allowedFilters[i])) continue;
            this.filter = filter;
            return;
        }
        throw new IllegalArgumentException("Invalid filter value. Valid values are point, hermite, cubic, box, gaussian, catrom, triangle, quadratic and mitchell.");
    }

    public int getResize() {
        return this.resize;
    }

    public void setResize(int resize) {
        for (int i = 1; i < 10; ++i) {
            if (resize != i * 100) continue;
            this.resize = resize;
            return;
        }
        throw new IllegalArgumentException("Invalid resize value. Valid range of values is 100-900.");
    }

    public String getImageMagickPath() {
        return this.ImageMagickPath;
    }

    public void setImageMagickPath(String ImageMagickPath) {
        if (!ImageMagickPath.isEmpty() && !ImageMagickPath.endsWith(File.separator)) {
            ImageMagickPath = ImageMagickPath + File.separator;
        }
        this.ImageMagickPath = ImageMagickPath;
    }

    private int getProp(Properties properties, String property, int defaultMissing) {
        String p = properties.getProperty(property);
        if (p == null || p.isEmpty()) {
            return defaultMissing;
        }
        try {
            return Integer.parseInt(p);
        }
        catch (Throwable ex) {
            throw new RuntimeException(String.format(Locale.ROOT, "Cannot parse TesseractOCRConfig variable %s, invalid integer value", property), ex);
        }
    }

    private String getProp(Properties properties, String property, String defaultMissing) {
        return properties.getProperty(property, defaultMissing);
    }

    private boolean getProp(Properties properties, String property, boolean defaultMissing) {
        String propVal = properties.getProperty(property);
        if (propVal == null) {
            return defaultMissing;
        }
        if (propVal.equalsIgnoreCase("true")) {
            return true;
        }
        if (propVal.equalsIgnoreCase("false")) {
            return false;
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Cannot parse TesseractOCRConfig variable %s, invalid boolean value: %s", property, propVal));
    }

    public static enum OUTPUT_TYPE {
        TXT,
        HOCR;

    }
}

