/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.wordperfect;

import java.io.IOException;
import org.apache.tika.parser.wordperfect.WP5Charsets;
import org.apache.tika.parser.wordperfect.WPDocumentAreaExtractor;
import org.apache.tika.parser.wordperfect.WPInputStream;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

class WP5DocumentAreaExtractor
extends WPDocumentAreaExtractor {
    WP5DocumentAreaExtractor() {
    }

    @Override
    protected void extract(int c, WPInputStream in, StringBuilder out, XHTMLContentHandler xhtml) throws IOException, SAXException {
        if (c == 10) {
            this.endParagraph(out, xhtml);
        } else if (c == 11) {
            out.append(' ');
        } else if (c == 12) {
            this.endParagraph(out, xhtml);
        } else if (c == 13) {
            out.append(' ');
        } else if (c >= 32 && c <= 126) {
            out.append((char)c);
        } else if (c == 140) {
            this.endParagraph(out, xhtml);
        } else if (c >= 144 && c <= 149) {
            out.append(' ');
        } else if (c == 153) {
            this.endParagraph(out, xhtml);
        } else if (c == 160) {
            out.append('\u00a0');
        } else if (c >= 169 && c <= 171) {
            out.append('-');
        } else if (c == 192) {
            int charval = in.readWP();
            int charset = in.readWP();
            in.readWP();
            WP5Charsets.append(out, charset, charval);
        } else if (c >= 193 && c <= 207) {
            this.skipUntilChar(in, c);
        } else if (c >= 208 && c <= 255) {
            in.readWP();
            int functionSize = in.readWPShort();
            for (int i = 0; i < functionSize; ++i) {
                in.readWP();
            }
        }
    }
}

