/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.server.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.server.HTMLHelper;
import org.apache.tika.server.resource.TikaResource;
import org.eclipse.jetty.util.ajax.JSON;

@Path(value="/mime-types")
public class TikaMimeTypes {
    private HTMLHelper html = new HTMLHelper();

    @GET
    @Produces(value={"text/html"})
    public String getMimeTypesHTML() {
        StringBuffer h = new StringBuffer();
        this.html.generateHeader(h, "Apache Tika Supported Mime Types");
        List<MediaTypeDetails> types = this.getMediaTypes();
        TreeMap<String, String> firstType = new TreeMap<String, String>();
        for (MediaTypeDetails type : types) {
            if (firstType.containsKey(type.type.getType())) continue;
            firstType.put(type.type.getType(), type.type.toString());
        }
        h.append("<ul>");
        for (String section : firstType.keySet()) {
            h.append("<li><a href=\"#").append((String)firstType.get(section)).append("\">").append(section).append("</a></li>\n");
        }
        h.append("</ul>");
        for (MediaTypeDetails type : types) {
            h.append("<a name=\"").append(type.type).append("\"></a>\n");
            h.append("<h2>").append(type.type).append("</h2>\n");
            for (MediaType alias : type.aliases) {
                h.append("<div>Alias: ").append(alias).append("</div>\n");
            }
            if (type.supertype != null) {
                h.append("<div>Super Type: <a href=\"#").append(type.supertype).append("\">").append(type.supertype).append("</a></div>\n");
            }
            if (type.parser == null) continue;
            h.append("<div>Parser: ").append(type.parser).append("</div>\n");
        }
        this.html.generateFooter(h);
        return h.toString();
    }

    @GET
    @Produces(value={"application/json"})
    public String getMimeTypesJSON() {
        HashMap details = new HashMap();
        for (MediaTypeDetails type : this.getMediaTypes()) {
            HashMap<String, Object> typeDets = new HashMap<String, Object>();
            typeDets.put("alias", type.aliases);
            if (type.supertype != null) {
                typeDets.put("supertype", type.supertype);
            }
            if (type.parser != null) {
                typeDets.put("parser", type.parser);
            }
            details.put(type.type.toString(), typeDets);
        }
        return JSON.toString(details);
    }

    @GET
    @Produces(value={"text/plain"})
    public String getMimeTypesPlain() {
        StringBuffer text = new StringBuffer();
        for (MediaTypeDetails type : this.getMediaTypes()) {
            text.append(type.type.toString());
            text.append("\n");
            for (MediaType alias : type.aliases) {
                text.append("  alias:     ").append(alias).append("\n");
            }
            if (type.supertype != null) {
                text.append("  supertype: ").append(type.supertype.toString()).append("\n");
            }
            if (type.parser == null) continue;
            text.append("  parser:    ").append(type.parser).append("\n");
        }
        return text.toString();
    }

    protected List<MediaTypeDetails> getMediaTypes() {
        MediaTypeRegistry registry = TikaResource.getConfig().getMediaTypeRegistry();
        Map<MediaType, Parser> parsers = ((CompositeParser)TikaResource.getConfig().getParser()).getParsers();
        ArrayList<MediaTypeDetails> types = new ArrayList<MediaTypeDetails>(registry.getTypes().size());
        for (MediaType type : registry.getTypes()) {
            Parser p;
            MediaTypeDetails details = new MediaTypeDetails();
            details.type = type;
            MediaTypeDetails.access$102(details, registry.getAliases(type).toArray(new MediaType[0]));
            MediaType supertype = registry.getSupertype(type);
            if (supertype != null && !MediaType.OCTET_STREAM.equals(supertype)) {
                details.supertype = supertype;
            }
            if ((p = parsers.get(type)) != null) {
                if (p instanceof CompositeParser) {
                    p = ((CompositeParser)p).getParsers().get(type);
                }
                details.parser = p.getClass().getName();
            }
            types.add(details);
        }
        return types;
    }

    private static class MediaTypeDetails {
        private MediaType type;
        private MediaType[] aliases;
        private MediaType supertype;
        private String parser;

        private MediaTypeDetails() {
        }

        static /* synthetic */ MediaType[] access$102(MediaTypeDetails x0, MediaType[] x1) {
            x0.aliases = x1;
            return x1;
        }
    }
}

